/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.locationtech.jts.simplify.LineSegmentVisitor;
import org.locationtech.jts.simplify.TaggedLineSegment;
import org.locationtech.jts.simplify.TaggedLineString;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/simplify/LineSegmentIndex;", "", "<init>", "()V", "index", "Lorg/locationtech/jts/index/quadtree/Quadtree;", "add", "", "line", "Lorg/locationtech/jts/simplify/TaggedLineString;", "seg", "Lorg/locationtech/jts/geom/LineSegment;", "remove", "query", "", "querySeg", "kts-core"})
public final class LineSegmentIndex {
    @NotNull
    private final Quadtree index = new Quadtree();

    public final void add(@NotNull TaggedLineString line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        for (TaggedLineSegment seg : line.getSegments()) {
            this.add(seg);
        }
    }

    public final void add(@Nullable LineSegment seg) {
        LineSegment lineSegment = seg;
        Intrinsics.checkNotNull((Object)lineSegment);
        this.index.insert(new Envelope(lineSegment.p0, seg.p1), seg);
    }

    public final void remove(@NotNull LineSegment seg) {
        Intrinsics.checkNotNullParameter((Object)seg, (String)"seg");
        this.index.remove(new Envelope(seg.p0, seg.p1), seg);
    }

    @NotNull
    public final List<Object> query(@NotNull LineSegment querySeg) {
        Intrinsics.checkNotNullParameter((Object)querySeg, (String)"querySeg");
        Envelope env = new Envelope(querySeg.p0, querySeg.p1);
        LineSegmentVisitor visitor = new LineSegmentVisitor(querySeg);
        this.index.query(env, visitor);
        return visitor.getItems();
    }
}

