/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.index.VertexSequencePackedRtree;
import org.locationtech.jts.legacy.queue.PriorityQueue;
import org.locationtech.jts.simplify.LinkedRing;
import org.locationtech.jts.simplify.RingHullIndex;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 ;2\u00020\u0001:\u0002:;B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tJ\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u000bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010 J#\u0010!\u001a\u00020\u00182\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010%J \u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\t2\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015H\u0002J\u0010\u0010(\u001a\u00020\u00182\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u0010\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0016H\u0002J \u0010+\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u00162\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015H\u0002J\u001a\u0010,\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J \u0010-\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u0000H\u0002J\u0010\u00100\u001a\u00020$2\u0006\u00101\u001a\u00020\tH\u0002J\u0010\u00102\u001a\u0002032\u0006\u0010.\u001a\u00020\u001dH\u0002J \u00104\u001a\u00020\u00182\b\u00105\u001a\u0004\u0018\u00010\u001d2\u000e\u00106\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010$07J\u0006\u00108\u001a\u000209R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/locationtech/jts/simplify/RingHull;", "", "inputRing", "Lorg/locationtech/jts/geom/LinearRing;", "isOuter", "", "<init>", "(Lorg/locationtech/jts/geom/LinearRing;Z)V", "targetVertexNum", "", "targetAreaDelta", "", "vertexRing", "Lorg/locationtech/jts/simplify/LinkedRing;", "areaDelta", "value", "Lorg/locationtech/jts/index/VertexSequencePackedRtree;", "vertexIndex", "getVertexIndex", "()Lorg/locationtech/jts/index/VertexSequencePackedRtree;", "cornerQueue", "Lorg/locationtech/jts/legacy/queue/PriorityQueue;", "Lorg/locationtech/jts/simplify/RingHull$Corner;", "setMinVertexNum", "", "minVertexNum", "setMaxAreaDelta", "maxAreaDelta", "getEnvelope", "Lorg/locationtech/jts/geom/Envelope;", "getHull", "hullIndex", "Lorg/locationtech/jts/simplify/RingHullIndex;", "init", "ring", "", "Lorg/locationtech/jts/geom/Coordinate;", "([Lorg/locationtech/jts/geom/Coordinate;Z)V", "addCorner", "i", "compute", "isAtTarget", "corner", "removeCorner", "isRemovable", "hasIntersectingVertex", "cornerEnv", "hull", "getCoordinate", "index", "query", "", "queryHull", "queryEnv", "pts", "", "toGeometry", "Lorg/locationtech/jts/geom/Polygon;", "Corner", "Companion", "kts-core"})
public final class RingHull {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LinearRing inputRing;
    private int targetVertexNum;
    private double targetAreaDelta;
    @Nullable
    private LinkedRing vertexRing;
    private double areaDelta;
    @Nullable
    private VertexSequencePackedRtree vertexIndex;
    @Nullable
    private PriorityQueue<Corner> cornerQueue;

    public RingHull(@NotNull LinearRing inputRing, boolean isOuter) {
        Intrinsics.checkNotNullParameter((Object)inputRing, (String)"inputRing");
        this.inputRing = inputRing;
        this.targetVertexNum = -1;
        this.targetAreaDelta = -1.0;
        this.init(this.inputRing.getCoordinates(), isOuter);
    }

    @Nullable
    public final VertexSequencePackedRtree getVertexIndex() {
        return this.vertexIndex;
    }

    public final void setMinVertexNum(int minVertexNum) {
        this.targetVertexNum = minVertexNum;
    }

    public final void setMaxAreaDelta(double maxAreaDelta) {
        this.targetAreaDelta = maxAreaDelta;
    }

    @NotNull
    public final Envelope getEnvelope() {
        return this.inputRing.getEnvelopeInternal();
    }

    @NotNull
    public final LinearRing getHull(@Nullable RingHullIndex hullIndex) {
        this.compute(hullIndex);
        LinkedRing linkedRing = this.vertexRing;
        Intrinsics.checkNotNull((Object)linkedRing);
        Coordinate[] hullPts = linkedRing.getCoordinates();
        return this.inputRing.getFactory().createLinearRing(hullPts);
    }

    private final void init(Coordinate[] ring, boolean isOuter) {
        Coordinate[] ring2 = ring;
        if (isOuter == Orientation.isCCW(ring2)) {
            Coordinate[] coordinateArray = Arrays.copyOf(ring2, ring2.length);
            Intrinsics.checkNotNullExpressionValue((Object)coordinateArray, (String)"copyOf(...)");
            ring2 = coordinateArray;
            CoordinateArrays.reverse(ring2);
        }
        this.vertexRing = new LinkedRing(ring2);
        VertexSequencePackedRtree vertexSequencePackedRtree = this.vertexIndex = new VertexSequencePackedRtree(ring2);
        Intrinsics.checkNotNull((Object)vertexSequencePackedRtree);
        vertexSequencePackedRtree.remove(ring2.length - 1);
        this.cornerQueue = new PriorityQueue(0, null, 3, null);
        LinkedRing linkedRing = this.vertexRing;
        Intrinsics.checkNotNull((Object)linkedRing);
        int n = linkedRing.size();
        for (int i = 0; i < n; ++i) {
            this.addCorner(i, this.cornerQueue);
        }
    }

    private final void addCorner(int i, PriorityQueue<Corner> cornerQueue) {
        if (Companion.isConvex(this.vertexRing, i)) {
            return;
        }
        LinkedRing linkedRing = this.vertexRing;
        Intrinsics.checkNotNull((Object)linkedRing);
        int n = linkedRing.prev(i);
        LinkedRing linkedRing2 = this.vertexRing;
        Intrinsics.checkNotNull((Object)linkedRing2);
        Corner corner = new Corner(i, n, linkedRing2.next(i), Companion.area(this.vertexRing, i));
        PriorityQueue<Corner> priorityQueue = cornerQueue;
        Intrinsics.checkNotNull(priorityQueue);
        priorityQueue.add(corner);
    }

    public final void compute(@Nullable RingHullIndex hullIndex) {
        while (true) {
            PriorityQueue<Corner> priorityQueue = this.cornerQueue;
            Intrinsics.checkNotNull(priorityQueue);
            if (priorityQueue.isEmpty()) break;
            LinkedRing linkedRing = this.vertexRing;
            Intrinsics.checkNotNull((Object)linkedRing);
            if (linkedRing.size() <= 3) break;
            PriorityQueue<Corner> priorityQueue2 = this.cornerQueue;
            Intrinsics.checkNotNull(priorityQueue2);
            Object object = priorityQueue2.poll();
            Intrinsics.checkNotNull((Object)object);
            Corner corner = (Corner)object;
            if (corner.isRemoved(this.vertexRing)) continue;
            if (this.isAtTarget(corner)) {
                return;
            }
            if (!this.isRemovable(corner, hullIndex)) continue;
            this.removeCorner(corner, this.cornerQueue);
        }
    }

    private final boolean isAtTarget(Corner corner) {
        if (this.targetVertexNum >= 0) {
            LinkedRing linkedRing = this.vertexRing;
            Intrinsics.checkNotNull((Object)linkedRing);
            return linkedRing.size() < this.targetVertexNum;
        }
        return this.targetAreaDelta >= 0.0 ? this.areaDelta + corner.getArea() > this.targetAreaDelta : true;
    }

    private final void removeCorner(Corner corner, PriorityQueue<Corner> cornerQueue) {
        int index = corner.getIndex();
        LinkedRing linkedRing = this.vertexRing;
        Intrinsics.checkNotNull((Object)linkedRing);
        int prev = linkedRing.prev(index);
        LinkedRing linkedRing2 = this.vertexRing;
        Intrinsics.checkNotNull((Object)linkedRing2);
        int next = linkedRing2.next(index);
        LinkedRing linkedRing3 = this.vertexRing;
        Intrinsics.checkNotNull((Object)linkedRing3);
        linkedRing3.remove(index);
        VertexSequencePackedRtree vertexSequencePackedRtree = this.vertexIndex;
        Intrinsics.checkNotNull((Object)vertexSequencePackedRtree);
        vertexSequencePackedRtree.remove(index);
        this.areaDelta += corner.getArea();
        this.addCorner(prev, cornerQueue);
        this.addCorner(next, cornerQueue);
    }

    private final boolean isRemovable(Corner corner, RingHullIndex hullIndex) {
        Envelope cornerEnv = corner.envelope(this.vertexRing);
        if (this.hasIntersectingVertex(corner, cornerEnv, this)) {
            return false;
        }
        if (hullIndex == null) {
            return true;
        }
        for (RingHull hull : hullIndex.query(cornerEnv)) {
            if (hull == this || !this.hasIntersectingVertex(corner, cornerEnv, hull)) continue;
            return false;
        }
        return true;
    }

    private final boolean hasIntersectingVertex(Corner corner, Envelope cornerEnv, RingHull hull) {
        for (int index : hull.query(cornerEnv)) {
            Coordinate v;
            if (hull == this && corner.isVertex(index) || !corner.intersects(v = hull.getCoordinate(index), this.vertexRing)) continue;
            return true;
        }
        return false;
    }

    private final Coordinate getCoordinate(int index) {
        LinkedRing linkedRing = this.vertexRing;
        Intrinsics.checkNotNull((Object)linkedRing);
        return linkedRing.getCoordinate(index);
    }

    private final int[] query(Envelope cornerEnv) {
        VertexSequencePackedRtree vertexSequencePackedRtree = this.vertexIndex;
        Intrinsics.checkNotNull((Object)vertexSequencePackedRtree);
        return vertexSequencePackedRtree.query(cornerEnv);
    }

    public final void queryHull(@Nullable Envelope queryEnv, @NotNull List<Coordinate> pts) {
        Intrinsics.checkNotNullParameter(pts, (String)"pts");
        VertexSequencePackedRtree vertexSequencePackedRtree = this.vertexIndex;
        Intrinsics.checkNotNull((Object)vertexSequencePackedRtree);
        Envelope envelope = queryEnv;
        Intrinsics.checkNotNull((Object)envelope);
        for (int index : vertexSequencePackedRtree.query(envelope)) {
            LinkedRing linkedRing = this.vertexRing;
            Intrinsics.checkNotNull((Object)linkedRing);
            if (!linkedRing.hasCoordinate(index)) continue;
            LinkedRing linkedRing2 = this.vertexRing;
            Intrinsics.checkNotNull((Object)linkedRing2);
            Coordinate v = linkedRing2.getCoordinate(index);
            pts.add(v);
        }
    }

    @NotNull
    public final Polygon toGeometry() {
        GeometryFactory fact = new GeometryFactory();
        LinkedRing linkedRing = this.vertexRing;
        Intrinsics.checkNotNull((Object)linkedRing);
        Coordinate[] coords = linkedRing.getCoordinates();
        return GeometryFactory.createPolygon$default(fact, fact.createLinearRing(coords), null, 2, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Lorg/locationtech/jts/simplify/RingHull$Companion;", "", "<init>", "()V", "isConvex", "", "vertexRing", "Lorg/locationtech/jts/simplify/LinkedRing;", "index", "", "area", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isConvex(@Nullable LinkedRing vertexRing, int index) {
            LinkedRing linkedRing = vertexRing;
            Intrinsics.checkNotNull((Object)linkedRing);
            Coordinate pp = linkedRing.prevCoordinate(index);
            Coordinate p = vertexRing.getCoordinate(index);
            Coordinate pn = vertexRing.nextCoordinate(index);
            return -1 == Orientation.index(pp, p, pn);
        }

        public final double area(@Nullable LinkedRing vertexRing, int index) {
            LinkedRing linkedRing = vertexRing;
            Intrinsics.checkNotNull((Object)linkedRing);
            Coordinate pp = linkedRing.prevCoordinate(index);
            Coordinate p = vertexRing.getCoordinate(index);
            Coordinate pn = vertexRing.nextCoordinate(index);
            return Triangle.Companion.area(pp, p, pn);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u001c2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\u0001:\u0001\u001cB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003J\u0014\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0000H\u0096\u0082\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u001a\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0010\u0010\u0019\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lorg/locationtech/jts/simplify/RingHull$Corner;", "", "index", "", "prev", "next", "area", "", "<init>", "(IIID)V", "getIndex", "()I", "getArea", "()D", "isVertex", "", "compareTo", "o", "envelope", "Lorg/locationtech/jts/geom/Envelope;", "ring", "Lorg/locationtech/jts/simplify/LinkedRing;", "intersects", "v", "Lorg/locationtech/jts/geom/Coordinate;", "isRemoved", "toLineString", "Lorg/locationtech/jts/geom/LineString;", "Companion", "kts-core"})
    private static final class Corner
    implements Comparable<Corner> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int index;
        private final int prev;
        private final int next;
        private final double area;

        public Corner(int index, int prev, int next, double area) {
            this.index = index;
            this.prev = prev;
            this.next = next;
            this.area = area;
        }

        public final int getIndex() {
            return this.index;
        }

        public final double getArea() {
            return this.area;
        }

        public final boolean isVertex(int index) {
            return index == this.index || index == this.prev || index == this.next;
        }

        @Override
        public int compareTo(@Nullable Corner o) {
            Corner corner = o;
            Intrinsics.checkNotNull((Object)corner);
            return Double.compare(this.area, corner.area);
        }

        @NotNull
        public final Envelope envelope(@Nullable LinkedRing ring) {
            LinkedRing linkedRing = ring;
            Intrinsics.checkNotNull((Object)linkedRing);
            Coordinate pp = linkedRing.getCoordinate(this.prev);
            Coordinate p = ring.getCoordinate(this.index);
            Coordinate pn = ring.getCoordinate(this.next);
            Envelope env = new Envelope(pp, pn);
            env.expandToInclude(p);
            return env;
        }

        public final boolean intersects(@Nullable Coordinate v, @Nullable LinkedRing ring) {
            LinkedRing linkedRing = ring;
            Intrinsics.checkNotNull((Object)linkedRing);
            Coordinate pp = linkedRing.getCoordinate(this.prev);
            Coordinate p = ring.getCoordinate(this.index);
            Coordinate pn = ring.getCoordinate(this.next);
            return Triangle.Companion.intersects(pp, p, pn, v);
        }

        public final boolean isRemoved(@Nullable LinkedRing ring) {
            LinkedRing linkedRing = ring;
            Intrinsics.checkNotNull((Object)linkedRing);
            return linkedRing.prev(this.index) != this.prev || ring.next(this.index) != this.next;
        }

        @NotNull
        public final LineString toLineString(@NotNull LinkedRing ring) {
            Intrinsics.checkNotNullParameter((Object)ring, (String)"ring");
            Coordinate pp = ring.getCoordinate(this.prev);
            Coordinate p = ring.getCoordinate(this.index);
            Coordinate pn = ring.getCoordinate(this.next);
            Coordinate[] coordinateArray = new Coordinate[]{Corner.Companion.safeCoord(pp), Corner.Companion.safeCoord(p), Corner.Companion.safeCoord(pn)};
            return new GeometryFactory().createLineString(coordinateArray);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/locationtech/jts/simplify/RingHull$Corner$Companion;", "", "<init>", "()V", "safeCoord", "Lorg/locationtech/jts/geom/Coordinate;", "p", "kts-core"})
        public static final class Companion {
            private Companion() {
            }

            private final Coordinate safeCoord(Coordinate p) {
                Coordinate coordinate = p;
                if (coordinate == null) {
                    coordinate = new Coordinate(Double.NaN, Double.NaN);
                }
                return coordinate;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

