/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.simplify.TaggedLineSegment;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001a\u001a\u00020\u0005J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0012J\u0006\u0010\"\u001a\u00020\u0003J\u0006\u0010#\u001a\u00020$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000bR\u0019\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006&"}, d2={"Lorg/locationtech/jts/simplify/TaggedLineString;", "", "parent", "Lorg/locationtech/jts/geom/LineString;", "minimumSize", "", "<init>", "(Lorg/locationtech/jts/geom/LineString;I)V", "getParent", "()Lorg/locationtech/jts/geom/LineString;", "getMinimumSize", "()I", "segs", "", "Lorg/locationtech/jts/simplify/TaggedLineSegment;", "[Lorg/locationtech/jts/simplify/TaggedLineSegment;", "resultSegs", "", "Lorg/locationtech/jts/geom/LineSegment;", "resultCoordinates", "Lorg/locationtech/jts/geom/Coordinate;", "getResultCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "resultSize", "getResultSize", "getSegment", "i", "init", "", "segments", "getSegments", "()[Lorg/locationtech/jts/simplify/TaggedLineSegment;", "addToResult", "seg", "asLineString", "asLinearRing", "Lorg/locationtech/jts/geom/LinearRing;", "Companion", "kts-core"})
public final class TaggedLineString {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LineString parent;
    private final int minimumSize;
    @Nullable
    private TaggedLineSegment[] segs;
    @NotNull
    private final List<LineSegment> resultSegs;

    @JvmOverloads
    public TaggedLineString(@NotNull LineString parent, int minimumSize) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.parent = parent;
        this.minimumSize = minimumSize;
        this.resultSegs = new ArrayList();
        this.init();
    }

    public /* synthetic */ TaggedLineString(LineString lineString, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        this(lineString, n);
    }

    @NotNull
    public final LineString getParent() {
        return this.parent;
    }

    public final int getMinimumSize() {
        return this.minimumSize;
    }

    @NotNull
    public final Coordinate[] getResultCoordinates() {
        return TaggedLineString.Companion.extractCoordinates(this.resultSegs);
    }

    public final int getResultSize() {
        int resultSegsSize = this.resultSegs.size();
        return resultSegsSize == 0 ? 0 : resultSegsSize + 1;
    }

    @Nullable
    public final TaggedLineSegment getSegment(int i) {
        Intrinsics.checkNotNull((Object)this.segs);
        return this.segs[i];
    }

    private final void init() {
        Coordinate[] coordinateArray = this.parent.getCoordinates();
        Intrinsics.checkNotNull((Object)coordinateArray);
        Coordinate[] pts = coordinateArray;
        this.segs = new TaggedLineSegment[pts.length - 1];
        int n = pts.length - 1;
        for (int i = 0; i < n; ++i) {
            TaggedLineSegment seg = new TaggedLineSegment(pts[i], pts[i + 1], this.parent, i);
            Intrinsics.checkNotNull((Object)this.segs);
            this.segs[i] = seg;
        }
    }

    @NotNull
    public final TaggedLineSegment[] getSegments() {
        Intrinsics.checkNotNull((Object)this.segs);
        return this.segs;
    }

    public final void addToResult(@NotNull LineSegment seg) {
        Intrinsics.checkNotNullParameter((Object)seg, (String)"seg");
        this.resultSegs.add(seg);
    }

    @NotNull
    public final LineString asLineString() {
        return this.parent.getFactory().createLineString(TaggedLineString.Companion.extractCoordinates(this.resultSegs));
    }

    @NotNull
    public final LinearRing asLinearRing() {
        return this.parent.getFactory().createLinearRing(TaggedLineString.Companion.extractCoordinates(this.resultSegs));
    }

    @JvmOverloads
    public TaggedLineString(@NotNull LineString parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this(parent, 0, 2, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/simplify/TaggedLineString$Companion;", "", "<init>", "()V", "extractCoordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "segs", "", "Lorg/locationtech/jts/geom/LineSegment;", "(Ljava/util/List;)[Lorg/locationtech/jts/geom/Coordinate;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Coordinate[] extractCoordinates(List<LineSegment> segs) {
            Object[] pts = new Coordinate[segs.size() + 1];
            LineSegment seg = null;
            int n = ((Collection)segs).size();
            for (int i = 0; i < n; ++i) {
                LineSegment lineSegment = seg = segs.get(i);
                Intrinsics.checkNotNull((Object)lineSegment);
                pts[i] = lineSegment.p0;
            }
            int n2 = pts.length - 1;
            LineSegment lineSegment = seg;
            Intrinsics.checkNotNull((Object)lineSegment);
            pts[n2] = lineSegment.p1;
            return (Coordinate[])ArraysKt.requireNoNulls((Object[])pts);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

