/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.simplify.LineSegmentIndex;
import org.locationtech.jts.simplify.TaggedLineSegment;
import org.locationtech.jts.simplify.TaggedLineString;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\t\u0018\u0000 .2\u00020\u0001:\u0001.B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nJ \u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J3\u0010\u0019\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0016H\u0002J\"\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\n2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001fH\u0002J\u0010\u0010(\u001a\u00020#2\u0006\u0010'\u001a\u00020\u001fH\u0002J\"\u0010)\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\n2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001fH\u0002J\u0018\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\u001fH\u0002J\"\u0010-\u001a\u00020\u00122\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0016H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/locationtech/jts/simplify/TaggedLineStringSimplifier;", "", "inputIndex", "Lorg/locationtech/jts/simplify/LineSegmentIndex;", "outputIndex", "<init>", "(Lorg/locationtech/jts/simplify/LineSegmentIndex;Lorg/locationtech/jts/simplify/LineSegmentIndex;)V", "li", "Lorg/locationtech/jts/algorithm/LineIntersector;", "line", "Lorg/locationtech/jts/simplify/TaggedLineString;", "linePts", "", "Lorg/locationtech/jts/geom/Coordinate;", "[Lorg/locationtech/jts/geom/Coordinate;", "distanceTolerance", "", "setDistanceTolerance", "", "simplify", "simplifySection", "i", "", "j", "depth", "findFurthestPoint", "pts", "maxDistance", "", "([Lorg/locationtech/jts/geom/Coordinate;II[D)I", "flatten", "Lorg/locationtech/jts/geom/LineSegment;", "start", "end", "hasBadIntersection", "", "parentLine", "sectionIndex", "", "candidateSeg", "hasBadOutputIntersection", "hasBadInputIntersection", "hasInteriorIntersection", "seg0", "seg1", "remove", "Companion", "kts-core"})
public final class TaggedLineStringSimplifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LineIntersector li;
    @NotNull
    private LineSegmentIndex inputIndex;
    @NotNull
    private LineSegmentIndex outputIndex;
    @Nullable
    private TaggedLineString line;
    private Coordinate[] linePts;
    private double distanceTolerance;

    public TaggedLineStringSimplifier(@NotNull LineSegmentIndex inputIndex, @NotNull LineSegmentIndex outputIndex) {
        Intrinsics.checkNotNullParameter((Object)inputIndex, (String)"inputIndex");
        Intrinsics.checkNotNullParameter((Object)outputIndex, (String)"outputIndex");
        this.li = new RobustLineIntersector();
        this.inputIndex = new LineSegmentIndex();
        this.outputIndex = new LineSegmentIndex();
        this.inputIndex = inputIndex;
        this.outputIndex = outputIndex;
    }

    public final void setDistanceTolerance(double distanceTolerance) {
        this.distanceTolerance = distanceTolerance;
    }

    public final void simplify(@NotNull TaggedLineString line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        this.line = line;
        Coordinate[] coordinateArray = this.linePts = line.getParent().getCoordinates();
        if (this.linePts == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"linePts");
            coordinateArray = null;
        }
        this.simplifySection(0, coordinateArray.length - 1, 0);
    }

    private final void simplifySection(int i, int j, int depth) {
        int depth2 = depth;
        ++depth2;
        int[] sectionIndex = new int[2];
        if (i + 1 == j) {
            TaggedLineString taggedLineString = this.line;
            Intrinsics.checkNotNull((Object)taggedLineString);
            TaggedLineSegment taggedLineSegment = taggedLineString.getSegment(i);
            Intrinsics.checkNotNull((Object)taggedLineSegment);
            LineSegment newSeg = taggedLineSegment;
            TaggedLineString taggedLineString2 = this.line;
            Intrinsics.checkNotNull((Object)taggedLineString2);
            taggedLineString2.addToResult(newSeg);
            return;
        }
        boolean isValidToSimplify = true;
        TaggedLineString taggedLineString = this.line;
        Intrinsics.checkNotNull((Object)taggedLineString);
        int n = taggedLineString.getResultSize();
        TaggedLineString taggedLineString3 = this.line;
        Intrinsics.checkNotNull((Object)taggedLineString3);
        if (n < taggedLineString3.getMinimumSize()) {
            int worstCaseSize = depth2 + 1;
            TaggedLineString taggedLineString4 = this.line;
            Intrinsics.checkNotNull((Object)taggedLineString4);
            if (worstCaseSize < taggedLineString4.getMinimumSize()) {
                isValidToSimplify = false;
            }
        }
        double[] distance = new double[1];
        Coordinate[] coordinateArray = this.linePts;
        if (this.linePts == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"linePts");
            coordinateArray = null;
        }
        int furthestPtIndex = this.findFurthestPoint(coordinateArray, i, j, distance);
        if (distance[0] > this.distanceTolerance) {
            isValidToSimplify = false;
        }
        LineSegment candidateSeg = new LineSegment(null, null, 3, null);
        Coordinate[] coordinateArray2 = this.linePts;
        if (this.linePts == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"linePts");
            coordinateArray2 = null;
        }
        candidateSeg.p0 = coordinateArray2[i];
        Coordinate[] coordinateArray3 = this.linePts;
        if (this.linePts == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"linePts");
            coordinateArray3 = null;
        }
        candidateSeg.p1 = coordinateArray3[j];
        sectionIndex[0] = i;
        sectionIndex[1] = j;
        if (this.hasBadIntersection(this.line, sectionIndex, candidateSeg)) {
            isValidToSimplify = false;
        }
        if (isValidToSimplify) {
            LineSegment newSeg = this.flatten(i, j);
            TaggedLineString taggedLineString5 = this.line;
            Intrinsics.checkNotNull((Object)taggedLineString5);
            taggedLineString5.addToResult(newSeg);
            return;
        }
        this.simplifySection(i, furthestPtIndex, depth2);
        this.simplifySection(furthestPtIndex, j, depth2);
    }

    private final int findFurthestPoint(Coordinate[] pts, int i, int j, double[] maxDistance) {
        LineSegment seg = new LineSegment(null, null, 3, null);
        seg.p0 = pts[i];
        seg.p1 = pts[j];
        double maxDist = -1.0;
        int maxIndex = i;
        for (int k = i + 1; k < j; ++k) {
            Coordinate midPt = pts[k];
            double distance = seg.distance(midPt);
            if (!(distance > maxDist)) continue;
            maxDist = distance;
            maxIndex = k;
        }
        maxDistance[0] = maxDist;
        return maxIndex;
    }

    private final LineSegment flatten(int start, int end) {
        Coordinate[] coordinateArray = this.linePts;
        if (this.linePts == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"linePts");
            coordinateArray = null;
        }
        Coordinate p0 = coordinateArray[start];
        Coordinate[] coordinateArray2 = this.linePts;
        if (this.linePts == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"linePts");
            coordinateArray2 = null;
        }
        Coordinate p1 = coordinateArray2[end];
        LineSegment newSeg = new LineSegment(p0, p1);
        this.remove(this.line, start, end);
        this.outputIndex.add(newSeg);
        return newSeg;
    }

    private final boolean hasBadIntersection(TaggedLineString parentLine, int[] sectionIndex, LineSegment candidateSeg) {
        if (this.hasBadOutputIntersection(candidateSeg)) {
            return true;
        }
        return this.hasBadInputIntersection(parentLine, sectionIndex, candidateSeg);
    }

    private final boolean hasBadOutputIntersection(LineSegment candidateSeg) {
        List<Object> querySegs = this.outputIndex.query(candidateSeg);
        for (Object object : querySegs) {
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineSegment");
            LineSegment querySeg = (LineSegment)object;
            if (!this.hasInteriorIntersection(querySeg, candidateSeg)) continue;
            return true;
        }
        return false;
    }

    private final boolean hasBadInputIntersection(TaggedLineString parentLine, int[] sectionIndex, LineSegment candidateSeg) {
        List<Object> querySegs = this.inputIndex.query(candidateSeg);
        for (Object object : querySegs) {
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.simplify.TaggedLineSegment");
            TaggedLineSegment querySeg = (TaggedLineSegment)object;
            if (!this.hasInteriorIntersection(querySeg, candidateSeg) || TaggedLineStringSimplifier.Companion.isInLineSection(parentLine, sectionIndex, querySeg)) continue;
            return true;
        }
        return false;
    }

    private final boolean hasInteriorIntersection(LineSegment seg0, LineSegment seg1) {
        this.li.computeIntersection(seg0.p0, seg0.p1, seg1.p0, seg1.p1);
        return this.li.isInteriorIntersection();
    }

    private final void remove(TaggedLineString line, int start, int end) {
        for (int i = start; i < end; ++i) {
            TaggedLineSegment seg;
            TaggedLineString taggedLineString = line;
            Intrinsics.checkNotNull((Object)taggedLineString);
            Intrinsics.checkNotNull((Object)taggedLineString.getSegment(i));
            this.inputIndex.remove(seg);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/locationtech/jts/simplify/TaggedLineStringSimplifier$Companion;", "", "<init>", "()V", "isInLineSection", "", "line", "Lorg/locationtech/jts/simplify/TaggedLineString;", "sectionIndex", "", "seg", "Lorg/locationtech/jts/simplify/TaggedLineSegment;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isInLineSection(TaggedLineString line, int[] sectionIndex, TaggedLineSegment seg) {
            Geometry geometry = seg.getParent();
            TaggedLineString taggedLineString = line;
            Intrinsics.checkNotNull((Object)taggedLineString);
            if (geometry != taggedLineString.getParent()) {
                return false;
            }
            int segIndex = seg.getIndex();
            return segIndex >= sectionIndex[0] && segIndex < sectionIndex[1];
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

