/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.util.GeometryTransformer;
import org.locationtech.jts.simplify.TaggedLineString;
import org.locationtech.jts.simplify.TaggedLinesSimplifier;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0003\u0013\u0014\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/locationtech/jts/simplify/TopologyPreservingSimplifier;", "", "inputGeom", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "lineSimplifier", "Lorg/locationtech/jts/simplify/TaggedLinesSimplifier;", "linestringMap", "", "Lorg/locationtech/jts/geom/LineString;", "Lorg/locationtech/jts/simplify/TaggedLineString;", "setDistanceTolerance", "", "distanceTolerance", "", "resultGeometry", "getResultGeometry", "()Lorg/locationtech/jts/geom/Geometry;", "LineStringTransformer", "LineStringMapBuilderFilter", "Companion", "kts-core"})
public final class TopologyPreservingSimplifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry inputGeom;
    @NotNull
    private final TaggedLinesSimplifier lineSimplifier;
    @Nullable
    private Map<LineString, TaggedLineString> linestringMap;

    public TopologyPreservingSimplifier(@NotNull Geometry inputGeom) {
        Intrinsics.checkNotNullParameter((Object)inputGeom, (String)"inputGeom");
        this.inputGeom = inputGeom;
        this.lineSimplifier = new TaggedLinesSimplifier();
    }

    public final void setDistanceTolerance(double distanceTolerance) {
        if (distanceTolerance < 0.0) {
            throw new IllegalArgumentException("Tolerance must be non-negative");
        }
        this.lineSimplifier.setDistanceTolerance(distanceTolerance);
    }

    @NotNull
    public final Geometry getResultGeometry() {
        if (this.inputGeom.isEmpty()) {
            return this.inputGeom.copy();
        }
        this.linestringMap = new HashMap();
        this.inputGeom.apply(new LineStringMapBuilderFilter(this));
        Map<LineString, TaggedLineString> map = this.linestringMap;
        Intrinsics.checkNotNull(map);
        this.lineSimplifier.simplify(map.values());
        return new LineStringTransformer(this.linestringMap).transform(this.inputGeom);
    }

    @JvmStatic
    @NotNull
    public static final Geometry simplify(@NotNull Geometry geom, double distanceTolerance) {
        return Companion.simplify(geom, distanceTolerance);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/simplify/TopologyPreservingSimplifier$Companion;", "", "<init>", "()V", "simplify", "Lorg/locationtech/jts/geom/Geometry;", "geom", "distanceTolerance", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Geometry simplify(@NotNull Geometry geom, double distanceTolerance) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            TopologyPreservingSimplifier tss = new TopologyPreservingSimplifier(geom);
            tss.setDistanceTolerance(distanceTolerance);
            return tss.getResultGeometry();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\r"}, d2={"Lorg/locationtech/jts/simplify/TopologyPreservingSimplifier$LineStringMapBuilderFilter;", "Lorg/locationtech/jts/geom/GeometryComponentFilter;", "tps", "Lorg/locationtech/jts/simplify/TopologyPreservingSimplifier;", "<init>", "(Lorg/locationtech/jts/simplify/TopologyPreservingSimplifier;)V", "getTps", "()Lorg/locationtech/jts/simplify/TopologyPreservingSimplifier;", "setTps", "filter", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "kts-core"})
    public static final class LineStringMapBuilderFilter
    implements GeometryComponentFilter {
        @NotNull
        private TopologyPreservingSimplifier tps;

        public LineStringMapBuilderFilter(@NotNull TopologyPreservingSimplifier tps) {
            Intrinsics.checkNotNullParameter((Object)tps, (String)"tps");
            this.tps = tps;
        }

        @NotNull
        public final TopologyPreservingSimplifier getTps() {
            return this.tps;
        }

        public final void setTps(@NotNull TopologyPreservingSimplifier topologyPreservingSimplifier) {
            Intrinsics.checkNotNullParameter((Object)topologyPreservingSimplifier, (String)"<set-?>");
            this.tps = topologyPreservingSimplifier;
        }

        @Override
        public void filter(@NotNull Geometry geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            if (geom instanceof LineString) {
                LineString line = (LineString)geom;
                if (line.isEmpty()) {
                    return;
                }
                int minSize = line.isClosed() ? 4 : 2;
                TaggedLineString taggedLine = new TaggedLineString(line, minSize);
                Map map = this.tps.linestringMap;
                Intrinsics.checkNotNull((Object)map);
                map.put(line, taggedLine);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0010\u0010\u0002\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014R\u0018\u0010\u0002\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/simplify/TopologyPreservingSimplifier$LineStringTransformer;", "Lorg/locationtech/jts/geom/util/GeometryTransformer;", "linestringMap", "", "<init>", "(Ljava/util/Map;)V", "transformCoordinates", "Lorg/locationtech/jts/geom/CoordinateSequence;", "coords", "parent", "Lorg/locationtech/jts/geom/Geometry;", "kts-core"})
    public static final class LineStringTransformer
    extends GeometryTransformer {
        @Nullable
        private final Map<?, ?> linestringMap;

        public LineStringTransformer(@Nullable Map<?, ?> linestringMap) {
            this.linestringMap = linestringMap;
        }

        @Override
        @Nullable
        protected CoordinateSequence transformCoordinates(@Nullable CoordinateSequence coords, @Nullable Geometry parent) {
            CoordinateSequence coordinateSequence = coords;
            Intrinsics.checkNotNull((Object)coordinateSequence);
            if (coordinateSequence.size() == 0) {
                return null;
            }
            if (parent instanceof LineString) {
                TaggedLineString taggedLine;
                Map<?, ?> map = this.linestringMap;
                Intrinsics.checkNotNull(map);
                TaggedLineString taggedLineString = taggedLine = (TaggedLineString)map.get(parent);
                Intrinsics.checkNotNull((Object)taggedLineString);
                return this.createCoordinateSequence(taggedLineString.getResultCoordinates());
            }
            return super.transformCoordinates(coords, parent);
        }
    }
}

