/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0002\u0010\u0011B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/locationtech/jts/simplify/VWLineSimplifier;", "", "pts", "", "Lorg/locationtech/jts/geom/Coordinate;", "distanceTolerance", "", "<init>", "([Lorg/locationtech/jts/geom/Coordinate;D)V", "[Lorg/locationtech/jts/geom/Coordinate;", "tolerance", "simplify", "()[Lorg/locationtech/jts/geom/Coordinate;", "simplifyVertex", "vwLine", "Lorg/locationtech/jts/simplify/VWLineSimplifier$VWVertex;", "VWVertex", "Companion", "kts-core"})
public final class VWLineSimplifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Coordinate[] pts;
    private final double tolerance;

    public VWLineSimplifier(@NotNull Coordinate[] pts, double distanceTolerance) {
        Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
        this.pts = pts;
        this.tolerance = distanceTolerance * distanceTolerance;
    }

    @NotNull
    public final Coordinate[] simplify() {
        Coordinate[] coordinateArray;
        VWVertex vwLine = VWVertex.Companion.buildLine(this.pts);
        double minArea = this.tolerance;
        while ((minArea = this.simplifyVertex(vwLine)) < this.tolerance) {
        }
        VWVertex vWVertex = vwLine;
        Intrinsics.checkNotNull((Object)vWVertex);
        Coordinate[] simp = vWVertex.getCoordinates();
        if (simp.length < 2) {
            Coordinate[] coordinateArray2 = new Coordinate[]{simp[0], new Coordinate(simp[0])};
            coordinateArray = coordinateArray2;
        } else {
            coordinateArray = simp;
        }
        return coordinateArray;
    }

    private final double simplifyVertex(VWVertex vwLine) {
        VWVertex curr;
        VWVertex vWVertex = curr = vwLine;
        Intrinsics.checkNotNull((Object)vWVertex);
        double minArea = vWVertex.getArea();
        VWVertex minVertex = null;
        while (curr != null) {
            double area = curr.getArea();
            if (area < minArea) {
                minArea = area;
                minVertex = curr;
            }
            curr = curr.getNext();
        }
        if (minVertex != null && minArea < this.tolerance) {
            minVertex.remove();
        }
        VWVertex vWVertex2 = vwLine;
        Intrinsics.checkNotNull((Object)vWVertex2);
        return !vWVertex2.isLive() ? -1.0 : minArea;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/simplify/VWLineSimplifier$Companion;", "", "<init>", "()V", "simplify", "", "Lorg/locationtech/jts/geom/Coordinate;", "pts", "distanceTolerance", "", "([Lorg/locationtech/jts/geom/Coordinate;D)[Lorg/locationtech/jts/geom/Coordinate;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Coordinate[] simplify(@NotNull Coordinate[] pts, double distanceTolerance) {
            Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
            VWLineSimplifier simp = new VWLineSimplifier(pts, distanceTolerance);
            return simp.simplify();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00152\b\u0010\u0006\u001a\u0004\u0018\u00010\u0000J\u0006\u0010\u0016\u001a\u00020\u0015J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lorg/locationtech/jts/simplify/VWLineSimplifier$VWVertex;", "", "pt", "Lorg/locationtech/jts/geom/Coordinate;", "<init>", "(Lorg/locationtech/jts/geom/Coordinate;)V", "prev", "next", "getNext", "()Lorg/locationtech/jts/simplify/VWLineSimplifier$VWVertex;", "setNext", "(Lorg/locationtech/jts/simplify/VWLineSimplifier$VWVertex;)V", "value", "", "area", "getArea", "()D", "", "isLive", "()Z", "setPrev", "", "updateArea", "remove", "coordinates", "", "getCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "Companion", "kts-core"})
    public static final class VWVertex {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Coordinate pt;
        @Nullable
        private VWVertex prev;
        @Nullable
        private VWVertex next;
        private double area;
        private boolean isLive;
        private static double MAX_AREA = Double.MAX_VALUE;

        public VWVertex(@NotNull Coordinate pt) {
            Intrinsics.checkNotNullParameter((Object)pt, (String)"pt");
            this.pt = pt;
            this.area = MAX_AREA;
            this.isLive = true;
        }

        @Nullable
        public final VWVertex getNext() {
            return this.next;
        }

        public final void setNext(@Nullable VWVertex vWVertex) {
            this.next = vWVertex;
        }

        public final double getArea() {
            return this.area;
        }

        public final boolean isLive() {
            return this.isLive;
        }

        public final void setPrev(@Nullable VWVertex prev) {
            this.prev = prev;
        }

        public final void updateArea() {
            if (this.prev == null || this.next == null) {
                this.area = MAX_AREA;
                return;
            }
            VWVertex vWVertex = this.prev;
            Intrinsics.checkNotNull((Object)vWVertex);
            Coordinate coordinate = vWVertex.pt;
            VWVertex vWVertex2 = this.next;
            Intrinsics.checkNotNull((Object)vWVertex2);
            this.area = Math.INSTANCE.abs(Triangle.Companion.area(coordinate, this.pt, vWVertex2.pt));
        }

        @Nullable
        public final VWVertex remove() {
            VWVertex tmpPrev = this.prev;
            VWVertex tmpNext = this.next;
            VWVertex result2 = null;
            if (this.prev != null) {
                Intrinsics.checkNotNull((Object)this.prev);
                this.prev.next = tmpNext;
                VWVertex vWVertex = this.prev;
                Intrinsics.checkNotNull((Object)vWVertex);
                vWVertex.updateArea();
                result2 = this.prev;
            }
            if (this.next != null) {
                VWVertex vWVertex = this.next;
                Intrinsics.checkNotNull((Object)vWVertex);
                vWVertex.setPrev(tmpPrev);
                VWVertex vWVertex2 = this.next;
                Intrinsics.checkNotNull((Object)vWVertex2);
                vWVertex2.updateArea();
                if (result2 == null) {
                    result2 = this.next;
                }
            }
            this.isLive = false;
            return result2;
        }

        @NotNull
        public final Coordinate[] getCoordinates() {
            CoordinateList coords = new CoordinateList();
            VWVertex curr = this;
            do {
                VWVertex vWVertex = curr;
                Intrinsics.checkNotNull((Object)vWVertex);
                coords.add(vWVertex.pt, false);
            } while ((curr = curr.next) != null);
            return coords.toCoordinateArray();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/simplify/VWLineSimplifier$VWVertex$Companion;", "", "<init>", "()V", "buildLine", "Lorg/locationtech/jts/simplify/VWLineSimplifier$VWVertex;", "pts", "", "Lorg/locationtech/jts/geom/Coordinate;", "([Lorg/locationtech/jts/geom/Coordinate;)Lorg/locationtech/jts/simplify/VWLineSimplifier$VWVertex;", "MAX_AREA", "", "getMAX_AREA", "()D", "setMAX_AREA", "(D)V", "kts-core"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final VWVertex buildLine(@NotNull Coordinate[] pts) {
                Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
                VWVertex first = null;
                VWVertex prev = null;
                int n = pts.length;
                for (int i = 0; i < n; ++i) {
                    VWVertex v = new VWVertex(pts[i]);
                    if (first == null) {
                        first = v;
                    }
                    v.setPrev(prev);
                    if (prev != null) {
                        prev.setNext(v);
                        prev.updateArea();
                    }
                    prev = v;
                }
                return first;
            }

            public final double getMAX_AREA() {
                return MAX_AREA;
            }

            public final void setMAX_AREA(double d) {
                MAX_AREA = d;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

