/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.ConvexHull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.index.kdtree.KdNode;
import org.locationtech.jts.index.kdtree.KdTree;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.triangulate.ConstraintSplitPointFinder;
import org.locationtech.jts.triangulate.ConstraintVertex;
import org.locationtech.jts.triangulate.ConstraintVertexFactory;
import org.locationtech.jts.triangulate.IncrementalDelaunayTriangulator;
import org.locationtech.jts.triangulate.NonEncroachingSplitPointFinder;
import org.locationtech.jts.triangulate.Segment;
import org.locationtech.jts.triangulate.quadedge.LastFoundQuadEdgeLocator;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.quadedge.Vertex;
import org.locationtech.jts.util.Debug;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0003\u0018\u0000 G2\u00020\u0001:\u0001GB\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ$\u0010(\u001a\u00020)2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\tJ\u000e\u0010*\u001a\u00020)2\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010+\u001a\u0004\u0018\u00010!J\u0010\u0010,\u001a\u00020)2\b\u0010 \u001a\u0004\u0018\u00010!J\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00040\tJ\b\u00101\u001a\u00020)H\u0002J\b\u00102\u001a\u00020)H\u0002J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020%H\u0002J\u001a\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010%2\u0006\u0010:\u001a\u00020\fH\u0002J\u0016\u0010;\u001a\u00020)2\f\u0010<\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003H\u0002J\u0010\u0010=\u001a\u0002082\u0006\u0010>\u001a\u000208H\u0002J\u000e\u0010=\u001a\u00020)2\u0006\u00109\u001a\u00020%J\u0006\u0010?\u001a\u00020)J\u0006\u0010@\u001a\u00020)J\b\u0010A\u001a\u00020)H\u0002J\u0016\u0010B\u001a\u00020C2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\f0EH\u0002J\u0012\u0010F\u001a\u0004\u0018\u00010%2\u0006\u0010:\u001a\u00020\fH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0015\u0010.\u001a\u0006\u0012\u0002\b\u00030\u00038F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0017\u00103\u001a\b\u0012\u0004\u0012\u00020%048F\u00a2\u0006\u0006\u001a\u0004\b5\u00106\u00a8\u0006H"}, d2={"Lorg/locationtech/jts/triangulate/ConformingDelaunayTriangulator;", "", "initialVertices", "", "Lorg/locationtech/jts/triangulate/quadedge/Vertex;", "tolerance", "", "<init>", "(Ljava/util/Collection;D)V", "", "segVertices", "segments", "Lorg/locationtech/jts/triangulate/Segment;", "value", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeSubdivision;", "subdivision", "getSubdivision", "()Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeSubdivision;", "incDel", "Lorg/locationtech/jts/triangulate/IncrementalDelaunayTriangulator;", "Lorg/locationtech/jts/geom/Geometry;", "convexHull", "getConvexHull", "()Lorg/locationtech/jts/geom/Geometry;", "splitFinder", "Lorg/locationtech/jts/triangulate/ConstraintSplitPointFinder;", "kDT", "Lorg/locationtech/jts/index/kdtree/KdTree;", "getKDT", "()Lorg/locationtech/jts/index/kdtree/KdTree;", "setKDT", "(Lorg/locationtech/jts/index/kdtree/KdTree;)V", "vertexFactory", "Lorg/locationtech/jts/triangulate/ConstraintVertexFactory;", "computeAreaEnv", "Lorg/locationtech/jts/geom/Envelope;", "splitPt", "Lorg/locationtech/jts/geom/Coordinate;", "getTolerance", "()D", "setConstraints", "", "setSplitPointFinder", "getVertexFactory", "setVertexFactory", "getInitialVertices", "constraintSegments", "getConstraintSegments", "()Ljava/util/Collection;", "computeBoundingBox", "computeConvexHull", "pointArray", "", "getPointArray", "()[Lorg/locationtech/jts/geom/Coordinate;", "createVertex", "Lorg/locationtech/jts/triangulate/ConstraintVertex;", "p", "seg", "insertSites", "vertices", "insertSite", "v", "formInitialDelaunay", "enforceConstraints", "addConstraintVertices", "enforceGabriel", "", "segsToInsert", "", "findNonGabrielPoint", "Companion", "kts-core"})
public final class ConformingDelaunayTriangulator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Vertex> initialVertices;
    @Nullable
    private List<Vertex> segVertices;
    @NotNull
    private List<Segment> segments;
    @Nullable
    private QuadEdgeSubdivision subdivision;
    @Nullable
    private IncrementalDelaunayTriangulator incDel;
    @Nullable
    private Geometry convexHull;
    @NotNull
    private ConstraintSplitPointFinder splitFinder;
    @Nullable
    private KdTree kDT;
    @Nullable
    private ConstraintVertexFactory vertexFactory;
    @Nullable
    private Envelope computeAreaEnv;
    @Nullable
    private Coordinate splitPt;
    private final double tolerance;
    private static final int MAX_SPLIT_ITER = 99;

    public ConformingDelaunayTriangulator(@NotNull Collection<? extends Vertex> initialVertices, double tolerance) {
        Intrinsics.checkNotNullParameter(initialVertices, (String)"initialVertices");
        this.segments = new ArrayList();
        this.splitFinder = new NonEncroachingSplitPointFinder();
        this.initialVertices = new ArrayList<Vertex>(initialVertices);
        this.tolerance = tolerance;
        this.kDT = new KdTree(tolerance);
    }

    @Nullable
    public final QuadEdgeSubdivision getSubdivision() {
        return this.subdivision;
    }

    @Nullable
    public final Geometry getConvexHull() {
        return this.convexHull;
    }

    @Nullable
    public final KdTree getKDT() {
        return this.kDT;
    }

    public final void setKDT(@Nullable KdTree kdTree) {
        this.kDT = kdTree;
    }

    public final double getTolerance() {
        return this.tolerance;
    }

    public final void setConstraints(@NotNull List<Segment> segments, @Nullable List<Vertex> segVertices) {
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        this.segments = segments;
        this.segVertices = segVertices;
    }

    public final void setSplitPointFinder(@NotNull ConstraintSplitPointFinder splitFinder) {
        Intrinsics.checkNotNullParameter((Object)splitFinder, (String)"splitFinder");
        this.splitFinder = splitFinder;
    }

    @Nullable
    public final ConstraintVertexFactory getVertexFactory() {
        return this.vertexFactory;
    }

    public final void setVertexFactory(@Nullable ConstraintVertexFactory vertexFactory) {
        this.vertexFactory = vertexFactory;
    }

    @NotNull
    public final List<Vertex> getInitialVertices() {
        return this.initialVertices;
    }

    @NotNull
    public final Collection<?> getConstraintSegments() {
        return this.segments;
    }

    private final void computeBoundingBox() {
        Envelope vertexEnv = ConformingDelaunayTriangulator.Companion.computeVertexEnvelope(this.initialVertices);
        Envelope segEnv = ConformingDelaunayTriangulator.Companion.computeVertexEnvelope(this.segVertices);
        Envelope allPointsEnv = new Envelope(vertexEnv);
        allPointsEnv.expandToInclude(segEnv);
        double deltaX = allPointsEnv.getWidth() * 0.2;
        double deltaY = allPointsEnv.getHeight() * 0.2;
        double delta = Math.INSTANCE.max(deltaX, deltaY);
        Envelope envelope = this.computeAreaEnv = new Envelope(allPointsEnv);
        Intrinsics.checkNotNull((Object)envelope);
        envelope.expandBy(delta);
    }

    private final void computeConvexHull() {
        GeometryFactory fact = new GeometryFactory();
        Coordinate[] coords = this.getPointArray();
        ConvexHull hull = new ConvexHull(coords, fact);
        this.convexHull = hull.getConvexHull();
    }

    @NotNull
    public final Coordinate[] getPointArray() {
        int n = this.initialVertices.size();
        List<Vertex> list = this.segVertices;
        Intrinsics.checkNotNull(list);
        Object[] pts = new Coordinate[n + list.size()];
        int index = 0;
        Iterator<Vertex> i = this.initialVertices.iterator();
        while (i.hasNext()) {
            Vertex v;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.triangulate.quadedge.Vertex");
            pts[index++] = v.getCoordinate();
        }
        List<Vertex> list2 = this.segVertices;
        Intrinsics.checkNotNull(list2);
        Iterator<Vertex> i2 = list2.iterator();
        while (i2.hasNext()) {
            Vertex v;
            Intrinsics.checkNotNull((Object)i2.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.triangulate.quadedge.Vertex");
            pts[index++] = v.getCoordinate();
        }
        return (Coordinate[])ArraysKt.requireNoNulls((Object[])pts);
    }

    private final ConstraintVertex createVertex(Coordinate p) {
        ConstraintVertex v = null;
        if (this.vertexFactory != null) {
            ConstraintVertexFactory constraintVertexFactory = this.vertexFactory;
            Intrinsics.checkNotNull((Object)constraintVertexFactory);
            v = constraintVertexFactory.createVertex(p, null);
        } else {
            v = new ConstraintVertex(p);
        }
        ConstraintVertex constraintVertex = v;
        Intrinsics.checkNotNull((Object)constraintVertex);
        return constraintVertex;
    }

    private final ConstraintVertex createVertex(Coordinate p, Segment seg) {
        ConstraintVertex v = null;
        if (this.vertexFactory != null) {
            ConstraintVertexFactory constraintVertexFactory = this.vertexFactory;
            Intrinsics.checkNotNull((Object)constraintVertexFactory);
            v = constraintVertexFactory.createVertex(p, seg);
        } else {
            v = new ConstraintVertex(p);
        }
        ConstraintVertex constraintVertex = v;
        Intrinsics.checkNotNull((Object)constraintVertex);
        constraintVertex.setOnConstraint(true);
        return v;
    }

    private final void insertSites(Collection<?> vertices) {
        Collection<?> collection = vertices;
        Intrinsics.checkNotNull(collection);
        for (Object obj : collection) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.triangulate.ConstraintVertex");
            ConstraintVertex v = (ConstraintVertex)obj;
            this.insertSite(v);
        }
    }

    private final ConstraintVertex insertSite(ConstraintVertex v) {
        KdTree kdTree = this.kDT;
        Intrinsics.checkNotNull((Object)kdTree);
        KdNode kdnode = kdTree.insert(v.getCoordinate(), v);
        if (kdnode.isRepeated()) {
            ConstraintVertex snappedV;
            ConstraintVertex constraintVertex = snappedV = (ConstraintVertex)kdnode.getData();
            Intrinsics.checkNotNull((Object)constraintVertex);
            constraintVertex.merge(v);
            return snappedV;
        }
        IncrementalDelaunayTriangulator incrementalDelaunayTriangulator = this.incDel;
        Intrinsics.checkNotNull((Object)incrementalDelaunayTriangulator);
        incrementalDelaunayTriangulator.insertSite(v);
        return v;
    }

    public final void insertSite(@NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this.insertSite(this.createVertex(p));
    }

    public final void formInitialDelaunay() {
        this.computeBoundingBox();
        Envelope envelope = this.computeAreaEnv;
        Intrinsics.checkNotNull((Object)envelope);
        QuadEdgeSubdivision quadEdgeSubdivision = this.subdivision = new QuadEdgeSubdivision(envelope, this.tolerance);
        Intrinsics.checkNotNull((Object)quadEdgeSubdivision);
        QuadEdgeSubdivision quadEdgeSubdivision2 = this.subdivision;
        Intrinsics.checkNotNull((Object)quadEdgeSubdivision2);
        quadEdgeSubdivision.setLocator(new LastFoundQuadEdgeLocator(quadEdgeSubdivision2));
        QuadEdgeSubdivision quadEdgeSubdivision3 = this.subdivision;
        Intrinsics.checkNotNull((Object)quadEdgeSubdivision3);
        this.incDel = new IncrementalDelaunayTriangulator(quadEdgeSubdivision3);
        this.insertSites((Collection)this.initialVertices);
    }

    public final void enforceConstraints() {
        this.addConstraintVertices();
        int count = 0;
        int splits = 0;
        while ((splits = this.enforceGabriel((Collection<Segment>)this.segments)) > 0 && ++count < 99) {
        }
        if (count == 99) {
            // empty if block
        }
    }

    private final void addConstraintVertices() {
        this.computeConvexHull();
        this.insertSites((Collection)this.segVertices);
    }

    private final int enforceGabriel(Collection<Segment> segsToInsert) {
        List newSegments = new ArrayList();
        int splits = 0;
        List segsToRemove = new ArrayList();
        Iterator<Segment> i = segsToInsert.iterator();
        while (i.hasNext()) {
            Coordinate encroachPt;
            Segment seg;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.triangulate.Segment");
            if (this.findNonGabrielPoint(seg) == null) continue;
            this.splitPt = this.splitFinder.findSplitPoint(seg, encroachPt);
            ConstraintVertex splitVertex = this.createVertex(this.splitPt, seg);
            ConstraintVertex insertedVertex = this.insertSite(splitVertex);
            Coordinate coordinate = insertedVertex.getCoordinate();
            Coordinate coordinate2 = this.splitPt;
            Intrinsics.checkNotNull((Object)coordinate2);
            if (!coordinate.equals2D(coordinate2)) {
                Debug.Companion.println("Split pt snapped to: " + insertedVertex);
            }
            Segment s1 = new Segment(seg.getStartX(), seg.getStartY(), seg.getStartZ(), splitVertex.getX(), splitVertex.getY(), splitVertex.getZ(), seg.getData());
            Segment s2 = new Segment(splitVertex.getX(), splitVertex.getY(), splitVertex.getZ(), seg.getEndX(), seg.getEndY(), seg.getEndZ(), seg.getData());
            newSegments.add(s1);
            newSegments.add(s2);
            segsToRemove.add(seg);
            ++splits;
        }
        segsToInsert.removeAll(segsToRemove);
        segsToInsert.addAll(newSegments);
        return splits;
    }

    private final Coordinate findNonGabrielPoint(Segment seg) {
        Coordinate p = seg.getStart();
        Coordinate q = seg.getEnd();
        Coordinate midPt = new Coordinate((p.x + q.x) / 2.0, (p.y + q.y) / 2.0);
        double segRadius = p.distance(midPt);
        Envelope env = new Envelope(midPt);
        env.expandBy(segRadius);
        KdTree kdTree = this.kDT;
        Intrinsics.checkNotNull((Object)kdTree);
        List<KdNode> result2 = kdTree.query(env);
        Coordinate closestNonGabriel = null;
        double minDist = Double.MAX_VALUE;
        Iterator<KdNode> i = result2.iterator();
        while (i.hasNext()) {
            double testRadius;
            KdNode nextNode;
            Coordinate testPt;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.index.kdtree.KdNode");
            Coordinate coordinate = testPt = nextNode.getCoordinate();
            Intrinsics.checkNotNull((Object)coordinate);
            if (coordinate.equals2D(p) || testPt.equals2D(q) || !((testRadius = midPt.distance(testPt)) < segRadius) || closestNonGabriel != null && !(testRadius < minDist)) continue;
            closestNonGabriel = testPt;
            minDist = testRadius;
        }
        return closestNonGabriel;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/triangulate/ConformingDelaunayTriangulator$Companion;", "", "<init>", "()V", "computeVertexEnvelope", "Lorg/locationtech/jts/geom/Envelope;", "vertices", "", "MAX_SPLIT_ITER", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Envelope computeVertexEnvelope(Collection<?> vertices) {
            Envelope env = new Envelope();
            Collection<?> collection = vertices;
            Intrinsics.checkNotNull(collection);
            for (Object obj : collection) {
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.triangulate.quadedge.Vertex");
                Vertex v = (Vertex)obj;
                env.expandToInclude(v.getCoordinate());
            }
            return env;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

