/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.quadedge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.triangulate.quadedge.QuadEdge;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.quadedge.TriangleVisitor;
import org.locationtech.jts.triangulate.quadedge.Vertex;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0007\u0018\u0000 ;2\u00020\u0001:\u0002:;B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0004J\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0019J\u0016\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$J\u0013\u0010(\u001a\u00020\u00102\b\u0010)\u001a\u0004\u0018\u00010\u001eH\u0086\u0002J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\n\u0010.\u001a\u00020/H\u0096\u0080\u0004J\u000e\u00100\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u00101\u001a\u0004\u0018\u00010\u00002\u0006\u00102\u001a\u00020\u0017J\u000e\u00103\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017J\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020\u0000052\u0006\u00106\u001a\u00020\u0017R\u0018\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0019\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0019\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u00038F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0011\u00100\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0011R\u0019\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\u00038F\u00a2\u0006\u0006\u001a\u0004\b8\u00109\u00a8\u0006<"}, d2={"Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeTriangle;", "", "edge", "", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;", "<init>", "([Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;)V", "[Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;", "data", "getData", "()Ljava/lang/Object;", "setData", "(Ljava/lang/Object;)V", "kill", "", "isLive", "", "()Z", "edges", "getEdges", "()[Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;", "getEdge", "i", "", "getVertex", "Lorg/locationtech/jts/triangulate/quadedge/Vertex;", "vertices", "getVertices", "()[Lorg/locationtech/jts/triangulate/quadedge/Vertex;", "getCoordinate", "Lorg/locationtech/jts/geom/Coordinate;", "getEdgeIndex", "e", "v", "getEdgeSegment", "seg", "Lorg/locationtech/jts/geom/LineSegment;", "coordinates", "getCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "contains", "pt", "getGeometry", "Lorg/locationtech/jts/geom/Polygon;", "fact", "Lorg/locationtech/jts/geom/GeometryFactory;", "toString", "", "isBorder", "getAdjacentTriangleAcrossEdge", "edgeIndex", "getAdjacentTriangleEdgeIndex", "getTrianglesAdjacentToVertex", "", "vertexIndex", "neighbours", "getNeighbours", "()[Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeTriangle;", "QuadEdgeTriangleBuilderVisitor", "Companion", "kts-core"})
public final class QuadEdgeTriangle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private QuadEdge[] edge;
    @Nullable
    private Object data;

    public QuadEdgeTriangle(@NotNull QuadEdge[] edge) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        QuadEdge[] quadEdgeArray = Arrays.copyOf(edge, edge.length);
        Intrinsics.checkNotNullExpressionValue((Object)quadEdgeArray, (String)"copyOf(...)");
        this.edge = quadEdgeArray;
        for (int i = 0; i < 3; ++i) {
            edge[i].setData(this);
        }
    }

    @Nullable
    public final Object getData() {
        return this.data;
    }

    public final void setData(@Nullable Object object) {
        this.data = object;
    }

    public final void kill() {
        this.edge = null;
    }

    public final boolean isLive() {
        return this.edge != null;
    }

    @Nullable
    public final QuadEdge[] getEdges() {
        return this.edge;
    }

    @NotNull
    public final QuadEdge getEdge(int i) {
        Intrinsics.checkNotNull((Object)this.edge);
        return this.edge[i];
    }

    @NotNull
    public final Vertex getVertex(int i) {
        Intrinsics.checkNotNull((Object)this.edge);
        Vertex vertex = this.edge[i].orig();
        Intrinsics.checkNotNull((Object)vertex);
        return vertex;
    }

    @NotNull
    public final Vertex[] getVertices() {
        Vertex[] vert = new Vertex[3];
        for (int i = 0; i < 3; ++i) {
            vert[i] = this.getVertex(i);
        }
        return vert;
    }

    @NotNull
    public final Coordinate getCoordinate(int i) {
        Intrinsics.checkNotNull((Object)this.edge);
        Vertex vertex = this.edge[i].orig();
        Intrinsics.checkNotNull((Object)vertex);
        return vertex.getCoordinate();
    }

    public final int getEdgeIndex(@NotNull QuadEdge e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        for (int i = 0; i < 3; ++i) {
            Intrinsics.checkNotNull((Object)this.edge);
            if (this.edge[i] != e) continue;
            return i;
        }
        return -1;
    }

    public final int getEdgeIndex(@NotNull Vertex v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        for (int i = 0; i < 3; ++i) {
            Intrinsics.checkNotNull((Object)this.edge);
            if (!Intrinsics.areEqual((Object)this.edge[i].orig(), (Object)v)) continue;
            return i;
        }
        return -1;
    }

    public final void getEdgeSegment(int i, @NotNull LineSegment seg) {
        Intrinsics.checkNotNullParameter((Object)seg, (String)"seg");
        Intrinsics.checkNotNull((Object)this.edge);
        Vertex vertex = this.edge[i].orig();
        Intrinsics.checkNotNull((Object)vertex);
        seg.p0 = vertex.getCoordinate();
        int nexti = (i + 1) % 3;
        Intrinsics.checkNotNull((Object)this.edge);
        Vertex vertex2 = this.edge[nexti].orig();
        Intrinsics.checkNotNull((Object)vertex2);
        seg.p1 = vertex2.getCoordinate();
    }

    @NotNull
    public final Coordinate[] getCoordinates() {
        Coordinate[] pts = new Coordinate[4];
        for (int i = 0; i < 3; ++i) {
            Intrinsics.checkNotNull((Object)this.edge);
            Vertex vertex = this.edge[i].orig();
            Intrinsics.checkNotNull((Object)vertex);
            pts[i] = vertex.getCoordinate();
        }
        Coordinate coordinate = pts[0];
        Intrinsics.checkNotNull((Object)coordinate);
        pts[3] = new Coordinate(coordinate);
        return pts;
    }

    public final boolean contains(@Nullable Coordinate pt) {
        Object[] ring = this.getCoordinates();
        Coordinate coordinate = pt;
        Intrinsics.checkNotNull((Object)coordinate);
        return PointLocation.isInRing(coordinate, (Coordinate[])ArraysKt.requireNoNulls((Object[])ring));
    }

    @NotNull
    public final Polygon getGeometry(@NotNull GeometryFactory fact) {
        Intrinsics.checkNotNullParameter((Object)fact, (String)"fact");
        LinearRing ring = fact.createLinearRing((Coordinate[])ArraysKt.requireNoNulls((Object[])this.getCoordinates()));
        return GeometryFactory.createPolygon$default(fact, ring, null, 2, null);
    }

    @NotNull
    public String toString() {
        return this.getGeometry(new GeometryFactory()).toString();
    }

    public final boolean isBorder() {
        for (int i = 0; i < 3; ++i) {
            if (this.getAdjacentTriangleAcrossEdge(i) != null) continue;
            return true;
        }
        return false;
    }

    public final boolean isBorder(int i) {
        return this.getAdjacentTriangleAcrossEdge(i) == null;
    }

    @Nullable
    public final QuadEdgeTriangle getAdjacentTriangleAcrossEdge(int edgeIndex) {
        QuadEdge quadEdge = this.getEdge(edgeIndex).sym();
        Intrinsics.checkNotNull((Object)quadEdge);
        return (QuadEdgeTriangle)quadEdge.getData();
    }

    public final int getAdjacentTriangleEdgeIndex(int i) {
        QuadEdgeTriangle quadEdgeTriangle = this.getAdjacentTriangleAcrossEdge(i);
        Intrinsics.checkNotNull((Object)quadEdgeTriangle);
        QuadEdge quadEdge = this.getEdge(i).sym();
        Intrinsics.checkNotNull((Object)quadEdge);
        return quadEdgeTriangle.getEdgeIndex(quadEdge);
    }

    @NotNull
    public final List<QuadEdgeTriangle> getTrianglesAdjacentToVertex(int vertexIndex) {
        QuadEdge start;
        List adjTris = new ArrayList();
        QuadEdge qe = start = this.getEdge(vertexIndex);
        do {
            Object object = qe.getData();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.triangulate.quadedge.QuadEdgeTriangle");
            QuadEdgeTriangle adjTri = (QuadEdgeTriangle)object;
            adjTris.add(adjTri);
            Intrinsics.checkNotNull((Object)qe.oNext());
        } while (qe != start);
        return adjTris;
    }

    @NotNull
    public final QuadEdgeTriangle[] getNeighbours() {
        QuadEdgeTriangle[] neigh = new QuadEdgeTriangle[3];
        for (int i = 0; i < 3; ++i) {
            QuadEdge quadEdge = this.getEdge(i).sym();
            Intrinsics.checkNotNull((Object)quadEdge);
            Intrinsics.checkNotNull((Object)quadEdge.getData(), (String)"null cannot be cast to non-null type org.locationtech.jts.triangulate.quadedge.QuadEdgeTriangle");
        }
        return neigh;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ#\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J#\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0012J\u0019\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u0016J\u0019\u0010\u0013\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\f\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a\u00a8\u0006\u001c"}, d2={"Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeTriangle$Companion;", "", "<init>", "()V", "createOn", "", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeTriangle;", "subdiv", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeSubdivision;", "contains", "", "tri", "", "Lorg/locationtech/jts/triangulate/quadedge/Vertex;", "pt", "Lorg/locationtech/jts/geom/Coordinate;", "([Lorg/locationtech/jts/triangulate/quadedge/Vertex;Lorg/locationtech/jts/geom/Coordinate;)Z", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;", "([Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;Lorg/locationtech/jts/geom/Coordinate;)Z", "toPolygon", "Lorg/locationtech/jts/geom/Geometry;", "v", "([Lorg/locationtech/jts/triangulate/quadedge/Vertex;)Lorg/locationtech/jts/geom/Geometry;", "e", "([Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;)Lorg/locationtech/jts/geom/Geometry;", "nextIndex", "", "index", "kts-core"})
    @SourceDebugExtension(value={"SMAP\nQuadEdgeTriangle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuadEdgeTriangle.kt\norg/locationtech/jts/triangulate/quadedge/QuadEdgeTriangle$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,320:1\n1#2:321\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<QuadEdgeTriangle> createOn(@NotNull QuadEdgeSubdivision subdiv) {
            Intrinsics.checkNotNullParameter((Object)subdiv, (String)"subdiv");
            QuadEdgeTriangleBuilderVisitor visitor = new QuadEdgeTriangleBuilderVisitor();
            subdiv.visitTriangles(visitor, false);
            return visitor.getTriangles();
        }

        public final boolean contains(@NotNull Vertex[] tri, @Nullable Coordinate pt) {
            Intrinsics.checkNotNullParameter((Object)tri, (String)"tri");
            Coordinate[] coordinateArray = new Coordinate[]{tri[0].getCoordinate(), tri[1].getCoordinate(), tri[2].getCoordinate(), tri[0].getCoordinate()};
            Coordinate[] ring = coordinateArray;
            Coordinate coordinate = pt;
            Intrinsics.checkNotNull((Object)coordinate);
            return PointLocation.isInRing(coordinate, ring);
        }

        public final boolean contains(@NotNull QuadEdge[] tri, @Nullable Coordinate pt) {
            Intrinsics.checkNotNullParameter((Object)tri, (String)"tri");
            Coordinate[] coordinateArray = new Coordinate[4];
            Vertex vertex = tri[0].orig();
            Intrinsics.checkNotNull((Object)vertex);
            coordinateArray[0] = vertex.getCoordinate();
            Vertex vertex2 = tri[1].orig();
            Intrinsics.checkNotNull((Object)vertex2);
            coordinateArray[1] = vertex2.getCoordinate();
            Vertex vertex3 = tri[2].orig();
            Intrinsics.checkNotNull((Object)vertex3);
            coordinateArray[2] = vertex3.getCoordinate();
            Vertex vertex4 = tri[0].orig();
            Intrinsics.checkNotNull((Object)vertex4);
            coordinateArray[3] = vertex4.getCoordinate();
            Coordinate[] ring = coordinateArray;
            Coordinate coordinate = pt;
            Intrinsics.checkNotNull((Object)coordinate);
            return PointLocation.isInRing(coordinate, ring);
        }

        @NotNull
        public final Geometry toPolygon(@NotNull Vertex[] v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            Coordinate[] coordinateArray = new Coordinate[]{v[0].getCoordinate(), v[1].getCoordinate(), v[2].getCoordinate(), v[0].getCoordinate()};
            Coordinate[] ringPts = coordinateArray;
            GeometryFactory fact = new GeometryFactory();
            LinearRing ring = fact.createLinearRing(ringPts);
            return GeometryFactory.createPolygon$default(fact, ring, null, 2, null);
        }

        @NotNull
        public final Geometry toPolygon(@NotNull QuadEdge[] e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Coordinate[] coordinateArray = new Coordinate[4];
            Vertex vertex = e[0].orig();
            Intrinsics.checkNotNull((Object)vertex);
            coordinateArray[0] = vertex.getCoordinate();
            Vertex vertex2 = e[1].orig();
            Intrinsics.checkNotNull((Object)vertex2);
            coordinateArray[1] = vertex2.getCoordinate();
            Vertex vertex3 = e[2].orig();
            Intrinsics.checkNotNull((Object)vertex3);
            coordinateArray[2] = vertex3.getCoordinate();
            Vertex vertex4 = e[0].orig();
            Intrinsics.checkNotNull((Object)vertex4);
            coordinateArray[3] = vertex4.getCoordinate();
            Coordinate[] ringPts = coordinateArray;
            GeometryFactory fact = new GeometryFactory();
            LinearRing ring = fact.createLinearRing(ringPts);
            return GeometryFactory.createPolygon$default(fact, ring, null, 2, null);
        }

        /*
         * WARNING - void declaration
         */
        public final int nextIndex(int index) {
            void it;
            int n;
            int index2 = 0;
            index2 = index;
            int n2 = n = 3;
            int n3 = index2 + 1;
            boolean bl = false;
            index2 = it;
            Unit unit = Unit.INSTANCE;
            return n3 % n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0002\u0010\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeTriangle$QuadEdgeTriangleBuilderVisitor;", "Lorg/locationtech/jts/triangulate/quadedge/TriangleVisitor;", "<init>", "()V", "triangles", "", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeTriangle;", "visit", "", "edges", "", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;", "([Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;)V", "getTriangles", "kts-core"})
    private static final class QuadEdgeTriangleBuilderVisitor
    implements TriangleVisitor {
        @NotNull
        private final List<QuadEdgeTriangle> triangles = new ArrayList();

        @Override
        public void visit(@NotNull QuadEdge[] edges) {
            Intrinsics.checkNotNullParameter((Object)edges, (String)"edges");
            this.triangles.add(new QuadEdgeTriangle(edges));
        }

        @NotNull
        public final List<QuadEdgeTriangle> getTriangles() {
            return this.triangles;
        }
    }
}

