/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.tri;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.io.WKTWriter;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0002J\n\u0010\u000f\u001a\u00020\u0010H\u0096\u0080\u0004J\u0014\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u0096\u0080\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/locationtech/jts/triangulate/tri/TriEdge;", "", "p0", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "<init>", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;)V", "getP0", "()Lorg/locationtech/jts/geom/Coordinate;", "setP0", "(Lorg/locationtech/jts/geom/Coordinate;)V", "getP1", "setP1", "normalize", "", "hashCode", "", "equals", "", "arg", "toString", "", "kts-core"})
public final class TriEdge {
    @NotNull
    private Coordinate p0;
    @NotNull
    private Coordinate p1;

    public TriEdge(@NotNull Coordinate p0, @NotNull Coordinate p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        this.p0 = p0;
        this.p1 = p1;
        this.normalize();
    }

    @NotNull
    public final Coordinate getP0() {
        return this.p0;
    }

    public final void setP0(@NotNull Coordinate coordinate) {
        Intrinsics.checkNotNullParameter((Object)coordinate, (String)"<set-?>");
        this.p0 = coordinate;
    }

    @NotNull
    public final Coordinate getP1() {
        return this.p1;
    }

    public final void setP1(@NotNull Coordinate coordinate) {
        Intrinsics.checkNotNullParameter((Object)coordinate, (String)"<set-?>");
        this.p1 = coordinate;
    }

    private final void normalize() {
        if (this.p0.compareTo(this.p1) < 0) {
            Coordinate tmp = this.p0;
            this.p0 = this.p1;
            this.p1 = tmp;
        }
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 37 * result2 + Coordinate.Companion.hashCode(this.p0.x);
        result2 = 37 * result2 + Coordinate.Companion.hashCode(this.p1.x);
        result2 = 37 * result2 + Coordinate.Companion.hashCode(this.p0.y);
        result2 = 37 * result2 + Coordinate.Companion.hashCode(this.p1.y);
        return result2;
    }

    public boolean equals(@Nullable Object arg) {
        if (!(arg instanceof TriEdge)) {
            return false;
        }
        Object other = arg;
        return Intrinsics.areEqual((Object)this.p0, (Object)((TriEdge)other).p0) && Intrinsics.areEqual((Object)this.p1, (Object)((TriEdge)other).p1);
    }

    @NotNull
    public String toString() {
        Coordinate[] coordinateArray = new Coordinate[]{this.p0, this.p1};
        return WKTWriter.Companion.toLineString(coordinateArray);
    }
}

