/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.util;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.util.Stopwatch;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0002\u0019\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0001J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0001J\u0012\u0010\u0011\u001a\u00020\u000e2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0001J\u0006\u0010\u0015\u001a\u00020\u000eJ\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0001H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u001b"}, d2={"Lorg/locationtech/jts/util/Debug;", "", "<init>", "()V", "out", "Ljava/io/PrintStream;", "printArgs", "", "Ljava/lang/Class;", "[Ljava/lang/Class;", "watchObj", "args", "[Ljava/lang/Object;", "instancePrintWatch", "", "instancePrintIfWatch", "obj", "instancePrint", "it", "", "instancePrintObject", "println", "instanceAddWatch", "str", "", "SegmentFindingFilter", "Companion", "kts-core"})
public final class Debug {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrintStream out;
    @NotNull
    private final Class<?>[] printArgs;
    @Nullable
    private Object watchObj;
    @NotNull
    private final Object[] args = new Object[1];
    @NotNull
    private static String DEBUG_PROPERTY_NAME = "jts.debug";
    @NotNull
    private static String DEBUG_PROPERTY_VALUE_ON = "on";
    @NotNull
    private static String DEBUG_PROPERTY_VALUE_TRUE = "true";
    private static boolean isDebugging;
    @NotNull
    private static final Stopwatch stopwatch;
    private static long lastTimePrinted;
    @NotNull
    private static final Debug debug;
    @NotNull
    private static final GeometryFactory fact;
    @NotNull
    private static final String DEBUG_LINE_TAG = "D! ";

    private Debug() {
        PrintStream printStream = System.out;
        Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
        this.out = printStream;
        this.printArgs = new Class[1];
        try {
            this.printArgs[0] = Class.forName("java.io.PrintStream");
        }
        catch (Exception exception) {
        }
    }

    public final void instancePrintWatch() {
        if (this.watchObj == null) {
            return;
        }
        Object object = this.watchObj;
        Intrinsics.checkNotNull((Object)object);
        this.instancePrint(object);
    }

    public final void instancePrintIfWatch(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (obj != this.watchObj) {
            return;
        }
        if (this.watchObj == null) {
            return;
        }
        Object object = this.watchObj;
        Intrinsics.checkNotNull((Object)object);
        this.instancePrint(object);
    }

    public final void instancePrint(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (obj instanceof Collection) {
            this.instancePrint(((Collection)obj).iterator());
        } else if (obj instanceof Iterator) {
            this.instancePrint((Iterator)obj);
        } else {
            this.instancePrintObject(obj);
        }
    }

    public final void instancePrint(@NotNull Iterator<?> it) {
        Intrinsics.checkNotNullParameter(it, (String)"it");
        while (it.hasNext()) {
            Object obj;
            Intrinsics.checkNotNull(it.next());
            this.instancePrintObject(obj);
        }
    }

    public final void instancePrintObject(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Method printMethod = null;
        try {
            Class<?> cls = obj.getClass();
            try {
                Object object = this.printArgs;
                printMethod = cls.getMethod("print", Arrays.copyOf(object, ((Class<?>[])object).length));
                this.args[0] = this.out;
                this.out.print(DEBUG_LINE_TAG);
                object = this.args;
                object = printMethod.invoke(obj, Arrays.copyOf(object, ((Object[])object).length));
            }
            catch (NoSuchMethodException ex) {
                this.instancePrint(obj.toString());
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(this.out);
        }
    }

    public final void println() {
        this.out.println();
    }

    private final void instanceAddWatch(Object obj) {
        this.watchObj = obj;
    }

    private final void instancePrint(String str) {
        this.out.print(DEBUG_LINE_TAG);
        this.out.print(str);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    static {
        String string = System.getProperty(DEBUG_PROPERTY_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String debugValue = string;
        if (StringsKt.equals((String)debugValue, (String)DEBUG_PROPERTY_VALUE_ON, (boolean)true) || StringsKt.equals((String)debugValue, (String)DEBUG_PROPERTY_VALUE_TRUE, (boolean)true)) {
            isDebugging = true;
        }
        stopwatch = new Stopwatch();
        debug = new Debug();
        fact = new GeometryFactory();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cH\u0007\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&J\u001e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020&J&\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020&J\u0006\u0010*\u001a\u00020\u001aJ\u000e\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u0005J\u000e\u0010+\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u0001J\u0016\u0010+\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u0001J\u000e\u0010*\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u0001J\u0006\u0010/\u001a\u00020\u001aJ\u000e\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u00020\u0005J\u0018\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u000205H\u0002J \u00108\u001a\u00020\u00112\u0006\u00109\u001a\u00020&2\b\u0010:\u001a\u0004\u0018\u00010&2\u0006\u0010;\u001a\u00020<J\u000e\u0010=\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u0001J\u0006\u0010>\u001a\u00020\u001aJ\u000e\u0010?\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u0001J\u000e\u0010@\u001a\u00020\u001a2\u0006\u0010A\u001a\u00020\u0011J\u0016\u0010B\u001a\u00020\u001a2\u0006\u0010C\u001a\u00020\u00012\u0006\u0010D\u001a\u00020\u0001J \u0010B\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010&2\u0006\u0010;\u001a\u00020<J\b\u0010E\u001a\u00020\u001aH\u0002J\u001e\u0010F\u001a\u00020\u00112\u0006\u0010G\u001a\u00020H2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lorg/locationtech/jts/util/Debug$Companion;", "", "<init>", "()V", "DEBUG_PROPERTY_NAME", "", "getDEBUG_PROPERTY_NAME", "()Ljava/lang/String;", "setDEBUG_PROPERTY_NAME", "(Ljava/lang/String;)V", "DEBUG_PROPERTY_VALUE_ON", "getDEBUG_PROPERTY_VALUE_ON", "setDEBUG_PROPERTY_VALUE_ON", "DEBUG_PROPERTY_VALUE_TRUE", "getDEBUG_PROPERTY_VALUE_TRUE", "setDEBUG_PROPERTY_VALUE_TRUE", "isDebugging", "", "()Z", "setDebugging", "(Z)V", "stopwatch", "Lorg/locationtech/jts/util/Stopwatch;", "lastTimePrinted", "", "main", "", "args", "", "([Ljava/lang/String;)V", "debug", "Lorg/locationtech/jts/util/Debug;", "fact", "Lorg/locationtech/jts/geom/GeometryFactory;", "DEBUG_LINE_TAG", "toLine", "Lorg/locationtech/jts/geom/LineString;", "p0", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "p2", "p3", "println", "print", "str", "obj", "isTrue", "resetTime", "printTime", "tag", "formatField", "s", "fieldLen", "", "spaces", "n", "equals", "c1", "c2", "tolerance", "", "addWatch", "printWatch", "printIfWatch", "breakIf", "cond", "breakIfEqual", "o1", "o2", "doBreak", "hasSegment", "geom", "Lorg/locationtech/jts/geom/Geometry;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDEBUG_PROPERTY_NAME() {
            return DEBUG_PROPERTY_NAME;
        }

        public final void setDEBUG_PROPERTY_NAME(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            DEBUG_PROPERTY_NAME = string;
        }

        @NotNull
        public final String getDEBUG_PROPERTY_VALUE_ON() {
            return DEBUG_PROPERTY_VALUE_ON;
        }

        public final void setDEBUG_PROPERTY_VALUE_ON(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            DEBUG_PROPERTY_VALUE_ON = string;
        }

        @NotNull
        public final String getDEBUG_PROPERTY_VALUE_TRUE() {
            return DEBUG_PROPERTY_VALUE_TRUE;
        }

        public final void setDEBUG_PROPERTY_VALUE_TRUE(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            DEBUG_PROPERTY_VALUE_TRUE = string;
        }

        public final boolean isDebugging() {
            return isDebugging;
        }

        public final void setDebugging(boolean bl) {
            isDebugging = bl;
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.println("JTS Debugging is " + (this.isDebugging() ? "ON" : "OFF"));
        }

        @NotNull
        public final LineString toLine(@NotNull Coordinate p0, @NotNull Coordinate p1) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            Coordinate[] coordinateArray = new Coordinate[]{p0, p1};
            return fact.createLineString(coordinateArray);
        }

        @NotNull
        public final LineString toLine(@NotNull Coordinate p0, @NotNull Coordinate p1, @NotNull Coordinate p2) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
            Coordinate[] coordinateArray = new Coordinate[]{p0, p1, p2};
            return fact.createLineString(coordinateArray);
        }

        @NotNull
        public final LineString toLine(@NotNull Coordinate p0, @NotNull Coordinate p1, @NotNull Coordinate p2, @NotNull Coordinate p3) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
            Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
            Coordinate[] coordinateArray = new Coordinate[]{p0, p1, p2, p3};
            return fact.createLineString(coordinateArray);
        }

        public final void println() {
            if (!this.isDebugging()) {
                return;
            }
            debug.println();
        }

        public final void print(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            if (!this.isDebugging()) {
                return;
            }
            debug.instancePrint(str);
        }

        public final void print(@NotNull Object obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            if (!this.isDebugging()) {
                return;
            }
            debug.instancePrint(obj);
        }

        public final void print(boolean isTrue, @NotNull Object obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            if (!this.isDebugging()) {
                return;
            }
            if (!isTrue) {
                return;
            }
            debug.instancePrint(obj);
        }

        public final void println(@NotNull Object obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            if (!this.isDebugging()) {
                return;
            }
            debug.instancePrint(obj);
            debug.println();
        }

        public final void resetTime() {
            stopwatch.reset();
            lastTimePrinted = stopwatch.getTime();
        }

        public final void printTime(@NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            if (!this.isDebugging()) {
                return;
            }
            long time = stopwatch.getTime();
            long elapsedTime = time - lastTimePrinted;
            debug.instancePrint(this.formatField(Stopwatch.Companion.getTimeString(time), 10) + " (" + this.formatField(Stopwatch.Companion.getTimeString(elapsedTime), 10) + " ) " + tag);
            debug.println();
            lastTimePrinted = time;
        }

        private final String formatField(String s, int fieldLen) {
            int nPad = fieldLen - s.length();
            if (nPad <= 0) {
                return s;
            }
            String padStr = this.spaces(nPad) + s;
            String string = padStr.substring(padStr.length() - fieldLen);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }

        private final String spaces(int n) {
            char[] ch = new char[n];
            for (int i = 0; i < n; ++i) {
                ch[i] = 32;
            }
            return new String(ch);
        }

        public final boolean equals(@NotNull Coordinate c1, @Nullable Coordinate c2, double tolerance) {
            Intrinsics.checkNotNullParameter((Object)c1, (String)"c1");
            Coordinate coordinate = c2;
            Intrinsics.checkNotNull((Object)coordinate);
            return c1.distance(coordinate) <= tolerance;
        }

        public final void addWatch(@NotNull Object obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            debug.instanceAddWatch(obj);
        }

        public final void printWatch() {
            debug.instancePrintWatch();
        }

        public final void printIfWatch(@NotNull Object obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            debug.instancePrintIfWatch(obj);
        }

        public final void breakIf(boolean cond) {
            if (cond) {
                this.doBreak();
            }
        }

        public final void breakIfEqual(@NotNull Object o1, @NotNull Object o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            if (Intrinsics.areEqual((Object)o1, (Object)o2)) {
                this.doBreak();
            }
        }

        public final void breakIfEqual(@NotNull Coordinate p0, @Nullable Coordinate p1, double tolerance) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Coordinate coordinate = p1;
            Intrinsics.checkNotNull((Object)coordinate);
            if (p0.distance(coordinate) <= tolerance) {
                this.doBreak();
            }
        }

        private final void doBreak() {
        }

        public final boolean hasSegment(@NotNull Geometry geom, @NotNull Coordinate p0, @NotNull Coordinate p1) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            SegmentFindingFilter filter = new SegmentFindingFilter(p0, p1);
            geom.apply(filter);
            return filter.hasSegment();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\bJ\u001a\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0012\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/locationtech/jts/util/Debug$SegmentFindingFilter;", "Lorg/locationtech/jts/geom/CoordinateSequenceFilter;", "p0", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "<init>", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;)V", "value", "", "isDone", "()Z", "hasSegment", "filter", "", "seq", "Lorg/locationtech/jts/geom/CoordinateSequence;", "i", "", "isGeometryChanged", "kts-core"})
    private static final class SegmentFindingFilter
    implements CoordinateSequenceFilter {
        @NotNull
        private final Coordinate p0;
        @NotNull
        private final Coordinate p1;
        private boolean isDone;

        public SegmentFindingFilter(@NotNull Coordinate p0, @NotNull Coordinate p1) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            this.p0 = p0;
            this.p1 = p1;
        }

        @Override
        public boolean isDone() {
            return this.isDone;
        }

        public final boolean hasSegment() {
            return this.isDone();
        }

        @Override
        public void filter(@Nullable CoordinateSequence seq, int i) {
            if (i == 0) {
                return;
            }
            CoordinateSequence coordinateSequence = seq;
            Intrinsics.checkNotNull((Object)coordinateSequence);
            this.isDone = this.p0.equals2D(coordinateSequence.getCoordinate(i - 1)) && this.p1.equals2D(seq.getCoordinate(i));
        }

        @Override
        public boolean isGeometryChanged() {
            return false;
        }
    }
}

