/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.canvas;

import androidx.compose.runtime.internal.StabilityInferred;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Kernel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.AbstractBufferedImageOp;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 +2\u00020\u0001:\u0001+B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bB!\b\u0012\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\rB\u0019\b\u0012\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0010J\u001a\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001dH\u0016J\u0018\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020&H\u0016J\n\u0010)\u001a\u00020*H\u0096\u0080\u0004R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/mkui/canvas/AntiAliasingBufferedImageOp;", "Lorg/mkui/canvas/AbstractBufferedImageOp;", "kernel", "Ljava/awt/image/Kernel;", "transparency", "", "<init>", "(Ljava/awt/image/Kernel;I)V", "()V", "factor", "", "diagonal", "tranparency", "(FFI)V", "matrix", "", "([FI)V", "getKernel", "()Ljava/awt/image/Kernel;", "setKernel", "(Ljava/awt/image/Kernel;)V", "alpha", "", "edgeAction", "getEdgeAction", "()I", "setEdgeAction", "(I)V", "filter", "Ljava/awt/image/BufferedImage;", "src", "dst", "createCompatibleDestImage", "dstCM", "Ljava/awt/image/ColorModel;", "getBounds2D", "Ljava/awt/geom/Rectangle2D;", "getPoint2D", "Ljava/awt/geom/Point2D;", "srcPt", "dstPt", "toString", "", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public final class AntiAliasingBufferedImageOp
extends AbstractBufferedImageOp {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Kernel kernel;
    private final boolean alpha;
    private int edgeAction;
    private final int transparency;
    public static final int $stable = 8;
    private static int ZERO_EDGES;
    private static final int CLAMP_EDGES = 1;
    private static final int WRAP_EDGES = 2;

    private AntiAliasingBufferedImageOp(Kernel kernel, int transparency) {
        this.alpha = true;
        this.edgeAction = 1;
        this.kernel = kernel;
        this.transparency = transparency;
    }

    @Nullable
    public final Kernel getKernel() {
        return this.kernel;
    }

    public final void setKernel(@Nullable Kernel kernel) {
        this.kernel = kernel;
    }

    public final int getEdgeAction() {
        return this.edgeAction;
    }

    public final void setEdgeAction(int n) {
        this.edgeAction = n;
    }

    public AntiAliasingBufferedImageOp() {
        this(1.0f, 0.0f, 127);
    }

    private AntiAliasingBufferedImageOp(float factor, float diagonal, int tranparency) {
        float[] fArray = new float[]{diagonal, factor, diagonal, factor, 0.0f, factor, diagonal, factor, diagonal};
        this(fArray, tranparency);
    }

    private AntiAliasingBufferedImageOp(float[] matrix, int transparency) {
        this(new Kernel(3, 3, matrix), transparency);
    }

    @Override
    @NotNull
    public BufferedImage filter(@NotNull BufferedImage src, @Nullable BufferedImage dst) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        BufferedImage dst2 = dst;
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst2 == null) {
            ColorModel colorModel = src.getColorModel();
            Intrinsics.checkNotNullExpressionValue((Object)colorModel, (String)"getColorModel(...)");
            dst2 = this.createCompatibleDestImage(src, colorModel);
        }
        int[] inPixels = new int[width * height];
        int[] outPixels = new int[width * height];
        this.getRGB(src, 0, 0, width, height, inPixels);
        AntiAliasingBufferedImageOp.Companion.convolve(this.kernel, inPixels, outPixels, width, height, this.alpha, this.edgeAction, this.transparency);
        this.setRGB(dst2, 0, 0, width, height, outPixels);
        return dst2;
    }

    @Override
    @NotNull
    public BufferedImage createCompatibleDestImage(@NotNull BufferedImage src, @NotNull ColorModel dstCM) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dstCM, (String)"dstCM");
        return new BufferedImage(dstCM, dstCM.createCompatibleWritableRaster(src.getWidth(), src.getHeight()), dstCM.isAlphaPremultiplied(), null);
    }

    @Override
    @NotNull
    public Rectangle2D getBounds2D(@NotNull BufferedImage src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return new Rectangle(0, 0, src.getWidth(), src.getHeight());
    }

    @Override
    @NotNull
    public Point2D getPoint2D(@NotNull Point2D srcPt, @NotNull Point2D dstPt) {
        Intrinsics.checkNotNullParameter((Object)srcPt, (String)"srcPt");
        Intrinsics.checkNotNullParameter((Object)dstPt, (String)"dstPt");
        Point2D dstPt2 = dstPt;
        dstPt2.setLocation(srcPt.getX(), srcPt.getY());
        return dstPt2;
    }

    @NotNull
    public String toString() {
        return "AntiAliasing...";
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002JJ\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002JJ\u0010\u001b\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/mkui/canvas/AntiAliasingBufferedImageOp$Companion;", "", "<init>", "()V", "ZERO_EDGES", "", "getZERO_EDGES", "()I", "setZERO_EDGES", "(I)V", "CLAMP_EDGES", "WRAP_EDGES", "clamp", "c", "convolve", "", "kernel", "Ljava/awt/image/Kernel;", "inPixels", "", "outPixels", "width", "height", "alpha", "", "edgeAction", "transparency", "convolveHV", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public final int getZERO_EDGES() {
            return ZERO_EDGES;
        }

        public final void setZERO_EDGES(int n) {
            ZERO_EDGES = n;
        }

        private final int clamp(int c2) {
            if (c2 < 0) {
                return 0;
            }
            return c2 > 255 ? 255 : c2;
        }

        private final void convolve(Kernel kernel, int[] inPixels, int[] outPixels, int width, int height, boolean alpha, int edgeAction, int transparency) {
            this.convolveHV(kernel, inPixels, outPixels, width, height, alpha, edgeAction, transparency);
        }

        private final void convolveHV(Kernel kernel, int[] inPixels, int[] outPixels, int width, int height, boolean alpha, int edgeAction, int transparency) {
            int index = 0;
            Kernel kernel2 = kernel;
            Intrinsics.checkNotNull((Object)kernel2);
            float[] matrix = kernel2.getKernelData(null);
            int rows = kernel.getHeight();
            int cols = kernel.getWidth();
            int rows2 = rows / 2;
            int cols2 = cols / 2;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int pixel;
                    block10: {
                        block11: {
                            int count;
                            float a;
                            block12: {
                                pixel = inPixels[y * width + x];
                                if (x >= width - cols2 || y >= height - rows2) break block10;
                                if ((pixel >> 24 & 0xFF) != 0) break block11;
                                float r = 0.0f;
                                float g2 = 0.0f;
                                float b = 0.0f;
                                a = 0.0f;
                                count = 0;
                                int row = -rows2;
                                if (row > rows2) break block12;
                                while (true) {
                                    block16: {
                                        int n;
                                        int ioffset;
                                        block14: {
                                            int iy;
                                            block15: {
                                                block13: {
                                                    iy = y + row;
                                                    ioffset = 0;
                                                    if (0 > iy || iy >= height) break block13;
                                                    n = iy * width;
                                                    break block14;
                                                }
                                                if (edgeAction != 1) break block15;
                                                n = y * width;
                                                break block14;
                                            }
                                            if (edgeAction != 2) break block16;
                                            n = (iy + height) % height * width;
                                        }
                                        ioffset = n;
                                        int moffset = cols * (row + rows2) + cols2;
                                        int col = -cols2;
                                        if (col > cols2) break block16;
                                        while (true) {
                                            block17: {
                                                int rgb;
                                                int t;
                                                int ix;
                                                float f;
                                                block18: {
                                                    int n2;
                                                    if ((f = matrix[moffset + col]) == 0.0f) break block17;
                                                    ix = x + col;
                                                    if (0 <= ix && ix < width) break block18;
                                                    switch (edgeAction) {
                                                        case 1: {
                                                            n2 = x;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n2 = (x + width) % width;
                                                            break;
                                                        }
                                                        default: {
                                                            break block17;
                                                        }
                                                    }
                                                    ix = n2;
                                                }
                                                if ((t = (rgb = inPixels[ioffset + ix]) >> 24 & 0xFF) != 0) {
                                                    ++count;
                                                    a += f * (float)transparency;
                                                    r += f * (float)(rgb >> 16 & 0xFF);
                                                    g2 += f * (float)(rgb >> 8 & 0xFF);
                                                    b += f * (float)(rgb & 0xFF);
                                                }
                                            }
                                            if (col == cols2) break;
                                            ++col;
                                        }
                                    }
                                    if (row == rows2) break;
                                    ++row;
                                }
                            }
                            if (count >= 2) {
                                a = transparency;
                                int ia = alpha ? this.clamp((int)((double)a + 0.5)) : 255;
                                int ir = this.clamp((int)((double)(r /= (float)count) + 0.5));
                                int ig = this.clamp((int)((double)(g2 /= (float)count) + 0.5));
                                int ib = this.clamp((int)((double)(b /= (float)count) + 0.5));
                                outPixels[index++] = ia << 24 | ir << 16 | ig << 8 | ib;
                                continue;
                            }
                            outPixels[index++] = pixel;
                            continue;
                        }
                        outPixels[index++] = pixel;
                        continue;
                    }
                    outPixels[index++] = pixel;
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

