/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.colormap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.SortedSet;
import com.macrofocus.common.interval.MutableInterval;
import com.macrofocus.common.interval.PropertyClosedInterval;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColorFactory;
import org.mkui.color.MkColorKt;
import org.mkui.colormap.MutableColorMap;
import org.mkui.colormap.SimpleColorMap;
import org.mkui.palette.CustomPalette;
import org.mkui.palette.MutablePalette;
import org.mkui.palette.PaletteFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0004\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0014\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011J\u0014\u0010\u0012\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011J\u0014\u0010\u0013\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011J\u001e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016J$\u0010\u0017\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016J\u0014\u0010\u001d\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011J\u001a\u0010\u001e\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010 J\u001a\u0010\"\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010 R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/mkui/colormap/ColorMapFactory;", "", "paletteFactory", "Lorg/mkui/palette/PaletteFactory;", "<init>", "(Lorg/mkui/palette/PaletteFactory;)V", "colorFactory", "Lorg/mkui/color/MkColorFactory;", "getPaletteFactory", "createContinuousSequentialColorMap", "Lorg/mkui/colormap/MutableColorMap;", "min", "", "max", "createContinuousDivergingColorMap", "createCategoricalSequentialColorMap", "values", "", "createCategoricalDivergingColorMap", "createQualitativeColorMap", "createContinuousColorMap", "palette", "Lorg/mkui/palette/MutablePalette;", "createCategoricalColorMap", "cyclic", "", "createColorMap", "interval", "Lcom/macrofocus/common/interval/MutableInterval;", "createAlphabeticalColorMap", "createAutoContinuousColorMap", "mininum", "", "maximum", "createAutoSegmentedColorMap", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public final class ColorMapFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MkColorFactory colorFactory;
    @NotNull
    private final PaletteFactory paletteFactory;
    public static final int $stable = 8;
    @NotNull
    private static final ColorMapFactory instance = new ColorMapFactory(null, 1, null);

    public ColorMapFactory(@NotNull PaletteFactory paletteFactory) {
        Intrinsics.checkNotNullParameter((Object)paletteFactory, (String)"paletteFactory");
        this.colorFactory = MkColorFactory.Companion.getInstance();
        this.paletteFactory = paletteFactory;
    }

    public /* synthetic */ ColorMapFactory(PaletteFactory paletteFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            paletteFactory = PaletteFactory.Companion.getInstance();
        }
        this(paletteFactory);
    }

    @NotNull
    public final PaletteFactory getPaletteFactory() {
        return this.paletteFactory;
    }

    @NotNull
    public final MutableColorMap createContinuousSequentialColorMap(double min, double max) {
        return this.createContinuousColorMap(min, max, this.paletteFactory.createDefaultSequentialPalette());
    }

    @NotNull
    public final MutableColorMap createContinuousDivergingColorMap(double min, double max) {
        return this.createContinuousColorMap(min, max, this.paletteFactory.createDefaultDivergingPalette());
    }

    @NotNull
    public final MutableColorMap createCategoricalSequentialColorMap(@Nullable Set<?> values) {
        return this.createCategoricalColorMap(values, false, this.paletteFactory.createDefaultSequentialPalette());
    }

    @NotNull
    public final MutableColorMap createCategoricalDivergingColorMap(@Nullable Set<?> values) {
        return this.createCategoricalColorMap(values, false, this.paletteFactory.createDefaultDivergingPalette());
    }

    @NotNull
    public final MutableColorMap createQualitativeColorMap(@Nullable Set<?> values) {
        return this.createCategoricalColorMap(values, true, this.paletteFactory.createDefaultQualititativePalette());
    }

    @NotNull
    public final MutableColorMap createContinuousColorMap(double min, double max, @NotNull MutablePalette palette) {
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        return new SimpleColorMap((MutableInterval)new PropertyClosedInterval(min, max - min), palette);
    }

    @NotNull
    public final MutableColorMap createCategoricalColorMap(@Nullable Set<?> values, boolean cyclic, @NotNull MutablePalette palette) {
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        return new SimpleColorMap(values, cyclic, palette);
    }

    @NotNull
    public final MutableColorMap createColorMap(@NotNull MutableInterval interval, @NotNull MutablePalette palette) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        return new SimpleColorMap(interval, palette);
    }

    @NotNull
    public final MutableColorMap createAlphabeticalColorMap(@Nullable Set<?> values) {
        SortedSet set = new SortedSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE), null, 2, null);
        set.add((Object)"A");
        set.add((Object)"B");
        set.add((Object)"C");
        return new SimpleColorMap((Set)set, false, this.paletteFactory.createDefaultSequentialPalette());
    }

    @NotNull
    public final MutableColorMap createAutoContinuousColorMap(@Nullable Number mininum, @Nullable Number maximum) {
        MutableColorMap mutableColorMap;
        if (mininum != null && maximum != null) {
            if (mininum.doubleValue() < 0.0 && maximum.doubleValue() > 0.0) {
                double diffMin = 0.0 - mininum.doubleValue();
                double diffMax = maximum.doubleValue();
                double maxDiff = Math.max(diffMin, diffMax);
                mutableColorMap = this.createContinuousDivergingColorMap(0.0 - maxDiff, maxDiff);
            } else {
                mutableColorMap = this.createContinuousSequentialColorMap(mininum.doubleValue(), maximum.doubleValue());
            }
        } else {
            mutableColorMap = this.createContinuousSequentialColorMap(0.0, 0.0);
        }
        return mutableColorMap;
    }

    @NotNull
    public final MutableColorMap createAutoSegmentedColorMap(@Nullable Number mininum, @Nullable Number maximum) {
        MutableColorMap mutableColorMap;
        if (mininum != null && maximum != null) {
            if (mininum.doubleValue() < 0.0 && maximum.doubleValue() > 0.0) {
                double diffMin = 0.0 - mininum.doubleValue();
                double diffMax = maximum.doubleValue();
                double maxDiff = Math.max(diffMin, diffMax);
                double min = 0.0 - maxDiff;
                double minF = (min - mininum.doubleValue()) / (maximum.doubleValue() - mininum.doubleValue());
                double maxF = (maxDiff - mininum.doubleValue()) / (maximum.doubleValue() - mininum.doubleValue());
                double meanF = (maxF + minF) / 2.0;
                CustomPalette.Entry[] entryArray = new CustomPalette.Entry[]{new CustomPalette.Entry(minF, MkColorKt.colorOf(255, 0, 0)), new CustomPalette.Entry(meanF, this.colorFactory.getWhite()), new CustomPalette.Entry(maxF, MkColorKt.colorOf(0, 128, 0))};
                mutableColorMap = this.createContinuousColorMap(mininum.doubleValue(), maximum.doubleValue(), new CustomPalette(entryArray));
            } else {
                CustomPalette.Entry[] entryArray = new CustomPalette.Entry[]{new CustomPalette.Entry(0.0, MkColorKt.colorOf(255, 0, 0)), new CustomPalette.Entry(0.5, this.colorFactory.getWhite()), new CustomPalette.Entry(1.0, MkColorKt.colorOf(0, 128, 0))};
                mutableColorMap = this.createContinuousColorMap(mininum.doubleValue(), maximum.doubleValue(), new CustomPalette(entryArray));
            }
        } else {
            CustomPalette.Entry[] entryArray = new CustomPalette.Entry[]{new CustomPalette.Entry(0.0, this.colorFactory.getWhite())};
            mutableColorMap = this.createContinuousColorMap(0.0, 0.0, new CustomPalette(entryArray));
        }
        return mutableColorMap;
    }

    public ColorMapFactory() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/mkui/colormap/ColorMapFactory$Companion;", "", "<init>", "()V", "instance", "Lorg/mkui/colormap/ColorMapFactory;", "getInstance", "()Lorg/mkui/colormap/ColorMapFactory;", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColorMapFactory getInstance() {
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

