/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.math.MathKt;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.Arc2D;
import org.mkui.geom.PathIterator;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\u0010\u0013\n\u0002\b\u0002\b\u0001\u0018\u0000 52\u00020\u0001:\u00015B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010/\u001a\u000200H\u0096\u0002J\u0010\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u000203H\u0016J\u0010\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u000204H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0012\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000b\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u000b\"\u0004\b\u001d\u0010\u001aR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010!\"\u0004\b&\u0010#R\u001a\u0010'\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010!\"\u0004\b)\u0010#R\u0014\u0010*\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010!R\u0014\u0010,\u001a\u00020-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010.\u00a8\u00066"}, d2={"Lorg/mkui/geom/ArcIterator;", "Lorg/mkui/geom/PathIterator;", "a", "Lorg/mkui/geom/Arc2D;", "at", "Lorg/mkui/geom/AffineTransform;", "<init>", "(Lorg/mkui/geom/Arc2D;Lorg/mkui/geom/AffineTransform;)V", "x", "", "getX", "()D", "y", "getY", "w", "getW", "h", "getH", "angStRad", "getAngStRad", "affine", "getAffine", "()Lorg/mkui/geom/AffineTransform;", "increment", "getIncrement", "setIncrement", "(D)V", "cv", "getCv", "setCv", "index", "", "getIndex", "()I", "setIndex", "(I)V", "arcSegs", "getArcSegs", "setArcSegs", "lineSegs", "getLineSegs", "setLineSegs", "windingRule", "getWindingRule", "isDone", "", "()Z", "next", "", "currentSegment", "coords", "", "", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public final class ArcIterator
implements PathIterator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;
    private final double w;
    private final double h;
    private final double angStRad;
    @Nullable
    private final AffineTransform affine;
    private double increment;
    private double cv;
    private int index;
    private int arcSegs;
    private int lineSegs;
    public static final int $stable = 8;

    public ArcIterator(@NotNull Arc2D a, @Nullable AffineTransform at) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        this.w = a.getWidth() / (double)2;
        this.h = a.getHeight() / (double)2;
        this.x = a.getX() + this.w;
        this.y = a.getY() + this.h;
        this.angStRad = -MathKt.convertDegreesToRadians((double)a.getAngleStart());
        this.affine = at;
        double ext = -a.getAngleExtent();
        if (ext >= 360.0 || ext <= -360.0) {
            this.arcSegs = 4;
            this.increment = 1.5707963267948966;
            this.cv = 0.5522847498307933;
            if (ext < 0.0) {
                this.increment = -this.increment;
                this.cv = -this.cv;
            }
        } else {
            this.arcSegs = (int)Math.ceil(Math.abs(ext) / 90.0);
            this.increment = MathKt.convertDegreesToRadians((double)(ext / (double)this.arcSegs));
            this.cv = ArcIterator.Companion.btan(this.increment);
            if (this.cv == 0.0) {
                this.arcSegs = 0;
            }
        }
        switch (a.getArcType()) {
            case 0: {
                this.lineSegs = 0;
                break;
            }
            case 1: {
                this.lineSegs = 1;
                break;
            }
            case 2: {
                this.lineSegs = 2;
            }
        }
        if (this.w < 0.0 || this.h < 0.0) {
            this.arcSegs = this.lineSegs = -1;
        }
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getW() {
        return this.w;
    }

    public final double getH() {
        return this.h;
    }

    public final double getAngStRad() {
        return this.angStRad;
    }

    @Nullable
    public final AffineTransform getAffine() {
        return this.affine;
    }

    public final double getIncrement() {
        return this.increment;
    }

    public final void setIncrement(double d) {
        this.increment = d;
    }

    public final double getCv() {
        return this.cv;
    }

    public final void setCv(double d) {
        this.cv = d;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    public final int getArcSegs() {
        return this.arcSegs;
    }

    public final void setArcSegs(int n) {
        this.arcSegs = n;
    }

    public final int getLineSegs() {
        return this.lineSegs;
    }

    public final void setLineSegs(int n) {
        this.lineSegs = n;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.index > this.arcSegs + this.lineSegs;
    }

    @Override
    public void next() {
        int n = this.index;
        this.index = n + 1;
    }

    @Override
    public int currentSegment(@NotNull float[] coords) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            if (this.isDone()) {
                throw new NoSuchElementException("arc iterator out of bounds");
            }
            double angle = this.angStRad;
            if (this.index == 0) {
                coords[0] = (float)(this.x + Math.cos(angle) * this.w);
                coords[1] = (float)(this.y + Math.sin(angle) * this.h);
                AffineTransform affineTransform = this.affine;
                if (affineTransform != null) {
                    affineTransform.transform(coords, 0, coords, 0, 1);
                }
                return 0;
            }
            if (this.index > this.arcSegs) {
                if (this.index == this.arcSegs + this.lineSegs) {
                    return 4;
                }
                coords[0] = (float)this.x;
                coords[1] = (float)this.y;
                AffineTransform affineTransform = this.affine;
                if (affineTransform != null) {
                    affineTransform.transform(coords, 0, coords, 0, 1);
                }
                return 1;
            }
            double relx = Math.cos(angle += this.increment * (double)(this.index - 1));
            double rely = Math.sin(angle);
            coords[0] = (float)(this.x + (relx - this.cv * rely) * this.w);
            coords[1] = (float)(this.y + (rely + this.cv * relx) * this.h);
            relx = Math.cos(angle += this.increment);
            rely = Math.sin(angle);
            coords[2] = (float)(this.x + (relx + this.cv * rely) * this.w);
            coords[3] = (float)(this.y + (rely - this.cv * relx) * this.h);
            coords[4] = (float)(this.x + relx * this.w);
            coords[5] = (float)(this.y + rely * this.h);
            AffineTransform affineTransform = this.affine;
            if (affineTransform == null) break block6;
            affineTransform.transform(coords, 0, coords, 0, 3);
        }
        return 3;
    }

    @Override
    public int currentSegment(@NotNull double[] coords) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            if (this.isDone()) {
                throw new NoSuchElementException("arc iterator out of bounds");
            }
            double angle = this.angStRad;
            if (this.index == 0) {
                coords[0] = this.x + Math.cos(angle) * this.w;
                coords[1] = this.y + Math.sin(angle) * this.h;
                AffineTransform affineTransform = this.affine;
                if (affineTransform != null) {
                    affineTransform.transform(coords, 0, coords, 0, 1);
                }
                return 0;
            }
            if (this.index > this.arcSegs) {
                if (this.index == this.arcSegs + this.lineSegs) {
                    return 4;
                }
                coords[0] = this.x;
                coords[1] = this.y;
                AffineTransform affineTransform = this.affine;
                if (affineTransform != null) {
                    affineTransform.transform(coords, 0, coords, 0, 1);
                }
                return 1;
            }
            double relx = Math.cos(angle += this.increment * (double)(this.index - 1));
            double rely = Math.sin(angle);
            coords[0] = this.x + (relx - this.cv * rely) * this.w;
            coords[1] = this.y + (rely + this.cv * relx) * this.h;
            relx = Math.cos(angle += this.increment);
            rely = Math.sin(angle);
            coords[2] = this.x + (relx + this.cv * rely) * this.w;
            coords[3] = this.y + (rely - this.cv * relx) * this.h;
            coords[4] = this.x + relx * this.w;
            coords[5] = this.y + rely * this.h;
            AffineTransform affineTransform = this.affine;
            if (affineTransform == null) break block6;
            affineTransform.transform(coords, 0, coords, 0, 3);
        }
        return 3;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/mkui/geom/ArcIterator$Companion;", "", "<init>", "()V", "btan", "", "increment", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        private final double btan(double increment) {
            double increment2 = increment;
            return 1.3333333333333333 * Math.sin(increment2 /= 2.0) / (1.0 + Math.cos(increment2));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

