/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.ArrayFnKt;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.mkui.geom.CubicCurve2D;
import org.mkui.geom.PathIterator;
import org.mkui.geom.QuadCurve2D;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u0013\n\u0002\b\u001a\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0014\n\u0002\b\u0002\b\u0007\u0018\u0000 L2\u00020\u0001:\u0001LB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0010\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020=H\u0002J\u000e\u0010D\u001a\u00020B2\u0006\u0010E\u001a\u00020\u0006J\t\u0010A\u001a\u00020BH\u0096\u0002J\u0010\u0010I\u001a\u00020\u00062\u0006\u0010J\u001a\u00020KH\u0016J\u0010\u0010I\u001a\u00020\u00062\u0006\u0010J\u001a\u00020\u0019H\u0016R\u001a\u0010\u0002\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0010\"\u0004\b \u0010\u0012R\u001a\u0010!\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0010\"\u0004\b#\u0010\u0012R\u001a\u0010$\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0010\"\u0004\b&\u0010\u0012R\u001a\u0010'\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0010\"\u0004\b)\u0010\u0012R\u001a\u0010*\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0015\"\u0004\b,\u0010\u0017R\u001a\u0010-\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0015\"\u0004\b/\u0010\u0017R\u001a\u00100\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0015\"\u0004\b2\u0010\u0017R\u001a\u00103\u001a\u000204X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001a\u00109\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u0015\"\u0004\b;\u0010\u0017R\u001a\u0010<\u001a\u00020=X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010>\"\u0004\b?\u0010@R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u0010R\u0014\u0010G\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u0015\u00a8\u0006M"}, d2={"Lorg/mkui/geom/FlatteningPathIterator;", "Lorg/mkui/geom/PathIterator;", "src", "flatness", "", "limit", "", "<init>", "(Lorg/mkui/geom/PathIterator;DI)V", "(Lorg/mkui/geom/PathIterator;D)V", "getSrc", "()Lorg/mkui/geom/PathIterator;", "setSrc", "(Lorg/mkui/geom/PathIterator;)V", "squareflat", "getSquareflat", "()D", "setSquareflat", "(D)V", "recursionLimit", "getRecursionLimit", "()I", "setRecursionLimit", "(I)V", "hold", "", "getHold", "()[D", "setHold", "([D)V", "curx", "getCurx", "setCurx", "cury", "getCury", "setCury", "movx", "getMovx", "setMovx", "movy", "getMovy", "setMovy", "holdType", "getHoldType", "setHoldType", "holdEnd", "getHoldEnd", "setHoldEnd", "holdIndex", "getHoldIndex", "setHoldIndex", "levels", "", "getLevels", "()[I", "setLevels", "([I)V", "levelIndex", "getLevelIndex", "setLevelIndex", "isDone", "", "()Z", "setDone", "(Z)V", "next", "", "doNext", "ensureHoldCapacity", "want", "getFlatness", "windingRule", "getWindingRule", "currentSegment", "coords", "", "Companion", "mkui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nFlatteningPathIterator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlatteningPathIterator.kt\norg/mkui/geom/FlatteningPathIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,398:1\n1#2:399\n*E\n"})
public final class FlatteningPathIterator
implements PathIterator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private PathIterator src;
    private double squareflat;
    private int recursionLimit;
    @NotNull
    private double[] hold;
    private double curx;
    private double cury;
    private double movx;
    private double movy;
    private int holdType;
    private int holdEnd;
    private int holdIndex;
    @NotNull
    private int[] levels;
    private int levelIndex;
    private boolean isDone;
    public static final int $stable = 8;
    public static final int GROW_SIZE = 24;

    public FlatteningPathIterator(@NotNull PathIterator src, double flatness, int limit) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        this.hold = new double[14];
        if (!(flatness >= 0.0)) {
            boolean $i$a$-require-FlatteningPathIterator$32 = false;
            String $i$a$-require-FlatteningPathIterator$32 = "flatness must be >= 0";
            throw new IllegalArgumentException($i$a$-require-FlatteningPathIterator$32.toString());
        }
        if (!(limit >= 0)) {
            boolean bl = false;
            String string = "limit must be >= 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.src = src;
        this.squareflat = flatness * flatness;
        this.recursionLimit = limit;
        this.levels = new int[limit + 1];
        this.next(false);
    }

    @NotNull
    public final PathIterator getSrc() {
        return this.src;
    }

    public final void setSrc(@NotNull PathIterator pathIterator) {
        Intrinsics.checkNotNullParameter((Object)pathIterator, (String)"<set-?>");
        this.src = pathIterator;
    }

    public final double getSquareflat() {
        return this.squareflat;
    }

    public final void setSquareflat(double d) {
        this.squareflat = d;
    }

    public final int getRecursionLimit() {
        return this.recursionLimit;
    }

    public final void setRecursionLimit(int n) {
        this.recursionLimit = n;
    }

    @NotNull
    public final double[] getHold() {
        return this.hold;
    }

    public final void setHold(@NotNull double[] dArray) {
        Intrinsics.checkNotNullParameter((Object)dArray, (String)"<set-?>");
        this.hold = dArray;
    }

    public final double getCurx() {
        return this.curx;
    }

    public final void setCurx(double d) {
        this.curx = d;
    }

    public final double getCury() {
        return this.cury;
    }

    public final void setCury(double d) {
        this.cury = d;
    }

    public final double getMovx() {
        return this.movx;
    }

    public final void setMovx(double d) {
        this.movx = d;
    }

    public final double getMovy() {
        return this.movy;
    }

    public final void setMovy(double d) {
        this.movy = d;
    }

    public final int getHoldType() {
        return this.holdType;
    }

    public final void setHoldType(int n) {
        this.holdType = n;
    }

    public final int getHoldEnd() {
        return this.holdEnd;
    }

    public final void setHoldEnd(int n) {
        this.holdEnd = n;
    }

    public final int getHoldIndex() {
        return this.holdIndex;
    }

    public final void setHoldIndex(int n) {
        this.holdIndex = n;
    }

    @NotNull
    public final int[] getLevels() {
        return this.levels;
    }

    public final void setLevels(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.levels = nArray;
    }

    public final int getLevelIndex() {
        return this.levelIndex;
    }

    public final void setLevelIndex(int n) {
        this.levelIndex = n;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    public void setDone(boolean bl) {
        this.isDone = bl;
    }

    public FlatteningPathIterator(@NotNull PathIterator src, double flatness) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        this(src, flatness, 10);
    }

    private final void next(boolean doNext) {
        if (this.holdIndex >= this.holdEnd) {
            if (doNext) {
                this.src.next();
            }
            if (this.src.isDone()) {
                this.setDone(true);
                return;
            }
            this.holdType = this.src.currentSegment(this.hold);
            this.levelIndex = 0;
            this.levels[0] = 0;
        }
        int level = 0;
        switch (this.holdType) {
            case 0: 
            case 1: {
                this.curx = this.hold[0];
                this.cury = this.hold[1];
                if (this.holdType == 0) {
                    this.movx = this.curx;
                    this.movy = this.cury;
                }
                this.holdIndex = 0;
                this.holdEnd = 0;
                break;
            }
            case 4: {
                this.curx = this.movx;
                this.cury = this.movy;
                this.holdIndex = 0;
                this.holdEnd = 0;
                break;
            }
            case 2: {
                int n;
                if (this.holdIndex >= this.holdEnd) {
                    this.holdIndex = this.hold.length - 6;
                    this.holdEnd = this.hold.length - 2;
                    this.hold[this.holdIndex + 0] = this.curx;
                    this.hold[this.holdIndex + 1] = this.cury;
                    this.hold[this.holdIndex + 2] = this.hold[0];
                    this.hold[this.holdIndex + 3] = this.hold[1];
                    this.hold[this.holdIndex + 4] = this.curx = this.hold[2];
                    this.hold[this.holdIndex + 5] = this.cury = this.hold[3];
                }
                level = this.levels[this.levelIndex];
                while (level < this.recursionLimit && !(QuadCurve2D.Companion.getFlatnessSq(this.hold, this.holdIndex) < this.squareflat)) {
                    this.ensureHoldCapacity(4);
                    QuadCurve2D.Companion.subdivide(this.hold, this.holdIndex, this.hold, this.holdIndex - 4, this.hold, this.holdIndex);
                    this.holdIndex -= 4;
                    this.levels[this.levelIndex] = ++level;
                    n = this.levelIndex;
                    this.levelIndex = n + 1;
                    this.levels[this.levelIndex] = level;
                }
                this.holdIndex += 4;
                n = this.levelIndex;
                this.levelIndex = n + -1;
                break;
            }
            case 3: {
                int n;
                if (this.holdIndex >= this.holdEnd) {
                    this.holdIndex = this.hold.length - 8;
                    this.holdEnd = this.hold.length - 2;
                    this.hold[this.holdIndex + 0] = this.curx;
                    this.hold[this.holdIndex + 1] = this.cury;
                    this.hold[this.holdIndex + 2] = this.hold[0];
                    this.hold[this.holdIndex + 3] = this.hold[1];
                    this.hold[this.holdIndex + 4] = this.hold[2];
                    this.hold[this.holdIndex + 5] = this.hold[3];
                    this.hold[this.holdIndex + 6] = this.curx = this.hold[4];
                    this.hold[this.holdIndex + 7] = this.cury = this.hold[5];
                }
                level = this.levels[this.levelIndex];
                while (level < this.recursionLimit && !(CubicCurve2D.INSTANCE.getFlatnessSq(this.hold, this.holdIndex) < this.squareflat)) {
                    this.ensureHoldCapacity(6);
                    CubicCurve2D.INSTANCE.subdivide(this.hold, this.holdIndex, this.hold, this.holdIndex - 6, this.hold, this.holdIndex);
                    this.holdIndex -= 6;
                    this.levels[this.levelIndex] = ++level;
                    n = this.levelIndex;
                    this.levelIndex = n + 1;
                    this.levels[this.levelIndex] = level;
                }
                this.holdIndex += 6;
                n = this.levelIndex;
                this.levelIndex = n + -1;
            }
        }
    }

    public final void ensureHoldCapacity(int want) {
        if (this.holdIndex - want < 0) {
            int have = this.hold.length - this.holdIndex;
            int newsize = this.hold.length + 24;
            double[] newhold = new double[newsize];
            ArrayFnKt.arraycopy((double[])this.hold, (int)this.holdIndex, (double[])newhold, (int)(this.holdIndex + 24), (int)have);
            this.hold = newhold;
            this.holdIndex += 24;
            this.holdEnd += 24;
        }
    }

    public final double getFlatness() {
        return Math.sqrt(this.squareflat);
    }

    @Override
    public int getWindingRule() {
        return this.src.getWindingRule();
    }

    @Override
    public void next() {
        this.next(true);
    }

    @Override
    public int currentSegment(@NotNull float[] coords) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        if (this.isDone()) {
            throw new NoSuchElementException("flattening iterator out of bounds");
        }
        int type = this.holdType;
        if (type != 4) {
            coords[0] = (float)this.hold[this.holdIndex + 0];
            coords[1] = (float)this.hold[this.holdIndex + 1];
            if (type != 0) {
                type = 1;
            }
        }
        return type;
    }

    @Override
    public int currentSegment(@NotNull double[] coords) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        if (this.isDone()) {
            throw new NoSuchElementException("flattening iterator out of bounds");
        }
        int type = this.holdType;
        if (type != 4) {
            coords[0] = this.hold[this.holdIndex + 0];
            coords[1] = this.hold[this.holdIndex + 1];
            if (type != 0) {
                type = 1;
            }
        }
        return type;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/mkui/geom/FlatteningPathIterator$Companion;", "", "<init>", "()V", "GROW_SIZE", "", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

