/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.Labeling;
import com.treemap.Nesting;
import com.treemap.TreeMapColumnSettings;
import com.treemap.TreeMapModel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\b'\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JQ\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u0002H\u00062\u0006\u0010\r\u001a\u00020\u000eH&\u00a2\u0006\u0002\u0010\u000fJQ\u0010\u0010\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010\u0012\u001a\u0002H\u00062\u0006\u0010\f\u001a\u0002H\u00062\u0006\u0010\u0013\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lcom/treemap/AbstractNesting;", "Lcom/treemap/Nesting;", "<init>", "()V", "subtract", "Lorg/mkui/geom/Shape;", "N", "Row", "Column", "model", "Lcom/treemap/TreeMapModel;", "rectangle", "node", "amount", "", "(Lcom/treemap/TreeMapModel;Lorg/mkui/geom/Shape;Ljava/lang/Object;D)Lorg/mkui/geom/Shape;", "getNested", "treeMapModel", "currentRoot", "shape", "(Lcom/treemap/TreeMapModel;Ljava/lang/Object;Ljava/lang/Object;Lorg/mkui/geom/Shape;)Lorg/mkui/geom/Shape;", "Companion", "treemap"})
@StabilityInferred(parameters=1)
public abstract class AbstractNesting
implements Nesting {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    private static final boolean APPLY_NESTING_TO_CURRENT_ROOT = true;

    @NotNull
    public abstract <N, Row, Column> Shape subtract(@NotNull TreeMapModel<N, Row, Column> var1, @NotNull Shape var2, N var3, double var4);

    @Override
    @NotNull
    public <N, Row, Column> Shape getNested(@NotNull TreeMapModel<N, Row, Column> treeMapModel, N currentRoot, N node, @NotNull Shape shape) {
        Shape shape2;
        Intrinsics.checkNotNullParameter(treeMapModel, (String)"treeMapModel");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Shape r = null;
        Shape nested = null;
        TreeMapColumnSettings columnSettings = treeMapModel.getSettings().getColumnSettings(treeMapModel.getGroupByColumn(node));
        if (columnSettings.getAlgorithm().isChildContained()) {
            Double d = columnSettings.getNestingAmount();
            Intrinsics.checkNotNull((Object)d);
            v1 = this.subtract(treeMapModel, shape, node, d);
        } else {
            v1 = nested = shape;
        }
        if (columnSettings.getAlgorithm().isChildContained()) {
            Labeling labeling = columnSettings.getLabeling();
            Intrinsics.checkNotNull((Object)labeling);
            Shape label = labeling.subtract(treeMapModel, shape, node);
            if (label != nested && label instanceof Rectangle2D && nested instanceof Rectangle2D) {
                Rectangle2D n = (Rectangle2D)nested;
                Rectangle2D l = (Rectangle2D)label;
                double x1 = Math.max(n.getMinX(), l.getMinX());
                double y1 = Math.max(n.getMinY(), l.getMinY());
                double x2 = Math.min(n.getMaxX(), l.getMaxX());
                double y2 = Math.min(n.getMaxY(), l.getMaxY());
                shape2 = (Shape)new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
            } else {
                shape2 = nested;
            }
        } else {
            shape2 = nested;
        }
        r = shape2;
        return r;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/treemap/AbstractNesting$Companion;", "", "<init>", "()V", "APPLY_NESTING_TO_CURRENT_ROOT", "", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

