/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.Aggregation;
import com.treemap.AverageAggregation;
import com.treemap.CountAggregation;
import com.treemap.MaxAggregation;
import com.treemap.MinAggregation;
import com.treemap.NoneAggregation;
import com.treemap.SizeWeightedAggregation;
import com.treemap.StdDevAggregation;
import com.treemap.SumAggregation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001b\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004J\u0006\u0010\u000b\u001a\u00020\u0004J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rJ\u0013\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0086\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/treemap/AggregationFactory;", "", "entries", "", "Lcom/treemap/Aggregation;", "<init>", "([Lcom/treemap/Aggregation;)V", "", "add", "", "entry", "getDefault", "getAggregations", "", "get", "name", "", "find", "Companion", "treemap"})
@StabilityInferred(parameters=0)
public final class AggregationFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Aggregation> entries;
    public static final int $stable = 8;
    @NotNull
    private static final Aggregation NONE_AGGREGATION = new NoneAggregation();
    @NotNull
    private static final Aggregation SUM_AGGREGATION = new SumAggregation();
    @NotNull
    private static final Aggregation SIZE_WEIGHTED_AGGREGATION = new SizeWeightedAggregation();
    @NotNull
    private static final Aggregation AVERAGE_AGGREGATION = new AverageAggregation();
    @NotNull
    private static final Aggregation COUNT_AGGREGATION = new CountAggregation();
    @NotNull
    private static final Aggregation MIN_AGGREGATION = new MinAggregation();
    @NotNull
    private static final Aggregation MAX_AGGREGATION = new MaxAggregation();
    @NotNull
    private static final Aggregation STD_DEV_AGGREGATION = new StdDevAggregation();
    @NotNull
    private static final AggregationFactory ourInstance;

    public AggregationFactory(Aggregation ... entries) {
        Intrinsics.checkNotNullParameter((Object)entries, (String)"entries");
        this.entries = new ArrayList();
        CollectionsKt.addAll((Collection)this.entries, (Object[])entries);
    }

    public final void add(@NotNull Aggregation entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.entries.add(entry);
    }

    @NotNull
    public final Aggregation getDefault() {
        return SUM_AGGREGATION;
    }

    @NotNull
    public final List<Aggregation> getAggregations() {
        return this.entries;
    }

    @NotNull
    public final Aggregation get(@Nullable String name) {
        for (Aggregation aggregation : this.entries) {
            if (!aggregation.toString().equals(name)) continue;
            return aggregation;
        }
        return this.getDefault();
    }

    @Nullable
    public final Aggregation find(@Nullable String name) {
        for (Aggregation aggregation : this.entries) {
            if (!aggregation.toString().equals(name)) continue;
            return aggregation;
        }
        return null;
    }

    static {
        Aggregation[] aggregationArray = new Aggregation[]{NONE_AGGREGATION, SUM_AGGREGATION, SIZE_WEIGHTED_AGGREGATION, AVERAGE_AGGREGATION, COUNT_AGGREGATION, MIN_AGGREGATION, MAX_AGGREGATION, STD_DEV_AGGREGATION};
        ourInstance = new AggregationFactory(aggregationArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0018\u001a\u00020\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/treemap/AggregationFactory$Companion;", "", "<init>", "()V", "NONE_AGGREGATION", "Lcom/treemap/Aggregation;", "getNONE_AGGREGATION", "()Lcom/treemap/Aggregation;", "SUM_AGGREGATION", "getSUM_AGGREGATION", "SIZE_WEIGHTED_AGGREGATION", "getSIZE_WEIGHTED_AGGREGATION", "AVERAGE_AGGREGATION", "getAVERAGE_AGGREGATION", "COUNT_AGGREGATION", "getCOUNT_AGGREGATION", "MIN_AGGREGATION", "getMIN_AGGREGATION", "MAX_AGGREGATION", "getMAX_AGGREGATION", "STD_DEV_AGGREGATION", "getSTD_DEV_AGGREGATION", "ourInstance", "Lcom/treemap/AggregationFactory;", "getInstance", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Aggregation getNONE_AGGREGATION() {
            return NONE_AGGREGATION;
        }

        @NotNull
        public final Aggregation getSUM_AGGREGATION() {
            return SUM_AGGREGATION;
        }

        @NotNull
        public final Aggregation getSIZE_WEIGHTED_AGGREGATION() {
            return SIZE_WEIGHTED_AGGREGATION;
        }

        @NotNull
        public final Aggregation getAVERAGE_AGGREGATION() {
            return AVERAGE_AGGREGATION;
        }

        @NotNull
        public final Aggregation getCOUNT_AGGREGATION() {
            return COUNT_AGGREGATION;
        }

        @NotNull
        public final Aggregation getMIN_AGGREGATION() {
            return MIN_AGGREGATION;
        }

        @NotNull
        public final Aggregation getMAX_AGGREGATION() {
            return MAX_AGGREGATION;
        }

        @NotNull
        public final Aggregation getSTD_DEV_AGGREGATION() {
            return STD_DEV_AGGREGATION;
        }

        @NotNull
        public final AggregationFactory getInstance() {
            return ourInstance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

