/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.plot.guide;

import java.util.HashMap;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.AnimationTimer;
import javafx.animation.KeyFrame;
import javafx.animation.SequentialTransition;
import javafx.animation.Timeline;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.chart.Axis;

public final class MyChartLayoutAnimator
extends AnimationTimer
implements EventHandler<ActionEvent> {
    private Parent nodeToLayout;
    private final Map<Object, Animation> activeTimeLines = new HashMap<Object, Animation>();
    private final boolean isAxis;

    public MyChartLayoutAnimator(Parent nodeToLayout) {
        this.nodeToLayout = nodeToLayout;
        this.isAxis = nodeToLayout instanceof Axis;
    }

    public void handle(long l) {
        if (this.isAxis) {
            ((Axis)this.nodeToLayout).requestAxisLayout();
        } else {
            this.nodeToLayout.requestLayout();
        }
    }

    public void handle(ActionEvent actionEvent) {
        this.activeTimeLines.remove(actionEvent.getSource());
        if (this.activeTimeLines.isEmpty()) {
            this.stop();
        }
        this.handle(0L);
    }

    public void stop(Object animationID) {
        Animation t = this.activeTimeLines.remove(animationID);
        if (t != null) {
            t.stop();
        }
        if (this.activeTimeLines.isEmpty()) {
            this.stop();
        }
    }

    public Object animate(KeyFrame ... keyFrames) {
        Timeline t = new Timeline();
        t.setAutoReverse(false);
        t.setCycleCount(1);
        t.getKeyFrames().addAll((Object[])keyFrames);
        t.setOnFinished((EventHandler)this);
        if (this.activeTimeLines.isEmpty()) {
            this.start();
        }
        this.activeTimeLines.put(t, (Animation)t);
        t.play();
        return t;
    }

    public Object animate(Animation animation) {
        SequentialTransition t = new SequentialTransition();
        t.getChildren().add((Object)animation);
        t.setOnFinished((EventHandler)this);
        if (this.activeTimeLines.isEmpty()) {
            this.start();
        }
        this.activeTimeLines.put(t, (Animation)t);
        t.play();
        return t;
    }
}

