/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.plot.guide;

import com.macrofocus.plot.guide.MyChartLayoutAnimator;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WritableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.SizeConverter;
import javafx.geometry.Dimension2D;
import javafx.geometry.Side;
import javafx.scene.Parent;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.ValueAxis;
import javafx.util.Duration;
import javafx.util.StringConverter;

public class MyNumberAxis
extends ValueAxis<Number> {
    private Object currentAnimationID;
    private final MyChartLayoutAnimator animator = new MyChartLayoutAnimator((Parent)this);
    private final StringProperty currentFormatterProperty = new SimpleStringProperty((Object)this, "currentFormatter", "");
    private final DefaultFormatter defaultFormatter = new DefaultFormatter(this);
    private BooleanProperty forceZeroInRange = new BooleanPropertyBase(true){

        protected void invalidated() {
            if (MyNumberAxis.this.isAutoRanging()) {
                MyNumberAxis.this.requestAxisLayout();
                MyNumberAxis.this.invalidateRange();
            }
        }

        public Object getBean() {
            return MyNumberAxis.this;
        }

        public String getName() {
            return "forceZeroInRange";
        }
    };
    private DoubleProperty tickUnit = new StyleableDoubleProperty(5.0){

        protected void invalidated() {
            if (!MyNumberAxis.this.isAutoRanging()) {
                MyNumberAxis.this.invalidateRange();
                MyNumberAxis.this.requestAxisLayout();
            }
        }

        public CssMetaData<MyNumberAxis, Number> getCssMetaData() {
            return StyleableProperties.TICK_UNIT;
        }

        public Object getBean() {
            return MyNumberAxis.this;
        }

        public String getName() {
            return "tickUnit";
        }
    };

    public final boolean isForceZeroInRange() {
        return this.forceZeroInRange.getValue();
    }

    public final void setForceZeroInRange(boolean value) {
        this.forceZeroInRange.setValue(Boolean.valueOf(value));
    }

    public final BooleanProperty forceZeroInRangeProperty() {
        return this.forceZeroInRange;
    }

    public final double getTickUnit() {
        return this.tickUnit.get();
    }

    public final void setTickUnit(double value) {
        this.tickUnit.set(value);
    }

    public final DoubleProperty tickUnitProperty() {
        return this.tickUnit;
    }

    public MyNumberAxis() {
    }

    public MyNumberAxis(double lowerBound, double upperBound, double tickUnit) {
        super(lowerBound, upperBound);
        this.setTickUnit(tickUnit);
    }

    public MyNumberAxis(String axisLabel, double lowerBound, double upperBound, double tickUnit) {
        super(lowerBound, upperBound);
        this.setTickUnit(tickUnit);
        this.setLabel(axisLabel);
    }

    protected String getTickMarkLabel(Number value) {
        StringConverter formatter = this.getTickLabelFormatter();
        if (formatter == null) {
            formatter = this.defaultFormatter;
        }
        return formatter.toString((Object)value);
    }

    protected Object getRange() {
        return new Object[]{this.getLowerBound(), this.getUpperBound(), this.getTickUnit(), this.getScale(), this.currentFormatterProperty.get()};
    }

    protected void setRange(Object range, boolean animate) {
        Object[] rangeProps = (Object[])range;
        double lowerBound = (Double)rangeProps[0];
        double upperBound = (Double)rangeProps[1];
        double tickUnit = (Double)rangeProps[2];
        double scale = (Double)rangeProps[3];
        String formatter = (String)rangeProps[4];
        this.currentFormatterProperty.set((Object)formatter);
        double oldLowerBound = this.getLowerBound();
        this.setLowerBound(lowerBound);
        this.setUpperBound(upperBound);
        this.setTickUnit(tickUnit);
        if (animate) {
            this.animator.stop(this.currentAnimationID);
            this.currentAnimationID = this.animator.animate(new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.currentLowerBound, (Object)oldLowerBound)}), new KeyFrame(Duration.millis((double)700.0), new KeyValue[]{new KeyValue((WritableValue)this.currentLowerBound, (Object)lowerBound)}));
        } else {
            this.currentLowerBound.set(lowerBound);
            this.setScale(scale);
        }
    }

    protected List<Number> calculateTickValues(double length, Object range) {
        Object[] rangeProps = (Object[])range;
        double lowerBound = (Double)rangeProps[0];
        double upperBound = (Double)rangeProps[1];
        double tickUnit = (Double)rangeProps[2];
        ArrayList<Number> tickValues = new ArrayList<Number>();
        if (lowerBound == upperBound) {
            tickValues.add(lowerBound);
        } else if (tickUnit <= 0.0) {
            tickValues.add(lowerBound);
            tickValues.add(upperBound);
        } else if (tickUnit > 0.0) {
            tickValues.add(lowerBound);
            if ((upperBound - lowerBound) / tickUnit > 2000.0) {
                System.err.println("Warning we tried to create more than 2000 major tick marks on a NumberAxis. Lower Bound=" + lowerBound + ", Upper Bound=" + upperBound + ", Tick Unit=" + tickUnit);
            } else if (lowerBound + tickUnit < upperBound) {
                double major = Math.rint(tickUnit) == tickUnit ? Math.ceil(lowerBound) : lowerBound + tickUnit;
                int count = (int)Math.ceil((upperBound - major) / tickUnit);
                for (int i = 0; major < upperBound && i < count; major += tickUnit, ++i) {
                    if (tickValues.contains(major)) continue;
                    tickValues.add(major);
                }
            }
            tickValues.add(upperBound);
        }
        return tickValues;
    }

    protected List<Number> calculateMinorTickMarks() {
        ArrayList<Number> minorTickMarks = new ArrayList<Number>();
        double lowerBound = this.getLowerBound();
        double upperBound = this.getUpperBound();
        double tickUnit = this.getTickUnit();
        double minorUnit = tickUnit / (double)Math.max(1, this.getMinorTickCount());
        if (tickUnit > 0.0) {
            int i;
            int count;
            boolean tickUnitIsInteger;
            if ((upperBound - lowerBound) / minorUnit > 10000.0) {
                System.err.println("Warning we tried to create more than 10000 minor tick marks on a NumberAxis. Lower Bound=" + this.getLowerBound() + ", Upper Bound=" + this.getUpperBound() + ", Tick Unit=" + tickUnit);
                return minorTickMarks;
            }
            boolean bl = tickUnitIsInteger = Math.rint(tickUnit) == tickUnit;
            if (tickUnitIsInteger) {
                double minor = Math.floor(lowerBound) + minorUnit;
                count = (int)Math.ceil((Math.ceil(lowerBound) - minor) / minorUnit);
                for (i = 0; minor < Math.ceil(lowerBound) && i < count; minor += minorUnit, ++i) {
                    if (!(minor > lowerBound)) continue;
                    minorTickMarks.add(minor);
                }
            }
            double major = tickUnitIsInteger ? Math.ceil(lowerBound) : lowerBound;
            count = (int)Math.ceil((upperBound - major) / tickUnit);
            for (i = 0; major < upperBound && i < count; major += tickUnit, ++i) {
                double next = Math.min(major + tickUnit, upperBound);
                double minor = major + minorUnit;
                int minorCount = (int)Math.ceil((next - minor) / minorUnit);
                for (int j = 0; minor < next && j < minorCount; minor += minorUnit, ++j) {
                    minorTickMarks.add(minor);
                }
            }
        }
        return minorTickMarks;
    }

    protected Dimension2D measureTickMarkSize(Number value, Object range) {
        Object[] rangeProps = (Object[])range;
        String formatter = (String)rangeProps[4];
        return this.measureTickMarkSize(value, this.getTickLabelRotation(), formatter);
    }

    private Dimension2D measureTickMarkSize(Number value, double rotation, String numFormatter) {
        StringConverter formatter = this.getTickLabelFormatter();
        if (formatter == null) {
            formatter = this.defaultFormatter;
        }
        String labelText = formatter instanceof NumberAxis.DefaultFormatter ? ((DefaultFormatter)formatter).toString(value, numFormatter) : formatter.toString((Object)value);
        return this.measureTickMarkLabelSize(labelText, rotation);
    }

    protected Object autoRange(double minValue, double maxValue, double length, double labelSize) {
        Side side = this.getSide();
        if (this.isForceZeroInRange()) {
            if (maxValue < 0.0) {
                maxValue = 0.0;
            } else if (minValue > 0.0) {
                minValue = 0.0;
            }
        }
        int numOfTickMarks = (int)Math.floor(length / labelSize);
        numOfTickMarks = Math.max(numOfTickMarks, 2);
        int minorTickCount = Math.max(this.getMinorTickCount(), 1);
        double range = maxValue - minValue;
        if (range != 0.0 && range / (double)(numOfTickMarks * minorTickCount) <= Math.ulp(minValue)) {
            range = 0.0;
        }
        double paddedRange = range == 0.0 ? (minValue == 0.0 ? 2.0 : Math.abs(minValue) * 0.02) : Math.abs(range) * 1.02;
        double padding = (paddedRange - range) / 2.0;
        double paddedMin = minValue - padding;
        double paddedMax = maxValue + padding;
        if (paddedMin < 0.0 && minValue >= 0.0 || paddedMin > 0.0 && minValue <= 0.0) {
            paddedMin = 0.0;
        }
        if (paddedMax < 0.0 && maxValue >= 0.0 || paddedMax > 0.0 && maxValue <= 0.0) {
            paddedMax = 0.0;
        }
        double tickUnit = paddedRange / (double)numOfTickMarks;
        double tickUnitRounded = 0.0;
        double minRounded = 0.0;
        double maxRounded = 0.0;
        int count = 0;
        double reqLength = Double.MAX_VALUE;
        String formatter = "0.00000000";
        while (reqLength > length || count > 20) {
            double mant;
            int exp = (int)Math.floor(Math.log10(tickUnit));
            double ratio = mant = tickUnit / Math.pow(10.0, exp);
            if (mant > 5.0) {
                ++exp;
                ratio = 1.0;
            } else if (mant > 1.0) {
                double d = ratio = mant > 2.5 ? 5.0 : 2.5;
            }
            if (exp > 1) {
                formatter = "#,##0";
            } else if (exp == 1) {
                formatter = "0";
            } else {
                int n;
                boolean ratioHasFrac = Math.rint(ratio) != ratio;
                StringBuilder formatterB = new StringBuilder("0");
                int n2 = n = ratioHasFrac ? Math.abs(exp) + 1 : Math.abs(exp);
                if (n > 0) {
                    formatterB.append(".");
                }
                for (int i = 0; i < n; ++i) {
                    formatterB.append("0");
                }
                formatter = formatterB.toString();
            }
            tickUnitRounded = ratio * Math.pow(10.0, exp);
            minRounded = Math.floor(paddedMin / tickUnitRounded) * tickUnitRounded;
            maxRounded = Math.ceil(paddedMax / tickUnitRounded) * tickUnitRounded;
            double maxReqTickGap = 0.0;
            double last = 0.0;
            count = (int)Math.ceil((maxRounded - minRounded) / tickUnitRounded);
            double major = minRounded;
            for (int i = 0; major <= maxRounded && i < count; major += tickUnitRounded, ++i) {
                double size;
                Dimension2D markSize = this.measureTickMarkSize(major, this.getTickLabelRotation(), formatter);
                double d = size = side.isVertical() ? markSize.getHeight() : markSize.getWidth();
                if (i == 0) {
                    last = size / 2.0;
                    continue;
                }
                maxReqTickGap = Math.max(maxReqTickGap, last + 6.0 + size / 2.0);
            }
            reqLength = (double)(count - 1) * maxReqTickGap;
            tickUnit = tickUnitRounded;
            if (numOfTickMarks == 2 && reqLength > length) break;
            if (!(reqLength > length) && count <= 20) continue;
            tickUnit *= 2.0;
        }
        double newScale = this.calculateNewScale(length, minRounded, maxRounded);
        return new Object[]{minRounded, maxRounded, tickUnitRounded, newScale, formatter};
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return MyNumberAxis.getClassCssMetaData();
    }

    public static class DefaultFormatter
    extends StringConverter<Number> {
        private DecimalFormat formatter;
        private String prefix = null;
        private String suffix = null;

        public DefaultFormatter(MyNumberAxis axis) {
            this.formatter = axis.isAutoRanging() ? new DecimalFormat((String)axis.currentFormatterProperty.get()) : new DecimalFormat();
            ChangeListener axisListener = (observable, oldValue, newValue) -> {
                this.formatter = axis.isAutoRanging() ? new DecimalFormat((String)axis.currentFormatterProperty.get()) : new DecimalFormat();
            };
            axis.currentFormatterProperty.addListener(axisListener);
            axis.autoRangingProperty().addListener(axisListener);
        }

        public DefaultFormatter(MyNumberAxis axis, String prefix, String suffix) {
            this(axis);
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public String toString(Number object) {
            return this.toString(object, this.formatter);
        }

        private String toString(Number object, String numFormatter) {
            if (numFormatter == null || numFormatter.isEmpty()) {
                return this.toString(object, this.formatter);
            }
            return this.toString(object, new DecimalFormat(numFormatter));
        }

        private String toString(Number object, DecimalFormat formatter) {
            if (this.prefix != null && this.suffix != null) {
                return this.prefix + formatter.format(object) + this.suffix;
            }
            if (this.prefix != null) {
                return this.prefix + formatter.format(object);
            }
            if (this.suffix != null) {
                return formatter.format(object) + this.suffix;
            }
            return formatter.format(object);
        }

        public Number fromString(String string) {
            try {
                int prefixLength = this.prefix == null ? 0 : this.prefix.length();
                int suffixLength = this.suffix == null ? 0 : this.suffix.length();
                return this.formatter.parse(string.substring(prefixLength, string.length() - suffixLength));
            }
            catch (ParseException e) {
                return null;
            }
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<MyNumberAxis, Number> TICK_UNIT = new CssMetaData<MyNumberAxis, Number>("-fx-tick-unit", SizeConverter.getInstance(), (Number)5.0){

            public boolean isSettable(MyNumberAxis n) {
                return n.tickUnit == null || !n.tickUnit.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(MyNumberAxis n) {
                return (StyleableProperty)n.tickUnitProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<MyNumberAxis, Number>> styleables = new ArrayList<CssMetaData<MyNumberAxis, Number>>(ValueAxis.getClassCssMetaData());
            styleables.add(TICK_UNIT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

