/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.aggregates.cube;

import com.macrofocus.molap.aggregates.cube.KthSelector;
import com.macrofocus.molap.aggregates.cube.Statistics;
import com.macrofocus.molap.series.Series;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class UnivariateStatistics
implements Statistics,
Comparable<UnivariateStatistics> {
    private final List<Number> a = new ArrayList<Number>();
    private Double b;
    private Double c;
    private long d;
    private long e;
    private static final Comparator<Number> f = new Comparator<Number>(){

        @Override
        public final /* synthetic */ int compare(Object object, Object object2) {
            object2 = (Number)object2;
            object = (Number)object;
            return Double.compare(((Number)object).doubleValue(), ((Number)object2).doubleValue());
        }
    };

    public UnivariateStatistics(Series column) {
        for (Object object : column.keys()) {
            if ((object = column.get(object)) != null && object instanceof Number) {
                double d2 = ((Number)(object = (Number)object)).doubleValue();
                if (!Double.isInfinite(d2) && !Double.isNaN(d2)) {
                    this.a.add((Number)object);
                    this.b = this.b != null ? Double.valueOf(this.b + ((Number)object).doubleValue()) : Double.valueOf(((Number)object).doubleValue());
                    if (this.c != null) {
                        double d3 = d2;
                        this.c = this.c + d3 * d3;
                    } else {
                        double d4 = d2;
                        this.c = d4 * d4;
                    }
                    ++this.d;
                    continue;
                }
                ++this.e;
                continue;
            }
            ++this.e;
        }
        Collections.sort(this.a, f);
    }

    public <Row> UnivariateStatistics(Iterable<Row> rows, Series<Row, ?> column) {
        Iterator iterator;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if ((object = column.get(object)) != null && object instanceof Number) {
                double d2 = ((Number)(object = (Number)object)).doubleValue();
                if (!Double.isInfinite(d2) && !Double.isNaN(d2)) {
                    this.a.add((Number)object);
                    this.b = this.b != null ? Double.valueOf(this.b + ((Number)object).doubleValue()) : Double.valueOf(((Number)object).doubleValue());
                    if (this.c != null) {
                        double d3 = d2;
                        this.c = this.c + d3 * d3;
                    } else {
                        double d4 = d2;
                        this.c = d4 * d4;
                    }
                    ++this.d;
                    continue;
                }
                ++this.e;
                continue;
            }
            ++this.e;
        }
        Collections.sort(this.a, new a());
    }

    @Override
    public Double getUncorrectedSumOfSquares() {
        return this.c;
    }

    @Override
    public Number getMinimum() {
        if (this.a.size() > 0) {
            return this.a.get(0);
        }
        return null;
    }

    @Override
    public Number getMaximum() {
        if (this.a.size() > 0) {
            return this.a.get(this.a.size() - 1);
        }
        return null;
    }

    public Double getMean() {
        if (this.d > 0L) {
            return this.b / (double)this.d;
        }
        return null;
    }

    public Double getVariance() {
        Double d2 = this.getMean();
        if (d2 != null) {
            return this.getUncorrectedSumOfSquares() / (double)this.getCount() - d2 * d2;
        }
        return null;
    }

    public Double getStdDev() {
        Double d2 = this.getVariance();
        if (d2 != null) {
            return Math.sqrt(d2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Object getSigma(double sigma) {
        Double d2 = this.getMean();
        if (d2 != null) {
            Double d3 = this.getStdDev();
            if (d3 != null) {
                void var1_1;
                return d2 + var1_1 * d3;
            }
            return null;
        }
        return null;
    }

    public Number getMedian() {
        return this.getPercentile(50.0);
    }

    @Override
    public long getCount() {
        return this.d;
    }

    @Override
    public long getCountOfMissing() {
        return this.e;
    }

    @Override
    public Double getSum() {
        return this.b;
    }

    public long getCountLessThan(double threshold) {
        long l2 = 0L;
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            Number number = this.a.get(i2);
            if (number == null) continue;
            if (!(number.doubleValue() < threshold)) break;
            ++l2;
        }
        return l2;
    }

    public long getCountValue(double value) {
        long l2 = 0L;
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            Number number = this.a.get(i2);
            if (number == null) continue;
            if (number.doubleValue() == value) {
                ++l2;
                continue;
            }
            if (number.doubleValue() > value) break;
        }
        return l2;
    }

    /*
     * WARNING - void declaration
     */
    public Double getPercentile(EstimationType type, double p2) {
        int n2 = this.a.size();
        if (n2 > 0) {
            void var2_2;
            void var1_1;
            double[] dArray = new double[n2];
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                Number number = this.a.get(i2);
                dArray[i2] = number.doubleValue();
            }
            return var1_1.evaluate(dArray, (double)var2_2, new KthSelector());
        }
        return null;
    }

    public Double getPercentileRank(double value) {
        int n2 = this.a.size();
        if (n2 > 1) {
            double d2;
            Double d3 = this.getPercentile(0.0);
            int n3 = 0;
            int n4 = 0;
            while (n4 <= 100) {
                d3 = this.getPercentile(n4);
                if (value <= d3) {
                    n3 = n4;
                    break;
                }
                n3 = n4++;
            }
            n4 = n3;
            int n5 = n3 + 1;
            while (n5 <= 100 && this.getPercentile(n5).doubleValue() == d3.doubleValue()) {
                n4 = n5++;
            }
            double d4 = (double)(n3 + n4) / 2.0;
            if (d2 > 50.0) {
                return Math.ceil(d4);
            }
            return Math.floor(d4);
        }
        if (n2 > 0) {
            return 50.0;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Double getPercentileRankWikipedia(double value) {
        long l2 = this.getCount();
        if (l2 > 0L) {
            void var1_1;
            double d2 = this.getCountLessThan(value);
            double d3 = this.getCountValue((double)var1_1);
            double d4 = l2;
            return Math.round((d2 + d3 * 0.5) / d4 * 100.0);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Double getPercentileRankWikipediaNmin1(double value) {
        void var1_1;
        return Math.round(this.getPercentileRankWikipediaNmin1Unrounded((double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Double getPercentileRankWikipediaNmin1Unrounded(double value) {
        long l2 = this.getCount();
        if (l2 > 1L) {
            void var1_1;
            double d2 = this.getCountLessThan(value);
            double d3 = this.getCountValue((double)var1_1) - 1L;
            double d4 = l2 - 1L;
            return (d2 + d3 * 0.5) / d4 * 100.0;
        }
        if (l2 > 0L) {
            return 50.0;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Double getPercentileRankInc(double value) {
        long l2 = this.getCount();
        if (l2 > 1L) {
            void var1_1;
            double d2 = this.getCountLessThan((double)var1_1);
            double d3 = l2 - 1L;
            return Math.round(d2 / d3 * 100.0);
        }
        if (l2 > 0L) {
            return 50.0;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Double getPercentile(double p2) {
        void var1_1;
        return this.getPercentile(EstimationType.R_7, (double)var1_1);
    }

    @Override
    public int compareTo(UnivariateStatistics o2) {
        if (o2 != null && this.getMean() != null) {
            Number number;
            if ((number = ((UnivariateStatistics)((Object)number)).getMedian()) != null) {
                return Double.compare(this.getMedian().doubleValue(), number.doubleValue());
            }
            return 1;
        }
        return 1;
    }

    public boolean equals(Object o2) {
        UnivariateStatistics univariateStatistics;
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof UnivariateStatistics)) {
            return false;
        }
        univariateStatistics = univariateStatistics;
        return Objects.equals(this.getMedian(), univariateStatistics.getMedian()) && Objects.equals(this.getMinimum(), univariateStatistics.getMinimum()) && Objects.equals(this.getMaximum(), univariateStatistics.getMaximum()) && this.getCount() == univariateStatistics.getCount() && this.getCountOfMissing() == univariateStatistics.getCountOfMissing() && Objects.equals(this.getSum(), univariateStatistics.getSum()) && Objects.equals(this.getUncorrectedSumOfSquares(), univariateStatistics.getUncorrectedSumOfSquares());
    }

    public int hashCode() {
        return Objects.hash(this.getMedian(), this.getMinimum(), this.getMaximum(), this.getCount(), this.getCountOfMissing(), this.getSum(), this.getUncorrectedSumOfSquares());
    }

    public String toString() {
        return "UnivariateStatistics{count=" + this.d + ", min=" + String.valueOf(this.getMinimum()) + ", median=" + String.valueOf(this.getMedian()) + ", mean=" + this.getMean() + ", max=" + String.valueOf(this.getMaximum()) + "}";
    }

    private static final class a
    implements Comparator<Number> {
        private a() {
        }

        @Override
        public final /* synthetic */ int compare(Object object, Object object2) {
            object2 = (Number)object2;
            object = (Number)object;
            return Double.compare(((Number)object).doubleValue(), ((Number)object2).doubleValue());
        }
    }

    public static enum EstimationType {
        LEGACY("Legacy Apache Commons Math", (AbstractEstimationFunction)new a()),
        R_1("R-1", (AbstractEstimationFunction)new b()),
        R_2("R-2", (AbstractEstimationFunction)new c()),
        R_3("R-3", (AbstractEstimationFunction)new d()),
        R_4("R-4", (AbstractEstimationFunction)new e()),
        R_5("R-5", (AbstractEstimationFunction)new f()),
        R_6("R-6", (AbstractEstimationFunction)new g()),
        R_7("R-7", (AbstractEstimationFunction)new h()),
        R_8("R-8", (AbstractEstimationFunction)new i()),
        R_9("R-9", (AbstractEstimationFunction)new j());

        private final String a;
        private final EstimationFunction b;

        /*
         * WARNING - void declaration
         */
        private EstimationType(String type, EstimationFunction func) {
            void var3_3;
            this.a = var3_3;
            this.b = func;
        }

        /*
         * WARNING - void declaration
         */
        protected final double index(double p2, int length) {
            void var3_2;
            void var1_1;
            return this.b.index((double)var1_1, (int)var3_2);
        }

        /*
         * WARNING - void declaration
         */
        protected final double estimate(double[] work, int[] pivotsHeap, double pos, int length, KthSelector selector) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.b.estimate((double[])var1_1, (int[])var2_2, (double)var3_3, length, selector);
        }

        /*
         * WARNING - void declaration
         */
        protected final double evaluate(double[] work, int[] pivotsHeap, double p2, KthSelector selector) {
            void var1_1;
            void var3_3;
            void var2_2;
            if (p2 > 100.0 || p2 < 0.0) {
                throw new IllegalArgumentException("OUT_OF_BOUNDS_QUANTILE_VALUE");
            }
            return this.estimate(work, (int[])var2_2, this.index((double)(var3_3 / 100.0), work.length), ((void)var1_1).length, selector);
        }

        /*
         * WARNING - void declaration
         */
        public final double evaluate(double[] work, double p2, KthSelector selector) {
            void var2_2;
            void var1_1;
            return this.evaluate((double[])var1_1, null, (double)var2_2, selector);
        }

        private static final class a
        extends AbstractEstimationFunction {
            private a() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final double index(double p2, int length) {
                void var3_2;
                void var1_1;
                if (Double.compare(p2, 0.0) == 0) {
                    return 0.0;
                }
                if (Double.compare(p2, 1.0) == 0) {
                    return length;
                }
                return (double)(var1_1 * (double)(var3_2 + true));
            }
        }

        private static final class b
        extends AbstractEstimationFunction {
            private b() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final double index(double p2, int length) {
                void var1_1;
                void var3_2;
                if (Double.compare(p2, 0.0) == 0) {
                    return 0.0;
                }
                return (double)var3_2 * var1_1 + 0.5;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final double estimate(double[] values, int[] pivotsHeap, double pos, int length, KthSelector selector) {
                void var3_3;
                void var2_2;
                void var1_1;
                return super.estimate((double[])var1_1, (int[])var2_2, Math.ceil((double)(var3_3 - 0.5)), length, selector);
            }
        }

        private static final class c
        extends AbstractEstimationFunction {
            private c() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final double index(double p2, int length) {
                void var1_1;
                void var3_2;
                if (Double.compare(p2, 1.0) == 0) {
                    return length;
                }
                if (Double.compare(p2, 0.0) == 0) {
                    return 0.0;
                }
                return (double)var3_2 * var1_1 + 0.5;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final double estimate(double[] values, int[] pivotsHeap, double pos, int length, KthSelector selector) {
                void var3_3;
                void var2_2;
                void var1_1;
                double d2 = super.estimate(values, pivotsHeap, Math.ceil(pos - 0.5), length, selector);
                double d3 = super.estimate((double[])var1_1, (int[])var2_2, Math.floor((double)(var3_3 + 0.5)), length, selector);
                return (d2 + d3) / 2.0;
            }
        }

        private static final class d
        extends AbstractEstimationFunction {
            private d() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final double index(double p2, int length) {
                void var1_1;
                void var3_2;
                double d2 = 0.5 / (double)length;
                if (Double.compare(p2, d2) <= 0) {
                    return 0.0;
                }
                return Math.rint((double)var3_2 * var1_1);
            }
        }

        private static final class e
        extends AbstractEstimationFunction {
            private e() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final double index(double p2, int length) {
                void var1_1;
                void var3_2;
                double d2 = 1.0 / (double)length;
                if (Double.compare(p2, d2) < 0) {
                    return 0.0;
                }
                if (Double.compare(p2, 1.0) == 0) {
                    return length;
                }
                return (double)var3_2 * var1_1;
            }
        }

        private static final class f
        extends AbstractEstimationFunction {
            private f() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final double index(double p2, int length) {
                void var1_1;
                void var3_2;
                double d2 = 0.5 / (double)length;
                double d3 = ((double)length - 0.5) / (double)length;
                if (Double.compare(p2, d2) < 0) {
                    return 0.0;
                }
                if (Double.compare(p2, d3) >= 0) {
                    return length;
                }
                return (double)var3_2 * var1_1 + 0.5;
            }
        }

        private static final class g
        extends AbstractEstimationFunction {
            private g() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final double index(double p2, int length) {
                void var1_1;
                void var3_2;
                double d2 = 1.0 / (double)(length + 1);
                double d3 = 1.0 * (double)length / (double)(length + 1);
                if (Double.compare(p2, d2) < 0) {
                    return 0.0;
                }
                if (Double.compare(p2, d3) >= 0) {
                    return length;
                }
                return (double)(var3_2 + true) * var1_1;
            }
        }

        private static final class h
        extends AbstractEstimationFunction {
            private h() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final double index(double p2, int length) {
                void var1_1;
                void var3_2;
                if (Double.compare(p2, 0.0) == 0) {
                    return 0.0;
                }
                if (Double.compare(p2, 1.0) == 0) {
                    return length;
                }
                return 1.0 + (double)(var3_2 - true) * var1_1;
            }
        }

        private static final class i
        extends AbstractEstimationFunction {
            private i() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final double index(double p2, int length) {
                void var1_1;
                void var3_2;
                double d2 = 0.6666666666666666 / ((double)length + 0.3333333333333333);
                double d3 = ((double)length - 0.3333333333333333) / ((double)length + 0.3333333333333333);
                if (Double.compare(p2, d2) < 0) {
                    return 0.0;
                }
                if (Double.compare(p2, d3) >= 0) {
                    return length;
                }
                return ((double)var3_2 + 0.3333333333333333) * var1_1 + 0.3333333333333333;
            }
        }

        private static final class j
        extends AbstractEstimationFunction {
            private j() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final double index(double p2, int length) {
                void var1_1;
                void var3_2;
                double d2 = 0.625 / ((double)length + 0.25);
                double d3 = ((double)length - 0.375) / ((double)length + 0.25);
                if (Double.compare(p2, d2) < 0) {
                    return 0.0;
                }
                if (Double.compare(p2, d3) >= 0) {
                    return length;
                }
                return ((double)var3_2 + 0.25) * var1_1 + 0.375;
            }
        }
    }

    public static abstract class AbstractEstimationFunction
    implements EstimationFunction {
        /*
         * WARNING - void declaration
         */
        @Override
        public double estimate(double[] work, int[] pivotsHeap, double pos, int length, KthSelector selector) {
            void var2_2;
            void var1_1;
            void var3_3;
            double d2 = Math.floor(pos);
            int n2 = (int)d2;
            double d3 = pos - d2;
            if (pos < 1.0) {
                return selector.select(work, pivotsHeap, 0);
            }
            if (var3_3 >= (double)length) {
                return selector.select(work, pivotsHeap, length - 1);
            }
            double d4 = selector.select(work, pivotsHeap, n2 - 1);
            double d5 = selector.select((double[])var1_1, (int[])var2_2, n2);
            return d4 + d3 * (d5 - d4);
        }
    }

    public static interface EstimationFunction {
        public double index(double var1, int var3);

        public double estimate(double[] var1, int[] var2, double var3, int var5, KthSelector var6);
    }
}

