/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.series;

import com.macrofocus.molap.series.ByteDictionarySeries;
import com.macrofocus.molap.series.DefaultSeries;
import com.macrofocus.molap.series.DoubleSeries;
import com.macrofocus.molap.series.FloatSeries;
import com.macrofocus.molap.series.IndexedSeries;
import com.macrofocus.molap.series.IntegerSeries;
import com.macrofocus.molap.series.LongSeries;
import com.macrofocus.molap.series.MutableSeries;
import com.macrofocus.molap.series.Series;
import com.macrofocus.molap.series.ShortDictionarySeries;

public class SeriesFactory {
    private static final SeriesFactory a = new SeriesFactory();

    public static SeriesFactory getInstance() {
        return a;
    }

    private SeriesFactory() {
    }

    public static <V> MutableSeries<Integer, V> create(V ... values) {
        V[] VArray;
        SeriesFactory.getInstance();
        if (VArray.getClass().getComponentType() == Integer.class) {
            return new IntegerSeries((Integer[])VArray);
        }
        return new DefaultSeries<V>(VArray);
    }

    /*
     * WARNING - void declaration
     */
    public static MutableSeries<Integer, Integer> createInteger(int[] values, boolean[] available) {
        void var1_1;
        int[] nArray;
        SeriesFactory.getInstance();
        return new IntegerSeries(nArray, (boolean[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static MutableSeries<Integer, Long> createLong(long[] values, boolean[] available) {
        void var1_1;
        long[] lArray;
        SeriesFactory.getInstance();
        return new LongSeries(lArray, (boolean[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static MutableSeries<Integer, Float> createFloat(float[] values, boolean[] available) {
        void var1_1;
        float[] fArray;
        SeriesFactory.getInstance();
        return new FloatSeries(fArray, (boolean[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static MutableSeries<Integer, Double> createDouble(double[] values, boolean[] available) {
        void var1_1;
        double[] dArray;
        SeriesFactory.getInstance();
        return new DoubleSeries(dArray, (boolean[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <V> MutableSeries<Integer, V> create(Object name, V ... values) {
        void var1_1;
        Object object;
        SeriesFactory.getInstance();
        return new DefaultSeries(object, (V[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Series<K, V> create(Object name, V[] values, K[] keys) {
        void var2_2;
        void var1_1;
        Object object;
        SeriesFactory.getInstance();
        return new IndexedSeries(object, (V[])var1_1, (K[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <V> Series<Integer, V> create(Object name, V[] dictionary, byte[] pointers) {
        void var2_2;
        void var1_1;
        Object object;
        SeriesFactory.getInstance();
        return new ByteDictionarySeries(object, (V[])var1_1, (byte[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <V> Series<Integer, V> create(Object name, V[] dictionary, short[] pointers) {
        void var2_2;
        void var1_1;
        Object object;
        SeriesFactory.getInstance();
        return new ShortDictionarySeries(object, (V[])var1_1, (short[])var2_2);
    }
}

