/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.map.hash;

import gnu.trove.TDoubleCollection;
import gnu.trove.func.TDoubleFunction;
import gnu.trove.impl.Constants;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.THash;
import gnu.trove.impl.hash.TObjectHash;
import gnu.trove.iterator.TDoubleIterator;
import gnu.trove.iterator.TObjectDoubleIterator;
import gnu.trove.iterator.hash.TObjectHashIterator;
import gnu.trove.map.TObjectDoubleMap;
import gnu.trove.procedure.TDoubleProcedure;
import gnu.trove.procedure.TObjectDoubleProcedure;
import gnu.trove.procedure.TObjectProcedure;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class TObjectDoubleHashMap<K>
extends TObjectHash<K>
implements TObjectDoubleMap<K> {
    private final TObjectDoubleProcedure<K> a = new TObjectDoubleProcedure<K>(this){
        private /* synthetic */ TObjectDoubleHashMap a;
        {
            this.a = tObjectDoubleHashMap;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean execute(K key, double value) {
            void var2_2;
            void var1_1;
            this.a.put(var1_1, (double)var2_2);
            return true;
        }
    };
    protected transient double[] _values;
    protected double no_entry_value;

    public TObjectDoubleHashMap() {
        this.no_entry_value = Constants.DEFAULT_DOUBLE_NO_ENTRY_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public TObjectDoubleHashMap(int initialCapacity) {
        super((int)var1_1);
        void var1_1;
        this.no_entry_value = Constants.DEFAULT_DOUBLE_NO_ENTRY_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public TObjectDoubleHashMap(int initialCapacity, float loadFactor) {
        super((int)var1_1, (float)var2_2);
        void var2_2;
        void var1_1;
        this.no_entry_value = Constants.DEFAULT_DOUBLE_NO_ENTRY_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public TObjectDoubleHashMap(int initialCapacity, float loadFactor, double noEntryValue) {
        super((int)var1_1, (float)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.no_entry_value = var3_3;
        if (this.no_entry_value != 0.0) {
            Arrays.fill(this._values, this.no_entry_value);
        }
    }

    /*
     * WARNING - void declaration
     */
    public TObjectDoubleHashMap(TObjectDoubleMap<? extends K> map) {
        this(map.size(), 0.5f, map.getNoEntryValue());
        void var1_1;
        if (map instanceof TObjectDoubleHashMap) {
            TObjectDoubleHashMap tObjectDoubleHashMap = (TObjectDoubleHashMap)map;
            this._loadFactor = tObjectDoubleHashMap._loadFactor;
            this.no_entry_value = tObjectDoubleHashMap.no_entry_value;
            if (this.no_entry_value != 0.0) {
                Arrays.fill(this._values, this.no_entry_value);
            }
            ((TObjectHash)this).setUp((int)Math.ceil(10.0f / this._loadFactor));
        }
        this.putAll((TObjectDoubleMap<K>)var1_1);
    }

    @Override
    public int setUp(int initialCapacity) {
        int n2;
        n2 = super.setUp(n2);
        this._values = new double[n2];
        return n2;
    }

    @Override
    protected void rehash(int newCapacity) {
        int n2;
        int n3 = this._set.length;
        Object[] objectArray = this._set;
        double[] dArray = this._values;
        this._set = new Object[newCapacity];
        Arrays.fill(this._set, FREE);
        this._values = new double[n2];
        Arrays.fill(this._values, this.no_entry_value);
        n2 = n3;
        while (n2-- > 0) {
            if (objectArray[n2] == FREE || objectArray[n2] == REMOVED) continue;
            Object object = objectArray[n2];
            int n4 = this.insertKey(object);
            if (n4 < 0) {
                TObjectDoubleHashMap tObjectDoubleHashMap = this;
                tObjectDoubleHashMap.throwObjectContractViolation(tObjectDoubleHashMap._set[-n4 - 1], object);
            }
            this._set[n4] = object;
            this._values[n4] = dArray[n2];
        }
    }

    @Override
    public double getNoEntryValue() {
        return this.no_entry_value;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object key) {
        void var1_1;
        return this.contains(var1_1);
    }

    @Override
    public boolean containsValue(double val) {
        Object[] objectArray = this._set;
        double[] dArray = this._values;
        int n2 = this._values.length;
        while (n2-- > 0) {
            if (objectArray[n2] == FREE || objectArray[n2] == REMOVED || val != dArray[n2]) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double get(Object key) {
        void var1_1;
        int n2 = this.index(var1_1);
        if (n2 < 0) {
            return this.no_entry_value;
        }
        return this._values[n2];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double put(K key, double value) {
        void var2_3;
        void var1_1;
        int n2 = this.insertKey(var1_1);
        return this.a((double)var2_3, n2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double putIfAbsent(K key, double value) {
        void var2_3;
        void var1_1;
        int n2 = this.insertKey(var1_1);
        if (n2 < 0) {
            return this._values[-n2 - 1];
        }
        return this.a((double)var2_3, n2);
    }

    private double a(double d2, int n2) {
        double d3 = this.no_entry_value;
        boolean bl = true;
        if (n2 < 0) {
            n2 = -n2 - 1;
            d3 = this._values[n2];
            bl = false;
        }
        this._values[n2] = d2;
        if (bl) {
            TObjectDoubleHashMap tObjectDoubleHashMap = this;
            tObjectDoubleHashMap.postInsertHook(tObjectDoubleHashMap.consumeFreeSlot);
        }
        return d3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double remove(Object key) {
        void var1_1;
        double d2 = this.no_entry_value;
        int n2 = this.index(var1_1);
        if (n2 >= 0) {
            d2 = this._values[n2];
            this.removeAt(n2);
        }
        return d2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void removeAt(int index) {
        void var1_1;
        this._values[index] = this.no_entry_value;
        super.removeAt((int)var1_1);
    }

    @Override
    public void putAll(Map<? extends K, ? extends Double> map) {
        Object object = map.entrySet();
        object = object.iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            this.put(entry.getKey(), (Double)entry.getValue());
        }
    }

    @Override
    public void putAll(TObjectDoubleMap<? extends K> map) {
        map.forEachEntry(this.a);
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this._set, 0, this._set.length, FREE);
        Arrays.fill(this._values, 0, this._values.length, this.no_entry_value);
    }

    @Override
    public Set<K> keySet() {
        return new KeyView(this);
    }

    @Override
    public Object[] keys() {
        Object[] objectArray = new Object[this.size()];
        Object[] objectArray2 = this._set;
        int n2 = this._set.length;
        int n3 = 0;
        while (n2-- > 0) {
            if (objectArray2[n2] == FREE || objectArray2[n2] == REMOVED) continue;
            objectArray[n3++] = objectArray2[n2];
        }
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public K[] keys(K[] a2) {
        void var1_1;
        int n2 = this.size();
        if (a2.length < n2) {
            throw new IllegalArgumentException();
        }
        Object[] objectArray = this._set;
        int n3 = this._set.length;
        int n4 = 0;
        while (n3-- > 0) {
            if (objectArray[n3] == FREE || objectArray[n3] == REMOVED) continue;
            a2[n4++] = objectArray[n3];
        }
        return var1_1;
    }

    @Override
    public TDoubleCollection valueCollection() {
        return new TDoubleValueCollection(this);
    }

    @Override
    public double[] values() {
        double[] dArray = new double[this.size()];
        double[] dArray2 = this._values;
        Object[] objectArray = this._set;
        int n2 = dArray2.length;
        int n3 = 0;
        while (n2-- > 0) {
            if (objectArray[n2] == FREE || objectArray[n2] == REMOVED) continue;
            dArray[n3++] = dArray2[n2];
        }
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] values(double[] array) {
        void var1_1;
        int n2 = this.size();
        if (array.length < n2) {
            array = new double[n2];
        }
        double[] dArray = this._values;
        Object[] objectArray = this._set;
        int n3 = dArray.length;
        int n4 = 0;
        while (n3-- > 0) {
            if (objectArray[n3] == FREE || objectArray[n3] == REMOVED) continue;
            array[n4++] = dArray[n3];
        }
        if (array.length > n2) {
            array[n2] = this.no_entry_value;
        }
        return var1_1;
    }

    @Override
    public TObjectDoubleIterator<K> iterator() {
        TObjectDoubleHashMap tObjectDoubleHashMap = this;
        return new b(tObjectDoubleHashMap, tObjectDoubleHashMap);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean increment(K key) {
        void var1_1;
        return this.adjustValue(var1_1, 1.0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean adjustValue(K key, double amount) {
        void var2_3;
        void var1_1;
        int n2 = this.index(var1_1);
        if (n2 < 0) {
            return false;
        }
        int n3 = n2;
        this._values[n3] = this._values[n3] + var2_3;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double adjustOrPutValue(K key, double adjust_amount, double put_amount) {
        double d2;
        void var1_1;
        int n2 = this.insertKey(var1_1);
        if (n2 < 0) {
            void var2_3;
            int n3 = n2 = -n2 - 1;
            double d3 = this._values[n3] + var2_3;
            this._values[n3] = d3;
            d2 = d3;
            n2 = 0;
        } else {
            d2 = this._values[n2] = put_amount;
            n2 = 1;
        }
        if (n2 != 0) {
            TObjectDoubleHashMap tObjectDoubleHashMap = this;
            tObjectDoubleHashMap.postInsertHook(tObjectDoubleHashMap.consumeFreeSlot);
        }
        return d2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean forEachKey(TObjectProcedure<? super K> procedure) {
        void var1_1;
        return this.forEach(var1_1);
    }

    @Override
    public boolean forEachValue(TDoubleProcedure procedure) {
        Object[] objectArray = this._set;
        double[] dArray = this._values;
        int n2 = this._values.length;
        while (n2-- > 0) {
            if (objectArray[n2] == FREE || objectArray[n2] == REMOVED || procedure.execute(dArray[n2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachEntry(TObjectDoubleProcedure<? super K> procedure) {
        Object[] objectArray = this._set;
        double[] dArray = this._values;
        int n2 = objectArray.length;
        while (n2-- > 0) {
            if (objectArray[n2] == FREE || objectArray[n2] == REMOVED || procedure.execute(objectArray[n2], dArray[n2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainEntries(TObjectDoubleProcedure<? super K> procedure) {
        boolean bl = false;
        Object[] objectArray = this._set;
        double[] dArray = this._values;
        this.tempDisableAutoCompaction();
        try {
            int n2 = objectArray.length;
            while (n2-- > 0) {
                if (objectArray[n2] == FREE || objectArray[n2] == REMOVED || procedure.execute(objectArray[n2], dArray[n2])) continue;
                this.removeAt(n2);
                bl = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return bl;
    }

    @Override
    public void transformValues(TDoubleFunction func) {
        Object[] objectArray = this._set;
        double[] dArray = this._values;
        int n2 = this._values.length;
        while (n2-- > 0) {
            if (objectArray[n2] == null || objectArray[n2] == REMOVED) continue;
            dArray[n2] = func.execute(dArray[n2]);
        }
    }

    @Override
    public boolean equals(Object other) {
        TObjectDoubleMap tObjectDoubleMap;
        if (!(other instanceof TObjectDoubleMap)) {
            return false;
        }
        if ((tObjectDoubleMap = (TObjectDoubleMap)tObjectDoubleMap).size() != this.size()) {
            return false;
        }
        try {
            TObjectDoubleIterator<K> tObjectDoubleIterator = this.iterator();
            while (tObjectDoubleIterator.hasNext()) {
                tObjectDoubleIterator.advance();
                K k2 = tObjectDoubleIterator.key();
                double d2 = tObjectDoubleIterator.value();
                if (!(d2 == this.no_entry_value ? tObjectDoubleMap.get(k2) != tObjectDoubleMap.getNoEntryValue() || !tObjectDoubleMap.containsKey(k2) : d2 != tObjectDoubleMap.get(k2))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {}
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        Object[] objectArray = this._set;
        double[] dArray = this._values;
        int n3 = this._values.length;
        while (n3-- > 0) {
            if (objectArray[n3] == FREE || objectArray[n3] == REMOVED) continue;
            n2 += HashFunctions.hash(dArray[n3]) ^ (objectArray[n3] == null ? 0 : objectArray[n3].hashCode());
        }
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        this.forEachEntry(new TObjectDoubleProcedure<K>(){
            private boolean a = true;
            private /* synthetic */ StringBuilder b;
            private /* synthetic */ TObjectDoubleHashMap c;
            {
                this.c = tObjectDoubleHashMap;
                this.b = stringBuilder;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean execute(K key, double value) {
                void var2_2;
                void var1_1;
                if (this.a) {
                    this.a = false;
                } else {
                    this.b.append(",");
                }
                this.b.append(var1_1).append("=").append((double)var2_2);
                return true;
            }
        });
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    protected class KeyView
    extends a<K> {
        private /* synthetic */ TObjectDoubleHashMap a;

        /*
         * WARNING - void declaration
         */
        protected KeyView(TObjectDoubleHashMap this$0) {
            void var1_1;
            this.a = this$0;
            super((TObjectDoubleHashMap)var1_1);
        }

        @Override
        public Iterator<K> iterator() {
            return new TObjectHashIterator(this.a);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeElement(K key) {
            void var1_1;
            return this.a.no_entry_value != this.a.remove(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsElement(K key) {
            void var1_1;
            return this.a.contains(var1_1);
        }
    }

    final class TDoubleValueCollection
    implements TDoubleCollection {
        final /* synthetic */ TObjectDoubleHashMap a;

        /*
         * WARNING - void declaration
         */
        TDoubleValueCollection(TObjectDoubleHashMap this$0) {
            void var1_1;
            this.a = var1_1;
        }

        @Override
        public final TDoubleIterator iterator() {
            return new TObjectDoubleValueHashIterator(this);
        }

        @Override
        public final double getNoEntryValue() {
            return this.a.no_entry_value;
        }

        @Override
        public final int size() {
            return this.a._size;
        }

        @Override
        public final boolean isEmpty() {
            return 0 == this.a._size;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(double entry) {
            void var1_1;
            return this.a.containsValue((double)var1_1);
        }

        @Override
        public final double[] toArray() {
            return this.a.values();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final double[] toArray(double[] dest) {
            void var1_1;
            return this.a.values((double[])var1_1);
        }

        @Override
        public final boolean add(double entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean remove(double entry) {
            double[] dArray = this.a._values;
            Object[] objectArray = this.a._set;
            int n2 = dArray.length;
            while (n2-- > 0) {
                if (objectArray[n2] == TObjectHash.FREE || objectArray[n2] == TObjectHash.REMOVED || entry != dArray[n2]) continue;
                this.a.removeAt(n2);
                return true;
            }
            return false;
        }

        @Override
        public final boolean containsAll(Collection<?> collection) {
            for (Object obj : collection) {
                if (obj instanceof Double) {
                    double d2 = (Double)obj;
                    if (this.a.containsValue(d2)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public final boolean containsAll(TDoubleCollection collection) {
            TDoubleIterator tDoubleIterator = collection.iterator();
            while (tDoubleIterator.hasNext()) {
                if (this.a.containsValue(tDoubleIterator.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public final boolean containsAll(double[] array) {
            double[] dArray = array;
            int n2 = array.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                double d2 = dArray[i2];
                if (this.a.containsValue(d2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public final boolean addAll(Collection<? extends Double> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(TDoubleCollection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(double[] array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(Collection<?> collection) {
            boolean bl = false;
            TDoubleIterator tDoubleIterator = this.iterator();
            while (tDoubleIterator.hasNext()) {
                if (collection.contains(tDoubleIterator.next())) continue;
                tDoubleIterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public final boolean retainAll(TDoubleCollection collection) {
            if (this == collection) {
                return false;
            }
            boolean bl = false;
            TDoubleIterator tDoubleIterator = this.iterator();
            while (tDoubleIterator.hasNext()) {
                if (collection.contains(tDoubleIterator.next())) continue;
                tDoubleIterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public final boolean retainAll(double[] array) {
            boolean bl = false;
            Arrays.sort(array);
            double[] dArray = this.a._values;
            Object[] objectArray = this.a._set;
            int n2 = this.a._set.length;
            while (n2-- > 0) {
                if (objectArray[n2] == TObjectHash.FREE || objectArray[n2] == TObjectHash.REMOVED || Arrays.binarySearch(array, dArray[n2]) >= 0) continue;
                this.a.removeAt(n2);
                bl = true;
            }
            return bl;
        }

        @Override
        public final boolean removeAll(Collection<?> collection) {
            Iterator iterator;
            boolean bl = false;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                double d2;
                Object e2 = iterator.next();
                if (!(e2 instanceof Double) || !this.remove(d2 = ((Double)e2).doubleValue())) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public final boolean removeAll(TDoubleCollection collection) {
            TDoubleIterator tDoubleIterator;
            if (this == collection) {
                this.clear();
                return true;
            }
            boolean bl = false;
            tDoubleIterator = tDoubleIterator.iterator();
            while (tDoubleIterator.hasNext()) {
                double d2 = tDoubleIterator.next();
                if (!this.remove(d2)) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public final boolean removeAll(double[] array) {
            boolean bl = false;
            int n2 = array.length;
            while (n2-- > 0) {
                if (!this.remove(array[n2])) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public final void clear() {
            ((THash)this.a).clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean forEach(TDoubleProcedure procedure) {
            void var1_1;
            return this.a.forEachValue((TDoubleProcedure)var1_1);
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder("{");
            this.a.forEachValue(new TDoubleProcedure(){
                private boolean a = true;
                private /* synthetic */ StringBuilder b;
                private /* synthetic */ TDoubleValueCollection c;
                {
                    this.c = tDoubleValueCollection;
                    this.b = stringBuilder;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final boolean execute(double value) {
                    void var1_1;
                    if (this.a) {
                        this.a = false;
                    } else {
                        this.b.append(", ");
                    }
                    this.b.append((double)var1_1);
                    return true;
                }
            });
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        class TObjectDoubleValueHashIterator
        implements TDoubleIterator {
            protected THash _hash;
            protected int _expectedSize;
            protected int _index;
            private /* synthetic */ TDoubleValueCollection a;

            /*
             * WARNING - void declaration
             */
            TObjectDoubleValueHashIterator(TDoubleValueCollection this$1) {
                void var1_1;
                this.a = var1_1;
                this._hash = this.a.a;
                this._expectedSize = this._hash.size();
                this._index = this._hash.capacity();
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex() >= 0;
            }

            @Override
            public double next() {
                this.moveToNextIndex();
                return this.a.a._values[this._index];
            }

            @Override
            public void remove() {
                if (this._expectedSize != this._hash.size()) {
                    throw new ConcurrentModificationException();
                }
                try {
                    this._hash.tempDisableAutoCompaction();
                    this.a.a.removeAt(this._index);
                }
                finally {
                    this._hash.reenableAutoCompaction(false);
                }
                --this._expectedSize;
            }

            protected final void moveToNextIndex() {
                this._index = this.nextIndex();
                if (this._index < 0) {
                    throw new NoSuchElementException();
                }
            }

            protected final int nextIndex() {
                if (this._expectedSize != this._hash.size()) {
                    throw new ConcurrentModificationException();
                }
                Object[] objectArray = this.a.a._set;
                int n2 = this._index;
                while (n2-- > 0 && (objectArray[n2] == TObjectHash.FREE || objectArray[n2] == TObjectHash.REMOVED)) {
                }
                return n2;
            }
        }
    }

    final class b<K>
    extends TObjectHashIterator<K>
    implements TObjectDoubleIterator<K> {
        private final TObjectDoubleHashMap<K> a;
        private /* synthetic */ TObjectDoubleHashMap b;

        public b(TObjectDoubleHashMap tObjectDoubleHashMap, TObjectDoubleHashMap<K> tObjectDoubleHashMap2) {
            this.b = tObjectDoubleHashMap;
            super(tObjectDoubleHashMap2);
            this.a = tObjectDoubleHashMap2;
        }

        @Override
        public final void advance() {
            this.moveToNextIndex();
        }

        @Override
        public final K key() {
            return (K)this.a._set[this._index];
        }

        @Override
        public final double value() {
            return this.a._values[this._index];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final double setValue(double val) {
            void var1_1;
            double d2 = this.value();
            this.a._values[this._index] = var1_1;
            return d2;
        }
    }

    private abstract class a<E>
    extends AbstractSet<E>
    implements Iterable<E>,
    Set<E> {
        private /* synthetic */ TObjectDoubleHashMap a;

        private a(TObjectDoubleHashMap tObjectDoubleHashMap) {
            this.a = tObjectDoubleHashMap;
        }

        public abstract boolean removeElement(E var1);

        public abstract boolean containsElement(E var1);

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object key) {
            void var1_1;
            return this.containsElement(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o2) {
            void var1_1;
            return this.removeElement(var1_1);
        }

        @Override
        public void clear() {
            ((THash)this.a).clear();
        }

        @Override
        public boolean add(E obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            Iterator iterator = this.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                objectArray[n2] = iterator.next();
                ++n2;
            }
            return objectArray;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> T[] toArray(T[] a2) {
            void var1_1;
            int n2 = this.size();
            if (a2.length < n2) {
                throw new IllegalArgumentException();
            }
            Iterator iterator = this.iterator();
            T[] TArray = a2;
            for (int i2 = 0; i2 < n2; ++i2) {
                TArray[i2] = iterator.next();
            }
            if (a2.length > n2) {
                a2[n2] = null;
            }
            return var1_1;
        }

        @Override
        public boolean isEmpty() {
            return this.a.isEmpty();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }
    }
}

