/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.set.hash;

import gnu.trove.TIntCollection;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.THashPrimitiveIterator;
import gnu.trove.impl.hash.TIntHash;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.TIntSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class TIntHashSet
extends TIntHash
implements TIntSet {
    public TIntHashSet() {
    }

    /*
     * WARNING - void declaration
     */
    public TIntHashSet(int initialCapacity) {
        super((int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TIntHashSet(int initialCapacity, float load_factor) {
        super((int)var1_1, (float)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TIntHashSet(int initial_capacity, float load_factor, int no_entry_value) {
        super((int)var1_1, (float)var2_2, no_entry_value);
        void var2_2;
        void var1_1;
        if (no_entry_value != 0) {
            void var3_3;
            Arrays.fill(this._set, (int)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public TIntHashSet(Collection<? extends Integer> collection) {
        this(Math.max(collection.size(), 10));
        void var1_1;
        this.addAll((Collection<? extends Integer>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public TIntHashSet(TIntCollection collection) {
        this(Math.max(collection.size(), 10));
        void var1_1;
        if (collection instanceof TIntHashSet) {
            TIntHashSet tIntHashSet = (TIntHashSet)collection;
            this._loadFactor = tIntHashSet._loadFactor;
            this.no_entry_value = tIntHashSet.no_entry_value;
            if (this.no_entry_value != 0) {
                Arrays.fill(this._set, this.no_entry_value);
            }
            this.setUp((int)Math.ceil(10.0f / this._loadFactor));
        }
        this.addAll((TIntCollection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public TIntHashSet(int[] array) {
        this(Math.max(array.length, 10));
        void var1_1;
        this.addAll((int[])var1_1);
    }

    @Override
    public TIntIterator iterator() {
        TIntHashSet tIntHashSet = this;
        return new a(tIntHashSet, tIntHashSet);
    }

    @Override
    public int[] toArray() {
        int[] nArray = new int[this.size()];
        if (nArray.length == 0) {
            return nArray;
        }
        int[] nArray2 = this._set;
        byte[] byArray = this._states;
        int n2 = this._states.length;
        int n3 = 0;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            nArray[n3++] = nArray2[n2];
        }
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int[] toArray(int[] dest) {
        void var1_1;
        if (dest.length == 0) {
            return dest;
        }
        int[] nArray = this._set;
        byte[] byArray = this._states;
        int n2 = this._states.length;
        int n3 = 0;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            dest[n3++] = nArray[n2];
        }
        if (dest.length > this._size) {
            dest[this._size] = this.no_entry_value;
        }
        return var1_1;
    }

    @Override
    public boolean add(int val) {
        int n2;
        if ((n2 = this.insertKey(n2)) < 0) {
            return false;
        }
        TIntHashSet tIntHashSet = this;
        tIntHashSet.postInsertHook(tIntHashSet.consumeFreeSlot);
        return true;
    }

    @Override
    public boolean remove(int val) {
        int n2;
        if ((n2 = this.index(n2)) >= 0) {
            this.removeAt(n2);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (obj instanceof Integer) {
                int n2 = (Integer)obj;
                if (this.contains(n2)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(TIntCollection collection) {
        TIntIterator tIntIterator = collection.iterator();
        while (tIntIterator.hasNext()) {
            int n2 = tIntIterator.next();
            if (this.contains(n2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(int[] array) {
        int n2 = array.length;
        while (n2-- > 0) {
            if (this.contains(array[n2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> collection) {
        Iterator iterator;
        boolean bl = false;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            int n3 = n2;
            if (!this.add(n3)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean addAll(TIntCollection collection) {
        TIntIterator tIntIterator;
        boolean bl = false;
        tIntIterator = tIntIterator.iterator();
        while (tIntIterator.hasNext()) {
            int n2 = tIntIterator.next();
            if (!this.add(n2)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean addAll(int[] array) {
        boolean bl = false;
        int n2 = array.length;
        while (n2-- > 0) {
            if (!this.add(array[n2])) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        TIntIterator tIntIterator = this.iterator();
        while (tIntIterator.hasNext()) {
            if (collection.contains(tIntIterator.next())) continue;
            tIntIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(TIntCollection collection) {
        if (this == collection) {
            return false;
        }
        boolean bl = false;
        TIntIterator tIntIterator = this.iterator();
        while (tIntIterator.hasNext()) {
            if (collection.contains(tIntIterator.next())) continue;
            tIntIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(int[] array) {
        boolean bl = false;
        Arrays.sort(array);
        int[] nArray = this._set;
        byte[] byArray = this._states;
        this._autoCompactTemporaryDisable = true;
        int n2 = nArray.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1 || Arrays.binarySearch(array, nArray[n2]) >= 0) continue;
            this.removeAt(n2);
            bl = true;
        }
        this._autoCompactTemporaryDisable = false;
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        Iterator iterator;
        boolean bl = false;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            int n2;
            Object e2 = iterator.next();
            if (!(e2 instanceof Integer) || !this.remove(n2 = ((Integer)e2).intValue())) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(TIntCollection collection) {
        TIntIterator tIntIterator;
        boolean bl = false;
        tIntIterator = tIntIterator.iterator();
        while (tIntIterator.hasNext()) {
            int n2 = tIntIterator.next();
            if (!this.remove(n2)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(int[] array) {
        boolean bl = false;
        int n2 = array.length;
        while (n2-- > 0) {
            if (!this.remove(array[n2])) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public void clear() {
        super.clear();
        int[] nArray = this._set;
        byte[] byArray = this._states;
        int n2 = nArray.length;
        while (n2-- > 0) {
            nArray[n2] = this.no_entry_value;
            byArray[n2] = 0;
        }
    }

    @Override
    protected void rehash(int newCapacity) {
        int n2;
        int n3 = this._set.length;
        int[] nArray = this._set;
        byte[] byArray = this._states;
        this._set = new int[newCapacity];
        this._states = new byte[n2];
        n2 = n3;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            n3 = nArray[n2];
            this.insertKey(n3);
        }
    }

    @Override
    public boolean equals(Object other) {
        TIntSet tIntSet;
        if (!(other instanceof TIntSet)) {
            return false;
        }
        if ((tIntSet = (TIntSet)tIntSet).size() != this.size()) {
            return false;
        }
        int n2 = this._states.length;
        while (n2-- > 0) {
            if (this._states[n2] != 1 || tIntSet.contains(this._set[n2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        int n3 = this._states.length;
        while (n3-- > 0) {
            if (this._states[n3] != 1) continue;
            n2 += HashFunctions.hash(this._set[n3]);
        }
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder((this._size << 1) + 2);
        stringBuilder.append("{");
        int n2 = this._states.length;
        int n3 = 1;
        while (n2-- > 0) {
            if (this._states[n2] != 1) continue;
            stringBuilder.append(this._set[n2]);
            if (n3++ >= this._size) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    final class a
    extends THashPrimitiveIterator
    implements TIntIterator {
        private final TIntHash a;
        private /* synthetic */ TIntHashSet b;

        public a(TIntHashSet tIntHashSet, TIntHashSet tIntHashSet2) {
            this.b = tIntHashSet;
            super(tIntHashSet2);
            this.a = tIntHashSet2;
        }

        @Override
        public final int next() {
            this.moveToNextIndex();
            return this.a._set[this._index];
        }
    }
}

