/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

public class MathLib {
    public static final double TWO_PI = Math.PI * 2;
    public static final double LOG10 = Math.log(10.0);
    public static final double LOG2 = Math.log(2.0);

    private MathLib() {
    }

    public static double log2(double x2) {
        return Math.log(x2) / LOG2;
    }

    public static double log10(double x2) {
        return Math.log(x2) / LOG10;
    }

    public static double safeLog10(double x2) {
        double d2;
        boolean bl = x2 < 0.0;
        if (bl) {
            x2 = -x2;
        }
        if (x2 < 10.0) {
            x2 += (10.0 - x2) / 10.0;
        }
        x2 = Math.log(x2) / LOG10;
        if (bl) {
            return -x2;
        }
        return d2;
    }

    public static double safeSqrt(double x2) {
        double d2;
        if (x2 < 0.0) {
            return -Math.sqrt(-x2);
        }
        return Math.sqrt(d2);
    }
}

