/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geom;

import com.macrofocus.geom.AffineTransform;
import com.macrofocus.geom.Crossings;
import com.macrofocus.geom.PathIterator;
import com.macrofocus.geom.Point;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import java.util.Arrays;

public class Polygon
implements Shape {
    public int npoints;
    public int[] xpoints;
    public int[] ypoints;
    protected Rectangle bounds;

    public Polygon() {
        this.xpoints = new int[4];
        this.ypoints = new int[4];
    }

    /*
     * WARNING - void declaration
     */
    public Polygon(int[] xpoints, int[] ypoints, int npoints) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (npoints > xpoints.length || npoints > ypoints.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        if (npoints < 0) {
            throw new NegativeArraySizeException("npoints < 0");
        }
        this.npoints = npoints;
        this.xpoints = Arrays.copyOf((int[])var1_1, npoints);
        this.ypoints = Arrays.copyOf((int[])var2_2, (int)var3_3);
    }

    public void reset() {
        this.npoints = 0;
        this.bounds = null;
    }

    public void invalidate() {
        this.bounds = null;
    }

    /*
     * WARNING - void declaration
     */
    public void addPoint(int x, int y) {
        int n;
        if (this.npoints >= this.xpoints.length || this.npoints >= this.ypoints.length) {
            n = this.npoints << 1;
            if (n < 4) {
                n = 4;
            } else {
                int n2 = n;
                if ((n2 & n2 - 1) != 0) {
                    n = Integer.highestOneBit(n);
                }
            }
            this.xpoints = Arrays.copyOf(this.xpoints, n);
            this.ypoints = Arrays.copyOf(this.ypoints, n);
        }
        this.xpoints[this.npoints] = x;
        this.ypoints[this.npoints] = y;
        ++this.npoints;
        if (this.bounds != null) {
            void var1_1;
            void var2_3;
            n = var2_3;
            var2_3 = var1_1;
            Polygon polygon = this;
            if (var2_3 < polygon.bounds.x) {
                polygon.bounds.width += polygon.bounds.x - var2_3;
                polygon.bounds.x = var2_3;
            } else {
                polygon.bounds.width = Math.max(polygon.bounds.width, (int)(var2_3 - polygon.bounds.x));
            }
            if (n < polygon.bounds.y) {
                polygon.bounds.height += polygon.bounds.y - n;
                polygon.bounds.y = n;
                return;
            }
            polygon.bounds.height = Math.max(polygon.bounds.height, n - polygon.bounds.y);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(Point p) {
        void var1_1;
        return this.contains(p.x, var1_1.y);
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(int x, int y) {
        void var2_2;
        void var1_1;
        return this.contains((double)var1_1, (double)var2_2);
    }

    /*
     * Unable to fully structure code
     */
    public boolean contains(double x, double y) {
        if (this.npoints <= 2 || !this.getBoundingBox().contains(x, y)) {
            return false;
        }
        var5_3 = 0;
        var6_4 = this.xpoints[this.npoints - 1];
        var7_5 = this.ypoints[this.npoints - 1];
        for (var10_6 = 0; var10_6 < this.npoints; ++var10_6) {
            block8: {
                block11: {
                    block12: {
                        block10: {
                            block9: {
                                var8_7 = this.xpoints[var10_6];
                                var9_8 = this.ypoints[var10_6];
                                if (var9_8 == var7_5) break block8;
                                if (var8_7 >= var6_4) break block9;
                                if (x >= (double)var6_4) break block8;
                                var11_9 = var8_7;
                                break block10;
                            }
                            if (x >= (double)var8_7) break block8;
                            var11_9 = var6_4;
                        }
                        if (var9_8 >= var7_5) break block11;
                        if (y < (double)var9_8 || y >= (double)var7_5) break block8;
                        if (!(x < (double)var11_9)) break block12;
                        ++var5_3;
                        break block8;
                    }
                    var12_10 = x - (double)var8_7;
                    var14_11 = y - (double)var9_8;
                    ** GOTO lbl34
                }
                if (y < (double)var7_5 || y >= (double)var9_8) break block8;
                if (x < (double)var11_9) {
                    ++var5_3;
                } else {
                    var12_10 = x - (double)var6_4;
                    var14_11 = y - (double)var7_5;
lbl34:
                    // 2 sources

                    if (var12_10 < var14_11 / (double)(var7_5 - var9_8) * (double)(var6_4 - var8_7)) {
                        ++var5_3;
                    }
                }
            }
            var6_4 = var8_7;
            var7_5 = var9_8;
        }
        return (var5_3 & true) != false;
    }

    @Deprecated
    public Rectangle2D getBoundingBox() {
        if (this.npoints == 0) {
            return new Rectangle();
        }
        if (this.bounds == null) {
            Polygon polygon = this;
            int n = this.npoints;
            int[] nArray = this.ypoints;
            int[] nArray2 = polygon.xpoints;
            Polygon polygon2 = polygon;
            int n2 = Integer.MAX_VALUE;
            int n3 = Integer.MAX_VALUE;
            int n4 = Integer.MIN_VALUE;
            int n5 = Integer.MIN_VALUE;
            for (int i = 0; i < n; ++i) {
                int n6 = nArray2[i];
                n2 = Math.min(n2, n6);
                n4 = Math.max(n4, n6);
                n6 = nArray[i];
                n3 = Math.min(n3, n6);
                n5 = Math.max(n5, n6);
            }
            polygon2.bounds = new Rectangle(n2, n3, n4 - n2, n5 - n3);
        }
        return this.bounds.getBounds2D();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean inside(int x, int y) {
        void var2_2;
        void var1_1;
        return this.contains((double)var1_1, (double)var2_2);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getBoundingBox();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(Point2D p) {
        void var1_1;
        return this.contains(p.getX(), var1_1.getY());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean intersects(Rectangle2D r) {
        void var1_1;
        return this.intersects(r.getX(), r.getY(), r.getWidth(), var1_1.getHeight());
    }

    /*
     * WARNING - void declaration
     */
    public boolean intersects(double x, double y, double w, double h2) {
        void var3_3;
        void var1_1;
        if (this.npoints <= 0 || !this.getBoundingBox().intersects(x, y, w, h2)) {
            return false;
        }
        Crossings.EvenOdd evenOdd = this.a(x, y, (double)(var1_1 + w), (double)(var3_3 + h2));
        return evenOdd == null || !evenOdd.isEmpty();
    }

    private Crossings.EvenOdd a(double d2, double d3, double d4, double d5) {
        Crossings.EvenOdd evenOdd = new Crossings.EvenOdd(d2, d3, d4, d5);
        int n = this.xpoints[this.npoints - 1];
        int n2 = this.ypoints[this.npoints - 1];
        for (int i = 0; i < this.npoints; ++i) {
            int n3 = this.xpoints[i];
            int n4 = this.ypoints[i];
            if (evenOdd.accumulateLine(n, n2, n3, n4)) {
                return null;
            }
            n = n3;
            n2 = n4;
        }
        return evenOdd;
    }

    @Override
    public PathIterator getPathIterator() {
        return this.getPathIterator(null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        void var1_1;
        return new a(this, (AffineTransform)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PathIterator getFlattenPathIterator(double flatness) {
        void var1_1;
        return this.getPathIterator(null, (double)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        void var1_1;
        return this.getPathIterator((AffineTransform)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(Rectangle2D r) {
        void var1_1;
        return this.contains(r.getX(), r.getY(), r.getWidth(), var1_1.getHeight());
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(double x, double y, double w, double h2) {
        void var1_1;
        if (this.npoints <= 0 || !this.getBoundingBox().intersects(x, y, w, h2)) {
            return false;
        }
        Crossings.EvenOdd evenOdd = this.a(x, y, (double)(var1_1 + w), y + h2);
        if (evenOdd != null) {
            void var3_3;
            void v0 = var3_3;
            if (((Crossings)evenOdd).covers((double)v0, (double)(v0 + h2))) {
                return true;
            }
        }
        return false;
    }

    static final class a
    implements PathIterator {
        private Polygon a;
        private AffineTransform b;
        private int c;

        public a(Polygon polygon, AffineTransform affineTransform) {
            this.a = polygon;
            this.b = affineTransform;
            if (polygon.npoints == 0) {
                this.c = 1;
            }
        }

        @Override
        public final int getWindingRule() {
            return 0;
        }

        @Override
        public final boolean isDone() {
            return this.c > this.a.npoints;
        }

        @Override
        public final void next() {
            ++this.c;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int currentSegment(float[] coords) {
            if (this.c >= this.a.npoints) {
                return 4;
            }
            coords[0] = this.a.xpoints[this.c];
            coords[1] = this.a.ypoints[this.c];
            if (this.b != null) {
                void var1_1;
                this.b.transform(coords, 0, (float[])var1_1, 0, 1);
            }
            if (this.c == 0) {
                return 0;
            }
            return 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int currentSegment(double[] coords) {
            if (this.c >= this.a.npoints) {
                return 4;
            }
            coords[0] = this.a.xpoints[this.c];
            coords[1] = this.a.ypoints[this.c];
            if (this.b != null) {
                void var1_1;
                this.b.transform(coords, 0, (double[])var1_1, 0, 1);
            }
            if (this.c == 0) {
                return 0;
            }
            return 1;
        }
    }
}

