/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geom.curve;

import com.macrofocus.geom.curve.BSpline;
import com.macrofocus.geom.curve.ControlPath;
import com.macrofocus.geom.curve.GroupIterator;
import com.macrofocus.geom.curve.MultiPath;
import com.macrofocus.geom.curve.ValueVector;

public class NURBSpline
extends BSpline {
    private static double[] d = new double[0];
    private static double[] e = new double[0];
    private ValueVector f = new ValueVector(new double[]{1.0, 1.0, 1.0, 1.0}, 4);
    private boolean g = true;

    /*
     * WARNING - void declaration
     */
    public NURBSpline(ControlPath cp, GroupIterator gi) {
        super((ControlPath)var1_1, (GroupIterator)var2_2);
        void var2_2;
        void var1_1;
    }

    public ValueVector getWeightVector() {
        return this.f;
    }

    /*
     * WARNING - void declaration
     */
    public void setWeightVector(ValueVector v) {
        void var1_1;
        assert (v != null) : "Weight-vector cannot be null.";
        this.f = var1_1;
    }

    public boolean getUseWeightVector() {
        return this.g;
    }

    /*
     * WARNING - void declaration
     */
    public void setUseWeightVector(boolean b2) {
        void var1_1;
        this.g = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void appendTo(MultiPath mp) {
        void var1_1;
        if (!this.b.isInRange(0, this.a.numPoints())) {
            return;
        }
        int n = this.b.getGroupSize();
        if (d.length < n) {
            d = new double[2 * n];
            e = new double[2 * n];
        }
        if (this.g) {
            if (this.f.size() != n) {
                return;
            }
            for (int i = 0; i < n; ++i) {
                NURBSpline.e[i] = this.f.get(i);
                if (!(e[i] < 0.0)) continue;
                return;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                NURBSpline.e[i] = 1.0;
            }
        }
        super.appendTo((MultiPath)var1_1);
    }

    @Override
    protected void eval(double[] p) {
        int n;
        int n2 = p.length - 1;
        double d2 = p[n2];
        double d3 = 0.0;
        int n3 = this.b.getGroupSize();
        for (n = 0; n < n3; ++n) {
            NURBSpline.d[n] = this.a(d2, n) * e[n];
            d3 += d[n];
        }
        if (d3 == 0.0) {
            d3 = 1.0;
        }
        for (n = 0; n < n2; ++n) {
            this.b.set(0, 0);
            double d4 = 0.0;
            for (int i = 0; i < n3; ++i) {
                d4 += d[i] * this.a.getPoint(this.b.next()).getLocation()[n];
            }
            p[n] = d4 / d3;
        }
    }

    @Override
    public void resetMemory() {
        super.resetMemory();
        if (d.length > 0) {
            d = new double[0];
            e = new double[0];
        }
    }
}

