/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.treemap.CombinationGenerator;
import com.treemap.Function;
import com.treemap.PermutationGenerator;
import com.treemap.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Itertools {
    public static Iterable<Integer> count(final int start, final int step) {
        return () -> new Iterator<Integer>(){
            int a;
            {
                this.a = start - step;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            public Integer a() {
                this.a += step;
                return this.a;
            }

            @Override
            public /* synthetic */ Object next() {
                return this.a();
            }
        };
    }

    public static Iterable<Integer> count(int start) {
        return Itertools.count(start, 1);
    }

    public static <T> Iterable<T> cycle(final List<T> list) {
        return () -> new Iterator<T>(){
            int a = -1;

            @Override
            public boolean hasNext() {
                ++this.a;
                return true;
            }

            @Override
            public T next() {
                this.a %= list.size();
                return list.get(this.a);
            }
        };
    }

    public static <T> Iterable<T> repeat(final T t2, final int n2) {
        return () -> new Iterator<T>(){
            int a = -1;

            @Override
            public boolean hasNext() {
                ++this.a;
                return this.a < n2;
            }

            @Override
            public T next() {
                return t2;
            }
        };
    }

    public static <T> Iterable<T> repeat(final T t2) {
        return () -> new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T next() {
                return t2;
            }
        };
    }

    public static <T> Iterable<T> chain(final List<T> ... iterables) {
        int n2 = 0;
        for (List<T> list : iterables) {
            n2 += list.size();
        }
        final int n3 = n2;
        return () -> new Iterator<T>(){
            int a = -1;
            int b = 0;
            int c = 0;

            @Override
            public boolean hasNext() {
                ++this.a;
                return this.a < n3;
            }

            @Override
            public T next() {
                int n2 = this.a - this.c;
                while (n2 >= iterables[this.b].size()) {
                    this.c += iterables[this.b].size();
                    n2 = this.a - this.c;
                    ++this.b;
                }
                return iterables[this.b].get(n2);
            }
        };
    }

    public static <T> Iterable<T> compress(final List<T> data, final List<Boolean> selectors) {
        return () -> new Iterator<T>(){
            int a = -1;

            @Override
            public boolean hasNext() {
                ++this.a;
                while (this.a < data.size() && !((Boolean)selectors.get(this.a)).booleanValue()) {
                    ++this.a;
                }
                return this.a < data.size();
            }

            @Override
            public T next() {
                return data.get(this.a);
            }
        };
    }

    public static <T> Iterable<T> dropWhile(final Predicate<T> pred, final List<T> seq) {
        return () -> new Iterator<T>(){
            boolean a = false;
            int b = -1;

            @Override
            public boolean hasNext() {
                ++this.b;
                while (!this.a && this.b < seq.size() && pred.pred(seq.get(this.b))) {
                    ++this.b;
                }
                this.a = true;
                return this.b < seq.size();
            }

            @Override
            public T next() {
                return seq.get(this.b);
            }
        };
    }

    public static <T> Iterable<T> ifilter(final Predicate<T> predicate, final List<T> list) {
        return () -> new Iterator<T>(){
            int a = -1;

            @Override
            public boolean hasNext() {
                ++this.a;
                while (this.a < list.size() && !predicate.pred(list.get(this.a))) {
                    ++this.a;
                }
                return this.a < list.size();
            }

            @Override
            public T next() {
                return list.get(this.a);
            }
        };
    }

    public static <T> Iterable<T> ifilterfalse(final Predicate<T> predicate, final List<T> list) {
        return () -> new Iterator<T>(){
            int a = -1;

            @Override
            public boolean hasNext() {
                ++this.a;
                while (this.a < list.size() && predicate.pred(list.get(this.a))) {
                    ++this.a;
                }
                return this.a < list.size();
            }

            @Override
            public T next() {
                return list.get(this.a);
            }
        };
    }

    public static <T> Iterable<T> islice(final List<T> seq, final int start, final int stop, final int step) {
        return () -> new Iterator<T>(){
            int a;
            {
                this.a = start - step;
            }

            @Override
            public boolean hasNext() {
                this.a += step;
                return this.a < seq.size() && this.a < stop && this.a >= start;
            }

            @Override
            public T next() {
                return seq.get(this.a);
            }
        };
    }

    public static <T> Iterable<T> islice(List<T> seq, int stop, int step) {
        return Itertools.islice(seq, 0, stop, step);
    }

    public static <T> Iterable<T> islice(List<T> seq, int stop) {
        return Itertools.islice(seq, 0, stop, 1);
    }

    public static <T, U> Iterable<U> imap(final Function<T, U> f2, final List<T> ... lists) {
        return () -> new Iterator<U>(){
            int a = -1;

            @Override
            public boolean hasNext() {
                ++this.a;
                return this.a < lists[0].size();
            }

            @Override
            public U next() {
                ArrayList arrayList = new ArrayList();
                for (int i2 = 0; i2 < lists.length; ++i2) {
                    arrayList.add(lists[i2].get(this.a));
                }
                return f2.apply(arrayList);
            }
        };
    }

    public static <T> Iterable<T> takeWhile(final Predicate<T> pred, final List<T> seq) {
        return () -> new Iterator<T>(){
            boolean a = false;
            int b = -1;

            @Override
            public boolean hasNext() {
                ++this.b;
                while (!this.a && this.b < seq.size() && !pred.pred(seq.get(this.b))) {
                    ++this.b;
                }
                this.a = true;
                return this.b < seq.size();
            }

            @Override
            public T next() {
                return seq.get(this.b);
            }
        };
    }

    public static <T> Iterable<List<T>> izip(final List<T> ... lists) {
        int n2 = lists[0].size();
        for (List<T> list : lists) {
            if (list.size() >= n2) continue;
            n2 = list.size();
        }
        final int n3 = n2;
        return () -> new Iterator<List<T>>(){
            int a = -1;

            @Override
            public boolean hasNext() {
                ++this.a;
                return this.a < n3;
            }

            public List<T> a() {
                ArrayList arrayList = new ArrayList();
                for (List list : lists) {
                    arrayList.add(list.get(this.a));
                }
                return arrayList;
            }

            @Override
            public /* synthetic */ Object next() {
                return this.a();
            }
        };
    }

    public static <T> Iterable<List<T>> izipLongest(final T fillValue, final List<T> ... lists) {
        int n2 = lists[0].size();
        for (List<T> list : lists) {
            if (list.size() <= n2) continue;
            n2 = list.size();
        }
        final int n3 = n2;
        return () -> new Iterator<List<T>>(){
            int a = -1;

            @Override
            public boolean hasNext() {
                ++this.a;
                return this.a < n3;
            }

            public List<T> a() {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (List list : lists) {
                    if (this.a < list.size()) {
                        arrayList.add(list.get(this.a));
                        continue;
                    }
                    arrayList.add(fillValue);
                }
                return arrayList;
            }

            @Override
            public /* synthetic */ Object next() {
                return this.a();
            }
        };
    }

    public static <T> Iterable<List<T>> product(final List<T> ... lists) {
        int n2 = 1;
        final int[] nArray = new int[lists.length];
        for (int i2 = 0; i2 < lists.length; ++i2) {
            nArray[i2] = lists[i2].size();
        }
        final int[] nArray2 = new int[lists.length];
        Arrays.fill(nArray2, 1);
        for (List<T> list : lists) {
            n2 *= list.size();
        }
        final int n3 = n2;
        return () -> new Iterator<List<T>>(){
            int a = -1;
            int[] b;

            @Override
            public boolean hasNext() {
                ++this.a;
                return this.a < n3;
            }

            public List<T> a() {
                this.b = this.a == 0 ? nArray2 : PermutationGenerator.generateNextProduct(this.b, nArray);
                ArrayList arrayList = new ArrayList();
                for (int i2 = 0; i2 < this.b.length; ++i2) {
                    arrayList.add(lists[i2].get(this.b[i2] - 1));
                }
                return arrayList;
            }

            @Override
            public /* synthetic */ Object next() {
                return this.a();
            }
        };
    }

    public static <T> Iterable<List<T>> combinations(final List<T> list, final int r2) {
        return new Iterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return new Iterator<List<T>>(){
                    int a = -1;
                    int b;
                    int[] c;
                    {
                        this.b = (int)CombinationGenerator.nCr(list.size(), r2);
                        this.c = new int[r2];
                    }

                    @Override
                    public boolean hasNext() {
                        ++this.a;
                        return this.a < this.b;
                    }

                    public List<T> a() {
                        if (this.a == 0) {
                            for (int i2 = 0; i2 < this.c.length; ++i2) {
                                this.c[i2] = i2 + 1;
                            }
                        } else {
                            this.c = CombinationGenerator.generateNextCombination(this.c, list.size(), r2);
                        }
                        ArrayList arrayList = new ArrayList();
                        for (int n2 : this.c) {
                            arrayList.add(list.get(n2 - 1));
                        }
                        return arrayList;
                    }

                    @Override
                    public /* synthetic */ Object next() {
                        return this.a();
                    }
                };
            }
        };
    }

    public static <T> Iterable<List<T>> permutations(final List<T> list, final int r2) {
        final long l2 = (long)PermutationGenerator.a(r2);
        final long l3 = (long)CombinationGenerator.nCr(list.size(), r2) * l2;
        return new Iterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return new Iterator<List<T>>(){
                    int a = -1;
                    int b = 0;
                    int[] c;
                    int[] d;
                    {
                        this.c = new int[r2];
                        this.d = new int[r2];
                    }

                    @Override
                    public boolean hasNext() {
                        ++this.a;
                        return (long)this.a < l3;
                    }

                    public List<T> a() {
                        int n2;
                        if (this.a == 0) {
                            this.b = 0;
                            for (n2 = 0; n2 < this.d.length; ++n2) {
                                this.d[n2] = n2 + 1;
                                this.c[n2] = n2 + 1;
                            }
                        } else if ((long)(this.b + 1) % l2 == 0L) {
                            ++this.b;
                            this.d = CombinationGenerator.generateNextCombination(this.d, list.size(), r2);
                            for (n2 = 0; n2 < this.d.length; ++n2) {
                                this.c[n2] = n2 + 1;
                            }
                        } else {
                            ++this.b;
                            this.c = PermutationGenerator.generateNextPermutation(this.c, r2);
                        }
                        ArrayList arrayList = new ArrayList();
                        for (int i2 = 0; i2 < r2; ++i2) {
                            arrayList.add(list.get(this.d[this.c[i2] - 1] - 1));
                        }
                        return arrayList;
                    }

                    @Override
                    public /* synthetic */ Object next() {
                        return this.a();
                    }
                };
            }
        };
    }
}

