/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.tagcloud;

import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.SimpleProperties;
import com.macrofocus.geom.AffineTransform;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.igraphics.CPFontFactory;
import com.treemap.AbstractAlgorithm;
import com.treemap.DefaultTreeMapFieldSettings;
import com.treemap.MutableTreeMapNode;
import com.treemap.TreeMapWorker;
import com.treemap.tagcloud.ArchimedeanSpiral;
import com.treemap.tagcloud.DefaultWord;
import com.treemap.tagcloud.Orientation;
import com.treemap.tagcloud.Point2d;
import com.treemap.tagcloud.PositionIterator;
import com.treemap.tagcloud.TagCloudAlgorithm;
import com.treemap.tagcloud.TextShape;
import com.treemap.tagcloud.TextShapeFactory;
import com.treemap.tagcloud.Word;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class AbstractTagCloudAlgorithm<Font>
extends AbstractAlgorithm
implements TagCloudAlgorithm {
    public static final String PROPERTY_FONT = "font";
    public static final String PROPERTY_ORIENTATIONMODE = "orientationMode";
    public static final String PROPERTY_SPIRAL = "spiral";
    private final List<Word> a = new ArrayList<Word>();
    private Word b;
    private final TextShapeFactory<Font> c;
    private int d = 500;
    private int e = 6;
    private final MutableProperties f = new SimpleProperties();
    private final MutableProperty<CPFont<Font>> g;
    private final MutableProperty<TagCloudAlgorithm.OrientationMode> h = this.f.createProperty((Object)"orientationMode", (Object)TagCloudAlgorithm.OrientationMode.AllHorizontal);
    private final MutableProperty<TagCloudAlgorithm.Spiral> i = this.f.createProperty((Object)"spiral", (Object)TagCloudAlgorithm.Spiral.Rectangular);

    public AbstractTagCloudAlgorithm(TextShapeFactory textShapeFactory, CPFontFactory<Font> fontFactory) {
        this.c = textShapeFactory;
        this.g = this.f.createProperty((Object)PROPERTY_FONT, DefaultTreeMapFieldSettings.getDefaultLabelingFont(fontFactory));
    }

    public AbstractTagCloudAlgorithm(TextShapeFactory textShapeFactory, CPFontFactory<Font> fontFactory, TagCloudAlgorithm.OrientationMode orientationMode, TagCloudAlgorithm.Spiral spiral, CPFont<Font> font) {
        this(textShapeFactory, fontFactory);
        this.h.setValue((Object)orientationMode);
        this.i.setValue((Object)spiral);
        this.g.setValue(font);
    }

    @Override
    public MutableProperties getProperties() {
        return this.f;
    }

    @Override
    public boolean breadthFirstLayout(Shape shape, MutableTreeMapNode parent, MutableTreeMapNode[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, TreeMapWorker worker) {
        Object object;
        Object object2;
        long l2 = System.currentTimeMillis();
        this.a.clear();
        ArrayList<Word> arrayList = new ArrayList<Word>();
        Random random = new Random(1L);
        if (this.g.getValue() != null) {
            // empty if block
        }
        int n2 = Math.min(this.d, children.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl;
            if (worker != null && worker.isCancelled()) {
                return true;
            }
            object2 = children[i2];
            object = object2.toString();
            switch ((TagCloudAlgorithm.OrientationMode)((Object)this.h.getValue())) {
                case AllHorizontal: {
                    bl = false;
                    break;
                }
                case HorizontalAndVertical: {
                    bl = random.nextBoolean();
                    break;
                }
                default: {
                    bl = false;
                }
            }
            Orientation orientation = bl ? Orientation.Vertical : Orientation.Horizontal;
            double d2 = object2.getSize() / sumSizes;
            this.a.add(new DefaultWord(this.c, (String)object, d2, (MutableTreeMapNode)object2, orientation, this.e, (CPFont)this.g.getValue()));
        }
        if (worker != null && worker.isCancelled()) {
            return true;
        }
        Collections.sort(this.a);
        Collections.reverse(this.a);
        ArchimedeanSpiral archimedeanSpiral = null;
        switch ((TagCloudAlgorithm.Spiral)((Object)this.i.getValue())) {
            case Archimedean: {
                archimedeanSpiral = new ArchimedeanSpiral(this.a.get(this.a.size() - 1).getShapeForLayout().getBounds2D().getHeight() * 0.05);
                break;
            }
            case Rectangular: {
                archimedeanSpiral = null;
            }
        }
        object2 = new Point2d(0.0, 0.0);
        object = new PositionIterator(shape);
        double d3 = 0.0;
        this.b = null;
        int n3 = 0;
        for (Word word : this.a) {
            if (worker != null && worker.isCancelled()) {
                return true;
            }
            double d4 = word.getShapeForLayout().getBounds2D().getWidth();
            double d5 = word.getShapeForLayout().getBounds2D().getHeight();
            double d6 = Math.min(d4, d5);
            double d7 = Math.max(d4, d5);
            d3 = Math.max(d7, d3);
            double d8 = d7 / 10.0;
            d8 = Math.max(d8, d3 / 20.0);
            ((PositionIterator)object).resetIterator(d8);
            double d9 = Math.PI * 2;
            int n4 = 0;
            boolean bl = false;
            while (this.newWordIntersectsPlacedWords(word, arrayList)) {
                if (archimedeanSpiral != null) {
                    archimedeanSpiral.get(d9, (Point2d)object2);
                    double d10 = 2.0 * archimedeanSpiral.getRadius(d9);
                    double d11 = 0.5 / d10 * 2.0;
                    d9 += d11;
                } else {
                    if (n4 > 100) {
                        ((PositionIterator)object).doubleStepSize();
                        n4 = 0;
                    }
                    ((PositionIterator)object).getNextPosition((Point2d)object2);
                }
                word.setLocation((Point2d)object2);
                ++n3;
            }
            arrayList.add(word);
            ++n3;
        }
        for (MutableTreeMapNode mutableTreeMapNode : children) {
            mutableTreeMapNode.setShape(null);
        }
        this.a(shape, arrayList);
        return false;
    }

    private void a(Shape shape, List<Word> list) {
        Rectangle2D.Double double_ = null;
        for (Word word : list) {
            Rectangle2D rectangle2D = word.getShapeForLayout().getBounds2D();
            if (double_ != null) {
                double_ = double_.add(rectangle2D);
                continue;
            }
            double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        double d2 = rectangle2D.getWidth() / rectangle2D.getHeight();
        double d3 = double_.getWidth() / double_.getHeight();
        double d4 = d3 > d2 ? rectangle2D.getWidth() / double_.getWidth() : rectangle2D.getHeight() / double_.getHeight();
        double d5 = rectangle2D.getWidth() - double_.getWidth() * d4;
        double d6 = rectangle2D.getHeight() - double_.getHeight() * d4;
        Point2d point2d = new Point2d(rectangle2D.getX() - double_.getX() * d4 + d5 / 2.0, rectangle2D.getY() - double_.getY() * d4 + d6 / 2.0);
        for (Word word : list) {
            Shape shape2 = this.getShape(point2d, d4, word.getShapeForLayout());
            word.getTreeMapNode().setShape(shape2);
        }
    }

    public Shape getShape(Point2d offsetAbsolute, double scale, TextShape shape) {
        AffineTransform affineTransform = new AffineTransform(scale, 0.0, 0.0, scale, offsetAbsolute.x, offsetAbsolute.y);
        return shape.createTransformedShape(affineTransform);
    }

    public boolean newWordIntersectsPlacedWords(Word word, List<Word> placedWords) {
        if (this.b != null && word.intersects(this.b)) {
            return true;
        }
        for (Word word2 : placedWords) {
            if (word2 == this.b || !word.intersects(word2)) continue;
            this.b = word2;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCompatible(Shape shape) {
        return shape instanceof Rectangle2D;
    }

    @Override
    public boolean isRenderingLeafLabelsSupported() {
        return false;
    }

    @Override
    public boolean isRenderingParentLabelSupported() {
        return false;
    }

    @Override
    public int getMaxTags() {
        return this.d;
    }

    @Override
    public void setMaxTags(int maxTags) {
        this.d = maxTags;
    }

    @Override
    public int getnSubdivisions() {
        return this.e;
    }

    @Override
    public void setnSubdivisions(int nSubdivisions) {
        this.e = nSubdivisions;
    }

    @Override
    public Font getFont() {
        return (Font)((CPFont)this.g.getValue()).getNativeFont();
    }

    @Override
    public TagCloudAlgorithm.Spiral getSpiral() {
        return (TagCloudAlgorithm.Spiral)((Object)this.i.getValue());
    }

    @Override
    public TagCloudAlgorithm.OrientationMode getOrientationMode() {
        return (TagCloudAlgorithm.OrientationMode)((Object)this.h.getValue());
    }

    @Override
    public boolean isSpaceFilling() {
        return false;
    }

    public String toString() {
        return "Tag Cloud";
    }
}

