/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.treeplot;

import com.macrofocus.common.geom.Dimension;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.labeling.EnhancedLabel;
import com.treemap.DefaultTreeMapTooltipRenderer;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.crossplatform.TGraphics;
import com.treemap.treeplot.TreePlotModel;
import com.treemap.treeplot.TreePlotView;
import java.util.concurrent.Future;
import javax.swing.JComponent;

public class ToolTipTreePlotRenderer<N, Row, Column, Color, Font> {
    final EnhancedLabel<Color, Font> a = new EnhancedLabel();

    public ToolTipTreePlotRenderer() {
        this.a.setInsets(DefaultTreeMapTooltipRenderer.DEFAULT_BORDER.top, DefaultTreeMapTooltipRenderer.DEFAULT_BORDER.left, DefaultTreeMapTooltipRenderer.DEFAULT_BORDER.bottom, DefaultTreeMapTooltipRenderer.DEFAULT_BORDER.right);
    }

    public void paint(TGraphics<Color, Font> g2, TreePlotView<JComponent, N, Row, Column, Color, Font> view, N node, int width, int leftShift, int topShift, Future progress) {
        Shape shape;
        TreePlotModel<N, Row, Column, Color, Font> treePlotModel = view.getModel();
        if (node != null && (shape = view.getRenderedShape(node)) != null) {
            this.drawToolTip(g2, view, treePlotModel, node, width, leftShift, topShift, true);
        }
    }

    public Rectangle drawToolTip(TGraphics<Color, Font> g2, TreePlotView<JComponent, N, Row, Column, Color, Font> view, TreePlotModel<N, Row, Column, Color, Font> model, N node, int width, int leftShift, int topShift, boolean paint) {
        Rectangle rectangle = model.getSettings().getToolTipTreeMapFields();
        if (rectangle != null && ((TreeMapField[])rectangle).length >= 0) {
            Object object;
            CPFont<Font> cPFont;
            Object object2;
            int n2 = 0;
            boolean bl = false;
            for (TreeMapField treeMapField : rectangle) {
                if (!treeMapField.isValid()) continue;
                TreeMapFieldSettings<Color, Font> treeMapFieldSettings = view.getModel().getSettings().getFieldSettings(treeMapField);
                Rectangle rectangle2 = view.getTooltipRenderer().getTooltipRendererComponent(view, treeMapField, treeMapFieldSettings, node, new Dimension(width, 1000));
                if (rectangle2 == null) continue;
                object2 = view.getHeadless().sizeLabel((EnhancedLabel<Color, Font>)rectangle2, g2, width, 1000);
                cPFont = treeMapFieldSettings.getTooltipFont();
                object = cPFont.deriveFontWeight(CPFont.Weight.BOLD);
                rectangle2.setFont((CPFont)object);
                rectangle2.setForeground(treeMapFieldSettings.getTooltipForeground());
                rectangle2.setBackground(null);
                n2 = (int)((double)n2 + object2.getPreferredHeight());
            }
            Rectangle rectangle3 = new Rectangle(0, 0, width, n2);
            if (n2 <= 0) {
                return null;
            }
            int n3 = rectangle3.y;
            for (Rectangle rectangle2 : rectangle) {
                Rectangle rectangle4;
                if (!rectangle2.isValid()) continue;
                object2 = view.getModel().getSettings().getFieldSettings((TreeMapField)rectangle2);
                cPFont = view.getTooltipRenderer().getTooltipRendererComponent(view, (TreeMapField<N, Column>)rectangle2, (TreeMapFieldSettings<Color, Font>)object2, node, new Dimension(width, 1000));
                object = view.getHeadless().sizeLabel((EnhancedLabel<Color, Font>)cPFont, g2, rectangle3.width, rectangle3.height);
                if (cPFont == null) continue;
                CPFont cPFont2 = object2.getTooltipFont();
                CPFont cPFont3 = cPFont2.deriveFontWeight(CPFont.Weight.BOLD);
                cPFont.setFont(cPFont3);
                cPFont.setForeground(object2.getTooltipForeground());
                cPFont.setBackground(null);
                Dimension dimension = object.getPreferredSize();
                if (n3 + dimension.height > rectangle3.y + rectangle3.height) break;
                int n4 = rectangle3.x + 2;
                int n5 = rectangle3.width - 2 - 1;
                if (model.getSettings().getFieldSettings((TreeMapField)rectangle2).getShowLabel()) {
                    this.a.setFont(cPFont2);
                    this.a.setForeground(object2.getTooltipForeground());
                    this.a.setBackground(null);
                    this.a.setText(rectangle2.getName() + ": ");
                    rectangle4 = view.getHeadless().sizeLabel(this.a, g2, width, 1000).getPreferredSize();
                    if (rectangle4.width + dimension.width > n5) {
                        rectangle4.width = Math.max(0, n5 - dimension.width);
                    }
                    Rectangle rectangle5 = new Rectangle(n4, n3, rectangle4.width, rectangle4.height);
                    if (paint && g2 != null) {
                        g2.paintLabel(this.a, rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height);
                    }
                    if (view.getModel().isNumericType((TreeMapField<N, Column>)rectangle2)) {
                        n4 += rectangle4.width;
                        n5 -= rectangle4.width;
                    } else {
                        n4 += rectangle4.width;
                        n5 -= rectangle4.width;
                    }
                }
                rectangle4 = new Rectangle(n4, n3, n5, dimension.height);
                if (paint && g2 != null) {
                    g2.paintLabel((EnhancedLabel<Color, Font>)cPFont, rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                }
                n3 += dimension.height;
            }
            return rectangle3;
        }
        return null;
    }
}

