/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.javafx;

import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.crossplatform.CPComboBox;
import com.macrofocus.crossplatform.javafx.AbstractJavaFXComponent;
import com.macrofocus.format.CPFormat;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class JFXComboBox<E>
extends AbstractJavaFXComponent<Node>
implements CPComboBox<Node, E> {
    private final com.jfoenix.controls.JFXComboBox<E> nativeComponent = new com.jfoenix.controls.JFXComboBox();

    public JFXComboBox() {
        this.nativeComponent.setMaxWidth(Double.POSITIVE_INFINITY);
    }

    public JFXComboBox(MutableSingleSelection<E> selection, Iterable<E> values) {
        this();
        this.setModel(selection, values);
    }

    public void setModel(final MutableSingleSelection<E> selection, Iterable<E> values) {
        for (E value : values) {
            this.nativeComponent.getItems().add(value);
        }
        this.nativeComponent.getSelectionModel().select(selection.getSelected());
        this.nativeComponent.getSelectionModel().selectedItemProperty().addListener(new ChangeListener<E>(){

            public void changed(ObservableValue<? extends E> observable, E oldValue, E newValue) {
                selection.setSelected(newValue);
            }
        });
        selection.addSingleSelectionListener(new SingleSelectionListener<E>(){

            public void selectionChanged(SingleSelectionEvent<E> event) {
                JFXComboBox.this.nativeComponent.getSelectionModel().select(event.getCurrentSelection());
            }
        });
    }

    public void setFormat(final CPFormat<E> format) {
        this.nativeComponent.setConverter(new StringConverter<E>(){

            public String toString(E object) {
                return format.formatHtml(object, false);
            }

            public E fromString(String string) {
                try {
                    return format.parse(string);
                }
                catch (CPFormat.ParsingException e) {
                    return null;
                }
            }
        });
    }

    public void setEnabled(boolean enabled) {
        this.nativeComponent.setDisable(!enabled);
    }

    public void setRenderer(final CPComboBox.ItemRenderer<Node, E> itemRenderer) {
        this.nativeComponent.setCellFactory(new Callback<ListView<E>, ListCell<E>>(){

            public ListCell<E> call(ListView<E> param) {
                return new ListCell<E>(){

                    protected void updateItem(E item, boolean empty) {
                        super.updateItem(item, empty);
                        this.setGraphic((Node)itemRenderer.render(item).getNativeComponent());
                    }
                };
            }
        });
    }

    public ComboBox getNativeComponent() {
        return this.nativeComponent;
    }
}

