/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.javafx;

import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.SimpleProperty;
import com.macrofocus.crossplatform.CPCheckBox;
import com.macrofocus.crossplatform.javafx.AbstractJavaFXComponent;
import com.macrofocus.crossplatform.javafx.property.JavaFXPropertyHelper;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;

public class JavaFXCheckBox
extends AbstractJavaFXComponent<Node>
implements CPCheckBox<Node> {
    private final CheckBox nativeComponent;
    private MutableProperty<Boolean> allowIndeterminate = new SimpleProperty((Object)Boolean.FALSE);
    private MutableProperty<Boolean> indeterminate = new SimpleProperty((Object)Boolean.FALSE);
    private MutableProperty<Boolean> selected = new SimpleProperty((Object)Boolean.FALSE);
    private JavaFXPropertyHelper.BindRegistration registration;

    public JavaFXCheckBox(String label, MutableProperty<Boolean> on) {
        this.nativeComponent = label != null ? new CheckBox(label) : new CheckBox();
        JavaFXPropertyHelper.bindBidirectional(this.allowIndeterminate, this.nativeComponent.allowIndeterminateProperty());
        JavaFXPropertyHelper.bindBidirectional(this.indeterminate, this.nativeComponent.indeterminateProperty());
        this.setProperty(this.selected);
    }

    public JavaFXCheckBox(MutableProperty<Boolean> on) {
        this(null, on);
    }

    public MutableProperty<Boolean> allowIndeterminateProperty() {
        return this.allowIndeterminate;
    }

    public MutableProperty<Boolean> indeterminateProperty() {
        return this.indeterminate;
    }

    public MutableProperty<Boolean> selectedProperty() {
        return this.selected;
    }

    public CPCheckBox.State getState() {
        if (this.nativeComponent.isAllowIndeterminate() && this.nativeComponent.isIndeterminate()) {
            return CPCheckBox.State.Undefined;
        }
        if (this.nativeComponent.isSelected()) {
            return CPCheckBox.State.Checked;
        }
        return CPCheckBox.State.Unchecked;
    }

    public void setState(CPCheckBox.State state) {
        switch (state) {
            case Checked: {
                this.nativeComponent.setSelected(true);
                this.nativeComponent.setIndeterminate(false);
                break;
            }
            case Unchecked: {
                this.nativeComponent.setSelected(false);
                this.nativeComponent.setIndeterminate(false);
                break;
            }
            case Undefined: {
                this.nativeComponent.setAllowIndeterminate(true);
                this.nativeComponent.setIndeterminate(true);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.nativeComponent.setDisable(!enabled);
    }

    public void setProperty(MutableProperty<Boolean> on) {
        if (this.registration != null) {
            this.registration.removeHandler();
            this.registration = null;
        }
        this.selected = on;
        if (on != null) {
            this.registration = JavaFXPropertyHelper.bindBidirectional(on, this.nativeComponent.selectedProperty());
        }
    }

    public Node getNativeComponent() {
        return this.nativeComponent;
    }
}

