/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.javafx;

import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.crossplatform.CPCheckBoxList;
import com.macrofocus.crossplatform.javafx.AbstractJavaFXComponent;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import org.controlsfx.control.CheckListView;

public class JavaFXCheckBoxList<E>
extends AbstractJavaFXComponent<Node>
implements CPCheckBoxList<Node, E> {
    private final CheckListView<E> nativeComponent = new CheckListView();

    public JavaFXCheckBoxList(final MutableSingleSelection<E> selection, final MutableSelection<E> checks, Iterable<E> values) {
        this.nativeComponent.setMaxWidth(Double.POSITIVE_INFINITY);
        for (E value : values) {
            this.nativeComponent.getItems().add(value);
        }
        this.nativeComponent.getSelectionModel().select(selection.getSelected());
        this.nativeComponent.getSelectionModel().selectedItemProperty().addListener(new ChangeListener<E>(){

            public void changed(ObservableValue<? extends E> observable, E oldValue, E newValue) {
                selection.setSelected(newValue);
            }
        });
        selection.addSingleSelectionListener(new SingleSelectionListener<E>(){

            public void selectionChanged(SingleSelectionEvent<E> event) {
                JavaFXCheckBoxList.this.nativeComponent.getSelectionModel().select(event.getCurrentSelection());
            }
        });
        for (Object e : checks) {
            this.nativeComponent.getCheckModel().check(e);
        }
        this.nativeComponent.getCheckModel().getCheckedItems().addListener(new ListChangeListener<E>(){

            public void onChanged(ListChangeListener.Change<? extends E> c) {
                checks.setSelectedIterable((Iterable)JavaFXCheckBoxList.this.nativeComponent.getCheckModel().getCheckedItems());
            }
        });
        checks.addSelectionListener(new SelectionListener<E>(){

            public void selectionChanged(SelectionEvent<E> event) {
            }
        });
        this.nativeComponent.prefHeightProperty().setValue((Number)80);
    }

    public ListView getNativeComponent() {
        return this.nativeComponent;
    }
}

