/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.javafx;

import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.crossplatform.CPComboBox;
import com.macrofocus.crossplatform.javafx.AbstractJavaFXComponent;
import com.macrofocus.format.CPFormat;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class JavaFXComboBox<E>
extends AbstractJavaFXComponent<Node>
implements CPComboBox<Node, E> {
    private final ComboBox<E> nativeComponent;
    private MutableSingleSelection<E> selection;
    private final ChangeListener<E> changeListener = new ChangeListener<E>(){

        public void changed(ObservableValue<? extends E> observable, E oldValue, E newValue) {
            JavaFXComboBox.this.selection.setSelected(newValue);
        }
    };
    private final SingleSelectionListener<E> selectionListener = new SingleSelectionListener<E>(){

        public void selectionChanged(SingleSelectionEvent<E> event) {
            JavaFXComboBox.this.nativeComponent.getSelectionModel().select(event.getCurrentSelection());
        }
    };

    public JavaFXComboBox() {
        this.nativeComponent = new ComboBox();
        this.nativeComponent.setMaxWidth(Double.POSITIVE_INFINITY);
    }

    public JavaFXComboBox(MutableSingleSelection<E> selection, Iterable<E> values) {
        this();
        this.setModel(selection, values);
    }

    public void setModel(MutableSingleSelection<E> selection, Iterable<E> values) {
        if (this.selection != null) {
            this.selection.removeSingleSelectionListener(this.selectionListener);
            this.nativeComponent.getSelectionModel().selectedItemProperty().removeListener(this.changeListener);
        }
        this.nativeComponent.getItems().clear();
        for (E value : values) {
            this.nativeComponent.getItems().add(value);
        }
        this.nativeComponent.getSelectionModel().select(selection.getSelected());
        this.selection = selection;
        if (this.selection != null) {
            selection.addSingleSelectionListener(this.selectionListener);
            this.nativeComponent.getSelectionModel().selectedItemProperty().addListener(this.changeListener);
        }
    }

    public void setFormat(final CPFormat<E> format) {
        this.nativeComponent.setConverter(new StringConverter<E>(){

            public String toString(E object) {
                return format.formatHtml(object, false);
            }

            public E fromString(String string) {
                try {
                    return format.parse(string);
                }
                catch (CPFormat.ParsingException e) {
                    return null;
                }
            }
        });
    }

    public void setEnabled(boolean enabled) {
        this.nativeComponent.disableProperty().setValue(Boolean.valueOf(!enabled));
    }

    public void setRenderer(final CPComboBox.ItemRenderer<Node, E> itemRenderer) {
        ListCell listCell = new ListCell<E>(){

            protected void updateItem(E item, boolean empty) {
                super.updateItem(item, empty);
                this.setGraphic((Node)itemRenderer.render(item).getNativeComponent());
            }
        };
        this.nativeComponent.setButtonCell(listCell);
        this.nativeComponent.setCellFactory(new Callback<ListView<E>, ListCell<E>>(){

            public ListCell<E> call(ListView<E> param) {
                ListCell listCell = new ListCell<E>(){

                    protected void updateItem(E item, boolean empty) {
                        super.updateItem(item, empty);
                        this.setGraphic((Node)itemRenderer.render(item).getNativeComponent());
                    }
                };
                return listCell;
            }
        });
    }

    public ComboBox getNativeComponent() {
        return this.nativeComponent;
    }
}

