/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.javafx;

import com.macrofocus.common.interval.IntervalEvent;
import com.macrofocus.common.interval.IntervalListener;
import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.properties.SimpleProperty;
import com.macrofocus.crossplatform.CPSpinner;
import com.macrofocus.crossplatform.javafx.AbstractJavaFXComponent;
import com.macrofocus.format.CPFormat;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;

public class JavaFXDoubleSpinner
extends AbstractJavaFXComponent<Node>
implements CPSpinner<Node, Double> {
    private final Spinner<Double> nativeComponent = new Spinner();
    private BindRegistration registration;

    public JavaFXDoubleSpinner() {
        this.setProperty((MutableProperty<Double>)new SimpleProperty((Object)0.0));
    }

    public JavaFXDoubleSpinner(MutableProperty<Double> value) {
        this();
        this.setProperty(value);
    }

    public JavaFXDoubleSpinner(MutableBoundedInterval interval) {
        this();
        this.setBoundedInterval(interval);
    }

    public void setProperty(final MutableProperty<Double> property) {
        if (this.registration != null) {
            this.registration.removeHandler();
            this.registration = null;
        }
        if (property != null) {
            this.nativeComponent.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(-1.7976931348623157E308, Double.MAX_VALUE, ((Double)property.getValue()).doubleValue()));
            ChangeListener<Double> changeListener = new ChangeListener<Double>(){

                public void changed(ObservableValue observable, Double oldValue, Double newValue) {
                    property.setValue((Object)newValue);
                }
            };
            this.nativeComponent.getValueFactory().valueProperty().addListener((ChangeListener)changeListener);
            PropertyListener<Double> propertyListener = new PropertyListener<Double>(){

                public void propertyChanged(PropertyEvent<Double> event) {
                    JavaFXDoubleSpinner.this.nativeComponent.getValueFactory().setValue((Object)((Double)property.getValue()));
                }
            };
            property.addPropertyListener((PropertyListener)propertyListener);
            this.registration = new BindRegistration(){
                final /* synthetic */ PropertyListener val$propertyListener;
                final /* synthetic */ ChangeListener val$changeListener;
                {
                    this.val$propertyListener = propertyListener;
                    this.val$changeListener = changeListener;
                }

                @Override
                public void removeHandler() {
                    property.removePropertyListener(this.val$propertyListener);
                    JavaFXDoubleSpinner.this.nativeComponent.getValueFactory().valueProperty().removeListener(this.val$changeListener);
                }
            };
        }
        this.nativeComponent.setEditable(property != null);
    }

    public void setBoundedInterval(final MutableBoundedInterval interval) {
        if (this.registration != null) {
            this.registration.removeHandler();
            this.registration = null;
        }
        if (interval != null) {
            this.nativeComponent.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(interval.getMinimum(), interval.getMaximum(), interval.getStart()));
            ChangeListener<Double> changeListener = new ChangeListener<Double>(){

                public void changed(ObservableValue observable, Double oldValue, Double newValue) {
                    interval.setStart(newValue.doubleValue());
                }
            };
            this.nativeComponent.getValueFactory().valueProperty().addListener((ChangeListener)changeListener);
            final IntervalListener intervalListener = new IntervalListener(){

                public void intervalChanged(IntervalEvent event) {
                    JavaFXDoubleSpinner.this.nativeComponent.getValueFactory().setValue((Object)interval.getStart());
                }
            };
            interval.addIntervalListener(intervalListener);
            this.registration = new BindRegistration(){
                final /* synthetic */ ChangeListener val$changeListener;
                {
                    this.val$changeListener = changeListener;
                }

                @Override
                public void removeHandler() {
                    interval.removeIntervalListener(intervalListener);
                    JavaFXDoubleSpinner.this.nativeComponent.getValueFactory().valueProperty().removeListener(this.val$changeListener);
                }
            };
        }
        this.nativeComponent.setEditable(interval != null);
    }

    public void setValue(Double value) {
        this.nativeComponent.getValueFactory().setValue((Object)value);
    }

    public void setFormat(final CPFormat format) {
        this.nativeComponent.getValueFactory().setConverter((StringConverter)new DoubleStringConverter(){

            public Double fromString(String value) {
                if (format != null) {
                    try {
                        return (Double)format.parse(value);
                    }
                    catch (CPFormat.ParsingException e) {
                        return super.fromString(value);
                    }
                }
                return super.fromString(value);
            }

            public String toString(Double value) {
                if (format != null) {
                    return format.formatHtml((Object)value, false);
                }
                return super.toString(value);
            }
        });
    }

    public void setEnabled(boolean enabled) {
        this.nativeComponent.setDisable(!enabled);
    }

    public void setMinimum(Comparable minimum) {
    }

    public void setMaximum(Comparable minimum) {
    }

    public Node getNativeComponent() {
        return this.nativeComponent;
    }

    public static interface BindRegistration {
        public void removeHandler();
    }
}

