/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.javafx;

import com.macrofocus.common.command.Command;
import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.crossplatform.AbsoluteCPContainer;
import com.macrofocus.crossplatform.AbstractCPFactory;
import com.macrofocus.crossplatform.CPBorderPanel;
import com.macrofocus.crossplatform.CPButton;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPCheckBox;
import com.macrofocus.crossplatform.CPCheckBoxList;
import com.macrofocus.crossplatform.CPCollapsibleHeader;
import com.macrofocus.crossplatform.CPColorButton;
import com.macrofocus.crossplatform.CPColorPicker;
import com.macrofocus.crossplatform.CPComboBox;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPExpandablePanel;
import com.macrofocus.crossplatform.CPFillMiddlePanel;
import com.macrofocus.crossplatform.CPFontPicker;
import com.macrofocus.crossplatform.CPFormPanel;
import com.macrofocus.crossplatform.CPGridPanel;
import com.macrofocus.crossplatform.CPHeader;
import com.macrofocus.crossplatform.CPHeaderPanel;
import com.macrofocus.crossplatform.CPHorizontalFlowPanel;
import com.macrofocus.crossplatform.CPHorizontalPanel;
import com.macrofocus.crossplatform.CPLabel;
import com.macrofocus.crossplatform.CPMenuButton;
import com.macrofocus.crossplatform.CPOverlayPanel;
import com.macrofocus.crossplatform.CPPopupMenu;
import com.macrofocus.crossplatform.CPRadioButton;
import com.macrofocus.crossplatform.CPRadioButtons;
import com.macrofocus.crossplatform.CPRectangle;
import com.macrofocus.crossplatform.CPSlider;
import com.macrofocus.crossplatform.CPSpinner;
import com.macrofocus.crossplatform.CPSplitMenuButton;
import com.macrofocus.crossplatform.CPSplitPanel;
import com.macrofocus.crossplatform.CPSwitch;
import com.macrofocus.crossplatform.CPTabPanel;
import com.macrofocus.crossplatform.CPTree;
import com.macrofocus.crossplatform.CPTreeModel;
import com.macrofocus.crossplatform.CPVerticalFillMiddlePanel;
import com.macrofocus.crossplatform.CPVerticalFlowPanel;
import com.macrofocus.crossplatform.CPVerticalPanel;
import com.macrofocus.crossplatform.Layout;
import com.macrofocus.crossplatform.javafx.AbstractJavaFXComponent;
import com.macrofocus.crossplatform.javafx.JavaFXAbsoluteContainer;
import com.macrofocus.crossplatform.javafx.JavaFXButton;
import com.macrofocus.crossplatform.javafx.JavaFXCanvas;
import com.macrofocus.crossplatform.javafx.JavaFXCheckBox;
import com.macrofocus.crossplatform.javafx.JavaFXCheckBoxList;
import com.macrofocus.crossplatform.javafx.JavaFXCoalescingTimer;
import com.macrofocus.crossplatform.javafx.JavaFXCollapsibleHeader;
import com.macrofocus.crossplatform.javafx.JavaFXColorButton;
import com.macrofocus.crossplatform.javafx.JavaFXColorPicker;
import com.macrofocus.crossplatform.javafx.JavaFXComboBox;
import com.macrofocus.crossplatform.javafx.JavaFXDoubleSpinner;
import com.macrofocus.crossplatform.javafx.JavaFXExpandablePanel;
import com.macrofocus.crossplatform.javafx.JavaFXFillMiddlePanel;
import com.macrofocus.crossplatform.javafx.JavaFXFontPicker;
import com.macrofocus.crossplatform.javafx.JavaFXFormPanel;
import com.macrofocus.crossplatform.javafx.JavaFXGridPanel;
import com.macrofocus.crossplatform.javafx.JavaFXHeader;
import com.macrofocus.crossplatform.javafx.JavaFXHeaderPanel;
import com.macrofocus.crossplatform.javafx.JavaFXHorizontalFlowPanel;
import com.macrofocus.crossplatform.javafx.JavaFXHorizontalPanel;
import com.macrofocus.crossplatform.javafx.JavaFXIntegerSpinner;
import com.macrofocus.crossplatform.javafx.JavaFXLabel;
import com.macrofocus.crossplatform.javafx.JavaFXMenuButton;
import com.macrofocus.crossplatform.javafx.JavaFXOverlayPanel;
import com.macrofocus.crossplatform.javafx.JavaFXPopupMenu;
import com.macrofocus.crossplatform.javafx.JavaFXRadioButton;
import com.macrofocus.crossplatform.javafx.JavaFXRadioButtons;
import com.macrofocus.crossplatform.javafx.JavaFXRectangle;
import com.macrofocus.crossplatform.javafx.JavaFXSlider;
import com.macrofocus.crossplatform.javafx.JavaFXSplitMenuButton;
import com.macrofocus.crossplatform.javafx.JavaFXSwitch;
import com.macrofocus.crossplatform.javafx.JavaFXTabPanel;
import com.macrofocus.crossplatform.javafx.JavaFXTree;
import com.macrofocus.crossplatform.javafx.JavaFXVerticalFillMiddlePanel;
import com.macrofocus.crossplatform.javafx.JavaFXVerticalFlowPanel;
import com.macrofocus.crossplatform.javafx.JavaFXVerticalPanel;
import com.macrofocus.crossplatform.javafx.JavaFXVerticalSplitPanel;
import com.macrofocus.format.FormatFactory;
import com.macrofocus.format.javafx.JavaFXFormatFactory;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.igraphics.CPIcon;
import com.macrofocus.igraphics.javafx.JavaFXColor;
import com.macrofocus.igraphics.javafx.JavaFXFont;
import com.macrofocus.timer.CPTimer;
import java.awt.Image;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;

public class JavaFXFactory
extends AbstractCPFactory<Node, Font, Rectangle, Color> {
    private static JavaFXFactory ourInstance = new JavaFXFactory();

    public static JavaFXFactory getInstance() {
        return ourInstance;
    }

    protected JavaFXFactory() {
    }

    public <C extends Node> CPOverlayPanel<Node, C> createOverlayPanel(CPComponent<C> component) {
        return new JavaFXOverlayPanel<C>(component);
    }

    public <C extends Node> CPOverlayPanel<Node, C> createOverlayPanel() {
        return new JavaFXOverlayPanel();
    }

    public AbsoluteCPContainer<Node, Rectangle> createAbsoluteContainer(Layout layout) {
        return new JavaFXAbsoluteContainer(layout);
    }

    public CPFillMiddlePanel<Node> createFillMiddlePanel() {
        return new JavaFXFillMiddlePanel();
    }

    public CPVerticalFillMiddlePanel<Node> createVerticalFillMiddlePanel() {
        return new JavaFXVerticalFillMiddlePanel();
    }

    public CPHorizontalPanel<Node> createHorizontalPanel() {
        return new JavaFXHorizontalPanel();
    }

    public CPVerticalPanel<Node> createVerticalPanel() {
        return new JavaFXVerticalPanel();
    }

    public CPHorizontalFlowPanel<Node> createHorizontalFlowPanel(CPComponent<Node> ... components) {
        return new JavaFXHorizontalFlowPanel(components);
    }

    public CPVerticalFlowPanel<Node> createVerticalFlowPanel(CPComponent<Node> ... components) {
        return new JavaFXVerticalFlowPanel(components);
    }

    public CPHeaderPanel<Node> createHeaderPanel() {
        return new JavaFXHeaderPanel();
    }

    public CPBorderPanel<Node> createBorderPanel() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public CPFormPanel<Node> createFormPanel() {
        return new JavaFXFormPanel();
    }

    public CPGridPanel<Node> createGridPanel(int rows, int columns, CPComponent<Node>[] components) {
        return new JavaFXGridPanel(rows, columns, components);
    }

    public CPExpandablePanel<Node> createExpandablePanel(CPComponent<Node> header, CPComponent<Node> content) {
        return new JavaFXExpandablePanel(header, content);
    }

    public CPSplitPanel<Node> createHorizontalSplitPanel() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public CPSplitPanel<Node> createVerticalSplitPanel() {
        return new JavaFXVerticalSplitPanel();
    }

    public CPTabPanel<Node> createTabPanel() {
        return new JavaFXTabPanel();
    }

    public <C extends Node> CPComponent<C> createComponent(final C c) {
        return new AbstractJavaFXComponent<C>(){

            public C getNativeComponent() {
                return c;
            }
        };
    }

    public CPLabel<Node, Font> createLabel(String text) {
        return new JavaFXLabel(text);
    }

    public CPHeader<Node> createHeader(String text) {
        return new JavaFXHeader(text);
    }

    public CPCollapsibleHeader<Node> createCollapsibleHeader(String text, MutableProperty<Boolean> collapsedProperty) {
        return new JavaFXCollapsibleHeader(text);
    }

    public CPButton<Node> createButton(String text) {
        return new JavaFXButton(text);
    }

    public CPButton<Node> createButton(Property<String> text) {
        return new JavaFXButton((String)text.getValue());
    }

    public CPMenuButton<Node> createMenuButton() {
        return new JavaFXMenuButton();
    }

    public CPSplitMenuButton<Node> createSplitMenuButton() {
        return new JavaFXSplitMenuButton();
    }

    public CPColorButton<Node, Color> createColorButton(CPColor<Color> color, Command command) {
        return new JavaFXColorButton(color, command);
    }

    public <E> CPComboBox<Node, E> createComboBox() {
        return new JavaFXComboBox();
    }

    public <E> CPComboBox<Node, E> createComboBox(MutableSingleSelection<E> selection, Iterable<E> values) {
        return new JavaFXComboBox<E>(selection, values);
    }

    public <E> CPRadioButtons<Node, E> createRadioButtons(Iterable<E> values) {
        return new JavaFXRadioButtons<E>(values);
    }

    public <E> CPRadioButtons<Node, E> createRadioButtons(MutableSingleSelection<E> selection, Iterable<E> values) {
        return new JavaFXRadioButtons<E>(selection, values);
    }

    public <E> CPCheckBoxList<Node, E> createCheckBoxList(MutableSingleSelection<E> selection, MutableSelection<E> checks, Iterable<E> values) {
        return new JavaFXCheckBoxList<E>(selection, checks, values);
    }

    public CPCheckBox<Node> createCheckBox(String label, MutableProperty<Boolean> on) {
        return new JavaFXCheckBox(label, on);
    }

    public CPCheckBox<Node> createCheckBox(MutableProperty<Boolean> on) {
        return new JavaFXCheckBox(on);
    }

    public CPRadioButton<Node> createRadioButton(MutableProperty<Boolean> on) {
        return new JavaFXRadioButton(on);
    }

    public CPSwitch<Node> createSwitch() {
        return new JavaFXSwitch();
    }

    public CPSwitch<Node> createSwitch(MutableProperty<Boolean> on) {
        return new JavaFXSwitch(on);
    }

    public CPSpinner<Node, Integer> createIntegerSpinner() {
        return new JavaFXIntegerSpinner();
    }

    public CPSpinner<Node, Integer> createIntegerSpinner(MutableProperty<Integer> value) {
        return new JavaFXIntegerSpinner(value);
    }

    public CPSpinner<Node, Double> createDoubleSpinner() {
        return new JavaFXDoubleSpinner();
    }

    public CPSpinner<Node, Double> createDoubleSpinner(MutableProperty<Double> value) {
        return new JavaFXDoubleSpinner(value);
    }

    public CPSpinner<Node, Double> createDoubleSpinner(MutableBoundedInterval interval) {
        return new JavaFXDoubleSpinner(interval);
    }

    public CPSlider<Node> createSlider() {
        return new JavaFXSlider();
    }

    public CPSlider<Node> createSlider(MutableBoundedInterval interval) {
        return new JavaFXSlider(interval);
    }

    public CPColorPicker<Node, Color> createColorPicker() {
        return new JavaFXColorPicker();
    }

    public CPColorPicker<Node, Color> createColorPicker(MutableProperty<CPColor<Color>> color) {
        return new JavaFXColorPicker(color);
    }

    public CPFontPicker<Node, Font> createFontPicker() {
        return new JavaFXFontPicker();
    }

    public CPFontPicker<Node, Font> createFontPicker(MutableProperty<CPFont<Font>> font) {
        return new JavaFXFontPicker(font);
    }

    public CPCanvas<Node> createCanvas() {
        return new JavaFXCanvas();
    }

    public <N> CPTree<Node, Color, N> createTree(CPTreeModel<N> model) {
        return new JavaFXTree<N>(model);
    }

    public CPPopupMenu<Node> createPopupMenu() {
        return new JavaFXPopupMenu();
    }

    public CPFont<Font> createFont(String family, int style, int size) {
        return new JavaFXFont(family, style, size);
    }

    public CPFont<Font> createFontFamily(String family) {
        Font font = Font.font((String)family);
        if (font != null) {
            return new JavaFXFont(font);
        }
        return null;
    }

    public CPFont<Font> createDefaultFont() {
        return this.createFontFamily("Arial");
    }

    public CPRectangle createRectangle(int x, int y, int width, int height) {
        return new JavaFXRectangle(x, y, width, height);
    }

    public CPColor<Color> createRGBAColor(int r, int g, int b, int a) {
        return new JavaFXColor(r, g, b, a);
    }

    public CPColor<Color> createColor(int rgba) {
        return new JavaFXColor(rgba >> 16 & 0xFF, rgba >> 8 & 0xFF, rgba >> 0 & 0xFF, rgba >> 24 & 0xFF);
    }

    public CPColor<Color> createNativeColor(Object color) {
        if (color instanceof Color) {
            return new JavaFXColor((Color)color);
        }
        return null;
    }

    public ExecutorService newFixedThreadPool(final String name, int corePoolSize, int maximumPoolSize) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 20L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            final ThreadGroup group = System.getSecurityManager() != null ? System.getSecurityManager().getThreadGroup() : Thread.currentThread().getThreadGroup();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(this.group, r, name, 0L);
                if (t.isDaemon()) {
                    t.setDaemon(false);
                }
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                return t;
            }
        });
    }

    public CPTimer createTimer(String name, int delay, boolean postponing) {
        return new JavaFXCoalescingTimer(name, delay, postponing);
    }

    public void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean isAssignableFrom(Class a, Class b) {
        return a.isAssignableFrom(b);
    }

    public boolean isNumericType(Class type) {
        return type != null && (this.isAssignableFrom(Number.class, type) || type == Double.TYPE || type == Integer.TYPE || type == Float.TYPE || type == Short.TYPE || type == Long.TYPE);
    }

    public boolean isTemporalType(Class type) {
        return type != null && (this.isAssignableFrom(Date.class, type) || this.isAssignableFrom(Calendar.class, type) || type == Double.TYPE || type == Long.TYPE);
    }

    public boolean isVisualType(Class type) {
        return type != null && (this.isAssignableFrom(CPColor.class, type) || this.isAssignableFrom(CPIcon.class, type) || this.isAssignableFrom(Image.class, type));
    }

    public FormatFactory getFormatFactory() {
        return JavaFXFormatFactory.getInstance();
    }

    public Class getNativeColorClass() {
        return Color.class;
    }
}

