/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.javafx.fontpicker;

import com.macrofocus.crossplatform.javafx.fontpicker.FontPicker;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Spinner;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.RowConstraints;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.util.StringConverter;

public class FontPickerContent
extends GridPane {
    private Font newFont;
    private Label previewLabel;
    private ComboBox<String> fontComboBox;
    private Spinner<Number> sizeSpinner;
    private CheckBox boldCheckBox;
    private CheckBox italicCheckBox;
    private FontPicker fontPicker;

    public FontPickerContent(FontPicker fontPicker) {
        this.fontPicker = fontPicker;
        this.getStyleClass().add((Object)"font-picker-popup");
        this.initGui();
    }

    private void initGui() {
        this.setPrefSize(200.0, 230.0);
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("font-picker.css").toExternalForm());
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(40.0), new ColumnConstraints(160.0)});
        this.getRowConstraints().addAll((Object[])new RowConstraints[]{new RowConstraints(20.0), new RowConstraints(35.0), new RowConstraints(35.0), new RowConstraints(35.0), new RowConstraints(30.0), new RowConstraints(30.0), new RowConstraints(30.0)});
        this.add((Node)new Label("Preview:"), 0, 0, 2, 1);
        this.previewLabel = new Label("ABCDEF abcdef 0123456");
        this.previewLabel.setMaxWidth(Double.MAX_VALUE);
        this.previewLabel.setMaxHeight(Double.MAX_VALUE);
        this.previewLabel.getStyleClass().add((Object)"preview-label");
        this.add((Node)this.previewLabel, 0, 1, 2, 2);
        this.add((Node)new Label("Font:"), 0, 3, 1, 1);
        List families = Font.getFamilies();
        this.fontComboBox = new ComboBox(FXCollections.observableList((List)families));
        this.fontComboBox.setMaxWidth(Double.MAX_VALUE);
        this.add((Node)this.fontComboBox, 1, 3, 1, 1);
        this.add((Node)new Label("Size:"), 0, 4, 1, 1);
        this.sizeSpinner = new Spinner(1.0, 100.0, this.fontPicker.getValue() != null ? ((Font)this.fontPicker.getValue()).getSize() : 12.0);
        this.sizeSpinner.setEditable(true);
        this.sizeSpinner.setPrefWidth(70.0);
        this.add((Node)this.sizeSpinner, 1, 4, 1, 1);
        this.add((Node)new Label("Style:"), 0, 5, 1, 1);
        this.boldCheckBox = new CheckBox("Bold");
        this.italicCheckBox = new CheckBox("Italic");
        HBox styleHBox = new HBox(10.0);
        styleHBox.setAlignment(Pos.CENTER_LEFT);
        styleHBox.getChildren().addAll((Object[])new Node[]{this.boldCheckBox, this.italicCheckBox});
        this.add((Node)styleHBox, 1, 5, 1, 1);
        Button okButton = new Button("OK");
        okButton.setPrefWidth(55.0);
        Button cancelButton = new Button("Cancel");
        cancelButton.setPrefWidth(55.0);
        HBox buttonsHBox = new HBox(5.0);
        buttonsHBox.setAlignment(Pos.CENTER_RIGHT);
        buttonsHBox.getChildren().addAll((Object[])new Node[]{okButton, cancelButton});
        this.add((Node)buttonsHBox, 1, 6, 1, 1);
        if (this.fontPicker.getValue() != null) {
            this.fontComboBox.getSelectionModel().select((Object)((Font)this.fontPicker.getValue()).getName());
        } else {
            this.fontComboBox.getSelectionModel().select(0);
        }
        this.fontComboBox.valueProperty().addListener(observable -> this.changeFont());
        this.fontComboBox.setCellFactory(listView -> {
            ListCell<String> cell = new ListCell<String>(){

                public void updateItem(String item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (item != null) {
                        this.setText(item);
                        this.setFont(new Font(item, 12.0));
                    }
                }
            };
            cell.setPrefWidth(120.0);
            return cell;
        });
        StringConverter<Number> spinnerFormatter = new StringConverter<Number>(){

            public Number fromString(String val) {
                String oldVal = String.valueOf(FontPickerContent.this.sizeSpinner.getValue());
                try {
                    int result = Integer.parseInt(val);
                    if (result >= 1 && result <= 100) {
                        return result;
                    }
                    throw new Exception("");
                }
                catch (Exception e) {
                    FontPickerContent.this.sizeSpinner.getEditor().setText(oldVal);
                    return (Number)FontPickerContent.this.sizeSpinner.getValue();
                }
            }

            public String toString(Number val) {
                return val.toString();
            }
        };
        this.sizeSpinner.getValueFactory().setConverter((StringConverter)spinnerFormatter);
        this.sizeSpinner.valueProperty().addListener(observable -> this.changeFont());
        this.boldCheckBox.selectedProperty().addListener(observable -> this.changeFont());
        this.italicCheckBox.selectedProperty().addListener(observable -> this.changeFont());
        okButton.setOnAction(event -> {
            this.fontPicker.setValue(this.newFont);
            this.fontPicker.hide();
        });
        cancelButton.setOnAction(event -> this.fontPicker.hide());
        this.changeFont();
    }

    private void changeFont() {
        Font font;
        FontWeight weight = this.boldCheckBox.isSelected() ? FontWeight.BOLD : FontWeight.NORMAL;
        FontPosture posture = this.italicCheckBox.isSelected() ? FontPosture.ITALIC : FontPosture.REGULAR;
        double size = ((Number)this.sizeSpinner.getValue()).doubleValue();
        String family = (String)this.fontComboBox.getValue();
        this.newFont = font = Font.font((String)family, (FontWeight)weight, (FontPosture)posture, (double)size);
        this.previewLabel.setFont(font);
    }

    public void updateSelection(Font font) {
        this.newFont = font;
        this.previewLabel.setFont(font);
    }
}

