/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.javafx.fontpicker;

import com.macrofocus.crossplatform.javafx.fontpicker.FontPicker;
import com.macrofocus.crossplatform.javafx.fontpicker.FontPickerContent;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.skin.ComboBoxPopupControl;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import javafx.util.StringConverter;

public class FontPickerSkin
extends ComboBoxPopupControl<Font> {
    private FontPicker fontPicker;
    private final Label displayNode;
    private FontPickerContent popupContent;

    public FontPickerSkin(FontPicker control) {
        super((ComboBoxBase)control);
        control.onMousePressedProperty().set((Object)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                FontPickerSkin.this.fontPicker.show();
            }
        });
        this.fontPicker = control;
        this.registerChangeListener((ObservableValue)control.valueProperty(), e -> this.updateFont());
        this.displayNode = new Label("");
        this.displayNode.getStyleClass().add((Object)"font-label");
        this.displayNode.setManaged(false);
        this.updateFont();
    }

    private void updateFont() {
        FontPicker fontPicker = (FontPicker)this.getSkinnable();
        Font font = (Font)fontPicker.getValue();
        String fontText = font.getFamily() + ", " + font.getStyle() + ", " + (int)font.getSize();
        this.displayNode.setText(fontText);
    }

    protected Node getPopupContent() {
        if (this.popupContent == null) {
            this.popupContent = new FontPickerContent(this.fontPicker);
        }
        return this.popupContent;
    }

    public void show() {
        super.show();
        FontPicker fontPicker = (FontPicker)this.getSkinnable();
        this.popupContent.updateSelection((Font)fontPicker.getValue());
    }

    protected TextField getEditor() {
        return null;
    }

    protected StringConverter<Font> getConverter() {
        return null;
    }

    public Node getDisplayNode() {
        return this.displayNode;
    }
}

