/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.javafx.layer;

import com.macrofocus.crossplatform.AbstractAveragingLayer;
import com.macrofocus.crossplatform.javafx.layer.JavaFXLayer;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.igraphics.IDrawing;
import com.macrofocus.timer.VisualizationExecutorService;
import java.awt.Color;
import java.util.Arrays;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;

public class AveragingJavaFXLayer
extends AbstractAveragingLayer
implements JavaFXLayer {
    private static final boolean MULTITHREADED = false;
    private static final VisualizationExecutorService executor = null;
    private final IDrawing iDrawing;
    private final boolean antialiasing;
    private WritableImage image;

    public AveragingJavaFXLayer(IDrawing iDrawing, boolean antialiasing) {
        this.iDrawing = iDrawing;
        this.antialiasing = antialiasing;
        this.resize(this.width, this.height);
    }

    @Override
    public void prepare(int width, int height) {
        this.resize(width, height);
        if (this.iDrawing.isActive() && width > 0 && height > 0) {
            this.iDrawing.draw(this.g, null, (double)this.width, (double)this.height, new Rectangle(0, 0, this.width, this.height));
            PixelWriter pixelWriter = this.image.getPixelWriter();
            for (int i = 0; i < this.overlay.length; ++i) {
                int count = this.overlay[i];
                if (count > 0) {
                    float[] c = this.rgb[i];
                    float red = c[0] / (float)count;
                    float green = c[1] / (float)count;
                    float blue = c[2] / (float)count;
                    assert (red >= 0.0f && red <= 1.0f) : red + ", " + c[0] + ", " + count;
                    assert (green >= 0.0f && green <= 1.0f) : green + ", " + c[1] + ", " + count;
                    assert (blue >= 0.0f && blue <= 1.0f) : blue + ", " + c[2] + ", " + count;
                    Color color = new Color(red, green, blue);
                    pixelWriter.setArgb(i % width, i / width, color.getRGB());
                    continue;
                }
                pixelWriter.setArgb(i % width, i / width, 0xFFFFFF);
            }
        }
        if (this.antialiasing) {
            this.image = this.createAntiAliasedImage(this.image);
        }
    }

    void resize(int width, int height) {
        if ((this.width != width || this.height != height) && width > 0 && height > 0) {
            WritableImage bufferedImage = new WritableImage(width, height);
            int[] o = new int[width * height];
            float[][] rgb = new float[width * height][3];
            for (int i = 0; i < rgb.length; ++i) {
                rgb[i] = new float[3];
            }
            this.width = width;
            this.height = height;
            this.image = bufferedImage;
            this.overlay = o;
            this.rgb = rgb;
            this.cx1 = 0;
            this.cy1 = 0;
            this.cx2 = width - 1;
            this.cy2 = height - 1;
        } else {
            this.clear();
        }
    }

    @Override
    public void render(GraphicsContext g) {
        if (this.iDrawing.isActive() && this.image != null) {
            g.drawImage((Image)this.image, 0.0, 0.0);
        }
    }

    private WritableImage createAntiAliasedImage(WritableImage img) {
        return img;
    }

    void clear() {
        if (this.image != null) {
            Arrays.fill(this.overlay, 0);
            for (float[] c : this.rgb) {
                c[0] = 0.0f;
                c[1] = 0.0f;
                c[2] = 0.0f;
            }
        }
    }
}

