/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.javafx.layer;

import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.javafx.layer.JavaFXLayer;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.IDrawing;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.igraphics.javafx.JavaFXIGraphics;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class BufferedJavaFXLayer
implements JavaFXLayer {
    private final IDrawing iDrawing;
    private final boolean antialiasing;
    private CPCanvas.PaletteProvider paletteProvider;
    private Double alpha;
    private CPColor<Color> color;
    private int width;
    private int height;
    private Canvas image;
    private WritableImage screenImage;

    public BufferedJavaFXLayer(IDrawing iDrawing, boolean antialiasing, CPCanvas.PaletteProvider paletteProvider) {
        this.iDrawing = iDrawing;
        this.antialiasing = antialiasing;
        this.paletteProvider = paletteProvider;
    }

    public BufferedJavaFXLayer(IDrawing iDrawing, boolean antialiasing) {
        this.iDrawing = iDrawing;
        this.antialiasing = antialiasing;
    }

    public BufferedJavaFXLayer(IDrawing iDrawing, boolean antialiasing, CPColor<Color> color, Double alpha) {
        this.iDrawing = iDrawing;
        this.antialiasing = antialiasing;
        this.color = color;
        this.alpha = alpha;
    }

    @Override
    public void prepare(int width, int height) {
        this.resize(width, height);
        if (this.iDrawing.isActive() && this.image != null) {
            GraphicsContext g2 = this.image.getGraphicsContext2D();
            if (this.antialiasing) {
                // empty if block
            }
            if (this.paletteProvider != null) {
                CPColor start = this.paletteProvider.getPalette().getColor(0.0);
                CPColor end = this.paletteProvider.getPalette().getColor(1.0);
                float s = (float)start.getRed() / 255.0f;
                float e = (float)end.getRed() / 255.0f;
                if (e > s) {
                    if (this.alpha == null) {
                        float alpha = s / e;
                        g2.setGlobalAlpha((double)alpha);
                    }
                } else if (this.alpha == null) {
                    float alpha = (1.0f - s) / (1.0f - e);
                    g2.setGlobalAlpha((double)alpha);
                }
            }
            if (this.color != null) {
                g2.setStroke((Paint)this.color.getNativeColor());
                g2.setFill((Paint)this.color.getNativeColor());
            }
            if (this.alpha != null) {
                g2.setGlobalAlpha(this.alpha.doubleValue());
            }
            this.iDrawing.draw((IGraphics)new JavaFXIGraphics(g2), null, (double)this.width, (double)this.height, new Rectangle(0, 0, this.width, this.height));
            BufferedJavaFXLayer.copySrcIntoDstAt(this.image, this.screenImage);
        }
    }

    void resize(int width, int height) {
        if ((this.width != width || this.height != height) && width > 0 && height > 0) {
            this.image = new Canvas((double)width, (double)height);
            this.screenImage = new WritableImage(width, height);
            this.width = width;
            this.height = height;
        } else {
            this.clear();
        }
    }

    void clear() {
        if (this.iDrawing.isActive() && this.image != null) {
            GraphicsContext g2 = this.image.getGraphicsContext2D();
            g2.clearRect(0.0, 0.0, this.image.getWidth(), this.image.getHeight());
        }
    }

    @Override
    public void render(GraphicsContext g) {
        g.drawImage((Image)this.screenImage, 0.0, 0.0);
    }

    private static void copySrcIntoDstAt(final Canvas src, final WritableImage dst) {
        BufferedJavaFXLayer.runAndWait(new Runnable(){

            @Override
            public void run() {
                SnapshotParameters parameters = new SnapshotParameters();
                parameters.setFill((Paint)Color.TRANSPARENT);
                src.snapshot(parameters, dst);
            }
        });
    }

    public static void runAndWait(final Runnable action) {
        if (action == null) {
            throw new NullPointerException("action");
        }
        if (Platform.isFxApplicationThread()) {
            action.run();
            return;
        }
        final CountDownLatch doneLatch = new CountDownLatch(1);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    action.run();
                }
                finally {
                    doneLatch.countDown();
                }
            }
        });
        try {
            doneLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

