/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.format.javafx;

import com.macrofocus.crossplatform.CPLocale;
import com.macrofocus.crossplatform.CPTimeZone;
import com.macrofocus.format.AbstractFormat;
import com.macrofocus.format.AbstractFormatFactory;
import com.macrofocus.format.CPFormat;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class JavaFXFormatFactory
extends AbstractFormatFactory {
    private static JavaFXFormatFactory ourInstance = new JavaFXFormatFactory();

    public static JavaFXFormatFactory getInstance() {
        return ourInstance;
    }

    public CPFormat createDecimalFormat() {
        return new JavaFXFormat(DecimalFormat.getInstance(), null, null, 1.0, 1.0);
    }

    public CPFormat createDecimalFormat(int fractionDigits, String pre, String post, double rounding, double factor) {
        NumberFormat instance = DecimalFormat.getInstance();
        instance.setMaximumFractionDigits(fractionDigits);
        return new JavaFXFormat(instance, pre, post, rounding, factor);
    }

    public CPFormat createIntegerFormat(String pre, String post, double rounding) {
        return new JavaFXFormat(DecimalFormat.getIntegerInstance(), pre, post, rounding, 1.0);
    }

    public CPFormat createPercentDecimalFormat(int fractionDigits, double rounding) {
        NumberFormat instance = DecimalFormat.getPercentInstance();
        instance.setMaximumFractionDigits(fractionDigits);
        return new JavaFXFormat(instance, null, null, rounding, 1.0);
    }

    public CPFormat createDateFormat() {
        return new JavaFXDateFormat("dd.MM.yyyy");
    }

    public CPFormat createDateTimeFormat() {
        return new JavaFXDateFormat("dd.MM.yyyy HH:mm:ss");
    }

    public CPFormat createDateOrDateTimeFormat() {
        return new CPFormat(){
            DateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
            DateFormat fullDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

            public String format(Object value) {
                return this.formatHtml(value, false);
            }

            public String formatHtml(Object value, boolean htmlSupported) {
                if (value != null) {
                    Date date;
                    if (value instanceof Number) {
                        date = new Date(((Number)value).longValue());
                    } else if (value instanceof Date) {
                        date = (Date)value;
                    } else {
                        return value.toString();
                    }
                    if (date.getHours() != 0 || date.getMinutes() != 0 || date.getSeconds() != 0) {
                        return this.fullDateFormat.format(date);
                    }
                    return this.dateFormat.format(date);
                }
                return "";
            }

            public Object parse(String text) throws CPFormat.ParsingException {
                try {
                    return this.fullDateFormat.parse(text);
                }
                catch (ParseException e) {
                    try {
                        return this.dateFormat.parse(text);
                    }
                    catch (ParseException e1) {
                        throw new CPFormat.ParsingException(e.getMessage(), e.getErrorOffset());
                    }
                }
            }

            public String getPattern() {
                return null;
            }

            public Object getNativeFormat() {
                return null;
            }

            public CPFormat.HorizontalAlignment getHorizontalAlignment() {
                return null;
            }

            public String getClassName(Object value) {
                return null;
            }
        };
    }

    public CPFormat createNumberFormat(String pattern) {
        return new JavaFXNumberFormat(pattern);
    }

    public CPFormat createDateFormat(String pattern) {
        return new JavaFXDateFormat(pattern);
    }

    public CPFormat createDateFormat(String pattern, CPLocale locale) {
        return new JavaFXDateFormat(pattern);
    }

    public CPFormat createDateFormat(String pattern, CPLocale locale, CPTimeZone zone) {
        return new JavaFXDateFormat(pattern);
    }

    private static class JavaFXFormat
    extends AbstractFormat {
        private final Format format;
        private final String pre;
        private final String post;
        private final double rounding;
        private final double factor;

        public JavaFXFormat(Format format, String pre, String post, double rounding, double factor) {
            this.format = format;
            this.pre = pre;
            this.post = post;
            this.rounding = rounding;
            this.factor = factor;
        }

        public String format(Object value) {
            return this.formatHtml(value, false);
        }

        public String formatHtml(Object value, boolean htmlSupported) {
            Object s;
            Number n = (Number)value;
            if (value != null) {
                if (this.rounding != 1.0) {
                    n = (double)Math.round(n.doubleValue() / this.rounding) * this.rounding;
                }
                if (this.factor != 1.0) {
                    n = n.doubleValue() * this.factor;
                }
                s = this.format.format(n);
                if (this.pre != null) {
                    s = this.pre + (String)s;
                }
                if (this.post != null) {
                    s = (String)s + this.post;
                }
            } else {
                s = null;
            }
            return s;
        }

        public Object parse(String text) {
            if (text != null) {
                if (this.pre != null && !((String)text).startsWith(this.pre)) {
                    text = this.pre + (String)text;
                }
                if (this.post != null && !((String)text).endsWith(this.post)) {
                    text = (String)text + this.post;
                }
                try {
                    return this.format.parseObject((String)text);
                }
                catch (ParseException e) {
                    return null;
                }
            }
            return null;
        }

        public Format getNativeFormat() {
            return this.format;
        }
    }

    private static class JavaFXDateFormat
    implements CPFormat {
        final DateFormat dateFormat;
        final String pattern;

        public JavaFXDateFormat(String pattern) {
            this.dateFormat = new SimpleDateFormat(pattern);
            this.pattern = pattern;
        }

        public String format(Object value) {
            return this.formatHtml(value, false);
        }

        public String formatHtml(Object value, boolean htmlSupported) {
            if (value != null) {
                Date date;
                if (value instanceof Number) {
                    date = new Date(((Number)value).longValue());
                } else if (value instanceof Date) {
                    date = (Date)value;
                } else {
                    return value.toString();
                }
                return this.dateFormat.format(date);
            }
            return "";
        }

        public Object parse(String text) throws CPFormat.ParsingException {
            try {
                return this.dateFormat.parse(text);
            }
            catch (ParseException e) {
                throw new CPFormat.ParsingException(e.getMessage(), e.getErrorOffset());
            }
        }

        public String getPattern() {
            return this.pattern;
        }

        public Object getNativeFormat() {
            return this.dateFormat;
        }

        public CPFormat.HorizontalAlignment getHorizontalAlignment() {
            return null;
        }

        public String getClassName(Object value) {
            return null;
        }
    }

    private static class JavaFXNumberFormat
    implements CPFormat {
        final DecimalFormat numberFormat;
        final String pattern;

        public JavaFXNumberFormat(String pattern) {
            this.numberFormat = new DecimalFormat(pattern);
            this.pattern = pattern;
        }

        public String format(Object value) {
            return this.formatHtml(value, false);
        }

        public String formatHtml(Object value, boolean htmlSupported) {
            if (value != null) {
                if (!(value instanceof Number)) {
                    return value.toString();
                }
                Number number = (Number)value;
                return this.numberFormat.format(number);
            }
            return "";
        }

        public Object parse(String text) throws CPFormat.ParsingException {
            try {
                return this.numberFormat.parse(text);
            }
            catch (ParseException e) {
                throw new CPFormat.ParsingException(e.getMessage(), e.getErrorOffset());
            }
        }

        public String getPattern() {
            return this.pattern;
        }

        public Object getNativeFormat() {
            return this.numberFormat;
        }

        public CPFormat.HorizontalAlignment getHorizontalAlignment() {
            return null;
        }

        public String getClassName(Object value) {
            return null;
        }
    }
}

