/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.igraphics.javafx;

import com.macrofocus.crossplatform.javafx.JavaFXFactory;
import com.macrofocus.igraphics.AbstractCPColor;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPColorFactory;
import javafx.scene.paint.Color;

public class JavaFXColor
extends AbstractCPColor<Color> {
    private final Color nativeColor;

    public JavaFXColor(Color nativeColor) {
        this.nativeColor = nativeColor;
    }

    public JavaFXColor(int r, int g, int b, int a) {
        this.nativeColor = Color.rgb((int)r, (int)g, (int)b, (double)((double)a / 255.0));
    }

    public CPColorFactory<Color> getFactory() {
        return JavaFXFactory.getInstance();
    }

    protected CPColor<Color> create(int rgba) {
        int alpha = rgba >> 24 & 0xFF;
        int red = rgba >> 16 & 0xFF;
        int green = rgba >> 8 & 0xFF;
        int blue = rgba & 0xFF;
        return new JavaFXColor(red, green, blue, alpha);
    }

    public int getRed() {
        return (int)Math.round(this.nativeColor.getRed() * 255.0);
    }

    public int getGreen() {
        return (int)Math.round(this.nativeColor.getGreen() * 255.0);
    }

    public int getBlue() {
        return (int)Math.round(this.nativeColor.getBlue() * 255.0);
    }

    public int getAlpha() {
        return (int)Math.round(this.nativeColor.getOpacity() * 255.0);
    }

    public int getRGB() {
        int r = (int)Math.round(this.nativeColor.getRed() * 255.0);
        int g = (int)Math.round(this.nativeColor.getGreen() * 255.0);
        int b = (int)Math.round(this.nativeColor.getBlue() * 255.0);
        int a = (int)Math.round(this.nativeColor.getOpacity() * 255.0);
        return JavaFXColor.to32BitInteger(r, g, b, a);
    }

    public CPColor<Color> brightenAndSaturate(float brightness, float saturation) {
        float[] hsb = JavaFXColor.RGBtoHSB((int)this.getRed(), (int)this.getGreen(), (int)this.getBlue(), null);
        if (brightness != 0.0f) {
            hsb[2] = Math.max(0.0f, Math.min(1.0f, hsb[2] + brightness));
        }
        if (saturation != 0.0f) {
            hsb[1] = Math.max(0.0f, Math.min(1.0f, hsb[1] + saturation));
        }
        return this.getHSBColor(hsb[0], hsb[1], hsb[2]);
    }

    public CPColor<Color> alpha(float alpha) {
        return new JavaFXColor(this.getRed(), this.getGreen(), this.getBlue(), (int)(255.0f * alpha));
    }

    private static int to32BitInteger(int red, int green, int blue, int alpha) {
        int i = alpha;
        i <<= 8;
        i |= red;
        i <<= 8;
        i |= green;
        i <<= 8;
        return i |= blue;
    }

    public Color getNativeColor() {
        return this.nativeColor;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("JavaFXColor{");
        sb.append("red=").append(this.getRed());
        sb.append(",green=").append(this.getGreen());
        sb.append(",blue=").append(this.getBlue());
        sb.append(",alpha=").append(this.getAlpha());
        sb.append('}');
        return sb.toString();
    }
}

