/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.igraphics.javafx;

import com.macrofocus.igraphics.CPFont;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

public class JavaFXFont
implements CPFont<Font> {
    private final Font nativeFont;
    private final FontWeight fontWeight;
    private final FontPosture fontPosture;

    public JavaFXFont(Font nativeFont) {
        this.nativeFont = nativeFont;
        this.fontWeight = FontWeight.NORMAL;
        this.fontPosture = FontPosture.REGULAR;
    }

    public JavaFXFont(Font nativeFont, FontWeight fontWeight, FontPosture fontPosture) {
        this.nativeFont = nativeFont;
        this.fontWeight = fontWeight;
        this.fontPosture = fontPosture;
    }

    public JavaFXFont(String name, int style, int size) {
        this.fontWeight = (style & 1) != 0 ? FontWeight.BOLD : FontWeight.NORMAL;
        this.fontPosture = (style & 2) != 0 ? FontPosture.ITALIC : FontPosture.REGULAR;
        this.nativeFont = Font.font((String)name, (FontWeight)this.fontWeight, (FontPosture)this.fontPosture, (double)size);
    }

    public Font getNativeFont() {
        return this.nativeFont;
    }

    public double getSize2D() {
        return this.nativeFont.getSize();
    }

    public CPFont<Font> deriveFontSize(double fontSize) {
        return new JavaFXFont(Font.font((String)this.nativeFont.getFamily(), (double)fontSize), this.fontWeight, this.fontPosture);
    }

    public CPFont<Font> deriveFontWeight(CPFont.Weight weight) {
        FontWeight w = null;
        switch (weight) {
            case NORMAL: {
                w = FontWeight.NORMAL;
                break;
            }
            case BOLD: {
                w = FontWeight.BOLD;
            }
        }
        return new JavaFXFont(Font.font((String)this.nativeFont.getFamily(), (FontWeight)w, (double)this.nativeFont.getSize()), w, this.fontPosture);
    }

    public String toString() {
        String strStyle = "plain";
        strStyle = this.fontWeight == FontWeight.BOLD ? (this.fontPosture == FontPosture.ITALIC ? "bolditalic" : "bold") : (this.fontPosture == FontPosture.ITALIC ? "italic" : "plain");
        return this.nativeFont.getFamily() + "-" + strStyle + "-" + String.format("%.0f", this.nativeFont.getSize());
    }
}

