/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.igraphics.javafx;

import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPTextMetrics;
import com.macrofocus.igraphics.GraphicsContext2D;
import com.macrofocus.igraphics.javafx.JavaFXTextMetrics;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ArcType;
import javafx.scene.text.Font;

public class JavaFXGraphicsContext2D
implements GraphicsContext2D<Color, Font> {
    private final GraphicsContext gc;

    public JavaFXGraphicsContext2D(GraphicsContext gc) {
        this.gc = gc;
    }

    public CPTextMetrics getTextMetrics(String text) {
        return new JavaFXTextMetrics(this.gc, text);
    }

    public void drawGradient(CPColor<Color> color1, CPColor<Color> color2, double x, double y, double w, double h, boolean isVertical) {
        if (isVertical) {
            this.gc.setFill((Paint)new LinearGradient(0.0, y, 0.0, y + h, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, (Color)color1.getNativeColor()), new Stop(1.0, (Color)color2.getNativeColor())}));
            this.gc.fillRect(x, y, w, h);
        } else {
            this.gc.setFill((Paint)new LinearGradient(x, 0.0, x + w, 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, (Color)color1.getNativeColor()), new Stop(1.0, (Color)color2.getNativeColor())}));
            this.gc.fillRect(x, y, w, h);
        }
    }

    public void save() {
        this.gc.save();
    }

    public void restore() {
        this.gc.restore();
    }

    public void translate(double x, double y) {
        this.gc.translate(x, y);
    }

    public void scale(double x, double y) {
        this.gc.scale(x, y);
    }

    public void rotate(double degrees) {
        this.gc.rotate(degrees);
    }

    public void transform(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        this.gc.transform(mxx, myx, mxy, myy, mxt, myt);
    }

    public void setTransform(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        this.gc.setTransform(mxx, myx, mxy, myy, mxt, myt);
    }

    public double getGlobalAlpha() {
        return this.gc.getGlobalAlpha();
    }

    public void setGlobalAlpha(double alpha) {
        this.gc.setGlobalAlpha(alpha);
    }

    public Color getFill() {
        return (Color)this.gc.getFill();
    }

    public void setFill(CPColor<Color> p) {
        this.gc.setFill((Paint)p.getNativeColor());
    }

    public Color getStroke() {
        return (Color)this.gc.getStroke();
    }

    public void setStroke(CPColor<Color> p) {
        this.gc.setStroke((Paint)p.getNativeColor());
    }

    public double getLineWidth() {
        return this.gc.getLineWidth();
    }

    public void setLineWidth(double lw) {
        this.gc.setLineWidth(lw);
    }

    public double getMiterLimit() {
        return this.gc.getMiterLimit();
    }

    public void setMiterLimit(double ml) {
        this.gc.setMiterLimit(ml);
    }

    public double[] getLineDashes() {
        return this.gc.getLineDashes();
    }

    public void setLineDashes(double ... dashes) {
        this.gc.setLineDashes(dashes);
    }

    public double getLineDashOffset() {
        return this.gc.getLineDashOffset();
    }

    public void setLineDashOffset(double dashOffset) {
        this.gc.setLineDashOffset(dashOffset);
    }

    public Font getFont() {
        return this.gc.getFont();
    }

    public void setFont(Font f) {
        this.gc.setFont(f);
    }

    public void fillText(String text, double x, double y) {
        this.gc.fillText(text, x, y);
    }

    public void beginPath() {
        this.gc.beginPath();
    }

    public void moveTo(double x0, double y0) {
        this.gc.moveTo(x0, y0);
    }

    public void lineTo(double x1, double y1) {
        this.gc.lineTo(x1, y1);
    }

    public void quadraticCurveTo(double xc, double yc, double x1, double y1) {
        this.gc.quadraticCurveTo(xc, yc, x1, y1);
    }

    public void bezierCurveTo(double xc1, double yc1, double xc2, double yc2, double x1, double y1) {
        this.gc.bezierCurveTo(xc1, yc1, xc2, yc2, x1, y1);
    }

    public void rect(double x, double y, double w, double h) {
        this.gc.rect(x, y, w, h);
    }

    public void closePath() {
        this.gc.closePath();
    }

    public void fill() {
        this.gc.fill();
    }

    public void stroke() {
        this.gc.stroke();
    }

    public void clip() {
        this.gc.clip();
    }

    public void fillRect(double x, double y, double w, double h) {
        this.gc.fillRect(x, y, w, h);
    }

    public void strokeRect(double x, double y, double w, double h) {
        this.gc.strokeRect(x, y, w, h);
    }

    public void strokeLine(double x1, double y1, double x2, double y2) {
        this.gc.strokeLine(x1, y1, x2, y2);
    }

    public void strokeText(String text, double x, double y) {
        this.gc.strokeText(text, x, y);
    }

    public void fillText(String text, double x, double y, double maxWidth) {
        this.gc.fillText(text, x, y, maxWidth);
    }

    public void strokeText(String text, double x, double y, double maxWidth) {
        this.gc.strokeText(text, x, y, maxWidth);
    }

    public void arcTo(double x1, double y1, double x2, double y2, double radius) {
        this.gc.arcTo(x1, y1, x2, y2, radius);
    }

    public void appendSVGPath(String svgpath) {
        this.gc.appendSVGPath(svgpath);
    }

    public boolean isPointInPath(double x, double y) {
        return this.gc.isPointInPath(x, y);
    }

    public void clearRect(double x, double y, double w, double h) {
        this.gc.clearRect(x, y, w, h);
    }

    public void fillOval(double x, double y, double w, double h) {
        this.gc.fillOval(x, y, w, h);
    }

    public void strokeOval(double x, double y, double w, double h) {
        this.gc.strokeOval(x, y, w, h);
    }

    public void fillArc(double x, double y, double w, double h, double startAngle, double arcExtent, ArcType closure) {
        this.gc.fillArc(x, y, w, h, startAngle, arcExtent, closure);
    }

    public void strokeArc(double x, double y, double w, double h, double startAngle, double arcExtent, ArcType closure) {
        this.gc.strokeArc(x, y, w, h, startAngle, arcExtent, closure);
    }

    public void fillRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
        this.gc.fillRoundRect(x, y, w, h, arcWidth, arcHeight);
    }

    public void strokeRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
        this.gc.strokeRoundRect(x, y, w, h, arcWidth, arcHeight);
    }

    public void fillPolygon(double[] xPoints, double[] yPoints, int nPoints) {
        this.gc.fillPolygon(xPoints, yPoints, nPoints);
    }

    public void strokePolygon(double[] xPoints, double[] yPoints, int nPoints) {
        this.gc.strokePolygon(xPoints, yPoints, nPoints);
    }

    public void strokePolyline(double[] xPoints, double[] yPoints, int nPoints) {
        this.gc.strokePolyline(xPoints, yPoints, nPoints);
    }
}

