/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.javafx;

import com.macrofocus.common.geom.Dimension;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.javafx.JavaFXCanvas;
import com.macrofocus.crossplatform.javafx.JavaFXFactory;
import com.macrofocus.geom.Point;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.javafx.ResizableCanvas;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.timer.CPTimer;
import com.macrofocus.timer.CPTimerListener;
import com.treemap.AbstractTreeMapView;
import com.treemap.LabelingFactory;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapRenderer;
import com.treemap.TreeMapToolTip;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.Headless;
import com.treemap.crossplatform.TGraphics;
import com.treemap.javafx.crossplatform.JavaFXHeadless;
import com.treemap.javafx.crossplatform.JavaFXTGraphics;
import java.awt.image.BufferedImage;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;

public class JavaFXTreeMapView<N, Row, Column>
extends AbstractTreeMapView<Node, N, Row, Column, Color, Font> {
    private final StackPane nativeComponent = new StackPane();
    private CanvasComponent canvas;
    protected final CPTimer timer = JavaFXFactory.getInstance().createTimer("TreeMapViewUpdater", 17, false, new CPTimerListener(){

        public void timerTriggered() {
            if (Platform.isFxApplicationThread()) {
                if (JavaFXTreeMapView.this.canvas.isVisible()) {
                    JavaFXTreeMapView.this.canvas.draw();
                }
            } else {
                Platform.runLater(() -> {
                    if (JavaFXTreeMapView.this.canvas.isVisible()) {
                        JavaFXTreeMapView.this.canvas.draw();
                    }
                });
            }
        }
    });

    public JavaFXTreeMapView() {
        super((Headless)new JavaFXHeadless());
        this.canvas = new CanvasComponent(this);
        this.nativeComponent.getChildren().add((Object)this.canvas);
        this.canvas.widthProperty().bind((ObservableValue)this.nativeComponent.widthProperty());
        this.canvas.heightProperty().bind((ObservableValue)this.nativeComponent.heightProperty());
        this.nativeComponent.widthProperty().addListener((observable, oldValue, newValue) -> {
            this.updateModelDimension();
            this.updateSize();
        });
        this.nativeComponent.heightProperty().addListener((observable, oldValue, newValue) -> {
            this.updateModelDimension();
            this.updateSize();
        });
        this.updateModelDimension();
        this.updateSize();
    }

    public void setModel(TreeMapModel<N, Row, Column, Color, Font> model) {
        LabelingFactory.SURROUND.setHeadless((Headless)new JavaFXHeadless());
        LabelingFactory.COLORED_SURROUND.setHeadless((Headless)new JavaFXHeadless());
        super.setModel(model);
    }

    protected void repaint(long delay) {
        if (this.nativeComponent != null) {
            this.timer.restart();
        }
    }

    protected void updateSize() {
        int h;
        int w;
        double height;
        double width;
        Dimension m;
        Dimension dimension = m = this._model != null && this._model.getSettings().getDimension() != null ? this._model.getSettings().getDimension() : new Dimension(0, 0);
        if (this.nativeComponent != null) {
            Dimension v = new Dimension((int)this.nativeComponent.getWidth(), (int)this.nativeComponent.getHeight());
            width = Math.max(0.0, Math.max(m.getWidth(), v.getWidth()));
            height = Math.max(0.0, Math.max(m.getHeight(), v.getHeight()));
            w = Math.max(0, v.width);
            h = Math.max(0, v.height);
        } else {
            width = Math.max(0.0, m.getWidth());
            height = Math.max(0.0, m.getHeight());
            w = 0;
            h = 0;
        }
        this.xRangeModel.setMinMax(0.0, width);
        this.yRangeModel.setMinMax(0.0, height);
        this.xRangeModel.setMaximumExtent((double)w);
        this.yRangeModel.setMaximumExtent((double)h);
        this.xRangeModel.setValue(0.0, this.xRangeModel.getMaximumExtent());
        this.yRangeModel.setValue(height - this.yRangeModel.getMaximumExtent(), this.yRangeModel.getMaximumExtent());
        this.screenTransform.setScreenSize(w, h);
    }

    public void setLicenseModel(LicenseModel licenseModel) {
    }

    public void setShowTiming(boolean showTiming) {
        this._showTiming = showTiming;
        this.repaint();
    }

    public void setProgressive(TreeMapView.Progressive progressive) {
    }

    public void updateModelDimension() {
        if (this._model != null && this.isUpdateModelDimension() && !this._model.getSettings().getDimensionFixed().booleanValue()) {
            this._model.getSettings().setDimension(new Dimension((int)this.nativeComponent.getWidth(), (int)this.nativeComponent.getHeight()));
        }
    }

    public BufferedImage getImage() {
        return null;
    }

    public BufferedImage getToolTipImage(N node) {
        return null;
    }

    public Point getToolTipPreferredLocation(N node) {
        TreeMapToolTip toolTip = this.getToolTip();
        Object oldNode = toolTip.getNode();
        toolTip.setNode(node);
        Point p = toolTip.getPreferredLocation();
        toolTip.setNode(oldNode);
        return p;
    }

    public void waitUntilReady() {
    }

    public StackPane getNativeComponent() {
        return this.nativeComponent;
    }

    public CPColor<Color> getBackground() {
        return null;
    }

    public void addMouseListener(final CPCanvas.MouseListener l) {
        this.nativeComponent.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                l.mouseClicked((CPCanvas.MouseEvent)new JavaFXCanvas.JavaFXMouseEvent(event));
            }
        });
        this.nativeComponent.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                l.mousePressed((CPCanvas.MouseEvent)new JavaFXCanvas.JavaFXMouseEvent(event));
            }
        });
        this.nativeComponent.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                l.mouseReleased((CPCanvas.MouseEvent)new JavaFXCanvas.JavaFXMouseEvent(event));
            }
        });
        this.nativeComponent.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                l.mouseEntered((CPCanvas.MouseEvent)new JavaFXCanvas.JavaFXMouseEvent(event));
            }
        });
        this.nativeComponent.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                l.mouseExited((CPCanvas.MouseEvent)new JavaFXCanvas.JavaFXMouseEvent(event));
            }
        });
    }

    public void addMouseMotionListener(final CPCanvas.MouseMotionListener l) {
        this.nativeComponent.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                l.mouseDragged((CPCanvas.MouseEvent)new JavaFXCanvas.JavaFXMouseEvent(event));
            }
        });
        this.nativeComponent.setOnMouseMoved((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                l.mouseMoved((CPCanvas.MouseEvent)new JavaFXCanvas.JavaFXMouseEvent(event));
            }
        });
    }

    public void addMouseWheelListener(final CPCanvas.MouseWheelListener l) {
        this.nativeComponent.setOnScroll((EventHandler)new EventHandler<ScrollEvent>(){

            public void handle(final ScrollEvent event) {
                l.mouseWheelMoved(new CPCanvas.MouseWheelEvent(){

                    public int getX() {
                        return (int)event.getX();
                    }

                    public int getY() {
                        return (int)event.getY();
                    }

                    public int getWheelRotation() {
                        return -((int)event.getDeltaY());
                    }
                });
            }
        });
    }

    public void addKeyListener(CPCanvas.KeyListener l) {
    }

    public void addContextMenuListener(CPCanvas.ContextMenuListener l) {
    }

    public Dimension getSize() {
        return new Dimension((int)this.nativeComponent.getWidth(), (int)this.nativeComponent.getHeight());
    }

    public void setSize(Dimension dimension) {
        this.nativeComponent.prefWidthProperty().setValue((Number)dimension.width);
        this.nativeComponent.prefHeightProperty().setValue((Number)dimension.height);
    }

    private class CanvasComponent
    extends ResizableCanvas {
        private JavaFXTGraphics tg;
        private final JavaFXTreeMapView<N, Row, Column> view;

        public CanvasComponent(JavaFXTreeMapView<N, Row, Column> view) {
            this.view = view;
            GraphicsContext g = this.getGraphicsContext2D();
            this.tg = new JavaFXTGraphics(g);
            this.widthProperty().addListener(e -> JavaFXTreeMapView.this.repaint());
            this.heightProperty().addListener(e -> JavaFXTreeMapView.this.repaint());
        }

        private void draw() {
            Dimension tooltipDimension;
            Point tooltipPosition;
            long current = System.currentTimeMillis();
            double width = this.getWidth();
            double height = this.getHeight();
            GraphicsContext g = this.getGraphicsContext2D();
            g.clearRect(0.0, 0.0, width, height);
            for (Object renderer : this.view.getPreRenderers()) {
                renderer.paint((TGraphics)this.tg, this.view, null);
            }
            boolean paintingForPrint = false;
            for (TreeMapRenderer renderer : this.view.getProgressiveRenderers()) {
                renderer.paint((TGraphics)this.tg, this.view, null);
            }
            for (TreeMapRenderer renderer : this.view.getPostRenderers()) {
                renderer.paint((TGraphics)this.tg, this.view, null);
            }
            TreeMapToolTip toolTip = this.view.getToolTip();
            if (toolTip != null && (paintingForPrint || toolTip.getType() == TreeMapToolTip.ToolTipType.Painted)) {
                tooltipPosition = toolTip.getPopupLocation();
                tooltipDimension = toolTip.getPreferredSize((TGraphics)this.tg);
                if (tooltipPosition != null && tooltipDimension != null) {
                    toolTip.setSize(tooltipDimension);
                    this.tg.save();
                    this.tg.translate(tooltipPosition.x, tooltipPosition.y);
                    this.tg.clip((Shape)new Rectangle2D.Double(0.0, 0.0, tooltipDimension.getWidth(), tooltipDimension.getHeight()));
                    toolTip.paintBackground((TGraphics)this.tg);
                    toolTip.paintText((TGraphics)this.tg);
                    this.tg.restore();
                }
            }
            if ((toolTip = this.view.getSelectionToolTip()) != null && (paintingForPrint || toolTip.getType() == TreeMapToolTip.ToolTipType.Painted)) {
                tooltipPosition = toolTip.getPreferredLocation();
                tooltipDimension = toolTip.getPreferredSize((TGraphics)this.tg);
                if (tooltipPosition != null && tooltipDimension != null) {
                    toolTip.setSize(tooltipDimension);
                    this.tg.save();
                    this.tg.translate(tooltipPosition.x, tooltipPosition.y);
                    this.tg.clip((Shape)new Rectangle2D.Double(0.0, 0.0, tooltipDimension.getWidth(), tooltipDimension.getHeight()));
                    toolTip.paintBackground((TGraphics)this.tg);
                    toolTip.paintText((TGraphics)this.tg);
                    this.tg.restore();
                }
            }
            if (this.view.getRubberBand().getRubberBand().isActive()) {
                this.tg.save();
                this.tg.setStroke((CPColor<Color>)JavaFXFactory.getInstance().getBlack());
                double[] dashPattern = new double[]{10.0, 2.0, 2.0, 2.0};
                this.tg.setLineWidth(1.0);
                this.tg.setLineDash(dashPattern);
                Rectangle2D r = this.view.getRubberBand().getRubberBandScreen();
                this.tg.stroke((Shape)new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
                this.tg.restore();
            }
            if (this.view.isShowTiming()) {
                g.setFill((Paint)Color.RED);
                g.fillText(System.currentTimeMillis() - current + " milliseconds", 5.0, (double)((int)this.getHeight() - 5));
            }
        }
    }
}

