/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.javafx.crossplatform;

import com.macrofocus.common.geom.Dimension;
import com.macrofocus.labeling.EnhancedLabel;
import com.treemap.crossplatform.Headless;
import com.treemap.crossplatform.PreferredSize;
import com.treemap.crossplatform.TGraphics;
import javafx.application.Platform;
import javafx.geometry.Bounds;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class JavaFXHeadless
implements Headless<Color, Font> {
    private static Text text;

    public PreferredSize sizeLabel(final EnhancedLabel<Color, Font> l, TGraphics<Color, Font> g, int width, int height) {
        if (g != null) {
            return g.sizeLabel(l, width, height);
        }
        return new PreferredSize(){

            public Dimension getMinimumSize() {
                return new Dimension(0, (int)this.getPreferredHeight());
            }

            public double getPreferredHeight() {
                Bounds b = JavaFXHeadless.computeStringBounds(l.getText(), (Font)l.getFont().getNativeFont());
                return b.getHeight();
            }

            public Dimension getPreferredSize() {
                Bounds b = JavaFXHeadless.computeStringBounds(l.getText(), (Font)l.getFont().getNativeFont());
                return new Dimension((int)b.getWidth(), (int)b.getHeight());
            }

            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
        };
    }

    public static double computeStringWidth(String s, Font myFont) {
        Text text = new Text(s);
        text.setFont(myFont);
        Bounds tb = text.getBoundsInLocal();
        Rectangle stencil = new Rectangle(tb.getMinX(), tb.getMinY(), tb.getWidth(), tb.getHeight());
        Shape intersection = Shape.intersect((Shape)text, (Shape)stencil);
        Bounds ib = intersection.getBoundsInLocal();
        return ib.getWidth();
    }

    public static Bounds computeStringBounds(String s, Font myFont) {
        Text text;
        if (Platform.isFxApplicationThread()) {
            if (JavaFXHeadless.text == null) {
                text = JavaFXHeadless.text = new Text(s);
            } else {
                JavaFXHeadless.text.setText(s);
                text = JavaFXHeadless.text;
            }
        } else {
            text = new Text(s);
        }
        text.setFont(myFont);
        Bounds tb = text.getBoundsInLocal();
        return tb;
    }
}

