/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.javafx.crossplatform;

import com.macrofocus.common.geom.Dimension;
import com.macrofocus.crossplatform.javafx.JavaFXFactory;
import com.macrofocus.geom.AffineTransform;
import com.macrofocus.geom.Arc2D;
import com.macrofocus.geom.Ellipse2D;
import com.macrofocus.geom.GeneralPath;
import com.macrofocus.geom.Line2D;
import com.macrofocus.geom.PathIterator;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.RoundRectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.CPImage;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.igraphics.javafx.JavaFXColor;
import com.macrofocus.igraphics.javafx.JavaFXIGraphics;
import com.macrofocus.labeling.EnhancedLabel;
import com.treemap.crossplatform.AbstractTGraphics;
import com.treemap.crossplatform.PreferredSize;
import com.treemap.javafx.crossplatform.JavaFXHeadless;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javafx.geometry.Bounds;
import javafx.geometry.VPos;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class JavaFXTGraphics
extends AbstractTGraphics<javafx.scene.paint.Color, Font> {
    static Text text;
    private final GraphicsContext gc;
    private final RenderingHints hints;
    private Paint paint = Color.BLACK;
    private CPColor<javafx.scene.paint.Color> color = JavaFXFactory.getInstance().getBlack();
    private Stroke stroke = new BasicStroke(1.0f);
    private double zeroStrokeWidth;
    private Font font = new Font("SansSerif", 12.0);
    private AffineTransform transform = new AffineTransform();
    private javafx.scene.paint.Color background = javafx.scene.paint.Color.BLACK;
    private final double[] coords = new double[6];

    public JavaFXTGraphics(GraphicsContext gc) {
        this.gc = gc;
        this.zeroStrokeWidth = 0.5;
        this.hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    public CPColorFactory<javafx.scene.paint.Color> getColorFactory() {
        return JavaFXFactory.getInstance();
    }

    public void paintLabel(EnhancedLabel<javafx.scene.paint.Color, Font> l, int x, int y, int w, int h) {
        String text;
        this.gc.save();
        if (l.isOpaque()) {
            this.gc.setFill((javafx.scene.paint.Paint)l.getBackground().getNativeColor());
            this.gc.fillRect((double)x, (double)y, (double)w, (double)h);
        }
        if ((text = l.getText()) != null) {
            this.gc.setTextBaseline(VPos.TOP);
            this.gc.setFont((Font)l.getFont().getNativeFont());
            this.gc.setFill((javafx.scene.paint.Paint)l.getForeground().getNativeColor());
            if (l.getMinimumCharactersToDisplay() != null) {
                String s;
                Bounds b;
                double width;
                int minimumCharactersToDisplay = l.getMinimumCharactersToDisplay();
                if (text.length() > minimumCharactersToDisplay && (width = (b = JavaFXHeadless.computeStringBounds(s = text.substring(0, minimumCharactersToDisplay), (Font)l.getFont().getNativeFont())).getWidth()) > (double)(w - l.getInsetLeft() - l.getInsetRight())) {
                    this.gc.restore();
                    return;
                }
            }
            switch (l.getHorizontalAlignment()) {
                case 2: 
                case 10: {
                    this.gc.setTextAlign(TextAlignment.LEFT);
                    this.gc.fillText(text, (double)(x + l.getInsetLeft()), (double)(y + l.getInsetTop()));
                    break;
                }
                case 4: 
                case 11: {
                    this.gc.setTextAlign(TextAlignment.RIGHT);
                    this.gc.fillText(text, (double)(x + w - l.getInsetRight()), (double)(y + l.getInsetTop()));
                    break;
                }
                case 0: {
                    this.gc.setTextAlign(TextAlignment.LEFT);
                    Bounds b = JavaFXHeadless.computeStringBounds(l.getText(), (Font)l.getFont().getNativeFont());
                    double width = Math.max(0.0, ((double)(w - l.getInsetLeft() - l.getInsetRight()) - b.getWidth()) / 2.0);
                    this.gc.fillText(text, (double)x + width + (double)l.getInsetLeft().intValue(), (double)(y + l.getInsetTop()));
                }
            }
        }
        this.gc.restore();
    }

    public PreferredSize sizeLabel(final EnhancedLabel<javafx.scene.paint.Color, Font> l, int w, int h) {
        return new PreferredSize(){

            public Dimension getMinimumSize() {
                return new Dimension(0, (int)this.getPreferredHeight());
            }

            public double getPreferredHeight() {
                Bounds b = JavaFXHeadless.computeStringBounds(l.getText(), (Font)l.getFont().getNativeFont());
                return b.getHeight();
            }

            public Dimension getPreferredSize() {
                Bounds b = JavaFXHeadless.computeStringBounds(l.getText(), (Font)l.getFont().getNativeFont());
                return new Dimension((int)b.getWidth(), (int)b.getHeight());
            }

            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
        };
    }

    public void save() {
        this.gc.save();
    }

    public void restore() {
        this.gc.restore();
    }

    public void setGlobalAlpha(double alpha) {
        this.gc.setGlobalAlpha(alpha);
    }

    public void setPaint(Paint paint) {
        if (paint != null) {
            this.paint = paint;
            if (paint instanceof Color) {
                this.setColor((CPColor<javafx.scene.paint.Color>)new JavaFXColor(this.awtColorToJavaFX((Color)paint)));
            } else if (paint instanceof GradientPaint) {
                GradientPaint gp = (GradientPaint)paint;
                Stop[] stops = new Stop[]{new Stop(0.0, this.awtColorToJavaFX(gp.getColor1())), new Stop(1.0, this.awtColorToJavaFX(gp.getColor2()))};
                Point2D p1 = gp.getPoint1();
                Point2D p2 = gp.getPoint2();
                LinearGradient lg = new LinearGradient(p1.getX(), p1.getY(), p2.getX(), p2.getY(), false, CycleMethod.NO_CYCLE, stops);
                this.gc.setStroke((javafx.scene.paint.Paint)lg);
                this.gc.setFill((javafx.scene.paint.Paint)lg);
            } else if (paint instanceof MultipleGradientPaint) {
                MultipleGradientPaint mgp = (MultipleGradientPaint)paint;
                Color[] colors = mgp.getColors();
                float[] fractions = mgp.getFractions();
                Stop[] stops = new Stop[colors.length];
                for (int i = 0; i < colors.length; ++i) {
                    stops[i] = new Stop((double)fractions[i], this.awtColorToJavaFX(colors[i]));
                }
                if (paint instanceof RadialGradientPaint) {
                    RadialGradientPaint rgp = (RadialGradientPaint)paint;
                    Point2D center = rgp.getCenterPoint();
                    Point2D focus = rgp.getFocusPoint();
                    double focusDistance = focus.distance(center);
                    double focusAngle = 0.0;
                    if (!focus.equals(center)) {
                        focusAngle = Math.atan2(focus.getY() - center.getY(), focus.getX() - center.getX());
                    }
                    double radius = rgp.getRadius();
                    RadialGradient rg = new RadialGradient(Math.toDegrees(focusAngle), focusDistance, center.getX(), center.getY(), radius, false, CycleMethod.NO_CYCLE, stops);
                    this.gc.setStroke((javafx.scene.paint.Paint)rg);
                    this.gc.setFill((javafx.scene.paint.Paint)rg);
                } else if (paint instanceof LinearGradientPaint) {
                    LinearGradientPaint lgp = (LinearGradientPaint)paint;
                    Point2D center = lgp.getStartPoint();
                    Point2D focus = lgp.getEndPoint();
                    LinearGradient lg = new LinearGradient(center.getX(), center.getY(), focus.getX(), focus.getY(), false, CycleMethod.NO_CYCLE, stops);
                    this.gc.setStroke((javafx.scene.paint.Paint)lg);
                    this.gc.setFill((javafx.scene.paint.Paint)lg);
                }
            }
        }
    }

    public void setFill(CPColor<javafx.scene.paint.Color> c) {
        this.gc.setFill((javafx.scene.paint.Paint)c.getNativeColor());
    }

    public void setStroke(CPColor<javafx.scene.paint.Color> c) {
        this.gc.setStroke((javafx.scene.paint.Paint)c.getNativeColor());
    }

    public void setColor(CPColor<javafx.scene.paint.Color> c) {
        this.color = c;
        this.gc.setFill(c != null ? (javafx.scene.paint.Paint)c.getNativeColor() : null);
        this.gc.setStroke(c != null ? (javafx.scene.paint.Paint)c.getNativeColor() : null);
    }

    public void setRadialGradient() {
    }

    public boolean isPaintingForPrint() {
        return false;
    }

    public void setPaintingForPrint(boolean paintingForPrint) {
    }

    public Object getNativeGraphics() {
        return this.gc;
    }

    public IGraphics<javafx.scene.paint.Color, Font> getIGraphics() {
        return new JavaFXIGraphics(this.gc);
    }

    public javafx.scene.paint.Color awtColorToJavaFX(Color c) {
        return javafx.scene.paint.Color.rgb((int)c.getRed(), (int)c.getGreen(), (int)c.getBlue(), (double)((double)c.getAlpha() / 255.0));
    }

    public javafx.scene.paint.Color getBackground() {
        return this.background;
    }

    public void setBackground(CPColor<javafx.scene.paint.Color> color) {
    }

    public void setLineWidth(double lw) {
        this.gc.setLineWidth(lw);
    }

    public void setLineDash(double[] dashPattern) {
        this.gc.setLineDashes(dashPattern);
    }

    public StrokeLineCap awtToJavaFXLineCap(int c) {
        if (c == 0) {
            return StrokeLineCap.BUTT;
        }
        if (c == 1) {
            return StrokeLineCap.ROUND;
        }
        if (c == 2) {
            return StrokeLineCap.SQUARE;
        }
        throw new IllegalArgumentException("Unrecognised cap code: " + c);
    }

    public StrokeLineJoin awtToJavaFXLineJoin(int j) {
        if (j == 2) {
            return StrokeLineJoin.BEVEL;
        }
        if (j == 0) {
            return StrokeLineJoin.MITER;
        }
        if (j == 1) {
            return StrokeLineJoin.ROUND;
        }
        throw new IllegalArgumentException("Unrecognised join code: " + j);
    }

    public double[] floatToDoubleArray(float[] f) {
        if (f == null) {
            return null;
        }
        double[] d = new double[f.length];
        for (int i = 0; i < f.length; ++i) {
            d[i] = f[i];
        }
        return d;
    }

    public boolean isInterpolationBilinear() {
        return false;
    }

    public void setInterpolationBilinear(boolean bilinear) {
    }

    public boolean isAntialias() {
        return false;
    }

    public void setAntialias(boolean antialias) {
    }

    public boolean isTextAntialias() {
        return false;
    }

    public void setTextAntialias(boolean antialias) {
    }

    public void stroke(Shape s) {
        if (this.stroke != null && !(this.stroke instanceof BasicStroke)) {
            throw new IllegalStateException();
        }
        if (s instanceof Line2D) {
            Line2D l = (Line2D)s;
            throw new IllegalArgumentException();
        }
        if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            this.gc.strokeRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        } else if (s instanceof RoundRectangle2D) {
            RoundRectangle2D rr = (RoundRectangle2D)s;
            this.gc.strokeRoundRect(rr.getX(), rr.getY(), rr.getWidth(), rr.getHeight(), rr.getArcWidth(), rr.getArcHeight());
        } else if (s instanceof Ellipse2D) {
            Ellipse2D e = (Ellipse2D)s;
            this.gc.strokeOval(e.getX(), e.getY(), e.getWidth(), e.getHeight());
        } else if (s instanceof Arc2D) {
            Arc2D a = (Arc2D)s;
            this.gc.strokeArc(a.getX(), a.getY(), a.getWidth(), a.getHeight(), a.getAngleStart(), a.getAngleExtent(), this.intToArcType(a.getArcType()));
        } else {
            this.shapeToPath(s);
            this.gc.stroke();
        }
    }

    public void shapeToPath(Shape s) {
        this.gc.beginPath();
        PathIterator iterator = s.getPathIterator(null);
        while (!iterator.isDone()) {
            int segType = iterator.currentSegment(this.coords);
            switch (segType) {
                case 0: {
                    this.gc.moveTo(this.coords[0], this.coords[1]);
                    break;
                }
                case 1: {
                    this.gc.lineTo(this.coords[0], this.coords[1]);
                    break;
                }
                case 2: {
                    this.gc.quadraticCurveTo(this.coords[0], this.coords[1], this.coords[2], this.coords[3]);
                    break;
                }
                case 3: {
                    this.gc.bezierCurveTo(this.coords[0], this.coords[1], this.coords[2], this.coords[3], this.coords[4], this.coords[5]);
                    break;
                }
                case 4: {
                    this.gc.closePath();
                    break;
                }
                default: {
                    throw new RuntimeException("Unrecognised segment type " + segType);
                }
            }
            iterator.next();
        }
    }

    public ArcType intToArcType(int t) {
        if (t == 1) {
            return ArcType.CHORD;
        }
        if (t == 0) {
            return ArcType.OPEN;
        }
        if (t == 2) {
            return ArcType.ROUND;
        }
        throw new IllegalArgumentException("Unrecognised t: " + t);
    }

    public void fill(Shape s) {
        if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            this.gc.fillRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        } else if (s instanceof RoundRectangle2D) {
            RoundRectangle2D rr = (RoundRectangle2D)s;
            this.gc.fillRoundRect(rr.getX(), rr.getY(), rr.getWidth(), rr.getHeight(), rr.getArcWidth(), rr.getArcHeight());
        } else if (s instanceof Ellipse2D) {
            Ellipse2D e = (Ellipse2D)s;
            this.gc.fillOval(e.getX(), e.getY(), e.getWidth(), e.getHeight());
        } else if (s instanceof Arc2D) {
            Arc2D a = (Arc2D)s;
            this.gc.fillArc(a.getX(), a.getY(), a.getWidth(), a.getHeight(), a.getAngleStart(), a.getAngleExtent(), this.intToArcType(a.getArcType()));
        } else {
            this.shapeToPath(s);
            this.gc.fill();
        }
    }

    public Font getFont() {
        return this.gc.getFont();
    }

    public void setFont(Font font) {
        this.gc.setFont(font);
    }

    public Rectangle2D getStringBounds(String text) {
        Text t = new Text(text);
        t.setFont(this.gc.getFont());
        Bounds stringBounds = t.getLayoutBounds();
        return new Rectangle2D.Double(stringBounds.getMinX(), stringBounds.getMinY(), stringBounds.getWidth(), stringBounds.getHeight());
    }

    public double getStringWidth(String text) {
        return this.getStringBounds(text).getWidth();
    }

    public void fillText(String str, int x, int y) {
        this.fillText(str, (float)x, (float)y);
    }

    public void fillText(String str, float x, float y) {
        if (str == null) {
            throw new NullPointerException("Null 'str' argument.");
        }
        this.gc.fillText(str, (double)x, (double)y);
    }

    public void translate(int tx, int ty) {
        this.translate((double)tx, (double)ty);
    }

    public void translate(double tx, double ty) {
        this.transform.translate(tx, ty);
        this.gc.translate(tx, ty);
    }

    public void rotate(double theta) {
        this.transform.rotate(theta);
        this.gc.rotate(Math.toDegrees(theta));
    }

    public void rotate(double theta, double x, double y) {
        this.translate(x, y);
        this.rotate(theta);
        this.translate(-x, -y);
    }

    public void scale(double sx, double sy) {
        this.transform.scale(sx, sy);
        this.gc.scale(sx, sy);
    }

    public void shear(double shx, double shy) {
        this.transform(AffineTransform.getShearInstance((double)shx, (double)shy));
    }

    public void transform(AffineTransform t) {
        AffineTransform tx = this.getTransform();
        tx.concatenate(t);
        this.setTransform(tx);
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    public void setTransform(AffineTransform t) {
        if (t == null) {
            t = this.transform = new AffineTransform();
        } else {
            this.transform = new AffineTransform(t);
        }
        this.gc.setTransform(t.getScaleX(), t.getShearY(), t.getShearX(), t.getScaleY(), t.getTranslateX(), t.getTranslateY());
    }

    public void clip(Shape s) {
        if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            this.gc.beginPath();
            this.gc.rect(Math.floor(r.getX()), Math.floor(r.getY()), Math.ceil(r.getWidth()), Math.ceil(r.getHeight()));
        } else {
            this.shapeToPath(s);
        }
        this.gc.clip();
    }

    public void strokeLine(int x1, int y1, int x2, int y2) {
        this.gc.strokeLine((double)x1, (double)y1, (double)x2, (double)y2);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.gc.fillRect((double)x, (double)y, (double)width, (double)height);
    }

    public void clearRect(int x, int y, int width, int height) {
        if (this.getBackground() != null) {
            this.fillRect(x, y, width, height);
        }
    }

    public void strokeRect(double x, double y, double width, double height) {
        this.gc.strokeRect(x, y, width, height);
    }

    public void fillRect(double x, double y, double width, double height) {
        this.gc.fillRect(x, y, width, height);
    }

    public void strokeRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this.gc.strokeRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public void fillRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this.gc.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.gc.strokeOval((double)x, (double)y, (double)width, (double)height);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.gc.fillOval((double)x, (double)y, (double)width, (double)height);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.gc.strokeArc((double)x, (double)y, (double)width, (double)height, (double)startAngle, (double)arcAngle, this.intToArcType(0));
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.gc.fillArc((double)x, (double)y, (double)width, (double)height, (double)startAngle, (double)arcAngle, this.intToArcType(0));
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath p = this.createPolygon(xPoints, yPoints, nPoints, false);
        this.stroke((Shape)p);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath p = this.createPolygon(xPoints, yPoints, nPoints, true);
        this.stroke((Shape)p);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath p = this.createPolygon(xPoints, yPoints, nPoints, true);
        this.fill((Shape)p);
    }

    public GeneralPath createPolygon(int[] xPoints, int[] yPoints, int nPoints, boolean close) {
        GeneralPath p = new GeneralPath();
        p.moveTo((double)xPoints[0], (double)yPoints[0]);
        for (int i = 1; i < nPoints; ++i) {
            p.lineTo((double)xPoints[i], (double)yPoints[i]);
        }
        if (close) {
            p.closePath();
        }
        return p;
    }

    public BufferedImage createImage(int width, int height) {
        return new BufferedImage(width, height, 2);
    }

    public boolean drawNativeImage(Image img, int x, int y) {
        if (img == null) {
            return true;
        }
        int w = img.getWidth(null);
        if (w < 0) {
            return false;
        }
        int h = img.getHeight(null);
        return false;
    }

    public boolean drawImage(CPImage image, int x, int y) {
        WritableImage nativeImage = (WritableImage)image.getNativeImage();
        this.gc.drawImage((javafx.scene.image.Image)nativeImage, (double)x, (double)y);
        return true;
    }

    public boolean drawImage(CPImage image, int x, int y, int w, int h) {
        WritableImage nativeImage = (WritableImage)image.getNativeImage();
        this.gc.drawImage((javafx.scene.image.Image)nativeImage, (double)x, (double)y, (double)w, (double)h);
        return true;
    }
}

