/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.javafx.treeplot;

import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormap.javafx.JavaFXColorMapFactory;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.CPHelper;
import com.macrofocus.crossplatform.javafx.AbstractJavaFXComponent;
import com.macrofocus.crossplatform.javafx.JavaFXFactory;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.CPFontFactory;
import com.macrofocus.igraphics.CPImageFactory;
import com.macrofocus.igraphics.javafx.JavaFXImageFactory;
import com.macrofocus.license.SimpleLicenseModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.treemap.DefaultTreeMapModel;
import com.treemap.TreeMapModel;
import com.treemap.javafx.treeplot.JavaFXTreePlotController;
import com.treemap.javafx.treeplot.JavaFXTreePlotView;
import com.treemap.treeplot.AbstractTreePlot;
import com.treemap.treeplot.DefaultTreePlotModel;
import com.treemap.treeplot.TreePlotController;
import com.treemap.treeplot.TreePlotModel;
import com.treemap.treeplot.TreePlotView;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

public class JavaFXTreePlot<N, Row, Column>
extends AbstractTreePlot<Node, N, Row, Column, Color, Font> {
    private final StackPane nativeComponent = new StackPane();

    public JavaFXTreePlot() {
        this.view = this.createView();
        this.controller = this.createController(this.view);
        ((Canvas)this.view.getNativeComponent()).widthProperty().bind((ObservableValue)this.nativeComponent.widthProperty());
        ((Canvas)this.view.getNativeComponent()).heightProperty().bind((ObservableValue)this.nativeComponent.heightProperty());
        this.nativeComponent.getChildren().add((Object)((Node)this.view.getNativeComponent()));
    }

    public JavaFXTreePlot(TreeMapModel<N, Row, Column, Color, Font> model) {
        this();
        this.setModel(this.createTreePlotModel(model));
    }

    public JavaFXTreePlot(DataFrame<Row, Column, ?> dataFrame) {
        this();
        this.load(dataFrame);
    }

    public static void setLicenseKey(String username, String key) {
        licenseModel = new SimpleLicenseModel(ApplicationModelFactory.TREEMAP_API, username, key);
    }

    void load(DataFrame<Row, Column, ?> dataFrame) {
        this.setModel(this.createTreePlotModel(dataFrame));
    }

    protected TreePlotModel<N, Row, Column, Color, Font> createTreePlotModel(DataFrame<Row, Column, ?> dataFrame) {
        DefaultTreeMapModel treeMapModel = new DefaultTreeMapModel(dataFrame, (CPFactory)JavaFXFactory.getInstance(), (ColorMapFactory)JavaFXColorMapFactory.getInstance(), (CPImageFactory)JavaFXImageFactory.getInstance());
        return this.createTreePlotModel((TreeMapModel<N, Row, Column, Color, Font>)treeMapModel);
    }

    protected TreePlotModel<N, Row, Column, Color, Font> createTreePlotModel(TreeMapModel<N, Row, Column, Color, Font> model) {
        return new DefaultTreePlotModel(model, (CPColorFactory)JavaFXFactory.getInstance(), (CPFontFactory)JavaFXFactory.getInstance(), (CPHelper)JavaFXFactory.getInstance());
    }

    protected TreePlotView<Node, N, Row, Column, Color, Font> createView() {
        JavaFXTreePlotView view = new JavaFXTreePlotView();
        return view;
    }

    protected TreePlotController<Node, N, Row, Column, Color, Font> createController(TreePlotView<Node, N, Row, Column, Color, Font> view) {
        return new JavaFXTreePlotController<N, Row, Column>(view);
    }

    public void setStyleClass(String ... styleClasses) {
        AbstractJavaFXComponent.setStyleClass((CPComponent)this, (String[])styleClasses);
    }

    public Node getNativeComponent() {
        return this.nativeComponent;
    }
}

