/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.javafx.treeplot;

import com.macrofocus.common.geom.Dimension;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.javafx.JavaFXCanvas;
import com.macrofocus.crossplatform.javafx.JavaFXFactory;
import com.macrofocus.geom.Point;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.plot.guide.Guide;
import com.macrofocus.plot.guide.JavaFXXNumberOneDScreenTransformAxisGuide;
import com.macrofocus.plot.guide.JavaFXYNumberOneDScreenTransformAxisGuide;
import com.macrofocus.timer.CPTimer;
import com.macrofocus.timer.CPTimerListener;
import com.macrofocus.transform.OneDScreenTransform;
import com.treemap.TreeMapToolTip;
import com.treemap.crossplatform.Headless;
import com.treemap.crossplatform.TGraphics;
import com.treemap.javafx.crossplatform.JavaFXHeadless;
import com.treemap.javafx.crossplatform.JavaFXTGraphics;
import com.treemap.treeplot.AbstractTreePlotView;
import com.treemap.treeplot.TreePlotRenderer;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;

public class JavaFXTreePlotView<N, Row, Column>
extends AbstractTreePlotView<Node, N, Row, Column, Color, Font> {
    private NativeComponent nativeComponent;
    protected final CPTimer timer = JavaFXFactory.getInstance().createTimer("TreePlotViewUpdater", 17, false, new CPTimerListener(){

        public void timerTriggered() {
            if (Platform.isFxApplicationThread()) {
                if (JavaFXTreePlotView.this.nativeComponent.isVisible()) {
                    JavaFXTreePlotView.this.nativeComponent.draw();
                }
            } else {
                Platform.runLater(() -> {
                    if (JavaFXTreePlotView.this.nativeComponent.isVisible()) {
                        JavaFXTreePlotView.this.nativeComponent.draw();
                    }
                });
            }
        }
    });

    public JavaFXTreePlotView() {
        super((Headless)new JavaFXHeadless());
        this.nativeComponent = new NativeComponent(this);
        this.nativeComponent.widthProperty().addListener((observable, oldValue, newValue) -> this.screenTransform.setScreenSize((int)this.nativeComponent.getWidth(), (int)this.nativeComponent.getHeight()));
        this.nativeComponent.heightProperty().addListener((observable, oldValue, newValue) -> this.screenTransform.setScreenSize((int)this.nativeComponent.getWidth(), (int)this.nativeComponent.getHeight()));
        this.xGuide = new JavaFXXNumberOneDScreenTransformAxisGuide((OneDScreenTransform)this.getXCoordinateAxis());
        this.yGuide = new JavaFXYNumberOneDScreenTransformAxisGuide(Guide.Type.Left, (OneDScreenTransform)this.getYCoordinateAxis());
    }

    protected void repaint(long delay) {
        if (this.nativeComponent != null) {
            this.timer.restart();
        }
    }

    public int getWidth() {
        return (int)this.nativeComponent.getWidth();
    }

    public int getHeight() {
        return (int)this.nativeComponent.getHeight();
    }

    protected void setBackground(CPColor<Color> background) {
    }

    public Dimension getSize() {
        return new Dimension((int)this.nativeComponent.getWidth(), (int)this.nativeComponent.getHeight());
    }

    public NativeComponent getNativeComponent() {
        return this.nativeComponent;
    }

    public void addMouseListener(final CPCanvas.MouseListener l) {
        this.nativeComponent.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                l.mouseClicked((CPCanvas.MouseEvent)new JavaFXCanvas.JavaFXMouseEvent(event));
            }
        });
        this.nativeComponent.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                l.mousePressed((CPCanvas.MouseEvent)new JavaFXCanvas.JavaFXMouseEvent(event));
            }
        });
        this.nativeComponent.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                l.mouseReleased((CPCanvas.MouseEvent)new JavaFXCanvas.JavaFXMouseEvent(event));
            }
        });
        this.nativeComponent.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                l.mouseEntered((CPCanvas.MouseEvent)new JavaFXCanvas.JavaFXMouseEvent(event));
            }
        });
        this.nativeComponent.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                l.mouseExited((CPCanvas.MouseEvent)new JavaFXCanvas.JavaFXMouseEvent(event));
            }
        });
    }

    public void addMouseMotionListener(final CPCanvas.MouseMotionListener l) {
        this.nativeComponent.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                l.mouseDragged((CPCanvas.MouseEvent)new JavaFXCanvas.JavaFXMouseEvent(event));
            }
        });
        this.nativeComponent.setOnMouseMoved((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                l.mouseMoved((CPCanvas.MouseEvent)new JavaFXCanvas.JavaFXMouseEvent(event));
            }
        });
    }

    public void addMouseWheelListener(final CPCanvas.MouseWheelListener l) {
        this.nativeComponent.setOnScroll((EventHandler)new EventHandler<ScrollEvent>(){

            public void handle(final ScrollEvent event) {
                l.mouseWheelMoved(new CPCanvas.MouseWheelEvent(){

                    public int getX() {
                        return (int)event.getX();
                    }

                    public int getY() {
                        return (int)event.getY();
                    }

                    public int getWheelRotation() {
                        return -((int)event.getDeltaY());
                    }
                });
            }
        });
    }

    public void addKeyListener(CPCanvas.KeyListener l) {
    }

    public void addContextMenuListener(CPCanvas.ContextMenuListener l) {
    }

    private class NativeComponent
    extends Canvas {
        private JavaFXTGraphics tg;
        private final JavaFXTreePlotView<N, Row, Column> view;

        public NativeComponent(JavaFXTreePlotView<N, Row, Column> view) {
            this.view = view;
            GraphicsContext g = this.getGraphicsContext2D();
            this.tg = new JavaFXTGraphics(g);
            this.widthProperty().addListener(e -> JavaFXTreePlotView.this.repaint());
            this.heightProperty().addListener(e -> JavaFXTreePlotView.this.repaint());
        }

        private void draw() {
            long current = System.currentTimeMillis();
            double width = this.getWidth();
            double height = this.getHeight();
            GraphicsContext g = this.getGraphicsContext2D();
            if (this.view.getModel() != null) {
                Dimension tooltipDimension;
                Point tooltipPosition;
                TreeMapToolTip toolTip;
                this.tg.setFill((CPColor<Color>)this.view.getModel().getSettings().getBackground());
                this.tg.fillRect(0.0, 0.0, width, height);
                boolean paintingForPrint = false;
                if (this.view.getModel() != null) {
                    for (TreePlotRenderer renderer : this.view.getProgressiveRenderers()) {
                        renderer.paint((TGraphics)this.tg, this.view, null);
                    }
                    for (TreePlotRenderer renderer : this.view.getRenderers()) {
                        renderer.paint((TGraphics)this.tg, this.view, null);
                    }
                }
                if ((toolTip = this.view.getToolTip()) != null && (paintingForPrint || toolTip.getType() == TreeMapToolTip.ToolTipType.Painted)) {
                    tooltipPosition = toolTip.getPopupLocation();
                    tooltipDimension = toolTip.getPreferredSize((TGraphics)this.tg);
                    if (tooltipPosition != null && tooltipDimension != null) {
                        toolTip.setSize(tooltipDimension);
                        this.tg.save();
                        this.tg.translate(tooltipPosition.x, tooltipPosition.y);
                        this.tg.clip((Shape)new Rectangle2D.Double(0.0, 0.0, tooltipDimension.getWidth(), tooltipDimension.getHeight()));
                        toolTip.paintBackground((TGraphics)this.tg);
                        toolTip.paintText((TGraphics)this.tg);
                        this.tg.restore();
                    }
                }
                if ((toolTip = this.view.getSelectionToolTip()) != null && (paintingForPrint || toolTip.getType() == TreeMapToolTip.ToolTipType.Painted)) {
                    tooltipPosition = toolTip.getPreferredLocation();
                    tooltipDimension = toolTip.getPreferredSize((TGraphics)this.tg);
                    if (tooltipPosition != null && tooltipDimension != null) {
                        toolTip.setSize(tooltipDimension);
                        this.tg.save();
                        this.tg.translate(tooltipPosition.x, tooltipPosition.y);
                        this.tg.clip((Shape)new Rectangle2D.Double(0.0, 0.0, tooltipDimension.getWidth(), tooltipDimension.getHeight()));
                        toolTip.paintBackground((TGraphics)this.tg);
                        toolTip.paintText((TGraphics)this.tg);
                        this.tg.restore();
                    }
                }
                if (this.view.getRubberBand().getRubberBand().isActive()) {
                    this.tg.save();
                    this.tg.setStroke((CPColor<Color>)JavaFXFactory.getInstance().getBlack());
                    double[] dashPattern = new double[]{10.0, 2.0, 2.0, 2.0};
                    this.tg.setLineWidth(1.0);
                    this.tg.setLineDash(dashPattern);
                    Rectangle2D r = this.view.getRubberBand().getRubberBandScreen();
                    this.tg.stroke((Shape)new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
                    this.tg.restore();
                }
                if (this.view.isShowTiming()) {
                    g.setFill((Paint)Color.RED);
                    g.fillText(System.currentTimeMillis() - current + " milliseconds", 5.0, (double)((int)this.getHeight() - 5));
                }
            }
        }

        public boolean isResizable() {
            return true;
        }

        public double prefWidth(double height) {
            return 1.0;
        }

        public double prefHeight(double width) {
            return 1.0;
        }
    }
}

