//region block: polyfills
if (typeof Math.imul === 'undefined') {
  Math.imul = function imul(a, b) {
    return (a & 4.29490176E9) * (b & 65535) + (a & 65535) * (b | 0) | 0;
  };
}
if (typeof ArrayBuffer.isView === 'undefined') {
  ArrayBuffer.isView = function (a) {
    return a != null && a.__proto__ != null && a.__proto__.__proto__ === Int8Array.prototype.__proto__;
  };
}
if (typeof Array.prototype.fill === 'undefined') {
  // Polyfill from https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/fill#Polyfill
  Object.defineProperty(Array.prototype, 'fill', {value: function (value) {
    // Steps 1-2.
    if (this == null) {
      throw new TypeError('this is null or not defined');
    }
    var O = Object(this); // Steps 3-5.
    var len = O.length >>> 0; // Steps 6-7.
    var start = arguments[1];
    var relativeStart = start >> 0; // Step 8.
    var k = relativeStart < 0 ? Math.max(len + relativeStart, 0) : Math.min(relativeStart, len); // Steps 9-10.
    var end = arguments[2];
    var relativeEnd = end === undefined ? len : end >> 0; // Step 11.
    var finalValue = relativeEnd < 0 ? Math.max(len + relativeEnd, 0) : Math.min(relativeEnd, len); // Step 12.
    while (k < finalValue) {
      O[k] = value;
      k++;
    }
    ; // Step 13.
    return O;
  }});
}
[Int8Array, Int16Array, Uint16Array, Int32Array, Float32Array, Float64Array].forEach(function (TypedArray) {
  if (typeof TypedArray.prototype.fill === 'undefined') {
    Object.defineProperty(TypedArray.prototype, 'fill', {value: Array.prototype.fill});
  }
});
if (typeof Math.trunc === 'undefined') {
  Math.trunc = function (x) {
    if (isNaN(x)) {
      return NaN;
    }
    if (x > 0) {
      return Math.floor(x);
    }
    return Math.ceil(x);
  };
}
if (typeof Math.sinh === 'undefined') {
  var epsilon = 2.220446049250313E-16;
  var taylor_2_bound = Math.sqrt(epsilon);
  var taylor_n_bound = Math.sqrt(taylor_2_bound);
  Math.sinh = function (x) {
    if (Math.abs(x) < taylor_n_bound) {
      var result = x;
      if (Math.abs(x) > taylor_2_bound) {
        result += x * x * x / 6;
      }
      return result;
    } else {
      var y = Math.exp(x);
      var y1 = 1 / y;
      if (!isFinite(y))
        return Math.exp(x - Math.LN2);
      if (!isFinite(y1))
        return -Math.exp(-x - Math.LN2);
      return (y - y1) / 2;
    }
  };
}
if (typeof Math.expm1 === 'undefined') {
  var epsilon = 2.220446049250313E-16;
  var taylor_2_bound = Math.sqrt(epsilon);
  var taylor_n_bound = Math.sqrt(taylor_2_bound);
  Math.expm1 = function (x) {
    if (Math.abs(x) < taylor_n_bound) {
      var x2 = x * x;
      var x3 = x2 * x;
      var x4 = x3 * x; // approximation by taylor series in x at 0 up to order 4
      return x4 / 24 + x3 / 6 + x2 / 2 + x;
    }
    return Math.exp(x) - 1;
  };
}
if (typeof Math.asinh === 'undefined') {
  var epsilon = 2.220446049250313E-16;
  var taylor_2_bound = Math.sqrt(epsilon);
  var taylor_n_bound = Math.sqrt(taylor_2_bound);
  var upper_taylor_2_bound = 1 / taylor_2_bound;
  var upper_taylor_n_bound = 1 / taylor_n_bound;
  var asinh = function (x) {
    if (x >= +taylor_n_bound) {
      if (x > upper_taylor_n_bound) {
        if (x > upper_taylor_2_bound) {
          // approximation by laurent series in 1/x at 0+ order from -1 to 0
          return Math.log(x) + Math.LN2;
        } else {
          // approximation by laurent series in 1/x at 0+ order from -1 to 1
          return Math.log(x * 2 + 1 / (x * 2));
        }
      } else {
        return Math.log(x + Math.sqrt(x * x + 1));
      }
    } else if (x <= -taylor_n_bound) {
      return -asinh(-x);
    } else {
      // approximation by taylor series in x at 0 up to order 2
      var result = x;
      if (Math.abs(x) >= taylor_2_bound) {
        var x3 = x * x * x; // approximation by taylor series in x at 0 up to order 4
        result -= x3 / 6;
      }
      return result;
    }
  };
  Math.asinh = asinh;
}
if (typeof Math.log1p === 'undefined') {
  var epsilon = 2.220446049250313E-16;
  var taylor_2_bound = Math.sqrt(epsilon);
  var taylor_n_bound = Math.sqrt(taylor_2_bound);
  Math.log1p = function (x) {
    if (Math.abs(x) < taylor_n_bound) {
      var x2 = x * x;
      var x3 = x2 * x;
      var x4 = x3 * x; // approximation by taylor series in x at 0 up to order 4
      return -x4 / 4 + x3 / 3 - x2 / 2 + x;
    }
    return Math.log(x + 1);
  };
}
if (typeof Math.tanh === 'undefined') {
  var epsilon = 2.220446049250313E-16;
  var taylor_2_bound = Math.sqrt(epsilon);
  var taylor_n_bound = Math.sqrt(taylor_2_bound);
  Math.tanh = function (x) {
    if (Math.abs(x) < taylor_n_bound) {
      var result = x;
      if (Math.abs(x) > taylor_2_bound) {
        result -= x * x * x / 3;
      }
      return result;
    } else {
      var a = Math.exp(+x), b = Math.exp(-x);
      return a === Infinity ? 1 : b === Infinity ? -1 : (a - b) / (a + b);
    }
  };
}
if (typeof Math.cosh === 'undefined') {
  Math.cosh = function (x) {
    var y = Math.exp(x);
    var y1 = 1 / y;
    if (!isFinite(y) || !isFinite(y1))
      return Math.exp(Math.abs(x) - Math.LN2);
    return (y + y1) / 2;
  };
}
if (typeof Math.log10 === 'undefined') {
  Math.log10 = function (x) {
    return Math.log(x) * Math.LOG10E;
  };
}
if (typeof Math.clz32 === 'undefined') {
  Math.clz32 = function (log, LN2) {
    return function (x) {
      var asUint = x >>> 0;
      if (asUint === 0) {
        return 32;
      }
      return 31 - (log(asUint) / LN2 | 0) | 0; // the "| 0" acts like math.floor
    };
  }(Math.log, Math.LN2);
}
if (typeof Math.sign === 'undefined') {
  Math.sign = function (x) {
    x = +x; // convert to a number
    if (x === 0 || isNaN(x)) {
      return Number(x);
    }
    return x > 0 ? 1 : -1;
  };
}
if (typeof Math.log2 === 'undefined') {
  Math.log2 = function (x) {
    return Math.log(x) * Math.LOG2E;
  };
}
//endregion
import {
  jsx as jsx,
  jsxs as jsxs,
} from 'react/jsx-runtime';
import {
  useEffect as useEffect,
  Fragment as Fragment,
  useRef as useRef,
} from 'react';
import { createRoot as createRoot } from 'react-dom/client';
//region block: imports
var imul_0 = Math.imul;
var trunc = Math.trunc;
var isView = ArrayBuffer.isView;
var clz32 = Math.clz32;
var cosh = Math.cosh;
var asinh_0 = Math.asinh;
var sinh = Math.sinh;
var log10 = Math.log10;
var expm1 = Math.expm1;
var log1p = Math.log1p;
var log2 = Math.log2;
var sign = Math.sign;
var tanh = Math.tanh;
//endregion
//region block: pre-declaration
class CharSequence {}
class Comparable {}
class Error_0 extends Error {
  static gc() {
    var $this = createExternalThis(this, Error, [null]);
    setPropertiesToThrowableInstance($this);
    init_kotlin_Error($this);
    return $this;
  }
  static i(message) {
    var $this = createExternalThis(this, Error, [message]);
    setPropertiesToThrowableInstance($this, message);
    init_kotlin_Error($this);
    return $this;
  }
}
class IrLinkageError extends Error_0 {
  static g(message) {
    var $this = this.i(message);
    captureStack($this, $this.f_1);
    return $this;
  }
}
class Iterable {}
class asIterable$$inlined$Iterable$1 {
  constructor($this_asIterable) {
    this.v1_1 = $this_asIterable;
  }
  h1() {
    return this.v1_1.h1();
  }
}
class Exception extends Error {
  static jb() {
    var $this = createExternalThis(this, Error, [null]);
    setPropertiesToThrowableInstance($this);
    init_kotlin_Exception($this);
    return $this;
  }
  static kb(message) {
    var $this = createExternalThis(this, Error, [message]);
    setPropertiesToThrowableInstance($this, message);
    init_kotlin_Exception($this);
    return $this;
  }
  static mb(cause) {
    var $this = createExternalThis(this, Error, [null, setupCauseParameter(cause)]);
    setPropertiesToThrowableInstance($this, VOID, cause);
    init_kotlin_Exception($this);
    return $this;
  }
}
class RuntimeException extends Exception {
  static c2() {
    var $this = this.jb();
    init_kotlin_RuntimeException($this);
    return $this;
  }
  static o9(message) {
    var $this = this.kb(message);
    init_kotlin_RuntimeException($this);
    return $this;
  }
  static lb(cause) {
    var $this = this.mb(cause);
    init_kotlin_RuntimeException($this);
    return $this;
  }
}
class KotlinNothingValueException extends RuntimeException {
  static z1() {
    var $this = this.c2();
    init_kotlin_KotlinNothingValueException($this);
    return $this;
  }
}
class Companion {
  constructor() {
    Companion_instance = this;
    this.e2_1 = _Char___init__impl__6a9atx(0);
    this.f2_1 = _Char___init__impl__6a9atx(65535);
    this.g2_1 = _Char___init__impl__6a9atx(55296);
    this.h2_1 = _Char___init__impl__6a9atx(56319);
    this.i2_1 = _Char___init__impl__6a9atx(56320);
    this.j2_1 = _Char___init__impl__6a9atx(57343);
    this.k2_1 = _Char___init__impl__6a9atx(55296);
    this.l2_1 = _Char___init__impl__6a9atx(57343);
    this.m2_1 = 2;
    this.n2_1 = 16;
  }
}
class Char {
  constructor(value) {
    Companion_getInstance();
    this.d2_1 = value;
  }
  o2(other) {
    return Char__compareTo_impl_ypi4mb(this.d2_1, other);
  }
  d(other) {
    return Char__compareTo_impl_ypi4mb_0(this, other);
  }
  toString() {
    return toString(this.d2_1);
  }
  equals(other) {
    return Char__equals_impl_x6719k(this.d2_1, other);
  }
  hashCode() {
    return Char__hashCode_impl_otmys(this.d2_1);
  }
}
class Companion_0 {
  p2(array) {
    return createListFrom(array);
  }
}
class Collection {}
class KtList {}
function asJsReadonlyArrayView() {
  return createJsReadonlyArrayViewFrom(this);
}
class Companion_1 {
  x2(set) {
    return createSetFrom(set);
  }
}
class KtSet {}
function asJsReadonlySetView() {
  return createJsReadonlySetViewFrom(this);
}
class Entry {}
class KtMap {}
class MutableIterable {}
class MutableCollection {}
class Companion_2 {}
class Enum {
  constructor(name, ordinal) {
    this.f3_1 = name;
    this.g3_1 = ordinal;
  }
  h3() {
    return this.f3_1;
  }
  i3() {
    return this.g3_1;
  }
  j3(other) {
    return compareTo(this.g3_1, other.g3_1);
  }
  d(other) {
    return this.j3(other instanceof Enum ? other : THROW_CCE());
  }
  equals(other) {
    return this === other;
  }
  hashCode() {
    return identityHashCode(this);
  }
  toString() {
    return this.f3_1;
  }
}
class FunctionAdapter {}
class arrayIterator$1 {
  constructor($array) {
    this.m3_1 = $array;
    this.l3_1 = 0;
  }
  i1() {
    return !(this.l3_1 === this.m3_1.length);
  }
  j1() {
    var tmp;
    if (!(this.l3_1 === this.m3_1.length)) {
      var _unary__edvuaz = this.l3_1;
      this.l3_1 = _unary__edvuaz + 1 | 0;
      tmp = this.m3_1[_unary__edvuaz];
    } else {
      throw NoSuchElementException.g1('' + this.l3_1);
    }
    return tmp;
  }
}
class JsArrayView extends Array {}
class JsSetView extends Set {}
class Digit {
  constructor() {
    Digit_instance = this;
    var tmp = this;
    // Inline function 'kotlin.intArrayOf' call
    tmp.l4_1 = new Int32Array([48, 1632, 1776, 1984, 2406, 2534, 2662, 2790, 2918, 3046, 3174, 3302, 3430, 3558, 3664, 3792, 3872, 4160, 4240, 6112, 6160, 6470, 6608, 6784, 6800, 6992, 7088, 7232, 7248, 42528, 43216, 43264, 43472, 43504, 43600, 44016, 65296]);
  }
}
class Letter {
  constructor() {
    Letter_instance = this;
    var toBase64 = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
    var fromBase64 = new Int32Array(128);
    var inductionVariable = 0;
    var last = charSequenceLength(toBase64) - 1 | 0;
    if (inductionVariable <= last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        // Inline function 'kotlin.code' call
        var this_0 = charCodeAt(toBase64, i);
        fromBase64[Char__toInt_impl_vasixd(this_0)] = i;
      }
       while (inductionVariable <= last);
    var rangeStartDiff = 'hCgBpCQGYHZH5BRpBPPPPPPRMP5BPPlCPP6BkEPPPPcPXPzBvBrB3BOiDoBHwD+E3DauCnFmBmB2D6E1BlBTiBmBlBP5BhBiBrBvBjBqBnBPRtBiCmCtBlB0BmB5BiB7BmBgEmChBZgCoEoGVpBSfRhBPqKQ2BwBYoFgB4CJuTiEvBuCuDrF5DgEgFlJ1DgFmBQtBsBRGsB+BPiBlD1EIjDPRPPPQPPPPPGQSQS/DxENVNU+B9zCwBwBPPCkDPNnBPqDYY1R8B7FkFgTgwGgwUwmBgKwBuBScmEP/BPPPPPPrBP8B7F1B/ErBqC6B7BiBmBfQsBUwCw/KwqIwLwETPcPjQgJxFgBlBsD';
    var diff = decodeVarLenBase64(rangeStartDiff, fromBase64, 222);
    var start = new Int32Array(diff.length);
    var inductionVariable_0 = 0;
    var last_0 = diff.length - 1 | 0;
    if (inductionVariable_0 <= last_0)
      do {
        var i_0 = inductionVariable_0;
        inductionVariable_0 = inductionVariable_0 + 1 | 0;
        if (i_0 === 0) {
          start[i_0] = diff[i_0];
        } else {
          start[i_0] = start[i_0 - 1 | 0] + diff[i_0] | 0;
        }
      }
       while (inductionVariable_0 <= last_0);
    this.m4_1 = start;
    var rangeLength = 'aaMBXHYH5BRpBPPPPPPRMP5BPPlCPPzBDOOPPcPXPzBvBjB3BOhDmBBpB7DoDYxB+EiBP1DoExBkBQhBekBPmBgBhBctBiBMWOOXhCsBpBkBUV3Ba4BkB0DlCgBXgBtD4FSdBfPhBPpKP0BvBXjEQ2CGsT8DhBtCqDpFvD1D3E0IrD2EkBJrBDOBsB+BPiBlB1EIjDPPPPPPPPPPPGPPMNLsBNPNPKCvBvBPPCkDPBmBPhDXXgD4B6FzEgDguG9vUtkB9JcuBSckEP/BPPPPPPBPf4FrBjEhBpC3B5BKaWPrBOwCk/KsCuLqDHPbPxPsFtEaaqDL';
    this.n4_1 = decodeVarLenBase64(rangeLength, fromBase64, 222);
    var rangeCategory = 'GFjgggUHGGFFZZZmzpz5qB6s6020B60ptltB6smt2sB60mz22B1+vv+8BZZ5s2850BW5q1ymtB506smzBF3q1q1qB1q1q1+Bgii4wDTm74g3KiggxqM60q1q1Bq1o1q1BF1qlrqrBZ2q5wprBGFZWWZGHFsjiooLowgmOowjkwCkgoiIk7ligGogiioBkwkiYkzj2oNoi+sbkwj04DghhkQ8wgiYkgoioDsgnkwC4gikQ//v+85BkwvoIsgoyI4yguI0whiwEowri4CoghsJowgqYowgm4DkwgsY/nwnzPowhmYkg6wI8yggZswikwHgxgmIoxgqYkwgk4DkxgmIkgoioBsgssoBgzgyI8g9gL8g9kI0wgwJoxgkoC0wgioFkw/wI0w53iF4gioYowjmgBHGq1qkgwBF1q1q8qBHwghuIwghyKk0goQkwgoQk3goQHGFHkyg0pBgxj6IoinkxDswno7Ikwhz9Bo0gioB8z48Rwli0xN0mpjoX8w78pDwltoqKHFGGwwgsIHFH3q1q16BFHWFZ1q10q1B2qlwq1B1q10q1B2q1yq1B6q1gq1Biq1qhxBir1qp1Bqt1q1qB1g1q1+B//3q16B///q1qBH/qlqq9Bholqq9B1i00a1q10qD1op1HkwmigEigiy6Cptogq1Bixo1kDq7/j00B2qgoBWGFm1lz50B6s5q1+BGWhggzhwBFFhgk4//Bo2jigE8wguI8wguI8wgugUog1qoB4qjmIwwi2KgkYHHH4lBgiFWkgIWoghssMmz5smrBZ3q1y50B5sm7gzBtz1smzB5smz50BqzqtmzB5sgzqzBF2/9//5BowgoIwmnkzPkwgk4C8ys65BkgoqI0wgy6FghquZo2giY0ghiIsgh24B4ghsQ8QF/v1q1OFs0O8iCHHF1qggz/B8wg6Iznv+//B08QgohsjK0QGFk7hsQ4gB';
    this.o4_1 = decodeVarLenBase64(rangeCategory, fromBase64, 222);
  }
}
class Comparator {}
class Unit {
  toString() {
    return 'kotlin.Unit';
  }
}
class AbstractCollection {
  static r4() {
    return createThis(this);
  }
  q2(element) {
    var tmp$ret$0;
    $l$block_0: {
      // Inline function 'kotlin.collections.any' call
      var tmp;
      if (isInterface(this, Collection)) {
        tmp = this.p1();
      } else {
        tmp = false;
      }
      if (tmp) {
        tmp$ret$0 = false;
        break $l$block_0;
      }
      var _iterator__ex2g4s = this.h1();
      while (_iterator__ex2g4s.i1()) {
        var element_0 = _iterator__ex2g4s.j1();
        if (equals(element_0, element)) {
          tmp$ret$0 = true;
          break $l$block_0;
        }
      }
      tmp$ret$0 = false;
    }
    return tmp$ret$0;
  }
  r2(elements) {
    var tmp$ret$0;
    $l$block_0: {
      // Inline function 'kotlin.collections.all' call
      var tmp;
      if (isInterface(elements, Collection)) {
        tmp = elements.p1();
      } else {
        tmp = false;
      }
      if (tmp) {
        tmp$ret$0 = true;
        break $l$block_0;
      }
      var _iterator__ex2g4s = elements.h1();
      while (_iterator__ex2g4s.i1()) {
        var element = _iterator__ex2g4s.j1();
        if (!this.q2(element)) {
          tmp$ret$0 = false;
          break $l$block_0;
        }
      }
      tmp$ret$0 = true;
    }
    return tmp$ret$0;
  }
  p1() {
    return this.k1() === 0;
  }
  toString() {
    return joinToString_1(this, ', ', '[', ']', VOID, VOID, AbstractCollection$toString$lambda(this));
  }
  toArray() {
    return collectionToArray(this);
  }
}
class AbstractMutableCollection extends AbstractCollection {
  static q4() {
    return this.r4();
  }
  e3(element) {
    this.s4();
    var iterator = this.h1();
    while (iterator.i1()) {
      if (equals(iterator.j1(), element)) {
        iterator.t4();
        return true;
      }
    }
    return false;
  }
  o1(elements) {
    this.s4();
    var modified = false;
    var _iterator__ex2g4s = elements.h1();
    while (_iterator__ex2g4s.i1()) {
      var element = _iterator__ex2g4s.j1();
      if (this.c1(element))
        modified = true;
    }
    return modified;
  }
  u4() {
    this.s4();
    var iterator = this.h1();
    while (iterator.i1()) {
      iterator.j1();
      iterator.t4();
    }
  }
  toJSON() {
    return this.toArray();
  }
  s4() {
  }
}
class IteratorImpl {
  constructor($outer, $box) {
    boxApply(this, $box);
    this.x4_1 = $outer;
    this.v4_1 = 0;
    this.w4_1 = -1;
  }
  i1() {
    return this.v4_1 < this.x4_1.k1();
  }
  j1() {
    if (!this.i1())
      throw NoSuchElementException.y4();
    var tmp = this;
    var _unary__edvuaz = this.v4_1;
    this.v4_1 = _unary__edvuaz + 1 | 0;
    tmp.w4_1 = _unary__edvuaz;
    return this.x4_1.l1(this.w4_1);
  }
  t4() {
    // Inline function 'kotlin.check' call
    if (!!(this.w4_1 === -1)) {
      var message = 'Call next() or previous() before removing element from the iterator.';
      throw IllegalStateException.w3(toString_1(message));
    }
    this.x4_1.a5(this.w4_1);
    this.v4_1 = this.w4_1;
    this.w4_1 = -1;
  }
}
class ListIteratorImpl extends IteratorImpl {
  constructor($outer, index, $box) {
    if ($box === VOID)
      $box = {};
    $box.e5_1 = $outer;
    super($outer, $box);
    Companion_instance_6.f5(index, this.e5_1.k1());
    this.v4_1 = index;
  }
  g5() {
    return this.v4_1 > 0;
  }
  h5() {
    return this.v4_1;
  }
  i5() {
    if (!this.g5())
      throw NoSuchElementException.y4();
    var tmp = this;
    this.v4_1 = this.v4_1 - 1 | 0;
    tmp.w4_1 = this.v4_1;
    return this.e5_1.l1(this.w4_1);
  }
}
class AbstractMutableList extends AbstractMutableCollection {
  static o5() {
    var $this = this.q4();
    $this.z4_1 = 0;
    return $this;
  }
  s5(_set____db54di) {
    this.z4_1 = _set____db54di;
  }
  t5() {
    return this.z4_1;
  }
  c1(element) {
    this.s4();
    this.p5(this.k1(), element);
    return true;
  }
  u4() {
    this.s4();
    this.r5(0, this.k1());
  }
  u5(elements) {
    this.s4();
    return removeAll(this, AbstractMutableList$removeAll$lambda(elements));
  }
  v5(elements) {
    this.s4();
    return removeAll(this, AbstractMutableList$retainAll$lambda(elements));
  }
  h1() {
    return new IteratorImpl(this);
  }
  q2(element) {
    return this.s2(element) >= 0;
  }
  s2(element) {
    var tmp$ret$1;
    $l$block: {
      // Inline function 'kotlin.collections.indexOfFirst' call
      var index = 0;
      var _iterator__ex2g4s = this.h1();
      while (_iterator__ex2g4s.i1()) {
        var item = _iterator__ex2g4s.j1();
        if (equals(item, element)) {
          tmp$ret$1 = index;
          break $l$block;
        }
        index = index + 1 | 0;
      }
      tmp$ret$1 = -1;
    }
    return tmp$ret$1;
  }
  t2(element) {
    var tmp$ret$1;
    $l$block: {
      // Inline function 'kotlin.collections.indexOfLast' call
      var iterator = this.v2(this.k1());
      while (iterator.g5()) {
        var it = iterator.i5();
        if (equals(it, element)) {
          tmp$ret$1 = iterator.h5();
          break $l$block;
        }
      }
      tmp$ret$1 = -1;
    }
    return tmp$ret$1;
  }
  u2() {
    return this.v2(0);
  }
  v2(index) {
    return new ListIteratorImpl(this, index);
  }
  w2(fromIndex, toIndex) {
    return SubList.n5(this, fromIndex, toIndex);
  }
  r5(fromIndex, toIndex) {
    var iterator = this.v2(fromIndex);
    // Inline function 'kotlin.repeat' call
    var times = toIndex - fromIndex | 0;
    var inductionVariable = 0;
    if (inductionVariable < times)
      do {
        var index = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        iterator.j1();
        iterator.t4();
      }
       while (inductionVariable < times);
  }
  equals(other) {
    if (other === this)
      return true;
    if (!(!(other == null) ? isInterface(other, KtList) : false))
      return false;
    return Companion_instance_6.w5(this, other);
  }
  hashCode() {
    return Companion_instance_6.x5(this);
  }
}
class RandomAccess {}
class SubList extends AbstractMutableList {
  static n5(list, fromIndex, toIndex) {
    var $this = this.o5();
    $this.k5_1 = list;
    $this.l5_1 = fromIndex;
    $this.m5_1 = 0;
    Companion_instance_6.k4($this.l5_1, toIndex, $this.k5_1.k1());
    $this.m5_1 = toIndex - $this.l5_1 | 0;
    return $this;
  }
  p5(index, element) {
    Companion_instance_6.f5(index, this.m5_1);
    this.k5_1.p5(this.l5_1 + index | 0, element);
    this.m5_1 = this.m5_1 + 1 | 0;
  }
  l1(index) {
    Companion_instance_6.q5(index, this.m5_1);
    return this.k5_1.l1(this.l5_1 + index | 0);
  }
  a5(index) {
    Companion_instance_6.q5(index, this.m5_1);
    var result = this.k5_1.a5(this.l5_1 + index | 0);
    this.m5_1 = this.m5_1 - 1 | 0;
    return result;
  }
  p4(index, element) {
    Companion_instance_6.q5(index, this.m5_1);
    return this.k5_1.p4(this.l5_1 + index | 0, element);
  }
  r5(fromIndex, toIndex) {
    this.k5_1.r5(this.l5_1 + fromIndex | 0, this.l5_1 + toIndex | 0);
    this.m5_1 = this.m5_1 - (toIndex - fromIndex | 0) | 0;
  }
  k1() {
    return this.m5_1;
  }
  s4() {
    return this.k5_1.s4();
  }
}
class AbstractMap {
  static f6() {
    var $this = createThis(this);
    $this.d6_1 = null;
    $this.e6_1 = null;
    return $this;
  }
  a3(key) {
    return !(implFindEntry(this, key) == null);
  }
  b3(value) {
    var tmp0 = this.d3();
    var tmp$ret$0;
    $l$block_0: {
      // Inline function 'kotlin.collections.any' call
      var tmp;
      if (isInterface(tmp0, Collection)) {
        tmp = tmp0.p1();
      } else {
        tmp = false;
      }
      if (tmp) {
        tmp$ret$0 = false;
        break $l$block_0;
      }
      var _iterator__ex2g4s = tmp0.h1();
      while (_iterator__ex2g4s.i1()) {
        var element = _iterator__ex2g4s.j1();
        if (equals(element.z2(), value)) {
          tmp$ret$0 = true;
          break $l$block_0;
        }
      }
      tmp$ret$0 = false;
    }
    return tmp$ret$0;
  }
  q6(entry) {
    if (!(!(entry == null) ? isInterface(entry, Entry) : false))
      return false;
    var key = entry.y2();
    var value = entry.z2();
    // Inline function 'kotlin.collections.get' call
    var ourValue = (isInterface(this, KtMap) ? this : THROW_CCE()).c3(key);
    if (!equals(value, ourValue)) {
      return false;
    }
    var tmp;
    if (ourValue == null) {
      // Inline function 'kotlin.collections.containsKey' call
      tmp = !(isInterface(this, KtMap) ? this : THROW_CCE()).a3(key);
    } else {
      tmp = false;
    }
    if (tmp) {
      return false;
    }
    return true;
  }
  equals(other) {
    if (other === this)
      return true;
    if (!(!(other == null) ? isInterface(other, KtMap) : false))
      return false;
    if (!(this.k1() === other.k1()))
      return false;
    var tmp0 = other.d3();
    var tmp$ret$0;
    $l$block_0: {
      // Inline function 'kotlin.collections.all' call
      var tmp;
      if (isInterface(tmp0, Collection)) {
        tmp = tmp0.p1();
      } else {
        tmp = false;
      }
      if (tmp) {
        tmp$ret$0 = true;
        break $l$block_0;
      }
      var _iterator__ex2g4s = tmp0.h1();
      while (_iterator__ex2g4s.i1()) {
        var element = _iterator__ex2g4s.j1();
        if (!this.q6(element)) {
          tmp$ret$0 = false;
          break $l$block_0;
        }
      }
      tmp$ret$0 = true;
    }
    return tmp$ret$0;
  }
  c3(key) {
    var tmp0_safe_receiver = implFindEntry(this, key);
    return tmp0_safe_receiver == null ? null : tmp0_safe_receiver.z2();
  }
  hashCode() {
    return hashCode(this.d3());
  }
  k1() {
    return this.d3().k1();
  }
  toString() {
    var tmp = this.d3();
    return joinToString_1(tmp, ', ', '{', '}', VOID, VOID, AbstractMap$toString$lambda(this));
  }
}
class AbstractMutableMap extends AbstractMap {
  static c6() {
    var $this = this.f6();
    $this.a6_1 = null;
    $this.b6_1 = null;
    return $this;
  }
  g6() {
    return HashMapKeysDefault.i6(this);
  }
  j6() {
    return HashMapValuesDefault.l6(this);
  }
  m6() {
    var tmp0_elvis_lhs = this.a6_1;
    var tmp;
    if (tmp0_elvis_lhs == null) {
      // Inline function 'kotlin.also' call
      var this_0 = this.g6();
      this.a6_1 = this_0;
      tmp = this_0;
    } else {
      tmp = tmp0_elvis_lhs;
    }
    return tmp;
  }
  n6() {
    var tmp0_elvis_lhs = this.b6_1;
    var tmp;
    if (tmp0_elvis_lhs == null) {
      // Inline function 'kotlin.also' call
      var this_0 = this.j6();
      this.b6_1 = this_0;
      tmp = this_0;
    } else {
      tmp = tmp0_elvis_lhs;
    }
    return tmp;
  }
  u4() {
    this.d3().u4();
  }
  p6(key) {
    this.s4();
    var iter = this.d3().h1();
    while (iter.i1()) {
      var entry = iter.j1();
      var k = entry.y2();
      if (equals(key, k)) {
        var value = entry.z2();
        iter.t4();
        return value;
      }
    }
    return null;
  }
  s4() {
  }
}
class AbstractMutableSet extends AbstractMutableCollection {
  static r6() {
    return this.q4();
  }
  equals(other) {
    if (other === this)
      return true;
    if (!(!(other == null) ? isInterface(other, KtSet) : false))
      return false;
    return Companion_instance_8.s6(this, other);
  }
  hashCode() {
    return Companion_instance_8.t6(this);
  }
}
class Companion_3 {
  constructor() {
    Companion_instance_3 = this;
    var tmp = this;
    // Inline function 'kotlin.also' call
    var this_0 = ArrayList.n1(0);
    this_0.r_1 = true;
    tmp.u6_1 = this_0;
  }
}
class ArrayList extends AbstractMutableList {
  static r3(array) {
    Companion_getInstance_3();
    var $this = this.o5();
    $this.q_1 = array;
    $this.r_1 = false;
    return $this;
  }
  static q1() {
    Companion_getInstance_3();
    // Inline function 'kotlin.emptyArray' call
    var tmp$ret$0 = [];
    return this.r3(tmp$ret$0);
  }
  static n1(initialCapacity) {
    Companion_getInstance_3();
    // Inline function 'kotlin.emptyArray' call
    var tmp$ret$0 = [];
    var $this = this.r3(tmp$ret$0);
    // Inline function 'kotlin.require' call
    if (!(initialCapacity >= 0)) {
      var message = 'Negative initial capacity: ' + initialCapacity;
      throw IllegalArgumentException.w(toString_1(message));
    }
    return $this;
  }
  static s(elements) {
    Companion_getInstance_3();
    // Inline function 'kotlin.collections.toTypedArray' call
    var tmp$ret$0 = copyToArray(elements);
    return this.r3(tmp$ret$0);
  }
  s3() {
    this.s4();
    this.r_1 = true;
    return this.k1() > 0 ? this : Companion_getInstance_3().u6_1;
  }
  v6() {
  }
  w6(minCapacity) {
  }
  k1() {
    return this.q_1.length;
  }
  l1(index) {
    var tmp = this.q_1[rangeCheck(this, index)];
    return (tmp == null ? true : !(tmp == null)) ? tmp : THROW_CCE();
  }
  p4(index, element) {
    this.s4();
    rangeCheck(this, index);
    // Inline function 'kotlin.apply' call
    var this_0 = this.q_1[index];
    this.q_1[index] = element;
    var tmp = this_0;
    return (tmp == null ? true : !(tmp == null)) ? tmp : THROW_CCE();
  }
  c1(element) {
    this.s4();
    // Inline function 'kotlin.js.asDynamic' call
    this.q_1.push(element);
    this.z4_1 = this.z4_1 + 1 | 0;
    return true;
  }
  p5(index, element) {
    this.s4();
    // Inline function 'kotlin.js.asDynamic' call
    this.q_1.splice(insertionRangeCheck(this, index), 0, element);
    this.z4_1 = this.z4_1 + 1 | 0;
  }
  o1(elements) {
    this.s4();
    if (elements.p1())
      return false;
    var offset = increaseLength(this, elements.k1());
    // Inline function 'kotlin.collections.forEachIndexed' call
    var index = 0;
    var _iterator__ex2g4s = elements.h1();
    while (_iterator__ex2g4s.i1()) {
      var item = _iterator__ex2g4s.j1();
      var _unary__edvuaz = index;
      index = _unary__edvuaz + 1 | 0;
      var index_0 = checkIndexOverflow(_unary__edvuaz);
      this.q_1[offset + index_0 | 0] = item;
    }
    this.z4_1 = this.z4_1 + 1 | 0;
    return true;
  }
  x6(index, elements) {
    this.s4();
    insertionRangeCheck(this, index);
    if (index === this.k1())
      return this.o1(elements);
    if (elements.p1())
      return false;
    // Inline function 'kotlin.js.asDynamic' call
    // Inline function 'kotlin.js.unsafeCast' call
    var tail = this.q_1.splice(index);
    this.o1(elements);
    var offset = increaseLength(this, tail.length);
    // Inline function 'kotlin.repeat' call
    var times = tail.length;
    var inductionVariable = 0;
    if (inductionVariable < times)
      do {
        var index_0 = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        this.q_1[offset + index_0 | 0] = tail[index_0];
      }
       while (inductionVariable < times);
    this.z4_1 = this.z4_1 + 1 | 0;
    return true;
  }
  a5(index) {
    this.s4();
    rangeCheck(this, index);
    this.z4_1 = this.z4_1 + 1 | 0;
    var tmp;
    if (index === get_lastIndex_0(this)) {
      // Inline function 'kotlin.js.asDynamic' call
      tmp = this.q_1.pop();
    } else {
      // Inline function 'kotlin.js.asDynamic' call
      tmp = this.q_1.splice(index, 1)[0];
    }
    return tmp;
  }
  e3(element) {
    this.s4();
    var inductionVariable = 0;
    var last = this.q_1.length - 1 | 0;
    if (inductionVariable <= last)
      do {
        var index = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        if (equals(this.q_1[index], element)) {
          // Inline function 'kotlin.js.asDynamic' call
          this.q_1.splice(index, 1);
          this.z4_1 = this.z4_1 + 1 | 0;
          return true;
        }
      }
       while (inductionVariable <= last);
    return false;
  }
  r5(fromIndex, toIndex) {
    this.s4();
    this.z4_1 = this.z4_1 + 1 | 0;
    // Inline function 'kotlin.js.asDynamic' call
    this.q_1.splice(fromIndex, toIndex - fromIndex | 0);
  }
  u4() {
    this.s4();
    var tmp = this;
    // Inline function 'kotlin.emptyArray' call
    tmp.q_1 = [];
    this.z4_1 = this.z4_1 + 1 | 0;
  }
  s2(element) {
    return indexOf(this.q_1, element);
  }
  t2(element) {
    return lastIndexOf(this.q_1, element);
  }
  toString() {
    return arrayToString(this.q_1);
  }
  y6(array) {
    if (array.length < this.k1()) {
      var tmp = this.z6();
      return isArray(tmp) ? tmp : THROW_CCE();
    }
    var tmp_0 = this.q_1;
    // Inline function 'kotlin.collections.copyInto' call
    var this_0 = isArray(tmp_0) ? tmp_0 : THROW_CCE();
    var endIndex = this_0.length;
    arrayCopy(this_0, array, 0, 0, endIndex);
    return terminateCollectionToArray(this.k1(), array);
  }
  z6() {
    return [].slice.call(this.q_1);
  }
  toArray() {
    return this.z6();
  }
  a7() {
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    return this.q_1;
  }
  s4() {
    if (this.r_1)
      throw UnsupportedOperationException.q3();
  }
}
class HashMap extends AbstractMutableMap {
  static h7(internalMap) {
    var $this = this.c6();
    init_kotlin_collections_HashMap($this);
    $this.f7_1 = internalMap;
    return $this;
  }
  static i7() {
    return this.h7(InternalHashMap.t7());
  }
  static u7(initialCapacity, loadFactor) {
    return this.h7(InternalHashMap.v7(initialCapacity, loadFactor));
  }
  static w7(initialCapacity) {
    return this.u7(initialCapacity, 1.0);
  }
  u4() {
    this.f7_1.u4();
  }
  a3(key) {
    return this.f7_1.x7(key);
  }
  b3(value) {
    return this.f7_1.b3(value);
  }
  g6() {
    return HashMapKeys.z7(this.f7_1);
  }
  j6() {
    return HashMapValues.b8(this.f7_1);
  }
  d3() {
    var tmp0_elvis_lhs = this.g7_1;
    var tmp;
    if (tmp0_elvis_lhs == null) {
      // Inline function 'kotlin.also' call
      var this_0 = HashMapEntrySet.d8(this.f7_1);
      this.g7_1 = this_0;
      tmp = this_0;
    } else {
      tmp = tmp0_elvis_lhs;
    }
    return tmp;
  }
  c3(key) {
    return this.f7_1.c3(key);
  }
  o6(key, value) {
    return this.f7_1.o6(key, value);
  }
  p6(key) {
    return this.f7_1.p6(key);
  }
  k1() {
    return this.f7_1.k1();
  }
}
class HashMapKeys extends AbstractMutableSet {
  static z7(backing) {
    var $this = this.r6();
    $this.y7_1 = backing;
    return $this;
  }
  k1() {
    return this.y7_1.k1();
  }
  p1() {
    return this.y7_1.k1() === 0;
  }
  q2(element) {
    return this.y7_1.x7(element);
  }
  u4() {
    return this.y7_1.u4();
  }
  c1(element) {
    throw UnsupportedOperationException.q3();
  }
  o1(elements) {
    throw UnsupportedOperationException.q3();
  }
  e3(element) {
    return this.y7_1.e8(element);
  }
  h1() {
    return this.y7_1.f8();
  }
  s4() {
    return this.y7_1.g8();
  }
}
class HashMapValues extends AbstractMutableCollection {
  static b8(backing) {
    var $this = this.q4();
    $this.a8_1 = backing;
    return $this;
  }
  k1() {
    return this.a8_1.k1();
  }
  p1() {
    return this.a8_1.k1() === 0;
  }
  h8(element) {
    return this.a8_1.b3(element);
  }
  q2(element) {
    if (!(element == null ? true : !(element == null)))
      return false;
    return this.h8((element == null ? true : !(element == null)) ? element : THROW_CCE());
  }
  i8(element) {
    throw UnsupportedOperationException.q3();
  }
  c1(element) {
    return this.i8((element == null ? true : !(element == null)) ? element : THROW_CCE());
  }
  j8(elements) {
    throw UnsupportedOperationException.q3();
  }
  o1(elements) {
    return this.j8(elements);
  }
  h1() {
    return this.a8_1.k8();
  }
  l8(element) {
    return this.a8_1.m8(element);
  }
  e3(element) {
    if (!(element == null ? true : !(element == null)))
      return false;
    return this.l8((element == null ? true : !(element == null)) ? element : THROW_CCE());
  }
  s4() {
    return this.a8_1.g8();
  }
}
class HashMapEntrySetBase extends AbstractMutableSet {
  static o8(backing) {
    var $this = this.r6();
    $this.n8_1 = backing;
    return $this;
  }
  k1() {
    return this.n8_1.k1();
  }
  p1() {
    return this.n8_1.k1() === 0;
  }
  q8(element) {
    return this.n8_1.t8(element);
  }
  q2(element) {
    if (!(!(element == null) ? isInterface(element, Entry) : false))
      return false;
    return this.q8((!(element == null) ? isInterface(element, Entry) : false) ? element : THROW_CCE());
  }
  u4() {
    return this.n8_1.u4();
  }
  r8(element) {
    throw UnsupportedOperationException.q3();
  }
  c1(element) {
    return this.r8((!(element == null) ? isInterface(element, Entry) : false) ? element : THROW_CCE());
  }
  o1(elements) {
    throw UnsupportedOperationException.q3();
  }
  s8(element) {
    return this.n8_1.u8(element);
  }
  e3(element) {
    if (!(!(element == null) ? isInterface(element, Entry) : false))
      return false;
    return this.s8((!(element == null) ? isInterface(element, Entry) : false) ? element : THROW_CCE());
  }
  r2(elements) {
    return this.n8_1.v8(elements);
  }
  s4() {
    return this.n8_1.g8();
  }
}
class HashMapEntrySet extends HashMapEntrySetBase {
  static d8(backing) {
    return this.o8(backing);
  }
  h1() {
    return this.n8_1.p8();
  }
}
class HashMapKeysDefault$iterator$1 {
  constructor($entryIterator) {
    this.w8_1 = $entryIterator;
  }
  i1() {
    return this.w8_1.i1();
  }
  j1() {
    return this.w8_1.j1().y2();
  }
  t4() {
    return this.w8_1.t4();
  }
}
class HashMapKeysDefault extends AbstractMutableSet {
  static i6(backingMap) {
    var $this = this.r6();
    $this.h6_1 = backingMap;
    return $this;
  }
  x8(element) {
    throw UnsupportedOperationException.y8('Add is not supported on keys');
  }
  c1(element) {
    return this.x8((element == null ? true : !(element == null)) ? element : THROW_CCE());
  }
  u4() {
    return this.h6_1.u4();
  }
  x7(element) {
    return this.h6_1.a3(element);
  }
  q2(element) {
    if (!(element == null ? true : !(element == null)))
      return false;
    return this.x7((element == null ? true : !(element == null)) ? element : THROW_CCE());
  }
  h1() {
    var entryIterator = this.h6_1.d3().h1();
    return new HashMapKeysDefault$iterator$1(entryIterator);
  }
  p6(element) {
    this.s4();
    if (this.h6_1.a3(element)) {
      this.h6_1.p6(element);
      return true;
    }
    return false;
  }
  e3(element) {
    if (!(element == null ? true : !(element == null)))
      return false;
    return this.p6((element == null ? true : !(element == null)) ? element : THROW_CCE());
  }
  k1() {
    return this.h6_1.k1();
  }
  s4() {
    return this.h6_1.s4();
  }
}
class HashMapValuesDefault$iterator$1 {
  constructor($entryIterator) {
    this.z8_1 = $entryIterator;
  }
  i1() {
    return this.z8_1.i1();
  }
  j1() {
    return this.z8_1.j1().z2();
  }
  t4() {
    return this.z8_1.t4();
  }
}
class HashMapValuesDefault extends AbstractMutableCollection {
  static l6(backingMap) {
    var $this = this.q4();
    $this.k6_1 = backingMap;
    return $this;
  }
  i8(element) {
    throw UnsupportedOperationException.y8('Add is not supported on values');
  }
  c1(element) {
    return this.i8((element == null ? true : !(element == null)) ? element : THROW_CCE());
  }
  h8(element) {
    return this.k6_1.b3(element);
  }
  q2(element) {
    if (!(element == null ? true : !(element == null)))
      return false;
    return this.h8((element == null ? true : !(element == null)) ? element : THROW_CCE());
  }
  h1() {
    var entryIterator = this.k6_1.d3().h1();
    return new HashMapValuesDefault$iterator$1(entryIterator);
  }
  k1() {
    return this.k6_1.k1();
  }
  s4() {
    return this.k6_1.s4();
  }
}
class HashSet extends AbstractMutableSet {
  static b9(map) {
    var $this = this.r6();
    init_kotlin_collections_HashSet($this);
    $this.a9_1 = map;
    return $this;
  }
  static c9() {
    return this.b9(InternalHashMap.t7());
  }
  static d9(elements) {
    var $this = this.b9(InternalHashMap.e9(elements.k1()));
    var _iterator__ex2g4s = elements.h1();
    while (_iterator__ex2g4s.i1()) {
      var element = _iterator__ex2g4s.j1();
      $this.a9_1.o6(element, true);
    }
    return $this;
  }
  static f9(initialCapacity, loadFactor) {
    return this.b9(InternalHashMap.v7(initialCapacity, loadFactor));
  }
  static g9(initialCapacity) {
    return this.f9(initialCapacity, 1.0);
  }
  c1(element) {
    return this.a9_1.o6(element, true) == null;
  }
  u4() {
    this.a9_1.u4();
  }
  q2(element) {
    return this.a9_1.x7(element);
  }
  p1() {
    return this.a9_1.k1() === 0;
  }
  h1() {
    return this.a9_1.f8();
  }
  e3(element) {
    return !(this.a9_1.p6(element) == null);
  }
  k1() {
    return this.a9_1.k1();
  }
}
class Companion_4 {
  constructor() {
    this.q9_1 = -1640531527;
    this.r9_1 = 8;
    this.s9_1 = 2;
    this.t9_1 = -1;
  }
}
class Itr {
  constructor(map) {
    this.u9_1 = map;
    this.v9_1 = 0;
    this.w9_1 = -1;
    this.x9_1 = this.u9_1.q7_1;
    this.y9();
  }
  y9() {
    while (this.v9_1 < this.u9_1.o7_1 && this.u9_1.l7_1[this.v9_1] < 0) {
      this.v9_1 = this.v9_1 + 1 | 0;
    }
  }
  i1() {
    return this.v9_1 < this.u9_1.o7_1;
  }
  t4() {
    this.z9();
    // Inline function 'kotlin.check' call
    if (!!(this.w9_1 === -1)) {
      var message = 'Call next() before removing element from the iterator.';
      throw IllegalStateException.w3(toString_1(message));
    }
    this.u9_1.g8();
    removeEntryAt(this.u9_1, this.w9_1);
    this.w9_1 = -1;
    this.x9_1 = this.u9_1.q7_1;
  }
  z9() {
    if (!(this.u9_1.q7_1 === this.x9_1))
      throw ConcurrentModificationException.aa();
  }
}
class KeysItr extends Itr {
  j1() {
    this.z9();
    if (this.v9_1 >= this.u9_1.o7_1)
      throw NoSuchElementException.y4();
    var tmp = this;
    var _unary__edvuaz = this.v9_1;
    this.v9_1 = _unary__edvuaz + 1 | 0;
    tmp.w9_1 = _unary__edvuaz;
    var result = this.u9_1.j7_1[this.w9_1];
    this.y9();
    return result;
  }
}
class ValuesItr extends Itr {
  j1() {
    this.z9();
    if (this.v9_1 >= this.u9_1.o7_1)
      throw NoSuchElementException.y4();
    var tmp = this;
    var _unary__edvuaz = this.v9_1;
    this.v9_1 = _unary__edvuaz + 1 | 0;
    tmp.w9_1 = _unary__edvuaz;
    var result = ensureNotNull(this.u9_1.k7_1)[this.w9_1];
    this.y9();
    return result;
  }
}
class EntriesItr extends Itr {
  j1() {
    this.z9();
    if (this.v9_1 >= this.u9_1.o7_1)
      throw NoSuchElementException.y4();
    var tmp = this;
    var _unary__edvuaz = this.v9_1;
    this.v9_1 = _unary__edvuaz + 1 | 0;
    tmp.w9_1 = _unary__edvuaz;
    var result = new EntryRef(this.u9_1, this.w9_1);
    this.y9();
    return result;
  }
  na() {
    if (this.v9_1 >= this.u9_1.o7_1)
      throw NoSuchElementException.y4();
    var tmp = this;
    var _unary__edvuaz = this.v9_1;
    this.v9_1 = _unary__edvuaz + 1 | 0;
    tmp.w9_1 = _unary__edvuaz;
    // Inline function 'kotlin.hashCode' call
    var tmp0_safe_receiver = this.u9_1.j7_1[this.w9_1];
    var tmp1_elvis_lhs = tmp0_safe_receiver == null ? null : hashCode(tmp0_safe_receiver);
    var tmp_0 = tmp1_elvis_lhs == null ? 0 : tmp1_elvis_lhs;
    // Inline function 'kotlin.hashCode' call
    var tmp0_safe_receiver_0 = ensureNotNull(this.u9_1.k7_1)[this.w9_1];
    var tmp1_elvis_lhs_0 = tmp0_safe_receiver_0 == null ? null : hashCode(tmp0_safe_receiver_0);
    var result = tmp_0 ^ (tmp1_elvis_lhs_0 == null ? 0 : tmp1_elvis_lhs_0);
    this.y9();
    return result;
  }
  oa(sb) {
    if (this.v9_1 >= this.u9_1.o7_1)
      throw NoSuchElementException.y4();
    var tmp = this;
    var _unary__edvuaz = this.v9_1;
    this.v9_1 = _unary__edvuaz + 1 | 0;
    tmp.w9_1 = _unary__edvuaz;
    var key = this.u9_1.j7_1[this.w9_1];
    if (equals(key, this.u9_1))
      sb.qa('(this Map)');
    else
      sb.pa(key);
    sb.ra(_Char___init__impl__6a9atx(61));
    var value = ensureNotNull(this.u9_1.k7_1)[this.w9_1];
    if (equals(value, this.u9_1))
      sb.qa('(this Map)');
    else
      sb.pa(value);
    this.y9();
  }
}
class EntryRef {
  constructor(map, index) {
    this.l9_1 = map;
    this.m9_1 = index;
    this.n9_1 = this.l9_1.q7_1;
  }
  y2() {
    checkForComodification(this);
    return this.l9_1.j7_1[this.m9_1];
  }
  z2() {
    checkForComodification(this);
    return ensureNotNull(this.l9_1.k7_1)[this.m9_1];
  }
  equals(other) {
    var tmp;
    var tmp_0;
    if (!(other == null) ? isInterface(other, Entry) : false) {
      tmp_0 = equals(other.y2(), this.y2());
    } else {
      tmp_0 = false;
    }
    if (tmp_0) {
      tmp = equals(other.z2(), this.z2());
    } else {
      tmp = false;
    }
    return tmp;
  }
  hashCode() {
    // Inline function 'kotlin.hashCode' call
    var tmp0_safe_receiver = this.y2();
    var tmp1_elvis_lhs = tmp0_safe_receiver == null ? null : hashCode(tmp0_safe_receiver);
    var tmp = tmp1_elvis_lhs == null ? 0 : tmp1_elvis_lhs;
    // Inline function 'kotlin.hashCode' call
    var tmp0_safe_receiver_0 = this.z2();
    var tmp1_elvis_lhs_0 = tmp0_safe_receiver_0 == null ? null : hashCode(tmp0_safe_receiver_0);
    return tmp ^ (tmp1_elvis_lhs_0 == null ? 0 : tmp1_elvis_lhs_0);
  }
  toString() {
    return toString_0(this.y2()) + '=' + toString_0(this.z2());
  }
}
class InternalMap {}
function containsAllEntries(m) {
  var tmp$ret$0;
  $l$block_0: {
    // Inline function 'kotlin.collections.all' call
    var tmp;
    if (isInterface(m, Collection)) {
      tmp = m.p1();
    } else {
      tmp = false;
    }
    if (tmp) {
      tmp$ret$0 = true;
      break $l$block_0;
    }
    var _iterator__ex2g4s = m.h1();
    while (_iterator__ex2g4s.i1()) {
      var element = _iterator__ex2g4s.j1();
      // Inline function 'kotlin.js.unsafeCast' call
      // Inline function 'kotlin.js.asDynamic' call
      var entry = element;
      var tmp_0;
      if (!(entry == null) ? isInterface(entry, Entry) : false) {
        tmp_0 = this.va(entry);
      } else {
        tmp_0 = false;
      }
      if (!tmp_0) {
        tmp$ret$0 = false;
        break $l$block_0;
      }
    }
    tmp$ret$0 = true;
  }
  return tmp$ret$0;
}
class InternalHashMap {
  static sa(keysArray, valuesArray, presenceArray, hashArray, maxProbeDistance, length) {
    var $this = createThis(this);
    $this.j7_1 = keysArray;
    $this.k7_1 = valuesArray;
    $this.l7_1 = presenceArray;
    $this.m7_1 = hashArray;
    $this.n7_1 = maxProbeDistance;
    $this.o7_1 = length;
    $this.p7_1 = computeShift(Companion_instance_4, _get_hashSize__tftcho($this));
    $this.q7_1 = 0;
    $this.r7_1 = 0;
    $this.s7_1 = false;
    return $this;
  }
  k1() {
    return this.r7_1;
  }
  static t7() {
    return this.e9(8);
  }
  static e9(initialCapacity) {
    return this.sa(arrayOfUninitializedElements(initialCapacity), null, new Int32Array(initialCapacity), new Int32Array(computeHashSize(Companion_instance_4, initialCapacity)), 2, 0);
  }
  static v7(initialCapacity, loadFactor) {
    var $this = this.e9(initialCapacity);
    // Inline function 'kotlin.require' call
    if (!(loadFactor > 0)) {
      var message = 'Non-positive load factor: ' + loadFactor;
      throw IllegalArgumentException.w(toString_1(message));
    }
    return $this;
  }
  ta() {
    this.g8();
    this.s7_1 = true;
  }
  b3(value) {
    return findValue(this, value) >= 0;
  }
  c3(key) {
    var index = findKey(this, key);
    if (index < 0)
      return null;
    return ensureNotNull(this.k7_1)[index];
  }
  x7(key) {
    return findKey(this, key) >= 0;
  }
  o6(key, value) {
    var index = addKey(this, key);
    var valuesArray = allocateValuesArray(this);
    if (index < 0) {
      var oldValue = valuesArray[(-index | 0) - 1 | 0];
      valuesArray[(-index | 0) - 1 | 0] = value;
      return oldValue;
    } else {
      valuesArray[index] = value;
      return null;
    }
  }
  p6(key) {
    this.g8();
    var index = findKey(this, key);
    if (index < 0)
      return null;
    var oldValue = ensureNotNull(this.k7_1)[index];
    removeEntryAt(this, index);
    return oldValue;
  }
  u4() {
    this.g8();
    var inductionVariable = 0;
    var last = this.o7_1 - 1 | 0;
    if (inductionVariable <= last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        var hash = this.l7_1[i];
        if (hash >= 0) {
          this.m7_1[hash] = 0;
          this.l7_1[i] = -1;
        }
      }
       while (!(i === last));
    resetRange(this.j7_1, 0, this.o7_1);
    var tmp0_safe_receiver = this.k7_1;
    if (tmp0_safe_receiver == null)
      null;
    else {
      resetRange(tmp0_safe_receiver, 0, this.o7_1);
    }
    this.r7_1 = 0;
    this.o7_1 = 0;
    registerModification(this);
  }
  equals(other) {
    var tmp;
    if (other === this) {
      tmp = true;
    } else {
      var tmp_0;
      if (!(other == null) ? isInterface(other, KtMap) : false) {
        tmp_0 = contentEquals_1(this, other);
      } else {
        tmp_0 = false;
      }
      tmp = tmp_0;
    }
    return tmp;
  }
  hashCode() {
    var result = 0;
    var it = this.p8();
    while (it.i1()) {
      result = result + it.na() | 0;
    }
    return result;
  }
  toString() {
    var sb = StringBuilder.ua(2 + imul_0(this.r7_1, 3) | 0);
    sb.qa('{');
    var i = 0;
    var it = this.p8();
    while (it.i1()) {
      if (i > 0) {
        sb.qa(', ');
      }
      it.oa(sb);
      i = i + 1 | 0;
    }
    sb.qa('}');
    return sb.toString();
  }
  g8() {
    if (this.s7_1)
      throw UnsupportedOperationException.q3();
  }
  e8(key) {
    this.g8();
    var index = findKey(this, key);
    if (index < 0)
      return false;
    removeEntryAt(this, index);
    return true;
  }
  t8(entry) {
    var index = findKey(this, entry.y2());
    if (index < 0)
      return false;
    return equals(ensureNotNull(this.k7_1)[index], entry.z2());
  }
  va(entry) {
    return this.t8(isInterface(entry, Entry) ? entry : THROW_CCE());
  }
  u8(entry) {
    this.g8();
    var index = findKey(this, entry.y2());
    if (index < 0)
      return false;
    if (!equals(ensureNotNull(this.k7_1)[index], entry.z2()))
      return false;
    removeEntryAt(this, index);
    return true;
  }
  m8(value) {
    this.g8();
    var index = findValue(this, value);
    if (index < 0)
      return false;
    removeEntryAt(this, index);
    return true;
  }
  f8() {
    return new KeysItr(this);
  }
  k8() {
    return new ValuesItr(this);
  }
  p8() {
    return new EntriesItr(this);
  }
}
class EmptyHolder {
  constructor() {
    EmptyHolder_instance = this;
    var tmp = this;
    // Inline function 'kotlin.also' call
    var this_0 = InternalHashMap.e9(0);
    this_0.ta();
    tmp.wa_1 = LinkedHashSet.xa(this_0);
  }
}
class LinkedHashSet extends HashSet {
  static m1() {
    var $this = this.c9();
    init_kotlin_collections_LinkedHashSet($this);
    return $this;
  }
  static r1(elements) {
    var $this = this.d9(elements);
    init_kotlin_collections_LinkedHashSet($this);
    return $this;
  }
  static ya(initialCapacity, loadFactor) {
    var $this = this.f9(initialCapacity, loadFactor);
    init_kotlin_collections_LinkedHashSet($this);
    return $this;
  }
  static b1(initialCapacity) {
    return this.ya(initialCapacity, 1.0);
  }
  static xa(internalMap) {
    var $this = this.b9(internalMap);
    init_kotlin_collections_LinkedHashSet($this);
    return $this;
  }
  s3() {
    this.a9_1.ta();
    return this.k1() > 0 ? this : EmptyHolder_getInstance().wa_1;
  }
  s4() {
    return this.a9_1.g8();
  }
}
class BaseOutput {
  za() {
    this.ab('\n');
  }
  bb(message) {
    this.ab(message);
    this.za();
  }
}
class NodeJsOutput extends BaseOutput {
  constructor(outputStream) {
    super();
    this.cb_1 = outputStream;
  }
  ab(message) {
    // Inline function 'kotlin.io.String' call
    var tmp1_elvis_lhs = message == null ? null : toString_1(message);
    var messageString = tmp1_elvis_lhs == null ? 'null' : tmp1_elvis_lhs;
    this.cb_1.write(messageString);
  }
}
class BufferedOutput extends BaseOutput {
  constructor() {
    super();
    this.eb_1 = '';
  }
  ab(message) {
    var tmp = this;
    var tmp_0 = this.eb_1;
    // Inline function 'kotlin.io.String' call
    var tmp1_elvis_lhs = message == null ? null : toString_1(message);
    tmp.eb_1 = tmp_0 + (tmp1_elvis_lhs == null ? 'null' : tmp1_elvis_lhs);
  }
}
class BufferedOutputToConsoleLog extends BufferedOutput {
  ab(message) {
    // Inline function 'kotlin.io.String' call
    var tmp1_elvis_lhs = message == null ? null : toString_1(message);
    var s = tmp1_elvis_lhs == null ? 'null' : tmp1_elvis_lhs;
    // Inline function 'kotlin.text.nativeLastIndexOf' call
    // Inline function 'kotlin.js.asDynamic' call
    var i = s.lastIndexOf('\n', 0);
    if (i >= 0) {
      this.eb_1 = this.eb_1 + substring(s, 0, i);
      this.fb();
      s = substring_0(s, i + 1 | 0);
    }
    this.eb_1 = this.eb_1 + s;
  }
  fb() {
    console.log(this.eb_1);
    this.eb_1 = '';
  }
}
class UnsupportedOperationException extends RuntimeException {
  static q3() {
    var $this = this.c2();
    init_kotlin_UnsupportedOperationException($this);
    return $this;
  }
  static y8(message) {
    var $this = this.o9(message);
    init_kotlin_UnsupportedOperationException($this);
    return $this;
  }
}
class IllegalStateException extends RuntimeException {
  static gb() {
    var $this = this.c2();
    init_kotlin_IllegalStateException($this);
    return $this;
  }
  static w3(message) {
    var $this = this.o9(message);
    init_kotlin_IllegalStateException($this);
    return $this;
  }
}
class IllegalArgumentException extends RuntimeException {
  static hb() {
    var $this = this.c2();
    init_kotlin_IllegalArgumentException($this);
    return $this;
  }
  static w(message) {
    var $this = this.o9(message);
    init_kotlin_IllegalArgumentException($this);
    return $this;
  }
}
class NoSuchElementException extends RuntimeException {
  static y4() {
    var $this = this.c2();
    init_kotlin_NoSuchElementException($this);
    return $this;
  }
  static g1(message) {
    var $this = this.o9(message);
    init_kotlin_NoSuchElementException($this);
    return $this;
  }
}
class IndexOutOfBoundsException extends RuntimeException {
  static qb() {
    var $this = this.c2();
    init_kotlin_IndexOutOfBoundsException($this);
    return $this;
  }
  static rb(message) {
    var $this = this.o9(message);
    init_kotlin_IndexOutOfBoundsException($this);
    return $this;
  }
}
class ClassCastException extends RuntimeException {
  static i4() {
    var $this = this.c2();
    init_kotlin_ClassCastException($this);
    return $this;
  }
}
class NumberFormatException extends IllegalArgumentException {
  static wb() {
    var $this = this.hb();
    init_kotlin_NumberFormatException($this);
    return $this;
  }
  static xb(message) {
    var $this = this.w(message);
    init_kotlin_NumberFormatException($this);
    return $this;
  }
}
class ArithmeticException extends RuntimeException {
  static bc() {
    var $this = this.c2();
    init_kotlin_ArithmeticException($this);
    return $this;
  }
  static cc(message) {
    var $this = this.o9(message);
    init_kotlin_ArithmeticException($this);
    return $this;
  }
}
class AssertionError extends Error_0 {
  static fc() {
    var $this = this.gc();
    init_kotlin_AssertionError($this);
    return $this;
  }
  static hc(message) {
    var $this = this.i(message);
    init_kotlin_AssertionError($this);
    return $this;
  }
}
class ConcurrentModificationException extends RuntimeException {
  static aa() {
    var $this = this.c2();
    init_kotlin_ConcurrentModificationException($this);
    return $this;
  }
  static k9(message) {
    var $this = this.o9(message);
    init_kotlin_ConcurrentModificationException($this);
    return $this;
  }
}
class NullPointerException extends RuntimeException {
  static a4() {
    var $this = this.c2();
    init_kotlin_NullPointerException($this);
    return $this;
  }
  static ic(message) {
    var $this = this.o9(message);
    init_kotlin_NullPointerException($this);
    return $this;
  }
}
class UninitializedPropertyAccessException extends RuntimeException {
  static jc() {
    var $this = this.c2();
    init_kotlin_UninitializedPropertyAccessException($this);
    return $this;
  }
  static o(message) {
    var $this = this.o9(message);
    init_kotlin_UninitializedPropertyAccessException($this);
    return $this;
  }
}
class NoWhenBranchMatchedException extends RuntimeException {
  static e4() {
    var $this = this.c2();
    init_kotlin_NoWhenBranchMatchedException($this);
    return $this;
  }
}
class KClass {}
class KClassImpl {
  equals(other) {
    var tmp;
    if (other instanceof NothingKClassImpl) {
      tmp = false;
    } else {
      if (other instanceof KClassImpl) {
        tmp = equals(this.oc(), other.oc());
      } else {
        tmp = false;
      }
    }
    return tmp;
  }
  hashCode() {
    var tmp0_safe_receiver = this.kc();
    var tmp1_elvis_lhs = tmp0_safe_receiver == null ? null : getStringHashCode(tmp0_safe_receiver);
    return tmp1_elvis_lhs == null ? 0 : tmp1_elvis_lhs;
  }
  toString() {
    return 'class ' + this.kc();
  }
}
class PrimitiveKClassImpl extends KClassImpl {
  constructor(jClass, givenSimpleName, isInstanceFunction) {
    super();
    this.lc_1 = jClass;
    this.mc_1 = givenSimpleName;
    this.nc_1 = isInstanceFunction;
  }
  oc() {
    return this.lc_1;
  }
  equals(other) {
    if (!(other instanceof PrimitiveKClassImpl))
      return false;
    return super.equals(other) && this.mc_1 === other.mc_1;
  }
  kc() {
    return this.mc_1;
  }
}
class NothingKClassImpl extends KClassImpl {
  constructor() {
    NothingKClassImpl_instance = null;
    super();
    NothingKClassImpl_instance = this;
    this.pc_1 = 'Nothing';
  }
  kc() {
    return this.pc_1;
  }
  oc() {
    throw UnsupportedOperationException.y8("There's no native JS class for Nothing type");
  }
  equals(other) {
    return other === this;
  }
  hashCode() {
    return 0;
  }
}
class SimpleKClassImpl extends KClassImpl {
  constructor(jClass) {
    super();
    this.qc_1 = jClass;
    var tmp = this;
    // Inline function 'kotlin.js.asDynamic' call
    var tmp0_safe_receiver = this.qc_1.$metadata$;
    // Inline function 'kotlin.js.unsafeCast' call
    tmp.rc_1 = tmp0_safe_receiver == null ? null : tmp0_safe_receiver.simpleName;
  }
  oc() {
    return this.qc_1;
  }
  kc() {
    return this.rc_1;
  }
}
class KProperty1 {}
class KMutableProperty1 {}
class PrimitiveClasses {
  constructor() {
    PrimitiveClasses_instance = this;
    var tmp = this;
    // Inline function 'kotlin.js.unsafeCast' call
    var tmp_0 = Object;
    tmp.anyClass = new PrimitiveKClassImpl(tmp_0, 'Any', PrimitiveClasses$anyClass$lambda);
    var tmp_1 = this;
    // Inline function 'kotlin.js.unsafeCast' call
    var tmp_2 = Number;
    tmp_1.numberClass = new PrimitiveKClassImpl(tmp_2, 'Number', PrimitiveClasses$numberClass$lambda);
    this.nothingClass = NothingKClassImpl_getInstance();
    var tmp_3 = this;
    // Inline function 'kotlin.js.unsafeCast' call
    var tmp_4 = Boolean;
    tmp_3.booleanClass = new PrimitiveKClassImpl(tmp_4, 'Boolean', PrimitiveClasses$booleanClass$lambda);
    var tmp_5 = this;
    // Inline function 'kotlin.js.unsafeCast' call
    var tmp_6 = Number;
    tmp_5.byteClass = new PrimitiveKClassImpl(tmp_6, 'Byte', PrimitiveClasses$byteClass$lambda);
    var tmp_7 = this;
    // Inline function 'kotlin.js.unsafeCast' call
    var tmp_8 = Number;
    tmp_7.shortClass = new PrimitiveKClassImpl(tmp_8, 'Short', PrimitiveClasses$shortClass$lambda);
    var tmp_9 = this;
    // Inline function 'kotlin.js.unsafeCast' call
    var tmp_10 = Number;
    tmp_9.intClass = new PrimitiveKClassImpl(tmp_10, 'Int', PrimitiveClasses$intClass$lambda);
    var tmp_11 = this;
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var tmp_12 = typeof BigInt === 'undefined' ? VOID : BigInt;
    tmp_11.longClass = new PrimitiveKClassImpl(tmp_12, 'Long', PrimitiveClasses$longClass$lambda);
    var tmp_13 = this;
    // Inline function 'kotlin.js.unsafeCast' call
    var tmp_14 = Number;
    tmp_13.floatClass = new PrimitiveKClassImpl(tmp_14, 'Float', PrimitiveClasses$floatClass$lambda);
    var tmp_15 = this;
    // Inline function 'kotlin.js.unsafeCast' call
    var tmp_16 = Number;
    tmp_15.doubleClass = new PrimitiveKClassImpl(tmp_16, 'Double', PrimitiveClasses$doubleClass$lambda);
    var tmp_17 = this;
    // Inline function 'kotlin.js.unsafeCast' call
    var tmp_18 = Array;
    tmp_17.arrayClass = new PrimitiveKClassImpl(tmp_18, 'Array', PrimitiveClasses$arrayClass$lambda);
    var tmp_19 = this;
    // Inline function 'kotlin.js.unsafeCast' call
    var tmp_20 = String;
    tmp_19.stringClass = new PrimitiveKClassImpl(tmp_20, 'String', PrimitiveClasses$stringClass$lambda);
    var tmp_21 = this;
    // Inline function 'kotlin.js.unsafeCast' call
    var tmp_22 = Error;
    tmp_21.throwableClass = new PrimitiveKClassImpl(tmp_22, 'Throwable', PrimitiveClasses$throwableClass$lambda);
    var tmp_23 = this;
    // Inline function 'kotlin.js.unsafeCast' call
    var tmp_24 = Array;
    tmp_23.booleanArrayClass = new PrimitiveKClassImpl(tmp_24, 'BooleanArray', PrimitiveClasses$booleanArrayClass$lambda);
    var tmp_25 = this;
    // Inline function 'kotlin.js.unsafeCast' call
    var tmp_26 = Uint16Array;
    tmp_25.charArrayClass = new PrimitiveKClassImpl(tmp_26, 'CharArray', PrimitiveClasses$charArrayClass$lambda);
    var tmp_27 = this;
    // Inline function 'kotlin.js.unsafeCast' call
    var tmp_28 = Int8Array;
    tmp_27.byteArrayClass = new PrimitiveKClassImpl(tmp_28, 'ByteArray', PrimitiveClasses$byteArrayClass$lambda);
    var tmp_29 = this;
    // Inline function 'kotlin.js.unsafeCast' call
    var tmp_30 = Int16Array;
    tmp_29.shortArrayClass = new PrimitiveKClassImpl(tmp_30, 'ShortArray', PrimitiveClasses$shortArrayClass$lambda);
    var tmp_31 = this;
    // Inline function 'kotlin.js.unsafeCast' call
    var tmp_32 = Int32Array;
    tmp_31.intArrayClass = new PrimitiveKClassImpl(tmp_32, 'IntArray', PrimitiveClasses$intArrayClass$lambda);
    var tmp_33 = this;
    // Inline function 'kotlin.js.unsafeCast' call
    var tmp_34 = Float32Array;
    tmp_33.floatArrayClass = new PrimitiveKClassImpl(tmp_34, 'FloatArray', PrimitiveClasses$floatArrayClass$lambda);
    var tmp_35 = this;
    // Inline function 'kotlin.js.unsafeCast' call
    var tmp_36 = Float64Array;
    tmp_35.doubleArrayClass = new PrimitiveKClassImpl(tmp_36, 'DoubleArray', PrimitiveClasses$doubleArrayClass$lambda);
  }
  sc() {
    return this.anyClass;
  }
  tc() {
    return this.numberClass;
  }
  uc() {
    return this.nothingClass;
  }
  vc() {
    return this.booleanClass;
  }
  wc() {
    return this.byteClass;
  }
  xc() {
    return this.shortClass;
  }
  yc() {
    return this.intClass;
  }
  zc() {
    return this.longClass;
  }
  ad() {
    return this.floatClass;
  }
  bd() {
    return this.doubleClass;
  }
  cd() {
    return this.arrayClass;
  }
  dd() {
    return this.stringClass;
  }
  ed() {
    return this.throwableClass;
  }
  fd() {
    return this.booleanArrayClass;
  }
  gd() {
    return this.charArrayClass;
  }
  hd() {
    return this.byteArrayClass;
  }
  id() {
    return this.shortArrayClass;
  }
  jd() {
    return this.intArrayClass;
  }
  kd() {
    return this.floatArrayClass;
  }
  ld() {
    return this.doubleArrayClass;
  }
  functionClass(arity) {
    var tmp0_elvis_lhs = get_functionClasses()[arity];
    var tmp;
    if (tmp0_elvis_lhs == null) {
      // Inline function 'kotlin.run' call
      // Inline function 'kotlin.js.unsafeCast' call
      var tmp_0 = Function;
      var tmp_1 = 'Function' + arity;
      var result = new PrimitiveKClassImpl(tmp_0, tmp_1, PrimitiveClasses$functionClass$lambda(arity));
      // Inline function 'kotlin.js.asDynamic' call
      get_functionClasses()[arity] = result;
      tmp = result;
    } else {
      tmp = tmp0_elvis_lhs;
    }
    return tmp;
  }
}
class StringBuilder {
  static md(content) {
    var $this = createThis(this);
    $this.x_1 = content;
    return $this;
  }
  static ua(capacity) {
    return this.y();
  }
  static nd(content) {
    return this.md(toString_1(content));
  }
  static y() {
    return this.md('');
  }
  a() {
    // Inline function 'kotlin.js.asDynamic' call
    return this.x_1.length;
  }
  b(index) {
    // Inline function 'kotlin.text.getOrElse' call
    var this_0 = this.x_1;
    var tmp;
    if (0 <= index ? index <= (charSequenceLength(this_0) - 1 | 0) : false) {
      tmp = charSequenceGet(this_0, index);
    } else {
      throw IndexOutOfBoundsException.rb('index: ' + index + ', length: ' + this.a() + '}');
    }
    return tmp;
  }
  c(startIndex, endIndex) {
    return substring(this.x_1, startIndex, endIndex);
  }
  ra(value) {
    this.x_1 = this.x_1 + toString(value);
    return this;
  }
  z(value) {
    this.x_1 = this.x_1 + toString_0(value);
    return this;
  }
  pa(value) {
    this.x_1 = this.x_1 + toString_0(value);
    return this;
  }
  od(value) {
    this.x_1 = this.x_1 + value;
    return this;
  }
  pd(value) {
    return this.qa(value.toString());
  }
  qd(value) {
    return this.qa(value.toString());
  }
  qa(value) {
    var tmp = this;
    var tmp_0 = this.x_1;
    tmp.x_1 = tmp_0 + (value == null ? 'null' : value);
    return this;
  }
  rd(string, startIndex) {
    // Inline function 'kotlin.js.asDynamic' call
    return this.x_1.indexOf(string, startIndex);
  }
  sd(index, value) {
    Companion_instance_6.f5(index, this.a());
    this.x_1 = substring(this.x_1, 0, index) + toString(value) + substring_0(this.x_1, index);
    return this;
  }
  td(index, value) {
    Companion_instance_6.f5(index, this.a());
    this.x_1 = substring(this.x_1, 0, index) + toString_0(value) + substring_0(this.x_1, index);
    return this;
  }
  ud(index, value) {
    Companion_instance_6.f5(index, this.a());
    var toInsert = value == null ? 'null' : value;
    this.x_1 = substring(this.x_1, 0, index) + toInsert + substring_0(this.x_1, index);
    return this;
  }
  vd(startIndex) {
    Companion_instance_6.f5(startIndex, this.a());
    return substring_0(this.x_1, startIndex);
  }
  toString() {
    return this.x_1;
  }
  wd(index, value) {
    Companion_instance_6.q5(index, this.a());
    this.x_1 = substring(this.x_1, 0, index) + toString(value) + substring_0(this.x_1, index + 1 | 0);
  }
  xd(index) {
    Companion_instance_6.q5(index, this.a());
    this.x_1 = substring(this.x_1, 0, index) + substring_0(this.x_1, index + 1 | 0);
    return this;
  }
  yd(startIndex, endIndex) {
    checkReplaceRange(this, startIndex, endIndex, this.a());
    this.x_1 = substring(this.x_1, 0, startIndex) + substring_0(this.x_1, endIndex);
    return this;
  }
  zd(value, startIndex, endIndex) {
    var stringCsq = toString_1(value);
    Companion_instance_6.ae(startIndex, endIndex, stringCsq.length);
    this.x_1 = this.x_1 + substring(stringCsq, startIndex, endIndex);
    return this;
  }
}
class Companion_5 {
  constructor() {
    Companion_instance_5 = this;
    this.be_1 = new RegExp('[\\\\^$*+?.()|[\\]{}]', 'g');
    this.ce_1 = new RegExp('[\\\\$]', 'g');
    this.de_1 = new RegExp('\\$', 'g');
  }
  ee(literal) {
    // Inline function 'kotlin.text.nativeReplace' call
    var pattern = this.be_1;
    // Inline function 'kotlin.js.asDynamic' call
    return literal.replace(pattern, '\\$&');
  }
  fe(literal) {
    // Inline function 'kotlin.text.nativeReplace' call
    var pattern = this.de_1;
    // Inline function 'kotlin.js.asDynamic' call
    return literal.replace(pattern, '$$$$');
  }
}
class sam$kotlin_Comparator$0 {
  constructor(function_0) {
    this.ge_1 = function_0;
  }
  he(a, b) {
    return this.ge_1(a, b);
  }
  compare(a, b) {
    return this.he(a, b);
  }
  k3() {
    return this.ge_1;
  }
  equals(other) {
    var tmp;
    if (!(other == null) ? isInterface(other, Comparator) : false) {
      var tmp_0;
      if (!(other == null) ? isInterface(other, FunctionAdapter) : false) {
        tmp_0 = equals(this.k3(), other.k3());
      } else {
        tmp_0 = false;
      }
      tmp = tmp_0;
    } else {
      tmp = false;
    }
    return tmp;
  }
  hashCode() {
    return hashCode(this.k3());
  }
}
class ExceptionTraceBuilder {
  constructor() {
    this.ie_1 = StringBuilder.y();
    var tmp = this;
    // Inline function 'kotlin.arrayOf' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    tmp.je_1 = [];
    this.ke_1 = '';
    this.le_1 = 0;
  }
  me(exception) {
    dumpFullTrace(this, exception, '', '');
    return this.ie_1.toString();
  }
}
class Companion_6 {
  constructor() {
    this.j4_1 = 2147483639;
  }
  q5(index, size) {
    if (index < 0 || index >= size) {
      throw IndexOutOfBoundsException.rb('index: ' + index + ', size: ' + size);
    }
  }
  f5(index, size) {
    if (index < 0 || index > size) {
      throw IndexOutOfBoundsException.rb('index: ' + index + ', size: ' + size);
    }
  }
  k4(fromIndex, toIndex, size) {
    if (fromIndex < 0 || toIndex > size) {
      throw IndexOutOfBoundsException.rb('fromIndex: ' + fromIndex + ', toIndex: ' + toIndex + ', size: ' + size);
    }
    if (fromIndex > toIndex) {
      throw IllegalArgumentException.w('fromIndex: ' + fromIndex + ' > toIndex: ' + toIndex);
    }
  }
  ae(startIndex, endIndex, size) {
    if (startIndex < 0 || endIndex > size) {
      throw IndexOutOfBoundsException.rb('startIndex: ' + startIndex + ', endIndex: ' + endIndex + ', size: ' + size);
    }
    if (startIndex > endIndex) {
      throw IllegalArgumentException.w('startIndex: ' + startIndex + ' > endIndex: ' + endIndex);
    }
  }
  p9(oldCapacity, minCapacity) {
    var newCapacity = oldCapacity + (oldCapacity >> 1) | 0;
    if ((newCapacity - minCapacity | 0) < 0)
      newCapacity = minCapacity;
    if ((newCapacity - 2147483639 | 0) > 0)
      newCapacity = minCapacity > 2147483639 ? 2147483647 : 2147483639;
    return newCapacity;
  }
  x5(c) {
    var hashCode_0 = 1;
    var _iterator__ex2g4s = c.h1();
    while (_iterator__ex2g4s.i1()) {
      var e = _iterator__ex2g4s.j1();
      var tmp = imul_0(31, hashCode_0);
      var tmp1_elvis_lhs = e == null ? null : hashCode(e);
      hashCode_0 = tmp + (tmp1_elvis_lhs == null ? 0 : tmp1_elvis_lhs) | 0;
    }
    return hashCode_0;
  }
  w5(c, other) {
    if (!(c.k1() === other.k1()))
      return false;
    var otherIterator = other.h1();
    var _iterator__ex2g4s = c.h1();
    while (_iterator__ex2g4s.i1()) {
      var elem = _iterator__ex2g4s.j1();
      var elemOther = otherIterator.j1();
      if (!equals(elem, elemOther)) {
        return false;
      }
    }
    return true;
  }
}
class Companion_7 {}
class Companion_8 {
  t6(c) {
    var hashCode_0 = 0;
    var _iterator__ex2g4s = c.h1();
    while (_iterator__ex2g4s.i1()) {
      var element = _iterator__ex2g4s.j1();
      var tmp = hashCode_0;
      var tmp1_elvis_lhs = element == null ? null : hashCode(element);
      hashCode_0 = tmp + (tmp1_elvis_lhs == null ? 0 : tmp1_elvis_lhs) | 0;
    }
    return hashCode_0;
  }
  s6(c, other) {
    if (!(c.k1() === other.k1()))
      return false;
    return c.r2(other);
  }
}
class EmptyList {
  constructor() {
    this.ne_1 = -7390468764508069838n;
  }
  equals(other) {
    var tmp;
    if (!(other == null) ? isInterface(other, KtList) : false) {
      tmp = other.p1();
    } else {
      tmp = false;
    }
    return tmp;
  }
  hashCode() {
    return 1;
  }
  toString() {
    return '[]';
  }
  k1() {
    return 0;
  }
  p1() {
    return true;
  }
  oe(element) {
    return false;
  }
  q2(element) {
    if (!false)
      return false;
    var tmp;
    if (false) {
      tmp = element;
    } else {
      tmp = THROW_CCE();
    }
    return this.oe(tmp);
  }
  pe(elements) {
    return elements.p1();
  }
  r2(elements) {
    return this.pe(elements);
  }
  l1(index) {
    throw IndexOutOfBoundsException.rb("Empty list doesn't contain element at index " + index + '.');
  }
  qe(element) {
    return -1;
  }
  s2(element) {
    if (!false)
      return -1;
    var tmp;
    if (false) {
      tmp = element;
    } else {
      tmp = THROW_CCE();
    }
    return this.qe(tmp);
  }
  re(element) {
    return -1;
  }
  t2(element) {
    if (!false)
      return -1;
    var tmp;
    if (false) {
      tmp = element;
    } else {
      tmp = THROW_CCE();
    }
    return this.re(tmp);
  }
  h1() {
    return EmptyIterator_instance;
  }
  u2() {
    return EmptyIterator_instance;
  }
  v2(index) {
    if (!(index === 0))
      throw IndexOutOfBoundsException.rb('Index: ' + index);
    return EmptyIterator_instance;
  }
  w2(fromIndex, toIndex) {
    if (fromIndex === 0 && toIndex === 0)
      return this;
    throw IndexOutOfBoundsException.rb('fromIndex: ' + fromIndex + ', toIndex: ' + toIndex);
  }
}
class EmptyIterator {
  i1() {
    return false;
  }
  g5() {
    return false;
  }
  h5() {
    return 0;
  }
  j1() {
    throw NoSuchElementException.y4();
  }
  i5() {
    throw NoSuchElementException.y4();
  }
}
class ArrayAsCollection {
  constructor(values, isVarargs) {
    this.se_1 = values;
    this.te_1 = isVarargs;
  }
  k1() {
    return this.se_1.length;
  }
  p1() {
    // Inline function 'kotlin.collections.isEmpty' call
    return this.se_1.length === 0;
  }
  ue(element) {
    return contains_0(this.se_1, element);
  }
  q2(element) {
    if (!(element == null ? true : !(element == null)))
      return false;
    return this.ue((element == null ? true : !(element == null)) ? element : THROW_CCE());
  }
  h1() {
    return arrayIterator(this.se_1);
  }
}
class IntIterator {
  j1() {
    return this.ve();
  }
}
class EmptySet {
  constructor() {
    this.we_1 = 3406603774387020532n;
  }
  equals(other) {
    var tmp;
    if (!(other == null) ? isInterface(other, KtSet) : false) {
      tmp = other.p1();
    } else {
      tmp = false;
    }
    return tmp;
  }
  hashCode() {
    return 0;
  }
  toString() {
    return '[]';
  }
  k1() {
    return 0;
  }
  p1() {
    return true;
  }
  oe(element) {
    return false;
  }
  q2(element) {
    if (!false)
      return false;
    var tmp;
    if (false) {
      tmp = element;
    } else {
      tmp = THROW_CCE();
    }
    return this.oe(tmp);
  }
  pe(elements) {
    return elements.p1();
  }
  r2(elements) {
    return this.pe(elements);
  }
  h1() {
    return EmptyIterator_instance;
  }
}
class NaturalOrderComparator {
  xe(a, b) {
    return compareTo(a, b);
  }
  compare(a, b) {
    var tmp = (!(a == null) ? isComparable(a) : false) ? a : THROW_CCE();
    return this.xe(tmp, (!(b == null) ? isComparable(b) : false) ? b : THROW_CCE());
  }
}
class Delegates {}
class ObservableProperty {
  constructor(initialValue, $box) {
    boxApply(this, $box);
    this.ye_1 = initialValue;
  }
  ze(property, oldValue, newValue) {
    return true;
  }
  af(property, oldValue, newValue) {
  }
  bf(thisRef, property) {
    return this.ye_1;
  }
  cf(thisRef, property) {
    return this.bf((thisRef == null ? true : !(thisRef == null)) ? thisRef : THROW_CCE(), property);
  }
  df(thisRef, property, value) {
    var oldValue = this.ye_1;
    if (!this.ze(property, oldValue, value)) {
      return Unit_instance;
    }
    this.ye_1 = value;
    this.af(property, oldValue, value);
  }
  ef(thisRef, property, value) {
    var tmp = (thisRef == null ? true : !(thisRef == null)) ? thisRef : THROW_CCE();
    return this.df(tmp, property, (value == null ? true : !(value == null)) ? value : THROW_CCE());
  }
  toString() {
    return 'ObservableProperty(value=' + toString_0(this.ye_1) + ')';
  }
}
class Random {
  static hf() {
    Default_getInstance();
    return createThis(this);
  }
  ve() {
    return this.if(32);
  }
  kf(array, fromIndex, toIndex) {
    // Inline function 'kotlin.require' call
    if (!((0 <= fromIndex ? fromIndex <= array.length : false) && (0 <= toIndex ? toIndex <= array.length : false))) {
      var message = 'fromIndex (' + fromIndex + ') or toIndex (' + toIndex + ') are out of range: 0..' + array.length + '.';
      throw IllegalArgumentException.w(toString_1(message));
    }
    // Inline function 'kotlin.require' call
    if (!(fromIndex <= toIndex)) {
      var message_0 = 'fromIndex (' + fromIndex + ') must be not greater than toIndex (' + toIndex + ').';
      throw IllegalArgumentException.w(toString_1(message_0));
    }
    var steps = (toIndex - fromIndex | 0) / 4 | 0;
    var position = fromIndex;
    // Inline function 'kotlin.repeat' call
    var inductionVariable = 0;
    if (inductionVariable < steps)
      do {
        var index = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        var v = this.ve();
        array[position] = toByte(v);
        array[position + 1 | 0] = toByte(v >>> 8 | 0);
        array[position + 2 | 0] = toByte(v >>> 16 | 0);
        array[position + 3 | 0] = toByte(v >>> 24 | 0);
        position = position + 4 | 0;
      }
       while (inductionVariable < steps);
    var remainder = toIndex - position | 0;
    var vr = this.if(imul_0(remainder, 8));
    var inductionVariable_0 = 0;
    if (inductionVariable_0 < remainder)
      do {
        var i = inductionVariable_0;
        inductionVariable_0 = inductionVariable_0 + 1 | 0;
        array[position + i | 0] = toByte(vr >>> imul_0(i, 8) | 0);
      }
       while (inductionVariable_0 < remainder);
    return array;
  }
  jf(array) {
    return this.kf(array, 0, array.length);
  }
}
class Default extends Random {
  static gf() {
    Default_instance = null;
    var $this = this.hf();
    Default_instance = $this;
    $this.ff_1 = defaultPlatformRandom();
    return $this;
  }
  if(bitCount) {
    return this.ff_1.if(bitCount);
  }
  ve() {
    return this.ff_1.ve();
  }
  jf(array) {
    return this.ff_1.jf(array);
  }
  kf(array, fromIndex, toIndex) {
    return this.ff_1.kf(array, fromIndex, toIndex);
  }
}
class Companion_9 {
  constructor() {
    this.sf_1 = 0n;
  }
}
class XorWowRandom extends Random {
  static tf(x, y, z, w, v, addend) {
    var $this = this.hf();
    $this.lf_1 = x;
    $this.mf_1 = y;
    $this.nf_1 = z;
    $this.of_1 = w;
    $this.pf_1 = v;
    $this.qf_1 = addend;
    checkInvariants($this);
    // Inline function 'kotlin.repeat' call
    var inductionVariable = 0;
    if (inductionVariable < 64)
      do {
        var index = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        $this.ve();
      }
       while (inductionVariable < 64);
    return $this;
  }
  static rf(seed1, seed2) {
    return this.tf(seed1, seed2, 0, 0, ~seed1, seed1 << 10 ^ (seed2 >>> 4 | 0));
  }
  ve() {
    var t = this.lf_1;
    t = t ^ (t >>> 2 | 0);
    this.lf_1 = this.mf_1;
    this.mf_1 = this.nf_1;
    this.nf_1 = this.of_1;
    var v0 = this.pf_1;
    this.of_1 = v0;
    t = t ^ t << 1 ^ v0 ^ v0 << 4;
    this.pf_1 = t;
    this.qf_1 = this.qf_1 + 362437 | 0;
    return t + this.qf_1 | 0;
  }
  if(bitCount) {
    return takeUpperBits(this.ve(), bitCount);
  }
}
class Companion_10 {
  constructor() {
    Companion_instance_10 = this;
    this.s1_1 = new IntRange(1, 0);
  }
}
class IntProgression {
  constructor(start, endInclusive, step) {
    if (step === 0)
      throw IllegalArgumentException.w('Step must be non-zero.');
    if (step === -2147483648)
      throw IllegalArgumentException.w('Step must be greater than Int.MIN_VALUE to avoid overflow on negation.');
    this.yf_1 = start;
    this.zf_1 = getProgressionLastElement(start, endInclusive, step);
    this.ag_1 = step;
  }
  h1() {
    return new IntProgressionIterator(this.yf_1, this.zf_1, this.ag_1);
  }
  p1() {
    return this.ag_1 > 0 ? this.yf_1 > this.zf_1 : this.yf_1 < this.zf_1;
  }
  equals(other) {
    var tmp;
    if (other instanceof IntProgression) {
      tmp = this.p1() && other.p1() || (this.yf_1 === other.yf_1 && this.zf_1 === other.zf_1 && this.ag_1 === other.ag_1);
    } else {
      tmp = false;
    }
    return tmp;
  }
  hashCode() {
    return this.p1() ? -1 : imul_0(31, imul_0(31, this.yf_1) + this.zf_1 | 0) + this.ag_1 | 0;
  }
  toString() {
    return this.ag_1 > 0 ? '' + this.yf_1 + '..' + this.zf_1 + ' step ' + this.ag_1 : '' + this.yf_1 + ' downTo ' + this.zf_1 + ' step ' + (-this.ag_1 | 0);
  }
}
class ClosedRange {}
function contains(value) {
  return compareTo(value, this.xf()) >= 0 && compareTo(value, this.bg()) <= 0;
}
function isEmpty() {
  return compareTo(this.xf(), this.bg()) > 0;
}
class IntRange extends IntProgression {
  constructor(start, endInclusive) {
    Companion_getInstance_10();
    super(start, endInclusive, 1);
  }
  xf() {
    return this.yf_1;
  }
  bg() {
    return this.zf_1;
  }
  cg(value) {
    return this.yf_1 <= value && value <= this.zf_1;
  }
  u1(value) {
    return this.cg(typeof value === 'number' ? value : THROW_CCE());
  }
  p1() {
    return this.yf_1 > this.zf_1;
  }
  equals(other) {
    var tmp;
    if (other instanceof IntRange) {
      tmp = this.p1() && other.p1() || (this.yf_1 === other.yf_1 && this.zf_1 === other.zf_1);
    } else {
      tmp = false;
    }
    return tmp;
  }
  hashCode() {
    return this.p1() ? -1 : imul_0(31, this.yf_1) + this.zf_1 | 0;
  }
  toString() {
    return '' + this.yf_1 + '..' + this.zf_1;
  }
}
class IntProgressionIterator extends IntIterator {
  constructor(first, last, step) {
    super();
    this.dg_1 = step;
    this.eg_1 = last;
    this.fg_1 = this.dg_1 > 0 ? first <= last : first >= last;
    this.gg_1 = this.fg_1 ? first : this.eg_1;
  }
  i1() {
    return this.fg_1;
  }
  ve() {
    var value = this.gg_1;
    if (value === this.eg_1) {
      if (!this.fg_1)
        throw NoSuchElementException.y4();
      this.fg_1 = false;
    } else {
      this.gg_1 = this.gg_1 + this.dg_1 | 0;
    }
    return value;
  }
}
class Companion_11 {
  t1(rangeStart, rangeEnd, step) {
    return new IntProgression(rangeStart, rangeEnd, step);
  }
}
class Companion_12 {
  constructor() {
    Companion_instance_12 = this;
    this.vg_1 = new BytesHexFormat(2147483647, 2147483647, '  ', '', '', '');
  }
}
class Builder {
  constructor() {
    this.wg_1 = Companion_getInstance_13().hh_1.ah_1;
    this.xg_1 = Companion_getInstance_13().hh_1.bh_1;
    this.yg_1 = Companion_getInstance_13().hh_1.ch_1;
    this.zg_1 = Companion_getInstance_13().hh_1.dh_1;
  }
  ih(value) {
    if (contains_3(value, _Char___init__impl__6a9atx(10)) || contains_3(value, _Char___init__impl__6a9atx(13)))
      throw IllegalArgumentException.w('LF and CR characters are prohibited in prefix, but was ' + value);
    this.wg_1 = value;
  }
  s3() {
    return new NumberHexFormat(this.wg_1, this.xg_1, this.yg_1, this.zg_1);
  }
}
class Companion_13 {
  constructor() {
    Companion_instance_13 = this;
    this.hh_1 = new NumberHexFormat('', '', false, 1);
  }
}
class BytesHexFormat {
  constructor(bytesPerLine, bytesPerGroup, groupSeparator, byteSeparator, bytePrefix, byteSuffix) {
    Companion_getInstance_12();
    this.mg_1 = bytesPerLine;
    this.ng_1 = bytesPerGroup;
    this.og_1 = groupSeparator;
    this.pg_1 = byteSeparator;
    this.qg_1 = bytePrefix;
    this.rg_1 = byteSuffix;
    this.sg_1 = (this.mg_1 === 2147483647 && this.ng_1 === 2147483647);
    var tmp = this;
    var tmp_0;
    var tmp_1;
    // Inline function 'kotlin.text.isEmpty' call
    var this_0 = this.qg_1;
    if (charSequenceLength(this_0) === 0) {
      // Inline function 'kotlin.text.isEmpty' call
      var this_1 = this.rg_1;
      tmp_1 = charSequenceLength(this_1) === 0;
    } else {
      tmp_1 = false;
    }
    if (tmp_1) {
      tmp_0 = this.pg_1.length <= 1;
    } else {
      tmp_0 = false;
    }
    tmp.tg_1 = tmp_0;
    this.ug_1 = isCaseSensitive(this.og_1) || isCaseSensitive(this.pg_1) || isCaseSensitive(this.qg_1) || isCaseSensitive(this.rg_1);
  }
  toString() {
    // Inline function 'kotlin.text.buildString' call
    // Inline function 'kotlin.apply' call
    var this_0 = StringBuilder.y();
    // Inline function 'kotlin.text.appendLine' call
    this_0.qa('BytesHexFormat(').ra(_Char___init__impl__6a9atx(10));
    // Inline function 'kotlin.text.appendLine' call
    this.jh(this_0, '    ').ra(_Char___init__impl__6a9atx(10));
    this_0.qa(')');
    return this_0.toString();
  }
  jh(sb, indent) {
    // Inline function 'kotlin.text.appendLine' call
    // Inline function 'kotlin.text.appendLine' call
    sb.qa(indent).qa('bytesPerLine = ').pd(this.mg_1).qa(',').ra(_Char___init__impl__6a9atx(10));
    // Inline function 'kotlin.text.appendLine' call
    // Inline function 'kotlin.text.appendLine' call
    sb.qa(indent).qa('bytesPerGroup = ').pd(this.ng_1).qa(',').ra(_Char___init__impl__6a9atx(10));
    // Inline function 'kotlin.text.appendLine' call
    // Inline function 'kotlin.text.appendLine' call
    sb.qa(indent).qa('groupSeparator = "').qa(this.og_1).qa('",').ra(_Char___init__impl__6a9atx(10));
    // Inline function 'kotlin.text.appendLine' call
    // Inline function 'kotlin.text.appendLine' call
    sb.qa(indent).qa('byteSeparator = "').qa(this.pg_1).qa('",').ra(_Char___init__impl__6a9atx(10));
    // Inline function 'kotlin.text.appendLine' call
    // Inline function 'kotlin.text.appendLine' call
    sb.qa(indent).qa('bytePrefix = "').qa(this.qg_1).qa('",').ra(_Char___init__impl__6a9atx(10));
    sb.qa(indent).qa('byteSuffix = "').qa(this.rg_1).qa('"');
    return sb;
  }
}
class NumberHexFormat {
  constructor(prefix, suffix, removeLeadingZeros, minLength) {
    Companion_getInstance_13();
    this.ah_1 = prefix;
    this.bh_1 = suffix;
    this.ch_1 = removeLeadingZeros;
    this.dh_1 = minLength;
    var tmp = this;
    var tmp_0;
    // Inline function 'kotlin.text.isEmpty' call
    var this_0 = this.ah_1;
    if (charSequenceLength(this_0) === 0) {
      // Inline function 'kotlin.text.isEmpty' call
      var this_1 = this.bh_1;
      tmp_0 = charSequenceLength(this_1) === 0;
    } else {
      tmp_0 = false;
    }
    tmp.eh_1 = tmp_0;
    this.fh_1 = (this.eh_1 && this.dh_1 === 1);
    this.gh_1 = isCaseSensitive(this.ah_1) || isCaseSensitive(this.bh_1);
  }
  toString() {
    // Inline function 'kotlin.text.buildString' call
    // Inline function 'kotlin.apply' call
    var this_0 = StringBuilder.y();
    // Inline function 'kotlin.text.appendLine' call
    this_0.qa('NumberHexFormat(').ra(_Char___init__impl__6a9atx(10));
    // Inline function 'kotlin.text.appendLine' call
    this.jh(this_0, '    ').ra(_Char___init__impl__6a9atx(10));
    this_0.qa(')');
    return this_0.toString();
  }
  jh(sb, indent) {
    // Inline function 'kotlin.text.appendLine' call
    // Inline function 'kotlin.text.appendLine' call
    sb.qa(indent).qa('prefix = "').qa(this.ah_1).qa('",').ra(_Char___init__impl__6a9atx(10));
    // Inline function 'kotlin.text.appendLine' call
    // Inline function 'kotlin.text.appendLine' call
    sb.qa(indent).qa('suffix = "').qa(this.bh_1).qa('",').ra(_Char___init__impl__6a9atx(10));
    var tmp0 = sb.qa(indent).qa('removeLeadingZeros = ').od(this.ch_1);
    // Inline function 'kotlin.text.appendLine' call
    var value = _Char___init__impl__6a9atx(44);
    // Inline function 'kotlin.text.appendLine' call
    tmp0.ra(value).ra(_Char___init__impl__6a9atx(10));
    sb.qa(indent).qa('minLength = ').pd(this.dh_1);
    return sb;
  }
}
class Builder_0 {
  constructor() {
    this.kh_1 = Companion_getInstance_14().hg_1.jg_1;
    this.lh_1 = null;
    this.mh_1 = null;
  }
  nh() {
    if (this.mh_1 == null) {
      this.mh_1 = new Builder();
    }
    return ensureNotNull(this.mh_1);
  }
  s3() {
    var tmp = this.kh_1;
    var tmp0_safe_receiver = this.lh_1;
    var tmp1_elvis_lhs = tmp0_safe_receiver == null ? null : tmp0_safe_receiver.s3();
    var tmp_0 = tmp1_elvis_lhs == null ? Companion_getInstance_12().vg_1 : tmp1_elvis_lhs;
    var tmp2_safe_receiver = this.mh_1;
    var tmp3_elvis_lhs = tmp2_safe_receiver == null ? null : tmp2_safe_receiver.s3();
    return new HexFormat(tmp, tmp_0, tmp3_elvis_lhs == null ? Companion_getInstance_13().hh_1 : tmp3_elvis_lhs);
  }
}
class Companion_14 {
  constructor() {
    Companion_instance_14 = this;
    this.hg_1 = new HexFormat(false, Companion_getInstance_12().vg_1, Companion_getInstance_13().hh_1);
    this.ig_1 = new HexFormat(true, Companion_getInstance_12().vg_1, Companion_getInstance_13().hh_1);
  }
}
class HexFormat {
  constructor(upperCase, bytes, number) {
    Companion_getInstance_14();
    this.jg_1 = upperCase;
    this.kg_1 = bytes;
    this.lg_1 = number;
  }
  toString() {
    // Inline function 'kotlin.text.buildString' call
    // Inline function 'kotlin.apply' call
    var this_0 = StringBuilder.y();
    // Inline function 'kotlin.text.appendLine' call
    this_0.qa('HexFormat(').ra(_Char___init__impl__6a9atx(10));
    // Inline function 'kotlin.text.appendLine' call
    // Inline function 'kotlin.text.appendLine' call
    this_0.qa('    upperCase = ').od(this.jg_1).qa(',').ra(_Char___init__impl__6a9atx(10));
    // Inline function 'kotlin.text.appendLine' call
    this_0.qa('    bytes = BytesHexFormat(').ra(_Char___init__impl__6a9atx(10));
    // Inline function 'kotlin.text.appendLine' call
    this.kg_1.jh(this_0, '        ').ra(_Char___init__impl__6a9atx(10));
    // Inline function 'kotlin.text.appendLine' call
    this_0.qa('    ),').ra(_Char___init__impl__6a9atx(10));
    // Inline function 'kotlin.text.appendLine' call
    this_0.qa('    number = NumberHexFormat(').ra(_Char___init__impl__6a9atx(10));
    // Inline function 'kotlin.text.appendLine' call
    this.lg_1.jh(this_0, '        ').ra(_Char___init__impl__6a9atx(10));
    // Inline function 'kotlin.text.appendLine' call
    this_0.qa('    )').ra(_Char___init__impl__6a9atx(10));
    this_0.qa(')');
    return this_0.toString();
  }
}
class State {
  constructor() {
    this.uh_1 = 0;
    this.vh_1 = 1;
    this.wh_1 = 2;
  }
}
class LinesIterator {
  constructor(string) {
    this.xh_1 = string;
    this.yh_1 = 0;
    this.zh_1 = 0;
    this.ai_1 = 0;
    this.bi_1 = 0;
  }
  i1() {
    if (!(this.yh_1 === 0)) {
      return this.yh_1 === 1;
    }
    if (this.bi_1 < 0) {
      this.yh_1 = 2;
      return false;
    }
    var _delimiterLength = -1;
    var _delimiterStartIndex = charSequenceLength(this.xh_1);
    var inductionVariable = this.zh_1;
    var last = charSequenceLength(this.xh_1);
    if (inductionVariable < last)
      $l$loop: do {
        var idx = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        var c = charSequenceGet(this.xh_1, idx);
        if (c === _Char___init__impl__6a9atx(10) || c === _Char___init__impl__6a9atx(13)) {
          _delimiterLength = c === _Char___init__impl__6a9atx(13) && (idx + 1 | 0) < charSequenceLength(this.xh_1) && charSequenceGet(this.xh_1, idx + 1 | 0) === _Char___init__impl__6a9atx(10) ? 2 : 1;
          _delimiterStartIndex = idx;
          break $l$loop;
        }
      }
       while (inductionVariable < last);
    this.yh_1 = 1;
    this.bi_1 = _delimiterLength;
    this.ai_1 = _delimiterStartIndex;
    return true;
  }
  j1() {
    if (!this.i1()) {
      throw NoSuchElementException.y4();
    }
    this.yh_1 = 0;
    var lastIndex = this.ai_1;
    var firstIndex = this.zh_1;
    this.zh_1 = this.ai_1 + this.bi_1 | 0;
    // Inline function 'kotlin.text.substring' call
    var this_0 = this.xh_1;
    return toString_1(charSequenceSubSequence(this_0, firstIndex, lastIndex));
  }
}
class DelimitedRangesSequence$iterator$1 {
  constructor(this$0) {
    this.hi_1 = this$0;
    this.ci_1 = -1;
    this.di_1 = coerceIn(this$0.ji_1, 0, charSequenceLength(this$0.ii_1));
    this.ei_1 = this.di_1;
    this.fi_1 = null;
    this.gi_1 = 0;
  }
  j1() {
    if (this.ci_1 === -1) {
      calcNext(this);
    }
    if (this.ci_1 === 0)
      throw NoSuchElementException.y4();
    var tmp = this.fi_1;
    var result = tmp instanceof IntRange ? tmp : THROW_CCE();
    this.fi_1 = null;
    this.ci_1 = -1;
    return result;
  }
  i1() {
    if (this.ci_1 === -1) {
      calcNext(this);
    }
    return this.ci_1 === 1;
  }
}
class DelimitedRangesSequence {
  constructor(input, startIndex, limit, getNextMatch) {
    this.ii_1 = input;
    this.ji_1 = startIndex;
    this.ki_1 = limit;
    this.li_1 = getNextMatch;
  }
  h1() {
    return new DelimitedRangesSequence$iterator$1(this);
  }
}
class lineSequence$$inlined$Sequence$1 {
  constructor($this_lineSequence) {
    this.oi_1 = $this_lineSequence;
  }
  h1() {
    return new LinesIterator(this.oi_1);
  }
}
class UnsafeLazyImpl {
  constructor(initializer) {
    this.pi_1 = initializer;
    this.qi_1 = UNINITIALIZED_VALUE_instance;
  }
  z2() {
    if (this.qi_1 === UNINITIALIZED_VALUE_instance) {
      this.qi_1 = ensureNotNull(this.pi_1)();
      this.pi_1 = null;
    }
    var tmp = this.qi_1;
    return (tmp == null ? true : !(tmp == null)) ? tmp : THROW_CCE();
  }
  ri() {
    return !(this.qi_1 === UNINITIALIZED_VALUE_instance);
  }
  toString() {
    return this.ri() ? toString_0(this.z2()) : 'Lazy value not initialized yet.';
  }
}
class UNINITIALIZED_VALUE {}
class NotImplementedError extends Error_0 {
  static ui(message) {
    message = message === VOID ? 'An operation is not implemented.' : message;
    var $this = this.i(message);
    captureStack($this, $this.ti_1);
    return $this;
  }
}
class Pair {
  constructor(first, second) {
    this.first = first;
    this.second = second;
  }
  vi() {
    return this.first;
  }
  wi() {
    return this.second;
  }
  toString() {
    return '(' + toString_0(this.first) + ', ' + toString_0(this.second) + ')';
  }
  mi() {
    return this.first;
  }
  ni() {
    return this.second;
  }
  xi(first, second) {
    return new Pair(first, second);
  }
  copy(first, second, $super) {
    first = first === VOID ? this.first : first;
    second = second === VOID ? this.second : second;
    return $super === VOID ? this.xi(first, second) : $super.xi.call(this, first, second);
  }
  hashCode() {
    var result = this.first == null ? 0 : hashCode(this.first);
    result = imul_0(result, 31) + (this.second == null ? 0 : hashCode(this.second)) | 0;
    return result;
  }
  equals(other) {
    if (this === other)
      return true;
    if (!(other instanceof Pair))
      return false;
    if (!equals(this.first, other.first))
      return false;
    if (!equals(this.second, other.second))
      return false;
    return true;
  }
}
class Companion_15 {
  constructor() {
    Companion_instance_15 = this;
    this.yi_1 = _ULong___init__impl__c78o9k(0n);
    this.zi_1 = _ULong___init__impl__c78o9k(-1n);
    this.aj_1 = 8;
    this.bj_1 = 64;
  }
}
class ULong {
  constructor(data) {
    Companion_getInstance_15();
    this.cj_1 = data;
  }
  dj(other) {
    return ULong__compareTo_impl_38i7tu(this.cj_1, other);
  }
  d(other) {
    return ULong__compareTo_impl_38i7tu_0(this, other);
  }
  toString() {
    return ULong__toString_impl_f9au7k(this.cj_1);
  }
  hashCode() {
    return ULong__hashCode_impl_6hv2lb(this.cj_1);
  }
  equals(other) {
    return ULong__equals_impl_o0gnyb(this.cj_1, other);
  }
}
class EnumMap {
  constructor(enums) {
    this.ej_1 = enums;
    this.fj_1 = booleanArray(this.ej_1.length);
    this.gj_1 = ArrayList.n1(this.ej_1.length);
    var inductionVariable = 0;
    var last = this.ej_1.length;
    if (inductionVariable < last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        this.gj_1.p5(i, null);
      }
       while (inductionVariable < last);
  }
  n6() {
    return this.gj_1;
  }
  d3() {
    var reason = 'Not yet implemented';
    throw NotImplementedError.ui('An operation is not implemented: ' + reason);
  }
  m6() {
    return toMutableSet(this.m6());
  }
  k1() {
    return this.gj_1.k1();
  }
  hj(key) {
    return true;
  }
  a3(key) {
    if (!(key instanceof Enum))
      return false;
    return this.hj(key instanceof Enum ? key : THROW_CCE());
  }
  ij(key) {
    return this.gj_1.l1(key.g3_1);
  }
  c3(key) {
    if (!(key instanceof Enum))
      return null;
    return this.ij(key instanceof Enum ? key : THROW_CCE());
  }
  u4() {
    // Inline function 'kotlin.TODO' call
    var reason = 'Not yet implemented';
    throw NotImplementedError.ui('An operation is not implemented: ' + reason);
  }
  jj(key, value) {
    this.gj_1.p4(key.g3_1, value);
    return this.gj_1.l1(key.g3_1);
  }
  o6(key, value) {
    var tmp = key instanceof Enum ? key : THROW_CCE();
    return this.jj(tmp, (value == null ? true : !(value == null)) ? value : THROW_CCE());
  }
}
class ConcatenateIterator {
  constructor($outer) {
    this.lj_1 = $outer;
    this.kj_1 = this.mj();
  }
  i1() {
    return this.kj_1.i1();
  }
  j1() {
    var next = ensureNotNull(this.kj_1.j1());
    this.nj();
    return next;
  }
  mj() {
    return ensureNotNull(this.lj_1.oj_1).j1().h1();
  }
  nj() {
    $l$loop: while (!this.kj_1.i1() && ensureNotNull(this.lj_1.oj_1).i1()) {
      this.kj_1 = this.mj();
    }
    return this;
  }
}
class EmptyIterator_0 {
  i1() {
    return false;
  }
  j1() {
    throw IllegalStateException.gb();
  }
}
class ConcatenateIterable {
  constructor(iterables) {
    this.pj_1 = iterables;
    this.oj_1 = iterables.h1();
  }
  h1() {
    return !ensureNotNull(this.oj_1).i1() ? new EmptyIterator_0() : (new ConcatenateIterator(this)).nj();
  }
}
class Iterables {
  qj(original, condition) {
    // Inline function 'kotlin.collections.filter' call
    // Inline function 'kotlin.collections.filterTo' call
    var destination = ArrayList.q1();
    var _iterator__ex2g4s = original.h1();
    while (_iterator__ex2g4s.i1()) {
      var element = _iterator__ex2g4s.j1();
      if (condition.rj(element)) {
        destination.c1(element);
      }
    }
    return destination;
  }
  sj(iterables) {
    return this.tj(toList(iterables));
  }
  tj(iterables) {
    return new ConcatenateIterable(iterables);
  }
}
class SortedSet extends AbstractMutableSet {
  static wj(comparator, collection) {
    collection = collection === VOID ? emptyList() : collection;
    var $this = this.r6();
    $this.uj_1 = comparator;
    var tmp = $this;
    // Inline function 'kotlin.apply' call
    var this_0 = ArrayList.q1();
    this_0.o1(toSet_0(collection));
    sortWith_0(this_0, $this.uj_1);
    tmp.vj_1 = this_0;
    return $this;
  }
  k1() {
    return this.vj_1.k1();
  }
  c1(element) {
    var index = binarySearch(this.vj_1, element, this.uj_1);
    var tmp;
    if (index >= 0) {
      tmp = false;
    } else {
      this.vj_1.p5(abs_0(index) - 1 | 0, element);
      tmp = true;
    }
    return tmp;
  }
  h1() {
    return this.vj_1.h1();
  }
}
class UniversalComparator {
  xj(a, b) {
    var tmp;
    if (!(a == null) && !(b == null)) {
      var tmp_0;
      if (getKClassFromExpression(b).equals(getKClassFromExpression(a))) {
        var tmp_1;
        var tmp_2;
        if (typeof a === 'string') {
          tmp_2 = typeof b === 'string';
        } else {
          tmp_2 = false;
        }
        if (tmp_2) {
          tmp_1 = compareTo(a, b);
        } else {
          var tmp_3;
          if (isComparable(a)) {
            tmp_3 = isComparable(b);
          } else {
            tmp_3 = false;
          }
          if (tmp_3) {
            tmp_1 = compareTo(isComparable(a) ? a : THROW_CCE(), b);
          } else {
            tmp_1 = compareTo(toString_1(a), toString_1(b));
          }
        }
        tmp_0 = tmp_1;
      } else {
        var tmp_4;
        if (isNumber(b)) {
          tmp_4 = isNumber(a);
        } else {
          tmp_4 = false;
        }
        if (tmp_4) {
          var number1 = a;
          var number2 = b;
          if (numberToDouble(number1) < numberToDouble(number2))
            return -1;
          tmp_0 = numberToDouble(number1) > numberToDouble(number2) ? 1 : 0;
        } else {
          tmp_0 = compareTo(toString_1(a), toString_1(b));
        }
      }
      tmp = tmp_0;
    } else {
      var tmp_5;
      if (!(a == null)) {
        tmp_5 = 1;
      } else if (!(b == null)) {
        tmp_5 = -1;
      } else {
        tmp_5 = 0;
      }
      tmp = tmp_5;
    }
    return tmp;
  }
  compare(a, b) {
    var tmp = (a == null ? true : !(a == null)) ? a : THROW_CCE();
    return this.xj(tmp, (b == null ? true : !(b == null)) ? b : THROW_CCE());
  }
}
class WeakReference {
  constructor(referent) {
    this.yj_1 = referent;
  }
  zj() {
    return this.yj_1;
  }
}
class AbstractUICommand {
  static fk(titleProperty, enabledProperty, keystrokeProperty, mnemonicProperty, iconProperty, $box) {
    enabledProperty = enabledProperty === VOID ? new SimpleProperty(true) : enabledProperty;
    keystrokeProperty = keystrokeProperty === VOID ? null : keystrokeProperty;
    mnemonicProperty = mnemonicProperty === VOID ? null : mnemonicProperty;
    iconProperty = iconProperty === VOID ? null : iconProperty;
    var $this = createThis(this, $box);
    $this.ak_1 = titleProperty;
    $this.bk_1 = enabledProperty;
    $this.ck_1 = keystrokeProperty;
    $this.dk_1 = mnemonicProperty;
    $this.ek_1 = iconProperty;
    return $this;
  }
  static gk(title, $box) {
    return this.fk(new SimpleProperty(title), VOID, VOID, VOID, VOID, $box);
  }
  toString() {
    return ensureNotNull(ensureNotNull(this.ak_1).z2());
  }
}
class HtmlString {
  toString() {
    return ensureNotNull(this.hk_1);
  }
}
class WeakFilterListener {
  jk() {
    return this.ik_1.zj();
  }
}
class Companion_16 {
  constructor() {
    this.kk_1 = 6388032080849307737n;
  }
}
class AbstractFilter {
  constructor() {
    this.lk_1 = true;
    this.mk_1 = CollectionFactory_instance.nk();
  }
  ok(listener) {
    this.mk_1.c1(listener);
  }
  pk(listener) {
    if (listener instanceof WeakFilterListener) {
      var removed = this.mk_1.e3(listener);
    } else {
      var toRemove = null;
      var _iterator__ex2g4s = this.mk_1.h1();
      while (_iterator__ex2g4s.i1()) {
        var filterListener = _iterator__ex2g4s.j1();
        var comparable;
        var tmp;
        if (filterListener instanceof WeakFilterListener) {
          tmp = filterListener.jk();
        } else {
          tmp = filterListener;
        }
        comparable = tmp;
        if (equals(listener, comparable)) {
          toRemove = filterListener;
        }
      }
      if (!(toRemove == null)) {
        var removed_0 = this.mk_1.e3(toRemove);
      }
    }
  }
}
class AbstractMutableFilter extends AbstractFilter {
  constructor() {
    super();
    this.tk_1 = true;
  }
}
class SimpleFilter extends AbstractMutableFilter {
  constructor() {
    super();
    this.xk_1 = HashMap.i7();
  }
  qk(element) {
    return this.xk_1.a3(element);
  }
}
class CPFormat {}
class AbstractFormat {
  yk() {
    return null;
  }
}
class DecimalFormat {
  constructor(s, symbols) {
    symbols = symbols === VOID ? new DecimalFormatSymbols() : symbols;
    this.al_1 = symbols;
    this.bl_1 = 1.0;
    this.cl_1 = 0;
    this.dl_1 = false;
    this.el_1 = 0;
    this.fl_1 = 0;
    this.gl_1 = 0;
    this.hl_1 = 3;
    this.il_1 = 1;
    this.jl_1 = false;
  }
  kl(number) {
    var number_0 = number;
    if (isNaN_0(number_0)) {
      return this.al_1.ql_1;
    }
    var isNegative = number_0 < 0.0 || (number_0 === 0.0 && 1 / number_0 < 0.0);
    if (isNegative) {
      number_0 = -number_0;
    }
    var buf = StringBuilder.y();
    if (isInfinite(number_0)) {
      buf.qa(isNegative ? this.al_1.pl_1 : this.al_1.ol_1);
      buf.qa(this.al_1.nl_1);
      buf.qa(isNegative ? this.al_1.ll_1 : this.al_1.ml_1);
      return buf.toString();
    }
    number_0 = number_0 * this.bl_1;
    var scale = this.sl(buf, number_0);
    var preRound = ((buf.a() + scale | 0) + this.hl_1 | 0) + 3 | 0;
    if (preRound > 0 && preRound < buf.a() && buf.b(preRound) === _Char___init__impl__6a9atx(57)) {
      propagateCarry(this, buf, preRound - 1 | 0);
      scale = scale + (buf.a() - preRound | 0) | 0;
      buf.yd(preRound, preRound + buf.a() | 0);
    }
    this.tl(isNegative, buf, scale);
    return buf.toString();
  }
  sl(buf, val) {
    var startLen = buf.a();
    buf.qa(toPrecision(this, val, 20));
    var scale = 0;
    var expIdx = buf.rd('e', startLen);
    if (expIdx < 0) {
      expIdx = buf.rd('E', startLen);
    }
    if (expIdx >= 0) {
      var expDigits = expIdx + 1 | 0;
      if (expDigits < buf.a() && buf.b(expDigits) === _Char___init__impl__6a9atx(43)) {
        expDigits = expDigits + 1 | 0;
      }
      if (expDigits < buf.a()) {
        scale = toInt_0(buf.vd(expDigits));
      }
      buf.yd(expIdx, expIdx + buf.a() | 0);
    }
    var dot = buf.rd('.', startLen);
    if (dot >= 0) {
      buf.xd(dot);
      scale = scale - (buf.a() - dot | 0) | 0;
    }
    return scale;
  }
  tl(isNegative, digits, scale) {
    var decimalSeparator = this.al_1.rl_1;
    this.fl_1 = 0;
    this.el_1 = digits.a();
    this.cl_1 = this.el_1 + scale | 0;
    processLeadingZeros(this, digits);
    roundValue(this, digits);
    adjustFractionDigits(this, digits);
    addZeroAndDecimal(this, digits, decimalSeparator);
    digits.ud(0, isNegative ? this.al_1.pl_1 : this.al_1.ol_1);
    digits.qa(isNegative ? this.al_1.ll_1 : this.al_1.ml_1);
  }
}
class DecimalFormatSymbols {
  constructor() {
    this.ll_1 = '';
    this.ml_1 = '';
    this.nl_1 = 'Inf';
    this.ol_1 = '';
    this.pl_1 = '-';
    this.ql_1 = 'NaN';
    this.rl_1 = _Char___init__impl__6a9atx(46);
  }
}
class SwingFormat extends AbstractFormat {
  constructor(format, pre, post, rounding, factor) {
    super();
    this.ul_1 = pre;
    this.vl_1 = post;
    this.wl_1 = rounding;
    this.xl_1 = factor;
    this.yl_1 = format;
  }
  zl(value, htmlSupported) {
    var s;
    if (isNumber(value)) {
      var n = numberToDouble(value);
      if (!(this.wl_1 === 1.0)) {
        n = round(n / this.wl_1) * this.wl_1;
      }
      if (!(this.xl_1 === 1.0)) {
        n = n * this.xl_1;
      }
      s = this.yl_1.kl(n);
      if (!(this.ul_1 == null)) {
        s = this.ul_1 + s;
      }
      if (!(this.vl_1 == null)) {
        s = s + this.vl_1;
      }
    } else {
      s = null;
    }
    return s;
  }
  zk(value, htmlSupported) {
    return this.zl((value == null ? true : !(value == null)) ? value : THROW_CCE(), htmlSupported);
  }
}
class FormatFactoryCommon {}
function createDecimalFormat(fractionDigits) {
  return this.bm(fractionDigits, null, null, 1.0, 1.0);
}
function createDecimalFormat_0(fractionDigits, pre, post, rounding, factor) {
  var instance = new DecimalFormat('');
  instance.hl_1 = fractionDigits;
  return new SwingFormat(instance, pre, post, rounding, factor);
}
class Dimension {
  static em() {
    var $this = createThis(this);
    init_com_macrofocus_common_geom_Dimension($this);
    $this.cm_1 = 0;
    $this.dm_1 = 0;
    return $this;
  }
  static fm(width, height) {
    var $this = createThis(this);
    init_com_macrofocus_common_geom_Dimension($this);
    $this.cm_1 = width;
    $this.dm_1 = height;
    return $this;
  }
  gm() {
    return this.cm_1;
  }
  hm() {
    return this.dm_1;
  }
  toString() {
    return 'Dimension.Integer{width=' + this.gm() + ', height=' + this.hm() + toString(_Char___init__impl__6a9atx(125));
  }
}
class AbstractIndex {
  static im() {
    return createThis(this);
  }
}
class AbstractMutableInterval {
  static pm() {
    var $this = createThis(this);
    $this.om_1 = CollectionFactory_instance.nk();
    return $this;
  }
  sm(listener) {
    this.om_1.c1(listener);
  }
  addIntervalListener(listener) {
    return this.sm(listener);
  }
  tm(listener) {
    var weakListener = new WeakIntervalListener(this, listener);
    this.om_1.c1(weakListener);
  }
  addWeakIntervalListener(listener) {
    return this.tm(listener);
  }
  um(listener) {
    if (listener instanceof WeakIntervalListener) {
      var removed = this.om_1.e3(listener);
    } else {
      var toRemove = null;
      var _iterator__ex2g4s = this.om_1.h1();
      while (_iterator__ex2g4s.i1()) {
        var intervalListener = _iterator__ex2g4s.j1();
        var comparable;
        if (intervalListener instanceof WeakIntervalListener) {
          comparable = intervalListener.jk();
        } else {
          comparable = intervalListener;
        }
        if (equals(listener, comparable)) {
          toRemove = intervalListener;
        }
      }
      if (!(toRemove == null)) {
        var removed_0 = this.om_1.e3(toRemove);
      }
    }
  }
  removeIntervalListener(listener) {
    return this.um(listener);
  }
  vm() {
    this.om_1.u4();
  }
  removeIntervalListeners() {
    return this.vm();
  }
  wm(event) {
    var _iterator__ex2g4s = this.om_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var listener = _iterator__ex2g4s.j1();
      listener.kn(event);
    }
  }
}
class AbstractBoundedInterval extends AbstractMutableInterval {
  static nm() {
    var $this = this.pm();
    $this.mm_1 = CollectionFactory_instance.nk();
    return $this;
  }
  qm(event) {
    var _iterator__ex2g4s = this.mm_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var listener = _iterator__ex2g4s.j1();
      listener.rm(event);
    }
  }
}
class WeakIntervalListener {
  constructor($outer, listener) {
    this.jn_1 = $outer;
    this.in_1 = new WeakReference(listener);
  }
  kn(event) {
    var l = this.jk();
    if (!(l == null)) {
      l.kn(event);
    } else {
      this.jn_1.um(this);
    }
  }
  jk() {
    return this.in_1.zj();
  }
  toString() {
    var l = this.jk();
    var tmp;
    if (!(l == null)) {
      tmp = 'Weak[' + toString_1(l) + ']';
    } else {
      tmp = toString_1(getKClassFromExpression(this)) + '@' + hashCode(this);
    }
    return tmp;
  }
}
class BoundedIntervalEvent {
  constructor(oldMinimum, oldMaximum, oldMinimumExtent, oldMaximumExtent) {
    this.ln_1 = oldMinimum;
    this.mn_1 = oldMaximum;
    this.nn_1 = oldMinimumExtent;
    this.on_1 = oldMaximumExtent;
    this.pn_1 = 0.0;
    this.qn_1 = 0.0;
    this.rn_1 = 0.0;
    this.sn_1 = 0.0;
  }
  tn(newMinimum, newMaximum, newMinimumExtent, newMaximumExtent) {
    this.pn_1 = newMinimum;
    this.qn_1 = newMaximum;
    this.rn_1 = newMinimumExtent;
    this.sn_1 = newMaximumExtent;
  }
}
class ClosedInterval extends AbstractMutableInterval {
  static vn() {
    var $this = this.pm();
    delete $this.extent;
    delete $this.isInverted;
    delete $this.isDegenerate;
    return $this;
  }
  cn(value) {
    // Inline function 'kotlin.TODO' call
    var reason = 'Not yet implemented!';
    throw NotImplementedError.ui('An operation is not implemented: ' + reason);
  }
  dn() {
    return this.end - this.start;
  }
  wn(value) {
    return this.start <= value && this.end >= value;
  }
  contains(value) {
    return this.wn(value);
  }
  xn(start, end) {
    return this.wn(start) && this.wn(end);
  }
  containsStartEnd(start, end) {
    return this.xn(start, end);
  }
  yn(interval) {
    return this.wn(ensureNotNull(interval).start) && this.wn(interval.end);
  }
  containsInterval(interval) {
    return this.yn(interval);
  }
  zn(start, end) {
    return this.wn(start) || this.wn(end);
  }
  overlaps(start, end) {
    return this.zn(start, end);
  }
  ao(interval) {
    return this.wn(ensureNotNull(interval).start) || this.wn(interval.end);
  }
  overlapsInterval(interval) {
    return this.ao(interval);
  }
  fn() {
    return this.end < this.start;
  }
  en() {
    return this.dn() === 0.0;
  }
  get extent() {
    return this.dn();
  }
  set extent(value) {
    this.cn(value);
  }
  get isInverted() {
    return this.fn();
  }
  get isDegenerate() {
    return this.en();
  }
}
class IntervalEvent {
  constructor(oldStart, oldEnd, oldExtent) {
    this.bo_1 = oldStart;
    this.co_1 = oldEnd;
    this.do_1 = oldExtent;
    this.eo_1 = 0.0;
    this.fo_1 = 0.0;
    this.go_1 = 0.0;
  }
  ho(newStart, newEnd, newExtent) {
    this.eo_1 = newStart;
    this.fo_1 = newEnd;
    this.go_1 = newExtent;
  }
  toString() {
    return 'IntervalEvent{newStart=' + this.eo_1 + ', newEnd=' + this.fo_1 + ', newExtent=' + this.go_1 + ', oldStart=' + this.bo_1 + ', oldEnd=' + this.co_1 + ', oldExtent=' + this.do_1 + toString(_Char___init__impl__6a9atx(125));
  }
}
class PropertyClosedInterval extends ClosedInterval {
  static po(start, extent) {
    var $this = this.vn();
    $this.no_1 = new SimpleProperty(start);
    $this.oo_1 = new SimpleProperty($this.xm().z2() + extent);
    var tmp = $this.xm();
    tmp.zo(new PropertyClosedInterval$1($this, start, extent));
    var tmp_0 = $this.ym();
    tmp_0.zo(new PropertyClosedInterval$2(start, $this, extent));
    delete $this.startProperty;
    delete $this.endProperty;
    delete $this.start;
    delete $this.end;
    return $this;
  }
  xm() {
    return this.no_1;
  }
  ym() {
    return this.oo_1;
  }
  zm(value) {
    this.xm().ap(value);
  }
  xf() {
    return this.xm().z2();
  }
  an(value) {
    this.ym().ap(value);
  }
  bn() {
    return this.ym().z2();
  }
  cn(extent) {
    this.ym().ap(this.xf() + extent);
  }
  dn() {
    return super.dn();
  }
  qo(value, extent) {
    this.xm().ap(value);
    this.ym().ap(value + extent);
  }
  setValue(value, extent) {
    return this.qo(value, extent);
  }
  toString() {
    return 'PropertyClosedInterval{start=' + this.xf() + ', end=' + this.bn() + ', extent=' + this.dn() + toString(_Char___init__impl__6a9atx(125));
  }
  get startProperty() {
    return this.xm();
  }
  get endProperty() {
    return this.ym();
  }
  get start() {
    return this.xf();
  }
  set start(value) {
    this.zm(value);
  }
  get end() {
    return this.bn();
  }
  set end(value) {
    this.an(value);
  }
}
class OpenInterval extends PropertyClosedInterval {
  static lo(start, extent) {
    return this.po(start, extent);
  }
  wn(value) {
    return this.xf() <= value && this.bn() > value;
  }
  contains(value) {
    return this.wn(value);
  }
}
class PropertyListener {}
class PropertyClosedInterval$1 {
  constructor(this$0, $start, $extent) {
    this.ro_1 = this$0;
    this.so_1 = $start;
    this.to_1 = $extent;
  }
  uo(event) {
    var e = new IntervalEvent(event.oldValue, this.ro_1.bn(), this.ro_1.bn() - event.oldValue);
    e.ho(this.so_1, this.ro_1.bn(), this.to_1);
    this.ro_1.wm(e);
  }
  vo(event) {
    return this.uo(event);
  }
}
class PropertyClosedInterval$2 {
  constructor($start, this$0, $extent) {
    this.wo_1 = $start;
    this.xo_1 = this$0;
    this.yo_1 = $extent;
  }
  uo(event) {
    var e = new IntervalEvent(this.wo_1, event.oldValue, event.oldValue - this.wo_1);
    e.ho(this.wo_1, this.xo_1.bn(), this.yo_1);
    this.xo_1.wm(e);
  }
  vo(event) {
    return this.uo(event);
  }
}
class SimpleBoundedInterval$intervalListener$1 {
  constructor(this$0) {
    this.bp_1 = this$0;
  }
  kn(event) {
    this.bp_1.wm(event);
  }
}
class SimpleBoundedInterval extends AbstractBoundedInterval {
  static kp(interval, minimum, maximum) {
    var $this = this.nm();
    $this.ep_1 = interval;
    $this.fp_1 = minimum;
    $this.gp_1 = maximum;
    $this.hp_1 = 0.0;
    $this.ip_1 = 0.0;
    var tmp = $this;
    tmp.jp_1 = new SimpleBoundedInterval$intervalListener$1($this);
    $this.lp(0.0);
    $this.mp(maximum - minimum);
    $this.ep_1.addWeakIntervalListener($this.jp_1);
    delete $this.startProperty;
    delete $this.endProperty;
    delete $this.start;
    delete $this.start;
    delete $this.end;
    delete $this.end;
    delete $this.extent;
    delete $this.extent;
    delete $this.isDegenerate;
    delete $this.isDegenerate;
    delete $this.isInverted;
    delete $this.isInverted;
    return $this;
  }
  np(minimum) {
    if (!(this.fp_1 === minimum)) {
      var event = new BoundedIntervalEvent(this.fp_1, this.gp_1, this.hp_1, this.ip_1);
      this.fp_1 = minimum;
      this.mp(this.gp_1 - this.fp_1);
      event.tn(this.fp_1, this.gp_1, this.hp_1, this.ip_1);
      this.qm(event);
    }
  }
  gn() {
    return this.fp_1;
  }
  op(maximum) {
    if (!(this.gp_1 === maximum)) {
      var event = new BoundedIntervalEvent(this.fp_1, this.gp_1, this.hp_1, this.ip_1);
      this.gp_1 = maximum;
      this.mp(this.gp_1 - this.fp_1);
      event.tn(this.fp_1, this.gp_1, this.hp_1, this.ip_1);
      this.qm(event);
    }
  }
  hn() {
    return this.gp_1;
  }
  lp(minimumExtent) {
    if (!(this.hp_1 === minimumExtent)) {
      var event = new BoundedIntervalEvent(this.fp_1, this.gp_1, this.hp_1, this.ip_1);
      this.hp_1 = minimumExtent;
      event.tn(this.fp_1, this.gp_1, this.hp_1, this.ip_1);
      this.qm(event);
    }
  }
  mp(maximumExtent) {
    if (!(this.ip_1 === maximumExtent)) {
      var event = new BoundedIntervalEvent(this.fp_1, this.gp_1, this.hp_1, this.ip_1);
      this.ip_1 = maximumExtent;
      event.tn(this.fp_1, this.gp_1, this.hp_1, this.ip_1);
      this.qm(event);
    }
  }
  pp() {
    return this.ip_1;
  }
  static qp(start, extent, minimum, maximum) {
    minimum = minimum === VOID ? start : minimum;
    maximum = maximum === VOID ? start + extent : maximum;
    return this.kp(PropertyClosedInterval.po(start, extent), minimum, maximum);
  }
  qo(value, extent) {
    this.ep_1.setValue(value, extent);
  }
  setValue(value, extent) {
    return this.qo(value, extent);
  }
  xm() {
    return this.ep_1.startProperty;
  }
  ym() {
    return this.ep_1.endProperty;
  }
  zm(value) {
    this.ep_1.start = value;
  }
  xf() {
    return this.ep_1.start;
  }
  an(value) {
    this.ep_1.end = value;
  }
  bn() {
    return this.ep_1.end;
  }
  cn(value) {
    this.ep_1.extent = value;
  }
  dn() {
    return this.ep_1.extent;
  }
  wn(value) {
    return this.ep_1.contains(value);
  }
  contains(value) {
    return this.wn(value);
  }
  xn(start, end) {
    return this.ep_1.containsStartEnd(start, end);
  }
  containsStartEnd(start, end) {
    return this.xn(start, end);
  }
  yn(interval) {
    return ensureNotNull(interval).containsInterval(interval);
  }
  containsInterval(interval) {
    return this.yn(interval);
  }
  zn(start, end) {
    return this.ep_1.overlaps(start, end);
  }
  overlaps(start, end) {
    return this.zn(start, end);
  }
  ao(interval) {
    return ensureNotNull(interval).overlapsInterval(interval);
  }
  overlapsInterval(interval) {
    return this.ao(interval);
  }
  en() {
    return this.ep_1.isDegenerate;
  }
  fn() {
    return this.ep_1.isInverted;
  }
  rp(min, max) {
    if (!(this.fp_1 === min) || !(this.gp_1 === max)) {
      var event = new BoundedIntervalEvent(this.fp_1, this.gp_1, this.hp_1, this.ip_1);
      this.np(min);
      this.op(max);
      this.mp(max - min);
      event.tn(this.fp_1, this.gp_1, this.hp_1, this.ip_1);
      this.qm(event);
    }
  }
  toString() {
    return 'SimpleBoundedInterval{start=' + this.ep_1.start + ', end=' + this.ep_1.end + ', extent=' + this.ep_1.extent + ', minimum=' + this.fp_1 + ', maximum=' + this.gp_1 + ', minimumExtent=' + this.hp_1 + ', maximumExtent=' + this.ip_1 + toString(_Char___init__impl__6a9atx(125));
  }
  get startProperty() {
    return this.xm();
  }
  get endProperty() {
    return this.ym();
  }
  get start() {
    return this.xf();
  }
  set start(value) {
    this.zm(value);
  }
  get end() {
    return this.bn();
  }
  set end(value) {
    this.an(value);
  }
  get extent() {
    return this.dn();
  }
  set extent(value) {
    this.cn(value);
  }
  get isDegenerate() {
    return this.en();
  }
  get isInverted() {
    return this.fn();
  }
}
class Companion_17 {
  constructor() {
    Companion_instance_17 = this;
    this.ZERO = BigDecimals_getInstance().sp_1;
    this.ONE = BigDecimals_getInstance().tp_1;
    this.TWO = BigDecimals_getInstance().up_1;
    this.TEN = BigDecimals_getInstance().vp_1;
    this.ONE_TENTH = BigDecimals_getInstance().wp_1;
    this.ONE_HALF = BigDecimals_getInstance().xp_1;
    this.PI = BigDecimals_getInstance().yp_1;
    this.E = BigDecimals_getInstance().zp_1;
  }
  aq() {
    return this.ZERO;
  }
  bq() {
    return this.ONE;
  }
  cq() {
    return this.TWO;
  }
  dq() {
    return this.TEN;
  }
  eq() {
    return this.ONE_TENTH;
  }
  fq() {
    return this.ONE_HALF;
  }
  gq() {
    return this.PI;
  }
  hq() {
    return this.E;
  }
  ofScaledLong(unscaledVal, scale) {
    return bigDecimalOf(unscaledVal, scale);
  }
  ofScaledLongWithPrecision(unscaledVal, scale, prec) {
    return bigDecimalOf_0(unscaledVal, scale, prec);
  }
  ofInt(val) {
    return bigDecimalOf_1(val);
  }
  of(val) {
    return bigDecimalOf_2(val);
  }
  ofScaledBigIntegerWithPrecision(intVal, scale, prec) {
    return bigDecimalOf_3(intVal, scale, prec);
  }
  iq(val, ctx) {
    return bigDecimalOf_4(val, ctx);
  }
  ofDouble(val, ctx, $super) {
    ctx = ctx === VOID ? null : ctx;
    return $super === VOID ? this.iq(val, ctx) : $super.iq.call(this, val, ctx);
  }
  jq(val, ctx) {
    return bigDecimalOf_5(val, ctx);
  }
  ofFloat(val, ctx, $super) {
    ctx = ctx === VOID ? null : ctx;
    return $super === VOID ? this.jq(val, ctx) : $super.jq.call(this, val, ctx);
  }
  kq(val, ctx) {
    return bigDecimalOf_6(val, ctx);
  }
  parse(val, ctx, $super) {
    ctx = ctx === VOID ? null : ctx;
    return $super === VOID ? this.kq(val, ctx) : $super.kq.call(this, val, ctx);
  }
  lq(val, ctx) {
    return bigDecimalOf_7(val, ctx);
  }
  ofBigInteger(val, ctx, $super) {
    ctx = ctx === VOID ? null : ctx;
    return $super === VOID ? this.lq(val, ctx) : $super.lq.call(this, val, ctx);
  }
  ofIntWithContext(val, ctx) {
    return bigDecimalOf_8(val, ctx);
  }
  ofWithContext(val, ctx) {
    return bigDecimalOf_9(val, ctx);
  }
}
class BigDecimal {}
function sqrt(mc, $super) {
  mc = mc === VOID ? new MathContext() : mc;
  return $super === VOID ? this.rq(mc) : $super.rq.call(this, mc);
}
class Companion_18 {
  constructor() {
    Companion_instance_18 = this;
    this.ZERO = BigIntegers_getInstance().tq_1;
    this.ONE = BigIntegers_getInstance().uq_1;
    this.TWO = BigIntegers_getInstance().vq_1;
    this.NEGATIVE_ONE = BigIntegers_getInstance().xq_1;
    this.TEN = BigIntegers_getInstance().wq_1;
  }
  aq() {
    return this.ZERO;
  }
  bq() {
    return this.ONE;
  }
  cq() {
    return this.TWO;
  }
  yq() {
    return this.NEGATIVE_ONE;
  }
  dq() {
    return this.TEN;
  }
  probablePrime(bitLength, rnd) {
    return bigProbablePrimeInteger(bitLength, rnd);
  }
  ofLong(value) {
    return bigIntegerOf(value);
  }
  of(value) {
    return bigIntegerOf_0(value);
  }
  parse(value) {
    return bigIntegerOf_1(value);
  }
  parseWithRadix(value, radix) {
    return bigIntegerOf_2(value, radix);
  }
  ofIntArray(value) {
    return bigIntegerOf_3(value);
  }
  ofSlideIntArray(signum, magnitude, off, len) {
    return bigIntegerOf_4(signum, magnitude, off, len);
  }
}
class BigInteger {}
function rangeTo(endInclusive) {
  return new BigIntegerRange(this, endInclusive);
}
function rangeToInt(endInclusive) {
  return new BigIntegerRange(this, Companion_getInstance_18().of(endInclusive));
}
function rangeToLong(endInclusive) {
  return new BigIntegerRange(this, Companion_getInstance_18().ofLong(endInclusive));
}
function plusInt(other) {
  return this.plus(Companion_getInstance_18().of(other));
}
function plusLong(other) {
  return this.plus(Companion_getInstance_18().ofLong(other));
}
function minusInt(other) {
  return this.minus(Companion_getInstance_18().of(other));
}
function minusLong(other) {
  return this.minus(Companion_getInstance_18().ofLong(other));
}
function timesInt(other) {
  return this.times(Companion_getInstance_18().of(other));
}
function timesLong(other) {
  return this.times(Companion_getInstance_18().ofLong(other));
}
function divInt(other) {
  return this.div(Companion_getInstance_18().of(other));
}
function divLong(other) {
  return this.div(Companion_getInstance_18().ofLong(other));
}
function divideAndRemainderInt(other) {
  return this.divideAndRemainder(Companion_getInstance_18().of(other));
}
function divideAndRemainderLong(other) {
  return this.divideAndRemainder(Companion_getInstance_18().ofLong(other));
}
function reminderInt(other) {
  return this.reminder(Companion_getInstance_18().of(other));
}
function reminderLong(other) {
  return this.reminder(Companion_getInstance_18().ofLong(other));
}
function gcdInt(other) {
  return this.gcd(Companion_getInstance_18().of(other));
}
function gcdLong(other) {
  return this.gcd(Companion_getInstance_18().ofLong(other));
}
function remInt(modulus) {
  return this.rem(Companion_getInstance_18().of(modulus));
}
function remLong(modulus) {
  return this.rem(Companion_getInstance_18().ofLong(modulus));
}
function modInverseInt(modulus) {
  return this.modInverse(Companion_getInstance_18().of(modulus));
}
function modInverseLong(modulus) {
  return this.modInverse(Companion_getInstance_18().ofLong(modulus));
}
function andInt(other) {
  return this.and(Companion_getInstance_18().of(other));
}
function andLong(other) {
  return this.and(Companion_getInstance_18().ofLong(other));
}
function orInt(other) {
  return this.or(Companion_getInstance_18().of(other));
}
function orLong(other) {
  return this.or(Companion_getInstance_18().ofLong(other));
}
function xorInt(other) {
  return this.xor(Companion_getInstance_18().of(other));
}
function xorLong(other) {
  return this.xor(Companion_getInstance_18().ofLong(other));
}
function andNotInt(other) {
  return this.andNot(Companion_getInstance_18().of(other));
}
function andNotLong(other) {
  return this.andNot(Companion_getInstance_18().ofLong(other));
}
class BigIntegerRange$iterator$1 {
  constructor(this$0) {
    this.dr_1 = this$0;
    this.cr_1 = this$0.er_1;
  }
  i1() {
    return this.cr_1.br(this.dr_1.fr_1) <= 0;
  }
  j1() {
    var temp = this.cr_1;
    this.cr_1 = this.cr_1.plus(Companion_getInstance_18().ONE);
    return temp;
  }
}
class BigIntegerRange {
  constructor(start, endInclusive) {
    this.er_1 = start;
    this.fr_1 = endInclusive;
  }
  xf() {
    return this.er_1;
  }
  bg() {
    return this.fr_1;
  }
  h1() {
    return new BigIntegerRange$iterator$1(this);
  }
  mi() {
    return this.er_1;
  }
  ni() {
    return this.fr_1;
  }
  gr(start, endInclusive) {
    return new BigIntegerRange(start, endInclusive);
  }
  copy(start, endInclusive, $super) {
    start = start === VOID ? this.er_1 : start;
    endInclusive = endInclusive === VOID ? this.fr_1 : endInclusive;
    return $super === VOID ? this.gr(start, endInclusive) : $super.gr.call(this, start, endInclusive);
  }
  toString() {
    return 'BigIntegerRange(start=' + this.er_1.toString() + ', endInclusive=' + this.fr_1.toString() + ')';
  }
  hashCode() {
    var result = this.er_1.hashCode();
    result = imul_0(result, 31) + this.fr_1.hashCode() | 0;
    return result;
  }
  equals(other) {
    if (this === other)
      return true;
    if (!(other instanceof BigIntegerRange))
      return false;
    if (!this.er_1.equals(other.er_1))
      return false;
    if (!this.fr_1.equals(other.fr_1))
      return false;
    return true;
  }
}
class Companion_19 {
  constructor() {
    Companion_instance_19 = this;
    this.jr_1 = BitSieve.kr();
  }
}
class BitSieve {
  static kr() {
    Companion_getInstance_19();
    var $this = createThis(this);
    init_com_macrofocus_common_math_big_BitSieve($this);
    $this.ir_1 = 9600;
    $this.hr_1 = new BigInt64Array(unitIndex(Companion_getInstance_19(), $this.ir_1 - 1 | 0) + 1 | 0);
    set($this, 0);
    var nextIndex = 1;
    var nextPrime = 3;
    do {
      sieveSingle($this, $this.ir_1, nextIndex + nextPrime | 0, nextPrime);
      nextIndex = sieveSearch($this, $this.ir_1, nextIndex + 1 | 0);
      nextPrime = imul_0(2, nextIndex) + 1 | 0;
    }
     while (nextIndex > 0 && nextPrime < $this.ir_1);
    return $this;
  }
  static lr(base, searchLen) {
    Companion_getInstance_19();
    var $this = createThis(this);
    init_com_macrofocus_common_math_big_BitSieve($this);
    $this.hr_1 = new BigInt64Array(unitIndex(Companion_getInstance_19(), searchLen - 1 | 0) + 1 | 0);
    $this.ir_1 = searchLen;
    var start = 0;
    var step = sieveSearch(Companion_getInstance_19().jr_1, Companion_getInstance_19().jr_1.ir_1, start);
    var convertedStep = imul_0(step, 2) + 1 | 0;
    var b = MutableBigInteger.qr(base);
    var q = MutableBigInteger.rr();
    do {
      start = b.sr(convertedStep, q);
      start = convertedStep - start | 0;
      if ((start % 2 | 0) === 0) {
        start = start + convertedStep | 0;
      }
      sieveSingle($this, searchLen, (start - 1 | 0) / 2 | 0, convertedStep);
      step = sieveSearch(Companion_getInstance_19().jr_1, Companion_getInstance_19().jr_1.ir_1, step + 1 | 0);
      convertedStep = imul_0(step, 2) + 1 | 0;
    }
     while (step > 0);
    return $this;
  }
  tr(initValue, certainty, random) {
    var offset = 1;
    var inductionVariable = 0;
    var last = ensureNotNull(this.hr_1).length - 1 | 0;
    if (inductionVariable <= last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        var nextLong = ~ensureNotNull(this.hr_1)[i];
        var inductionVariable_0 = 0;
        if (inductionVariable_0 <= 63)
          do {
            var j = inductionVariable_0;
            inductionVariable_0 = inductionVariable_0 + 1 | 0;
            if ((nextLong & 1n) === 1n) {
              var candidate = initValue.plus(Companion_getInstance_22().ofLong(fromInt_0(offset)));
              if (candidate.as(certainty, random)) {
                return candidate;
              }
            }
            nextLong = shiftRightUnsigned(nextLong, 1);
            offset = offset + 2 | 0;
          }
           while (inductionVariable_0 <= 63);
      }
       while (inductionVariable <= last);
    return null;
  }
}
class Companion_20 {
  constructor() {
    Companion_instance_20 = this;
    var tmp = this;
    // Inline function 'kotlin.charArrayOf' call
    tmp.bs_1 = charArrayOf([_Char___init__impl__6a9atx(48), _Char___init__impl__6a9atx(48), _Char___init__impl__6a9atx(48), _Char___init__impl__6a9atx(48), _Char___init__impl__6a9atx(48), _Char___init__impl__6a9atx(48), _Char___init__impl__6a9atx(48), _Char___init__impl__6a9atx(48), _Char___init__impl__6a9atx(48), _Char___init__impl__6a9atx(48), _Char___init__impl__6a9atx(49), _Char___init__impl__6a9atx(49), _Char___init__impl__6a9atx(49), _Char___init__impl__6a9atx(49), _Char___init__impl__6a9atx(49), _Char___init__impl__6a9atx(49), _Char___init__impl__6a9atx(49), _Char___init__impl__6a9atx(49), _Char___init__impl__6a9atx(49), _Char___init__impl__6a9atx(49), _Char___init__impl__6a9atx(50), _Char___init__impl__6a9atx(50), _Char___init__impl__6a9atx(50), _Char___init__impl__6a9atx(50), _Char___init__impl__6a9atx(50), _Char___init__impl__6a9atx(50), _Char___init__impl__6a9atx(50), _Char___init__impl__6a9atx(50), _Char___init__impl__6a9atx(50), _Char___init__impl__6a9atx(50), _Char___init__impl__6a9atx(51), _Char___init__impl__6a9atx(51), _Char___init__impl__6a9atx(51), _Char___init__impl__6a9atx(51), _Char___init__impl__6a9atx(51), _Char___init__impl__6a9atx(51), _Char___init__impl__6a9atx(51), _Char___init__impl__6a9atx(51), _Char___init__impl__6a9atx(51), _Char___init__impl__6a9atx(51), _Char___init__impl__6a9atx(52), _Char___init__impl__6a9atx(52), _Char___init__impl__6a9atx(52), _Char___init__impl__6a9atx(52), _Char___init__impl__6a9atx(52), _Char___init__impl__6a9atx(52), _Char___init__impl__6a9atx(52), _Char___init__impl__6a9atx(52), _Char___init__impl__6a9atx(52), _Char___init__impl__6a9atx(52), _Char___init__impl__6a9atx(53), _Char___init__impl__6a9atx(53), _Char___init__impl__6a9atx(53), _Char___init__impl__6a9atx(53), _Char___init__impl__6a9atx(53), _Char___init__impl__6a9atx(53), _Char___init__impl__6a9atx(53), _Char___init__impl__6a9atx(53), _Char___init__impl__6a9atx(53), _Char___init__impl__6a9atx(53), _Char___init__impl__6a9atx(54), _Char___init__impl__6a9atx(54), _Char___init__impl__6a9atx(54), _Char___init__impl__6a9atx(54), _Char___init__impl__6a9atx(54), _Char___init__impl__6a9atx(54), _Char___init__impl__6a9atx(54), _Char___init__impl__6a9atx(54), _Char___init__impl__6a9atx(54), _Char___init__impl__6a9atx(54), _Char___init__impl__6a9atx(55), _Char___init__impl__6a9atx(55), _Char___init__impl__6a9atx(55), _Char___init__impl__6a9atx(55), _Char___init__impl__6a9atx(55), _Char___init__impl__6a9atx(55), _Char___init__impl__6a9atx(55), _Char___init__impl__6a9atx(55), _Char___init__impl__6a9atx(55), _Char___init__impl__6a9atx(55), _Char___init__impl__6a9atx(56), _Char___init__impl__6a9atx(56), _Char___init__impl__6a9atx(56), _Char___init__impl__6a9atx(56), _Char___init__impl__6a9atx(56), _Char___init__impl__6a9atx(56), _Char___init__impl__6a9atx(56), _Char___init__impl__6a9atx(56), _Char___init__impl__6a9atx(56), _Char___init__impl__6a9atx(56), _Char___init__impl__6a9atx(57), _Char___init__impl__6a9atx(57), _Char___init__impl__6a9atx(57), _Char___init__impl__6a9atx(57), _Char___init__impl__6a9atx(57), _Char___init__impl__6a9atx(57), _Char___init__impl__6a9atx(57), _Char___init__impl__6a9atx(57), _Char___init__impl__6a9atx(57), _Char___init__impl__6a9atx(57)]);
    var tmp_0 = this;
    // Inline function 'kotlin.charArrayOf' call
    tmp_0.cs_1 = charArrayOf([_Char___init__impl__6a9atx(48), _Char___init__impl__6a9atx(49), _Char___init__impl__6a9atx(50), _Char___init__impl__6a9atx(51), _Char___init__impl__6a9atx(52), _Char___init__impl__6a9atx(53), _Char___init__impl__6a9atx(54), _Char___init__impl__6a9atx(55), _Char___init__impl__6a9atx(56), _Char___init__impl__6a9atx(57), _Char___init__impl__6a9atx(48), _Char___init__impl__6a9atx(49), _Char___init__impl__6a9atx(50), _Char___init__impl__6a9atx(51), _Char___init__impl__6a9atx(52), _Char___init__impl__6a9atx(53), _Char___init__impl__6a9atx(54), _Char___init__impl__6a9atx(55), _Char___init__impl__6a9atx(56), _Char___init__impl__6a9atx(57), _Char___init__impl__6a9atx(48), _Char___init__impl__6a9atx(49), _Char___init__impl__6a9atx(50), _Char___init__impl__6a9atx(51), _Char___init__impl__6a9atx(52), _Char___init__impl__6a9atx(53), _Char___init__impl__6a9atx(54), _Char___init__impl__6a9atx(55), _Char___init__impl__6a9atx(56), _Char___init__impl__6a9atx(57), _Char___init__impl__6a9atx(48), _Char___init__impl__6a9atx(49), _Char___init__impl__6a9atx(50), _Char___init__impl__6a9atx(51), _Char___init__impl__6a9atx(52), _Char___init__impl__6a9atx(53), _Char___init__impl__6a9atx(54), _Char___init__impl__6a9atx(55), _Char___init__impl__6a9atx(56), _Char___init__impl__6a9atx(57), _Char___init__impl__6a9atx(48), _Char___init__impl__6a9atx(49), _Char___init__impl__6a9atx(50), _Char___init__impl__6a9atx(51), _Char___init__impl__6a9atx(52), _Char___init__impl__6a9atx(53), _Char___init__impl__6a9atx(54), _Char___init__impl__6a9atx(55), _Char___init__impl__6a9atx(56), _Char___init__impl__6a9atx(57), _Char___init__impl__6a9atx(48), _Char___init__impl__6a9atx(49), _Char___init__impl__6a9atx(50), _Char___init__impl__6a9atx(51), _Char___init__impl__6a9atx(52), _Char___init__impl__6a9atx(53), _Char___init__impl__6a9atx(54), _Char___init__impl__6a9atx(55), _Char___init__impl__6a9atx(56), _Char___init__impl__6a9atx(57), _Char___init__impl__6a9atx(48), _Char___init__impl__6a9atx(49), _Char___init__impl__6a9atx(50), _Char___init__impl__6a9atx(51), _Char___init__impl__6a9atx(52), _Char___init__impl__6a9atx(53), _Char___init__impl__6a9atx(54), _Char___init__impl__6a9atx(55), _Char___init__impl__6a9atx(56), _Char___init__impl__6a9atx(57), _Char___init__impl__6a9atx(48), _Char___init__impl__6a9atx(49), _Char___init__impl__6a9atx(50), _Char___init__impl__6a9atx(51), _Char___init__impl__6a9atx(52), _Char___init__impl__6a9atx(53), _Char___init__impl__6a9atx(54), _Char___init__impl__6a9atx(55), _Char___init__impl__6a9atx(56), _Char___init__impl__6a9atx(57), _Char___init__impl__6a9atx(48), _Char___init__impl__6a9atx(49), _Char___init__impl__6a9atx(50), _Char___init__impl__6a9atx(51), _Char___init__impl__6a9atx(52), _Char___init__impl__6a9atx(53), _Char___init__impl__6a9atx(54), _Char___init__impl__6a9atx(55), _Char___init__impl__6a9atx(56), _Char___init__impl__6a9atx(57), _Char___init__impl__6a9atx(48), _Char___init__impl__6a9atx(49), _Char___init__impl__6a9atx(50), _Char___init__impl__6a9atx(51), _Char___init__impl__6a9atx(52), _Char___init__impl__6a9atx(53), _Char___init__impl__6a9atx(54), _Char___init__impl__6a9atx(55), _Char___init__impl__6a9atx(56), _Char___init__impl__6a9atx(57)]);
  }
}
class LongOverflow {
  constructor() {
    LongOverflow_instance = this;
    this.xu_1 = Companion_getInstance_22().ofLong(-9223372036854775808n);
    this.yu_1 = Companion_getInstance_22().ofLong(9223372036854775807n);
  }
  zu(num) {
    var intVal = inflated(num);
    if (intVal.br(this.xu_1) < 0 || intVal.br(this.yu_1) > 0) {
      throw ArithmeticException.cc('Overflow');
    }
  }
}
class StringBuilderHelper {
  constructor(sb, compactCharArray) {
    Companion_getInstance_20();
    sb = sb === VOID ? StringBuilder.y() : sb;
    compactCharArray = compactCharArray === VOID ? charArray(19) : compactCharArray;
    this.av_1 = sb;
    this.bv_1 = compactCharArray;
  }
  cv() {
    removeRange(this.av_1, 0, this.av_1.a());
    return this.av_1;
  }
  dv(intCompact) {
    var intCompact_0 = intCompact;
    // Inline function 'kotlin.require' call
    // Inline function 'kotlin.require' call
    if (!(intCompact_0 >= 0n)) {
      var message = 'Failed requirement.';
      throw IllegalArgumentException.w(toString_1(message));
    }
    var q;
    var r;
    var charPos = this.bv_1.length;
    while (intCompact_0 > 2147483647n) {
      // Inline function 'kotlin.Long.div' call
      var this_0 = intCompact_0;
      q = divide(this_0, fromInt_0(100));
      var tmp = intCompact_0;
      // Inline function 'kotlin.Long.times' call
      var tmp$ret$4 = multiply_0(q, fromInt_0(100));
      r = convertToInt(subtract_0(tmp, tmp$ret$4));
      intCompact_0 = q;
      charPos = charPos - 1 | 0;
      this.bv_1[charPos] = Companion_getInstance_20().cs_1[r];
      charPos = charPos - 1 | 0;
      this.bv_1[charPos] = Companion_getInstance_20().bs_1[r];
    }
    var q2;
    var i2 = convertToInt(intCompact_0);
    while (i2 >= 100) {
      q2 = i2 / 100 | 0;
      r = i2 - imul_0(q2, 100) | 0;
      i2 = q2;
      charPos = charPos - 1 | 0;
      this.bv_1[charPos] = Companion_getInstance_20().cs_1[r];
      charPos = charPos - 1 | 0;
      this.bv_1[charPos] = Companion_getInstance_20().bs_1[r];
    }
    charPos = charPos - 1 | 0;
    this.bv_1[charPos] = Companion_getInstance_20().cs_1[i2];
    if (i2 >= 10) {
      charPos = charPos - 1 | 0;
      this.bv_1[charPos] = Companion_getInstance_20().bs_1[i2];
    }
    return charPos;
  }
}
class Companion_21 {
  constructor() {
    Companion_instance_21 = this;
    this.ft_1 = -9223372036854775808n;
    this.gt_1 = Companion_getInstance_22().ofLong(-9223372036854775808n);
    this.ht_1 = 18;
    var tmp = this;
    // Inline function 'kotlin.arrayOf' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    tmp.it_1 = [CommonBigDecimal.eu(Companion_getInstance_22().ZERO, 0n, 0, 1), CommonBigDecimal.eu(Companion_getInstance_22().ONE, 1n, 0, 1), CommonBigDecimal.eu(Companion_getInstance_22().TWO, 2n, 0, 1), CommonBigDecimal.eu(Companion_getInstance_22().of(3), 3n, 0, 1), CommonBigDecimal.eu(Companion_getInstance_22().of(4), 4n, 0, 1), CommonBigDecimal.eu(Companion_getInstance_22().of(5), 5n, 0, 1), CommonBigDecimal.eu(Companion_getInstance_22().of(6), 6n, 0, 1), CommonBigDecimal.eu(Companion_getInstance_22().of(7), 7n, 0, 1), CommonBigDecimal.eu(Companion_getInstance_22().of(8), 8n, 0, 1), CommonBigDecimal.eu(Companion_getInstance_22().of(9), 9n, 0, 1), CommonBigDecimal.eu(Companion_getInstance_22().TEN, 10n, 0, 2)];
    var tmp_0 = this;
    // Inline function 'kotlin.arrayOf' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    tmp_0.jt_1 = [this.it_1[0], CommonBigDecimal.eu(Companion_getInstance_22().ZERO, 0n, 1, 1), CommonBigDecimal.eu(Companion_getInstance_22().ZERO, 0n, 2, 1), CommonBigDecimal.eu(Companion_getInstance_22().ZERO, 0n, 3, 1), CommonBigDecimal.eu(Companion_getInstance_22().ZERO, 0n, 4, 1), CommonBigDecimal.eu(Companion_getInstance_22().ZERO, 0n, 5, 1), CommonBigDecimal.eu(Companion_getInstance_22().ZERO, 0n, 6, 1), CommonBigDecimal.eu(Companion_getInstance_22().ZERO, 0n, 7, 1), CommonBigDecimal.eu(Companion_getInstance_22().ZERO, 0n, 8, 1), CommonBigDecimal.eu(Companion_getInstance_22().ZERO, 0n, 9, 1), CommonBigDecimal.eu(Companion_getInstance_22().ZERO, 0n, 10, 1), CommonBigDecimal.eu(Companion_getInstance_22().ZERO, 0n, 11, 1), CommonBigDecimal.eu(Companion_getInstance_22().ZERO, 0n, 12, 1), CommonBigDecimal.eu(Companion_getInstance_22().ZERO, 0n, 13, 1), CommonBigDecimal.eu(Companion_getInstance_22().ZERO, 0n, 14, 1), CommonBigDecimal.eu(Companion_getInstance_22().ZERO, 0n, 15, 1)];
    this.kt_1 = 4611686018427387903n;
    this.lt_1 = -4611686018427387904n;
    this.ZERO = this.it_1[0];
    this.ONE = this.it_1[1];
    this.TWO = this.it_1[2];
    this.TEN = this.it_1[10];
    this.ONE_TENTH = this.ofScaledLong(1n, 1);
    this.ONE_HALF = this.ofScaledLong(5n, 1);
    this.PI = this.parse('3.141592653589793238462643383279502884197169399375105820974944592307816406286208998628034825342117067982148086513282306647093844609550582231725359408128481117450284102701938521105559644622948954930381964428810975665933446128475648233786783165271201909145648');
    this.E = this.parse('2.718281828459045235360287471352662497757247093699959574966967627724076630353547594571382178525166427427466391932003059921817413596629043572900334295260595630738132328627943490763233829880753195251019011573834187930702154089149934884167509244761460668082264');
    var tmp_1 = this;
    // Inline function 'kotlin.doubleArrayOf' call
    tmp_1.mt_1 = new Float64Array([1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22]);
    var tmp_2 = this;
    // Inline function 'kotlin.floatArrayOf' call
    tmp_2.nt_1 = new Float32Array([1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10]);
    var tmp_3 = this;
    // Inline function 'kotlin.longArrayOf' call
    tmp_3.ot_1 = new BigInt64Array([1n, 10n, 100n, 1000n, 10000n, 100000n, 1000000n, 10000000n, 100000000n, 1000000000n, 10000000000n, 100000000000n, 1000000000000n, 10000000000000n, 100000000000000n, 1000000000000000n, 10000000000000000n, 100000000000000000n, 1000000000000000000n]);
    var tmp_4 = this;
    // Inline function 'kotlin.arrayOf' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    tmp_4.pt_1 = [Companion_getInstance_22().ONE, Companion_getInstance_22().of(10), Companion_getInstance_22().of(100), Companion_getInstance_22().of(1000), Companion_getInstance_22().of(10000), Companion_getInstance_22().of(100000), Companion_getInstance_22().of(1000000), Companion_getInstance_22().of(10000000), Companion_getInstance_22().of(100000000), Companion_getInstance_22().of(1000000000), Companion_getInstance_22().ofLong(10000000000n), Companion_getInstance_22().ofLong(100000000000n), Companion_getInstance_22().ofLong(1000000000000n), Companion_getInstance_22().ofLong(10000000000000n), Companion_getInstance_22().ofLong(100000000000000n), Companion_getInstance_22().ofLong(1000000000000000n), Companion_getInstance_22().ofLong(10000000000000000n), Companion_getInstance_22().ofLong(100000000000000000n), Companion_getInstance_22().ofLong(1000000000000000000n)];
    this.qt_1 = this.pt_1.length;
    this.rt_1 = imul_0(16, this.qt_1);
    var tmp_5 = this;
    // Inline function 'kotlin.longArrayOf' call
    tmp_5.st_1 = new BigInt64Array([9223372036854775807n, 922337203685477580n, 92233720368547758n, 9223372036854775n, 922337203685477n, 92233720368547n, 9223372036854n, 922337203685n, 92233720368n, 9223372036n, 922337203n, 92233720n, 9223372n, 922337n, 92233n, 9223n, 922n, 92n, 9n]);
    this.tt_1 = 4294967296n;
    var tmp_6 = this;
    // Inline function 'kotlin.longArrayOf' call
    var tmp_7 = new BigInt64Array([0n, -8446744073709551616n]);
    // Inline function 'kotlin.longArrayOf' call
    var tmp_8 = new BigInt64Array([5n, 7766279631452241920n]);
    // Inline function 'kotlin.longArrayOf' call
    var tmp_9 = new BigInt64Array([54n, 3875820019684212736n]);
    // Inline function 'kotlin.longArrayOf' call
    var tmp_10 = new BigInt64Array([542n, 1864712049423024128n]);
    // Inline function 'kotlin.longArrayOf' call
    var tmp_11 = new BigInt64Array([5421n, 200376420520689664n]);
    // Inline function 'kotlin.longArrayOf' call
    var tmp_12 = new BigInt64Array([54210n, 2003764205206896640n]);
    // Inline function 'kotlin.longArrayOf' call
    var tmp_13 = new BigInt64Array([542101n, 1590897978359414784n]);
    // Inline function 'kotlin.longArrayOf' call
    var tmp_14 = new BigInt64Array([5421010n, -2537764290115403776n]);
    // Inline function 'kotlin.longArrayOf' call
    var tmp_15 = new BigInt64Array([54210108n, -6930898827444486144n]);
    // Inline function 'kotlin.longArrayOf' call
    var tmp_16 = new BigInt64Array([542101086n, 4477988020393345024n]);
    // Inline function 'kotlin.longArrayOf' call
    var tmp_17 = new BigInt64Array([5421010862n, 7886392056514347008n]);
    // Inline function 'kotlin.longArrayOf' call
    var tmp_18 = new BigInt64Array([54210108624n, 5076944270305263616n]);
    // Inline function 'kotlin.longArrayOf' call
    var tmp_19 = new BigInt64Array([542101086242n, -4570789518076018688n]);
    // Inline function 'kotlin.longArrayOf' call
    var tmp_20 = new BigInt64Array([5421010862427n, -8814407033341083648n]);
    // Inline function 'kotlin.longArrayOf' call
    var tmp_21 = new BigInt64Array([54210108624275n, 4089650035136921600n]);
    // Inline function 'kotlin.longArrayOf' call
    var tmp_22 = new BigInt64Array([542101086242752n, 4003012203950112768n]);
    // Inline function 'kotlin.longArrayOf' call
    var tmp_23 = new BigInt64Array([5421010862427522n, 3136633892082024448n]);
    // Inline function 'kotlin.longArrayOf' call
    var tmp_24 = new BigInt64Array([54210108624275221n, -5527149226598858752n]);
    // Inline function 'kotlin.longArrayOf' call
    var tmp_25 = new BigInt64Array([542101086242752217n, 68739955140067328n]);
    // Inline function 'kotlin.longArrayOf' call
    // Inline function 'kotlin.arrayOf' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    tmp_6.ut_1 = [tmp_7, tmp_8, tmp_9, tmp_10, tmp_11, tmp_12, tmp_13, tmp_14, tmp_15, tmp_16, tmp_17, tmp_18, tmp_19, tmp_20, tmp_21, tmp_22, tmp_23, tmp_24, tmp_25, new BigInt64Array([5421010862427522170n, 687399551400673280n])];
  }
  aq() {
    return this.ZERO;
  }
  bq() {
    return this.ONE;
  }
  cq() {
    return this.TWO;
  }
  dq() {
    return this.TEN;
  }
  eq() {
    return this.ONE_TENTH;
  }
  fq() {
    return this.ONE_HALF;
  }
  gq() {
    return this.PI;
  }
  hq() {
    return this.E;
  }
  ofScaledLong(unscaledVal, scale) {
    if (scale === 0) {
      return this.of(unscaledVal);
    } else if (unscaledVal === 0n) {
      return this.wu(scale);
    }
    var tmp;
    if (unscaledVal === -9223372036854775808n) {
      tmp = this.gt_1;
    } else {
      tmp = null;
    }
    return CommonBigDecimal.eu(tmp, unscaledVal, scale, 0);
  }
  ofScaledLongWithPrecision(unscaledVal, scale, prec) {
    var tmp;
    if (scale === 0 && unscaledVal >= 0n && unscaledVal < fromInt_0(this.it_1.length)) {
      tmp = this.it_1[convertToInt(unscaledVal)];
    } else if (unscaledVal === 0n) {
      tmp = this.wu(scale);
    } else {
      tmp = CommonBigDecimal.eu(unscaledVal === -9223372036854775808n ? this.gt_1 : null, unscaledVal, scale, prec);
    }
    return tmp;
  }
  ofInt(val) {
    return this.of(fromInt_0(val));
  }
  of(val) {
    var tmp;
    if (val >= 0n && val < fromInt_0(this.it_1.length)) {
      tmp = this.it_1[convertToInt(val)];
    } else {
      var tmp_0;
      if (!(val === -9223372036854775808n)) {
        tmp_0 = CommonBigDecimal.eu((null == null ? true : null instanceof CommonBigInteger) ? null : THROW_CCE(), val, 0, 0);
      } else {
        tmp_0 = CommonBigDecimal.eu(this.gt_1, val, 0, 0);
      }
      tmp = tmp_0;
    }
    return tmp;
  }
  ofScaledBigIntegerWithPrecision(intVal, scale, prec) {
    var val = compactValFor(this, intVal);
    if (val === 0n) {
      return this.wu(scale);
    } else if (scale === 0 && val >= 0n && val < fromInt_0(this.it_1.length)) {
      return this.it_1[convertToInt(val)];
    }
    return CommonBigDecimal.eu(intVal, val, scale, prec);
  }
  wu(scale) {
    var tmp;
    if (scale >= 0 && scale < this.jt_1.length) {
      tmp = this.jt_1[scale];
    } else {
      tmp = CommonBigDecimal.eu(Companion_getInstance_22().ZERO, 0n, scale, 1);
    }
    return tmp;
  }
  ofDouble(val, ctx) {
    return CommonBigDecimal.ev(val, ctx);
  }
  ofFloat(val, ctx) {
    return this.ofDouble(val, ctx);
  }
  kq(val, ctx) {
    var tmp;
    if (ctx === null) {
      tmp = CommonBigDecimal.gv(val);
    } else {
      tmp = CommonBigDecimal.fv(val, ctx);
    }
    return tmp;
  }
  parse(val, ctx, $super) {
    ctx = ctx === VOID ? null : ctx;
    return $super === VOID ? this.kq(val, ctx) : $super.kq.call(this, val, ctx);
  }
  hv(val, ctx) {
    var tmp;
    if (ctx === null) {
      tmp = CommonBigDecimal.jv(val);
    } else {
      tmp = CommonBigDecimal.iv(val, ctx);
    }
    return tmp;
  }
  ofBigInteger(val, ctx, $super) {
    ctx = ctx === VOID ? null : ctx;
    return $super === VOID ? this.hv(val, ctx) : $super.hv.call(this, val, ctx);
  }
  ofIntWithContext(val, ctx) {
    return CommonBigDecimal.kv(fromInt_0(val), ctx);
  }
  ofWithContext(val, ctx) {
    return CommonBigDecimal.kv(val, ctx);
  }
  du(x) {
    var x_0 = x;
    // Inline function 'kotlin.require' call
    // Inline function 'kotlin.require' call
    if (!!(x_0 === -9223372036854775808n)) {
      var message = 'Failed requirement.';
      throw IllegalArgumentException.w(toString_1(message));
    }
    if (x_0 < 0n) {
      x_0 = negate_0(x_0);
    }
    if (x_0 < 10n) {
      return 1;
    }
    var r = imul_0((64 - numberOfLeadingZeros_0(x_0) | 0) + 1 | 0, 1233) >>> 12 | 0;
    var tab = this.ot_1;
    return r >= tab.length || x_0 < tab[r] ? r : r + 1 | 0;
  }
  vu(n, sign, scale) {
    if (n < this.ot_1.length) {
      return this.ofScaledLong(multiply_0(numberToLong(sign), this.ot_1[n]), scale);
    } else {
      var unscaledVal = bigTenToThe(this, n);
      if (sign === -1) {
        unscaledVal = unscaledVal.unaryMinus();
      }
      return CommonBigDecimal.eu(unscaledVal, -9223372036854775808n, scale, n + 1 | 0);
    }
  }
}
class CommonBigDecimal {
  static eu(intVal, val, scale, prec) {
    Companion_getInstance_21();
    var $this = createThis(this);
    init_com_macrofocus_common_math_big_CommonBigDecimal($this);
    $this.wt_1 = scale;
    $this.xt_1 = prec;
    $this.zt_1 = val;
    $this.vt_1 = intVal;
    return $this;
  }
  static lv(in_0, offset, len, mc) {
    Companion_getInstance_21();
    offset = offset === VOID ? 0 : offset;
    len = len === VOID ? in_0.length : len;
    mc = mc === VOID ? Companion_getInstance_23().UNLIMITED : mc;
    var $this = createThis(this);
    init_com_macrofocus_common_math_big_CommonBigDecimal($this);
    var offset_0 = offset;
    var len_0 = len;
    if ((offset_0 + len_0 | 0) > in_0.length || offset_0 < 0) {
      throw NumberFormatException.xb('Bad offset or len arguments for char[] input.');
    }
    var prec = 0;
    var scl = 0;
    var rs = 0n;
    var rb = null;
    try {
      var isneg = false;
      if (in_0[offset_0] === _Char___init__impl__6a9atx(45)) {
        isneg = true;
        offset_0 = offset_0 + 1 | 0;
        len_0 = len_0 - 1 | 0;
      } else if (in_0[offset_0] === _Char___init__impl__6a9atx(43)) {
        offset_0 = offset_0 + 1 | 0;
        len_0 = len_0 - 1 | 0;
      }
      var dot = false;
      var exp = 0n;
      var c;
      var isCompact = len_0 <= 18;
      var idx = 0;
      if (isCompact) {
        $l$loop: while (len_0 > 0) {
          c = in_0[offset_0];
          if (c === _Char___init__impl__6a9atx(48)) {
            if (prec === 0) {
              prec = 1;
            } else if (!(rs === 0n)) {
              // Inline function 'kotlin.Long.times' call
              var this_0 = rs;
              rs = multiply_0(this_0, fromInt_0(10));
              prec = prec + 1 | 0;
            }
            if (dot) {
              scl = scl + 1 | 0;
            }
          } else if (_Char___init__impl__6a9atx(49) <= c ? c <= _Char___init__impl__6a9atx(57) : false) {
            var digit = Char__minus_impl_a2frrh(c, _Char___init__impl__6a9atx(48));
            if (!(prec === 1) || !(rs === 0n)) {
              prec = prec + 1 | 0;
            }
            // Inline function 'kotlin.Long.times' call
            var this_1 = rs;
            // Inline function 'kotlin.Long.plus' call
            var this_2 = multiply_0(this_1, fromInt_0(10));
            rs = add_0(this_2, fromInt_0(digit));
            if (dot) {
              scl = scl + 1 | 0;
            }
          } else if (c === _Char___init__impl__6a9atx(46)) {
            if (dot) {
              throw NumberFormatException.xb('Character array contains more than one decimal point.');
            }
            dot = true;
          } else if (isDigit(c)) {
            var digit_0 = toDigit(c, 10);
            if (digit_0 === 0) {
              if (prec === 0) {
                prec = 1;
              } else if (!(rs === 0n)) {
                // Inline function 'kotlin.Long.times' call
                var this_3 = rs;
                rs = multiply_0(this_3, fromInt_0(10));
                prec = prec + 1 | 0;
              }
            } else {
              if (!(prec === 1) || !(rs === 0n)) {
                prec = prec + 1 | 0;
              }
              // Inline function 'kotlin.Long.times' call
              var this_4 = rs;
              // Inline function 'kotlin.Long.plus' call
              var this_5 = multiply_0(this_4, fromInt_0(10));
              rs = add_0(this_5, fromInt_0(digit_0));
            }
            if (dot) {
              scl = scl + 1 | 0;
            }
          } else if (c === _Char___init__impl__6a9atx(101) || c === _Char___init__impl__6a9atx(69)) {
            exp = parseExp(Companion_getInstance_21(), in_0, offset_0, len_0);
            if (!(fromInt_0(convertToInt(exp)) === exp)) {
              throw NumberFormatException.xb('Exponent overflow.');
            }
            break $l$loop;
          } else {
            throw NumberFormatException.xb('Character ' + toString(c) + ' is neither a decimal digit number, decimal point, nor' + ' "e" notation exponential mark.');
          }
          offset_0 = offset_0 + 1 | 0;
          len_0 = len_0 - 1 | 0;
        }
        if (prec === 0) {
          throw NumberFormatException.xb('No digits found.');
        }
        if (!(exp === 0n)) {
          scl = adjustScale($this, scl, exp);
        }
        rs = isneg ? negate_0(rs) : rs;
        var mcp = mc.precision;
        var drop = prec - mcp | 0;
        if (mcp > 0 && drop > 0) {
          while (drop > 0) {
            var tmp = Companion_getInstance_21();
            var tmp0 = fromInt_0(scl);
            // Inline function 'kotlin.Long.minus' call
            var other = drop;
            var tmp$ret$6 = subtract_0(tmp0, fromInt_0(other));
            scl = checkScaleNonZero(tmp, tmp$ret$6);
            rs = divideAndRound_0(Companion_getInstance_21(), rs, Companion_getInstance_21().ot_1[drop], mc.roundingMode.value);
            prec = Companion_getInstance_21().du(rs);
            drop = prec - mcp | 0;
          }
        }
      } else {
        var coeff = charArray(len_0);
        $l$loop_1: while (len_0 > 0) {
          c = in_0[offset_0];
          if ((_Char___init__impl__6a9atx(48) <= c ? c <= _Char___init__impl__6a9atx(57) : false) || isDigit(c)) {
            if (c === _Char___init__impl__6a9atx(48) || toDigit(c, 10) === 0) {
              if (prec === 0) {
                coeff[idx] = c;
                prec = 1;
              } else if (!(idx === 0)) {
                var _unary__edvuaz = idx;
                idx = _unary__edvuaz + 1 | 0;
                coeff[_unary__edvuaz] = c;
                prec = prec + 1 | 0;
              }
            } else {
              if (!(prec === 1) || !(idx === 0)) {
                prec = prec + 1 | 0;
              }
              var _unary__edvuaz_0 = idx;
              idx = _unary__edvuaz_0 + 1 | 0;
              coeff[_unary__edvuaz_0] = c;
            }
            if (dot) {
              scl = scl + 1 | 0;
            }
            offset_0 = offset_0 + 1 | 0;
            len_0 = len_0 - 1 | 0;
            continue $l$loop_1;
          }
          if (c === _Char___init__impl__6a9atx(46)) {
            if (dot) {
              throw NumberFormatException.xb('Character array contains more than one decimal point.');
            }
            dot = true;
            offset_0 = offset_0 + 1 | 0;
            len_0 = len_0 - 1 | 0;
            continue $l$loop_1;
          }
          if (!(c === _Char___init__impl__6a9atx(101)) && !(c === _Char___init__impl__6a9atx(69))) {
            throw NumberFormatException.xb('Character array is missing "e" notation exponential mark.');
          }
          exp = parseExp(Companion_getInstance_21(), in_0, offset_0, len_0);
          if (!(fromInt_0(convertToInt(exp)) === exp)) {
            throw NumberFormatException.xb('Exponent overflow.');
          }
          break $l$loop_1;
        }
        if (prec === 0) {
          throw NumberFormatException.xb('No digits found.');
        }
        if (!(exp === 0n)) {
          scl = adjustScale($this, scl, exp);
        }
        rb = CommonBigInteger.mv(coeff, isneg ? -1 : 1, prec);
        rs = compactValFor(Companion_getInstance_21(), rb);
        var mcp_0 = mc.precision;
        if (1 <= mcp_0 ? mcp_0 < prec : false) {
          if (rs === -9223372036854775808n) {
            var drop_0 = prec - mcp_0 | 0;
            $l$loop_2: while (drop_0 > 0) {
              var tmp_0 = Companion_getInstance_21();
              var tmp0_0 = fromInt_0(scl);
              // Inline function 'kotlin.Long.minus' call
              var other_0 = drop_0;
              var tmp$ret$7 = subtract_0(tmp0_0, fromInt_0(other_0));
              scl = checkScaleNonZero(tmp_0, tmp$ret$7);
              rb = divideAndRoundByTenPow(Companion_getInstance_21(), ensureNotNull(rb), drop_0, mc.roundingMode.value);
              rs = compactValFor(Companion_getInstance_21(), rb);
              if (!(rs === -9223372036854775808n)) {
                prec = Companion_getInstance_21().du(rs);
                break $l$loop_2;
              }
              prec = bigDigitLength(Companion_getInstance_21(), rb);
              drop_0 = prec - mcp_0 | 0;
            }
          }
          if (!(rs === -9223372036854775808n)) {
            var drop_1 = prec - mcp_0 | 0;
            while (drop_1 > 0) {
              var tmp_1 = Companion_getInstance_21();
              var tmp0_1 = fromInt_0(scl);
              // Inline function 'kotlin.Long.minus' call
              var other_1 = drop_1;
              var tmp$ret$8 = subtract_0(tmp0_1, fromInt_0(other_1));
              scl = checkScaleNonZero(tmp_1, tmp$ret$8);
              rs = divideAndRound_0(Companion_getInstance_21(), rs, Companion_getInstance_21().ot_1[drop_1], mc.roundingMode.value);
              prec = Companion_getInstance_21().du(rs);
              drop_1 = prec - mcp_0 | 0;
            }
            rb = null;
          }
        }
      }
    } catch ($p) {
      if ($p instanceof IndexOutOfBoundsException) {
        var e = $p;
        var nfe = NumberFormatException.wb();
        throw nfe;
      } else {
        if ($p instanceof RuntimeException) {
          var e_0 = $p;
          var nfe_0 = NumberFormatException.wb();
          throw nfe_0;
        } else {
          throw $p;
        }
      }
    }
    $this.wt_1 = scl;
    $this.xt_1 = prec;
    $this.zt_1 = rs;
    $this.vt_1 = rb;
    return $this;
  }
  static gv(val) {
    Companion_getInstance_21();
    return this.lv(toCharArray_0(val), 0, val.length);
  }
  static fv(val, mc) {
    Companion_getInstance_21();
    return this.lv(toCharArray_0(val), 0, val.length, mc);
  }
  static ev(val, mc) {
    Companion_getInstance_21();
    mc = mc === VOID ? Companion_getInstance_23().UNLIMITED : mc;
    var $this = createThis(this);
    init_com_macrofocus_common_math_big_CommonBigDecimal($this);
    if (isInfinite(val) || isInfinite(val)) {
      throw NumberFormatException.xb('Infinite or NaN');
    }
    var valBits = toBits(val);
    var sign = shiftRight(valBits, 63) === 0n ? 1 : -1;
    var exponent = convertToInt(shiftRight(valBits, 52) & 2047n);
    var tmp;
    if (exponent === 0) {
      // Inline function 'kotlin.Long.minus' call
      var this_0 = 4503599627370496n;
      var tmp$ret$0 = subtract_0(this_0, fromInt_0(1));
      tmp = shiftLeft(valBits & tmp$ret$0, 1);
    } else {
      // Inline function 'kotlin.Long.minus' call
      var this_1 = 4503599627370496n;
      tmp = valBits & subtract_0(this_1, fromInt_0(1)) | 4503599627370496n;
    }
    var significand = tmp;
    exponent = exponent - 1075 | 0;
    if (significand === 0n) {
      $this.vt_1 = Companion_getInstance_22().ZERO;
      $this.wt_1 = 0;
      $this.zt_1 = 0n;
      $this.xt_1 = 1;
      return $this;
    }
    while ((significand & 1n) === 0n) {
      significand = shiftRight(significand, 1);
      exponent = exponent + 1 | 0;
    }
    var scl = 0;
    var rb;
    var compactVal = multiply_0(numberToLong(sign), significand);
    if (exponent === 0) {
      rb = compactVal === -9223372036854775808n ? Companion_getInstance_21().gt_1 : null;
    } else {
      if (exponent < 0) {
        rb = Companion_getInstance_22().of(5).pow(-exponent | 0).uu(compactVal);
        scl = -exponent | 0;
      } else {
        rb = Companion_getInstance_22().TWO.pow(exponent).uu(compactVal);
      }
      compactVal = compactValFor(Companion_getInstance_21(), rb);
    }
    var prec = 0;
    var mcp = mc.precision;
    if (mcp > 0) {
      var mode = mc.roundingMode.value;
      var drop;
      if (compactVal === -9223372036854775808n) {
        prec = bigDigitLength(Companion_getInstance_21(), ensureNotNull(rb));
        drop = prec - mcp | 0;
        $l$loop: while (drop > 0) {
          var tmp_0 = Companion_getInstance_21();
          var tmp0 = fromInt_0(scl);
          // Inline function 'kotlin.Long.minus' call
          var other = drop;
          var tmp$ret$2 = subtract_0(tmp0, fromInt_0(other));
          scl = checkScaleNonZero(tmp_0, tmp$ret$2);
          rb = divideAndRoundByTenPow(Companion_getInstance_21(), ensureNotNull(rb), drop, mode);
          compactVal = compactValFor(Companion_getInstance_21(), rb);
          if (!(compactVal === -9223372036854775808n)) {
            break $l$loop;
          }
          prec = bigDigitLength(Companion_getInstance_21(), rb);
          drop = prec - mcp | 0;
        }
      }
      if (!(compactVal === -9223372036854775808n)) {
        prec = Companion_getInstance_21().du(compactVal);
        drop = prec - mcp | 0;
        while (drop > 0) {
          var tmp_1 = Companion_getInstance_21();
          var tmp0_0 = fromInt_0(scl);
          // Inline function 'kotlin.Long.minus' call
          var other_0 = drop;
          var tmp$ret$3 = subtract_0(tmp0_0, fromInt_0(other_0));
          scl = checkScaleNonZero(tmp_1, tmp$ret$3);
          compactVal = divideAndRound_0(Companion_getInstance_21(), compactVal, Companion_getInstance_21().ot_1[drop], mc.roundingMode.value);
          prec = Companion_getInstance_21().du(compactVal);
          drop = prec - mcp | 0;
        }
        rb = null;
      }
    }
    $this.vt_1 = rb;
    $this.zt_1 = compactVal;
    $this.wt_1 = scl;
    $this.xt_1 = prec;
    return $this;
  }
  static jv(val) {
    Companion_getInstance_21();
    var $this = createThis(this);
    init_com_macrofocus_common_math_big_CommonBigDecimal($this);
    $this.wt_1 = 0;
    $this.vt_1 = val;
    $this.zt_1 = compactValFor(Companion_getInstance_21(), val);
    return $this;
  }
  static iv(val, mc) {
    Companion_getInstance_21();
    return this.nv(val, 0, mc);
  }
  static tu(unscaledVal, scale) {
    Companion_getInstance_21();
    var $this = createThis(this);
    init_com_macrofocus_common_math_big_CommonBigDecimal($this);
    $this.vt_1 = unscaledVal;
    $this.zt_1 = compactValFor(Companion_getInstance_21(), unscaledVal);
    $this.wt_1 = scale;
    return $this;
  }
  static nv(unscaledVal, scale, mc) {
    Companion_getInstance_21();
    var $this = createThis(this);
    init_com_macrofocus_common_math_big_CommonBigDecimal($this);
    var unscaledVal_0 = unscaledVal;
    var scale_0 = scale;
    var compactVal = compactValFor(Companion_getInstance_21(), ensureNotNull(unscaledVal_0));
    var mcp = mc.precision;
    var prec = 0;
    if (mcp > 0) {
      var mode = mc.roundingMode.value;
      if (compactVal === -9223372036854775808n) {
        prec = bigDigitLength(Companion_getInstance_21(), unscaledVal_0);
        var drop = prec - mcp | 0;
        $l$loop: while (drop > 0) {
          var tmp = Companion_getInstance_21();
          var tmp0 = fromInt_0(scale_0);
          // Inline function 'kotlin.Long.minus' call
          var other = drop;
          var tmp$ret$0 = subtract_0(tmp0, fromInt_0(other));
          scale_0 = checkScaleNonZero(tmp, tmp$ret$0);
          unscaledVal_0 = divideAndRoundByTenPow(Companion_getInstance_21(), ensureNotNull(unscaledVal_0), drop, mode);
          compactVal = compactValFor(Companion_getInstance_21(), unscaledVal_0);
          if (!(compactVal === -9223372036854775808n)) {
            break $l$loop;
          }
          prec = bigDigitLength(Companion_getInstance_21(), unscaledVal_0);
          drop = prec - mcp | 0;
        }
      }
      if (!(compactVal === -9223372036854775808n)) {
        prec = Companion_getInstance_21().du(compactVal);
        var drop_0 = prec - mcp | 0;
        while (drop_0 > 0) {
          var tmp_0 = Companion_getInstance_21();
          var tmp0_0 = fromInt_0(scale_0);
          // Inline function 'kotlin.Long.minus' call
          var other_0 = drop_0;
          var tmp$ret$1 = subtract_0(tmp0_0, fromInt_0(other_0));
          scale_0 = checkScaleNonZero(tmp_0, tmp$ret$1);
          compactVal = divideAndRound_0(Companion_getInstance_21(), compactVal, Companion_getInstance_21().ot_1[drop_0], mode);
          prec = Companion_getInstance_21().du(compactVal);
          drop_0 = prec - mcp | 0;
        }
        unscaledVal_0 = null;
      }
    }
    $this.vt_1 = unscaledVal_0;
    $this.zt_1 = compactVal;
    $this.wt_1 = scale_0;
    $this.xt_1 = prec;
    return $this;
  }
  static kv(val, mc) {
    Companion_getInstance_21();
    var $this = createThis(this);
    init_com_macrofocus_common_math_big_CommonBigDecimal($this);
    var val_0 = val;
    var mcp = mc.precision;
    var mode = mc.roundingMode.value;
    var prec = 0;
    var scl = 0;
    var rb = val_0 === -9223372036854775808n ? Companion_getInstance_21().gt_1 : null;
    if (mcp > 0) {
      if (val_0 === -9223372036854775808n) {
        prec = 19;
        var drop = prec - mcp | 0;
        $l$loop: while (drop > 0) {
          var tmp = Companion_getInstance_21();
          var tmp0 = fromInt_0(scl);
          // Inline function 'kotlin.Long.minus' call
          var other = drop;
          var tmp$ret$0 = subtract_0(tmp0, fromInt_0(other));
          scl = checkScaleNonZero(tmp, tmp$ret$0);
          rb = divideAndRoundByTenPow(Companion_getInstance_21(), ensureNotNull(rb), drop, mode);
          val_0 = compactValFor(Companion_getInstance_21(), rb);
          if (!(val_0 === -9223372036854775808n)) {
            break $l$loop;
          }
          prec = bigDigitLength(Companion_getInstance_21(), rb);
          drop = prec - mcp | 0;
        }
      }
      if (!(val_0 === -9223372036854775808n)) {
        prec = Companion_getInstance_21().du(val_0);
        var drop_0 = prec - mcp | 0;
        while (drop_0 > 0) {
          var tmp_0 = Companion_getInstance_21();
          var tmp0_0 = fromInt_0(scl);
          // Inline function 'kotlin.Long.minus' call
          var other_0 = drop_0;
          var tmp$ret$1 = subtract_0(tmp0_0, fromInt_0(other_0));
          scl = checkScaleNonZero(tmp_0, tmp$ret$1);
          val_0 = divideAndRound_0(Companion_getInstance_21(), val_0, Companion_getInstance_21().ot_1[drop_0], mc.roundingMode.value);
          prec = Companion_getInstance_21().du(val_0);
          drop_0 = prec - mcp | 0;
        }
        rb = null;
      }
    }
    $this.vt_1 = rb;
    $this.zt_1 = val_0;
    $this.wt_1 = scl;
    $this.xt_1 = prec;
    return $this;
  }
  plus(augend) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var augend_0 = ensureNotNull(augend);
    var tmp;
    if (!(this.zt_1 === -9223372036854775808n)) {
      var tmp_0;
      if (!(augend_0.zt_1 === -9223372036854775808n)) {
        tmp_0 = sum_1(Companion_getInstance_21(), this.zt_1, this.wt_1, augend_0.zt_1, augend_0.wt_1);
      } else {
        tmp_0 = sum_2(Companion_getInstance_21(), this.zt_1, this.wt_1, ensureNotNull(augend_0.vt_1), augend_0.wt_1);
      }
      tmp = tmp_0;
    } else {
      var tmp_1;
      if (!(augend_0.zt_1 === -9223372036854775808n)) {
        tmp_1 = sum_2(Companion_getInstance_21(), augend_0.zt_1, augend_0.wt_1, ensureNotNull(this.vt_1), this.wt_1);
      } else {
        tmp_1 = sum_3(Companion_getInstance_21(), this.vt_1, this.wt_1, augend_0.vt_1, augend_0.wt_1);
      }
      tmp = tmp_1;
    }
    return tmp;
  }
  plusWithContext(augend, mc) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var augend_0 = ensureNotNull(augend);
    if (mc.precision === 0) {
      return this.plus(augend_0);
    }
    var lhs = this;
    // Inline function 'kotlin.run' call
    var lhsIsZero = lhs.signum === 0;
    var augendIsZero = augend_0.signum === 0;
    if (lhsIsZero || augendIsZero) {
      var tmp0 = lhs.scale;
      // Inline function 'kotlin.math.max' call
      var b = augend_0.scale;
      var preferredScale = Math.max(tmp0, b);
      var result = lhsIsZero ? doRound(Companion_getInstance_21(), augend_0, mc) : doRound(Companion_getInstance_21(), lhs, mc);
      if (lhsIsZero && augendIsZero) {
        return Companion_getInstance_21().wu(preferredScale);
      }
      if (ensureNotNull(result).scale === preferredScale) {
        return result;
      } else if (result.scale > preferredScale) {
        return stripZerosToMatchScale(Companion_getInstance_21(), result.vt_1, result.zt_1, result.wt_1, preferredScale);
      } else {
        var precisionDiff = mc.precision - result.precision | 0;
        var scaleDiff = preferredScale - result.scale | 0;
        var tmp;
        if (precisionDiff >= scaleDiff) {
          tmp = result.setScale(preferredScale);
        } else {
          tmp = result.setScale(result.scale + precisionDiff | 0);
        }
        return tmp;
      }
    }
    var tmp0_0 = fromInt_0(lhs.wt_1);
    // Inline function 'kotlin.Long.minus' call
    var other = augend_0.wt_1;
    var padding = subtract_0(tmp0_0, fromInt_0(other));
    if (!(padding === 0n)) {
      var arg = preAlign(this, lhs, augend_0, padding, mc);
      matchScale(Companion_getInstance_21(), arg);
      lhs = arg[0];
      augend_0 = arg[1];
    }
    return doRound_1(Companion_getInstance_21(), inflated(lhs).plus(inflated(augend_0)), lhs.wt_1, mc);
  }
  minus(subtrahend) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var subtrahend_0 = subtrahend;
    var tmp;
    if (!(this.zt_1 === -9223372036854775808n)) {
      var tmp_0;
      if (!(subtrahend_0.zt_1 === -9223372036854775808n)) {
        tmp_0 = sum_1(Companion_getInstance_21(), this.zt_1, this.wt_1, negate_0(subtrahend_0.zt_1), subtrahend_0.wt_1);
      } else {
        tmp_0 = sum_2(Companion_getInstance_21(), this.zt_1, this.wt_1, ensureNotNull(subtrahend_0.vt_1).unaryMinus(), subtrahend_0.wt_1);
      }
      tmp = tmp_0;
    } else {
      var tmp_1;
      if (!(subtrahend_0.zt_1 === -9223372036854775808n)) {
        tmp_1 = sum_2(Companion_getInstance_21(), negate_0(subtrahend_0.zt_1), subtrahend_0.wt_1, ensureNotNull(this.vt_1), this.wt_1);
      } else {
        tmp_1 = sum_3(Companion_getInstance_21(), this.vt_1, this.wt_1, ensureNotNull(subtrahend_0.vt_1).unaryMinus(), subtrahend_0.wt_1);
      }
      tmp = tmp_1;
    }
    return tmp;
  }
  minusWithContext(subtrahend, mc) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var subtrahend_0 = subtrahend;
    return mc.precision === 0 ? this.minus(subtrahend_0) : this.plusWithContext(subtrahend_0.unaryMinus(), mc);
  }
  times(multiplicand) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var multiplicand_0 = ensureNotNull(multiplicand);
    var tmp0 = fromInt_0(this.wt_1);
    // Inline function 'kotlin.Long.plus' call
    var other = multiplicand_0.wt_1;
    var tmp$ret$3 = add_0(tmp0, fromInt_0(other));
    var productScale = checkScale_1(this, tmp$ret$3);
    var tmp;
    if (!(this.zt_1 === -9223372036854775808n)) {
      var tmp_0;
      if (!(multiplicand_0.zt_1 === -9223372036854775808n)) {
        tmp_0 = multiply_2(Companion_getInstance_21(), this.zt_1, multiplicand_0.zt_1, productScale);
      } else {
        tmp_0 = multiply_3(Companion_getInstance_21(), this.zt_1, multiplicand_0.vt_1, productScale);
      }
      tmp = tmp_0;
    } else {
      var tmp_1;
      if (!(multiplicand_0.zt_1 === -9223372036854775808n)) {
        tmp_1 = multiply_3(Companion_getInstance_21(), multiplicand_0.zt_1, this.vt_1, productScale);
      } else {
        tmp_1 = multiply_4(Companion_getInstance_21(), ensureNotNull(this.vt_1), multiplicand_0.vt_1, productScale);
      }
      tmp = tmp_1;
    }
    return tmp;
  }
  timesWithContext(multiplicand, mc) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var multiplicand_0 = multiplicand;
    if (mc.precision === 0) {
      return this.times(multiplicand_0);
    }
    var tmp0 = fromInt_0(this.wt_1);
    // Inline function 'kotlin.Long.plus' call
    var other = multiplicand_0.wt_1;
    var tmp$ret$3 = add_0(tmp0, fromInt_0(other));
    var productScale = checkScale_1(this, tmp$ret$3);
    var tmp;
    if (!(this.zt_1 === -9223372036854775808n)) {
      var tmp_0;
      if (!(multiplicand_0.zt_1 === -9223372036854775808n)) {
        tmp_0 = multiplyAndRound(Companion_getInstance_21(), this.zt_1, multiplicand_0.zt_1, productScale, mc);
      } else {
        tmp_0 = multiplyAndRound_0(Companion_getInstance_21(), this.zt_1, multiplicand_0.vt_1, productScale, mc);
      }
      tmp = tmp_0;
    } else {
      var tmp_1;
      if (!(multiplicand_0.zt_1 === -9223372036854775808n)) {
        tmp_1 = multiplyAndRound_0(Companion_getInstance_21(), multiplicand_0.zt_1, this.vt_1, productScale, mc);
      } else {
        tmp_1 = multiplyAndRound_1(Companion_getInstance_21(), ensureNotNull(this.vt_1), multiplicand_0.vt_1, productScale, mc);
      }
      tmp = tmp_1;
    }
    return tmp;
  }
  div(divisor) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var divisor_0 = divisor;
    if (divisor_0.signum === 0) {
      if (this.signum === 0) {
        throw ArithmeticException.cc('Division undefined');
      }
      throw ArithmeticException.cc('Division by zero');
    }
    var tmp = Companion_getInstance_21();
    var tmp0 = fromInt_0(this.wt_1);
    // Inline function 'kotlin.Long.minus' call
    var other = divisor_0.wt_1;
    var tmp$ret$3 = subtract_0(tmp0, fromInt_0(other));
    var preferredScale = saturateLong(tmp, tmp$ret$3);
    if (this.signum === 0) {
      return Companion_getInstance_21().wu(preferredScale);
    } else {
      var tmp_0 = this.precision;
      // Inline function 'kotlin.math.ceil' call
      var x = 10.0 * divisor_0.precision / 3.0;
      var tmp$ret$4 = Math.ceil(x);
      var tmp0_0 = add_0(numberToLong(tmp_0), numberToLong(tmp$ret$4));
      // Inline function 'kotlin.math.min' call
      var b = 2147483647n;
      var tmp$ret$5 = tmp0_0 <= b ? tmp0_0 : b;
      var mc = new MathContext(convertToInt(tmp$ret$5), RoundingMode_UNNECESSARY_getInstance());
      var quotient;
      try {
        quotient = this.divWithContext(divisor_0, mc);
      } catch ($p) {
        if ($p instanceof ArithmeticException) {
          var e = $p;
          throw ArithmeticException.cc('Non-terminating decimal expansion; no exact representable decimal result.');
        } else {
          throw $p;
        }
      }
      var quotientScale = ensureNotNull(quotient).scale;
      var tmp_1;
      if (preferredScale > quotientScale) {
        tmp_1 = quotient.setScaleInt(preferredScale, RoundingMode_UNNECESSARY_getInstance().value);
      } else {
        tmp_1 = quotient;
      }
      return tmp_1;
    }
  }
  divWithContext(divisor, mc) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var divisor_0 = divisor;
    var mcp = mc.precision;
    if (mcp === 0) {
      return this.div(divisor_0);
    }
    var dividend = this;
    var tmp0 = fromInt_0(dividend.wt_1);
    // Inline function 'kotlin.Long.minus' call
    var other = divisor_0.wt_1;
    var preferredScale = subtract_0(tmp0, fromInt_0(other));
    if (divisor_0.signum === 0) {
      if (dividend.signum === 0) {
        throw ArithmeticException.cc('Division undefined');
      }
      throw ArithmeticException.cc('Division by zero');
    }
    if (dividend.signum === 0) {
      return Companion_getInstance_21().wu(saturateLong(Companion_getInstance_21(), preferredScale));
    }
    var xscale = dividend.precision;
    var yscale = divisor_0.precision;
    var tmp;
    if (!(dividend.zt_1 === -9223372036854775808n)) {
      var tmp_0;
      if (!(divisor_0.zt_1 === -9223372036854775808n)) {
        tmp_0 = divide_0(Companion_getInstance_21(), dividend.zt_1, xscale, divisor_0.zt_1, yscale, preferredScale, mc);
      } else {
        tmp_0 = divide_2(Companion_getInstance_21(), dividend.zt_1, xscale, divisor_0.vt_1, yscale, preferredScale, mc);
      }
      tmp = tmp_0;
    } else {
      var tmp_1;
      if (!(divisor_0.zt_1 === -9223372036854775808n)) {
        tmp_1 = divide_1(Companion_getInstance_21(), dividend.vt_1, xscale, divisor_0.zt_1, yscale, preferredScale, mc);
      } else {
        tmp_1 = divide_3(Companion_getInstance_21(), dividend.vt_1, xscale, divisor_0.vt_1, yscale, preferredScale, mc);
      }
      tmp = tmp_1;
    }
    return tmp;
  }
  divideToIntegralValue(divisor) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var divisor_0 = divisor;
    var tmp = Companion_getInstance_21();
    var tmp0 = fromInt_0(this.wt_1);
    // Inline function 'kotlin.Long.minus' call
    var other = divisor_0.wt_1;
    var tmp$ret$3 = subtract_0(tmp0, fromInt_0(other));
    var preferredScale = saturateLong(tmp, tmp$ret$3);
    if (compareMagnitude(this, divisor_0) < 0) {
      return Companion_getInstance_21().wu(preferredScale);
    }
    if (this.signum === 0 && !(divisor_0.signum === 0)) {
      return this.setScaleInt(preferredScale, RoundingMode_UNNECESSARY_getInstance().value);
    }
    var tmp_0 = fromInt_0(this.precision);
    // Inline function 'kotlin.math.ceil' call
    var x = 10.0 * divisor_0.precision / 3.0;
    var tmp$ret$4 = Math.ceil(x);
    var tmp_1 = add_0(tmp_0, numberToLong(tmp$ret$4));
    var tmp0_0 = fromInt_0(this.scale);
    // Inline function 'kotlin.Long.minus' call
    var other_0 = divisor_0.scale;
    var tmp$ret$5 = subtract_0(tmp0_0, fromInt_0(other_0));
    // Inline function 'kotlin.Long.plus' call
    var this_0 = add_0(tmp_1, abs_1(tmp$ret$5));
    var tmp0_1 = add_0(this_0, fromInt_0(2));
    // Inline function 'kotlin.math.min' call
    var b = 2147483647n;
    var tmp$ret$7 = tmp0_1 <= b ? tmp0_1 : b;
    var maxDigits = convertToInt(tmp$ret$7);
    var quotient = this.divWithContext(divisor_0, new MathContext(maxDigits, RoundingMode_DOWN_getInstance()));
    if (ensureNotNull(quotient).wt_1 > 0) {
      quotient = quotient.setScaleRounding(0, RoundingMode_DOWN_getInstance());
      quotient = stripZerosToMatchScale(Companion_getInstance_21(), quotient.vt_1, quotient.zt_1, quotient.wt_1, preferredScale);
    }
    if (quotient.wt_1 < preferredScale) {
      quotient = quotient.setScaleInt(preferredScale, RoundingMode_UNNECESSARY_getInstance().value);
    }
    return quotient;
  }
  divideToIntegralValueWithContext(divisor, mc) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var divisor_0 = divisor;
    if (mc.precision === 0 || compareMagnitude(this, divisor_0) < 0) {
      return this.divideToIntegralValue(divisor_0);
    }
    var tmp = Companion_getInstance_21();
    var tmp0 = fromInt_0(this.wt_1);
    // Inline function 'kotlin.Long.minus' call
    var other = divisor_0.wt_1;
    var tmp$ret$3 = subtract_0(tmp0, fromInt_0(other));
    var preferredScale = saturateLong(tmp, tmp$ret$3);
    var result = this.divWithContext(divisor_0, new MathContext(mc.precision, RoundingMode_DOWN_getInstance()));
    if (ensureNotNull(result).scale < 0) {
      var product = result.times(divisor_0);
      if (compareMagnitude(this.minus(product), divisor_0) >= 0) {
        throw ArithmeticException.cc('Division impossible');
      }
    } else if (result.scale > 0) {
      result = result.setScaleRounding(0, RoundingMode_DOWN_getInstance());
    }
    var precisionDiff;
    if (preferredScale > result.scale) {
      precisionDiff = mc.precision - result.precision | 0;
      if (precisionDiff > 0) {
        var tmp_0 = result;
        var tmp_1 = result.scale;
        // Inline function 'kotlin.math.min' call
        var b = preferredScale - result.wt_1 | 0;
        var tmp$ret$4 = Math.min(precisionDiff, b);
        return tmp_0.setScale(tmp_1 + tmp$ret$4 | 0);
      }
    }
    return stripZerosToMatchScale(Companion_getInstance_21(), result.vt_1, result.zt_1, result.wt_1, preferredScale);
  }
  rem(divisor) {
    var divrem = this.divideAndRemainder(divisor);
    return divrem.second;
  }
  remWithContext(divisor, mc) {
    var divrem = this.divideAndRemainderWithContext(divisor, mc);
    return divrem.second;
  }
  divideAndRemainder(divisor) {
    var temp = this.divideToIntegralValue(divisor);
    return new Pair(temp, temp.times(divisor));
  }
  divideAndRemainderWithContext(divisor, mc) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var divisor_0 = divisor;
    if (mc.precision === 0) {
      return this.divideAndRemainder(divisor_0);
    }
    var lhs = this;
    var temp = lhs.divideToIntegralValueWithContext(divisor_0, mc);
    return new Pair(temp, lhs.minus(temp.times(divisor_0)));
  }
  rq(mc) {
    var signum = this.signum;
    if (signum === 1) {
      var preferredScale = this.scale / 2 | 0;
      var zeroWithFinalPreferredScale = Companion_getInstance_21().ofScaledLong(0n, preferredScale);
      var stripped = this.stripTrailingZeros();
      var strippedScale = stripped.scale;
      if (_get_isPowerOfTen__mg2oyo(stripped) && (strippedScale % 2 | 0) === 0) {
        var result = Companion_getInstance_21().ofScaledLong(1n, strippedScale / 2 | 0);
        if (!(result.scale === preferredScale)) {
          result = result.plusWithContext(zeroWithFinalPreferredScale, mc);
        }
        return result;
      }
      var scale = (stripped.scale - stripped.precision | 0) + 1 | 0;
      var tmp;
      if ((scale % 2 | 0) === 0) {
        tmp = scale;
      } else {
        tmp = scale - 1 | 0;
      }
      var scaleAdjust = tmp;
      var working = stripped.scaleByPowerOfTen(scaleAdjust);
      // Inline function 'kotlin.require' call
      // Inline function 'kotlin.require' call
      if (!(Companion_getInstance_21().ONE_TENTH.sq(working) <= 0 && working.sq(Companion_getInstance_21().TEN) < 0)) {
        var message = 'Failed requirement.';
        throw IllegalArgumentException.w(toString_1(message));
      }
      // Inline function 'kotlin.math.sqrt' call
      var x = working.toDouble();
      var tmp$ret$3 = Math.sqrt(x);
      var guess = CommonBigDecimal.ev(tmp$ret$3);
      var guessPrecision = 15;
      var originalPrecision = mc.precision;
      var targetPrecision;
      if (originalPrecision === 0) {
        targetPrecision = (stripped.precision / 2 | 0) + 1 | 0;
      } else {
        targetPrecision = originalPrecision;
      }
      var approx = guess;
      var workingPrecision = working.precision;
      do {
        var tmp0 = guessPrecision;
        // Inline function 'kotlin.math.max' call
        var b = targetPrecision + 2 | 0;
        // Inline function 'kotlin.math.max' call
        var a = Math.max(tmp0, b);
        var tmpPrecision = Math.max(a, workingPrecision);
        var mcTmp = new MathContext(tmpPrecision, RoundingMode_HALF_EVEN_getInstance());
        approx = Companion_getInstance_21().ONE_HALF.times(approx.plusWithContext(working.divWithContext(approx, mcTmp), mcTmp));
        guessPrecision = imul_0(guessPrecision, 2);
      }
       while (guessPrecision < (targetPrecision + 2 | 0));
      var result_0;
      var targetRm = mc.roundingMode;
      if (targetRm === RoundingMode_UNNECESSARY_getInstance() || originalPrecision === 0) {
        var tmpRm = targetRm === RoundingMode_UNNECESSARY_getInstance() ? RoundingMode_DOWN_getInstance() : targetRm;
        var mcTmp_0 = new MathContext(targetPrecision, tmpRm);
        result_0 = approx.scaleByPowerOfTen((-scaleAdjust | 0) / 2 | 0).round(mcTmp_0);
        if (!(this.minus(ensureNotNull(result_0).times(result_0)).sq(Companion_getInstance_21().ZERO) === 0)) {
          throw ArithmeticException.cc('Computed square root not exact.');
        }
      } else {
        result_0 = approx.scaleByPowerOfTen((-scaleAdjust | 0) / 2 | 0).round(mc);
      }
      if (!(ensureNotNull(result_0).scale === preferredScale)) {
        result_0 = result_0.stripTrailingZeros().plusWithContext(zeroWithFinalPreferredScale, new MathContext(originalPrecision, RoundingMode_UNNECESSARY_getInstance()));
      }
      // Inline function 'kotlin.require' call
      // Inline function 'kotlin.require' call
      if (!squareRootResultAssertions(this, result_0, mc)) {
        var message_0 = 'Failed requirement.';
        throw IllegalArgumentException.w(toString_1(message_0));
      }
      return result_0;
    } else {
      switch (signum) {
        case -1:
          throw ArithmeticException.cc('Attempted square root of negative CommonBigDecimal');
        case 0:
          return Companion_getInstance_21().ofScaledLong(0n, this.scale / 2 | 0);
        default:
          throw AssertionError.hc('Bad value from _signum');
      }
    }
  }
  pow(n) {
    if (n < 0 || n > 999999999) {
      throw ArithmeticException.cc('Invalid operation');
    }
    // Inline function 'kotlin.Long.times' call
    var this_0 = fromInt_0(this.wt_1);
    var tmp$ret$0 = multiply_0(this_0, fromInt_0(n));
    var newScale = checkScale_1(this, tmp$ret$0);
    return CommonBigDecimal.tu(inflated(this).pow(n), newScale);
  }
  powWithContext(n, mc) {
    if (mc.precision === 0) {
      return this.pow(n);
    }
    if (n < -999999999 || n > 999999999) {
      throw ArithmeticException.cc('Invalid operation');
    }
    if (n === 0) {
      return Companion_getInstance_21().ONE;
    }
    var lhs = this;
    var workmc = mc;
    var mag = abs_0(n);
    if (mc.precision > 0) {
      var elength = Companion_getInstance_21().du(fromInt_0(mag));
      if (elength > mc.precision) {
        throw ArithmeticException.cc('Invalid operation');
      }
      workmc = new MathContext((mc.precision + elength | 0) + 1 | 0, mc.roundingMode);
    }
    var acc = Companion_getInstance_21().ONE;
    var seenbit = false;
    var i = 1;
    $l$loop: while (true) {
      mag = mag + mag | 0;
      if (mag < 0) {
        seenbit = true;
        acc = acc.timesWithContext(lhs, workmc);
      }
      if (i === 31) {
        break $l$loop;
      }
      if (seenbit) {
        acc = acc.timesWithContext(acc, workmc);
      }
      i = i + 1 | 0;
    }
    if (n < 0) {
      acc = ensureNotNull(Companion_getInstance_21().ONE.divWithContext(acc, workmc));
    }
    return doRound(Companion_getInstance_21(), acc, mc);
  }
  mq() {
    return this.signum < 0 ? this.unaryMinus() : this;
  }
  absoluteValueWithContext(mc) {
    return this.signum < 0 ? this.unaryMinusWithContext(mc) : this.unaryPlusWithContext(mc);
  }
  unaryMinus() {
    var tmp;
    if (this.zt_1 === -9223372036854775808n) {
      tmp = CommonBigDecimal.eu(ensureNotNull(this.vt_1).unaryMinus(), -9223372036854775808n, this.wt_1, this.xt_1);
    } else {
      tmp = Companion_getInstance_21().ofScaledLongWithPrecision(negate_0(this.zt_1), this.wt_1, this.xt_1);
    }
    return tmp;
  }
  unaryMinusWithContext(mc) {
    return this.unaryMinus().unaryPlusWithContext(mc);
  }
  unaryPlus() {
    return this;
  }
  unaryPlusWithContext(mc) {
    return mc.precision === 0 ? this : doRound(Companion_getInstance_21(), this, mc);
  }
  nq() {
    var tmp;
    if (!(this.zt_1 === -9223372036854775808n)) {
      tmp = get_sign(this.zt_1);
    } else {
      tmp = ensureNotNull(this.vt_1).signum;
    }
    return tmp;
  }
  oq() {
    return this.wt_1;
  }
  pq() {
    var result = this.xt_1;
    if (result === 0) {
      var s = this.zt_1;
      if (!(s === -9223372036854775808n)) {
        result = Companion_getInstance_21().du(s);
      } else {
        result = bigDigitLength(Companion_getInstance_21(), ensureNotNull(this.vt_1));
      }
      this.xt_1 = result;
    }
    return result;
  }
  qq() {
    return inflated(this);
  }
  round(mc) {
    return this.unaryPlusWithContext(mc);
  }
  setScaleRounding(newScale, roundingMode) {
    return this.setScaleInt(newScale, roundingMode.value);
  }
  setScaleInt(newScale, roundingMode) {
    if (roundingMode < RoundingMode_UP_getInstance().value || roundingMode > RoundingMode_UNNECESSARY_getInstance().value) {
      throw IllegalArgumentException.w('Invalid rounding mode');
    }
    var oldScale = this.wt_1;
    if (newScale === oldScale) {
      return this;
    }
    if (this.signum === 0) {
      return Companion_getInstance_21().wu(newScale);
    }
    if (!(this.zt_1 === -9223372036854775808n)) {
      var rs = this.zt_1;
      if (newScale > oldScale) {
        // Inline function 'kotlin.Long.minus' call
        var this_0 = fromInt_0(newScale);
        var tmp$ret$0 = subtract_0(this_0, fromInt_0(oldScale));
        var raise = checkScale_1(this, tmp$ret$0);
        rs = longMultiplyPowerTen(Companion_getInstance_21(), rs, raise);
        if (!(rs === -9223372036854775808n)) {
          return Companion_getInstance_21().ofScaledLong(rs, newScale);
        }
        var rb = bigMultiplyPowerTen_1(this, raise);
        return CommonBigDecimal.eu(rb, -9223372036854775808n, newScale, this.xt_1 > 0 ? this.xt_1 + raise | 0 : 0);
      } else {
        // Inline function 'kotlin.Long.minus' call
        var this_1 = fromInt_0(oldScale);
        var tmp$ret$1 = subtract_0(this_1, fromInt_0(newScale));
        var drop = checkScale_1(this, tmp$ret$1);
        var tmp;
        if (drop < Companion_getInstance_21().ot_1.length) {
          tmp = divideAndRound(Companion_getInstance_21(), rs, Companion_getInstance_21().ot_1[drop], newScale, roundingMode, newScale);
        } else {
          tmp = divideAndRound_4(Companion_getInstance_21(), inflated(this), bigTenToThe(Companion_getInstance_21(), drop), newScale, roundingMode, newScale);
        }
        return tmp;
      }
    } else {
      if (newScale > oldScale) {
        // Inline function 'kotlin.Long.minus' call
        var this_2 = fromInt_0(newScale);
        var tmp$ret$2 = subtract_0(this_2, fromInt_0(oldScale));
        var raise_0 = checkScale_1(this, tmp$ret$2);
        var rb_0 = bigMultiplyPowerTen_0(Companion_getInstance_21(), this.vt_1, raise_0);
        return CommonBigDecimal.eu(ensureNotNull(rb_0), -9223372036854775808n, newScale, this.xt_1 > 0 ? this.xt_1 + raise_0 | 0 : 0);
      } else {
        // Inline function 'kotlin.Long.minus' call
        var this_3 = fromInt_0(oldScale);
        var tmp$ret$3 = subtract_0(this_3, fromInt_0(newScale));
        var drop_0 = checkScale_1(this, tmp$ret$3);
        var tmp_0;
        if (drop_0 < Companion_getInstance_21().ot_1.length) {
          tmp_0 = divideAndRound_2(Companion_getInstance_21(), ensureNotNull(this.vt_1), Companion_getInstance_21().ot_1[drop_0], newScale, roundingMode, newScale);
        } else {
          tmp_0 = divideAndRound_4(Companion_getInstance_21(), ensureNotNull(this.vt_1), bigTenToThe(Companion_getInstance_21(), drop_0), newScale, roundingMode, newScale);
        }
        return tmp_0;
      }
    }
  }
  setScale(newScale) {
    return this.setScaleInt(newScale, RoundingMode_UNNECESSARY_getInstance().value);
  }
  movePointLeft(n) {
    // Inline function 'kotlin.Long.plus' call
    var this_0 = fromInt_0(this.wt_1);
    var tmp$ret$0 = add_0(this_0, fromInt_0(n));
    var newScale = checkScale_1(this, tmp$ret$0);
    var num = CommonBigDecimal.eu(ensureNotNull(this.vt_1), this.zt_1, newScale, 0);
    return num.wt_1 < 0 ? num.setScaleInt(0, RoundingMode_UNNECESSARY_getInstance().value) : num;
  }
  movePointRight(n) {
    // Inline function 'kotlin.Long.minus' call
    var this_0 = fromInt_0(this.wt_1);
    var tmp$ret$0 = subtract_0(this_0, fromInt_0(n));
    var newScale = checkScale_1(this, tmp$ret$0);
    var num = CommonBigDecimal.eu(ensureNotNull(this.vt_1), this.zt_1, newScale, 0);
    return num.wt_1 < 0 ? num.setScaleInt(0, RoundingMode_UNNECESSARY_getInstance().value) : num;
  }
  scaleByPowerOfTen(n) {
    // Inline function 'kotlin.Long.minus' call
    var this_0 = fromInt_0(this.wt_1);
    var tmp$ret$0 = subtract_0(this_0, fromInt_0(n));
    return CommonBigDecimal.eu(this.vt_1, this.zt_1, checkScale_1(this, tmp$ret$0), this.xt_1);
  }
  stripTrailingZeros() {
    var tmp;
    if (this.zt_1 === 0n || (!(this.vt_1 == null) && this.vt_1.signum === 0)) {
      tmp = Companion_getInstance_21().ZERO;
    } else if (!(this.zt_1 === -9223372036854775808n)) {
      tmp = createAndStripZerosToMatchScale_0(Companion_getInstance_21(), this.zt_1, this.wt_1, -9223372036854775808n);
    } else {
      tmp = createAndStripZerosToMatchScale(Companion_getInstance_21(), ensureNotNull(this.vt_1), this.wt_1, -9223372036854775808n);
    }
    return tmp;
  }
  sq(other) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var other_0 = other;
    if (this.wt_1 === other_0.wt_1) {
      var xs = this.zt_1;
      var ys = other_0.zt_1;
      if (!(xs === -9223372036854775808n) && !(ys === -9223372036854775808n)) {
        var tmp;
        if (!(xs === ys)) {
          var tmp_0;
          if (xs > ys) {
            tmp_0 = 1;
          } else {
            tmp_0 = -1;
          }
          tmp = tmp_0;
        } else {
          tmp = 0;
        }
        return tmp;
      }
    }
    var xsign = this.signum;
    var ysign = other_0.signum;
    if (!(xsign === ysign)) {
      return xsign > ysign ? 1 : -1;
    }
    if (xsign === 0) {
      return 0;
    }
    var cmp = compareMagnitude(this, other_0);
    return xsign > 0 ? cmp : -cmp | 0;
  }
  d(other) {
    return this.sq((!(other == null) ? isInterface(other, BigDecimal) : false) ? other : THROW_CCE());
  }
  equals(other) {
    if (!(other instanceof CommonBigDecimal)) {
      return false;
    }
    var xDec = other;
    if (other === this) {
      return true;
    }
    if (!(this.wt_1 === xDec.wt_1)) {
      return false;
    }
    var s = this.zt_1;
    var xs = xDec.zt_1;
    if (!(s === -9223372036854775808n)) {
      if (xs === -9223372036854775808n) {
        xs = compactValFor(Companion_getInstance_21(), ensureNotNull(xDec.vt_1));
      }
      return xs === s;
    } else if (!(xs === -9223372036854775808n)) {
      return xs === compactValFor(Companion_getInstance_21(), ensureNotNull(this.vt_1));
    }
    return inflated(this).equals(inflated(xDec));
  }
  min(val) {
    return this.sq(val) <= 0 ? this : val;
  }
  max(val) {
    return this.sq(val) >= 0 ? this : val;
  }
  hashCode() {
    var tmp;
    if (!(this.zt_1 === -9223372036854775808n)) {
      var val2 = this.zt_1 < 0n ? negate_0(this.zt_1) : this.zt_1;
      var temp = convertToInt(add_0(numberToLong(imul_0(convertToInt(shiftRightUnsigned(val2, 32)), 31)), val2 & 4294967295n));
      tmp = imul_0(31, this.zt_1 < 0n ? -temp | 0 : temp) + this.wt_1 | 0;
    } else {
      tmp = imul_0(31, ensureNotNull(this.vt_1).hashCode()) + this.wt_1 | 0;
    }
    return tmp;
  }
  toString() {
    var sc = this.yt_1;
    if (sc == null) {
      sc = layoutChars(this, true);
      this.yt_1 = sc;
    }
    return sc;
  }
  toEngineeringString() {
    return layoutChars(this, false);
  }
  toPlainString() {
    if (this.wt_1 === 0) {
      var tmp;
      if (!(this.zt_1 === -9223372036854775808n)) {
        tmp = this.zt_1.toString();
      } else {
        tmp = ensureNotNull(this.vt_1).toString();
      }
      return tmp;
    }
    if (this.wt_1 < 0) {
      if (this.signum === 0) {
        return '0';
      }
      var trailingZeros = checkScaleNonZero(Companion_getInstance_21(), negate_0(fromInt_0(this.wt_1)));
      var buf;
      if (!(this.zt_1 === -9223372036854775808n)) {
        buf = StringBuilder.ua(20 + trailingZeros | 0);
        buf.qd(this.zt_1);
      } else {
        var str = ensureNotNull(this.vt_1).toString();
        buf = StringBuilder.ua(str.length + trailingZeros | 0);
        buf.qa(str);
      }
      var inductionVariable = 0;
      if (inductionVariable < trailingZeros)
        do {
          var i = inductionVariable;
          inductionVariable = inductionVariable + 1 | 0;
          buf.ra(_Char___init__impl__6a9atx(48));
        }
         while (inductionVariable < trailingZeros);
      return buf.toString();
    }
    var str_0;
    if (!(this.zt_1 === -9223372036854775808n)) {
      // Inline function 'kotlin.math.absoluteValue' call
      var this_0 = this.zt_1;
      str_0 = abs_1(this_0).toString();
    } else {
      str_0 = ensureNotNull(this.vt_1).absoluteValue.toString();
    }
    return getValueString(this, this.signum, str_0, this.wt_1);
  }
  toBigInteger() {
    return inflated(this.setScaleInt(0, RoundingMode_DOWN_getInstance().value));
  }
  toBigIntegerExact() {
    return inflated(this.setScaleInt(0, RoundingMode_UNNECESSARY_getInstance().value));
  }
  toLong() {
    var tmp;
    if (!(this.zt_1 === -9223372036854775808n) && this.wt_1 === 0) {
      tmp = this.zt_1;
    } else {
      tmp = this.toBigInteger().toLong();
    }
    return tmp;
  }
  toLongExact() {
    if (!(this.zt_1 === -9223372036854775808n) && this.wt_1 === 0) {
      return this.zt_1;
    }
    if ((this.precision - this.wt_1 | 0) > 19) {
      throw ArithmeticException.cc('Overflow');
    }
    if (this.signum === 0) {
      return 0n;
    }
    if ((this.precision - this.wt_1 | 0) <= 0) {
      throw ArithmeticException.cc('Rounding necessary');
    }
    var num = this.setScaleInt(0, RoundingMode_UNNECESSARY_getInstance().value);
    if (num.precision >= 19) {
      LongOverflow_getInstance().zu(num);
    }
    return inflated(num).toLong();
  }
  toInt() {
    var tmp;
    if (!(this.zt_1 === -9223372036854775808n) && this.wt_1 === 0) {
      tmp = convertToInt(this.zt_1);
    } else {
      tmp = this.toBigInteger().toInt();
    }
    return tmp;
  }
  toByte() {
    return toByte(this.toInt());
  }
  toChar() {
    return numberToChar(this.toInt());
  }
  toShort() {
    return toShort(this.toInt());
  }
  toIntExact() {
    var num = this.toLongExact();
    if (!(fromInt_0(convertToInt(num)) === num)) {
      throw ArithmeticException.cc('Overflow');
    }
    return convertToInt(num);
  }
  toShortExact() {
    var num = this.toLongExact();
    if (!(fromInt_0(convertToShort(num)) === num)) {
      throw ArithmeticException.cc('Overflow');
    }
    return convertToShort(num);
  }
  toByteExact() {
    var num = this.toLongExact();
    if (!(fromInt_0(convertToByte(num)) === num)) {
      throw ArithmeticException.cc('Overflow');
    }
    return convertToByte(num);
  }
  toFloat() {
    if (!(this.zt_1 === -9223372036854775808n)) {
      if (this.wt_1 === 0) {
        return toNumber_0(this.zt_1);
      } else {
        if (abs_1(this.zt_1) < 4194304n) {
          if (this.wt_1 > 0 && this.wt_1 < Companion_getInstance_21().nt_1.length) {
            return toNumber_0(this.zt_1) / Companion_getInstance_21().nt_1[this.wt_1];
          } else if (this.wt_1 < 0 && this.wt_1 > (-Companion_getInstance_21().nt_1.length | 0)) {
            return toNumber_0(this.zt_1) * Companion_getInstance_21().nt_1[-this.wt_1 | 0];
          }
        }
      }
    }
    // Inline function 'kotlin.text.toFloat' call
    var this_0 = this.toString();
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    return toDouble(this_0);
  }
  toDouble() {
    if (!(this.zt_1 === -9223372036854775808n)) {
      if (this.wt_1 === 0) {
        return toNumber_0(this.zt_1);
      } else {
        if (abs_1(this.zt_1) < 4503599627370496n) {
          if (this.wt_1 > 0 && this.wt_1 < Companion_getInstance_21().mt_1.length) {
            return toNumber_0(this.zt_1) / Companion_getInstance_21().mt_1[this.wt_1];
          } else if (this.wt_1 < 0 && this.wt_1 > (-Companion_getInstance_21().mt_1.length | 0)) {
            return toNumber_0(this.zt_1) * Companion_getInstance_21().mt_1[-this.wt_1 | 0];
          }
        }
      }
    }
    return toDouble(this.toString());
  }
  ulp() {
    return Companion_getInstance_21().ofScaledLongWithPrecision(1n, this.scale, 1);
  }
  get absoluteValue() {
    return this.mq();
  }
  get signum() {
    return this.nq();
  }
  get scale() {
    return this.oq();
  }
  get precision() {
    return this.pq();
  }
  get unscaledValue() {
    return this.qq();
  }
}
class Companion_22 {
  constructor() {
    Companion_instance_22 = this;
    this.ds_1 = 4294967295n;
    this.es_1 = 67108864;
    this.fs_1 = 500000000;
    this.gs_1 = 80;
    this.hs_1 = 240;
    this.is_1 = 128;
    this.js_1 = 216;
    this.ks_1 = 80;
    this.ls_1 = 40;
    this.ms_1 = 20;
    this.ns_1 = 20;
    this.os_1 = 512;
    var tmp = this;
    // Inline function 'kotlin.longArrayOf' call
    tmp.ps_1 = new BigInt64Array([0n, 0n, 1024n, 1624n, 2048n, 2378n, 2648n, 2875n, 3072n, 3247n, 3402n, 3543n, 3672n, 3790n, 3899n, 4001n, 4096n, 4186n, 4271n, 4350n, 4426n, 4498n, 4567n, 4633n, 4696n, 4756n, 4814n, 4870n, 4923n, 4975n, 5025n, 5074n, 5120n, 5166n, 5210n, 5253n, 5295n]);
    this.qs_1 = 95;
    this.rs_1 = 100;
    var tmp_0 = this;
    // Inline function 'kotlin.Long.times' call
    // Inline function 'kotlin.Long.times' call
    var this_0 = multiply_0(3n, fromInt_0(5));
    // Inline function 'kotlin.Long.times' call
    var this_1 = multiply_0(this_0, fromInt_0(7));
    // Inline function 'kotlin.Long.times' call
    var this_2 = multiply_0(this_1, fromInt_0(11));
    // Inline function 'kotlin.Long.times' call
    var this_3 = multiply_0(this_2, fromInt_0(13));
    // Inline function 'kotlin.Long.times' call
    var this_4 = multiply_0(this_3, fromInt_0(17));
    // Inline function 'kotlin.Long.times' call
    var this_5 = multiply_0(this_4, fromInt_0(19));
    // Inline function 'kotlin.Long.times' call
    var this_6 = multiply_0(this_5, fromInt_0(23));
    // Inline function 'kotlin.Long.times' call
    var this_7 = multiply_0(this_6, fromInt_0(29));
    // Inline function 'kotlin.Long.times' call
    var this_8 = multiply_0(this_7, fromInt_0(31));
    // Inline function 'kotlin.Long.times' call
    var this_9 = multiply_0(this_8, fromInt_0(37));
    var tmp$ret$11 = multiply_0(this_9, fromInt_0(41));
    tmp_0.ss_1 = this.ofLong(tmp$ret$11);
    this.ts_1 = 16;
    var tmp_1 = this;
    // Inline function 'kotlin.arrayOfNulls' call
    var size = this.ts_1 + 1 | 0;
    tmp_1.us_1 = Array(size);
    var tmp_2 = this;
    // Inline function 'kotlin.arrayOfNulls' call
    var size_0 = this.ts_1 + 1 | 0;
    tmp_2.vs_1 = Array(size_0);
    var tmp_3 = this;
    // Inline function 'kotlin.arrayOfNulls' call
    tmp_3.ws_1 = Array(0);
    var tmp_4 = this;
    // Inline function 'kotlin.math.ln' call
    tmp_4.ys_1 = Math.log(2.0);
    var inductionVariable = 1;
    var last = this.ts_1;
    if (inductionVariable <= last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        var magnitude = new Int32Array(1);
        magnitude[0] = i;
        this.us_1[i] = CommonBigInteger.ov(magnitude, 1);
        this.vs_1[i] = CommonBigInteger.ov(magnitude, -1);
      }
       while (!(i === last));
    var tmp_5 = this;
    // Inline function 'kotlin.arrayOfNulls' call
    tmp_5.ws_1 = Array(37);
    this.xs_1 = new Float64Array(37);
    var inductionVariable_0 = 2;
    if (inductionVariable_0 <= 36)
      do {
        var i_0 = inductionVariable_0;
        inductionVariable_0 = inductionVariable_0 + 1 | 0;
        var tmp_6 = this.ws_1;
        // Inline function 'kotlin.arrayOf' call
        // Inline function 'kotlin.js.unsafeCast' call
        // Inline function 'kotlin.js.asDynamic' call
        tmp_6[i_0] = [this.ofLong(fromInt_0(i_0))];
        // Inline function 'kotlin.math.ln' call
        var tmp$ret$20 = Math.log(i_0);
        this.xs_1[i_0] = tmp$ret$20;
      }
       while (inductionVariable_0 <= 36);
    this.ZERO = CommonBigInteger.ov(new Int32Array(0), 0);
    this.ONE = this.of(1);
    this.TWO = this.of(2);
    this.NEGATIVE_ONE = this.of(-1);
    this.TEN = this.of(10);
    var tmp_7 = this;
    // Inline function 'kotlin.intArrayOf' call
    tmp_7.zs_1 = new Int32Array([7, 25, 81, 241, 673, 1793, 2147483647]);
    var tmp_8 = this;
    // Inline function 'kotlin.arrayOfNulls' call
    tmp_8.at_1 = Array(64);
    this.at_1[63] = '000000000000000000000000000000000000000000000000000000000000000';
    var inductionVariable_1 = 0;
    if (inductionVariable_1 <= 62)
      do {
        var i_1 = inductionVariable_1;
        inductionVariable_1 = inductionVariable_1 + 1 | 0;
        this.at_1[i_1] = substring(ensureNotNull(this.at_1[63]), 0, i_1);
      }
       while (inductionVariable_1 <= 62);
    var tmp_9 = this;
    // Inline function 'kotlin.intArrayOf' call
    tmp_9.bt_1 = new Int32Array([0, 0, 62, 39, 31, 27, 24, 22, 20, 19, 18, 18, 17, 17, 16, 16, 15, 15, 15, 14, 14, 14, 14, 13, 13, 13, 13, 13, 13, 12, 12, 12, 12, 12, 12, 12, 12]);
    var tmp_10 = this;
    // Inline function 'kotlin.arrayOf' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    tmp_10.ct_1 = [null, null, this.ofLong(4611686018427387904n), this.ofLong(4052555153018976267n), this.ofLong(4611686018427387904n), this.ofLong(7450580596923828125n), this.ofLong(4738381338321616896n), this.ofLong(3909821048582988049n), this.ofLong(1152921504606846976n), this.ofLong(1350851717672992089n), this.ofLong(1000000000000000000n), this.ofLong(5559917313492231481n), this.ofLong(2218611106740436992n), this.ofLong(8650415919381337933n), this.ofLong(2177953337809371136n), this.ofLong(6568408355712890625n), this.ofLong(1152921504606846976n), this.ofLong(2862423051509815793n), this.ofLong(6746640616477458432n), this.ofLong(799006685782884121n), this.ofLong(1638400000000000000n), this.ofLong(3243919932521508681n), this.ofLong(6221821273427820544n), this.ofLong(504036361936467383n), this.ofLong(876488338465357824n), this.ofLong(1490116119384765625n), this.ofLong(2481152873203736576n), this.ofLong(4052555153018976267n), this.ofLong(6502111422497947648n), this.ofLong(353814783205469041n), this.ofLong(531441000000000000n), this.ofLong(787662783788549761n), this.ofLong(1152921504606846976n), this.ofLong(1667889514952984961n), this.ofLong(2386420683693101056n), this.ofLong(3379220508056640625n), this.ofLong(4738381338321616896n)];
    var tmp_11 = this;
    // Inline function 'kotlin.intArrayOf' call
    tmp_11.dt_1 = new Int32Array([0, 0, 30, 19, 15, 13, 11, 11, 10, 9, 9, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5]);
    var tmp_12 = this;
    // Inline function 'kotlin.intArrayOf' call
    tmp_12.et_1 = new Int32Array([0, 0, 1073741824, 1162261467, 1073741824, 1220703125, 362797056, 1977326743, 1073741824, 387420489, 1000000000, 214358881, 429981696, 815730721, 1475789056, 170859375, 268435456, 410338673, 612220032, 893871739, 1280000000, 1801088541, 113379904, 148035889, 191102976, 244140625, 308915776, 387420489, 481890304, 594823321, 729000000, 887503681, 1073741824, 1291467969, 1544804416, 1838265625, 60466176]);
  }
  probablePrime(bitLength, rnd) {
    if (bitLength < 2) {
      throw ArithmeticException.cc('bitLength < 2');
    }
    var tmp;
    if (bitLength < 95) {
      tmp = smallPrime(this, bitLength, 100, rnd);
    } else {
      tmp = largePrime(this, bitLength, 100, rnd);
    }
    return tmp;
  }
  ofLong(other) {
    if (other === 0n) {
      return this.ZERO;
    }
    // Inline function 'kotlin.ranges.contains' call
    var this_0 = numberRangeToNumber(1, this.ts_1);
    if (contains_1(isInterface(this_0, ClosedRange) ? this_0 : THROW_CCE(), other)) {
      var tmp0_elvis_lhs = this.us_1[convertToInt(other)];
      var tmp;
      if (tmp0_elvis_lhs == null) {
        throw IllegalStateException.gb();
      } else {
        tmp = tmp0_elvis_lhs;
      }
      return tmp;
    } else {
      if (other < 0n && other >= fromInt_0(-this.ts_1 | 0)) {
        var tmp1_elvis_lhs = this.vs_1[convertToInt(negate_0(other))];
        var tmp_0;
        if (tmp1_elvis_lhs == null) {
          throw IllegalStateException.gb();
        } else {
          tmp_0 = tmp1_elvis_lhs;
        }
        return tmp_0;
      }
    }
    return CommonBigInteger.yv(other);
  }
  of(value) {
    return this.ofLong(fromInt_0(value));
  }
  parse(value) {
    var radixed = getRadix(value);
    return CommonBigInteger.zv(radixed.second, radixed.first);
  }
  parseWithRadix(value, radix) {
    return CommonBigInteger.zv(value, radix);
  }
  ofIntArray(other) {
    return other[0] > 0 ? CommonBigInteger.ov(other, 1) : CommonBigInteger.aw(other);
  }
  aq() {
    return this.ZERO;
  }
  bq() {
    return this.ONE;
  }
  cq() {
    return this.TWO;
  }
  yq() {
    return this.NEGATIVE_ONE;
  }
  dq() {
    return this.TEN;
  }
  qv(n) {
    return 32 - numberOfLeadingZeros(n) | 0;
  }
}
class CommonBigInteger {
  static aw(other) {
    Companion_getInstance_22();
    var $this = createThis(this);
    init_com_macrofocus_common_math_big_CommonBigInteger($this);
    // Inline function 'kotlin.collections.isEmpty' call
    if (other.length === 0) {
      throw NumberFormatException.xb('Zero length BigInteger');
    }
    if (other[0] < 0) {
      $this.vr_1 = makePositive(Companion_getInstance_22(), other);
      $this.ur_1 = -1;
    } else {
      $this.vr_1 = trustedStripLeadingZeroInts(Companion_getInstance_22(), other);
      var tmp = $this;
      var tmp_0;
      // Inline function 'kotlin.collections.isEmpty' call
      if ($this.vr_1.length === 0) {
        tmp_0 = 0;
      } else {
        tmp_0 = 1;
      }
      tmp.ur_1 = tmp_0;
    }
    if ($this.vr_1.length >= 67108864) {
      checkRange($this);
    }
    return $this;
  }
  static bw(signum, magnitude, off, len) {
    Companion_getInstance_22();
    off = off === VOID ? 0 : off;
    len = len === VOID ? magnitude.length : len;
    var $this = createThis(this);
    init_com_macrofocus_common_math_big_CommonBigInteger($this);
    if (signum < -1 || signum > 1) {
      throw NumberFormatException.xb('Invalid _signum value');
    } else if (off < 0 || len < 0 || (len > 0 && (off >= magnitude.length || len > (magnitude.length - off | 0)))) {
      throw IndexOutOfBoundsException.qb();
    }
    $this.vr_1 = stripLeadingZeroBytes(Companion_getInstance_22(), magnitude, off, len);
    // Inline function 'kotlin.collections.isEmpty' call
    if ($this.vr_1.length === 0) {
      $this.ur_1 = 0;
    } else {
      if (signum === 0) {
        throw NumberFormatException.xb('_signum-magnitude mismatch');
      }
      $this.ur_1 = signum;
    }
    if ($this.vr_1.length >= 67108864) {
      checkRange($this);
    }
    return $this;
  }
  static xv(signum, magnitude) {
    Companion_getInstance_22();
    var $this = createThis(this);
    init_com_macrofocus_common_math_big_CommonBigInteger($this);
    $this.vr_1 = stripLeadingZeroInts(Companion_getInstance_22(), magnitude);
    if (signum < -1 || signum > 1) {
      throw NumberFormatException.xb('Invalid _signum value');
    }
    // Inline function 'kotlin.collections.isEmpty' call
    if ($this.vr_1.length === 0) {
      $this.ur_1 = 0;
    } else {
      if (signum === 0) {
        throw NumberFormatException.xb('_signum-magnitude mismatch');
      }
      $this.ur_1 = signum;
    }
    if ($this.vr_1.length >= 67108864) {
      checkRange($this);
    }
    return $this;
  }
  static zv(other, radix) {
    Companion_getInstance_22();
    radix = radix === VOID ? 10 : radix;
    var $this = createThis(this);
    init_com_macrofocus_common_math_big_CommonBigInteger($this);
    var cursor = 0;
    var numDigits;
    var len = other.length;
    if (radix < 2 || radix > 36) {
      throw NumberFormatException.xb('Radix out of range');
    }
    if (len === 0) {
      throw NumberFormatException.xb('Zero length BigInteger');
    }
    var sign = 1;
    var index1 = lastIndexOf_0(other, _Char___init__impl__6a9atx(45));
    var index2 = lastIndexOf_0(other, _Char___init__impl__6a9atx(43));
    if (index1 >= 0) {
      if (!(index1 === 0) || index2 >= 0) {
        throw NumberFormatException.xb('Illegal embedded sign character');
      }
      sign = -1;
      cursor = 1;
    } else if (index2 >= 0) {
      if (!(index2 === 0)) {
        throw NumberFormatException.xb('Illegal embedded sign character');
      }
      cursor = 1;
    }
    if (cursor === len) {
      throw NumberFormatException.xb('Zero length BigInteger');
    }
    while (cursor < len && toDigit(charCodeAt(other, cursor), radix) === 0) {
      cursor = cursor + 1 | 0;
    }
    if (cursor === len) {
      $this.ur_1 = 0;
      $this.vr_1 = Companion_getInstance_22().ZERO.vr_1;
      return $this;
    }
    numDigits = len - cursor | 0;
    $this.ur_1 = sign;
    // Inline function 'kotlin.Long.plus' call
    var this_0 = shiftRightUnsigned(multiply_0(numberToLong(numDigits), Companion_getInstance_22().ps_1[radix]), 10);
    var numBits = add_0(this_0, fromInt_0(1));
    // Inline function 'kotlin.Long.plus' call
    if (add_0(numBits, fromInt_0(31)) >= 4294967296n) {
      reportOverflow(Companion_getInstance_22());
    }
    // Inline function 'kotlin.Long.plus' call
    var tmp$ret$2 = add_0(numBits, fromInt_0(31));
    var numWords = convertToInt(tmp$ret$2) >>> 5 | 0;
    var magnitude = new Int32Array(numWords);
    var firstGroupLen = numDigits % Companion_getInstance_22().dt_1[radix] | 0;
    if (firstGroupLen === 0) {
      firstGroupLen = Companion_getInstance_22().dt_1[radix];
    }
    var group = substring(other, cursor, cursor + firstGroupLen | 0);
    cursor = cursor + firstGroupLen | 0;
    magnitude[numWords - 1 | 0] = toInt(group, radix);
    if (magnitude[numWords - 1 | 0] < 0) {
      throw NumberFormatException.xb('Illegal digit');
    }
    var superRadix = Companion_getInstance_22().et_1[radix];
    var groupVal = 0;
    while (cursor < len) {
      group = substring(other, cursor, cursor + Companion_getInstance_22().dt_1[radix] | 0);
      cursor = cursor + Companion_getInstance_22().dt_1[radix] | 0;
      groupVal = toInt(group, radix);
      if (groupVal < 0) {
        throw NumberFormatException.xb('Illegal digit');
      }
      destructiveMulAdd(Companion_getInstance_22(), magnitude, superRadix, groupVal);
    }
    $this.vr_1 = trustedStripLeadingZeroInts(Companion_getInstance_22(), magnitude);
    if ($this.vr_1.length >= 67108864) {
      checkRange($this);
    }
    return $this;
  }
  static mv(other, sign, len) {
    Companion_getInstance_22();
    var $this = createThis(this);
    init_com_macrofocus_common_math_big_CommonBigInteger($this);
    var cursor = 0;
    var numDigits;
    while (cursor < len && toDigit(other[cursor], 10) === 0) {
      cursor = cursor + 1 | 0;
    }
    if (cursor === len) {
      $this.ur_1 = 0;
      $this.vr_1 = Companion_getInstance_22().ZERO.vr_1;
      return $this;
    }
    numDigits = len - cursor | 0;
    $this.ur_1 = sign;
    var numWords;
    if (len < 10) {
      numWords = 1;
    } else {
      // Inline function 'kotlin.Long.plus' call
      var this_0 = shiftRightUnsigned(multiply_0(numberToLong(numDigits), Companion_getInstance_22().ps_1[10]), 10);
      var numBits = add_0(this_0, fromInt_0(1));
      // Inline function 'kotlin.Long.plus' call
      if (add_0(numBits, fromInt_0(31)) >= 4294967296n) {
        reportOverflow(Companion_getInstance_22());
      }
      // Inline function 'kotlin.Long.plus' call
      var tmp$ret$2 = add_0(numBits, fromInt_0(31));
      numWords = convertToInt(tmp$ret$2) >>> 5 | 0;
    }
    var magnitude = new Int32Array(numWords);
    var firstGroupLen = numDigits % Companion_getInstance_22().dt_1[10] | 0;
    if (firstGroupLen === 0) {
      firstGroupLen = Companion_getInstance_22().dt_1[10];
    }
    magnitude[numWords - 1 | 0] = parseInt($this, other, cursor, cursor + firstGroupLen | 0);
    cursor = cursor + firstGroupLen | 0;
    while (cursor < len) {
      var groupVal = parseInt($this, other, cursor, cursor + Companion_getInstance_22().dt_1[10] | 0);
      cursor = cursor + Companion_getInstance_22().dt_1[10] | 0;
      destructiveMulAdd(Companion_getInstance_22(), magnitude, Companion_getInstance_22().et_1[10], groupVal);
    }
    $this.vr_1 = trustedStripLeadingZeroInts(Companion_getInstance_22(), magnitude);
    if ($this.vr_1.length >= 67108864) {
      checkRange($this);
    }
    return $this;
  }
  static pv(numBits, rnd) {
    Companion_getInstance_22();
    return this.bw(1, randomBits(Companion_getInstance_22(), numBits, rnd));
  }
  nextProbablePrime() {
    if (this.ur_1 < 0) {
      throw ArithmeticException.cc('start < 0: ' + this.toString());
    }
    if (this.ur_1 === 0 || this.equals(Companion_getInstance_22().ONE)) {
      return Companion_getInstance_22().TWO;
    }
    var result = this.plus(Companion_getInstance_22().ONE);
    if (result.bitLength < 95) {
      if (!result.testBit(0)) {
        result = result.plus(Companion_getInstance_22().ONE);
      }
      $l$loop: while (true) {
        if (result.bitLength > 6) {
          var r = result.reminder(Companion_getInstance_22().ss_1).toLong();
          var tmp;
          var tmp_0;
          var tmp_1;
          var tmp_2;
          var tmp_3;
          var tmp_4;
          var tmp_5;
          var tmp_6;
          var tmp_7;
          var tmp_8;
          var tmp_9;
          // Inline function 'kotlin.Long.rem' call
          if (modulo(r, fromInt_0(3)) === 0n) {
            tmp_9 = true;
          } else {
            // Inline function 'kotlin.Long.rem' call
            tmp_9 = modulo(r, fromInt_0(5)) === 0n;
          }
          if (tmp_9) {
            tmp_8 = true;
          } else {
            // Inline function 'kotlin.Long.rem' call
            tmp_8 = modulo(r, fromInt_0(7)) === 0n;
          }
          if (tmp_8) {
            tmp_7 = true;
          } else {
            // Inline function 'kotlin.Long.rem' call
            tmp_7 = modulo(r, fromInt_0(11)) === 0n;
          }
          if (tmp_7) {
            tmp_6 = true;
          } else {
            // Inline function 'kotlin.Long.rem' call
            tmp_6 = modulo(r, fromInt_0(13)) === 0n;
          }
          if (tmp_6) {
            tmp_5 = true;
          } else {
            // Inline function 'kotlin.Long.rem' call
            tmp_5 = modulo(r, fromInt_0(17)) === 0n;
          }
          if (tmp_5) {
            tmp_4 = true;
          } else {
            // Inline function 'kotlin.Long.rem' call
            tmp_4 = modulo(r, fromInt_0(19)) === 0n;
          }
          if (tmp_4) {
            tmp_3 = true;
          } else {
            // Inline function 'kotlin.Long.rem' call
            tmp_3 = modulo(r, fromInt_0(23)) === 0n;
          }
          if (tmp_3) {
            tmp_2 = true;
          } else {
            // Inline function 'kotlin.Long.rem' call
            tmp_2 = modulo(r, fromInt_0(29)) === 0n;
          }
          if (tmp_2) {
            tmp_1 = true;
          } else {
            // Inline function 'kotlin.Long.rem' call
            tmp_1 = modulo(r, fromInt_0(31)) === 0n;
          }
          if (tmp_1) {
            tmp_0 = true;
          } else {
            // Inline function 'kotlin.Long.rem' call
            tmp_0 = modulo(r, fromInt_0(37)) === 0n;
          }
          if (tmp_0) {
            tmp = true;
          } else {
            // Inline function 'kotlin.Long.rem' call
            tmp = modulo(r, fromInt_0(41)) === 0n;
          }
          if (tmp) {
            result = result.plus(Companion_getInstance_22().TWO);
            continue $l$loop;
          }
        }
        if (result.bitLength < 4) {
          return result;
        }
        if (result.as(100, null)) {
          return result;
        }
        result = result.plus(Companion_getInstance_22().TWO);
      }
    }
    if (result.testBit(0)) {
      result = result.minus(Companion_getInstance_22().ONE);
    }
    var searchLen = getPrimeSearchLen(Companion_getInstance_22(), result.bitLength);
    while (true) {
      var searchSieve = BitSieve.lr(result, searchLen);
      var tmp_10 = result;
      ensureNotNull(null);
      var candidate = searchSieve.tr(tmp_10, 100, throwKotlinNothingValueException());
      if (!(candidate == null)) {
        return candidate;
      }
      result = result.plus(Companion_getInstance_22().ofLong(fromInt_0(imul_0(2, searchLen))));
    }
  }
  as(certainty, random) {
    var rounds = 0;
    // Inline function 'kotlin.math.max' call
    var b = 2147483646;
    var n = (Math.max(certainty, b) + 1 | 0) / 2 | 0;
    var sizeInBits = this.bitLength;
    if (sizeInBits < 100) {
      rounds = 50;
      rounds = n < rounds ? n : rounds;
      return passesMillerRabin(this, rounds, random);
    }
    if (sizeInBits < 256) {
      rounds = 27;
    } else if (sizeInBits < 512) {
      rounds = 15;
    } else if (sizeInBits < 768) {
      rounds = 8;
    } else if (sizeInBits < 1024) {
      rounds = 4;
    } else {
      rounds = 2;
    }
    rounds = n < rounds ? n : rounds;
    return passesMillerRabin(this, rounds, random) && passesLucasLehmer(this);
  }
  static ov(magnitude, signum) {
    Companion_getInstance_22();
    var $this = createThis(this);
    init_com_macrofocus_common_math_big_CommonBigInteger($this);
    var tmp = $this;
    var tmp_0;
    // Inline function 'kotlin.collections.isEmpty' call
    if (magnitude.length === 0) {
      tmp_0 = 0;
    } else {
      tmp_0 = signum;
    }
    tmp.ur_1 = tmp_0;
    $this.vr_1 = magnitude;
    if ($this.vr_1.length >= 67108864) {
      checkRange($this);
    }
    return $this;
  }
  static yv(other) {
    Companion_getInstance_22();
    var $this = createThis(this);
    init_com_macrofocus_common_math_big_CommonBigInteger($this);
    var other_0 = other;
    if (other_0 < 0n) {
      other_0 = negate_0(other_0);
      $this.ur_1 = -1;
    } else {
      $this.ur_1 = 1;
    }
    var highWord = convertToInt(shiftRightUnsigned(other_0, 32));
    if (highWord === 0) {
      $this.vr_1 = new Int32Array(1);
      $this.vr_1[0] = convertToInt(other_0);
    } else {
      $this.vr_1 = new Int32Array(2);
      $this.vr_1[0] = highWord;
      $this.vr_1[1] = convertToInt(other_0);
    }
    return $this;
  }
  plus(other) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var other_0 = other;
    if (other_0.signum === 0) {
      return this;
    }
    if (this.ur_1 === 0) {
      return other_0;
    }
    if (other_0.ur_1 === this.ur_1) {
      return CommonBigInteger.ov(sum_5(Companion_getInstance_22(), this.vr_1, other_0.vr_1), this.ur_1);
    }
    var cmp = this.cu(other_0);
    if (cmp === 0) {
      return Companion_getInstance_22().ZERO;
    }
    var tmp;
    if (cmp > 0) {
      tmp = subtract_3(Companion_getInstance_22(), this.vr_1, other_0.vr_1);
    } else {
      tmp = subtract_3(Companion_getInstance_22(), other_0.vr_1, this.vr_1);
    }
    var resultMag = tmp;
    resultMag = trustedStripLeadingZeroInts(Companion_getInstance_22(), resultMag);
    return CommonBigInteger.ov(resultMag, cmp === this.ur_1 ? 1 : -1);
  }
  su(other) {
    if (other === 0n) {
      return this;
    }
    if (this.ur_1 === 0) {
      return Companion_getInstance_22().ofLong(other);
    }
    if (get_sign(other) === this.ur_1) {
      var tmp = Companion_getInstance_22();
      // Inline function 'kotlin.math.absoluteValue' call
      var tmp$ret$0 = abs_1(other);
      return CommonBigInteger.ov(sum_4(tmp, this.vr_1, tmp$ret$0), this.ur_1);
    }
    var cmp = compareMagnitude_0(this, other);
    if (cmp === 0) {
      return Companion_getInstance_22().ZERO;
    }
    var tmp_0;
    if (cmp > 0) {
      var tmp_1 = Companion_getInstance_22();
      // Inline function 'kotlin.math.absoluteValue' call
      var tmp$ret$1 = abs_1(other);
      tmp_0 = subtract_2(tmp_1, this.vr_1, tmp$ret$1);
    } else {
      var tmp_2 = Companion_getInstance_22();
      // Inline function 'kotlin.math.absoluteValue' call
      var tmp$ret$2 = abs_1(other);
      tmp_0 = subtract_1(tmp_2, tmp$ret$2, this.vr_1);
    }
    var resultMag = tmp_0;
    resultMag = trustedStripLeadingZeroInts(Companion_getInstance_22(), resultMag);
    return CommonBigInteger.ov(resultMag, cmp === this.ur_1 ? 1 : -1);
  }
  minus(other) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var other_0 = other;
    if (other_0.ur_1 === 0) {
      return this;
    }
    if (this.ur_1 === 0) {
      return other_0.unaryMinus();
    }
    if (!(other_0.ur_1 === this.ur_1)) {
      return CommonBigInteger.ov(sum_5(Companion_getInstance_22(), this.vr_1, other_0.vr_1), this.ur_1);
    }
    var cmp = this.cu(other_0);
    if (cmp === 0) {
      return Companion_getInstance_22().ZERO;
    }
    var tmp;
    if (cmp > 0) {
      tmp = subtract_3(Companion_getInstance_22(), this.vr_1, other_0.vr_1);
    } else {
      tmp = subtract_3(Companion_getInstance_22(), other_0.vr_1, this.vr_1);
    }
    var resultMag = tmp;
    resultMag = trustedStripLeadingZeroInts(Companion_getInstance_22(), resultMag);
    return CommonBigInteger.ov(resultMag, cmp === this.ur_1 ? 1 : -1);
  }
  times(other) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var other_0 = other;
    if (other_0.ur_1 === 0 || this.ur_1 === 0) {
      return Companion_getInstance_22().ZERO;
    }
    var xlen = this.vr_1.length;
    if (other_0 === this && xlen > 20) {
      return square(this);
    }
    var ylen = other_0.vr_1.length;
    if (xlen < 80 || ylen < 80) {
      var resultSign = this.ur_1 === other_0.ur_1 ? 1 : -1;
      if (other_0.vr_1.length === 1) {
        return multiplyByInt(Companion_getInstance_22(), this.vr_1, other_0.vr_1[0], resultSign);
      }
      if (this.vr_1.length === 1) {
        return multiplyByInt(Companion_getInstance_22(), other_0.vr_1, this.vr_1[0], resultSign);
      }
      var result = multiplyToLen(Companion_getInstance_22(), this.vr_1, xlen, other_0.vr_1, ylen, null);
      result = trustedStripLeadingZeroInts(Companion_getInstance_22(), result);
      return CommonBigInteger.ov(result, resultSign);
    } else {
      var tmp;
      if (xlen < 240 && ylen < 240) {
        tmp = multiplyKaratsuba(Companion_getInstance_22(), this, other_0);
      } else {
        tmp = multiplyToomCook3(Companion_getInstance_22(), this, other_0);
      }
      return tmp;
    }
  }
  uu(other) {
    var v = other;
    if (v === 0n || this.ur_1 === 0) {
      return Companion_getInstance_22().ZERO;
    }
    if (v === -9223372036854775808n) {
      return this.times(Companion_getInstance_22().ofLong(v));
    }
    var rsign = v > 0n ? this.ur_1 : -this.ur_1 | 0;
    if (v < 0n) {
      v = negate_0(v);
    }
    var dh = shiftRightUnsigned(v, 32);
    var dl = v & 4294967295n;
    var xlen = this.vr_1.length;
    var value = this.vr_1;
    var rmag = dh === 0n ? new Int32Array(xlen + 1 | 0) : new Int32Array(xlen + 2 | 0);
    var carry = 0n;
    var rstart = rmag.length - 1 | 0;
    var inductionVariable = xlen - 1 | 0;
    if (0 <= inductionVariable)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + -1 | 0;
        var product = add_0(multiply_0(fromInt_0(value[i]) & 4294967295n, dl), carry);
        var tmp = rmag;
        var _unary__edvuaz = rstart;
        rstart = _unary__edvuaz - 1 | 0;
        tmp[_unary__edvuaz] = convertToInt(product);
        carry = shiftRightUnsigned(product, 32);
      }
       while (0 <= inductionVariable);
    rmag[rstart] = convertToInt(carry);
    if (!(dh === 0n)) {
      carry = 0n;
      rstart = rmag.length - 2 | 0;
      var inductionVariable_0 = xlen - 1 | 0;
      if (0 <= inductionVariable_0)
        do {
          var i_0 = inductionVariable_0;
          inductionVariable_0 = inductionVariable_0 + -1 | 0;
          var product_0 = add_0(add_0(multiply_0(fromInt_0(value[i_0]) & 4294967295n, dh), fromInt_0(rmag[rstart]) & 4294967295n), carry);
          var tmp_0 = rmag;
          var _unary__edvuaz_0 = rstart;
          rstart = _unary__edvuaz_0 - 1 | 0;
          tmp_0[_unary__edvuaz_0] = convertToInt(product_0);
          carry = shiftRightUnsigned(product_0, 32);
        }
         while (0 <= inductionVariable_0);
      rmag[0] = convertToInt(carry);
    }
    if (carry === 0n) {
      rmag = copyOfRange_0(rmag, 1, rmag.length);
    }
    return CommonBigInteger.ov(rmag, rsign);
  }
  div(other) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var other_0 = other;
    var magSizeBelowThreshold = this.vr_1.length < 80;
    var magSizeDiffIsOffset = (this.vr_1.length - other_0.vr_1.length | 0) < 40;
    var tmp;
    if (magSizeBelowThreshold || magSizeDiffIsOffset) {
      tmp = divideKnuth(this, other_0);
    } else {
      tmp = divideBurnikelZiegler(this, other_0);
    }
    return tmp;
  }
  divideAndRemainder(other) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var other_0 = other;
    var magSizeBelowThreshold = this.vr_1.length < 80;
    var magSizeDiffIsOffset = (this.vr_1.length - other_0.vr_1.length | 0) < 40;
    var tmp;
    if (magSizeBelowThreshold || magSizeDiffIsOffset) {
      tmp = divideAndRemainderKnuth(this, other_0);
    } else {
      tmp = divideAndRemainderBurnikelZiegler(this, other_0);
    }
    return tmp;
  }
  reminder(other) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var other_0 = other;
    var magSizeBelowThreshold = this.vr_1.length < 80;
    var magSizeDiffIsOffset = (this.vr_1.length - other_0.vr_1.length | 0) < 40;
    var tmp;
    if (magSizeBelowThreshold || magSizeDiffIsOffset) {
      tmp = remainderKnuth(this, other_0);
    } else {
      tmp = remainderBurnikelZiegler(this, other_0);
    }
    return tmp;
  }
  pow(exponent) {
    if (exponent < 0) {
      throw ArithmeticException.cc('Negative exponent');
    }
    if (this.ur_1 === 0) {
      return exponent === 0 ? Companion_getInstance_22().ONE : this;
    }
    var partToSquare = this.absoluteValue;
    var powersOfTwo = _get_lowestSetBit__xjmtq(partToSquare);
    // Inline function 'kotlin.Long.times' call
    var this_0 = fromInt_0(powersOfTwo);
    var bitsToShift = multiply_0(this_0, fromInt_0(exponent));
    if (bitsToShift > 2147483647n) {
      reportOverflow(Companion_getInstance_22());
    }
    var remainingBits;
    if (powersOfTwo > 0) {
      partToSquare = partToSquare.shr(powersOfTwo);
      remainingBits = partToSquare.bitLength;
      if (remainingBits === 1) {
        var tmp;
        if (this.ur_1 < 0 && (exponent & 1) === 1) {
          tmp = Companion_getInstance_22().NEGATIVE_ONE.shl(imul_0(powersOfTwo, exponent));
        } else {
          tmp = Companion_getInstance_22().ONE.shl(imul_0(powersOfTwo, exponent));
        }
        return tmp;
      }
    } else {
      remainingBits = partToSquare.bitLength;
      if (remainingBits === 1) {
        var tmp_0;
        if (this.ur_1 < 0 && (exponent & 1) === 1) {
          tmp_0 = Companion_getInstance_22().NEGATIVE_ONE;
        } else {
          tmp_0 = Companion_getInstance_22().ONE;
        }
        return tmp_0;
      }
    }
    // Inline function 'kotlin.Long.times' call
    var this_1 = fromInt_0(remainingBits);
    var scaleFactor = multiply_0(this_1, fromInt_0(exponent));
    if (partToSquare.vr_1.length === 1 && scaleFactor <= 62n) {
      var newSign = this.ur_1 < 0 && (exponent & 1) === 1 ? -1 : 1;
      var result = 1n;
      var baseToPow2 = fromInt_0(partToSquare.vr_1[0]) & 4294967295n;
      var workingExponent = exponent;
      while (!(workingExponent === 0)) {
        if ((workingExponent & 1) === 1) {
          result = multiply_0(result, baseToPow2);
        }
        workingExponent = workingExponent >>> 1 | 0;
        if (!(workingExponent === 0)) {
          baseToPow2 = multiply_0(baseToPow2, baseToPow2);
        }
      }
      var tmp_1;
      if (powersOfTwo > 0) {
        var tmp_2;
        if (add_0(bitsToShift, scaleFactor) <= 62n) {
          var tmp_3 = Companion_getInstance_22();
          // Inline function 'kotlin.Long.times' call
          var this_2 = shiftLeft(result, convertToInt(bitsToShift));
          var tmp$ret$2 = multiply_0(this_2, fromInt_0(newSign));
          tmp_2 = tmp_3.ofLong(tmp$ret$2);
        } else {
          var tmp_4 = Companion_getInstance_22();
          // Inline function 'kotlin.Long.times' call
          var this_3 = result;
          var tmp$ret$3 = multiply_0(this_3, fromInt_0(newSign));
          tmp_2 = tmp_4.ofLong(tmp$ret$3).shl(convertToInt(bitsToShift));
        }
        tmp_1 = tmp_2;
      } else {
        var tmp_5 = Companion_getInstance_22();
        // Inline function 'kotlin.Long.times' call
        var this_4 = result;
        var tmp$ret$4 = multiply_0(this_4, fromInt_0(newSign));
        tmp_1 = tmp_5.ofLong(tmp$ret$4);
      }
      return tmp_1;
    } else {
      var answer = Companion_getInstance_22().ONE;
      var workingExponent_0 = exponent;
      while (!(workingExponent_0 === 0)) {
        if ((workingExponent_0 & 1) === 1) {
          answer = answer.times(partToSquare);
        }
        workingExponent_0 = workingExponent_0 >>> 1 | 0;
        if (!(workingExponent_0 === 0)) {
          partToSquare = square(partToSquare);
        }
      }
      if (powersOfTwo > 0) {
        answer = answer.shl(imul_0(powersOfTwo, exponent));
      }
      var tmp_6;
      if (this.ur_1 < 0 && (exponent & 1) === 1) {
        tmp_6 = answer.unaryMinus();
      } else {
        tmp_6 = answer;
      }
      return tmp_6;
    }
  }
  sqrt() {
    if (this.ur_1 < 0) {
      throw ArithmeticException.cc('Negative BigInteger');
    }
    return MutableBigInteger.fu(this.vr_1).cw().dw();
  }
  sqrtAndRemainder() {
    var s = this.sqrt();
    var r = this.minus(square(s));
    // Inline function 'kotlin.require' call
    // Inline function 'kotlin.require' call
    if (!(r.br(Companion_getInstance_22().ZERO) >= 0)) {
      var message = 'Failed requirement.';
      throw IllegalArgumentException.w(toString_1(message));
    }
    // Inline function 'kotlin.arrayOf' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    return [s, r];
  }
  gcd(other) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var other_0 = other;
    if (other_0.ur_1 === 0) {
      return this.absoluteValue;
    } else if (this.ur_1 === 0) {
      return other_0.absoluteValue;
    }
    var a = MutableBigInteger.qr(this);
    var b = MutableBigInteger.qr(other_0);
    var result = a.ew(b);
    return result.lu(1);
  }
  mq() {
    return this.ur_1 >= 0 ? this : this.unaryMinus();
  }
  unaryMinus() {
    return CommonBigInteger.ov(this.vr_1, -this.ur_1 | 0);
  }
  unaryPlus() {
    return this;
  }
  nq() {
    return this.ur_1;
  }
  rem(modulus) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var other = modulus;
    if (other.ur_1 <= 0) {
      throw ArithmeticException.cc('BigInteger: modulus not positive');
    }
    var result = this.reminder(other);
    return result.ur_1 >= 0 ? result : result.plus(other);
  }
  modPow(exponent, modulus) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var exponent_0 = exponent;
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var modulus_0 = modulus;
    if (modulus_0.ur_1 <= 0) {
      throw ArithmeticException.cc('BigInteger: modulus not positive');
    }
    if (exponent_0.ur_1 === 0) {
      return modulus_0.equals(Companion_getInstance_22().ONE) ? Companion_getInstance_22().ZERO : Companion_getInstance_22().ONE;
    }
    if (this.equals(Companion_getInstance_22().ONE)) {
      return modulus_0.equals(Companion_getInstance_22().ONE) ? Companion_getInstance_22().ZERO : Companion_getInstance_22().ONE;
    }
    if (this.equals(Companion_getInstance_22().ZERO) && exponent_0.ur_1 >= 0) {
      return Companion_getInstance_22().ZERO;
    }
    if (this.equals(Companion_getInstance_22().vs_1[1]) && !exponent_0.testBit(0)) {
      return modulus_0.equals(Companion_getInstance_22().ONE) ? Companion_getInstance_22().ZERO : Companion_getInstance_22().ONE;
    }
    var invertResult = exponent_0.ur_1 < 0;
    if (invertResult) {
      exponent_0 = exponent_0.unaryMinus();
    }
    var tmp;
    if (this.ur_1 < 0 || this.br(modulus_0) >= 0) {
      tmp = this.rem(modulus_0);
    } else {
      tmp = this;
    }
    var base = tmp;
    var result;
    if (modulus_0.testBit(0)) {
      result = oddModPow(base, exponent_0, modulus_0);
    } else {
      var p = _get_lowestSetBit__xjmtq(modulus_0);
      var m1 = modulus_0.shr(p);
      var m2 = Companion_getInstance_22().ONE.shl(p);
      var tmp_0;
      if (this.ur_1 < 0 || this.br(m1) >= 0) {
        tmp_0 = this.rem(m1);
      } else {
        tmp_0 = this;
      }
      var base2 = tmp_0;
      var tmp_1;
      if (m1.equals(Companion_getInstance_22().ONE)) {
        tmp_1 = Companion_getInstance_22().ZERO;
      } else {
        tmp_1 = oddModPow(base2, exponent_0, m1);
      }
      var a1 = tmp_1;
      var a2 = modPow2(base, exponent_0, p);
      var y1 = m2.modInverse(m1);
      var y2 = m1.modInverse(m2);
      if (modulus_0.vr_1.length < 33554432) {
        result = a1.times(m2).times(y1).plus(a2.times(m1).times(y2)).rem(modulus_0);
      } else {
        var t1 = MutableBigInteger.rr();
        MutableBigInteger.qr(a1.times(m2)).fw(MutableBigInteger.qr(y1), t1);
        var t2 = MutableBigInteger.rr();
        MutableBigInteger.qr(a2.times(m1)).fw(MutableBigInteger.qr(y2), t2);
        t1.ku(t2);
        var q = MutableBigInteger.rr();
        result = ensureNotNull(t1.pu(MutableBigInteger.qr(modulus_0), q)).dw();
      }
    }
    return invertResult ? result.modInverse(modulus_0) : result;
  }
  modInverse(modulus) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var modulus_0 = modulus;
    if (!(modulus_0.ur_1 === 1)) {
      throw ArithmeticException.cc('BigInteger: modulus not positive');
    }
    if (modulus_0.equals(Companion_getInstance_22().ONE)) {
      return Companion_getInstance_22().ZERO;
    }
    var modVal = this;
    if (this.ur_1 < 0 || this.cu(modulus_0) >= 0) {
      modVal = this.rem(modulus_0);
    }
    if (modVal.equals(Companion_getInstance_22().ONE)) {
      return Companion_getInstance_22().ONE;
    }
    var a = MutableBigInteger.qr(modVal);
    var b = MutableBigInteger.qr(modulus_0);
    var result = a.gw(b);
    return ensureNotNull(result).lu(1);
  }
  shl(n) {
    if (this.ur_1 === 0) {
      return Companion_getInstance_22().ZERO;
    }
    var tmp;
    if (n > 0) {
      tmp = CommonBigInteger.ov(shl(Companion_getInstance_22(), this.vr_1, n), this.ur_1);
    } else if (n === 0) {
      tmp = this;
    } else {
      tmp = shiftRightImpl(this, -n | 0);
    }
    return tmp;
  }
  shr(n) {
    if (this.ur_1 === 0) {
      return Companion_getInstance_22().ZERO;
    }
    var tmp;
    if (n > 0) {
      tmp = shiftRightImpl(this, n);
    } else if (n === 0) {
      tmp = this;
    } else {
      tmp = CommonBigInteger.ov(shl(Companion_getInstance_22(), this.vr_1, -n | 0), this.ur_1);
    }
    return tmp;
  }
  and(other) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var other_0 = other;
    var tmp0 = _get_intLength__55caik(this);
    // Inline function 'kotlin.math.max' call
    var b = _get_intLength__55caik(other_0);
    var tmp$ret$3 = Math.max(tmp0, b);
    var result = new Int32Array(tmp$ret$3);
    var inductionVariable = 0;
    var last = result.length - 1 | 0;
    if (inductionVariable <= last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        result[i] = getInt(this, (result.length - i | 0) - 1 | 0) & getInt(other_0, (result.length - i | 0) - 1 | 0);
      }
       while (inductionVariable <= last);
    return Companion_getInstance_22().ofIntArray(result);
  }
  or(other) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var other_0 = other;
    var tmp0 = _get_intLength__55caik(this);
    // Inline function 'kotlin.math.max' call
    var b = _get_intLength__55caik(other_0);
    var tmp$ret$3 = Math.max(tmp0, b);
    var result = new Int32Array(tmp$ret$3);
    var inductionVariable = 0;
    var last = result.length - 1 | 0;
    if (inductionVariable <= last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        result[i] = getInt(this, (result.length - i | 0) - 1 | 0) | getInt(other_0, (result.length - i | 0) - 1 | 0);
      }
       while (inductionVariable <= last);
    return Companion_getInstance_22().ofIntArray(result);
  }
  xor(other) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var other_0 = other;
    var tmp0 = _get_intLength__55caik(this);
    // Inline function 'kotlin.math.max' call
    var b = _get_intLength__55caik(other_0);
    var tmp$ret$3 = Math.max(tmp0, b);
    var result = new Int32Array(tmp$ret$3);
    var inductionVariable = 0;
    var last = result.length - 1 | 0;
    if (inductionVariable <= last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        result[i] = getInt(this, (result.length - i | 0) - 1 | 0) ^ getInt(other_0, (result.length - i | 0) - 1 | 0);
      }
       while (inductionVariable <= last);
    return Companion_getInstance_22().ofIntArray(result);
  }
  not() {
    var result = new Int32Array(_get_intLength__55caik(this));
    var inductionVariable = 0;
    var last = result.length - 1 | 0;
    if (inductionVariable <= last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        result[i] = ~getInt(this, (result.length - i | 0) - 1 | 0);
      }
       while (inductionVariable <= last);
    return Companion_getInstance_22().ofIntArray(result);
  }
  andNot(other) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var other_0 = other;
    var tmp0 = _get_intLength__55caik(this);
    // Inline function 'kotlin.math.max' call
    var b = _get_intLength__55caik(other_0);
    var tmp$ret$3 = Math.max(tmp0, b);
    var result = new Int32Array(tmp$ret$3);
    var inductionVariable = 0;
    var last = result.length - 1 | 0;
    if (inductionVariable <= last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        result[i] = getInt(this, (result.length - i | 0) - 1 | 0) & ~getInt(other_0, (result.length - i | 0) - 1 | 0);
      }
       while (inductionVariable <= last);
    return Companion_getInstance_22().ofIntArray(result);
  }
  testBit(n) {
    if (n < 0) {
      throw ArithmeticException.cc('Negative bit address');
    }
    return !((getInt(this, n >>> 5 | 0) & 1 << (n & 31)) === 0);
  }
  get(n) {
    return this.testBit(n);
  }
  set(n, b) {
    return b ? this.setBit(n) : this.clearBit(n);
  }
  setBit(n) {
    if (n < 0) {
      throw ArithmeticException.cc('Negative bit address');
    }
    var intNum = n >>> 5 | 0;
    var tmp0 = _get_intLength__55caik(this);
    // Inline function 'kotlin.math.max' call
    var b = intNum + 2 | 0;
    var tmp$ret$0 = Math.max(tmp0, b);
    var result = new Int32Array(tmp$ret$0);
    var inductionVariable = 0;
    var last = result.length - 1 | 0;
    if (inductionVariable <= last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        result[(result.length - i | 0) - 1 | 0] = getInt(this, i);
      }
       while (inductionVariable <= last);
    result[(result.length - intNum | 0) - 1 | 0] = result[(result.length - intNum | 0) - 1 | 0] | 1 << (n & 31);
    return Companion_getInstance_22().ofIntArray(result);
  }
  clearBit(n) {
    if (n < 0) {
      throw ArithmeticException.cc('Negative bit address');
    }
    var intNum = n >>> 5 | 0;
    var tmp0 = _get_intLength__55caik(this);
    // Inline function 'kotlin.math.max' call
    var b = ((n + 1 | 0) >>> 5 | 0) + 1 | 0;
    var tmp$ret$0 = Math.max(tmp0, b);
    var result = new Int32Array(tmp$ret$0);
    var inductionVariable = 0;
    var last = result.length - 1 | 0;
    if (inductionVariable <= last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        result[(result.length - i | 0) - 1 | 0] = getInt(this, i);
      }
       while (inductionVariable <= last);
    result[(result.length - intNum | 0) - 1 | 0] = result[(result.length - intNum | 0) - 1 | 0] & ~(1 << (n & 31));
    return Companion_getInstance_22().ofIntArray(result);
  }
  flipBit(n) {
    if (n < 0) {
      throw ArithmeticException.cc('Negative bit address');
    }
    var intNum = n >>> 5 | 0;
    var tmp0 = _get_intLength__55caik(this);
    // Inline function 'kotlin.math.max' call
    var b = intNum + 2 | 0;
    var tmp$ret$0 = Math.max(tmp0, b);
    var result = new Int32Array(tmp$ret$0);
    var inductionVariable = 0;
    var last = result.length - 1 | 0;
    if (inductionVariable <= last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        result[(result.length - i | 0) - 1 | 0] = getInt(this, i);
      }
       while (inductionVariable <= last);
    result[(result.length - intNum | 0) - 1 | 0] = result[(result.length - intNum | 0) - 1 | 0] ^ 1 << (n & 31);
    return Companion_getInstance_22().ofIntArray(result);
  }
  zq() {
    var n = this.xr_1 - 1 | 0;
    if (n === -1) {
      var m = this.vr_1;
      var len = m.length;
      if (len === 0) {
        n = 0;
      } else {
        var magBitLength = ((len - 1 | 0) << 5) + Companion_getInstance_22().qv(this.vr_1[0]) | 0;
        if (this.ur_1 < 0) {
          var pow2 = bitCount(this.vr_1[0]) === 1;
          var i = 1;
          while (i < len && pow2) {
            pow2 = this.vr_1[i] === 0;
            i = i + 1 | 0;
          }
          n = pow2 ? magBitLength - 1 | 0 : magBitLength;
        } else {
          n = magBitLength;
        }
      }
      this.xr_1 = n + 1 | 0;
    }
    return n;
  }
  ar() {
    var bc = this.wr_1 - 1 | 0;
    if (bc === -1) {
      bc = 0;
      var inductionVariable = 0;
      var last = this.vr_1.length - 1 | 0;
      if (inductionVariable <= last)
        do {
          var i = inductionVariable;
          inductionVariable = inductionVariable + 1 | 0;
          bc = bc + bitCount(this.vr_1[i]) | 0;
        }
         while (inductionVariable <= last);
      if (this.ur_1 < 0) {
        var magTrailingZeroCount = 0;
        var j;
        j = this.vr_1.length - 1 | 0;
        while (this.vr_1[j] === 0) {
          magTrailingZeroCount = magTrailingZeroCount + 32 | 0;
          j = j - 1 | 0;
        }
        magTrailingZeroCount = magTrailingZeroCount + numberOfTrailingZeros(this.vr_1[j]) | 0;
        bc = bc + (magTrailingZeroCount - 1 | 0) | 0;
      }
      this.wr_1 = bc + 1 | 0;
    }
    return bc;
  }
  isProbablePrime(certainty) {
    if (certainty <= 0) {
      return true;
    }
    var w = this.absoluteValue;
    if (w.equals(Companion_getInstance_22().TWO)) {
      return true;
    }
    return !w.testBit(0) || w.equals(Companion_getInstance_22().ONE) ? false : w.as(certainty, null);
  }
  br(other) {
    // Inline function 'com.macrofocus.common.math.big.castTo' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var other_0 = other;
    if (this.ur_1 === other_0.ur_1) {
      switch (this.ur_1) {
        case 1:
          return this.cu(other_0);
        case -1:
          return other_0.cu(this);
        default:
          return 0;
      }
    }
    return this.ur_1 > other_0.ur_1 ? 1 : -1;
  }
  d(other) {
    return this.br((!(other == null) ? isInterface(other, BigInteger) : false) ? other : THROW_CCE());
  }
  cu(other) {
    var m1 = this.vr_1;
    var len1 = m1.length;
    var m2 = other.vr_1;
    var len2 = m2.length;
    if (len1 < len2) {
      return -1;
    }
    if (len1 > len2) {
      return 1;
    }
    var inductionVariable = 0;
    if (inductionVariable < len1)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        var a = m1[i];
        var b = m2[i];
        if (!(a === b)) {
          return (fromInt_0(a) & 4294967295n) < (fromInt_0(b) & 4294967295n) ? -1 : 1;
        }
      }
       while (inductionVariable < len1);
    return 0;
  }
  equals(other) {
    if (other === this) {
      return true;
    }
    if (!(other instanceof CommonBigInteger)) {
      return false;
    }
    var xInt = other instanceof CommonBigInteger ? other : THROW_CCE();
    if (!(ensureNotNull(xInt).ur_1 === this.ur_1)) {
      return false;
    }
    var m = this.vr_1;
    var len = m.length;
    var xm = xInt.vr_1;
    if (!(len === xm.length)) {
      return false;
    }
    var inductionVariable = 0;
    if (inductionVariable < len)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        if (!(xm[i] === m[i])) {
          return false;
        }
      }
       while (inductionVariable < len);
    return true;
  }
  min(other) {
    return this.br(other) < 0 ? this : other;
  }
  max(other) {
    return this.br(other) > 0 ? this : other;
  }
  hashCode() {
    var hashCode = 0;
    var inductionVariable = 0;
    var last = this.vr_1.length - 1 | 0;
    if (inductionVariable <= last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        hashCode = imul_0(31, hashCode) + convertToInt(fromInt_0(this.vr_1[i]) & 4294967295n) | 0;
      }
       while (inductionVariable <= last);
    return imul_0(hashCode, this.ur_1);
  }
  toStringWithRadix(radix) {
    var radix_0 = radix;
    if (this.ur_1 === 0) {
      return '0';
    }
    if (radix_0 < 2 || radix_0 > 36) {
      radix_0 = 10;
    }
    if (this.vr_1.length <= 20) {
      return smallToString(this, radix_0);
    }
    var sb = StringBuilder.y();
    if (this.ur_1 < 0) {
      toString_7(Companion_getInstance_22(), this.unaryMinus(), sb, radix_0, 0);
      sb = insertChar(sb, 0, _Char___init__impl__6a9atx(45));
    } else {
      toString_7(Companion_getInstance_22(), this, sb, radix_0, 0);
    }
    return sb.toString();
  }
  toString() {
    return this.toStringWithRadix(10);
  }
  toByteArray() {
    var byteLen = (this.bitLength / 8 | 0) + 1 | 0;
    var byteArray = new Int8Array(byteLen);
    var i = byteLen - 1 | 0;
    var bytesCopied = 4;
    var nextInt = 0;
    var intIndex = 0;
    while (i >= 0) {
      if (bytesCopied === 4) {
        var _unary__edvuaz = intIndex;
        intIndex = _unary__edvuaz + 1 | 0;
        nextInt = getInt(this, _unary__edvuaz);
        bytesCopied = 1;
      } else {
        nextInt = nextInt >>> 8 | 0;
        bytesCopied = bytesCopied + 1 | 0;
      }
      byteArray[i] = toByte(nextInt);
      i = i - 1 | 0;
    }
    return byteArray;
  }
  toInt() {
    var result = 0;
    result = getInt(this, 0);
    return result;
  }
  toLong() {
    var result = 0n;
    var inductionVariable = 1;
    if (0 <= inductionVariable)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + -1 | 0;
        result = add_0(shiftLeft(result, 32), fromInt_0(getInt(this, i)) & 4294967295n);
      }
       while (0 <= inductionVariable);
    return result;
  }
  toByte() {
    return toByte(this.toInt());
  }
  toChar() {
    return numberToChar(this.toInt());
  }
  toShort() {
    return toShort(this.toInt());
  }
  toFloat() {
    return this.toInt();
  }
  toDouble() {
    return toNumber_0(this.toLong());
  }
  toLongExact() {
    var tmp;
    if (this.vr_1.length <= 2 && this.bitLength <= 63) {
      tmp = this.toLong();
    } else {
      throw ArithmeticException.cc('BigInteger out of long range');
    }
    return tmp;
  }
  toIntExact() {
    var tmp;
    if (this.vr_1.length <= 1 && this.bitLength <= 31) {
      tmp = this.toInt();
    } else {
      throw ArithmeticException.cc('BigInteger out of int range');
    }
    return tmp;
  }
  toShortExact() {
    if (this.vr_1.length <= 1 && this.bitLength <= 31) {
      var value = this.toInt();
      if (value >= -32768 && value <= 32767) {
        return this.toShort();
      }
    }
    throw ArithmeticException.cc('BigInteger out of short range');
  }
  toByteExact() {
    if (this.vr_1.length <= 1 && this.bitLength <= 31) {
      var value = this.toInt();
      if (value >= -128 && value <= 127) {
        return this.toByte();
      }
    }
    throw ArithmeticException.cc('BigInteger out of byte range');
  }
  get absoluteValue() {
    return this.mq();
  }
  get signum() {
    return this.nq();
  }
  get bitLength() {
    return this.zq();
  }
  get bitCount() {
    return this.ar();
  }
}
class Companion_23 {
  constructor() {
    Companion_instance_23 = this;
    this.UNLIMITED = new MathContext(0, RoundingMode_HALF_UP_getInstance());
    this.DECIMAL32 = new MathContext(7, RoundingMode_HALF_EVEN_getInstance());
    this.DECIMAL64 = new MathContext(16, RoundingMode_HALF_EVEN_getInstance());
    this.DECIMAL128 = new MathContext(34, RoundingMode_HALF_EVEN_getInstance());
  }
  hw() {
    return this.UNLIMITED;
  }
  iw() {
    return this.DECIMAL32;
  }
  jw() {
    return this.DECIMAL64;
  }
  kw() {
    return this.DECIMAL128;
  }
}
class MathContext {
  constructor(precision, roundingMode) {
    Companion_getInstance_23();
    precision = precision === VOID ? 9 : precision;
    roundingMode = roundingMode === VOID ? RoundingMode_HALF_UP_getInstance() : roundingMode;
    this.precision = precision;
    this.roundingMode = roundingMode;
    // Inline function 'kotlin.require' call
    // Inline function 'kotlin.require' call
    if (!(this.precision >= 0)) {
      var message = 'Failed requirement.';
      throw IllegalArgumentException.w(toString_1(message));
    }
  }
  pq() {
    return this.precision;
  }
  lw() {
    return this.roundingMode;
  }
  mi() {
    return this.precision;
  }
  ni() {
    return this.roundingMode;
  }
  mw(precision, roundingMode) {
    return new MathContext(precision, roundingMode);
  }
  copy(precision, roundingMode, $super) {
    precision = precision === VOID ? this.precision : precision;
    roundingMode = roundingMode === VOID ? this.roundingMode : roundingMode;
    return $super === VOID ? this.mw(precision, roundingMode) : $super.mw.call(this, precision, roundingMode);
  }
  toString() {
    return 'MathContext(precision=' + this.precision + ', roundingMode=' + this.roundingMode.toString() + ')';
  }
  hashCode() {
    var result = this.precision;
    result = imul_0(result, 31) + this.roundingMode.hashCode() | 0;
    return result;
  }
  equals(other) {
    if (this === other)
      return true;
    if (!(other instanceof MathContext))
      return false;
    if (!(this.precision === other.precision))
      return false;
    if (!this.roundingMode.equals(other.roundingMode))
      return false;
    return true;
  }
}
class Companion_24 {
  constructor() {
    Companion_instance_24 = this;
    this.hu_1 = MutableBigInteger.jx(1);
    this.iu_1 = 6;
    this.ju_1 = 3;
  }
  uw(n, d) {
    var dLong = fromInt_0(d) & 4294967295n;
    var r;
    var q;
    if (dLong === 1n) {
      q = fromInt_0(convertToInt(n));
      r = 0n;
      return shiftLeft(r, 32) | q & 4294967295n;
    }
    q = divide(shiftRightUnsigned(n, 1), shiftRightUnsigned(dLong, 1));
    r = subtract_0(n, multiply_0(q, dLong));
    while (r < 0n) {
      r = add_0(r, dLong);
      var _unary__edvuaz = q;
      q = subtract_0(_unary__edvuaz, get_ONE());
    }
    while (r >= dLong) {
      r = subtract_0(r, dLong);
      var _unary__edvuaz_0 = q;
      q = add_0(_unary__edvuaz_0, get_ONE());
    }
    return shiftLeft(r, 32) | q & 4294967295n;
  }
  ww(a, b) {
    var a_0 = a;
    var b_0 = b;
    if (b_0 === 0) {
      return a_0;
    }
    if (a_0 === 0) {
      return b_0;
    }
    var aZeros = numberOfTrailingZeros(a_0);
    var bZeros = numberOfTrailingZeros(b_0);
    a_0 = a_0 >>> aZeros | 0;
    b_0 = b_0 >>> bZeros | 0;
    var t = aZeros < bZeros ? aZeros : bZeros;
    while (!(a_0 === b_0)) {
      if ((a_0 + -2147483648 | 0) > (b_0 + -2147483648 | 0)) {
        a_0 = a_0 - b_0 | 0;
        a_0 = a_0 >>> numberOfTrailingZeros(a_0) | 0;
      } else {
        b_0 = b_0 - a_0 | 0;
        b_0 = b_0 >>> numberOfTrailingZeros(b_0) | 0;
      }
    }
    return a_0 << t;
  }
  kx(val) {
    var t = val;
    t = imul_0(t, 2 - imul_0(val, t) | 0);
    t = imul_0(t, 2 - imul_0(val, t) | 0);
    t = imul_0(t, 2 - imul_0(val, t) | 0);
    t = imul_0(t, 2 - imul_0(val, t) | 0);
    return t;
  }
  uv(val) {
    var t = val;
    t = multiply_0(t, subtract_0(numberToLong(2), multiply_0(val, t)));
    t = multiply_0(t, subtract_0(numberToLong(2), multiply_0(val, t)));
    t = multiply_0(t, subtract_0(numberToLong(2), multiply_0(val, t)));
    t = multiply_0(t, subtract_0(numberToLong(2), multiply_0(val, t)));
    t = multiply_0(t, subtract_0(numberToLong(2), multiply_0(val, t)));
    // Inline function 'kotlin.require' call
    // Inline function 'kotlin.require' call
    if (!(multiply_0(t, val) === 1n)) {
      var message = 'Failed requirement.';
      throw IllegalArgumentException.w(toString_1(message));
    }
    return t;
  }
  lx(mod, k) {
    return this.ix(MutableBigInteger.jx(1), MutableBigInteger.ow(mod), k);
  }
  ix(c, p, k) {
    var temp = MutableBigInteger.rr();
    var r = -this.kx(p.mr_1[(p.pr_1 + p.nr_1 | 0) - 1 | 0]) | 0;
    var i = 0;
    var numWords = k >> 5;
    while (i < numWords) {
      var v = imul_0(r, c.mr_1[(c.pr_1 + c.nr_1 | 0) - 1 | 0]);
      p.mx(v, temp);
      c.ku(temp);
      c.nr_1 = c.nr_1 - 1 | 0;
      i = i + 1 | 0;
    }
    var numBits = k & 31;
    if (!(numBits === 0)) {
      var v_0 = imul_0(r, c.mr_1[(c.pr_1 + c.nr_1 | 0) - 1 | 0]);
      v_0 = v_0 & ((1 << numBits) - 1 | 0);
      p.mx(v_0, temp);
      c.ku(temp);
      c.vw(numBits);
    }
    while (c.nw(p) >= 0) {
      c.sw(p);
    }
    return c;
  }
}
class MutableBigInteger {
  ex() {
    return this.nr_1 === 1 && this.mr_1[this.pr_1] === 1;
  }
  qu() {
    return this.nr_1 === 0;
  }
  dx() {
    return this.nr_1 === 0 || (this.mr_1[(this.pr_1 + this.nr_1 | 0) - 1 | 0] & 1) === 0;
  }
  ou() {
    return this.qu() ? false : (this.mr_1[(this.pr_1 + this.nr_1 | 0) - 1 | 0] & 1) === 1;
  }
  static rr() {
    Companion_getInstance_24();
    var $this = createThis(this);
    init_com_macrofocus_common_math_big_MutableBigInteger($this);
    $this.mr_1 = new Int32Array(1);
    $this.nr_1 = 0;
    return $this;
  }
  static jx(val) {
    Companion_getInstance_24();
    var $this = createThis(this);
    init_com_macrofocus_common_math_big_MutableBigInteger($this);
    $this.mr_1 = new Int32Array(1);
    $this.nr_1 = 1;
    $this.mr_1[0] = val;
    return $this;
  }
  static fu(val) {
    Companion_getInstance_24();
    var $this = createThis(this);
    init_com_macrofocus_common_math_big_MutableBigInteger($this);
    $this.mr_1 = val;
    $this.nr_1 = val.length;
    return $this;
  }
  static qr(b) {
    Companion_getInstance_24();
    var $this = createThis(this);
    init_com_macrofocus_common_math_big_MutableBigInteger($this);
    $this.nr_1 = b.vr_1.length;
    $this.mr_1 = copyOf(b.vr_1, $this.nr_1);
    return $this;
  }
  static ow(val) {
    Companion_getInstance_24();
    var $this = createThis(this);
    init_com_macrofocus_common_math_big_MutableBigInteger($this);
    $this.nr_1 = val.nr_1;
    $this.mr_1 = copyOfRange_0(val.mr_1, val.pr_1, val.pr_1 + $this.nr_1 | 0);
    return $this;
  }
  lu(sign) {
    var tmp;
    if (this.nr_1 === 0 || sign === 0) {
      tmp = Companion_getInstance_22().ZERO;
    } else {
      tmp = CommonBigInteger.ov(_get_magnitudeArray__ns4ohu(this), sign);
    }
    return tmp;
  }
  dw() {
    this.vv();
    return this.lu(this.qu() ? 0 : 1);
  }
  mu(sign, scale) {
    if (this.nr_1 === 0 || sign === 0) {
      return Companion_getInstance_21().wu(scale);
    }
    var mag = _get_magnitudeArray__ns4ohu(this);
    var len = mag.length;
    var d = mag[0];
    if (len > 2 || (d < 0 && len === 2)) {
      return CommonBigDecimal.eu(CommonBigInteger.ov(mag, sign), -9223372036854775808n, scale, 0);
    }
    var tmp;
    if (len === 2) {
      tmp = fromInt_0(mag[1]) & 4294967295n | shiftLeft(fromInt_0(d) & 4294967295n, 32);
    } else {
      tmp = fromInt_0(d) & 4294967295n;
    }
    var v = tmp;
    return Companion_getInstance_21().ofScaledLong(sign === -1 ? negate_0(v) : v, scale);
  }
  nu(sign) {
    if (this.nr_1 === 0 || sign === 0) {
      return 0n;
    }
    var mag = _get_magnitudeArray__ns4ohu(this);
    var len = mag.length;
    var d = mag[0];
    if (len > 2 || (d < 0 && len === 2)) {
      return -9223372036854775808n;
    }
    var tmp;
    if (len === 2) {
      tmp = fromInt_0(mag[1]) & 4294967295n | shiftLeft(fromInt_0(d) & 4294967295n, 32);
    } else {
      tmp = fromInt_0(d) & 4294967295n;
    }
    var v = tmp;
    return sign === -1 ? negate_0(v) : v;
  }
  u4() {
    this.nr_1 = 0;
    this.pr_1 = this.nr_1;
    var index = 0;
    var n = this.mr_1.length;
    while (index < n) {
      this.mr_1[index] = 0;
      index = index + 1 | 0;
    }
  }
  nx() {
    this.nr_1 = 0;
    this.pr_1 = this.nr_1;
  }
  nw(b) {
    var blen = b.nr_1;
    if (this.nr_1 < blen) {
      return -1;
    }
    if (this.nr_1 > blen) {
      return 1;
    }
    var bval = b.mr_1;
    var i = this.pr_1;
    var j = b.pr_1;
    while (i < (this.nr_1 + this.pr_1 | 0)) {
      var b1 = this.mr_1[i] + -2147483648 | 0;
      var b2 = bval[j] + -2147483648 | 0;
      if (b1 < b2) {
        return -1;
      }
      if (b1 > b2) {
        return 1;
      }
      i = i + 1 | 0;
      j = j + 1 | 0;
    }
    return 0;
  }
  ru(b) {
    var blen = b.nr_1;
    var len = this.nr_1;
    if (len <= 0) {
      return blen <= 0 ? 0 : -1;
    }
    if (len > blen) {
      return 1;
    }
    if (len < (blen - 1 | 0)) {
      return -1;
    }
    var bval = b.mr_1;
    var bstart = 0;
    var carry = 0;
    if (!(len === blen)) {
      if (bval[bstart] === 1) {
        bstart = bstart + 1 | 0;
        carry = -2147483648;
      } else {
        return -1;
      }
    }
    var val = this.mr_1;
    var i = this.pr_1;
    var j = bstart;
    while (i < (len + this.pr_1 | 0)) {
      var _unary__edvuaz = j;
      j = _unary__edvuaz + 1 | 0;
      var bv = bval[_unary__edvuaz];
      var tmp0 = fromInt_0(bv >>> 1 | 0);
      // Inline function 'kotlin.Long.plus' call
      var other = carry;
      var hb = add_0(tmp0, fromInt_0(other)) & 4294967295n;
      var _unary__edvuaz_0 = i;
      i = _unary__edvuaz_0 + 1 | 0;
      var v = fromInt_0(val[_unary__edvuaz_0]) & 4294967295n;
      if (!(v === hb)) {
        return v < hb ? -1 : 1;
      }
      carry = (bv & 1) << 31;
    }
    return carry === 0 ? 0 : -1;
  }
  vv() {
    if (this.nr_1 === 0) {
      this.pr_1 = 0;
      return Unit_instance;
    }
    var index = this.pr_1;
    if (!(this.mr_1[index] === 0)) {
      return Unit_instance;
    }
    var indexBound = index + this.nr_1 | 0;
    do {
      index = index + 1 | 0;
    }
     while (index < indexBound && this.mr_1[index] === 0);
    var numZeros = index - this.pr_1 | 0;
    this.nr_1 = this.nr_1 - numZeros | 0;
    this.pr_1 = this.nr_1 === 0 ? 0 : this.pr_1 + numZeros | 0;
  }
  wv() {
    var result = new Int32Array(this.nr_1);
    var inductionVariable = 0;
    var last = this.nr_1;
    if (inductionVariable < last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        result[i] = this.mr_1[this.pr_1 + i | 0];
      }
       while (inductionVariable < last);
    return result;
  }
  ox(val, length) {
    this.mr_1 = val;
    this.nr_1 = length;
    this.pr_1 = 0;
  }
  px(src) {
    var len = src.nr_1;
    if (this.mr_1.length < len) {
      this.mr_1 = new Int32Array(len);
    }
    arrayCopy_0(src.mr_1, src.pr_1, this.mr_1, 0, len);
    this.nr_1 = len;
    this.pr_1 = 0;
  }
  toString() {
    var b = this.lu(1);
    return b.toString();
  }
  pw(n) {
    if ((n / 32 | 0) >= this.nr_1) {
      this.nx();
    } else {
      this.vw(n);
    }
  }
  vw(n) {
    if (this.nr_1 === 0) {
      return Unit_instance;
    }
    var nInts = n >>> 5 | 0;
    var nBits = n & 31;
    this.nr_1 = this.nr_1 - nInts | 0;
    if (nBits === 0) {
      return Unit_instance;
    }
    var bitsInHighWord = Companion_getInstance_22().qv(this.mr_1[this.pr_1]);
    if (nBits >= bitsInHighWord) {
      primitiveLeftShift_0(this, 32 - nBits | 0);
      this.nr_1 = this.nr_1 - 1 | 0;
    } else {
      primitiveRightShift_0(this, nBits);
    }
  }
  qx(n) {
    if (n > 0) {
      this.rw(n);
    }
  }
  rw(n) {
    if (this.nr_1 === 0) {
      return Unit_instance;
    }
    var nInts = n >>> 5 | 0;
    var nBits = n & 31;
    var bitsInHighWord = Companion_getInstance_22().qv(this.mr_1[this.pr_1]);
    if (n <= (32 - bitsInHighWord | 0)) {
      primitiveLeftShift_0(this, nBits);
      return Unit_instance;
    }
    var newLen = (this.nr_1 + nInts | 0) + 1 | 0;
    if (nBits <= (32 - bitsInHighWord | 0)) {
      newLen = newLen - 1 | 0;
    }
    if (this.mr_1.length < newLen) {
      var result = new Int32Array(newLen);
      var inductionVariable = 0;
      var last = this.nr_1;
      if (inductionVariable < last)
        do {
          var i = inductionVariable;
          inductionVariable = inductionVariable + 1 | 0;
          result[i] = this.mr_1[this.pr_1 + i | 0];
        }
         while (inductionVariable < last);
      this.ox(result, newLen);
    } else if ((this.mr_1.length - this.pr_1 | 0) >= newLen) {
      var inductionVariable_0 = 0;
      var last_0 = newLen - this.nr_1 | 0;
      if (inductionVariable_0 < last_0)
        do {
          var i_0 = inductionVariable_0;
          inductionVariable_0 = inductionVariable_0 + 1 | 0;
          this.mr_1[(this.pr_1 + this.nr_1 | 0) + i_0 | 0] = 0;
        }
         while (inductionVariable_0 < last_0);
    } else {
      var inductionVariable_1 = 0;
      var last_1 = this.nr_1;
      if (inductionVariable_1 < last_1)
        do {
          var i_1 = inductionVariable_1;
          inductionVariable_1 = inductionVariable_1 + 1 | 0;
          this.mr_1[i_1] = this.mr_1[this.pr_1 + i_1 | 0];
        }
         while (inductionVariable_1 < last_1);
      var inductionVariable_2 = this.nr_1;
      var last_2 = newLen;
      if (inductionVariable_2 < last_2)
        do {
          var i_2 = inductionVariable_2;
          inductionVariable_2 = inductionVariable_2 + 1 | 0;
          this.mr_1[i_2] = 0;
        }
         while (inductionVariable_2 < last_2);
      this.pr_1 = 0;
    }
    this.nr_1 = newLen;
    if (nBits === 0) {
      return Unit_instance;
    }
    if (nBits <= (32 - bitsInHighWord | 0)) {
      primitiveLeftShift_0(this, nBits);
    } else {
      primitiveRightShift_0(this, 32 - nBits | 0);
    }
  }
  ku(addend) {
    var x = this.nr_1;
    var y = addend.nr_1;
    var resultLen = this.nr_1 > addend.nr_1 ? this.nr_1 : addend.nr_1;
    var result = this.mr_1.length < resultLen ? new Int32Array(resultLen) : this.mr_1;
    var rstart = result.length - 1 | 0;
    var sum;
    var carry = 0n;
    while (x > 0 && y > 0) {
      x = x - 1 | 0;
      y = y - 1 | 0;
      sum = add_0(add_0(fromInt_0(this.mr_1[x + this.pr_1 | 0]) & 4294967295n, fromInt_0(addend.mr_1[y + addend.pr_1 | 0]) & 4294967295n), carry);
      var tmp = result;
      var _unary__edvuaz = rstart;
      rstart = _unary__edvuaz - 1 | 0;
      tmp[_unary__edvuaz] = convertToInt(sum);
      carry = shiftRightUnsigned(sum, 32);
    }
    while (x > 0) {
      x = x - 1 | 0;
      if (carry === 0n && equals(result, this.mr_1) && rstart === (x + this.pr_1 | 0)) {
        return Unit_instance;
      }
      sum = add_0(fromInt_0(this.mr_1[x + this.pr_1 | 0]) & 4294967295n, carry);
      var tmp_0 = result;
      var _unary__edvuaz_0 = rstart;
      rstart = _unary__edvuaz_0 - 1 | 0;
      tmp_0[_unary__edvuaz_0] = convertToInt(sum);
      carry = shiftRightUnsigned(sum, 32);
    }
    while (y > 0) {
      y = y - 1 | 0;
      sum = add_0(fromInt_0(addend.mr_1[y + addend.pr_1 | 0]) & 4294967295n, carry);
      var tmp_1 = result;
      var _unary__edvuaz_1 = rstart;
      rstart = _unary__edvuaz_1 - 1 | 0;
      tmp_1[_unary__edvuaz_1] = convertToInt(sum);
      carry = shiftRightUnsigned(sum, 32);
    }
    if (carry > 0n) {
      resultLen = resultLen + 1 | 0;
      if (result.length < resultLen) {
        var temp = new Int32Array(resultLen);
        arrayCopy_0(result, 0, temp, 1, result.length);
        temp[0] = 1;
        result = temp;
      } else {
        var tmp_2 = result;
        var _unary__edvuaz_2 = rstart;
        rstart = _unary__edvuaz_2 - 1 | 0;
        tmp_2[_unary__edvuaz_2] = 1;
      }
    }
    this.mr_1 = result;
    this.nr_1 = resultLen;
    this.pr_1 = result.length - resultLen | 0;
  }
  rx(addend, n) {
    if (addend.qu()) {
      return Unit_instance;
    }
    var x = this.nr_1;
    var y = addend.nr_1 + n | 0;
    var resultLen = this.nr_1 > y ? this.nr_1 : y;
    var result = this.mr_1.length < resultLen ? new Int32Array(resultLen) : this.mr_1;
    var rstart = result.length - 1 | 0;
    var sum;
    var carry = 0n;
    while (x > 0 && y > 0) {
      x = x - 1 | 0;
      y = y - 1 | 0;
      var bval = (y + addend.pr_1 | 0) < addend.mr_1.length ? addend.mr_1[y + addend.pr_1 | 0] : 0;
      sum = add_0(add_0(fromInt_0(this.mr_1[x + this.pr_1 | 0]) & 4294967295n, fromInt_0(bval) & 4294967295n), carry);
      var tmp = result;
      var _unary__edvuaz = rstart;
      rstart = _unary__edvuaz - 1 | 0;
      tmp[_unary__edvuaz] = convertToInt(sum);
      carry = shiftRightUnsigned(sum, 32);
    }
    while (x > 0) {
      x = x - 1 | 0;
      if (carry === 0n && equals(result, this.mr_1) && rstart === (x + this.pr_1 | 0)) {
        return Unit_instance;
      }
      sum = add_0(fromInt_0(this.mr_1[x + this.pr_1 | 0]) & 4294967295n, carry);
      var tmp_0 = result;
      var _unary__edvuaz_0 = rstart;
      rstart = _unary__edvuaz_0 - 1 | 0;
      tmp_0[_unary__edvuaz_0] = convertToInt(sum);
      carry = shiftRightUnsigned(sum, 32);
    }
    while (y > 0) {
      y = y - 1 | 0;
      var bval_0 = (y + addend.pr_1 | 0) < addend.mr_1.length ? addend.mr_1[y + addend.pr_1 | 0] : 0;
      sum = add_0(fromInt_0(bval_0) & 4294967295n, carry);
      var tmp_1 = result;
      var _unary__edvuaz_1 = rstart;
      rstart = _unary__edvuaz_1 - 1 | 0;
      tmp_1[_unary__edvuaz_1] = convertToInt(sum);
      carry = shiftRightUnsigned(sum, 32);
    }
    if (carry > 0n) {
      resultLen = resultLen + 1 | 0;
      if (result.length < resultLen) {
        var temp = new Int32Array(resultLen);
        arrayCopy_0(result, 0, temp, 1, result.length);
        temp[0] = 1;
        result = temp;
      } else {
        var tmp_2 = result;
        var _unary__edvuaz_2 = rstart;
        rstart = _unary__edvuaz_2 - 1 | 0;
        tmp_2[_unary__edvuaz_2] = 1;
      }
    }
    this.mr_1 = result;
    this.nr_1 = resultLen;
    this.pr_1 = result.length - resultLen | 0;
  }
  qw(addend, n) {
    if (ensureNotNull(addend).qu()) {
      return Unit_instance;
    }
    var x = this.nr_1;
    var y = addend.nr_1 + n | 0;
    var resultLen = this.nr_1 > y ? this.nr_1 : y;
    var result;
    if (this.mr_1.length < resultLen) {
      result = new Int32Array(resultLen);
    } else {
      result = this.mr_1;
      fill_0(this.mr_1, this.pr_1 + this.nr_1 | 0, this.mr_1.length, 0);
    }
    var rstart = result.length - 1 | 0;
    arrayCopy_0(this.mr_1, this.pr_1, result, (rstart + 1 | 0) - x | 0, x);
    y = y - x | 0;
    rstart = rstart - x | 0;
    var tmp0 = y;
    // Inline function 'kotlin.math.min' call
    var b = addend.mr_1.length - addend.pr_1 | 0;
    var len = Math.min(tmp0, b);
    arrayCopy_0(addend.mr_1, addend.pr_1, result, (rstart + 1 | 0) - y | 0, len);
    var inductionVariable = ((rstart + 1 | 0) - y | 0) + len | 0;
    var last = rstart + 1 | 0;
    if (inductionVariable < last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        result[i] = 0;
      }
       while (inductionVariable < last);
    this.mr_1 = result;
    this.nr_1 = resultLen;
    this.pr_1 = result.length - resultLen | 0;
  }
  tw(addend, n) {
    var a = MutableBigInteger.ow(addend);
    if ((a.pr_1 + a.nr_1 | 0) >= n) {
      a.pr_1 = (a.pr_1 + a.nr_1 | 0) - n | 0;
      a.nr_1 = n;
    }
    a.vv();
    this.ku(a);
  }
  sw(b) {
    var b_0 = b;
    var a = this;
    var result = this.mr_1;
    var sign = a.nw(b_0);
    if (sign === 0) {
      this.nx();
      return 0;
    }
    if (sign < 0) {
      var tmp = a;
      a = b_0;
      b_0 = tmp;
    }
    var resultLen = a.nr_1;
    if (result.length < resultLen) {
      result = new Int32Array(resultLen);
    }
    var diff = 0n;
    var x = a.nr_1;
    var y = b_0.nr_1;
    var rstart = result.length - 1 | 0;
    while (y > 0) {
      x = x - 1 | 0;
      y = y - 1 | 0;
      diff = subtract_0(subtract_0(fromInt_0(a.mr_1[x + a.pr_1 | 0]) & 4294967295n, fromInt_0(b_0.mr_1[y + b_0.pr_1 | 0]) & 4294967295n), fromInt_0(convertToInt(negate_0(shiftRight(diff, 32)))));
      var tmp_0 = result;
      var _unary__edvuaz = rstart;
      rstart = _unary__edvuaz - 1 | 0;
      tmp_0[_unary__edvuaz] = convertToInt(diff);
    }
    while (x > 0) {
      x = x - 1 | 0;
      var tmp0 = fromInt_0(a.mr_1[x + a.pr_1 | 0]) & 4294967295n;
      // Inline function 'kotlin.Long.minus' call
      var other = convertToInt(negate_0(shiftRight(diff, 32)));
      diff = subtract_0(tmp0, fromInt_0(other));
      var tmp_1 = result;
      var _unary__edvuaz_0 = rstart;
      rstart = _unary__edvuaz_0 - 1 | 0;
      tmp_1[_unary__edvuaz_0] = convertToInt(diff);
    }
    this.mr_1 = result;
    this.nr_1 = resultLen;
    this.pr_1 = this.mr_1.length - resultLen | 0;
    this.vv();
    return sign;
  }
  fw(y, z) {
    var xLen = this.nr_1;
    var yLen = y.nr_1;
    var newLen = xLen + yLen | 0;
    if (z.mr_1.length < newLen) {
      z.mr_1 = new Int32Array(newLen);
    }
    z.pr_1 = 0;
    z.nr_1 = newLen;
    var carry = 0n;
    // Inline function 'kotlin.run' call
    var j = yLen - 1 | 0;
    var k = (yLen + xLen | 0) - 1 | 0;
    while (j >= 0) {
      var product = add_0(multiply_0(fromInt_0(y.mr_1[j + y.pr_1 | 0]) & 4294967295n, fromInt_0(this.mr_1[(xLen - 1 | 0) + this.pr_1 | 0]) & 4294967295n), carry);
      z.mr_1[k] = convertToInt(product);
      carry = shiftRightUnsigned(product, 32);
      j = j - 1 | 0;
      k = k - 1 | 0;
    }
    z.mr_1[xLen - 1 | 0] = convertToInt(carry);
    var inductionVariable = xLen - 2 | 0;
    if (0 <= inductionVariable)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + -1 | 0;
        carry = 0n;
        var j_0 = yLen - 1 | 0;
        var k_0 = yLen + i | 0;
        while (j_0 >= 0) {
          var product_0 = add_0(add_0(multiply_0(fromInt_0(y.mr_1[j_0 + y.pr_1 | 0]) & 4294967295n, fromInt_0(this.mr_1[i + this.pr_1 | 0]) & 4294967295n), fromInt_0(z.mr_1[k_0]) & 4294967295n), carry);
          z.mr_1[k_0] = convertToInt(product_0);
          carry = shiftRightUnsigned(product_0, 32);
          j_0 = j_0 - 1 | 0;
          k_0 = k_0 - 1 | 0;
        }
        z.mr_1[i] = convertToInt(carry);
      }
       while (0 <= inductionVariable);
    z.vv();
  }
  mx(y, z) {
    if (y === 1) {
      z.px(this);
      return Unit_instance;
    }
    if (y === 0) {
      z.u4();
      return Unit_instance;
    }
    var ylong = fromInt_0(y) & 4294967295n;
    var tmp;
    if (z.mr_1.length < (this.nr_1 + 1 | 0)) {
      tmp = new Int32Array(this.nr_1 + 1 | 0);
    } else {
      tmp = z.mr_1;
    }
    var zval = tmp;
    var carry = 0n;
    var inductionVariable = this.nr_1 - 1 | 0;
    if (0 <= inductionVariable)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + -1 | 0;
        var product = add_0(multiply_0(ylong, fromInt_0(this.mr_1[i + this.pr_1 | 0]) & 4294967295n), carry);
        zval[i + 1 | 0] = convertToInt(product);
        carry = shiftRightUnsigned(product, 32);
      }
       while (0 <= inductionVariable);
    if (carry === 0n) {
      z.pr_1 = 1;
      z.nr_1 = this.nr_1;
    } else {
      z.pr_1 = 0;
      z.nr_1 = this.nr_1 + 1 | 0;
      zval[0] = convertToInt(carry);
    }
    z.mr_1 = zval;
  }
  sr(divisor, quotient) {
    var divisorLong = fromInt_0(divisor) & 4294967295n;
    if (this.nr_1 === 1) {
      var dividendValue = fromInt_0(this.mr_1[this.pr_1]) & 4294967295n;
      var q = convertToInt(divide(dividendValue, divisorLong));
      var r = convertToInt(subtract_0(dividendValue, multiply_0(numberToLong(q), divisorLong)));
      quotient.mr_1[0] = q;
      quotient.nr_1 = q === 0 ? 0 : 1;
      quotient.pr_1 = 0;
      return r;
    }
    if (quotient.mr_1.length < this.nr_1) {
      quotient.mr_1 = new Int32Array(this.nr_1);
    }
    quotient.pr_1 = 0;
    quotient.nr_1 = this.nr_1;
    var shift = numberOfLeadingZeros(divisor);
    var rem = this.mr_1[this.pr_1];
    var remLong = fromInt_0(rem) & 4294967295n;
    if (remLong < divisorLong) {
      quotient.mr_1[0] = 0;
    } else {
      quotient.mr_1[0] = convertToInt(divide(remLong, divisorLong));
      rem = convertToInt(subtract_0(remLong, multiply_0(numberToLong(quotient.mr_1[0]), divisorLong)));
      remLong = fromInt_0(rem) & 4294967295n;
    }
    var xlen = this.nr_1;
    $l$loop: while (true) {
      xlen = xlen - 1 | 0;
      if (!(xlen > 0)) {
        break $l$loop;
      }
      var dividendEstimate = shiftLeft(remLong, 32) | fromInt_0(this.mr_1[(this.pr_1 + this.nr_1 | 0) - xlen | 0]) & 4294967295n;
      var q_0;
      if (dividendEstimate >= 0n) {
        q_0 = convertToInt(divide(dividendEstimate, divisorLong));
        rem = convertToInt(subtract_0(dividendEstimate, multiply_0(numberToLong(q_0), divisorLong)));
      } else {
        var tmp = Companion_getInstance_24().uw(dividendEstimate, divisor);
        q_0 = convertToInt(tmp & 4294967295n);
        rem = convertToInt(shiftRightUnsigned(tmp, 32));
      }
      quotient.mr_1[this.nr_1 - xlen | 0] = q_0;
      remLong = fromInt_0(rem) & 4294967295n;
    }
    quotient.vv();
    var tmp_0;
    if (shift > 0) {
      tmp_0 = rem % divisor | 0;
    } else {
      tmp_0 = rem;
    }
    return tmp_0;
  }
  sx(b, quotient, needRemainder) {
    var bLenBelowThreshold = b.nr_1 < 80;
    var lenDiffIsZieglerOffset = (this.nr_1 - b.nr_1 | 0) < 40;
    var tmp;
    if (bLenBelowThreshold || lenDiffIsZieglerOffset) {
      tmp = this.rv(b, quotient, needRemainder);
    } else {
      tmp = this.tv(b, quotient);
    }
    return tmp;
  }
  pu(b, quotient, needRemainder, $super) {
    needRemainder = needRemainder === VOID ? true : needRemainder;
    return $super === VOID ? this.sx(b, quotient, needRemainder) : $super.sx.call(this, b, quotient, needRemainder);
  }
  rv(b, quotient, needRemainder) {
    var b_0 = b;
    if (b_0.nr_1 === 0) {
      throw ArithmeticException.cc('BigInteger div by zero');
    }
    if (this.nr_1 === 0) {
      quotient.pr_1 = 0;
      quotient.nr_1 = quotient.pr_1;
      return needRemainder ? MutableBigInteger.rr() : null;
    }
    var cmp = this.nw(b_0);
    if (cmp < 0) {
      quotient.pr_1 = 0;
      quotient.nr_1 = quotient.pr_1;
      return needRemainder ? MutableBigInteger.ow(this) : null;
    }
    if (cmp === 0) {
      quotient.nr_1 = 1;
      quotient.mr_1[0] = quotient.nr_1;
      quotient.pr_1 = 0;
      return needRemainder ? MutableBigInteger.rr() : null;
    }
    quotient.u4();
    if (b_0.nr_1 === 1) {
      var r = this.sr(b_0.mr_1[b_0.pr_1], quotient);
      var tmp;
      if (needRemainder) {
        tmp = r === 0 ? MutableBigInteger.rr() : MutableBigInteger.jx(r);
      } else {
        tmp = null;
      }
      return tmp;
    }
    if (this.nr_1 >= Companion_getInstance_24().iu_1) {
      var tmp0 = _get_lowestSetBit__xjmtq_0(this);
      // Inline function 'kotlin.math.min' call
      var b_1 = _get_lowestSetBit__xjmtq_0(b_0);
      var trailingZeroBits = Math.min(tmp0, b_1);
      if (trailingZeroBits >= imul_0(Companion_getInstance_24().ju_1, 32)) {
        var a = MutableBigInteger.ow(this);
        b_0 = MutableBigInteger.ow(b_0);
        a.vw(trailingZeroBits);
        b_0.vw(trailingZeroBits);
        var r_0 = a.sv(b_0, quotient);
        ensureNotNull(r_0).rw(trailingZeroBits);
        return r_0;
      }
    }
    return divideMagnitude(this, b_0, quotient, needRemainder);
  }
  sv(b, quotient, needRemainder, $super) {
    needRemainder = needRemainder === VOID ? true : needRemainder;
    return $super === VOID ? this.rv(b, quotient, needRemainder) : $super.rv.call(this, b, quotient, needRemainder);
  }
  tv(b, quotient) {
    var r = this.nr_1;
    var s = b.nr_1;
    quotient.nr_1 = 0;
    quotient.pr_1 = quotient.nr_1;
    if (r < s) {
      return this;
    } else {
      var m = 1 << (32 - numberOfLeadingZeros(s / 80 | 0) | 0);
      var j = ((s + m | 0) - 1 | 0) / m | 0;
      var n = imul_0(j, m);
      // Inline function 'kotlin.Long.times' call
      var n32 = multiply_0(32n, fromInt_0(n));
      // Inline function 'kotlin.math.max' call
      var b_0 = subtract_0(n32, b.tx());
      var tmp$ret$1 = 0n >= b_0 ? 0n : b_0;
      var sigma = convertToInt(tmp$ret$1);
      var bShifted = MutableBigInteger.ow(b);
      bShifted.qx(sigma);
      var aShifted = MutableBigInteger.ow(this);
      aShifted.qx(sigma);
      var t = convertToInt(divide(add_0(aShifted.tx(), n32), n32));
      if (t < 2) {
        t = 2;
      }
      var a1 = getBlock(aShifted, t - 1 | 0, t, n);
      var z = getBlock(aShifted, t - 2 | 0, t, n);
      z.qw(a1, n);
      var qi = MutableBigInteger.rr();
      var ri;
      var inductionVariable = t - 2 | 0;
      if (1 <= inductionVariable)
        do {
          var i = inductionVariable;
          inductionVariable = inductionVariable + -1 | 0;
          ri = divide2n1n(z, bShifted, qi);
          z = getBlock(aShifted, i - 1 | 0, t, n);
          z.qw(ri, n);
          quotient.rx(qi, imul_0(i, n));
        }
         while (1 <= inductionVariable);
      ri = divide2n1n(z, bShifted, qi);
      quotient.ku(qi);
      ensureNotNull(ri).vw(sigma);
      return ri;
    }
  }
  tx() {
    var tmp;
    if (this.nr_1 === 0) {
      tmp = 0n;
    } else {
      var tmp0 = multiply_0(numberToLong(this.nr_1), 32n);
      // Inline function 'kotlin.Long.minus' call
      var other = numberOfLeadingZeros(this.mr_1[this.pr_1]);
      tmp = subtract_0(tmp0, fromInt_0(other));
    }
    return tmp;
  }
  gu(v, quotient) {
    var v_0 = v;
    if (v_0 === 0n) {
      throw ArithmeticException.cc('BigInteger div by zero');
    }
    if (this.nr_1 === 0) {
      quotient.pr_1 = 0;
      quotient.nr_1 = quotient.pr_1;
      return 0n;
    }
    if (v_0 < 0n) {
      v_0 = negate_0(v_0);
    }
    var d = convertToInt(shiftRightUnsigned(v_0, 32));
    quotient.u4();
    var tmp;
    if (d === 0) {
      tmp = fromInt_0(this.sr(convertToInt(v_0), quotient)) & 4294967295n;
    } else {
      tmp = toLong(divideLongMagnitude(this, v_0, quotient));
    }
    return tmp;
  }
  cw() {
    if (this.qu()) {
      return MutableBigInteger.jx(0);
    } else if (this.mr_1.length === 1 && (fromInt_0(this.mr_1[0]) & 4294967295n) < 4n) {
      return Companion_getInstance_24().hu_1;
    }
    if (this.tx() <= 63n) {
      var v = CommonBigInteger.ov(this.mr_1, 1).toLongExact();
      // Inline function 'kotlin.math.sqrt' call
      var x = toNumber_0(v);
      // Inline function 'kotlin.math.floor' call
      var x_0 = Math.sqrt(x);
      var tmp$ret$1 = Math.floor(x_0);
      var xk = numberToLong(tmp$ret$1);
      do {
        // Inline function 'kotlin.Long.div' call
        var this_0 = add_0(xk, divide(v, xk));
        var xk1 = divide(this_0, fromInt_0(2));
        if (xk1 >= xk) {
          // Inline function 'kotlin.intArrayOf' call
          var tmp$ret$3 = new Int32Array([convertToInt(shiftRightUnsigned(xk, 32)), convertToInt(xk & 4294967295n)]);
          return MutableBigInteger.fu(tmp$ret$3);
        }
        xk = xk1;
      }
       while (true);
    } else {
      var bitLength = convertToInt(this.tx());
      if (!(fromInt_0(bitLength) === this.tx())) {
        throw ArithmeticException.cc('bitLength() integer overflow');
      }
      var shift = bitLength - 63 | 0;
      if ((shift % 2 | 0) === 1) {
        shift = shift + 1 | 0;
      }
      var xk_0 = MutableBigInteger.ow(this);
      xk_0.vw(shift);
      xk_0.vv();
      var d = CommonBigInteger.ov(xk_0.mr_1, 1).toDouble();
      var tmp = Companion_getInstance_22();
      // Inline function 'kotlin.math.sqrt' call
      // Inline function 'kotlin.math.ceil' call
      var x_1 = Math.sqrt(d);
      var tmp$ret$5 = Math.ceil(x_1);
      var bi = tmp.ofLong(numberToLong(tmp$ret$5));
      xk_0 = MutableBigInteger.fu(bi.vr_1);
      xk_0.rw(shift / 2 | 0);
      var xk1_0 = MutableBigInteger.rr();
      do {
        this.sx(xk_0, xk1_0, false);
        xk1_0.ku(xk_0);
        xk1_0.vw(1);
        if (xk1_0.nw(xk_0) >= 0) {
          return xk_0;
        }
        xk_0.px(xk1_0);
        xk1_0.nx();
      }
       while (true);
    }
  }
  ew(b) {
    var b_0 = b;
    var a = this;
    var q = MutableBigInteger.rr();
    while (!(ensureNotNull(b_0).nr_1 === 0)) {
      if (abs_0(a.nr_1 - b_0.nr_1 | 0) < 2) {
        return binaryGCD(a, b_0);
      }
      var r = a.pu(b_0, q);
      a = b_0;
      b_0 = r;
    }
    return a;
  }
  gw(p) {
    if (p.ou()) {
      return modInverse(this, p);
    }
    if (this.dx()) {
      throw ArithmeticException.cc('BigInteger not invertible.');
    }
    var powersOf2 = _get_lowestSetBit__xjmtq_0(p);
    var oddMod = MutableBigInteger.ow(p);
    oddMod.vw(powersOf2);
    if (oddMod.ex()) {
      return this.ux(powersOf2);
    }
    var oddPart = modInverse(this, oddMod);
    var evenPart = this.ux(powersOf2);
    var y1 = Companion_getInstance_24().lx(oddMod, powersOf2);
    var y2 = oddMod.ux(powersOf2);
    var temp1 = MutableBigInteger.rr();
    var temp2 = MutableBigInteger.rr();
    var result = MutableBigInteger.rr();
    oddPart.rw(powersOf2);
    oddPart.fw(y1, result);
    evenPart.fw(oddMod, temp1);
    temp1.fw(y2, temp2);
    result.ku(temp2);
    return result.pu(p, temp1);
  }
  ux(k) {
    if (this.dx()) {
      throw ArithmeticException.cc('Non-invertible. (GCD != 1)');
    }
    if (k > 64) {
      return this.vx(k);
    }
    var t = Companion_getInstance_24().kx(this.mr_1[(this.pr_1 + this.nr_1 | 0) - 1 | 0]);
    if (k < 33) {
      t = k === 32 ? t : t & ((1 << k) - 1 | 0);
      return MutableBigInteger.jx(t);
    }
    var pLong = fromInt_0(this.mr_1[(this.pr_1 + this.nr_1 | 0) - 1 | 0]) & 4294967295n;
    if (this.nr_1 > 1) {
      pLong = pLong | shiftLeft(fromInt_0(this.mr_1[(this.pr_1 + this.nr_1 | 0) - 2 | 0]), 32);
    }
    var tLong = fromInt_0(t) & 4294967295n;
    tLong = multiply_0(tLong, subtract_0(numberToLong(2), multiply_0(pLong, tLong)));
    var tmp;
    if (k === 64) {
      tmp = tLong;
    } else {
      var tmp_0 = tLong;
      // Inline function 'kotlin.Long.minus' call
      var this_0 = shiftLeft(1n, k);
      tmp = tmp_0 & subtract_0(this_0, fromInt_0(1));
    }
    tLong = tmp;
    var result = MutableBigInteger.fu(new Int32Array(2));
    result.mr_1[0] = convertToInt(shiftRightUnsigned(tLong, 32));
    result.mr_1[1] = convertToInt(tLong);
    result.nr_1 = 2;
    result.vv();
    return result;
  }
  vx(k) {
    var b = MutableBigInteger.jx(1);
    ensureNotNull(b).rw(k);
    var mod = MutableBigInteger.ow(b);
    var a = MutableBigInteger.ow(this);
    var q = MutableBigInteger.rr();
    var r = b.pu(a, q);
    var swapper = b;
    b = r;
    r = swapper;
    var t1 = MutableBigInteger.ow(q);
    var t0 = MutableBigInteger.jx(1);
    var temp = MutableBigInteger.rr();
    while (!ensureNotNull(b).ex()) {
      r = a.pu(b, q);
      if (ensureNotNull(r).nr_1 === 0) {
        throw ArithmeticException.cc('BigInteger not invertible.');
      }
      swapper = r;
      a = swapper;
      if (q.nr_1 === 1) {
        t1.mx(q.mr_1[q.pr_1], temp);
      } else {
        q.fw(t1, temp);
      }
      swapper = q;
      q = temp;
      temp = swapper;
      t0.ku(q);
      if (a.ex()) {
        return t0;
      }
      r = b.pu(a, q);
      if (ensureNotNull(r).nr_1 === 0) {
        throw ArithmeticException.cc('BigInteger not invertible.');
      }
      swapper = b;
      b = r;
      if (q.nr_1 === 1) {
        t0.mx(q.mr_1[q.pr_1], temp);
      } else {
        q.fw(t0, temp);
      }
      swapper = q;
      q = temp;
      temp = swapper;
      t1.ku(q);
    }
    mod.sw(t1);
    return mod;
  }
}
class Companion_25 {
  valueOfInt(rm) {
    return values()[rm];
  }
}
class RoundingMode extends Enum {
  constructor(name, ordinal, value) {
    super(name, ordinal);
    this.value = value;
  }
  z2() {
    return this.value;
  }
  get name() {
    return this.h3();
  }
  get ordinal() {
    return this.i3();
  }
}
class SignedMutableBigInteger extends MutableBigInteger {
  static cx() {
    var $this = this.rr();
    init_com_macrofocus_common_math_big_SignedMutableBigInteger($this);
    return $this;
  }
  static bx(val) {
    var $this = this.jx(val);
    init_com_macrofocus_common_math_big_SignedMutableBigInteger($this);
    return $this;
  }
  fx(addend) {
    if (this.ax_1 === addend.ax_1) {
      this.ku(addend);
    } else {
      this.ax_1 = imul_0(this.ax_1, this.sw(addend));
    }
  }
  hx(addend) {
    if (this.ax_1 === 1) {
      this.ku(addend);
    } else {
      this.ax_1 = imul_0(this.ax_1, this.sw(addend));
    }
  }
  gx(addend) {
    if (this.ax_1 === addend.ax_1) {
      this.ax_1 = imul_0(this.ax_1, this.sw(addend));
    } else {
      this.ku(addend);
    }
  }
  toString() {
    return this.lu(this.ax_1).toString();
  }
}
class AbstractProperty {
  constructor($box) {
    boxApply(this, $box);
    var tmp = this;
    tmp.wx_1 = lazy(AbstractProperty$listernersDelegate$lambda);
    this.xx_1 = this.wx_1;
  }
  zo(listener) {
    _get_listeners__760gzy(this).c1(listener);
  }
  yx(listener) {
    var weakListener = new WeakPropertyListener(this, listener);
    this.zo(weakListener);
  }
  zx(listener) {
    _get_listeners__760gzy(this).e3(listener);
  }
  ay(event) {
    if (this.wx_1.ri()) {
      var _iterator__ex2g4s = _get_listeners__760gzy(this).h1();
      while (_iterator__ex2g4s.i1()) {
        var listener = _iterator__ex2g4s.j1();
        listener.vo(event);
      }
    }
  }
}
class MutableProperty {}
function getValue(thisRef, property) {
  return this.z2();
}
function setValue(thisRef, property, value) {
  this.ap(value);
}
class AbstractMutableProperty extends AbstractProperty {}
class WeakPropertiesListener {
  constructor($outer, listener) {
    this.dy_1 = $outer;
    this.cy_1 = new WeakReference(listener);
  }
  ey(name, event) {
    var l = this.jk();
    if (!(l == null)) {
      l.ey(name, event);
    } else {
      this.dy_1.gy(this);
    }
  }
  jk() {
    return this.cy_1.zj();
  }
  toString() {
    var l = this.jk();
    var tmp;
    if (!(l == null)) {
      tmp = 'Weak[' + toString_1(l) + ']';
    } else {
      tmp = toString_0(l);
    }
    return tmp;
  }
}
class AbstractProperties {
  constructor() {
    this.fy_1 = CollectionFactory_instance.nk();
  }
  hy(listener) {
    this.fy_1.c1(listener);
  }
  iy(listener) {
    var weakListener = new WeakPropertiesListener(this, listener);
    this.fy_1.c1(weakListener);
  }
  gy(listener) {
    if (listener instanceof WeakPropertiesListener) {
      var removed = this.fy_1.e3(listener);
    } else {
      var toRemove = null;
      var _iterator__ex2g4s = this.fy_1.h1();
      while (_iterator__ex2g4s.i1()) {
        var propertiesListener = _iterator__ex2g4s.j1();
        var comparable;
        if (propertiesListener instanceof WeakPropertiesListener) {
          comparable = propertiesListener.jk();
        } else {
          comparable = propertiesListener;
        }
        if (equals(listener, comparable)) {
          toRemove = propertiesListener;
        }
      }
      if (!(toRemove == null)) {
        var removed_0 = this.fy_1.e3(toRemove);
      }
    }
    this.fy_1.e3(listener);
  }
  jy(name, event) {
    var _iterator__ex2g4s = this.fy_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var listener = _iterator__ex2g4s.j1();
      listener.ey(name, event);
    }
  }
}
class WeakPropertyListener {
  constructor($outer, listener) {
    this.my_1 = $outer;
    this.ly_1 = new WeakReference(listener);
  }
  vo(event) {
    var l = _get_reference__19y5ba(this);
    if (!(l == null)) {
      l.vo(event);
    } else {
      this.my_1.zx(isInterface(this, PropertyListener) ? this : THROW_CCE());
    }
  }
  toString() {
    var l = _get_reference__19y5ba(this);
    var tmp;
    if (!(l == null)) {
      tmp = 'Weak[' + toString_1(l) + ']';
    } else {
      tmp = toString_0(l);
    }
    return tmp;
  }
}
class EnumProperties$ExposedProperty$listener$1 {
  constructor(this$0) {
    this.ny_1 = this$0;
  }
  vo(event) {
    this.ny_1.ay(event);
  }
}
class NamedPropertyListener {
  constructor($outer, name) {
    this.py_1 = $outer;
    this.oy_1 = name;
  }
  qy(event) {
    this.py_1.jy(this.oy_1, event);
  }
  vo(event) {
    return this.qy(event);
  }
}
class ExposedProperty extends AbstractMutableProperty {
  constructor($outer, secret, $box) {
    if ($box === VOID)
      $box = {};
    $box.vy_1 = $outer;
    super($box);
    var tmp = this;
    tmp.uy_1 = new EnumProperties$ExposedProperty$listener$1(this);
    this.ty_1 = secret;
    this.ty_1.zo(this.uy_1);
  }
  ap(value) {
    this.ty_1.ap(value);
  }
  z2() {
    return this.ty_1.z2();
  }
}
class EnumProperties extends AbstractProperties {
  constructor(enums) {
    super();
    this.xy_1 = new EnumMap(enums);
    this.yy_1 = new EnumMap(enums);
  }
  h1() {
    return this.xy_1.m6().h1();
  }
  zy(name, value) {
    var property = Companion_instance_27.newInstance(value);
    return this.az(name, property);
  }
  bz(name, value) {
    var tmp = name instanceof Enum ? name : THROW_CCE();
    return this.zy(tmp, (value == null ? true : !(value == null)) ? value : THROW_CCE());
  }
  az(name, property) {
    var exposedProperty = new ExposedProperty(this, isInterface(property, MutableProperty) ? property : THROW_CCE());
    // Inline function 'kotlin.collections.set' call
    this.xy_1.o6(name, exposedProperty);
    var listener = new NamedPropertyListener(this, name);
    exposedProperty.zo(listener);
    // Inline function 'kotlin.collections.set' call
    this.yy_1.o6(name, listener);
    return isInterface(exposedProperty, MutableProperty) ? exposedProperty : THROW_CCE();
  }
  cz(name, property) {
    return this.az(name instanceof Enum ? name : THROW_CCE(), property);
  }
  dz(name) {
    return ensureNotNull(this.xy_1.ij(name)).z2();
  }
  ky(name) {
    return this.dz(name instanceof Enum ? name : THROW_CCE());
  }
  ez(name) {
    return ensureNotNull(this.xy_1.ij(name));
  }
  fz(name) {
    return this.ez(name instanceof Enum ? name : THROW_CCE());
  }
}
class KReadWriteProperty {
  constructor(property) {
    this.gz_1 = property;
  }
  bf(thisRef, property) {
    return this.gz_1.z2();
  }
  cf(thisRef, property) {
    return this.bf((thisRef == null ? true : !(thisRef == null)) ? thisRef : THROW_CCE(), property);
  }
  by(thisRef, property, value) {
    this.gz_1.ap(value);
  }
  ef(thisRef, property, value) {
    var tmp = (thisRef == null ? true : !(thisRef == null)) ? thisRef : THROW_CCE();
    return this.by(tmp, property, (value == null ? true : !(value == null)) ? value : THROW_CCE());
  }
}
class Companion_26 {
  constructor() {
    this.hz_1 = 'overrideDefaults';
  }
}
class OverrideProperties$registerPropertyListener$1 {
  constructor(this$0, $name) {
    this.iz_1 = this$0;
    this.jz_1 = $name;
  }
  qy(event) {
    this.iz_1.jy(this.jz_1, new PropertyEvent(event.oldValue, event.newValue));
  }
  vo(event) {
    return this.qy(event);
  }
}
class OverrideProperties extends AbstractProperties {
  constructor(defaults, overrideDefaults) {
    super();
    this.lz_1 = defaults;
    this.mz_1 = overrideDefaults;
    this.nz_1 = HashMap.i7();
    this.oz_1 = HashMap.i7();
  }
  h1() {
    return this.lz_1.h1();
  }
  bz(name, value) {
    throw UnsupportedOperationException.q3();
  }
  cz(name, property) {
    throw UnsupportedOperationException.q3();
  }
  ky(name) {
    return this.mz_1.z2() && this.nz_1.a3(name) ? ensureNotNull(this.nz_1.c3(name)).z2() : this.lz_1.ky(name);
  }
  fz(name) {
    var tmp;
    if (this.nz_1.a3(name)) {
      tmp = ensureNotNull(this.nz_1.c3(name));
    } else {
      var property = this.vz(name, this.mz_1, this.lz_1.fz(name));
      this.wz(name, property);
      // Inline function 'kotlin.collections.set' call
      this.nz_1.o6(name, property);
      tmp = property;
    }
    return tmp;
  }
  wz(name, property) {
    property.zo(new OverrideProperties$registerPropertyListener$1(this, name));
  }
  vz(name, overrideDefaults, defaultProperty) {
    return new OverrideProperty(overrideDefaults, defaultProperty);
  }
  nx() {
    var _iterator__ex2g4s = this.nz_1.n6().h1();
    while (_iterator__ex2g4s.i1()) {
      var property = _iterator__ex2g4s.j1();
      if (property instanceof OverrideProperty) {
        ensureNotNull(property instanceof OverrideProperty ? property : THROW_CCE()).nx();
      }
    }
  }
}
class OverrideProperty$overridePropertyListener$1 {
  constructor($overrideDefaults, this$0) {
    this.xz_1 = $overrideDefaults;
    this.yz_1 = this$0;
  }
  vo(event) {
    if (this.xz_1.z2()) {
      this.yz_1.ay(new PropertyEvent(event.oldValue, event.newValue));
    }
  }
}
class OverrideProperty$1 {
  constructor($defaultProperty, this$0) {
    this.zz_1 = $defaultProperty;
    this.a10_1 = this$0;
  }
  b10(event) {
    var defaultValue = this.zz_1.z2();
    var overrideValue = !(this.a10_1.tz_1 == null) ? ensureNotNull(this.a10_1.tz_1).z2() : defaultValue;
    if (!(defaultValue === overrideValue)) {
      if (event.newValue) {
        this.a10_1.ay(new PropertyEvent(defaultValue, overrideValue));
      } else {
        this.a10_1.ay(new PropertyEvent(overrideValue, defaultValue));
      }
    }
  }
  vo(event) {
    return this.b10(event);
  }
}
class OverrideProperty$2 {
  constructor($overrideDefaults, this$0) {
    this.c10_1 = $overrideDefaults;
    this.d10_1 = this$0;
  }
  vo(event) {
    if (!this.c10_1.z2()) {
      this.d10_1.ay(new PropertyEvent(event.oldValue, event.newValue));
    }
  }
}
class OverrideProperty extends AbstractMutableProperty {
  constructor(overrideDefaults, defaultProperty) {
    super();
    this.rz_1 = overrideDefaults;
    this.sz_1 = defaultProperty;
    this.tz_1 = null;
    var tmp = this;
    tmp.uz_1 = new OverrideProperty$overridePropertyListener$1(overrideDefaults, this);
    overrideDefaults.zo(new OverrideProperty$1(defaultProperty, this));
    defaultProperty.zo(new OverrideProperty$2(overrideDefaults, this));
  }
  e10() {
    return this.sz_1;
  }
  f10() {
    if (this.tz_1 == null) {
      this.tz_1 = this.g10();
    }
    return this.tz_1;
  }
  g10() {
    var overrideProperty = Companion_instance_27.newInstance(this.e10().z2());
    return this.h10(overrideProperty);
  }
  h10(overrideProperty) {
    overrideProperty.zo(this.uz_1);
    return overrideProperty;
  }
  i10(overrideProperty) {
    overrideProperty.zx(this.uz_1);
  }
  ap(value) {
    if (this.rz_1.z2()) {
      ensureNotNull(this.f10()).ap(value);
    } else {
      this.e10().ap(value);
    }
  }
  z2() {
    var tmp;
    if (this.rz_1.z2() && !(this.tz_1 == null)) {
      tmp = ensureNotNull(this.tz_1).z2();
    } else {
      tmp = this.e10().z2();
    }
    return tmp;
  }
  j10() {
    var tmp;
    if (this.rz_1.z2() && !(this.tz_1 == null)) {
      tmp = ensureNotNull(this.tz_1).z2();
    } else {
      tmp = null;
    }
    return tmp;
  }
  nx() {
    if (this.rz_1.z2() && !(this.tz_1 == null)) {
      var oldValue = ensureNotNull(this.tz_1).z2();
      var newValue = this.e10().z2();
      this.i10(ensureNotNull(this.tz_1));
      this.tz_1 = null;
      if (!(oldValue === newValue)) {
        this.ay(new PropertyEvent(oldValue, newValue));
      }
    }
    this.tz_1 = null;
  }
}
class PropertyDelegates$mutable$1 extends KReadWriteProperty {}
class PropertyDelegates {
  k10(property) {
    return new PropertyDelegates$mutable$1(property);
  }
}
class PropertyEvent {
  constructor(oldValue, newValue) {
    this.oldValue = oldValue;
    this.newValue = newValue;
  }
  l10() {
    return this.oldValue;
  }
  m10() {
    return this.newValue;
  }
  toString() {
    return 'PropertyEvent{oldValue=' + this.oldValue + ', newValue=' + this.newValue + toString(_Char___init__impl__6a9atx(125));
  }
  mi() {
    return this.oldValue;
  }
  ni() {
    return this.newValue;
  }
  n10(oldValue, newValue) {
    return new PropertyEvent(oldValue, newValue);
  }
  copy(oldValue, newValue, $super) {
    oldValue = oldValue === VOID ? this.oldValue : oldValue;
    newValue = newValue === VOID ? this.newValue : newValue;
    return $super === VOID ? this.n10(oldValue, newValue) : $super.n10.call(this, oldValue, newValue);
  }
  hashCode() {
    var result = this.oldValue == null ? 0 : hashCode(this.oldValue);
    result = imul_0(result, 31) + (this.newValue == null ? 0 : hashCode(this.newValue)) | 0;
    return result;
  }
  equals(other) {
    if (this === other)
      return true;
    if (!(other instanceof PropertyEvent))
      return false;
    if (!equals(this.oldValue, other.oldValue))
      return false;
    if (!equals(this.newValue, other.newValue))
      return false;
    return true;
  }
}
class SimpleProperties$ExposedProperty$listener$1 {
  constructor(this$0) {
    this.o10_1 = this$0;
  }
  vo(event) {
    this.o10_1.ay(event);
  }
}
class NamedPropertyListener_0 {
  constructor($outer, name) {
    this.q10_1 = $outer;
    this.p10_1 = name;
  }
  qy(event) {
    this.q10_1.jy(this.p10_1, event);
  }
  vo(event) {
    return this.qy(event);
  }
}
class ExposedProperty_0 extends AbstractMutableProperty {
  constructor($outer, secret, $box) {
    if ($box === VOID)
      $box = {};
    $box.v10_1 = $outer;
    super($box);
    var tmp = this;
    tmp.u10_1 = new SimpleProperties$ExposedProperty$listener$1(this);
    this.t10_1 = secret;
    this.t10_1.zo(this.u10_1);
  }
  ap(value) {
    this.t10_1.ap(value);
  }
  z2() {
    return this.t10_1.z2();
  }
}
class SimpleProperties extends AbstractProperties {
  constructor() {
    super();
    this.x10_1 = HashMap.i7();
    this.y10_1 = HashMap.i7();
  }
  h1() {
    return this.x10_1.m6().h1();
  }
  z10(name, value) {
    var property = Companion_instance_27.newInstance(value);
    return this.a11(name, property);
  }
  bz(name, value) {
    var tmp = (name == null ? true : typeof name === 'string') ? name : THROW_CCE();
    return this.z10(tmp, (value == null ? true : !(value == null)) ? value : THROW_CCE());
  }
  a11(name, property) {
    var exposedProperty = new ExposedProperty_0(this, isInterface(property, MutableProperty) ? property : THROW_CCE());
    // Inline function 'kotlin.collections.set' call
    this.x10_1.o6(name, exposedProperty);
    var listener = new NamedPropertyListener_0(this, name);
    exposedProperty.zo(listener);
    // Inline function 'kotlin.collections.set' call
    this.y10_1.o6(name, listener);
    return isInterface(exposedProperty, MutableProperty) ? exposedProperty : THROW_CCE();
  }
  cz(name, property) {
    return this.a11((name == null ? true : typeof name === 'string') ? name : THROW_CCE(), property);
  }
  b11(name) {
    return ensureNotNull(this.x10_1.c3(name)).z2();
  }
  ky(name) {
    return this.b11((name == null ? true : typeof name === 'string') ? name : THROW_CCE());
  }
  c11(name) {
    return ensureNotNull(this.x10_1.c3(name));
  }
  fz(name) {
    return this.c11((name == null ? true : typeof name === 'string') ? name : THROW_CCE());
  }
}
class Companion_27 {
  newInstance(value) {
    return new SimpleProperty(value);
  }
}
class SimpleProperty$value$$inlined$observable$1 extends ObservableProperty {
  constructor($initialValue, this$0, $box) {
    if ($box === VOID)
      $box = {};
    $box.e11_1 = this$0;
    super($initialValue, $box);
  }
  f11(property, oldValue, newValue) {
    if (!equals(oldValue, newValue)) {
      this.e11_1.ay(new PropertyEvent(oldValue, newValue));
    }
    return Unit_instance;
  }
  af(property, oldValue, newValue) {
    var tmp = (oldValue == null ? true : !(oldValue == null)) ? oldValue : THROW_CCE();
    return this.f11(property, tmp, (newValue == null ? true : !(newValue == null)) ? newValue : THROW_CCE());
  }
}
class SimpleProperty extends AbstractMutableProperty {
  constructor(value) {
    super();
    var tmp = this;
    // Inline function 'kotlin.properties.Delegates.observable' call
    tmp.i11_1 = new SimpleProperty$value$$inlined$observable$1(value, this);
  }
  ap(_set____db54di) {
    var tmp = KMutableProperty1;
    var tmp_0 = SimpleProperty$_get_value_$ref_rqcknm_0();
    return this.i11_1.ef(this, getPropertyCallableRef('value', 1, tmp, tmp_0, SimpleProperty$_set_value_$ref_1khvqy_0()), _set____db54di);
  }
  z2() {
    var tmp = KMutableProperty1;
    var tmp_0 = SimpleProperty$_get_value_$ref_rqcknm();
    return this.i11_1.cf(this, getPropertyCallableRef('value', 1, tmp, tmp_0, SimpleProperty$_set_value_$ref_1khvqy()));
  }
  toString() {
    return 'SimpleProperty{value=' + this.z2() + toString(_Char___init__impl__6a9atx(125));
  }
}
class StartEnd extends Enum {}
class BoundedIntervalProperty$1 {
  constructor(this$0) {
    this.j11_1 = this$0;
  }
  kn(event) {
    switch (this.j11_1.n11_1.g3_1) {
      case 0:
        this.j11_1.ay(new PropertyEvent(event.bo_1, event.eo_1));
        break;
      case 1:
        this.j11_1.ay(new PropertyEvent(ensureNotNull(event).co_1, event.fo_1));
        break;
      default:
        noWhenBranchMatchedException();
        break;
    }
  }
}
class BoundedIntervalProperty extends AbstractMutableProperty {
  constructor(interval, startEnd) {
    super();
    this.m11_1 = interval;
    this.n11_1 = startEnd;
    this.m11_1.addIntervalListener(new BoundedIntervalProperty$1(this));
  }
  o11(value) {
    switch (this.n11_1.g3_1) {
      case 0:
        this.m11_1.start = ensureNotNull(value);
        break;
      case 1:
        this.m11_1.end = ensureNotNull(value);
        break;
      default:
        noWhenBranchMatchedException();
        break;
    }
  }
  ap(_set____db54di) {
    return this.o11((_set____db54di == null ? true : typeof _set____db54di === 'number') ? _set____db54di : THROW_CCE());
  }
  z2() {
    var tmp;
    switch (this.n11_1.g3_1) {
      case 0:
        tmp = this.m11_1.start;
        break;
      case 1:
        tmp = this.m11_1.end;
        break;
      default:
        noWhenBranchMatchedException();
        break;
    }
    return tmp;
  }
}
class NumericTransform extends Enum {
  constructor(name, ordinal, shortName, transform, inverse, dtransform, dinverse, domain) {
    super(name, ordinal);
    this.p12_1 = shortName;
    this.q12_1 = transform;
    this.r12_1 = inverse;
    this.s12_1 = dtransform;
    this.t12_1 = dinverse;
    this.u12_1 = domain;
  }
}
class Probit {
  constructor() {
    this.p11_1 = 0.02425;
    this.q11_1 = 0.97575;
    this.r11_1 = -39.69683028665376;
    this.s11_1 = 220.9460984245205;
    this.t11_1 = -275.9285104469687;
    this.u11_1 = 138.357751867269;
    this.v11_1 = -30.66479806614716;
    this.w11_1 = 2.506628277459239;
    this.x11_1 = -54.47609879822406;
    this.y11_1 = 161.5858368580409;
    this.z11_1 = -155.6989798598866;
    this.a12_1 = 66.80131188771972;
    this.b12_1 = -13.28068155288572;
    this.c12_1 = -0.007784894002430293;
    this.d12_1 = -0.3223964580411365;
    this.e12_1 = -2.400758277161838;
    this.f12_1 = -2.549732539343734;
    this.g12_1 = 4.374664141464968;
    this.h12_1 = 2.938163982698783;
    this.i12_1 = 0.007784695709041462;
    this.j12_1 = 0.3224671290700398;
    this.k12_1 = 2.445134137142996;
    this.l12_1 = 3.754408661907416;
  }
  m12(d) {
    if (d <= 0 || d >= 1) {
      return (d - 0.5) / 0.0;
    } else if (d < 0.02425) {
      // Inline function 'kotlin.math.ln' call
      // Inline function 'kotlin.math.sqrt' call
      var x = -2 * Math.log(d);
      var q = Math.sqrt(x);
      return (((((-0.007784894002430293 * q + -0.3223964580411365) * q + -2.400758277161838) * q + -2.549732539343734) * q + 4.374664141464968) * q + 2.938163982698783) / ((((0.007784695709041462 * q + 0.3224671290700398) * q + 2.445134137142996) * q + 3.754408661907416) * q + 1);
    } else if (0.97575 < d) {
      // Inline function 'kotlin.math.ln' call
      var x_0 = 1 - d;
      // Inline function 'kotlin.math.sqrt' call
      var x_1 = -2 * Math.log(x_0);
      var q_0 = Math.sqrt(x_1);
      return -(((((-0.007784894002430293 * q_0 + -0.3223964580411365) * q_0 + -2.400758277161838) * q_0 + -2.549732539343734) * q_0 + 4.374664141464968) * q_0 + 2.938163982698783) / ((((0.007784695709041462 * q_0 + 0.3224671290700398) * q_0 + 2.445134137142996) * q_0 + 3.754408661907416) * q_0 + 1);
    } else {
      var q_1 = d - 0.5;
      var r = q_1 * q_1;
      return (((((-39.69683028665376 * r + 220.9460984245205) * r + -275.9285104469687) * r + 138.357751867269) * r + -30.66479806614716) * r + 2.506628277459239) * q_1 / (((((-54.47609879822406 * r + 161.5858368580409) * r + -155.6989798598866) * r + 66.80131188771972) * r + -13.28068155288572) * r + 1);
    }
  }
}
class AbstractSelection {
  static a13() {
    var $this = createThis(this);
    $this.y12_1 = true;
    $this.z12_1 = CollectionFactory_instance.nk();
    return $this;
  }
  b13() {
    return this.y12_1;
  }
  c13(listener) {
    this.z12_1.c1(listener);
  }
  d13(listener) {
    if (listener instanceof WeakSelectionListener) {
      var removed = this.z12_1.e3(listener);
    } else {
      var toRemove = null;
      var _iterator__ex2g4s = this.z12_1.h1();
      while (_iterator__ex2g4s.i1()) {
        var selectionListener = _iterator__ex2g4s.j1();
        var comparable;
        if (selectionListener instanceof WeakSelectionListener) {
          comparable = selectionListener.jk();
        } else {
          comparable = selectionListener;
        }
        if (equals(listener, comparable)) {
          toRemove = selectionListener;
        }
      }
      if (!(toRemove == null)) {
        var removed_0 = this.z12_1.e3(toRemove);
      }
    }
  }
  e13(event) {
    var _iterator__ex2g4s = this.z12_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var listener = _iterator__ex2g4s.j1();
      listener.b14(event);
    }
  }
}
class AbstractMutableSelection extends AbstractSelection {
  static x12() {
    return this.a13();
  }
  b13() {
    return super.b13();
  }
}
class WeakSingleSelectionListener {
  p13() {
    return this.o13_1.zj();
  }
}
class AbstractMutableSingleSelection extends AbstractMutableSelection {
  static t13() {
    var $this = this.x12();
    $this.s13_1 = CollectionFactory_instance.nk();
    return $this;
  }
  u13(listener) {
    this.s13_1.c1(listener);
  }
  v13(listener) {
    if (listener instanceof WeakSingleSelectionListener) {
      var removed = this.s13_1.e3(listener);
    } else {
      var toRemove = null;
      var _iterator__ex2g4s = this.s13_1.h1();
      while (_iterator__ex2g4s.i1()) {
        var selectionListener = _iterator__ex2g4s.j1();
        var comparable;
        var tmp;
        if (selectionListener instanceof WeakSingleSelectionListener) {
          tmp = selectionListener.p13();
        } else {
          tmp = selectionListener;
        }
        comparable = tmp;
        if (equals(listener, comparable)) {
          toRemove = selectionListener;
        }
      }
      if (!(toRemove == null)) {
        var removed_0 = this.s13_1.e3(toRemove);
      }
    }
  }
  w13(event) {
    var _iterator__ex2g4s = this.s13_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var listener = _iterator__ex2g4s.j1();
      listener.x13(event);
    }
    super.e13(event);
  }
}
class WeakSelectionListener {
  jk() {
    return this.a14_1.zj();
  }
}
class AbstractSelectionEvent {}
class PropertySelection$1 {
  constructor(this$0, $self) {
    this.c14_1 = this$0;
    this.d14_1 = $self;
  }
  e14(event) {
    this.c14_1.e13(new SimpleSelectionEvent(this.d14_1, union(toSet_0(event.newValue), toSet_0(event.oldValue))));
  }
  vo(event) {
    return this.e14(event);
  }
}
class PropertySelection extends AbstractMutableSelection {
  static i14(property) {
    var $this = this.x12();
    $this.h14_1 = property;
    var self_0 = $this;
    $this.h14_1.zo(new PropertySelection$1($this, self_0));
    return $this;
  }
  i13() {
    var tmp;
    if (this.b13() && this.f13()) {
      this.h14_1.ap(emptyList());
      tmp = true;
    } else {
      tmp = false;
    }
    return tmp;
  }
  f13() {
    var tmp;
    // Inline function 'kotlin.collections.isNotEmpty' call
    if (!this.h14_1.z2().p1()) {
      tmp = this.b13();
    } else {
      tmp = false;
    }
    return tmp;
  }
  g13(element) {
    return equals(this.h14_1.z2(), element);
  }
  j13(element) {
    if (!this.h14_1.z2().q2(element)) {
      this.h14_1.ap(plus(this.h14_1.z2(), element));
    }
  }
  k13(element, selected) {
    if (this.b13()) {
      if (selected) {
        if (!this.h14_1.z2().q2(element)) {
          this.h14_1.ap(plus(this.h14_1.z2(), element));
        }
      } else {
        if (this.h14_1.z2().q2(element)) {
          this.h14_1.ap(minus(this.h14_1.z2(), element));
        }
      }
    }
  }
  l13(element, selected) {
    throw UnsupportedOperationException.q3();
  }
  m13(elements) {
    throw UnsupportedOperationException.q3();
  }
  n13(elements) {
    throw UnsupportedOperationException.q3();
  }
  h13() {
    return this.f13() ? 1 : 0;
  }
  h1() {
    return this.h14_1.z2().h1();
  }
}
class PropertySingleSelection$iterator$1 {
  constructor(this$0) {
    this.k14_1 = this$0;
    this.j14_1 = this$0.f13();
  }
  i1() {
    return !this.j14_1;
  }
  j1() {
    this.j14_1 = true;
    return ensureNotNull(this.k14_1.z13());
  }
}
class PropertySingleSelection$1 {
  constructor(this$0, $self) {
    this.p14_1 = this$0;
    this.q14_1 = $self;
  }
  r14(event) {
    this.p14_1.w13(new SingleSelectionEvent(this.q14_1, !(event.oldValue == null), !(event.newValue == null), event.oldValue, event.newValue));
  }
  vo(event) {
    return this.r14(event);
  }
}
class PropertySingleSelection extends AbstractMutableSingleSelection {
  static s14(property) {
    var $this = this.t13();
    $this.o14_1 = property;
    var self_0 = $this;
    $this.o14_1.zo(new PropertySingleSelection$1($this, self_0));
    return $this;
  }
  i13() {
    var tmp;
    if (this.b13() && this.f13()) {
      this.t14(null);
      tmp = true;
    } else {
      tmp = false;
    }
    return tmp;
  }
  f13() {
    return !(this.z13() == null) && this.b13();
  }
  g13(element) {
    return equals(this.o14_1.z2(), element);
  }
  j13(element) {
    this.y13(element);
  }
  k13(element, selected) {
    if (this.b13()) {
      if (selected) {
        this.y13(element);
      } else {
        if (this.g13(element)) {
          this.i13();
        }
      }
    }
  }
  l13(element, selected) {
    throw UnsupportedOperationException.q3();
  }
  m13(elements) {
    throw UnsupportedOperationException.q3();
  }
  n13(elements) {
    throw UnsupportedOperationException.q3();
  }
  y13(element) {
    this.t14(element);
  }
  z13() {
    return this.o14_1.z2();
  }
  t14(element) {
    if (this.b13()) {
      if (!(this.z13() === element)) {
        var previousSelected = this.z13();
        var previousActive = !(previousSelected == null);
        this.o14_1.ap(ensureNotNull(element));
        this.w13(new SingleSelectionEvent(this, previousActive, !(element == null), previousSelected, element));
      }
    }
  }
  h13() {
    return this.f13() ? 1 : 0;
  }
  h1() {
    return new PropertySingleSelection$iterator$1(this);
  }
}
class SimpleSelection extends AbstractMutableSelection {
  static x14() {
    var $this = this.x12();
    $this.w14_1 = CollectionFactory_instance.y14();
    return $this;
  }
  i13() {
    var tmp;
    if (this.b13() && this.f13()) {
      var changes = HashSet.c9();
      changes.o1(this.w14_1);
      this.w14_1.u4();
      this.e13(new SimpleSelectionEvent(this, changes));
      tmp = true;
    } else {
      tmp = false;
    }
    return tmp;
  }
  f13() {
    return !this.w14_1.p1() && this.b13();
  }
  g13(element) {
    return !(element == null) && this.w14_1.q2(element);
  }
  j13(e) {
    if (this.b13()) {
      if (!(e == null)) {
        var changes = HashSet.c9();
        var _iterator__ex2g4s = this.w14_1.h1();
        while (_iterator__ex2g4s.i1()) {
          var element = _iterator__ex2g4s.j1();
          changes.c1(element);
        }
        if (!this.g13(e)) {
          changes.c1(e);
          this.w14_1.c1(e);
        } else {
          changes.e3(e);
        }
        if (changes.k1() > 0) {
          this.w14_1.u4();
          this.w14_1.c1(e);
          this.e13(new SimpleSelectionEvent(this, changes));
        }
      } else {
        this.i13();
      }
    }
  }
  k13(element, selected) {
    if (this.b13() && !(element == null)) {
      if (selected) {
        if (!this.g13(element)) {
          var changes = HashSet.c9();
          changes.c1(element);
          this.w14_1.c1(element);
          this.e13(new SimpleSelectionEvent(this, changes));
        }
      } else {
        if (this.g13(element)) {
          var changes_0 = HashSet.c9();
          changes_0.c1(element);
          this.w14_1.e3(element);
          this.e13(new SimpleSelectionEvent(this, changes_0));
        }
      }
    }
  }
  l13(elements, selected) {
    if (this.b13() && !(elements == null)) {
      if (selected) {
        var changes = HashSet.c9();
        var _iterator__ex2g4s = elements.h1();
        while (_iterator__ex2g4s.i1()) {
          var element = _iterator__ex2g4s.j1();
          if (!this.g13(element)) {
            changes.c1(element);
            this.w14_1.c1(element);
          }
        }
        if (changes.k1() > 0) {
          this.e13(new SimpleSelectionEvent(this, changes));
          return true;
        }
      } else {
        var changes_0 = HashSet.c9();
        var _iterator__ex2g4s_0 = elements.h1();
        while (_iterator__ex2g4s_0.i1()) {
          var element_0 = _iterator__ex2g4s_0.j1();
          if (this.g13(element_0)) {
            changes_0.c1(element_0);
            this.w14_1.e3(element_0);
          }
        }
        if (changes_0.k1() > 0) {
          this.e13(new SimpleSelectionEvent(this, changes_0));
          return true;
        }
      }
    }
    return false;
  }
  m13(elements) {
    if (this.b13() && !(elements == null)) {
      var changes = HashSet.c9();
      var _iterator__ex2g4s = this.w14_1.h1();
      while (_iterator__ex2g4s.i1()) {
        var element = _iterator__ex2g4s.j1();
        changes.c1(element);
      }
      var inductionVariable = 0;
      var last = elements.length;
      while (inductionVariable < last) {
        var element_0 = elements[inductionVariable];
        inductionVariable = inductionVariable + 1 | 0;
        if (!this.g13(element_0)) {
          changes.c1(element_0);
          this.w14_1.c1(element_0);
        } else {
          changes.e3(element_0);
        }
      }
      if (changes.k1() > 0) {
        this.w14_1.u4();
        addAll(this.w14_1, elements);
        this.e13(new SimpleSelectionEvent(this, changes));
      }
    }
  }
  n13(elements) {
    if (this.b13()) {
      if (!(elements == null)) {
        var changes = HashSet.c9();
        var _iterator__ex2g4s = this.w14_1.h1();
        while (_iterator__ex2g4s.i1()) {
          var element = _iterator__ex2g4s.j1();
          changes.c1(element);
        }
        var _iterator__ex2g4s_0 = elements.h1();
        while (_iterator__ex2g4s_0.i1()) {
          var element_0 = _iterator__ex2g4s_0.j1();
          if (!this.g13(element_0)) {
            changes.c1(element_0);
            this.w14_1.c1(element_0);
          } else {
            changes.e3(element_0);
          }
        }
        if (changes.k1() > 0) {
          this.w14_1.u4();
          var _iterator__ex2g4s_1 = elements.h1();
          while (_iterator__ex2g4s_1.i1()) {
            var element_1 = _iterator__ex2g4s_1.j1();
            this.w14_1.c1(element_1);
          }
          this.e13(new SimpleSelectionEvent(this, changes));
        }
      } else {
        if (!this.w14_1.p1()) {
          var changes_0 = HashSet.c9();
          var _iterator__ex2g4s_2 = this.w14_1.h1();
          while (_iterator__ex2g4s_2.i1()) {
            var element_2 = _iterator__ex2g4s_2.j1();
            changes_0.c1(element_2);
          }
          this.w14_1.u4();
          this.e13(new SimpleSelectionEvent(this, changes_0));
        }
      }
    }
  }
  h13() {
    return this.w14_1.k1();
  }
  h1() {
    return this.w14_1.h1();
  }
  toString() {
    var selected = '';
    var first = true;
    var _iterator__ex2g4s = this.w14_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var s = _iterator__ex2g4s.j1();
      if (!first) {
        selected = selected + ',';
      } else {
        first = false;
      }
      selected = selected + toString_0(s);
    }
    return 'SimpleSelection{selected=' + selected + toString(_Char___init__impl__6a9atx(125));
  }
}
class SimpleSelectionEvent extends AbstractSelectionEvent {
  constructor(model, changes) {
    super();
    this.z14_1 = model;
    this.a15_1 = changes;
  }
  toString() {
    var s = 'SimpleSelectionEvent{model=' + toString_1(this.z14_1) + ', changes=';
    var _iterator__ex2g4s = this.a15_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var change = _iterator__ex2g4s.j1();
      s = s + (toString_0(change) + '(' + this.z14_1.g13(change) + '),');
    }
    s = s + toString(_Char___init__impl__6a9atx(125));
    return s;
  }
  hashCode() {
    var result = hashCode(this.z14_1);
    result = imul_0(result, 31) + hashCode(this.a15_1) | 0;
    return result;
  }
  equals(other) {
    if (this === other)
      return true;
    if (!(other instanceof SimpleSelectionEvent))
      return false;
    if (!equals(this.z14_1, other.z14_1))
      return false;
    if (!equals(this.a15_1, other.a15_1))
      return false;
    return true;
  }
}
class SimpleSingleSelection$iterator$1 {
  constructor(this$0) {
    this.c15_1 = this$0;
    this.b15_1 = !this$0.f13();
  }
  i1() {
    return !this.b15_1;
  }
  j1() {
    this.b15_1 = true;
    var s = this.c15_1.g15_1;
    if (!(s == null)) {
      return s;
    } else {
      throw IllegalStateException.gb();
    }
  }
}
class SimpleSingleSelection extends AbstractMutableSingleSelection {
  y13(element) {
    if (this.b13()) {
      if (!(this.g15_1 === element)) {
        if (this.g15_1 == null || !equals(this.g15_1, element)) {
          var previousSelected = this.g15_1;
          var previousActive = !(this.g15_1 == null);
          this.g15_1 = element;
          this.w13(new SingleSelectionEvent(this, previousActive, !(element == null), previousSelected, element));
        }
      }
    }
  }
  z13() {
    return this.g15_1;
  }
  static h15() {
    var $this = this.t13();
    init_com_macrofocus_common_selection_SimpleSingleSelection($this);
    $this.y13(null);
    return $this;
  }
  static i15(selected) {
    var $this = this.t13();
    init_com_macrofocus_common_selection_SimpleSingleSelection($this);
    $this.y13(selected);
    return $this;
  }
  i13() {
    var tmp;
    if (this.b13() && this.f13()) {
      this.y13(null);
      tmp = true;
    } else {
      tmp = false;
    }
    return tmp;
  }
  f13() {
    return !(this.g15_1 == null) && this.b13();
  }
  g13(element) {
    return !(this.g15_1 == null) && equals(this.g15_1, element);
  }
  k13(element, selected) {
    if (this.b13()) {
      if (selected) {
        this.y13(element);
      } else {
        if (this.g13(element)) {
          this.i13();
        }
      }
    }
  }
  l13(element, selected) {
    throw UnsupportedOperationException.q3();
  }
  m13(elements) {
    throw UnsupportedOperationException.q3();
  }
  n13(elements) {
    throw UnsupportedOperationException.q3();
  }
  j13(element) {
    this.y13(element);
  }
  h13() {
    return this.f13() ? 1 : 0;
  }
  h1() {
    return new SimpleSingleSelection$iterator$1(this);
  }
  toString() {
    return 'SimpleSingleSelection{selected=' + this.g15_1 + toString(_Char___init__impl__6a9atx(125));
  }
}
class SingleSelectionEvent extends AbstractSelectionEvent {
  constructor(model, previousActive, currentActive, previousSelection, currentSelection) {
    super();
    this.o15_1 = null;
    this.j15_1 = model;
    this.k15_1 = previousActive;
    this.l15_1 = currentActive;
    this.m15_1 = previousSelection;
    this.n15_1 = currentSelection;
  }
}
class AbstractCPTimer {
  constructor() {
    this.p15_1 = ArrayList.q1();
  }
  q15(listener) {
    this.p15_1.c1(listener);
  }
}
class AbstractMutableOneDScreenTransform {
  static t15() {
    var $this = createThis(this);
    $this.s15_1 = CollectionFactory_instance.nk();
    return $this;
  }
  u15(event) {
    var _iterator__ex2g4s = this.s15_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var listener = _iterator__ex2g4s.j1();
      listener.v15(event);
    }
  }
}
class RangesScreenTransformCoordinator$xRangeListener$1 {
  constructor(this$0, $xRange, $yRange) {
    this.g16_1 = this$0;
    this.h16_1 = $xRange;
    this.i16_1 = $yRange;
  }
  kn(event) {
    if (!this.g16_1.l16_1) {
      this.g16_1.l16_1 = true;
      if (!(event.go_1 === event.do_1)) {
        var xRangeRatio = this.h16_1.extent / this.h16_1.pp();
        var yDiff = this.i16_1.extent - this.i16_1.pp() * xRangeRatio;
        adjustValues(this.g16_1, this.i16_1, yDiff);
      }
      this.g16_1.l16_1 = false;
    }
  }
}
class RangesScreenTransformCoordinator$yRangeListener$1 {
  constructor(this$0, $yRange, $xRange) {
    this.o16_1 = this$0;
    this.p16_1 = $yRange;
    this.q16_1 = $xRange;
  }
  kn(event) {
    if (!this.o16_1.l16_1) {
      this.o16_1.l16_1 = true;
      if (!(event.go_1 === event.do_1)) {
        var yRangeRatio = this.p16_1.extent / this.p16_1.pp();
        var xDiff = this.q16_1.extent - this.q16_1.pp() * yRangeRatio;
        adjustValues(this.o16_1, this.q16_1, xDiff);
      }
      this.o16_1.l16_1 = false;
    }
  }
}
class RangesScreenTransformCoordinator {
  constructor(xRange, yRange) {
    this.l16_1 = false;
    var tmp = this;
    tmp.m16_1 = new RangesScreenTransformCoordinator$xRangeListener$1(this, xRange, yRange);
    var tmp_0 = this;
    tmp_0.n16_1 = new RangesScreenTransformCoordinator$yRangeListener$1(this, yRange, xRange);
    this.j16_1 = xRange;
    this.k16_1 = yRange;
    xRange.addIntervalListener(this.m16_1);
    yRange.addIntervalListener(this.n16_1);
  }
}
class ScreenTransformEvent {}
class SimpleOneDScreenTransform$intervalListener$1 {
  constructor(this$0) {
    this.r16_1 = this$0;
  }
  kn(event) {
    this.r16_1.u15(new ScreenTransformEvent());
  }
}
class SimpleOneDScreenTransform extends AbstractMutableOneDScreenTransform {
  static z16(world, screenSize) {
    var $this = this.t15();
    $this.t16_1 = world;
    $this.u16_1 = 0;
    $this.v16_1 = 0;
    $this.w16_1 = false;
    $this.x16_1 = false;
    var tmp = $this;
    tmp.y16_1 = new SimpleOneDScreenTransform$intervalListener$1($this);
    $this.t16_1.addWeakIntervalListener($this.y16_1);
    $this.w15(screenSize);
    return $this;
  }
  y15(screenMargins) {
    if (!(this.u16_1 === screenMargins)) {
      this.u16_1 = screenMargins;
      this.u15(new ScreenTransformEvent());
    }
  }
  w15(screenSize) {
    if (!(this.v16_1 === screenSize)) {
      this.v16_1 = screenSize;
      this.u15(new ScreenTransformEvent());
    }
  }
  x15() {
    return this.v16_1;
  }
  f16() {
    return this.x16_1;
  }
  static a17(world, screenSize, invertDeviceCoordinates, invertWorldCoordinates) {
    var $this = this.z16(world, screenSize);
    $this.w16_1 = invertDeviceCoordinates;
    $this.x16_1 = invertWorldCoordinates;
    return $this;
  }
  z15(screen) {
    var normalized;
    normalized = (screen - (this.u16_1 / 2 | 0) | 0) / (this.v16_1 - this.u16_1 | 0);
    if (this.w16_1)
      normalized = 1.0 - normalized;
    if (this.x16_1) {
      normalized = 1.0 - normalized;
    }
    normalized = normalized * this.e16() + this.d16();
    return normalized;
  }
  a16(world) {
    return numberToInt(this.b16(world));
  }
  b16(world) {
    var tmp;
    if (!!(this.x16_1 ^ this.w16_1)) {
      tmp = (this.b17() - world) * (this.v16_1 - this.u16_1 | 0) / this.e16() + this.u16_1 / 2.0;
    } else {
      tmp = (world - this.d16()) * (this.v16_1 - this.u16_1 | 0) / this.e16() + this.u16_1 / 2.0;
    }
    return tmp;
  }
  c16() {
    return this.t16_1;
  }
  d16() {
    var tmp;
    if (this.x16_1) {
      tmp = this.t16_1.gn() + (this.t16_1.hn() - (this.t16_1.start + this.t16_1.extent));
    } else {
      tmp = this.t16_1.start;
    }
    return tmp;
  }
  b17() {
    var tmp;
    if (this.x16_1) {
      tmp = this.t16_1.gn() + (this.t16_1.hn() - this.t16_1.start);
    } else {
      tmp = this.t16_1.start + this.t16_1.extent;
    }
    return tmp;
  }
  e16() {
    return this.t16_1.extent;
  }
  toString() {
    return 'SimpleOneDScreenTransform{world=' + this.t16_1 + ', screenMargins=' + this.u16_1 + ', screenSize=' + this.v16_1 + ', invertDeviceCoordinates=' + this.w16_1 + ', invertWorldCoordinates=' + this.x16_1 + toString(_Char___init__impl__6a9atx(125));
  }
}
class Quantity {}
class CollectionFactory {
  nk() {
    return ArrayList.q1();
  }
  c17() {
    return HashMap.i7();
  }
  y14() {
    return LinkedHashSet.m1();
  }
}
class JsArrayList extends ArrayList {
  constructor(elements) {
    return new.target.g17(elements);
  }
  static g17(elements) {
    return this.s(toList(elements));
  }
}
class SoftReference {
  constructor(referent) {
    this.h17_1 = referent;
  }
  zj() {
    return this.h17_1;
  }
}
class CallableFuture {
  constructor(task) {
    this.i17_1 = false;
    this.j17_1 = null;
    this.k17_1 = null;
    try {
      this.j17_1 = task.l17();
      this.i17_1 = true;
    } catch ($p) {
      if ($p instanceof Exception) {
        var e = $p;
        this.k17_1 = e;
      } else {
        throw $p;
      }
    }
  }
  m17() {
    return this.i17_1;
  }
  n17(mayInterruptIfRunning) {
    return false;
  }
  o17() {
    return false;
  }
  zj() {
    if (!(this.k17_1 == null)) {
      throw RuntimeException.lb(this.k17_1);
    } else {
      return this.j17_1;
    }
  }
}
class ExecutorService {
  p17(task) {
    var future = new CallableFuture(ensureNotNull(task));
    return future;
  }
}
class Companion_28 {
  q17() {
    return new Runtime();
  }
}
class Runtime {
  r17() {
    return 1;
  }
}
class Companion_29 {
  constructor() {
    Companion_instance_29 = this;
    this.s17_1 = new CPHelper();
  }
}
class CPHelper {
  constructor() {
    Companion_getInstance_29();
    var tmp = this;
    tmp.t17_1 = lazy(CPHelper$visualizationExecutorService$delegate$lambda(this));
    this.u17_1 = false;
  }
  v17(name, corePoolSize, maximumPoolSize) {
    return new ExecutorService();
  }
  w17(name, delay, postponing) {
    return new GWTTimer(name, delay, postponing);
  }
  x17(name, delay, postponing, timerListener) {
    var timer = this.w17(name, delay, postponing);
    timer.q15(timerListener);
    return timer;
  }
  y17(millis) {
  }
  z17(a, b) {
    return a.equals(b);
  }
  a18(cl) {
    return !(cl == null) && (this.z17(PrimitiveClasses_getInstance().tc(), cl) || cl.equals(PrimitiveClasses_getInstance().bd()) || cl.equals(PrimitiveClasses_getInstance().yc()) || cl.equals(PrimitiveClasses_getInstance().ad()) || cl.equals(PrimitiveClasses_getInstance().xc()) || cl.equals(PrimitiveClasses_getInstance().zc()));
  }
  b18(cl) {
    return false;
  }
  c18(cl) {
    return false;
  }
  d18(cl) {
    return PrimitiveClasses_getInstance().cd().equals(cl);
  }
  e18() {
    return numberToLong(Date.now());
  }
}
class Timer {
  constructor($box) {
    boxApply(this, $box);
    this.k18_1 = false;
    this.l18_1 = null;
  }
  m18() {
    return !(this.l18_1 == null);
  }
  n18() {
    if (!this.m18()) {
      return Unit_instance;
    }
    if (this.k18_1) {
      window.clearInterval(ensureNotNull(this.l18_1));
    } else {
      window.clearTimeout(ensureNotNull(this.l18_1));
    }
    this.l18_1 = null;
  }
  o18(delayMillis) {
    // Inline function 'kotlin.require' call
    if (!(delayMillis >= 0)) {
      var message = 'must be non-negative';
      throw IllegalArgumentException.w(toString_1(message));
    }
    if (this.m18()) {
      this.n18();
    }
    this.k18_1 = false;
    this.l18_1 = window.setTimeout(createTimeoutCallback(this, this), delayMillis);
  }
  p18() {
    if (!this.k18_1) {
      this.l18_1 = null;
    }
    this.i18();
  }
}
class GWTTimer$1 extends Timer {
  constructor(this$0, $box) {
    if ($box === VOID)
      $box = {};
    $box.h18_1 = this$0;
    super($box);
  }
  i18() {
    var _iterator__ex2g4s = this.h18_1.p15_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var listener = _iterator__ex2g4s.j1();
      listener.j18();
    }
  }
}
class GWTTimer extends AbstractCPTimer {
  constructor(name, delay, postponing) {
    super();
    this.r18_1 = name;
    this.s18_1 = delay;
    this.t18_1 = postponing;
    var tmp = this;
    tmp.u18_1 = new GWTTimer$1(this);
  }
  r15() {
    if (this.t18_1 || !this.u18_1.m18()) {
      this.u18_1.o18(this.s18_1);
    }
  }
}
class Companion_30 {
  constructor() {
    Companion_instance_30 = this;
    this.v18_1 = new FormatFactory();
  }
}
class FormatFactory$createDecimalFormat$1 {
  w18(value) {
    return toString_0(value);
  }
  zl(value, htmlSupported) {
    if (!htmlSupported) {
      return this.w18(value);
    } else {
      return toString_0(value);
    }
  }
  zk(value, htmlSupported) {
    return this.zl((value == null ? true : !(value == null)) ? value : THROW_CCE(), htmlSupported);
  }
  yk() {
    var reason = 'Not yet implemented';
    throw NotImplementedError.ui('An operation is not implemented: ' + reason);
  }
}
class FormatFactory {
  constructor() {
    Companion_getInstance_30();
  }
  x18() {
    return new FormatFactory$createDecimalFormat$1();
  }
  y18(pattern) {
    // Inline function 'kotlin.TODO' call
    var reason = 'Not yet implemented';
    throw NotImplementedError.ui('An operation is not implemented: ' + reason);
  }
  z18(pattern) {
    return ensureNotNull(this.am(0));
  }
}
class BigDecimals {
  constructor() {
    BigDecimals_instance = this;
    this.sp_1 = Companion_getInstance_21().ZERO;
    this.tp_1 = Companion_getInstance_21().ONE;
    this.up_1 = Companion_getInstance_21().TWO;
    this.vp_1 = Companion_getInstance_21().TEN;
    this.wp_1 = Companion_getInstance_21().ONE_TENTH;
    this.xp_1 = Companion_getInstance_21().ONE_HALF;
    this.yp_1 = Companion_getInstance_21().PI;
    this.zp_1 = Companion_getInstance_21().E;
  }
}
class BigIntegers {
  constructor() {
    BigIntegers_instance = this;
    this.tq_1 = Companion_getInstance_22().ZERO;
    this.uq_1 = Companion_getInstance_22().ONE;
    this.vq_1 = Companion_getInstance_22().TWO;
    this.wq_1 = Companion_getInstance_22().TEN;
    this.xq_1 = Companion_getInstance_22().NEGATIVE_ONE;
  }
}
class Timing {
  constructor() {
    this.a19_1 = 0.0;
    this.b19_1 = 0.0;
    this.c19_1 = 0n;
    this.d19_1 = 0n;
    this.e19_1 = 0;
  }
  f19() {
    return this.c19_1;
  }
  g19() {
    var tmp0 = this.d19_1;
    // Inline function 'kotlin.Long.div' call
    var other = this.e19_1;
    return divide(tmp0, fromInt_0(other));
  }
  h19() {
    if (this.f19() > 0n) {
      return convertToInt(divide(1000n, this.f19()));
    } else {
      return 1000;
    }
  }
  i19() {
    this.a19_1 = Date.now();
  }
  j19() {
    this.b19_1 = Date.now();
    this.c19_1 = numberToLong(this.b19_1 - this.a19_1);
    this.d19_1 = add_0(this.d19_1, this.c19_1);
    this.e19_1 = this.e19_1 + 1 | 0;
  }
  toString() {
    return 'Timing(lastDuration=' + this.f19().toString() + ', fps=' + this.h19() + ', averageDuration=' + this.g19().toString() + ')';
  }
}
class ReactHTML {}
class IColor {}
function toHTMLColor() {
  var alpha;
  var red = toString_6(this.k19(), 16);
  var blu = toString_6(this.m19(), 16);
  var gre = toString_6(this.l19(), 16);
  var tmp = this.n19();
  // Inline function 'kotlin.UInt.toUByte' call
  var this_0 = _UInt___init__impl__l7qpdl(255);
  // Inline function 'kotlin.toUByte' call
  var this_1 = _UInt___get_data__impl__f0vqqw(this_0);
  if (tmp === _UByte___init__impl__g9hnc4(toByte(this_1))) {
    alpha = '';
  } else {
    alpha = toString_6(this.n19(), 16);
    alpha = alpha.length === 1 ? '0' + alpha : alpha;
  }
  red = red.length === 1 ? '0' + red : red;
  blu = blu.length === 1 ? '0' + blu : blu;
  gre = gre.length === 1 ? '0' + gre : gre;
  return '#' + alpha + red + gre + blu;
}
function toJavaScriptColor() {
  var tmp;
  var tmp_0 = this.n19();
  // Inline function 'kotlin.UInt.toUByte' call
  var this_0 = _UInt___init__impl__l7qpdl(255);
  // Inline function 'kotlin.toUByte' call
  var this_1 = _UInt___get_data__impl__f0vqqw(this_0);
  if (tmp_0 === _UByte___init__impl__g9hnc4(toByte(this_1))) {
    tmp = this.o19();
  } else {
    var tmp_1 = 'rgba(' + UByte__toString_impl_v72jg(this.k19()) + ',' + UByte__toString_impl_v72jg(this.l19()) + ',' + UByte__toString_impl_v72jg(this.m19()) + ',';
    // Inline function 'kotlin.UByte.toFloat' call
    // Inline function 'kotlin.UByte.toInt' call
    var this_2 = this.n19();
    // Inline function 'kotlin.uintToFloat' call
    var value = _UByte___get_data__impl__jof9qr(this_2) & 255;
    tmp = tmp_1 + (uintToDouble(value) / 255.0).toString() + ')';
  }
  return tmp;
}
class PropertyType extends Enum {}
class WeakColorMapListener {
  constructor(listener) {
    this.q19_1 = new WeakReference(listener);
  }
  r19(event) {
    var l = this.jk();
    if (!(l == null)) {
      l.r19(event);
    } else {
      event.w19().removeColorMapListener(this);
    }
  }
  jk() {
    return this.q19_1.zj();
  }
}
class Companion_31 {
  constructor() {
    this.x19_1 = 'inverval';
    this.y19_1 = 'palette';
    this.z19_1 = 'matching';
    this.a1a_1 = 'assignments';
    this.b1a_1 = 'missingValuesColor';
    this.c1a_1 = 'underflowColor';
    this.d1a_1 = 'overflowColor';
    this.e1a_1 = 'inverted';
    this.f1a_1 = 'numberOfSteps';
    this.g1a_1 = 'brightness';
    this.h1a_1 = 'saturation';
    this.i1a_1 = 'alpha';
  }
}
class AbstractColorMap {
  static k1a() {
    var $this = createThis(this);
    $this.j1a_1 = CollectionFactory_instance.nk();
    return $this;
  }
  l1a(listener) {
    this.j1a_1.c1(listener);
  }
  addColorMapListener(listener) {
    return this.l1a(listener);
  }
  m1a(listener) {
    this.j1a_1.c1(new WeakColorMapListener(listener));
  }
  addWeakColorMapListener(listener) {
    return this.m1a(listener);
  }
  n1a(listener) {
    if (listener instanceof WeakColorMapListener) {
      var removed = this.j1a_1.e3(listener);
    } else {
      var toRemove = null;
      var _iterator__ex2g4s = this.j1a_1.h1();
      while (_iterator__ex2g4s.i1()) {
        var ColormapListener = _iterator__ex2g4s.j1();
        var comparable;
        var tmp;
        if (ColormapListener instanceof WeakColorMapListener) {
          tmp = ColormapListener.jk();
        } else {
          tmp = ColormapListener;
        }
        comparable = tmp;
        if (equals(listener, comparable)) {
          toRemove = ColormapListener;
        }
      }
      if (!(toRemove == null)) {
        var removed_0 = this.j1a_1.e3(toRemove);
      }
    }
  }
  removeColorMapListener(listener) {
    return this.n1a(listener);
  }
  o1a(event) {
    var _iterator__ex2g4s = this.j1a_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var listener = _iterator__ex2g4s.j1();
      listener.r19(event);
    }
  }
}
class Assignments extends Enum {}
class ColorMapEvent {
  constructor(colorMap, propertyName, oldValue, newValue) {
    this.s19_1 = colorMap;
    this.t19_1 = propertyName;
    this.v19_1 = oldValue;
    this.u19_1 = newValue;
  }
  w19() {
    return this.s19_1;
  }
}
class Companion_32 {
  constructor() {
    Companion_instance_32 = this;
    this.b1b_1 = new ColorMapFactory();
  }
}
class ColorMapFactory {
  constructor(paletteFactory) {
    Companion_getInstance_32();
    paletteFactory = paletteFactory === VOID ? Companion_getInstance_55().instance : paletteFactory;
    this.c1b_1 = Companion_getInstance_56().e1b_1;
    this.d1b_1 = paletteFactory;
  }
  f1b(min, max) {
    return this.g1b(min, max, this.d1b_1.createDefaultSequentialPalette());
  }
  h1b(min, max) {
    return this.g1b(min, max, this.d1b_1.createDefaultDivergingPalette());
  }
  i1b(values) {
    return this.j1b(values, true, this.d1b_1.createDefaultQualititativePalette());
  }
  g1b(min, max, palette) {
    return SimpleColorMap.intervalConstructor(PropertyClosedInterval.po(min, max - min), palette);
  }
  j1b(values, cyclic, palette) {
    return SimpleColorMap.values(values, cyclic, palette);
  }
  k1b(mininum, maximum) {
    var tmp;
    if (!(mininum == null) && !(maximum == null)) {
      var tmp_0;
      if (numberToDouble(mininum) < 0 && numberToDouble(maximum) > 0) {
        var diffMin = 0 - numberToDouble(mininum);
        var diffMax = numberToDouble(maximum);
        // Inline function 'kotlin.math.max' call
        var maxDiff = Math.max(diffMin, diffMax);
        tmp_0 = this.h1b(0 - maxDiff, maxDiff);
      } else {
        tmp_0 = this.f1b(numberToDouble(mininum), numberToDouble(maximum));
      }
      tmp = tmp_0;
    } else {
      tmp = this.f1b(0.0, 0.0);
    }
    return tmp;
  }
  l1b(mininum, maximum) {
    var tmp;
    if (!(mininum == null) && !(maximum == null)) {
      var tmp_0;
      if (numberToDouble(mininum) < 0 && numberToDouble(maximum) > 0) {
        var diffMin = 0 - numberToDouble(mininum);
        var diffMax = numberToDouble(maximum);
        // Inline function 'kotlin.math.max' call
        var maxDiff = Math.max(diffMin, diffMax);
        var min = 0 - maxDiff;
        var minF = (min - numberToDouble(mininum)) / (numberToDouble(maximum) - numberToDouble(mininum));
        var maxF = (maxDiff - numberToDouble(mininum)) / (numberToDouble(maximum) - numberToDouble(mininum));
        var meanF = (maxF + minF) / 2.0;
        tmp_0 = this.g1b(numberToDouble(mininum), numberToDouble(maximum), CustomPalette.a1c([new Entry_0(minF, colorOf_1(255, 0, 0)), new Entry_0(meanF, this.c1b_1.r1b()), new Entry_0(maxF, colorOf_1(0, 128, 0))]));
      } else {
        tmp_0 = this.g1b(numberToDouble(mininum), numberToDouble(maximum), CustomPalette.a1c([new Entry_0(0.0, colorOf_1(255, 0, 0)), new Entry_0(0.5, this.c1b_1.r1b()), new Entry_0(1.0, colorOf_1(0, 128, 0))]));
      }
      tmp = tmp_0;
    } else {
      tmp = this.g1b(0.0, 0.0, CustomPalette.a1c([new Entry_0(0.0, this.c1b_1.r1b())]));
    }
    return tmp;
  }
}
class Matching extends Enum {}
class SetStoreMutableProperty$1 {
  constructor($store) {
    this.b1c_1 = $store;
  }
  b10(event) {
    if (!event.newValue) {
      this.b1c_1.ap(null);
    }
  }
  vo(event) {
    return this.b10(event);
  }
}
class SetStoreMutableProperty$2 {
  constructor(this$0) {
    this.c1c_1 = this$0;
  }
  d1c(event) {
    this.c1c_1.ay(new PropertyEvent(null, this.c1c_1.z2()));
  }
  vo(event) {
    return this.d1c(event);
  }
}
class SetStoreMutableProperty$3 {
  constructor(this$0) {
    this.k1c_1 = this$0;
  }
  l1c(event) {
    this.k1c_1.ay(new PropertyEvent(event.oldValue, this.k1c_1.z2()));
  }
  vo(event) {
    return this.l1c(event);
  }
}
class SetStoreMutableProperty extends AbstractMutableProperty {
  constructor(set, store, palette, fraction) {
    super();
    this.g1c_1 = set;
    this.h1c_1 = store;
    this.i1c_1 = palette;
    this.j1c_1 = fraction;
    this.g1c_1.zo(new SetStoreMutableProperty$1(store));
    palette.zo(new SetStoreMutableProperty$2(this));
    store.zo(new SetStoreMutableProperty$3(this));
  }
  m1c(value) {
    if (!(value == null)) {
      this.g1c_1.ap(true);
    }
    this.h1c_1.ap(value);
  }
  ap(_set____db54di) {
    return this.m1c((_set____db54di == null ? true : _set____db54di instanceof CPColor) ? _set____db54di : THROW_CCE());
  }
  z2() {
    var tmp;
    if (!(this.h1c_1.z2() == null)) {
      tmp = this.h1c_1.z2();
    } else {
      tmp = !(this.i1c_1.z2() == null) ? ensureNotNull(this.i1c_1.z2()).n1c(this.j1c_1) : null;
    }
    return tmp;
  }
}
class SimpleColorMap$intervalListener$1 {
  constructor(this$0) {
    this.x1d_1 = this$0;
  }
  kn(event) {
    this.x1d_1.o1a(new ColorMapEvent(this.x1d_1, 'inverval', null, null));
  }
}
class SimpleColorMap$paletteListener$1 {
  constructor(this$0) {
    this.y1d_1 = this$0;
  }
  z1d(event) {
    this.y1d_1.o1a(new ColorMapEvent(this.y1d_1, 'palette', null, null));
  }
}
class SimpleColorMap$1 {
  constructor(this$0) {
    this.a1e_1 = this$0;
  }
  d1c(event) {
    if (!(event.oldValue == null)) {
      ensureNotNull(event.oldValue).b1e(this.a1e_1.q1d_1);
    }
    if (!(event.newValue == null)) {
      ensureNotNull(event.newValue).c1e(this.a1e_1.q1d_1);
    }
    this.a1e_1.o1a(new ColorMapEvent(this.a1e_1, 'palette', event.oldValue, event.newValue));
  }
  vo(event) {
    return this.d1c(event);
  }
}
class SimpleColorMap$2 {
  constructor(this$0) {
    this.d1e_1 = this$0;
  }
  b10(event) {
    this.d1e_1.o1a(new ColorMapEvent(this.d1e_1, 'inverted', event.oldValue, event.newValue));
  }
  vo(event) {
    return this.b10(event);
  }
}
class SimpleColorMap$3 {
  constructor(this$0) {
    this.e1e_1 = this$0;
  }
  f1e(event) {
    this.e1e_1.o1a(new ColorMapEvent(this.e1e_1, 'brightness', event.oldValue, event.newValue));
  }
  vo(event) {
    return this.f1e(event);
  }
}
class SimpleColorMap$4 {
  constructor(this$0) {
    this.g1e_1 = this$0;
  }
  f1e(event) {
    this.g1e_1.o1a(new ColorMapEvent(this.g1e_1, 'saturation', event.oldValue, event.newValue));
  }
  vo(event) {
    return this.f1e(event);
  }
}
class SimpleColorMap$5 {
  constructor(this$0) {
    this.h1e_1 = this$0;
  }
  l1c(event) {
    this.h1e_1.o1a(new ColorMapEvent(this.h1e_1, 'overflowColor', event.oldValue, event.newValue));
  }
  vo(event) {
    return this.l1c(event);
  }
}
class SimpleColorMap$6 {
  constructor(this$0) {
    this.i1e_1 = this$0;
  }
  l1c(event) {
    this.i1e_1.o1a(new ColorMapEvent(this.i1e_1, 'underflowColor', event.oldValue, event.newValue));
  }
  vo(event) {
    return this.l1c(event);
  }
}
class SimpleColorMap$7 {
  constructor(this$0) {
    this.j1e_1 = this$0;
  }
  l1c(event) {
    this.j1e_1.o1a(new ColorMapEvent(this.j1e_1, 'missingValuesColor', event.oldValue, event.newValue));
  }
  vo(event) {
    return this.l1c(event);
  }
}
class SimpleColorMap$8 {
  constructor(this$0) {
    this.k1e_1 = this$0;
  }
  b10(event) {
    this.k1e_1.o1a(new ColorMapEvent(this.k1e_1, 'numberOfSteps', event.oldValue, event.newValue));
  }
  vo(event) {
    return this.b10(event);
  }
}
class SimpleColorMap$9 {
  constructor(this$0) {
    this.l1e_1 = this$0;
  }
  f1e(event) {
    this.l1e_1.o1a(new ColorMapEvent(this.l1e_1, 'numberOfSteps', event.oldValue, event.newValue));
  }
  vo(event) {
    return this.f1e(event);
  }
}
class SimpleColorMap extends AbstractColorMap {
  static m1e() {
    var $this = this.k1a();
    $this.p1c_1 = new EnumProperties(values_0());
    $this.q1c_1 = null;
    $this.r1c_1 = $this.p1c_1.bz(PropertyType_Palette_getInstance(), null);
    $this.s1c_1 = PropertyDelegates_instance.k10($this.r1c_1);
    $this.u1c_1 = Matching_EXACT_getInstance();
    $this.v1c_1 = Assignments_STATIC_getInstance();
    $this.w1c_1 = $this.p1c_1.bz(PropertyType_MissingValuesColor_getInstance(), null);
    $this.x1c_1 = PropertyDelegates_instance.k10($this.w1c_1);
    $this.y1c_1 = new SimpleProperty(false);
    $this.z1c_1 = new SimpleProperty(null);
    $this.a1d_1 = $this.p1c_1.cz(PropertyType_UnderflowColor_getInstance(), new SetStoreMutableProperty($this.y1c_1, $this.z1c_1, $this.r1c_1, 0.0));
    $this.b1d_1 = new SimpleProperty(false);
    $this.c1d_1 = new SimpleProperty(null);
    $this.d1d_1 = $this.p1c_1.cz(PropertyType_OverflowColor_getInstance(), new SetStoreMutableProperty($this.b1d_1, $this.c1d_1, $this.r1c_1, 1.0));
    $this.e1d_1 = $this.p1c_1.bz(PropertyType_Inverted_getInstance(), false);
    $this.f1d_1 = PropertyDelegates_instance.k10($this.e1d_1);
    $this.g1d_1 = new SimpleProperty(false);
    $this.h1d_1 = $this.p1c_1.bz(PropertyType_NumberOfSteps_getInstance(), 3);
    $this.i1d_1 = PropertyDelegates_instance.k10($this.h1d_1);
    $this.j1d_1 = $this.p1c_1.bz(PropertyType_Brightness_getInstance(), 0);
    $this.k1d_1 = PropertyDelegates_instance.k10($this.j1d_1);
    $this.l1d_1 = $this.p1c_1.bz(PropertyType_Saturation_getInstance(), 0);
    $this.m1d_1 = PropertyDelegates_instance.k10($this.l1d_1);
    $this.n1d_1 = 1.0;
    $this.o1d_1 = Companion_getInstance_56().e1b_1;
    var tmp = $this;
    tmp.p1d_1 = new SimpleColorMap$intervalListener$1($this);
    var tmp_0 = $this;
    tmp_0.q1d_1 = new SimpleColorMap$paletteListener$1($this);
    $this.p1c_1.bz(PropertyType_Inverval_getInstance(), null);
    $this.p1c_1.bz(PropertyType_Matching_getInstance(), Matching_EXACT_getInstance());
    $this.p1c_1.bz(PropertyType_Assignments_getInstance(), Assignments_STATIC_getInstance());
    var tmp_1 = $this.r1c_1;
    tmp_1.zo(new SimpleColorMap$1($this));
    var tmp_2 = $this.e1d_1;
    tmp_2.zo(new SimpleColorMap$2($this));
    var tmp_3 = $this.j1d_1;
    tmp_3.zo(new SimpleColorMap$3($this));
    var tmp_4 = $this.l1d_1;
    tmp_4.zo(new SimpleColorMap$4($this));
    $this.d1d_1.zo(new SimpleColorMap$5($this));
    $this.a1d_1.zo(new SimpleColorMap$6($this));
    $this.w1c_1.zo(new SimpleColorMap$7($this));
    var tmp_5 = $this.g1d_1;
    tmp_5.zo(new SimpleColorMap$8($this));
    var tmp_6 = $this.h1d_1;
    tmp_6.zo(new SimpleColorMap$9($this));
    $this.w1c_1.ap($this.o1d_1.n1e());
    $this.t1c_1 = HashMap.i7();
    delete $this.interval;
    delete $this.interval;
    delete $this.paletteProperty;
    delete $this.palette;
    delete $this.palette;
    delete $this.nullColorProperty;
    delete $this.nullColor;
    delete $this.nullColor;
    delete $this.underColorSetProperty;
    delete $this.underColorStoreProperty;
    delete $this.underColorProperty;
    delete $this.overColorSetProperty;
    delete $this.overColorStoreProperty;
    delete $this.overColorProperty;
    delete $this.isInvertedProperty;
    delete $this.isInverted;
    delete $this.isInverted;
    delete $this.colorCountSetProperty;
    delete $this.colorCountProperty;
    delete $this.colorCount;
    delete $this.colorCount;
    delete $this.brightnessProperty;
    delete $this.brightness;
    delete $this.brightness;
    delete $this.saturationProperty;
    delete $this.saturation;
    delete $this.saturation;
    delete $this.alpha;
    delete $this.alpha;
    delete $this.underflowColor;
    delete $this.underflowColor;
    delete $this.overflowColor;
    delete $this.overflowColor;
    delete $this.isOverflowColorSet;
    delete $this.isOverflowColorSet;
    delete $this.isUnderflowColorSet;
    delete $this.isUnderflowColorSet;
    delete $this.assignedValues;
    delete $this.assignedValues;
    return $this;
  }
  o1e(interval) {
    if (!(this.q1c_1 === interval)) {
      var old = this.q1c_1;
      if (!(this.q1c_1 == null)) {
        ensureNotNull(this.q1c_1).removeIntervalListener(this.p1d_1);
      }
      this.q1c_1 = interval;
      if (!(this.q1c_1 == null)) {
        ensureNotNull(this.q1c_1).addIntervalListener(this.p1d_1);
      }
      this.o1a(new ColorMapEvent(this, 'inverval', old, interval));
    }
  }
  t1a() {
    return this.q1c_1;
  }
  p1e(_set____db54di) {
    this.r1c_1 = _set____db54di;
  }
  q1e() {
    return this.r1c_1;
  }
  r1d(_set____db54di) {
    var tmp = KMutableProperty1;
    var tmp_0 = SimpleColorMap$_get_palette_$ref_89wju4_0();
    return this.s1c_1.ef(this, getPropertyCallableRef('palette', 1, tmp, tmp_0, SimpleColorMap$_set_palette_$ref_m0hmhs_0()), _set____db54di);
  }
  u1a() {
    var tmp = KMutableProperty1;
    var tmp_0 = SimpleColorMap$_get_palette_$ref_89wju4();
    return this.s1c_1.cf(this, getPropertyCallableRef('palette', 1, tmp, tmp_0, SimpleColorMap$_set_palette_$ref_m0hmhs()));
  }
  r1e() {
    return this.w1c_1;
  }
  s1d(_set____db54di) {
    var tmp = KMutableProperty1;
    var tmp_0 = SimpleColorMap$_get_nullColor_$ref_k2v4t1_0();
    return this.x1c_1.ef(this, getPropertyCallableRef('nullColor', 1, tmp, tmp_0, SimpleColorMap$_set_nullColor_$ref_4v3map_0()), _set____db54di);
  }
  v1a() {
    var tmp = KMutableProperty1;
    var tmp_0 = SimpleColorMap$_get_nullColor_$ref_k2v4t1();
    return this.x1c_1.cf(this, getPropertyCallableRef('nullColor', 1, tmp, tmp_0, SimpleColorMap$_set_nullColor_$ref_4v3map()));
  }
  s1e(_set____db54di) {
    this.y1c_1 = _set____db54di;
  }
  t1e() {
    return this.y1c_1;
  }
  u1e(_set____db54di) {
    this.z1c_1 = _set____db54di;
  }
  v1e() {
    return this.z1c_1;
  }
  w1e() {
    return this.a1d_1;
  }
  x1e(_set____db54di) {
    this.b1d_1 = _set____db54di;
  }
  y1e() {
    return this.b1d_1;
  }
  z1e(_set____db54di) {
    this.c1d_1 = _set____db54di;
  }
  a1f() {
    return this.c1d_1;
  }
  b1f() {
    return this.d1d_1;
  }
  c1f(_set____db54di) {
    this.e1d_1 = _set____db54di;
  }
  d1f() {
    return this.e1d_1;
  }
  t1d(_set____db54di) {
    var tmp = KMutableProperty1;
    var tmp_0 = SimpleColorMap$_get_isInverted_$ref_pusu9g_0();
    return this.f1d_1.ef(this, getPropertyCallableRef('isInverted', 1, tmp, tmp_0, SimpleColorMap$_set_isInverted_$ref_bpe80_0()), _set____db54di);
  }
  fn() {
    var tmp = KMutableProperty1;
    var tmp_0 = SimpleColorMap$_get_isInverted_$ref_pusu9g();
    return this.f1d_1.cf(this, getPropertyCallableRef('isInverted', 1, tmp, tmp_0, SimpleColorMap$_set_isInverted_$ref_bpe80()));
  }
  e1f(_set____db54di) {
    this.g1d_1 = _set____db54di;
  }
  f1f() {
    return this.g1d_1;
  }
  g1f(_set____db54di) {
    this.h1d_1 = _set____db54di;
  }
  h1f() {
    return this.h1d_1;
  }
  u1d(_set____db54di) {
    var tmp = KMutableProperty1;
    var tmp_0 = SimpleColorMap$_get_colorCount_$ref_ggnfaf_0();
    return this.i1d_1.ef(this, getPropertyCallableRef('colorCount', 1, tmp, tmp_0, SimpleColorMap$_set_colorCount_$ref_92g0r1_0()), _set____db54di);
  }
  a1b() {
    var tmp = KMutableProperty1;
    var tmp_0 = SimpleColorMap$_get_colorCount_$ref_ggnfaf();
    return this.i1d_1.cf(this, getPropertyCallableRef('colorCount', 1, tmp, tmp_0, SimpleColorMap$_set_colorCount_$ref_92g0r1()));
  }
  i1f(_set____db54di) {
    this.j1d_1 = _set____db54di;
  }
  j1f() {
    return this.j1d_1;
  }
  v1d(_set____db54di) {
    var tmp = KMutableProperty1;
    var tmp_0 = SimpleColorMap$_get_brightness_$ref_rmha3m_0();
    return this.k1d_1.ef(this, getPropertyCallableRef('brightness', 1, tmp, tmp_0, SimpleColorMap$_set_brightness_$ref_23du26_0()), _set____db54di);
  }
  q1a() {
    var tmp = KMutableProperty1;
    var tmp_0 = SimpleColorMap$_get_brightness_$ref_rmha3m();
    return this.k1d_1.cf(this, getPropertyCallableRef('brightness', 1, tmp, tmp_0, SimpleColorMap$_set_brightness_$ref_23du26()));
  }
  k1f(_set____db54di) {
    this.l1d_1 = _set____db54di;
  }
  l1f() {
    return this.l1d_1;
  }
  w1d(_set____db54di) {
    var tmp = KMutableProperty1;
    var tmp_0 = SimpleColorMap$_get_saturation_$ref_3jmflr_0();
    return this.m1d_1.ef(this, getPropertyCallableRef('saturation', 1, tmp, tmp_0, SimpleColorMap$_set_saturation_$ref_t2pvn7_0()), _set____db54di);
  }
  r1a() {
    var tmp = KMutableProperty1;
    var tmp_0 = SimpleColorMap$_get_saturation_$ref_3jmflr();
    return this.m1d_1.cf(this, getPropertyCallableRef('saturation', 1, tmp, tmp_0, SimpleColorMap$_set_saturation_$ref_t2pvn7()));
  }
  m1f(alpha) {
    if (!(this.n1d_1 === alpha)) {
      var old = this.n1d_1;
      this.n1d_1 = alpha;
      this.o1a(new ColorMapEvent(this, 'alpha', old, alpha));
    }
  }
  s1a() {
    return this.n1d_1;
  }
  static intervalConstructor(interval, palette) {
    var $this = this.m1e();
    $this.o1e(interval);
    $this.r1d(palette);
    return $this;
  }
  static values(values, cyclic, palette) {
    var $this = this.m1e();
    $this.r1d(palette);
    if (values == null)
      null;
    else {
      // Inline function 'kotlin.let' call
      $this.n1f(values, cyclic);
    }
    return $this;
  }
  o1f(value) {
    var color;
    if (!(value == null)) {
      if (value instanceof CPColor) {
        return value;
      } else {
        var tmp;
        if (isComparable(value)) {
          tmp = this.t1c_1.a3(value);
        } else {
          tmp = false;
        }
        if (tmp) {
          color = this.t1c_1.c3(value);
        } else {
          var tmp_0;
          if (isNumber(value)) {
            tmp_0 = !(this.q1c_1 == null);
          } else {
            tmp_0 = false;
          }
          if (tmp_0) {
            var v = numberToDouble(value);
            var fraction;
            var tmp_1;
            if (!ensureNotNull(this.q1c_1).isDegenerate) {
              tmp_1 = (v - ensureNotNull(this.q1c_1).start) / ensureNotNull(this.q1c_1).extent;
            } else {
              tmp_1 = 0.5;
            }
            fraction = tmp_1;
            if (this.fn()) {
              fraction = 1.0 - fraction;
            }
            if (fraction < this.r1f()) {
              return this.x1a();
            } else if (fraction > this.q1f()) {
              return this.w1a();
            } else {
              var colorCount = this.g1d_1.z2() ? this.a1b() : 0;
              if (colorCount > 0) {
                var tmp_2;
                if (colorCount > 1) {
                  tmp_2 = numberToInt(fraction * colorCount) / (colorCount - 1 | 0);
                } else {
                  tmp_2 = 0.5;
                }
                fraction = tmp_2;
              }
              color = ensureNotNull(this.r1c_1.z2()).n1c(fraction);
            }
          } else {
            if (isArray(value)) {
              var str = arrayToString_0(this, value);
              var tmp_3;
              if (this.t1c_1.a3(str)) {
                tmp_3 = this.t1c_1.c3(str);
              } else {
                tmp_3 = this.v1a();
              }
              color = tmp_3;
            } else {
              var tmp_4;
              if (this.v1c_1 === Assignments_DYNAMIC_getInstance()) {
                var c = ensureNotNull(this.r1c_1.z2()).p1f(this.t1c_1.k1() % ensureNotNull(this.r1c_1.z2()).a1b() | 0);
                this.t1c_1.o6(value, c);
                tmp_4 = c;
              } else {
                tmp_4 = this.v1a();
              }
              color = tmp_4;
            }
          }
        }
      }
    } else {
      color = this.v1a();
    }
    if (!(color == null) && (!(this.j1d_1.z2() === 0) || !(this.l1d_1.z2() === 0))) {
      color = brightenAndSaturate(color, this.j1d_1.z2() / 300.0, this.l1d_1.z2() / 300.0);
    }
    if (!(color == null) && !(this.n1d_1 === 1.0)) {
      color = alpha(color, this.n1d_1);
    }
    return color;
  }
  getColor(value) {
    return this.o1f(value);
  }
  r1f() {
    var tmp = this.r1c_1.z2();
    if (tmp instanceof InterpolatedPalette) {
      var tmp_0 = this.r1c_1.z2();
      var tmp_1 = (tmp_0 instanceof InterpolatedPalette ? tmp_0 : THROW_CCE()).getEntries();
      var entries = tmp_1 instanceof SortedSet ? tmp_1 : THROW_CCE();
      if (!entries.p1()) {
        return first(entries).fraction;
      }
    } else {
      var tmp_2 = this.r1c_1.z2();
      if (tmp_2 instanceof CustomPalette) {
        var tmp_3 = this.u1a();
        var tmp_4 = (tmp_3 instanceof CustomPalette ? tmp_3 : THROW_CCE()).s1f();
        var entries_0 = tmp_4 instanceof SortedSet ? tmp_4 : THROW_CCE();
        if (!entries_0.p1()) {
          return first(entries_0).t1f_1;
        }
      }
    }
    return 0.0;
  }
  q1f() {
    var tmp = this.r1c_1.z2();
    if (tmp instanceof InterpolatedPalette) {
      var tmp_0 = this.r1c_1.z2();
      var tmp_1 = (tmp_0 instanceof InterpolatedPalette ? tmp_0 : THROW_CCE()).getEntries();
      var entries = tmp_1 instanceof SortedSet ? tmp_1 : THROW_CCE();
      if (!entries.p1()) {
        return last(entries).fraction;
      }
    } else {
      var tmp_2 = this.r1c_1.z2();
      if (tmp_2 instanceof CustomPalette) {
        var tmp_3 = this.u1a();
        var tmp_4 = (tmp_3 instanceof CustomPalette ? tmp_3 : THROW_CCE()).s1f();
        var entries_0 = tmp_4 instanceof SortedSet ? tmp_4 : THROW_CCE();
        if (!entries_0.p1()) {
          return last(entries_0).t1f_1;
        }
      }
    }
    return 1.0;
  }
  w1f(matching) {
    if (!(this.u1c_1 === matching)) {
      var old = this.u1c_1;
      this.u1c_1 = ensureNotNull(matching);
      this.o1a(new ColorMapEvent(this, 'matching', old, matching));
    }
  }
  setMatching(matching) {
    return this.w1f(matching);
  }
  x1f(assignments) {
    if (!(this.v1c_1 === assignments)) {
      var old = this.v1c_1;
      this.v1c_1 = ensureNotNull(assignments);
      this.o1a(new ColorMapEvent(this, 'assignments', old, assignments));
    }
  }
  setAssignments(assignments) {
    return this.x1f(assignments);
  }
  x1a() {
    return ensureNotNull(this.a1d_1.z2());
  }
  y1f(underColor) {
    if (!equals(this.x1a(), underColor) && (this.x1a() == null || !equals(this.x1a(), underColor))) {
      this.a1d_1.ap(ensureNotNull(underColor));
    }
  }
  setUnderColor(underColor) {
    return this.y1f(underColor);
  }
  w1a() {
    return ensureNotNull(this.c1d_1.z2());
  }
  z1f(overColor) {
    if (!equals(this.w1a(), overColor) && (this.w1a() == null || !equals(this.w1a(), overColor))) {
      this.c1d_1.ap(overColor);
    }
  }
  setOverColor(overColor) {
    return this.z1f(overColor);
  }
  y1a() {
    return this.b1d_1.z2();
  }
  z1a() {
    return this.y1c_1.z2();
  }
  n1f(values, cyclic) {
    this.t1c_1.u4();
    var i = 0;
    var _iterator__ex2g4s = values.h1();
    while (_iterator__ex2g4s.i1()) {
      var value = _iterator__ex2g4s.j1();
      var color;
      var tmp;
      if (!cyclic) {
        tmp = ensureNotNull(this.r1c_1.z2()).n1c(i / values.k1());
      } else {
        tmp = ensureNotNull(this.r1c_1.z2()).p1f(i % ensureNotNull(this.r1c_1.z2()).a1b() | 0);
      }
      color = tmp;
      var v;
      var tmp_0;
      if (!(value == null) ? isArray(value) : false) {
        tmp_0 = arrayToString_0(this, value);
      } else {
        tmp_0 = value;
      }
      v = tmp_0;
      this.t1c_1.o6(v, ensureNotNull(color));
      i = i + 1 | 0;
    }
    this.o1a(new ColorMapEvent(this, 'assignments', null, null));
  }
  assignColorsSet(values, normalized) {
    return this.n1f(values, normalized);
  }
  a1g(values) {
    this.t1c_1.u4();
    var i = 0;
    var inductionVariable = 0;
    var last = values.length;
    while (inductionVariable < last) {
      var value = values[inductionVariable];
      inductionVariable = inductionVariable + 1 | 0;
      if (!this.t1c_1.a3(value)) {
        this.t1c_1.o6(value, ensureNotNull(this.r1c_1.z2()).p1f(i % ensureNotNull(this.r1c_1.z2()).a1b() | 0));
        i = i + 1 | 0;
      }
    }
    this.o1a(new ColorMapEvent(this, 'assignments', null, null));
  }
  assignColors() {
    var values = [].slice.call(arguments, 0);
    return this.a1g(values);
  }
  b1g(values) {
    this.t1c_1.u4();
    var i = 0;
    var _iterator__ex2g4s = values.h1();
    while (_iterator__ex2g4s.i1()) {
      var value = _iterator__ex2g4s.j1();
      if (!this.t1c_1.a3(value)) {
        this.t1c_1.o6(value, ensureNotNull(this.r1c_1.z2()).p1f(i % ensureNotNull(this.r1c_1.z2()).a1b() | 0));
        i = i + 1 | 0;
      }
    }
    this.o1a(new ColorMapEvent(this, 'assignments', null, null));
  }
  assignColorsIterable(values) {
    return this.b1g(values);
  }
  c1g(value, color) {
    this.t1c_1.o6(value, ensureNotNull(color));
    this.o1a(new ColorMapEvent(this, 'assignments', null, null));
  }
  setColor(value, color) {
    return this.c1g(value, color);
  }
  d1g() {
    this.t1c_1.u4();
    this.o1a(new ColorMapEvent(this, 'assignments', null, null));
  }
  clearAssignedColor() {
    return this.d1g();
  }
  p1a() {
    return this.t1c_1.m6();
  }
  e1g() {
    var set = SortedSet.wj(new UniversalComparator());
    set.o1(this.t1c_1.m6());
    this.n1f(set, true);
  }
  resetAssignedValues() {
    return this.e1g();
  }
  f1g(property, value) {
    switch (property) {
      case 'inverval':
        this.o1e((!(value == null) ? !(value == null) : false) ? value : THROW_CCE());
        break;
      case 'palette':
        this.r1d((!(value == null) ? isInterface(value, MutablePalette) : false) ? value : THROW_CCE());
        break;
      case 'matching':
        this.w1f(value instanceof Matching ? value : THROW_CCE());
        break;
      case 'assignments':
        this.x1f(value instanceof Assignments ? value : THROW_CCE());
        break;
      case 'missingValuesColor':
        this.s1d(value instanceof CPColor ? value : THROW_CCE());
        break;
      case 'underflowColor':
        this.y1f(value instanceof CPColor ? value : THROW_CCE());
        break;
      case 'overflowColor':
        this.z1f(value instanceof CPColor ? value : THROW_CCE());
        break;
      case 'inverted':
        this.t1d((!(value == null) ? typeof value === 'boolean' : false) ? value : THROW_CCE());
        break;
      case 'numberOfSteps':
        this.u1d((!(value == null) ? typeof value === 'number' : false) ? value : THROW_CCE());
        break;
      case 'brightness':
        this.v1d((!(value == null) ? typeof value === 'number' : false) ? value : THROW_CCE());
        break;
      case 'saturation':
        this.w1d((!(value == null) ? typeof value === 'number' : false) ? value : THROW_CCE());
        break;
      case 'alpha':
        this.m1f((!(value == null) ? typeof value === 'number' : false) ? value : THROW_CCE());
        break;
      default:
        println('Unknonw property ' + property);
        break;
    }
  }
  setProperty(property, value) {
    return this.f1g(property, value);
  }
  toString() {
    return 'SimpleColorMap{interval=' + this.q1c_1 + ', palette=' + this.u1a() + ', nullColor=' + this.v1a() + ', underColor=' + this.a1d_1 + toString(_Char___init__impl__6a9atx(125));
  }
  get interval() {
    return this.t1a();
  }
  set interval(value) {
    this.o1e(value);
  }
  get paletteProperty() {
    return this.q1e();
  }
  set paletteProperty(value) {
    this.p1e(value);
  }
  get palette() {
    return this.u1a();
  }
  set palette(value) {
    this.r1d(value);
  }
  get nullColorProperty() {
    return this.r1e();
  }
  get nullColor() {
    return this.v1a();
  }
  set nullColor(value) {
    this.s1d(value);
  }
  get underColorSetProperty() {
    return this.t1e();
  }
  set underColorSetProperty(value) {
    this.s1e(value);
  }
  get underColorStoreProperty() {
    return this.v1e();
  }
  set underColorStoreProperty(value) {
    this.u1e(value);
  }
  get underColorProperty() {
    return this.w1e();
  }
  get overColorSetProperty() {
    return this.y1e();
  }
  set overColorSetProperty(value) {
    this.x1e(value);
  }
  get overColorStoreProperty() {
    return this.a1f();
  }
  set overColorStoreProperty(value) {
    this.z1e(value);
  }
  get overColorProperty() {
    return this.b1f();
  }
  get isInvertedProperty() {
    return this.d1f();
  }
  set isInvertedProperty(value) {
    this.c1f(value);
  }
  get isInverted() {
    return this.fn();
  }
  set isInverted(value) {
    this.t1d(value);
  }
  get colorCountSetProperty() {
    return this.f1f();
  }
  set colorCountSetProperty(value) {
    this.e1f(value);
  }
  get colorCountProperty() {
    return this.h1f();
  }
  set colorCountProperty(value) {
    this.g1f(value);
  }
  get colorCount() {
    return this.a1b();
  }
  set colorCount(value) {
    this.u1d(value);
  }
  get brightnessProperty() {
    return this.j1f();
  }
  set brightnessProperty(value) {
    this.i1f(value);
  }
  get brightness() {
    return this.q1a();
  }
  set brightness(value) {
    this.v1d(value);
  }
  get saturationProperty() {
    return this.l1f();
  }
  set saturationProperty(value) {
    this.k1f(value);
  }
  get saturation() {
    return this.r1a();
  }
  set saturation(value) {
    this.w1d(value);
  }
  get alpha() {
    return this.s1a();
  }
  set alpha(value) {
    this.m1f(value);
  }
  get underflowColor() {
    return this.x1a();
  }
  get overflowColor() {
    return this.w1a();
  }
  get isOverflowColorSet() {
    return this.y1a();
  }
  get isUnderflowColorSet() {
    return this.z1a();
  }
  get assignedValues() {
    return this.p1a();
  }
}
class MutableColorMapOverrideProperty extends OverrideProperty {
  g10() {
    var overrideProperty = new MutableColorMapProperty(this.e10().z2());
    return this.h10(overrideProperty);
  }
}
class MutableColorMapProperty$colorMapListener$1 {
  constructor(this$0, $colorMap) {
    this.m1g_1 = this$0;
    this.n1g_1 = $colorMap;
  }
  r19(event) {
    this.m1g_1.ay(new PropertyEvent(null, this.n1g_1));
  }
}
class MutableColorMapProperty extends AbstractMutableProperty {
  constructor(colorMap) {
    super();
    this.q1g_1 = null;
    var tmp = this;
    tmp.r1g_1 = new MutableColorMapProperty$colorMapListener$1(this, colorMap);
    this.s1g(colorMap);
  }
  s1g(value) {
    if (!(this.q1g_1 == null)) {
      ensureNotNull(this.q1g_1).removeColorMapListener(this.r1g_1);
    }
    var old = this.q1g_1;
    this.q1g_1 = value;
    if (!(this.q1g_1 == null)) {
      ensureNotNull(this.q1g_1).addColorMapListener(this.r1g_1);
    }
    this.ay(new PropertyEvent(old, this.q1g_1));
  }
  ap(_set____db54di) {
    return this.s1g((_set____db54di == null ? true : !(_set____db54di == null)) ? _set____db54di : THROW_CCE());
  }
  z2() {
    return this.q1g_1;
  }
}
class InteractiveComponentListeners {
  constructor() {
    this.t1g_1 = ArrayList.q1();
    this.u1g_1 = ArrayList.q1();
    this.v1g_1 = ArrayList.q1();
    this.w1g_1 = ArrayList.q1();
    this.x1g_1 = ArrayList.q1();
  }
  y1g(l) {
    this.t1g_1.c1(l);
  }
  z1g(l) {
    this.u1g_1.c1(l);
  }
}
class Posture extends Enum {}
class Weight extends Enum {}
class Companion_33 {
  constructor() {
    this.a1h_1 = 1;
    this.b1h_1 = 2;
    this.c1h_1 = 4;
    this.d1h_1 = 8;
  }
}
class Shape {}
function get_bounds() {
  var b = this.i1h();
  var width = b.gm();
  var height = b.hm();
  if (width < 0 || height < 0) {
    return Rectangle.empty();
  }
  var x = b.g1h();
  var y = b.h1h();
  // Inline function 'kotlin.math.floor' call
  var x1 = Math.floor(x);
  // Inline function 'kotlin.math.floor' call
  var y1 = Math.floor(y);
  // Inline function 'kotlin.math.ceil' call
  var x_0 = x + width;
  var x2 = Math.ceil(x_0);
  // Inline function 'kotlin.math.ceil' call
  var x_1 = y + height;
  var y2 = Math.ceil(x_1);
  return Rectangle.from(numberToInt(x1), numberToInt(y1), numberToInt(x2 - x1), numberToInt(y2 - y1));
}
function getPathIterator$default(at, $super) {
  at = at === VOID ? null : at;
  return $super === VOID ? this.o1h(at) : $super.o1h.call(this, at);
}
class Rectangle2D {}
class AbstractRectangle2D {
  static e1h() {
    return createThis(this);
  }
  f1h() {
    var width = this.gm();
    var height = this.hm();
    if (width < 0 || height < 0) {
      return Rectangle.empty();
    }
    var x = this.g1h();
    var y = this.h1h();
    // Inline function 'kotlin.math.floor' call
    var x1 = Math.floor(x);
    // Inline function 'kotlin.math.floor' call
    var y1 = Math.floor(y);
    // Inline function 'kotlin.math.ceil' call
    var x_0 = x + width;
    var x2 = Math.ceil(x_0);
    // Inline function 'kotlin.math.ceil' call
    var x_1 = y + height;
    var y2 = Math.ceil(x_1);
    return Rectangle.from(numberToInt(x1), numberToInt(y1), numberToInt(x2 - x1), numberToInt(y2 - y1));
  }
  i1h() {
    return this;
  }
  j1h(point) {
    var x = point.g1h();
    var y = point.h1h();
    var x0 = this.g1h();
    var y0 = this.h1h();
    return x >= x0 && y >= y0 && x < x0 + this.gm() && y < y0 + this.hm();
  }
  k1h() {
    return this.g1h() + this.gm() / 2.0;
  }
  l1h(rect) {
    var x = rect.g1h();
    var y = rect.h1h();
    var w = rect.gm();
    var h = rect.hm();
    if (w <= 0 || h <= 0) {
      return false;
    }
    var x0 = this.g1h();
    var y0 = this.h1h();
    return x + w > x0 && y + h > y0 && x < x0 + this.gm() && y < y0 + this.hm();
  }
  m1h() {
    return this.h1h() + this.hm() / 2.0;
  }
  n1h() {
    return this.o1h(null);
  }
  p1h() {
    return this.g1h();
  }
  o1h(at) {
    return new RectIterator(this, at);
  }
  r1h() {
    return this.h1h();
  }
  s1h() {
    return this.g1h() + this.gm();
  }
  t1h() {
    return this.h1h() + this.hm();
  }
  u1h(r) {
    var tmp0 = this.p1h();
    // Inline function 'kotlin.math.max' call
    var b = r.p1h();
    var x1 = Math.max(tmp0, b);
    var tmp0_0 = this.r1h();
    // Inline function 'kotlin.math.max' call
    var b_0 = r.r1h();
    var y1 = Math.max(tmp0_0, b_0);
    var tmp0_1 = this.s1h();
    // Inline function 'kotlin.math.min' call
    var b_1 = r.s1h();
    var x2 = Math.min(tmp0_1, b_1);
    var tmp0_2 = this.t1h();
    // Inline function 'kotlin.math.min' call
    var b_2 = r.t1h();
    var y2 = Math.min(tmp0_2, b_2);
    return Double_3.z1h(x1, y1, x2 - x1, y2 - y1);
  }
  a1i(x1, y1, x2, y2) {
    var x1_0 = x1;
    var y1_0 = y1;
    var out2;
    // Inline function 'kotlin.also' call
    var this_0 = this.b1i(x2, y2);
    out2 = this_0;
    if (this_0 === 0) {
      return true;
    }
    var out1;
    $l$loop: while (true) {
      // Inline function 'kotlin.also' call
      var this_1 = this.b1i(x1_0, y1_0);
      out1 = this_1;
      if (!!(this_1 === 0)) {
        break $l$loop;
      }
      if (!((out1 & out2) === 0)) {
        return false;
      }
      if (!((out1 & 5) === 0)) {
        var x = this.g1h();
        if (!((out1 & 4) === 0)) {
          x = x + this.gm();
        }
        y1_0 = y1_0 + (x - x1_0) * (y2 - y1_0) / (x2 - x1_0);
        x1_0 = x;
      } else {
        var y = this.h1h();
        if (!((out1 & 8) === 0)) {
          y = y + this.hm();
        }
        x1_0 = x1_0 + (y - y1_0) * (x2 - x1_0) / (y2 - y1_0);
        y1_0 = y;
      }
    }
    return true;
  }
  b1i(x, y) {
    var out = 0;
    if (this.gm() <= 0) {
      out = out | 5;
    } else if (x < this.g1h()) {
      out = out | 1;
    } else if (x > this.g1h() + this.gm()) {
      out = out | 4;
    }
    if (this.hm() <= 0) {
      out = out | 10;
    } else if (y < this.h1h()) {
      out = out | 2;
    } else if (y > this.h1h() + this.hm()) {
      out = out | 8;
    }
    return out;
  }
}
class Companion_34 {
  constructor() {
    Companion_instance_34 = this;
    this.o1i_1 = 0;
    this.p1i_1 = 1;
    this.q1i_1 = 2;
    this.r1i_1 = 4;
    this.s1i_1 = 6;
    this.t1i_1 = 64;
    this.u1i_1 = 8;
    this.v1i_1 = 16;
    this.w1i_1 = 24;
    this.x1i_1 = 32;
    this.y1i_1 = 0;
    this.z1i_1 = 1;
    this.a1j_1 = 2;
    this.b1j_1 = 4;
    this.c1j_1 = -1;
    this.d1j_1 = 3;
    this.e1j_1 = 0;
    this.f1j_1 = 8;
    this.g1j_1 = 16;
    this.h1j_1 = 32;
    var tmp = this;
    // Inline function 'kotlin.intArrayOf' call
    tmp.i1j_1 = new Int32Array([4, 5, 4, 5, 2, 3, 6, 7]);
  }
}
class AffineTransform {
  static j1j() {
    Companion_getInstance_34();
    var $this = createThis(this);
    init_org_mkui_geom_AffineTransform($this);
    $this.j1i_1 = 1.0;
    $this.g1i_1 = $this.j1i_1;
    return $this;
  }
  static k1j(Tx) {
    Companion_getInstance_34();
    var $this = createThis(this);
    init_org_mkui_geom_AffineTransform($this);
    $this.g1i_1 = Tx.g1i_1;
    $this.h1i_1 = Tx.h1i_1;
    $this.i1i_1 = Tx.i1i_1;
    $this.j1i_1 = Tx.j1i_1;
    $this.k1i_1 = Tx.k1i_1;
    $this.l1i_1 = Tx.l1i_1;
    $this.m1i_1 = Tx.m1i_1;
    $this.n1i_1 = Tx.n1i_1;
    return $this;
  }
  l1j() {
    if (this.i1i_1 === 0.0 && this.h1i_1 === 0.0) {
      if (this.g1i_1 === 1.0 && this.j1i_1 === 1.0) {
        if (this.k1i_1 === 0.0 && this.l1i_1 === 0.0) {
          this.m1i_1 = 0;
          this.n1i_1 = 0;
        } else {
          this.m1i_1 = 1;
          this.n1i_1 = 1;
        }
      } else {
        if (this.k1i_1 === 0.0 && this.l1i_1 === 0.0) {
          this.m1i_1 = 2;
          this.n1i_1 = -1;
        } else {
          this.m1i_1 = 3;
          this.n1i_1 = -1;
        }
      }
    } else {
      if (this.g1i_1 === 0.0 && this.j1i_1 === 0.0) {
        if (this.k1i_1 === 0.0 && this.l1i_1 === 0.0) {
          this.m1i_1 = 4;
          this.n1i_1 = -1;
        } else {
          this.m1i_1 = 5;
          this.n1i_1 = -1;
        }
      } else {
        if (this.k1i_1 === 0.0 && this.l1i_1 === 0.0) {
          this.m1i_1 = 6;
          this.n1i_1 = -1;
        } else {
          this.m1i_1 = 7;
          this.n1i_1 = -1;
        }
      }
    }
  }
  static m1j(m00, m10, m01, m11, m02, m12) {
    Companion_getInstance_34();
    var $this = createThis(this);
    init_org_mkui_geom_AffineTransform($this);
    $this.g1i_1 = m00;
    $this.h1i_1 = m10;
    $this.i1i_1 = m01;
    $this.j1i_1 = m11;
    $this.k1i_1 = m02;
    $this.l1i_1 = m12;
    $this.l1j();
    return $this;
  }
  n1j(sx, sy) {
    this.g1i_1 = sx;
    this.h1i_1 = 0.0;
    this.i1i_1 = 0.0;
    this.j1i_1 = sy;
    this.k1i_1 = 0.0;
    this.l1i_1 = 0.0;
    if (!(sx === 1.0) || !(sy === 1.0)) {
      this.m1i_1 = 2;
      this.n1i_1 = -1;
    } else {
      this.m1i_1 = 0;
      this.n1i_1 = 0;
    }
  }
  o1j(tx, ty) {
    switch (this.m1i_1) {
      case 7:
        this.k1i_1 = tx * this.g1i_1 + ty * this.i1i_1 + this.k1i_1;
        this.l1i_1 = tx * this.h1i_1 + ty * this.j1i_1 + this.l1i_1;
        if (this.k1i_1 === 0.0 && this.l1i_1 === 0.0) {
          this.m1i_1 = 6;
          if (!(this.n1i_1 === -1)) {
            this.n1i_1 = this.n1i_1 - 1 | 0;
          }
        }

        return Unit_instance;
      case 6:
        this.k1i_1 = tx * this.g1i_1 + ty * this.i1i_1;
        this.l1i_1 = tx * this.h1i_1 + ty * this.j1i_1;
        if (!(this.k1i_1 === 0.0) || !(this.l1i_1 === 0.0)) {
          this.m1i_1 = 7;
          this.n1i_1 = this.n1i_1 | 1;
        }

        return Unit_instance;
      case 5:
        this.k1i_1 = ty * this.i1i_1 + this.k1i_1;
        this.l1i_1 = tx * this.h1i_1 + this.l1i_1;
        if (this.k1i_1 === 0.0 && this.l1i_1 === 0.0) {
          this.m1i_1 = 4;
          if (!(this.n1i_1 === -1)) {
            this.n1i_1 = this.n1i_1 - 1 | 0;
          }
        }

        return Unit_instance;
      case 4:
        this.k1i_1 = ty * this.i1i_1;
        this.l1i_1 = tx * this.h1i_1;
        if (!(this.k1i_1 === 0.0) || !(this.l1i_1 === 0.0)) {
          this.m1i_1 = 5;
          this.n1i_1 = this.n1i_1 | 1;
        }

        return Unit_instance;
      case 3:
        this.k1i_1 = tx * this.g1i_1 + this.k1i_1;
        this.l1i_1 = ty * this.j1i_1 + this.l1i_1;
        if (this.k1i_1 === 0.0 && this.l1i_1 === 0.0) {
          this.m1i_1 = 2;
          if (!(this.n1i_1 === -1)) {
            this.n1i_1 = this.n1i_1 - 1 | 0;
          }
        }

        return Unit_instance;
      case 2:
        this.k1i_1 = tx * this.g1i_1;
        this.l1i_1 = ty * this.j1i_1;
        if (!(this.k1i_1 === 0.0) || !(this.l1i_1 === 0.0)) {
          this.m1i_1 = 3;
          this.n1i_1 = this.n1i_1 | 1;
        }

        return Unit_instance;
      case 1:
        this.k1i_1 = tx + this.k1i_1;
        this.l1i_1 = ty + this.l1i_1;
        if (this.k1i_1 === 0.0 && this.l1i_1 === 0.0) {
          this.m1i_1 = 0;
          this.n1i_1 = 0;
        }

        return Unit_instance;
      case 0:
        this.k1i_1 = tx;
        this.l1i_1 = ty;
        if (!(tx === 0.0) || !(ty === 0.0)) {
          this.m1i_1 = 1;
          this.n1i_1 = 1;
        }

        return Unit_instance;
      default:
        stateError(this);
        return Unit_instance;
    }
  }
  p1j(theta) {
    // Inline function 'kotlin.math.sin' call
    var sin = Math.sin(theta);
    if (sin === 1.0) {
      rotate90(this);
    } else if (sin === -1.0) {
      rotate270(this);
    } else {
      // Inline function 'kotlin.math.cos' call
      var cos = Math.cos(theta);
      if (cos === -1.0) {
        rotate180(this);
      } else if (!(cos === 1.0)) {
        var M0 = this.g1i_1;
        var M1 = this.i1i_1;
        this.g1i_1 = cos * M0 + sin * M1;
        this.i1i_1 = -sin * M0 + cos * M1;
        M0 = this.h1i_1;
        M1 = this.j1i_1;
        this.h1i_1 = cos * M0 + sin * M1;
        this.j1i_1 = -sin * M0 + cos * M1;
        this.l1j();
      }
    }
  }
  q1j() {
    this.j1i_1 = 1.0;
    this.g1i_1 = this.j1i_1;
    this.l1i_1 = 0.0;
    this.k1i_1 = this.l1i_1;
    this.i1i_1 = this.k1i_1;
    this.h1i_1 = this.i1i_1;
    this.m1i_1 = 0;
    this.n1i_1 = 0;
  }
  r1j(Tx) {
    var M0;
    var T01;
    var T10;
    var mystate = this.m1i_1;
    var txstate = Tx.m1i_1;
    switch (txstate << 3 | mystate) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
        return Unit_instance;
      case 56:
        this.i1i_1 = Tx.i1i_1;
        this.h1i_1 = Tx.h1i_1;
        this.g1i_1 = Tx.g1i_1;
        this.j1i_1 = Tx.j1i_1;
        this.k1i_1 = Tx.k1i_1;
        this.l1i_1 = Tx.l1i_1;
        this.m1i_1 = txstate;
        this.n1i_1 = Tx.n1i_1;
        return Unit_instance;
      case 24:
        this.g1i_1 = Tx.g1i_1;
        this.j1i_1 = Tx.j1i_1;
        this.k1i_1 = Tx.k1i_1;
        this.l1i_1 = Tx.l1i_1;
        this.m1i_1 = txstate;
        this.n1i_1 = Tx.n1i_1;
        return Unit_instance;
      case 8:
        this.k1i_1 = Tx.k1i_1;
        this.l1i_1 = Tx.l1i_1;
        this.m1i_1 = txstate;
        this.n1i_1 = Tx.n1i_1;
        return Unit_instance;
      case 48:
        this.i1i_1 = Tx.i1i_1;
        this.h1i_1 = Tx.h1i_1;
        this.g1i_1 = Tx.g1i_1;
        this.j1i_1 = Tx.j1i_1;
        this.m1i_1 = txstate;
        this.n1i_1 = Tx.n1i_1;
        return Unit_instance;
      case 16:
        this.g1i_1 = Tx.g1i_1;
        this.j1i_1 = Tx.j1i_1;
        this.m1i_1 = txstate;
        this.n1i_1 = Tx.n1i_1;
        return Unit_instance;
      case 40:
        this.k1i_1 = Tx.k1i_1;
        this.l1i_1 = Tx.l1i_1;
        this.i1i_1 = Tx.i1i_1;
        this.h1i_1 = Tx.h1i_1;
        // Inline function 'kotlin.run' call

        this.j1i_1 = 0.0;
        this.g1i_1 = this.j1i_1;
        this.m1i_1 = txstate;
        this.n1i_1 = Tx.n1i_1;
        return Unit_instance;
      case 32:
        this.i1i_1 = Tx.i1i_1;
        this.h1i_1 = Tx.h1i_1;
        // Inline function 'kotlin.run' call

        this.j1i_1 = 0.0;
        this.g1i_1 = this.j1i_1;
        this.m1i_1 = txstate;
        this.n1i_1 = Tx.n1i_1;
        return Unit_instance;
      case 15:
      case 14:
      case 13:
      case 12:
      case 11:
      case 10:
      case 9:
        this.o1j(Tx.k1i_1, Tx.l1i_1);
        return Unit_instance;
      case 23:
      case 22:
      case 21:
      case 20:
      case 19:
      case 18:
      case 17:
        this.s1j(Tx.g1i_1, Tx.j1i_1);
        return Unit_instance;
      case 39:
      case 38:
        T01 = Tx.i1i_1;
        T10 = Tx.h1i_1;
        M0 = this.g1i_1;
        this.g1i_1 = this.i1i_1 * T10;
        this.i1i_1 = M0 * T01;
        M0 = this.h1i_1;
        this.h1i_1 = this.j1i_1 * T10;
        this.j1i_1 = M0 * T01;
        this.n1i_1 = -1;
        return Unit_instance;
      case 37:
      case 36:
        this.g1i_1 = this.i1i_1 * Tx.h1i_1;
        this.i1i_1 = 0.0;
        this.j1i_1 = this.h1i_1 * Tx.i1i_1;
        this.h1i_1 = 0.0;
        this.m1i_1 = mystate ^ 6;
        this.n1i_1 = -1;
        return Unit_instance;
      case 35:
      case 34:
        this.i1i_1 = this.g1i_1 * Tx.i1i_1;
        this.g1i_1 = 0.0;
        this.h1i_1 = this.j1i_1 * Tx.h1i_1;
        this.j1i_1 = 0.0;
        this.m1i_1 = mystate ^ 6;
        this.n1i_1 = -1;
        return Unit_instance;
      case 33:
        this.g1i_1 = 0.0;
        this.i1i_1 = Tx.i1i_1;
        this.h1i_1 = Tx.h1i_1;
        this.j1i_1 = 0.0;
        this.m1i_1 = 5;
        this.n1i_1 = -1;
        return Unit_instance;
    }
    var T00 = Tx.g1i_1;
    T01 = Tx.i1i_1;
    var T02 = Tx.k1i_1;
    T10 = Tx.h1i_1;
    var T11 = Tx.j1i_1;
    var T12 = Tx.l1i_1;
    var M1;
    switch (mystate) {
      case 6:
        this.m1i_1 = mystate | txstate;
        M0 = this.g1i_1;
        M1 = this.i1i_1;
        this.g1i_1 = T00 * M0 + T10 * M1;
        this.i1i_1 = T01 * M0 + T11 * M1;
        this.k1i_1 = this.k1i_1 + (T02 * M0 + T12 * M1);
        M0 = this.h1i_1;
        M1 = this.j1i_1;
        this.h1i_1 = T00 * M0 + T10 * M1;
        this.j1i_1 = T01 * M0 + T11 * M1;
        this.l1i_1 = this.l1i_1 + (T02 * M0 + T12 * M1);
        this.n1i_1 = -1;
        return Unit_instance;
      case 7:
        M0 = this.g1i_1;
        M1 = this.i1i_1;
        this.g1i_1 = T00 * M0 + T10 * M1;
        this.i1i_1 = T01 * M0 + T11 * M1;
        this.k1i_1 = this.k1i_1 + (T02 * M0 + T12 * M1);
        M0 = this.h1i_1;
        M1 = this.j1i_1;
        this.h1i_1 = T00 * M0 + T10 * M1;
        this.j1i_1 = T01 * M0 + T11 * M1;
        this.l1i_1 = this.l1i_1 + (T02 * M0 + T12 * M1);
        this.n1i_1 = -1;
        return Unit_instance;
      case 5:
      case 4:
        M0 = this.i1i_1;
        this.g1i_1 = T10 * M0;
        this.i1i_1 = T11 * M0;
        this.k1i_1 = this.k1i_1 + T12 * M0;
        M0 = this.h1i_1;
        this.h1i_1 = T00 * M0;
        this.j1i_1 = T01 * M0;
        this.l1i_1 = this.l1i_1 + T02 * M0;
        break;
      case 3:
      case 2:
        M0 = this.g1i_1;
        this.g1i_1 = T00 * M0;
        this.i1i_1 = T01 * M0;
        this.k1i_1 = this.k1i_1 + T02 * M0;
        M0 = this.j1i_1;
        this.h1i_1 = T10 * M0;
        this.j1i_1 = T11 * M0;
        this.l1i_1 = this.l1i_1 + T12 * M0;
        break;
      case 1:
        this.g1i_1 = T00;
        this.i1i_1 = T01;
        this.k1i_1 = this.k1i_1 + T02;
        this.h1i_1 = T10;
        this.j1i_1 = T11;
        this.l1i_1 = this.l1i_1 + T12;
        this.m1i_1 = txstate | 1;
        this.n1i_1 = -1;
        return Unit_instance;
      default:
        stateError(this);
        this.m1i_1 = mystate | txstate;
        M0 = this.g1i_1;
        M1 = this.i1i_1;
        this.g1i_1 = T00 * M0 + T10 * M1;
        this.i1i_1 = T01 * M0 + T11 * M1;
        this.k1i_1 = this.k1i_1 + (T02 * M0 + T12 * M1);
        M0 = this.h1i_1;
        M1 = this.j1i_1;
        this.h1i_1 = T00 * M0 + T10 * M1;
        this.j1i_1 = T01 * M0 + T11 * M1;
        this.l1i_1 = this.l1i_1 + (T02 * M0 + T12 * M1);
        this.n1i_1 = -1;
        return Unit_instance;
    }
    this.l1j();
  }
  s1j(sx, sy) {
    var state = this.m1i_1;
    switch (state) {
      case 7:
      case 6:
        this.g1i_1 = this.g1i_1 * sx;
        this.j1i_1 = this.j1i_1 * sy;
        this.i1i_1 = this.i1i_1 * sy;
        this.h1i_1 = this.h1i_1 * sx;
        if (this.i1i_1 === 0.0 && this.h1i_1 === 0.0) {
          state = state & 1;
          if (this.g1i_1 === 1.0 && this.j1i_1 === 1.0) {
            this.n1i_1 = state === 0 ? 0 : 1;
          } else {
            state = state | 2;
            this.n1i_1 = -1;
          }
          this.m1i_1 = state;
        }

        return Unit_instance;
      case 5:
      case 4:
        this.i1i_1 = this.i1i_1 * sy;
        this.h1i_1 = this.h1i_1 * sx;
        if (this.i1i_1 === 0.0 && this.h1i_1 === 0.0) {
          state = state & 1;
          if (this.g1i_1 === 1.0 && this.j1i_1 === 1.0) {
            this.n1i_1 = state === 0 ? 0 : 1;
          } else {
            state = state | 2;
            this.n1i_1 = -1;
          }
          this.m1i_1 = state;
        }

        return Unit_instance;
      case 3:
      case 2:
        this.g1i_1 = this.g1i_1 * sx;
        this.j1i_1 = this.j1i_1 * sy;
        if (this.g1i_1 === 1.0 && this.j1i_1 === 1.0) {
          var tmp = this;
          // Inline function 'kotlin.let' call
          state = state & 1;
          tmp.m1i_1 = state;
          this.n1i_1 = state === 0 ? 0 : 1;
        } else {
          this.n1i_1 = -1;
        }

        return Unit_instance;
      case 1:
      case 0:
        this.g1i_1 = sx;
        this.j1i_1 = sy;
        if (!(sx === 1.0) || !(sy === 1.0)) {
          this.m1i_1 = state | 2;
          this.n1i_1 = -1;
        }

        return Unit_instance;
      default:
        stateError(this);
        this.g1i_1 = this.g1i_1 * sx;
        this.j1i_1 = this.j1i_1 * sy;
        this.i1i_1 = this.i1i_1 * sy;
        this.h1i_1 = this.h1i_1 * sx;
        if (this.i1i_1 === 0.0 && this.h1i_1 === 0.0) {
          state = state & 1;
          if (this.g1i_1 === 1.0 && this.j1i_1 === 1.0) {
            this.n1i_1 = state === 0 ? 0 : 1;
          } else {
            state = state | 2;
            this.n1i_1 = -1;
          }
          this.m1i_1 = state;
        }

        return Unit_instance;
    }
  }
  t1j(ptSrc, ptDst) {
    var ptDst_0 = ptDst;
    if (ptDst_0 == null) {
      var tmp;
      if (ptSrc instanceof Double_2) {
        tmp = Double_2.z1j();
      } else {
        tmp = Float.w1j();
      }
      ptDst_0 = tmp;
    }
    var x = ptSrc.g1h();
    var y = ptSrc.h1h();
    var tmp_0;
    switch (this.m1i_1) {
      case 7:
        ptDst_0.a1k(x * this.g1i_1 + y * this.i1i_1 + this.k1i_1, x * this.h1i_1 + y * this.j1i_1 + this.l1i_1);
        tmp_0 = ptDst_0;
        break;
      case 6:
        ptDst_0.a1k(x * this.g1i_1 + y * this.i1i_1, x * this.h1i_1 + y * this.j1i_1);
        tmp_0 = ptDst_0;
        break;
      case 5:
        ptDst_0.a1k(y * this.i1i_1 + this.k1i_1, x * this.h1i_1 + this.l1i_1);
        tmp_0 = ptDst_0;
        break;
      case 4:
        ptDst_0.a1k(y * this.i1i_1, x * this.h1i_1);
        tmp_0 = ptDst_0;
        break;
      case 3:
        ptDst_0.a1k(x * this.g1i_1 + this.k1i_1, y * this.j1i_1 + this.l1i_1);
        tmp_0 = ptDst_0;
        break;
      case 2:
        ptDst_0.a1k(x * this.g1i_1, y * this.j1i_1);
        tmp_0 = ptDst_0;
        break;
      case 1:
        ptDst_0.a1k(x + this.k1i_1, y + this.l1i_1);
        tmp_0 = ptDst_0;
        break;
      case 0:
        ptDst_0.a1k(x, y);
        tmp_0 = ptDst_0;
        break;
      default:
        stateError(this);
        tmp_0 = null;
        break;
    }
    return tmp_0;
  }
  b1k(srcPts, srcOff, dstPts, dstOff, numPts) {
    var srcOff_0 = srcOff;
    var dstOff_0 = dstOff;
    var numPts_0 = numPts;
    if (equals(dstPts, srcPts) && dstOff_0 > srcOff_0 && dstOff_0 < (srcOff_0 + imul_0(numPts_0, 2) | 0)) {
      arraycopy_0(srcPts, srcOff_0, dstPts, dstOff_0, imul_0(numPts_0, 2));
      srcOff_0 = dstOff_0;
    }
    var M12;
    var M11;
    var M10;
    var M02;
    var M01;
    var M00;
    switch (this.m1i_1) {
      case 7:
        M00 = this.g1i_1;
        M01 = this.i1i_1;
        M02 = this.k1i_1;
        M10 = this.h1i_1;
        M11 = this.j1i_1;
        M12 = this.l1i_1;
        $l$loop: while (true) {
          numPts_0 = numPts_0 - 1 | 0;
          if (!(numPts_0 >= 0)) {
            break $l$loop;
          }
          var _unary__edvuaz = srcOff_0;
          srcOff_0 = _unary__edvuaz + 1 | 0;
          var x = srcPts[_unary__edvuaz];
          var _unary__edvuaz_0 = srcOff_0;
          srcOff_0 = _unary__edvuaz_0 + 1 | 0;
          var y = srcPts[_unary__edvuaz_0];
          var _unary__edvuaz_1 = dstOff_0;
          dstOff_0 = _unary__edvuaz_1 + 1 | 0;
          dstPts[_unary__edvuaz_1] = M00 * x + M01 * y + M02;
          var _unary__edvuaz_2 = dstOff_0;
          dstOff_0 = _unary__edvuaz_2 + 1 | 0;
          dstPts[_unary__edvuaz_2] = M10 * x + M11 * y + M12;
        }

        return Unit_instance;
      case 6:
        M00 = this.g1i_1;
        M01 = this.i1i_1;
        M10 = this.h1i_1;
        M11 = this.j1i_1;
        $l$loop_0: while (true) {
          numPts_0 = numPts_0 - 1 | 0;
          if (!(numPts_0 >= 0)) {
            break $l$loop_0;
          }
          var _unary__edvuaz_3 = srcOff_0;
          srcOff_0 = _unary__edvuaz_3 + 1 | 0;
          var x_0 = srcPts[_unary__edvuaz_3];
          var _unary__edvuaz_4 = srcOff_0;
          srcOff_0 = _unary__edvuaz_4 + 1 | 0;
          var y_0 = srcPts[_unary__edvuaz_4];
          var _unary__edvuaz_5 = dstOff_0;
          dstOff_0 = _unary__edvuaz_5 + 1 | 0;
          dstPts[_unary__edvuaz_5] = M00 * x_0 + M01 * y_0;
          var _unary__edvuaz_6 = dstOff_0;
          dstOff_0 = _unary__edvuaz_6 + 1 | 0;
          dstPts[_unary__edvuaz_6] = M10 * x_0 + M11 * y_0;
        }

        return Unit_instance;
      case 5:
        M01 = this.i1i_1;
        M02 = this.k1i_1;
        M10 = this.h1i_1;
        M12 = this.l1i_1;
        $l$loop_1: while (true) {
          numPts_0 = numPts_0 - 1 | 0;
          if (!(numPts_0 >= 0)) {
            break $l$loop_1;
          }
          var _unary__edvuaz_7 = srcOff_0;
          srcOff_0 = _unary__edvuaz_7 + 1 | 0;
          var x_1 = srcPts[_unary__edvuaz_7];
          var _unary__edvuaz_8 = dstOff_0;
          dstOff_0 = _unary__edvuaz_8 + 1 | 0;
          var _unary__edvuaz_9 = srcOff_0;
          srcOff_0 = _unary__edvuaz_9 + 1 | 0;
          dstPts[_unary__edvuaz_8] = M01 * srcPts[_unary__edvuaz_9] + M02;
          var _unary__edvuaz_10 = dstOff_0;
          dstOff_0 = _unary__edvuaz_10 + 1 | 0;
          dstPts[_unary__edvuaz_10] = M10 * x_1 + M12;
        }

        return Unit_instance;
      case 4:
        M01 = this.i1i_1;
        M10 = this.h1i_1;
        $l$loop_2: while (true) {
          numPts_0 = numPts_0 - 1 | 0;
          if (!(numPts_0 >= 0)) {
            break $l$loop_2;
          }
          var _unary__edvuaz_11 = srcOff_0;
          srcOff_0 = _unary__edvuaz_11 + 1 | 0;
          var x_2 = srcPts[_unary__edvuaz_11];
          var _unary__edvuaz_12 = dstOff_0;
          dstOff_0 = _unary__edvuaz_12 + 1 | 0;
          var _unary__edvuaz_13 = srcOff_0;
          srcOff_0 = _unary__edvuaz_13 + 1 | 0;
          dstPts[_unary__edvuaz_12] = M01 * srcPts[_unary__edvuaz_13];
          var _unary__edvuaz_14 = dstOff_0;
          dstOff_0 = _unary__edvuaz_14 + 1 | 0;
          dstPts[_unary__edvuaz_14] = M10 * x_2;
        }

        return Unit_instance;
      case 3:
        M00 = this.g1i_1;
        M02 = this.k1i_1;
        M11 = this.j1i_1;
        M12 = this.l1i_1;
        $l$loop_3: while (true) {
          numPts_0 = numPts_0 - 1 | 0;
          if (!(numPts_0 >= 0)) {
            break $l$loop_3;
          }
          var _unary__edvuaz_15 = dstOff_0;
          dstOff_0 = _unary__edvuaz_15 + 1 | 0;
          var _unary__edvuaz_16 = srcOff_0;
          srcOff_0 = _unary__edvuaz_16 + 1 | 0;
          dstPts[_unary__edvuaz_15] = M00 * srcPts[_unary__edvuaz_16] + M02;
          var _unary__edvuaz_17 = dstOff_0;
          dstOff_0 = _unary__edvuaz_17 + 1 | 0;
          var _unary__edvuaz_18 = srcOff_0;
          srcOff_0 = _unary__edvuaz_18 + 1 | 0;
          dstPts[_unary__edvuaz_17] = M11 * srcPts[_unary__edvuaz_18] + M12;
        }

        return Unit_instance;
      case 2:
        M00 = this.g1i_1;
        M11 = this.j1i_1;
        $l$loop_4: while (true) {
          numPts_0 = numPts_0 - 1 | 0;
          if (!(numPts_0 >= 0)) {
            break $l$loop_4;
          }
          var _unary__edvuaz_19 = dstOff_0;
          dstOff_0 = _unary__edvuaz_19 + 1 | 0;
          var _unary__edvuaz_20 = srcOff_0;
          srcOff_0 = _unary__edvuaz_20 + 1 | 0;
          dstPts[_unary__edvuaz_19] = M00 * srcPts[_unary__edvuaz_20];
          var _unary__edvuaz_21 = dstOff_0;
          dstOff_0 = _unary__edvuaz_21 + 1 | 0;
          var _unary__edvuaz_22 = srcOff_0;
          srcOff_0 = _unary__edvuaz_22 + 1 | 0;
          dstPts[_unary__edvuaz_21] = M11 * srcPts[_unary__edvuaz_22];
        }

        return Unit_instance;
      case 1:
        M02 = this.k1i_1;
        M12 = this.l1i_1;
        $l$loop_5: while (true) {
          numPts_0 = numPts_0 - 1 | 0;
          if (!(numPts_0 >= 0)) {
            break $l$loop_5;
          }
          var _unary__edvuaz_23 = dstOff_0;
          dstOff_0 = _unary__edvuaz_23 + 1 | 0;
          var _unary__edvuaz_24 = srcOff_0;
          srcOff_0 = _unary__edvuaz_24 + 1 | 0;
          dstPts[_unary__edvuaz_23] = srcPts[_unary__edvuaz_24] + M02;
          var _unary__edvuaz_25 = dstOff_0;
          dstOff_0 = _unary__edvuaz_25 + 1 | 0;
          var _unary__edvuaz_26 = srcOff_0;
          srcOff_0 = _unary__edvuaz_26 + 1 | 0;
          dstPts[_unary__edvuaz_25] = srcPts[_unary__edvuaz_26] + M12;
        }

        return Unit_instance;
      case 0:
        if (!equals(srcPts, dstPts) || !(srcOff_0 === dstOff_0)) {
          arraycopy_0(srcPts, srcOff_0, dstPts, dstOff_0, imul_0(numPts_0, 2));
        }

        return Unit_instance;
      default:
        stateError(this);
        return Unit_instance;
    }
  }
  c1k(pSrc) {
    var tmp;
    if (pSrc == null) {
      tmp = null;
    } else {
      tmp = Double_1.i1k(pSrc, this);
    }
    return tmp;
  }
  hashCode() {
    var bits = toRawBits(this.g1i_1);
    // Inline function 'kotlin.Long.times' call
    var this_0 = bits;
    var tmp$ret$0 = multiply_0(this_0, fromInt_0(31));
    bits = add_0(tmp$ret$0, toRawBits(this.i1i_1));
    // Inline function 'kotlin.Long.times' call
    var this_1 = bits;
    var tmp$ret$1 = multiply_0(this_1, fromInt_0(31));
    bits = add_0(tmp$ret$1, toRawBits(this.k1i_1));
    // Inline function 'kotlin.Long.times' call
    var this_2 = bits;
    var tmp$ret$2 = multiply_0(this_2, fromInt_0(31));
    bits = add_0(tmp$ret$2, toRawBits(this.h1i_1));
    // Inline function 'kotlin.Long.times' call
    var this_3 = bits;
    var tmp$ret$3 = multiply_0(this_3, fromInt_0(31));
    bits = add_0(tmp$ret$3, toRawBits(this.j1i_1));
    // Inline function 'kotlin.Long.times' call
    var this_4 = bits;
    var tmp$ret$4 = multiply_0(this_4, fromInt_0(31));
    bits = add_0(tmp$ret$4, toRawBits(this.l1i_1));
    return convertToInt(bits) ^ convertToInt(shiftRight(bits, 32));
  }
  equals(obj) {
    if (!(obj instanceof AffineTransform)) {
      return false;
    }
    return this.g1i_1 === obj.g1i_1 && this.i1i_1 === obj.i1i_1 && this.k1i_1 === obj.k1i_1 && this.h1i_1 === obj.h1i_1 && this.j1i_1 === obj.j1i_1 && this.l1i_1 === obj.l1i_1;
  }
  toString() {
    return 'AffineTransform[[' + _matround(Companion_getInstance_34(), this.g1i_1) + ', ' + _matround(Companion_getInstance_34(), this.i1i_1) + ', ' + _matround(Companion_getInstance_34(), this.k1i_1) + '], [' + _matround(Companion_getInstance_34(), this.h1i_1) + ', ' + _matround(Companion_getInstance_34(), this.j1i_1) + ', ' + _matround(Companion_getInstance_34(), this.l1i_1) + ']]';
  }
}
class Companion_35 {
  j1k(angle) {
    var angle_0 = angle;
    if (angle_0 > 180.0) {
      if (angle_0 <= 180.0 + 360.0) {
        angle_0 = angle_0 - 360.0;
      } else {
        angle_0 = this.k1k(angle_0, 360.0);
        if (angle_0 === -180.0) {
          angle_0 = 180.0;
        }
      }
    } else if (angle_0 <= -180.0) {
      if (angle_0 > -180.0 - 360.0) {
        angle_0 = angle_0 + 360.0;
      } else {
        angle_0 = this.k1k(angle_0, 360.0);
        if (angle_0 === -180.0) {
          angle_0 = 180.0;
        }
      }
    }
    return angle_0;
  }
  k1k(f1, f2) {
    // Inline function 'kotlin.math.abs' call
    var x = f1 % f2;
    var r = Math.abs(x);
    var tmp;
    var tmp_0;
    if (isNaN_0(r) || r === f2) {
      tmp_0 = true;
    } else {
      // Inline function 'kotlin.math.abs' call
      tmp_0 = r <= Math.abs(f2) / 2.0;
    }
    if (tmp_0) {
      tmp = r;
    } else {
      // Inline function 'kotlin.math.sign' call
      tmp = sign(f1) * (r - f2);
    }
    return tmp;
  }
}
class Arc2D {}
class Double {
  g1h() {
    return this.l1k_1;
  }
  h1h() {
    return this.m1k_1;
  }
  gm() {
    return this.n1k_1;
  }
  hm() {
    return this.o1k_1;
  }
  s1k() {
    return this.r1k_1;
  }
  static t1k(bounds, start, extent, type) {
    var $this = createThis(this);
    init_org_mkui_geom_Arc2D_Double($this);
    $this.l1k_1 = bounds.g1h();
    $this.m1k_1 = bounds.h1h();
    $this.n1k_1 = bounds.gm();
    $this.o1k_1 = bounds.hm();
    $this.p1k_1 = start;
    $this.q1k_1 = extent;
    $this.r1k_1 = type;
    return $this;
  }
  i1h() {
    return this.u1k();
  }
  u1k() {
    if (this.v1k()) {
      return Double_3.z1h(this.l1k_1, this.m1k_1, this.n1k_1, this.o1k_1);
    }
    var x1;
    var y1;
    var x2;
    var y2;
    if (this.r1k_1 === 2) {
      y2 = 0.0;
      x2 = y2;
      y1 = x2;
      x1 = y1;
    } else {
      y1 = 1.0;
      x1 = y1;
      y2 = -1.0;
      x2 = y2;
    }
    var angle = 0.0;
    var inductionVariable = 0;
    if (inductionVariable <= 5)
      $l$loop: do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        if (i < 4) {
          angle = angle + 90.0;
          if (!this.y1k(angle)) {
            continue $l$loop;
          }
        } else if (i === 4) {
          angle = this.x1k();
        } else {
          angle = angle + this.w1k();
        }
        var rads = convertDegreesToRadians(-angle);
        // Inline function 'kotlin.math.cos' call
        var xe = Math.cos(rads);
        // Inline function 'kotlin.math.min' call
        var a = x1;
        x1 = Math.min(a, xe);
        // Inline function 'kotlin.math.sin' call
        var ye = Math.sin(rads);
        // Inline function 'kotlin.math.min' call
        var a_0 = y1;
        y1 = Math.min(a_0, ye);
        // Inline function 'kotlin.math.max' call
        var a_1 = x2;
        x2 = Math.max(a_1, xe);
        // Inline function 'kotlin.math.max' call
        var a_2 = y2;
        y2 = Math.max(a_2, ye);
      }
       while (inductionVariable <= 5);
    var w = this.n1k_1;
    var h = this.o1k_1;
    x2 = (x2 - x1) * 0.5 * w;
    y2 = (y2 - y1) * 0.5 * h;
    x1 = this.l1k_1 + (x1 * 0.5 + 0.5) * w;
    y1 = this.m1k_1 + (y1 * 0.5 + 0.5) * h;
    return Double_3.z1h(x1, y1, x2, y2);
  }
  v1k() {
    return this.n1k_1 <= 0.0 || this.o1k_1 <= 0.0;
  }
  j1h(point) {
    var x = point.g1h();
    var y = point.h1h();
    var ellw = this.n1k_1;
    if (ellw <= 0.0) {
      return false;
    }
    var normx = (x - x) / ellw - 0.5;
    var ellh = this.o1k_1;
    if (ellh <= 0.0) {
      return false;
    }
    var normy = (y - y) / ellh - 0.5;
    var distSq = normx * normx + normy * normy;
    if (distSq >= 0.25) {
      return false;
    }
    // Inline function 'kotlin.math.abs' call
    var x_0 = this.w1k();
    var angExt = Math.abs(x_0);
    if (angExt >= 360.0) {
      return true;
    }
    // Inline function 'kotlin.math.atan2' call
    var tmp$ret$1 = Math.atan2(normy, normx);
    var inarc = this.y1k(-convertRadiansToDegrees(tmp$ret$1));
    if (this.r1k_1 === 2) {
      return inarc;
    }
    if (inarc) {
      if (angExt >= 180.0) {
        return true;
      }
    } else {
      if (angExt <= 180.0) {
        return false;
      }
    }
    var angle = convertDegreesToRadians(-this.x1k());
    // Inline function 'kotlin.math.cos' call
    var x_1 = angle;
    var x1 = Math.cos(x_1);
    // Inline function 'kotlin.math.sin' call
    var x_2 = angle;
    var y1 = Math.sin(x_2);
    angle = angle + convertDegreesToRadians(-this.w1k());
    // Inline function 'kotlin.math.cos' call
    var x_3 = angle;
    var x2 = Math.cos(x_3);
    // Inline function 'kotlin.math.sin' call
    var x_4 = angle;
    var y2 = Math.sin(x_4);
    var inside = imul_0(Companion_instance_43.z1k(x1, y1, x2, y2, 2 * normx, 2 * normy), Companion_instance_43.z1k(x1, y1, x2, y2, 0.0, 0.0)) >= 0;
    return !(inarc === inside);
  }
  l1h(r) {
    var x = r.g1h();
    var y = r.h1h();
    var w = r.gm();
    var h = r.hm();
    var aw = this.n1k_1;
    var ah = this.o1k_1;
    if (w <= 0 || h <= 0 || aw <= 0 || ah <= 0) {
      return false;
    }
    var ext = this.w1k();
    if (ext === 0.0) {
      return false;
    }
    var ax = x;
    var ay = y;
    var axw = ax + aw;
    var ayh = ay + ah;
    var xw = x + w;
    var yh = y + h;
    if (x >= axw || y >= ayh || xw <= ax || yh <= ay) {
      return false;
    }
    var axc = this.k1h();
    var ayc = this.m1h();
    var sp = this.a1l();
    var ep = this.b1l();
    var sx = sp.g1h();
    var sy = sp.h1h();
    var ex = ep.g1h();
    var ey = ep.h1h();
    if (ayc >= y && ayc <= yh) {
      if (sx < xw && ex < xw && axc < xw && axw > x && this.y1k(0.0) || (sx > x && ex > x && axc > x && ax < xw && this.y1k(180.0))) {
        return true;
      }
    }
    if (axc >= x && axc <= xw) {
      if (sy > y && ey > y && ayc > y && ay < yh && this.y1k(90.0) || (sy < yh && ey < yh && ayc < yh && ayh > y && this.y1k(270.0))) {
        return true;
      }
    }
    var rect = Double_3.z1h(x, y, w, h);
    var tmp;
    if (this.r1k_1 === 2) {
      tmp = true;
    } else {
      // Inline function 'kotlin.math.abs' call
      tmp = Math.abs(ext) > 180;
    }
    if (tmp) {
      if (rect.a1i(axc, ayc, sx, sy) || rect.a1i(axc, ayc, ex, ey)) {
        return true;
      }
    } else {
      if (rect.a1i(sx, sy, ex, ey)) {
        return true;
      }
    }
    return this.j1h(Double_2.c1l(x, y)) || this.j1h(Double_2.c1l(x + w, y)) || this.j1h(Double_2.c1l(x, y + h)) || this.j1h(Double_2.c1l(x + w, y + h));
  }
  n1h() {
    return this.o1h(null);
  }
  o1h(at) {
    return new ArcIterator(this, at);
  }
  k1h() {
    return this.l1k_1 + this.n1k_1 / 2.0;
  }
  m1h() {
    return this.m1k_1 + this.o1k_1 / 2.0;
  }
  x1k() {
    return this.p1k_1;
  }
  w1k() {
    return this.q1k_1;
  }
  a1l() {
    return this.d1l();
  }
  d1l() {
    var angle = convertDegreesToRadians(-this.x1k());
    // Inline function 'kotlin.math.cos' call
    var tmp$ret$0 = Math.cos(angle);
    var x = this.l1k_1 + (tmp$ret$0 * 0.5 + 0.5) * this.n1k_1;
    // Inline function 'kotlin.math.sin' call
    var tmp$ret$1 = Math.sin(angle);
    var y = this.m1k_1 + (tmp$ret$1 * 0.5 + 0.5) * this.o1k_1;
    return Double_2.c1l(x, y);
  }
  b1l() {
    return this.e1l();
  }
  e1l() {
    var angle = convertDegreesToRadians(-this.x1k() - this.w1k());
    // Inline function 'kotlin.math.cos' call
    var tmp$ret$0 = Math.cos(angle);
    var x = this.l1k_1 + (tmp$ret$0 * 0.5 + 0.5) * this.n1k_1;
    // Inline function 'kotlin.math.sin' call
    var tmp$ret$1 = Math.sin(angle);
    var y = this.m1k_1 + (tmp$ret$1 * 0.5 + 0.5) * this.o1k_1;
    return Double_2.c1l(x, y);
  }
  y1k(angle) {
    var angle_0 = angle;
    var angExt = this.w1k();
    var backwards = angExt < 0.0;
    if (backwards) {
      angExt = -angExt;
    }
    if (angExt >= 360.0) {
      return true;
    }
    angle_0 = Companion_instance_35.j1k(angle_0) - Companion_instance_35.j1k(this.x1k());
    if (backwards) {
      angle_0 = -angle_0;
    }
    if (angle_0 < 0.0) {
      angle_0 = angle_0 + 360.0;
    }
    return angle_0 >= 0.0 && angle_0 < angExt;
  }
}
class Companion_36 {}
class ArcIterator {
  constructor(a, at) {
    this.l1l_1 = 0.0;
    this.m1l_1 = 0.0;
    this.n1l_1 = 0;
    this.o1l_1 = 0;
    this.p1l_1 = 0;
    this.h1l_1 = a.gm() / 2;
    this.i1l_1 = a.hm() / 2;
    this.f1l_1 = a.g1h() + this.h1l_1;
    this.g1l_1 = a.h1h() + this.i1l_1;
    this.j1l_1 = -convertDegreesToRadians(a.x1k());
    this.k1l_1 = at;
    var ext = -a.w1k();
    if (ext >= 360.0 || ext <= -360) {
      this.o1l_1 = 4;
      this.l1l_1 = 3.141592653589793 / 2;
      this.m1l_1 = 0.5522847498307933;
      if (ext < 0) {
        this.l1l_1 = -this.l1l_1;
        this.m1l_1 = -this.m1l_1;
      }
    } else {
      var tmp = this;
      // Inline function 'kotlin.math.abs' call
      // Inline function 'kotlin.math.ceil' call
      var x = Math.abs(ext) / 90.0;
      var tmp$ret$1 = Math.ceil(x);
      tmp.o1l_1 = numberToInt(tmp$ret$1);
      this.l1l_1 = convertDegreesToRadians(ext / this.o1l_1);
      this.m1l_1 = btan(Companion_instance_36, this.l1l_1);
      if (this.m1l_1 === 0.0) {
        this.o1l_1 = 0;
      }
    }
    switch (a.s1k()) {
      case 0:
        this.p1l_1 = 0;
        break;
      case 1:
        this.p1l_1 = 1;
        break;
      case 2:
        this.p1l_1 = 2;
        break;
    }
    if (this.h1l_1 < 0 || this.i1l_1 < 0) {
      this.p1l_1 = -1;
      this.o1l_1 = this.p1l_1;
    }
  }
  q1l() {
    return 1;
  }
  m17() {
    return this.n1l_1 > (this.o1l_1 + this.p1l_1 | 0);
  }
  r1l() {
    this.n1l_1 = this.n1l_1 + 1 | 0;
  }
  s1l(coords) {
    if (this.m17()) {
      throw NoSuchElementException.g1('arc iterator out of bounds');
    }
    var angle = this.j1l_1;
    if (this.n1l_1 === 0) {
      // Inline function 'kotlin.math.cos' call
      var x = angle;
      var tmp$ret$0 = Math.cos(x);
      coords[0] = this.f1l_1 + tmp$ret$0 * this.h1l_1;
      // Inline function 'kotlin.math.sin' call
      var x_0 = angle;
      var tmp$ret$1 = Math.sin(x_0);
      coords[1] = this.g1l_1 + tmp$ret$1 * this.i1l_1;
      var tmp0_safe_receiver = this.k1l_1;
      if (tmp0_safe_receiver == null)
        null;
      else {
        tmp0_safe_receiver.b1k(coords, 0, coords, 0, 1);
      }
      return 0;
    }
    if (this.n1l_1 > this.o1l_1) {
      if (this.n1l_1 === (this.o1l_1 + this.p1l_1 | 0)) {
        return 4;
      }
      coords[0] = this.f1l_1;
      coords[1] = this.g1l_1;
      var tmp1_safe_receiver = this.k1l_1;
      if (tmp1_safe_receiver == null)
        null;
      else {
        tmp1_safe_receiver.b1k(coords, 0, coords, 0, 1);
      }
      return 1;
    }
    angle = angle + this.l1l_1 * (this.n1l_1 - 1 | 0);
    // Inline function 'kotlin.math.cos' call
    var x_1 = angle;
    var relx = Math.cos(x_1);
    // Inline function 'kotlin.math.sin' call
    var x_2 = angle;
    var rely = Math.sin(x_2);
    coords[0] = this.f1l_1 + (relx - this.m1l_1 * rely) * this.h1l_1;
    coords[1] = this.g1l_1 + (rely + this.m1l_1 * relx) * this.i1l_1;
    angle = angle + this.l1l_1;
    // Inline function 'kotlin.math.cos' call
    var x_3 = angle;
    relx = Math.cos(x_3);
    // Inline function 'kotlin.math.sin' call
    var x_4 = angle;
    rely = Math.sin(x_4);
    coords[2] = this.f1l_1 + (relx + this.m1l_1 * rely) * this.h1l_1;
    coords[3] = this.g1l_1 + (rely - this.m1l_1 * relx) * this.i1l_1;
    coords[4] = this.f1l_1 + relx * this.h1l_1;
    coords[5] = this.g1l_1 + rely * this.i1l_1;
    var tmp2_safe_receiver = this.k1l_1;
    if (tmp2_safe_receiver == null)
      null;
    else {
      tmp2_safe_receiver.b1k(coords, 0, coords, 0, 3);
    }
    return 3;
  }
}
class AreaIterator {
  constructor(curves, at) {
    this.l1m_1 = 0;
    this.m1m_1 = null;
    this.n1m_1 = null;
    this.k1m_1 = curves;
    this.j1m_1 = at;
    if (curves.k1() >= 1) {
      var tmp = this;
      var tmp_0 = curves.l1(0);
      tmp.n1m_1 = tmp_0 instanceof Curve ? tmp_0 : THROW_CCE();
    }
  }
  q1l() {
    return 1;
  }
  m17() {
    return this.m1m_1 == null && this.n1m_1 == null;
  }
  r1l() {
    if (!(this.m1m_1 == null)) {
      this.m1m_1 = null;
    } else {
      this.m1m_1 = this.n1m_1;
      this.l1m_1 = this.l1m_1 + 1 | 0;
      if (this.l1m_1 < this.k1m_1.k1()) {
        this.n1m_1 = this.k1m_1.l1(this.l1m_1);
        if (!(ensureNotNull(this.n1m_1).o1m() === 0) && ensureNotNull(this.m1m_1).p1m() === ensureNotNull(this.n1m_1).g1m() && ensureNotNull(this.m1m_1).q1m() === ensureNotNull(this.n1m_1).h1m()) {
          this.m1m_1 = null;
        }
      } else {
        this.n1m_1 = null;
      }
    }
  }
  s1l(coords) {
    var segtype;
    var numpoints;
    if (!(this.m1m_1 == null)) {
      if (this.n1m_1 == null || ensureNotNull(this.n1m_1).o1m() === 0) {
        return 4;
      }
      coords[0] = ensureNotNull(this.n1m_1).g1m();
      coords[1] = ensureNotNull(this.n1m_1).h1m();
      segtype = 1;
      numpoints = 1;
    } else if (this.n1m_1 == null) {
      throw NoSuchElementException.g1('area iterator out of bounds');
    } else {
      segtype = ensureNotNull(this.n1m_1).r1m(coords);
      numpoints = ensureNotNull(this.n1m_1).o1m();
      if (numpoints === 0) {
        numpoints = 1;
      }
    }
    if (!(this.j1m_1 == null)) {
      this.j1m_1.b1k(coords, 0, coords, 0, numpoints);
    }
    return segtype;
  }
}
class Companion_37 {
  constructor() {
    Companion_instance_37 = this;
    this.b1m_1 = ArrayList.q1();
  }
}
class Area {
  static s1m() {
    Companion_getInstance_37();
    var $this = createThis(this);
    init_corg_mkui_geom_Area($this);
    $this.d1m_1 = Companion_getInstance_37().b1m_1;
    return $this;
  }
  static t1m(s) {
    Companion_getInstance_37();
    var $this = createThis(this);
    init_corg_mkui_geom_Area($this);
    var tmp = $this;
    var tmp_0;
    if (s instanceof Area) {
      tmp_0 = (s instanceof Area ? s : THROW_CCE()).d1m_1;
    } else {
      tmp_0 = pathToCurves(Companion_getInstance_37(), s.q1h());
    }
    tmp.d1m_1 = tmp_0;
    return $this;
  }
  u1m(rhs) {
    this.d1m_1 = (new IntOp()).c1m(ensureNotNull(this.d1m_1), ensureNotNull(rhs.d1m_1));
    invalidateBounds(this);
  }
  i1h() {
    return getCachedBounds(this).i1h();
  }
  j1h(point) {
    return this.f1i(point.g1h(), point.h1h());
  }
  f1i(x, y) {
    if (!getCachedBounds(this).f1i(x, y)) {
      return false;
    }
    var crossings = 0;
    var _iterator__ex2g4s = ensureNotNull(this.d1m_1).h1();
    while (_iterator__ex2g4s.i1()) {
      var c = _iterator__ex2g4s.j1();
      crossings = crossings + c.v1m(x, y) | 0;
    }
    return (crossings & 1) === 1;
  }
  l1h(rect) {
    return this.e1i(rect.g1h(), rect.h1h(), rect.gm(), rect.hm());
  }
  e1i(x, y, w, h) {
    if (w < 0 || h < 0) {
      return false;
    }
    if (!getCachedBounds(this).e1i(x, y, w, h)) {
      return false;
    }
    var c = Companion_instance_39.x1m(ensureNotNull(this.d1m_1), x, y, x + w, y + h);
    return c == null || !c.v1k();
  }
  n1h() {
    return new AreaIterator(ensureNotNull(this.d1m_1), null);
  }
  o1h(at) {
    return new AreaIterator(ensureNotNull(this.d1m_1), at);
  }
  equals(other) {
    if (other === this) {
      return true;
    }
    if (other == null) {
      return false;
    }
    if (other instanceof Area) {
      var c = (new XorOp()).c1m(ensureNotNull(this.d1m_1), ensureNotNull(other.d1m_1));
      return c.p1();
    } else {
      return false;
    }
  }
}
class sam$kotlin_Comparator$0_0 {
  constructor(function_0) {
    this.f1n_1 = function_0;
  }
  he(a, b) {
    return this.f1n_1(a, b);
  }
  compare(a, b) {
    return this.he(a, b);
  }
  k3() {
    return this.f1n_1;
  }
  equals(other) {
    var tmp;
    if (!(other == null) ? isInterface(other, Comparator) : false) {
      var tmp_0;
      if (!(other == null) ? isInterface(other, FunctionAdapter) : false) {
        tmp_0 = equals(this.k3(), other.k3());
      } else {
        tmp_0 = false;
      }
      tmp = tmp_0;
    } else {
      tmp = false;
    }
    return tmp;
  }
  hashCode() {
    return hashCode(this.k3());
  }
}
class AreaOp {
  constructor() {
    Companion_getInstance_38();
  }
  c1m(left, right) {
    var edges = ArrayList.q1();
    addEdges(Companion_getInstance_38(), edges, left, 0);
    addEdges(Companion_getInstance_38(), edges, right, 1);
    var curves = pruneEdges(this, edges);
    if (false) {
      println('result: ');
      var numcurves = curves.k1();
      // Inline function 'kotlin.collections.toTypedArray' call
      var curvelist = copyToArray(curves);
      var inductionVariable = 0;
      if (inductionVariable < numcurves)
        do {
          var i = inductionVariable;
          inductionVariable = inductionVariable + 1 | 0;
          println('curvelist[' + i + '] = ' + curvelist[i].toString());
        }
         while (inductionVariable < numcurves);
    }
    return curves;
  }
}
class CAGOp extends AreaOp {
  constructor() {
    super();
    this.r1o_1 = false;
    this.s1o_1 = false;
    this.t1o_1 = false;
  }
  d1o() {
    this.r1o_1 = false;
    this.s1o_1 = false;
    this.t1o_1 = false;
  }
  e1o(e) {
    if (e.h1n_1 === 0) {
      this.r1o_1 = !this.r1o_1;
    } else {
      this.s1o_1 = !this.s1o_1;
    }
    var newClass = this.u1o(this.r1o_1, this.s1o_1);
    if (this.t1o_1 === newClass) {
      return 0;
    }
    this.t1o_1 = newClass;
    return newClass ? 1 : -1;
  }
  f1o() {
    return this.t1o_1 ? 1 : -1;
  }
}
class IntOp extends CAGOp {
  u1o(inLeft, inRight) {
    return inLeft && inRight;
  }
}
class XorOp extends CAGOp {
  u1o(inLeft, inRight) {
    return !(inLeft === inRight);
  }
}
class NZWindOp extends AreaOp {
  constructor() {
    super();
    this.b1p_1 = 0;
  }
  d1o() {
    this.b1p_1 = 0;
  }
  e1o(e) {
    var newCount = this.b1p_1;
    var type = newCount === 0 ? 1 : 0;
    newCount = newCount + e.g1n_1.f1m_1 | 0;
    this.b1p_1 = newCount;
    return newCount === 0 ? -1 : type;
  }
  f1o() {
    return this.b1p_1 === 0 ? -1 : 1;
  }
}
class EOWindOp extends AreaOp {
  constructor() {
    super();
    this.c1p_1 = false;
  }
  d1o() {
    this.c1p_1 = false;
  }
  e1o(e) {
    var newInside = !this.c1p_1;
    this.c1p_1 = newInside;
    return newInside ? 1 : -1;
  }
  f1o() {
    return this.c1p_1 ? 1 : -1;
  }
}
class Companion_38 {
  constructor() {
    Companion_instance_38 = this;
    this.q1n_1 = 0;
    this.r1n_1 = 1;
    this.s1n_1 = 0;
    this.t1n_1 = 1;
    this.u1n_1 = -1;
    this.v1n_1 = 1;
    this.w1n_1 = -1;
    var tmp = this;
    var tmp_0 = AreaOp$Companion$YXTopComparator$lambda;
    tmp.x1n_1 = new sam$kotlin_Comparator$0_0(tmp_0);
    var tmp_1 = this;
    // Inline function 'kotlin.arrayOfNulls' call
    tmp_1.y1n_1 = Array(2);
    var tmp_2 = this;
    // Inline function 'kotlin.arrayOfNulls' call
    tmp_2.z1n_1 = Array(2);
  }
  b1o(subcurves, chains) {
    var numchains = chains.k1();
    if (numchains === 0) {
      return Unit_instance;
    }
    if (!((numchains & 1) === 0)) {
      throw UnsupportedOperationException.y8('Odd number of chains!');
    }
    // Inline function 'kotlin.collections.toTypedArray' call
    var endlist = copyToArray(chains);
    var i = 1;
    while (i < numchains) {
      var open = endlist[i - 1 | 0];
      var close = endlist[i];
      var subcurve = ensureNotNull(open).h1p(close);
      if (!(subcurve == null)) {
        subcurves.c1(subcurve);
      }
      i = i + 2 | 0;
    }
    chains.u4();
  }
  o1o(subcurves, chains, links) {
    var numlinks = links.k1();
    var linklist;
    var tmp;
    if (numlinks === 0) {
      tmp = this.y1n_1;
    } else {
      if (!((numlinks & 1) === 0)) {
        throw UnsupportedOperationException.y8('Odd number of new curves!');
      }
      // Inline function 'kotlin.collections.toTypedArray' call
      var tmp$ret$0 = copyToArray(links);
      tmp = copyOf_0(tmp$ret$0, numlinks + 2 | 0);
    }
    linklist = tmp;
    var numchains = chains.k1();
    var endlist;
    var tmp_0;
    if (numchains === 0) {
      tmp_0 = this.z1n_1;
    } else {
      if (!((numchains & 1) === 0)) {
        throw UnsupportedOperationException.y8('Odd number of chains!');
      }
      // Inline function 'kotlin.collections.toTypedArray' call
      var tmp$ret$1 = copyToArray(chains);
      tmp_0 = copyOf_0(tmp$ret$1, numchains + 2 | 0);
    }
    endlist = tmp_0;
    chains.u4();
    var chain = endlist[0];
    var nextchain = endlist[1];
    var link = linklist[0];
    var nextlink = linklist[1];
    var curlink = 0;
    var curchain = 0;
    while (!(chain == null) || !(link == null)) {
      var connectchains = link == null;
      var connectlinks = chain == null;
      if (!connectchains && !connectlinks) {
        connectchains = ((curchain & 1) === 0 && ensureNotNull(chain).g1h() === ensureNotNull(nextchain).g1h());
        connectlinks = ((curlink & 1) === 0 && ensureNotNull(link).g1h() === ensureNotNull(nextlink).g1h());
        if (!connectchains && !connectlinks) {
          var cx = ensureNotNull(chain).g1h();
          var lx = ensureNotNull(link).g1h();
          connectchains = (!(nextchain == null) && cx < lx && this.i1p(nextchain.g1h(), lx, curchain));
          connectlinks = (!(nextlink == null) && lx < cx && this.i1p(nextlink.g1h(), cx, curlink));
        }
      }
      if (connectchains) {
        var subcurve = ensureNotNull(chain).h1p(nextchain);
        if (!(subcurve == null)) {
          subcurves.c1(subcurve);
        }
        curchain = curchain + 2 | 0;
        chain = endlist[curchain];
        nextchain = endlist[curchain + 1 | 0];
      }
      if (connectlinks) {
        var openend = new ChainEnd(ensureNotNull(link), null);
        var closeend = new ChainEnd(ensureNotNull(nextlink), openend);
        openend.j1p(closeend);
        chains.c1(openend);
        chains.c1(closeend);
        curlink = curlink + 2 | 0;
        link = linklist[curlink];
        nextlink = linklist[curlink + 1 | 0];
      }
      if (!connectchains && !connectlinks) {
        ensureNotNull(chain).k1p(ensureNotNull(link));
        chains.c1(chain);
        curchain = curchain + 1 | 0;
        chain = nextchain;
        nextchain = endlist[curchain + 1 | 0];
        curlink = curlink + 1 | 0;
        link = nextlink;
        nextlink = linklist[curlink + 1 | 0];
      }
    }
    if (!((chains.k1() & 1) === 0)) {
      println('Odd number of chains!');
    }
  }
  i1p(v1, v2, phase) {
    return (phase & 1) === 0 ? v1 <= v2 : v1 < v2;
  }
}
class ChainEnd {
  constructor(first, partner) {
    this.d1p_1 = first;
    this.e1p_1 = first;
    this.f1p_1 = partner;
    this.g1p_1 = first.j1o_1;
  }
  j1p(partner) {
    this.f1p_1 = partner;
  }
  h1p(that) {
    if (this.g1p_1 === 0 || ensureNotNull(that).g1p_1 === 0) {
      throw UnsupportedOperationException.y8('ChainEnd linked more than once!');
    }
    if (this.g1p_1 === that.g1p_1) {
      throw UnsupportedOperationException.y8('Linking chains of the same type!');
    }
    var enter;
    var exit;
    if (this.g1p_1 === 1) {
      enter = this;
      exit = that;
    } else {
      enter = that;
      exit = this;
    }
    this.g1p_1 = 0;
    that.g1p_1 = 0;
    enter.e1p_1.m1o_1 = exit.d1p_1;
    enter.e1p_1 = exit.e1p_1;
    if (equals(this.f1p_1, that)) {
      return enter.d1p_1;
    }
    var otherenter = exit.f1p_1;
    var otherexit = enter.f1p_1;
    ensureNotNull(otherenter).f1p_1 = otherexit;
    ensureNotNull(otherexit).f1p_1 = otherenter;
    if (enter.d1p_1.k1o_1 < otherenter.d1p_1.k1o_1) {
      enter.e1p_1.m1o_1 = otherenter.d1p_1;
      otherenter.d1p_1 = enter.d1p_1;
    } else {
      otherexit.e1p_1.m1o_1 = enter.d1p_1;
      otherexit.e1p_1 = enter.e1p_1;
    }
    return null;
  }
  k1p(newlink) {
    if (this.g1p_1 === 1) {
      this.e1p_1.m1o_1 = newlink;
      this.e1p_1 = newlink;
    } else {
      newlink.m1o_1 = this.d1p_1;
      this.d1p_1 = newlink;
    }
  }
  g1h() {
    var tmp;
    if (this.g1p_1 === 1) {
      tmp = this.e1p_1.l1p();
    } else {
      tmp = this.d1p_1.l1p();
    }
    return tmp;
  }
}
class Crossings {
  constructor(xLo, yLo, xHi, yHi) {
    this.y1m_1 = xLo;
    this.z1m_1 = yLo;
    this.a1n_1 = xHi;
    this.b1n_1 = yHi;
    this.c1n_1 = ArrayList.q1();
    this.d1n_1 = 0;
    this.e1n_1 = new Float64Array(10);
  }
  u1p() {
    println('Crossings [');
    println('  bounds = [' + this.z1m_1 + ', ' + this.b1n_1 + toString(_Char___init__impl__6a9atx(93)));
    var i = 0;
    while (i < this.d1n_1) {
      println('  [' + this.e1n_1[i] + ', ' + this.e1n_1[i + 1 | 0] + toString(_Char___init__impl__6a9atx(93)));
      i = i + 2 | 0;
    }
    println(']');
  }
  v1k() {
    return this.d1n_1 === 0;
  }
}
class EvenOdd extends Crossings {
  t1p(ystart, yend, direction) {
    var ystart_0 = ystart;
    var yend_0 = yend;
    if (ystart_0 >= yend_0) {
      return Unit_instance;
    }
    var from = 0;
    while (from < this.d1n_1 && ystart_0 > this.e1n_1[from + 1 | 0]) {
      from = from + 2 | 0;
    }
    var to = from;
    $l$loop_0: while (from < this.d1n_1) {
      var tmp = this.e1n_1;
      var _unary__edvuaz = from;
      from = _unary__edvuaz + 1 | 0;
      var yrlo = tmp[_unary__edvuaz];
      var tmp_0 = this.e1n_1;
      var _unary__edvuaz_0 = from;
      from = _unary__edvuaz_0 + 1 | 0;
      var yrhi = tmp_0[_unary__edvuaz_0];
      if (yend_0 < yrlo) {
        var tmp_1 = this.e1n_1;
        var _unary__edvuaz_1 = to;
        to = _unary__edvuaz_1 + 1 | 0;
        tmp_1[_unary__edvuaz_1] = ystart_0;
        var tmp_2 = this.e1n_1;
        var _unary__edvuaz_2 = to;
        to = _unary__edvuaz_2 + 1 | 0;
        tmp_2[_unary__edvuaz_2] = yend_0;
        ystart_0 = yrlo;
        yend_0 = yrhi;
        continue $l$loop_0;
      }
      var yll;
      var ylh;
      if (ystart_0 < yrlo) {
        yll = ystart_0;
        ylh = yrlo;
      } else {
        yll = yrlo;
        ylh = ystart_0;
      }
      var yhh;
      var yhl;
      if (yend_0 < yrhi) {
        yhl = yend_0;
        yhh = yrhi;
      } else {
        yhl = yrhi;
        yhh = yend_0;
      }
      if (ylh === yhl) {
        ystart_0 = yll;
        yend_0 = yhh;
      } else {
        if (ylh > yhl) {
          ystart_0 = yhl;
          yhl = ylh;
          ylh = ystart_0;
        }
        if (!(yll === ylh)) {
          var tmp_3 = this.e1n_1;
          var _unary__edvuaz_3 = to;
          to = _unary__edvuaz_3 + 1 | 0;
          tmp_3[_unary__edvuaz_3] = yll;
          var tmp_4 = this.e1n_1;
          var _unary__edvuaz_4 = to;
          to = _unary__edvuaz_4 + 1 | 0;
          tmp_4[_unary__edvuaz_4] = ylh;
        }
        ystart_0 = yhl;
        yend_0 = yhh;
      }
      if (ystart_0 >= yend_0) {
        break $l$loop_0;
      }
    }
    if (to < from && from < this.d1n_1) {
      arraycopy_0(this.e1n_1, from, this.e1n_1, to, this.d1n_1 - from | 0);
    }
    to = to + (this.d1n_1 - from | 0) | 0;
    if (ystart_0 < yend_0) {
      if (to >= this.e1n_1.length) {
        var newranges = new Float64Array(to + 10 | 0);
        arraycopy_0(this.e1n_1, 0, newranges, 0, to);
        this.e1n_1 = newranges;
      }
      var tmp_5 = this.e1n_1;
      var _unary__edvuaz_5 = to;
      to = _unary__edvuaz_5 + 1 | 0;
      tmp_5[_unary__edvuaz_5] = ystart_0;
      var tmp_6 = this.e1n_1;
      var _unary__edvuaz_6 = to;
      to = _unary__edvuaz_6 + 1 | 0;
      tmp_6[_unary__edvuaz_6] = yend_0;
    }
    this.d1n_1 = to;
  }
}
class Companion_39 {
  constructor() {
    this.w1m_1 = false;
  }
  x1m(curves, xlo, ylo, xhi, yhi) {
    var cross = new EvenOdd(xlo, ylo, xhi, yhi);
    var _iterator__ex2g4s = curves.h1();
    while (_iterator__ex2g4s.i1()) {
      var c = _iterator__ex2g4s.j1();
      if (ensureNotNull(c).v1p(cross)) {
        return null;
      }
    }
    if (false) {
      cross.u1p();
    }
    return cross;
  }
}
class Companion_40 {
  constructor() {
    this.t1l_1 = 1;
    this.u1l_1 = -1;
    this.v1l_1 = -2147483648;
    this.w1l_1 = 0.001;
  }
  y1l(curves, x, y) {
    curves.c1(new Order0(x, y));
  }
  x1l(curves, x0, y0, x1, y1) {
    if (y0 < y1) {
      curves.c1(new Order1(x0, y0, x1, y1, 1));
    } else if (y0 > y1) {
      curves.c1(new Order1(x1, y1, x0, y0, -1));
    }
  }
  z1l(curves, x0, y0, coords) {
    var y1 = coords[3];
    if (y0 > y1) {
      Companion_instance_44.w1p(curves, coords, coords[2], y1, coords[0], coords[1], x0, y0, -1);
    } else if (y0 === y1 && y0 === coords[1]) {
      return Unit_instance;
    } else {
      Companion_instance_44.w1p(curves, coords, x0, y0, coords[0], coords[1], coords[2], y1, 1);
    }
  }
  a1m(curves, x0, y0, coords) {
    var y1 = coords[5];
    if (y0 > y1) {
      Companion_instance_45.x1p(curves, coords, coords[4], y1, coords[2], coords[3], coords[0], coords[1], x0, y0, -1);
    } else if (y0 === y1 && y0 === coords[1] && y0 === coords[3]) {
      return Unit_instance;
    } else {
      Companion_instance_45.x1p(curves, coords, x0, y0, coords[0], coords[1], coords[2], coords[3], coords[4], y1, 1);
    }
  }
  y1p(px, py, x0, y0, x1, y1) {
    if (py < y0 && py < y1)
      return 0;
    if (py >= y0 && py >= y1)
      return 0;
    if (px >= x0 && px >= x1)
      return 0;
    if (px < x0 && px < x1)
      return y0 < y1 ? 1 : -1;
    var xintercept = x0 + (py - y0) * (x1 - x0) / (y1 - y0);
    if (px >= xintercept)
      return 0;
    return y0 < y1 ? 1 : -1;
  }
  z1p(px, py, x0, y0, xc, yc, x1, y1, level) {
    var xc_0 = xc;
    var yc_0 = yc;
    if (py < y0 && py < yc_0 && py < y1)
      return 0;
    if (py >= y0 && py >= yc_0 && py >= y1)
      return 0;
    if (px >= x0 && px >= xc_0 && px >= x1)
      return 0;
    if (px < x0 && px < xc_0 && px < x1) {
      if (py >= y0) {
        if (py < y1)
          return 1;
      } else {
        if (py >= y1)
          return -1;
      }
      return 0;
    }
    if (level > 52)
      return this.y1p(px, py, x0, y0, x1, y1);
    var x0c = (x0 + xc_0) / 2;
    var y0c = (y0 + yc_0) / 2;
    var xc1 = (xc_0 + x1) / 2;
    var yc1 = (yc_0 + y1) / 2;
    xc_0 = (x0c + xc1) / 2;
    yc_0 = (y0c + yc1) / 2;
    var tmp;
    if (isNaN_3(xc_0) || isNaN_3(yc_0)) {
      tmp = 0;
    } else {
      tmp = this.z1p(px, py, x0, y0, x0c, y0c, xc_0, yc_0, level + 1 | 0) + this.z1p(px, py, xc_0, yc_0, xc1, yc1, x1, y1, level + 1 | 0) | 0;
    }
    return tmp;
  }
  a1q(px, py, x0, y0, xc0, yc0, xc1, yc1, x1, y1, level) {
    var xc0_0 = xc0;
    var yc0_0 = yc0;
    var xc1_0 = xc1;
    var yc1_0 = yc1;
    if (py < y0 && py < yc0_0 && py < yc1_0 && py < y1)
      return 0;
    if (py >= y0 && py >= yc0_0 && py >= yc1_0 && py >= y1)
      return 0;
    if (px >= x0 && px >= xc0_0 && px >= xc1_0 && px >= x1)
      return 0;
    if (px < x0 && px < xc0_0 && px < xc1_0 && px < x1) {
      if (py >= y0) {
        if (py < y1)
          return 1;
      } else {
        if (py >= y1)
          return -1;
      }
      return 0;
    }
    if (level > 52)
      return this.y1p(px, py, x0, y0, x1, y1);
    var xmid = (xc0_0 + xc1_0) / 2;
    var ymid = (yc0_0 + yc1_0) / 2;
    xc0_0 = (x0 + xc0_0) / 2;
    yc0_0 = (y0 + yc0_0) / 2;
    xc1_0 = (xc1_0 + x1) / 2;
    yc1_0 = (yc1_0 + y1) / 2;
    var xc0m = (xc0_0 + xmid) / 2;
    var yc0m = (yc0_0 + ymid) / 2;
    var xmc1 = (xmid + xc1_0) / 2;
    var ymc1 = (ymid + yc1_0) / 2;
    xmid = (xc0m + xmc1) / 2;
    ymid = (yc0m + ymc1) / 2;
    var tmp;
    if (isNaN_3(xmid) || isNaN_3(ymid)) {
      tmp = 0;
    } else {
      tmp = this.a1q(px, py, x0, y0, xc0_0, yc0_0, xc0m, yc0m, xmid, ymid, level + 1 | 0) + this.a1q(px, py, xmid, ymid, xmc1, ymc1, xc1_0, yc1_0, x1, y1, level + 1 | 0) | 0;
    }
    return tmp;
  }
  b1q(crossings, rxmin, rymin, rxmax, rymax, x0, y0, x1, y1) {
    var crossings_0 = crossings;
    if (y0 >= rymax && y1 >= rymax)
      return crossings_0;
    if (y0 <= rymin && y1 <= rymin)
      return crossings_0;
    if (x0 <= rxmin && x1 <= rxmin)
      return crossings_0;
    if (x0 >= rxmax && x1 >= rxmax) {
      if (y0 < y1) {
        if (y0 <= rymin) {
          crossings_0 = crossings_0 + 1 | 0;
        }
        if (y1 >= rymax) {
          crossings_0 = crossings_0 + 1 | 0;
        }
      } else if (y1 < y0) {
        if (y1 <= rymin) {
          crossings_0 = crossings_0 - 1 | 0;
        }
        if (y0 >= rymax) {
          crossings_0 = crossings_0 - 1 | 0;
        }
      }
      return crossings_0;
    }
    if (x0 > rxmin && x0 < rxmax && y0 > rymin && y0 < rymax || (x1 > rxmin && x1 < rxmax && y1 > rymin && y1 < rymax)) {
      return -2147483648;
    }
    var xi0 = x0;
    if (y0 < rymin) {
      xi0 = xi0 + (rymin - y0) * (x1 - x0) / (y1 - y0);
    } else if (y0 > rymax) {
      xi0 = xi0 + (rymax - y0) * (x1 - x0) / (y1 - y0);
    }
    var xi1 = x1;
    if (y1 < rymin) {
      xi1 = xi1 + (rymin - y1) * (x0 - x1) / (y0 - y1);
    } else if (y1 > rymax) {
      xi1 = xi1 + (rymax - y1) * (x0 - x1) / (y0 - y1);
    }
    if (xi0 <= rxmin && xi1 <= rxmin)
      return crossings_0;
    if (xi0 >= rxmax && xi1 >= rxmax) {
      if (y0 < y1) {
        if (y0 <= rymin) {
          crossings_0 = crossings_0 + 1 | 0;
        }
        if (y1 >= rymax) {
          crossings_0 = crossings_0 + 1 | 0;
        }
      } else if (y1 < y0) {
        if (y1 <= rymin) {
          crossings_0 = crossings_0 - 1 | 0;
        }
        if (y0 >= rymax) {
          crossings_0 = crossings_0 - 1 | 0;
        }
      }
      return crossings_0;
    }
    return -2147483648;
  }
  c1q(crossings, rxmin, rymin, rxmax, rymax, x0, y0, xc, yc, x1, y1, level) {
    var crossings_0 = crossings;
    var xc_0 = xc;
    var yc_0 = yc;
    if (y0 >= rymax && yc_0 >= rymax && y1 >= rymax)
      return crossings_0;
    if (y0 <= rymin && yc_0 <= rymin && y1 <= rymin)
      return crossings_0;
    if (x0 <= rxmin && xc_0 <= rxmin && x1 <= rxmin)
      return crossings_0;
    if (x0 >= rxmax && xc_0 >= rxmax && x1 >= rxmax) {
      if (y0 < y1) {
        if (y0 <= rymin && y1 > rymin) {
          crossings_0 = crossings_0 + 1 | 0;
        }
        if (y0 < rymax && y1 >= rymax) {
          crossings_0 = crossings_0 + 1 | 0;
        }
      } else if (y1 < y0) {
        if (y1 <= rymin && y0 > rymin) {
          crossings_0 = crossings_0 - 1 | 0;
        }
        if (y1 < rymax && y0 >= rymax) {
          crossings_0 = crossings_0 - 1 | 0;
        }
      }
      return crossings_0;
    }
    if (x0 < rxmax && x0 > rxmin && y0 < rymax && y0 > rymin || (x1 < rxmax && x1 > rxmin && y1 < rymax && y1 > rymin)) {
      return -2147483648;
    }
    if (level > 52) {
      return this.b1q(crossings_0, rxmin, rymin, rxmax, rymax, x0, y0, x1, y1);
    }
    var x0c = (x0 + xc_0) / 2;
    var y0c = (y0 + yc_0) / 2;
    var xc1 = (xc_0 + x1) / 2;
    var yc1 = (yc_0 + y1) / 2;
    xc_0 = (x0c + xc1) / 2;
    yc_0 = (y0c + yc1) / 2;
    if (isNaN_3(xc_0) || isNaN_3(yc_0)) {
      return 0;
    }
    crossings_0 = this.c1q(crossings_0, rxmin, rymin, rxmax, rymax, x0, y0, x0c, y0c, xc_0, yc_0, level + 1 | 0);
    if (!(crossings_0 === -2147483648)) {
      crossings_0 = this.c1q(crossings_0, rxmin, rymin, rxmax, rymax, xc_0, yc_0, xc1, yc1, x1, y1, level + 1 | 0);
    }
    return crossings_0;
  }
  d1q(crossings, rxmin, rymin, rxmax, rymax, x0, y0, xc0, yc0, xc1, yc1, x1, y1, level) {
    var crossings_0 = crossings;
    var xc0_0 = xc0;
    var yc0_0 = yc0;
    var xc1_0 = xc1;
    var yc1_0 = yc1;
    if (y0 >= rymax && yc0_0 >= rymax && yc1_0 >= rymax && y1 >= rymax) {
      return crossings_0;
    }
    if (y0 <= rymin && yc0_0 <= rymin && yc1_0 <= rymin && y1 <= rymin) {
      return crossings_0;
    }
    if (x0 <= rxmin && xc0_0 <= rxmin && xc1_0 <= rxmin && x1 <= rxmin) {
      return crossings_0;
    }
    if (x0 >= rxmax && xc0_0 >= rxmax && xc1_0 >= rxmax && x1 >= rxmax) {
      if (y0 < y1) {
        if (y0 <= rymin && y1 > rymin) {
          crossings_0 = crossings_0 + 1 | 0;
        }
        if (y0 < rymax && y1 >= rymax) {
          crossings_0 = crossings_0 + 1 | 0;
        }
      } else if (y1 < y0) {
        if (y1 <= rymin && y0 > rymin) {
          crossings_0 = crossings_0 - 1 | 0;
        }
        if (y1 < rymax && y0 >= rymax) {
          crossings_0 = crossings_0 - 1 | 0;
        }
      }
      return crossings_0;
    }
    if (x0 > rxmin && x0 < rxmax && y0 > rymin && y0 < rymax || (x1 > rxmin && x1 < rxmax && y1 > rymin && y1 < rymax)) {
      return -2147483648;
    }
    if (level > 52) {
      return this.b1q(crossings_0, rxmin, rymin, rxmax, rymax, x0, y0, x1, y1);
    }
    var xmid = (xc0_0 + xc1_0) / 2;
    var ymid = (yc0_0 + yc1_0) / 2;
    xc0_0 = (x0 + xc0_0) / 2;
    yc0_0 = (y0 + yc0_0) / 2;
    xc1_0 = (xc1_0 + x1) / 2;
    yc1_0 = (yc1_0 + y1) / 2;
    var xc0m = (xc0_0 + xmid) / 2;
    var yc0m = (yc0_0 + ymid) / 2;
    var xmc1 = (xmid + xc1_0) / 2;
    var ymc1 = (ymid + yc1_0) / 2;
    xmid = (xc0m + xmc1) / 2;
    ymid = (yc0m + ymc1) / 2;
    if (isNaN_3(xmid) || isNaN_3(ymid)) {
      return 0;
    }
    crossings_0 = this.d1q(crossings_0, rxmin, rymin, rxmax, rymax, x0, y0, xc0_0, yc0_0, xc0m, yc0m, xmid, ymid, level + 1 | 0);
    if (!(crossings_0 === -2147483648)) {
      crossings_0 = this.d1q(crossings_0, rxmin, rymin, rxmax, rymax, xmid, ymid, xmc1, ymc1, xc1_0, yc1_0, x1, y1, level + 1 | 0);
    }
    return crossings_0;
  }
  e1q(x1, x2) {
    if (x1 < x2) {
      return -1;
    }
    var tmp;
    if (x1 > x2) {
      tmp = 1;
    } else {
      tmp = 0;
    }
    return tmp;
  }
  f1q(y1, y2) {
    return abs_1(subtract_0(doubleToLongBits(y1), doubleToLongBits(y2)));
  }
  g1q(v) {
    return v;
  }
}
class Curve {
  constructor(direction) {
    this.f1m_1 = direction;
  }
  h1q(direction) {
    return this.f1m_1 === direction ? this : ensureNotNull(this.i1q());
  }
  toString() {
    return 'Curve[' + this.o1m() + ', ' + ('(' + Companion_instance_40.g1q(this.g1m()) + ', ' + Companion_instance_40.g1q(this.h1m()) + '), ') + this.j1q() + ('(' + Companion_instance_40.g1q(this.p1m()) + ', ' + Companion_instance_40.g1q(this.q1m()) + '), ') + (this.f1m_1 === 1 ? 'D' : 'U') + toString(_Char___init__impl__6a9atx(93));
  }
  j1q() {
    return '';
  }
  v1m(x, y) {
    if (y >= this.o1n() && y < this.a1o()) {
      if (x < this.l1q() && (x < this.m1q() || x < this.n1q(y))) {
        return 1;
      }
    }
    return 0;
  }
  v1p(c) {
    var xhi = c.a1n_1;
    if (this.m1q() >= xhi) {
      return false;
    }
    var xlo = c.y1m_1;
    var ylo = c.z1m_1;
    var yhi = c.b1n_1;
    var y0 = this.o1n();
    var y1 = this.a1o();
    var tstart;
    var ystart;
    if (y0 < ylo) {
      if (y1 <= ylo) {
        return false;
      }
      ystart = ylo;
      tstart = this.o1q(ylo);
    } else {
      if (y0 >= yhi) {
        return false;
      }
      ystart = y0;
      tstart = 0.0;
    }
    var yend;
    var tend;
    if (y1 > yhi) {
      yend = yhi;
      tend = this.o1q(yhi);
    } else {
      yend = y1;
      tend = 1.0;
    }
    var hitLo = false;
    var hitHi = false;
    $l$loop: while (true) {
      var x = this.p1q(tstart);
      if (x < xhi) {
        if (hitHi || x > xlo) {
          return true;
        }
        hitLo = true;
      } else {
        if (hitLo) {
          return true;
        }
        hitHi = true;
      }
      if (tstart >= tend) {
        break $l$loop;
      }
      tstart = this.q1q(tstart, tend);
    }
    if (hitLo) {
      c.t1p(ystart, yend, this.f1m_1);
    }
    return false;
  }
  s1q(that, yrange) {
    var y0 = yrange[0];
    var y1 = yrange[1];
    var tmp0 = y1;
    // Inline function 'kotlin.math.min' call
    var b = this.a1o();
    var tmp0_0 = Math.min(tmp0, b);
    // Inline function 'kotlin.math.min' call
    var b_0 = that.a1o();
    y1 = Math.min(tmp0_0, b_0);
    if (y1 <= yrange[0]) {
      println('this == ' + this.toString());
      println('that == ' + that.toString());
      println('target range = ' + yrange[0] + '=>' + yrange[1]);
      throw Error_0.i('backstepping from ' + yrange[0] + ' to ' + y1);
    }
    yrange[1] = y1;
    if (this.l1q() <= that.m1q()) {
      var tmp;
      if (this.m1q() === that.l1q()) {
        tmp = 0;
      } else {
        tmp = -1;
      }
      return tmp;
    }
    if (this.m1q() >= that.l1q()) {
      return 1;
    }
    var s0 = this.o1q(y0);
    var ys0 = this.k1q(s0);
    if (ys0 < y0) {
      s0 = this.t1q(s0, ys0, y0);
      ys0 = this.k1q(s0);
    }
    var s1 = this.o1q(y1);
    if (this.k1q(s1) < y0) {
      s1 = this.t1q(s1, this.k1q(s1), y0);
    }
    var t0 = that.o1q(y0);
    var yt0 = that.k1q(t0);
    if (yt0 < y0) {
      t0 = that.t1q(t0, yt0, y0);
      yt0 = that.k1q(t0);
    }
    var t1 = that.o1q(y1);
    if (that.k1q(t1) < y0) {
      t1 = that.t1q(t1, that.k1q(t1), y0);
    }
    var xs0 = this.p1q(s0);
    var xt0 = that.p1q(t0);
    // Inline function 'kotlin.math.abs' call
    var tmp0_1 = Math.abs(y0);
    // Inline function 'kotlin.math.abs' call
    var x = y1;
    // Inline function 'kotlin.math.max' call
    var b_1 = Math.abs(x);
    var scale = Math.max(tmp0_1, b_1);
    // Inline function 'kotlin.math.max' call
    var a = scale * 1.0E-14;
    var ymin = Math.max(a, 1.0E-300);
    if (fairlyClose(Companion_instance_40, xs0, xt0)) {
      var bump = ymin;
      var tmp0_2 = ymin * 1.0E13;
      // Inline function 'kotlin.math.min' call
      var b_2 = (y1 - y0) * 0.1;
      var maxbump = Math.min(tmp0_2, b_2);
      var y = y0 + bump;
      $l$loop_0: while (y <= y1) {
        if (fairlyClose(Companion_instance_40, this.n1q(y), that.n1q(y))) {
          // Inline function 'kotlin.let' call
          bump = bump * 2;
          if (bump > maxbump) {
            bump = maxbump;
          }
        } else {
          y = y - bump;
          $l$loop: while (true) {
            bump = bump / 2.0;
            var newy = y + bump;
            if (newy <= y) {
              break $l$loop;
            }
            if (fairlyClose(Companion_instance_40, this.n1q(newy), that.n1q(newy))) {
              y = newy;
            }
          }
          break $l$loop_0;
        }
        y = y + bump;
      }
      if (y > y0) {
        if (y < y1) {
          yrange[1] = y;
        }
        return 0;
      }
    }
    if (ymin <= 0) {
      println('ymin = ' + ymin);
    }
    $l$loop_3: while (s0 < s1 && t0 < t1) {
      var sh = this.q1q(s0, s1);
      var xsh = this.p1q(sh);
      var ysh = this.k1q(sh);
      var th = that.q1q(t0, t1);
      var xth = that.p1q(th);
      var yth = that.k1q(th);
      try {
        if (this.u1q(that, yrange, ymin, 0, 0, s0, xs0, ys0, sh, xsh, ysh, t0, xt0, yt0, th, xth, yth)) {
          break $l$loop_3;
        }
      } catch ($p) {
        if ($p instanceof Error) {
          var t = $p;
          println('Error: ' + t.toString());
          println('y range was ' + yrange[0] + '=>' + yrange[1]);
          println('s y range is ' + ys0 + '=>' + ysh);
          println('t y range is ' + yt0 + '=>' + yth);
          println('ymin is ' + ymin);
          return 0;
        } else {
          throw $p;
        }
      }
      if (ysh < yth) {
        if (ysh > yrange[0]) {
          if (ysh < yrange[1]) {
            yrange[1] = ysh;
          }
          break $l$loop_3;
        }
        s0 = sh;
        xs0 = xsh;
        ys0 = ysh;
      } else {
        if (yth > yrange[0]) {
          if (yth < yrange[1]) {
            yrange[1] = yth;
          }
          break $l$loop_3;
        }
        t0 = th;
        xt0 = xth;
        yt0 = yth;
      }
    }
    var ymid = (yrange[0] + yrange[1]) / 2;
    return Companion_instance_40.e1q(this.n1q(ymid), that.n1q(ymid));
  }
  u1q(that, yrange, ymin, slevel, tlevel, s0, xs0, ys0, s1, xs1, ys1, t0, xt0, yt0, t1, xt1, yt1) {
    if (ys0 > yt1 || yt0 > ys1) {
      return false;
    }
    var tmp;
    // Inline function 'kotlin.math.min' call
    var tmp_0 = Math.min(xs0, xs1);
    // Inline function 'kotlin.math.max' call
    if (tmp_0 > Math.max(xt0, xt1)) {
      tmp = true;
    } else {
      // Inline function 'kotlin.math.max' call
      var tmp_1 = Math.max(xs0, xs1);
      // Inline function 'kotlin.math.min' call
      tmp = tmp_1 < Math.min(xt0, xt1);
    }
    if (tmp) {
      return false;
    }
    if (s1 - s0 > 0.001) {
      var s = (s0 + s1) / 2;
      var xs = this.p1q(s);
      var ys = this.k1q(s);
      if (s === s0 || s === s1) {
        println('s0 = ' + s0);
        println('s1 = ' + s1);
        throw Error_0.i('no s progress!');
      }
      if (t1 - t0 > 0.001) {
        var t = (t0 + t1) / 2;
        var xt = that.p1q(t);
        var yt = that.k1q(t);
        if (t === t0 || t === t1) {
          println('t0 = ' + t0);
          println('t1 = ' + t1);
          throw Error_0.i('no t progress!');
        }
        if (ys >= yt0 && yt >= ys0) {
          if (this.u1q(that, yrange, ymin, slevel + 1 | 0, tlevel + 1 | 0, s0, xs0, ys0, s, xs, ys, t0, xt0, yt0, t, xt, yt)) {
            return true;
          }
        }
        if (ys >= yt) {
          if (this.u1q(that, yrange, ymin, slevel + 1 | 0, tlevel + 1 | 0, s0, xs0, ys0, s, xs, ys, t, xt, yt, t1, xt1, yt1)) {
            return true;
          }
        }
        if (yt >= ys) {
          if (this.u1q(that, yrange, ymin, slevel + 1 | 0, tlevel + 1 | 0, s, xs, ys, s1, xs1, ys1, t0, xt0, yt0, t, xt, yt)) {
            return true;
          }
        }
        if (ys1 >= yt && yt1 >= ys) {
          return this.u1q(that, yrange, ymin, slevel + 1 | 0, tlevel + 1 | 0, s, xs, ys, s1, xs1, ys1, t, xt, yt, t1, xt1, yt1);
        }
      } else {
        if (ys >= yt0) {
          if (this.u1q(that, yrange, ymin, slevel + 1 | 0, tlevel, s0, xs0, ys0, s, xs, ys, t0, xt0, yt0, t1, xt1, yt1)) {
            return true;
          }
        }
        if (yt1 >= ys) {
          return this.u1q(that, yrange, ymin, slevel + 1 | 0, tlevel, s, xs, ys, s1, xs1, ys1, t0, xt0, yt0, t1, xt1, yt1);
        }
      }
    } else if (t1 - t0 > 0.001) {
      var t_0 = (t0 + t1) / 2;
      var xt_0 = that.p1q(t_0);
      var yt_0 = that.k1q(t_0);
      if (t_0 === t0 || t_0 === t1) {
        println('t0 = ' + t0);
        println('t1 = ' + t1);
        throw Error_0.i('no t progress!');
      }
      if (yt_0 >= ys0) {
        if (this.u1q(that, yrange, ymin, slevel, tlevel + 1 | 0, s0, xs0, ys0, s1, xs1, ys1, t0, xt0, yt0, t_0, xt_0, yt_0)) {
          return true;
        }
      }
      if (ys1 >= yt_0) {
        return this.u1q(that, yrange, ymin, slevel, tlevel + 1 | 0, s0, xs0, ys0, s1, xs1, ys1, t_0, xt_0, yt_0, t1, xt1, yt1);
      }
    } else {
      var xlk = xs1 - xs0;
      var ylk = ys1 - ys0;
      var xnm = xt1 - xt0;
      var ynm = yt1 - yt0;
      var det = xnm * ylk - ynm * xlk;
      if (!(det === 0.0)) {
        var detinv = 1 / det;
        var ymk = yt0 - ys0;
        var xmk = xt0 - xs0;
        var s_0 = (xnm * ymk - ynm * xmk) * detinv;
        var t_1 = (xlk * ymk - ylk * xmk) * detinv;
        if (s_0 >= 0 && s_0 <= 1 && t_1 >= 0 && t_1 <= 1) {
          s_0 = s0 + s_0 * (s1 - s0);
          t_1 = t0 + t_1 * (t1 - t0);
          if (s_0 < 0 || s_0 > 1 || t_1 < 0 || t_1 > 1) {
            println('Uh oh!');
          }
          var y = (this.k1q(s_0) + that.k1q(t_1)) / 2;
          if (y <= yrange[1] && y > yrange[0]) {
            yrange[1] = y;
            return true;
          }
        }
      }
    }
    return false;
  }
  t1q(t0, yt0, y0) {
    var t0_0 = t0;
    var t1 = 1.0;
    while (true) {
      var th = (t0_0 + t1) / 2;
      if (th === t0_0 || th === t1) {
        return t1;
      }
      var y = this.k1q(th);
      if (y < y0) {
        t0_0 = th;
      } else if (y > y0) {
        t1 = th;
      } else {
        return t1;
      }
    }
  }
}
class CurveLink {
  constructor(curve, ystart, yend, etag) {
    this.m1o_1 = null;
    this.i1o_1 = curve;
    this.k1o_1 = ystart;
    this.l1o_1 = yend;
    this.j1o_1 = etag;
    if (this.k1o_1 < curve.o1n() || this.l1o_1 > curve.a1o()) {
      throw UnsupportedOperationException.y8('bad curvelink [' + this.k1o_1 + '=>' + this.l1o_1 + '] for ' + curve.toString());
    }
  }
  q1o(link) {
    return this.v1q(link.i1o_1, link.k1o_1, link.l1o_1, link.j1o_1);
  }
  v1q(curve, ystart, yend, etag) {
    if (!(this.i1o_1 === curve) || !(this.j1o_1 === etag) || this.l1o_1 < ystart || this.k1o_1 > yend) {
      return false;
    }
    if (ystart < curve.o1n() || yend > curve.a1o()) {
      throw UnsupportedOperationException.y8('bad curvelink [' + ystart + '=>' + yend + '] for ' + curve.toString());
    }
    var tmp = this;
    // Inline function 'kotlin.math.min' call
    var a = this.k1o_1;
    tmp.k1o_1 = Math.min(a, ystart);
    var tmp_0 = this;
    // Inline function 'kotlin.math.max' call
    var a_0 = this.l1o_1;
    tmp_0.l1o_1 = Math.max(a_0, yend);
    return true;
  }
  n1o() {
    var tmp;
    if (this.k1o_1 === this.i1o_1.o1n() && this.l1o_1 === this.i1o_1.a1o()) {
      tmp = this.i1o_1.h1q(this.j1o_1);
    } else {
      tmp = this.i1o_1.r1q(this.k1o_1, this.l1o_1, this.j1o_1);
    }
    return tmp;
  }
  p1o() {
    return new Order0(this.p1n(), this.k1o_1);
  }
  p1n() {
    return this.i1o_1.n1q(this.k1o_1);
  }
  l1p() {
    return this.i1o_1.n1q(this.l1o_1);
  }
  g1h() {
    return this.i1o_1.n1q(this.k1o_1);
  }
}
class Companion_41 {
  constructor() {
    this.w1q_1 = 4;
    this.x1q_1 = 10;
  }
}
class Edge {
  constructor(c, ctag, etag) {
    etag = etag === VOID ? 0 : etag;
    this.j1n_1 = 0.0;
    this.k1n_1 = 0;
    this.l1n_1 = null;
    this.m1n_1 = 0;
    this.n1n_1 = 0.0;
    this.g1n_1 = c;
    this.h1n_1 = ctag;
    this.i1n_1 = etag;
  }
  c1o(other, yrange) {
    if (equals(other, this.l1n_1) && yrange[0] < this.n1n_1) {
      if (yrange[1] > this.n1n_1) {
        yrange[1] = this.n1n_1;
      }
      return this.m1n_1;
    }
    if (equals(this, other.l1n_1) && yrange[0] < other.n1n_1) {
      if (yrange[1] > other.n1n_1) {
        yrange[1] = other.n1n_1;
      }
      return 0 - other.m1n_1 | 0;
    }
    var ret = this.g1n_1.s1q(other.g1n_1, yrange);
    this.l1n_1 = other;
    this.n1n_1 = yrange[1];
    this.m1n_1 = ret;
    return ret;
  }
  h1o(yend, etag) {
    this.j1n_1 = yend;
    this.i1n_1 = etag;
  }
  g1o(y, etag) {
    return this.i1n_1 === etag && this.j1n_1 >= y;
  }
  toString() {
    return 'Edge[' + this.g1n_1 + ', ' + (this.h1n_1 === 0 ? 'L' : 'R') + ', ' + (this.i1n_1 === 1 ? 'I' : this.i1n_1 === -1 ? 'O' : 'N') + toString(_Char___init__impl__6a9atx(93));
  }
}
class Ellipse2D {}
class Double_0 {
  constructor(x, y, width, height) {
    this.y1q_1 = x;
    this.z1q_1 = y;
    this.a1r_1 = width;
    this.b1r_1 = height;
  }
  g1h() {
    return this.y1q_1;
  }
  h1h() {
    return this.z1q_1;
  }
  gm() {
    return this.a1r_1;
  }
  hm() {
    return this.b1r_1;
  }
  i1h() {
    return Double_3.z1h(this.y1q_1, this.z1q_1, this.a1r_1, this.b1r_1);
  }
  j1h(point) {
    var x = point.g1h();
    var y = point.h1h();
    var x0 = x;
    var y0 = y;
    return x >= x0 && y >= y0 && x < x0 + this.a1r_1 && y < y0 + this.b1r_1;
  }
  l1h(rect) {
    var x = rect.g1h();
    var y = rect.h1h();
    var w = rect.gm();
    var h = rect.hm();
    if (w <= 0.0 || h <= 0.0) {
      return false;
    }
    var ellw = this.a1r_1;
    if (ellw <= 0.0) {
      return false;
    }
    var normx0 = (x - x) / ellw - 0.5;
    var ellh = this.b1r_1;
    if (ellh <= 0.0) {
      return false;
    }
    var normy0 = (y - y) / ellh - 0.5;
    var nearx;
    var normx1 = normx0 + w / ellw;
    var tmp;
    if (normx0 > 0.0) {
      tmp = normx0;
    } else if (normx1 < 0.0) {
      tmp = normx1;
    } else {
      tmp = 0.0;
    }
    nearx = tmp;
    var neary;
    var normy1 = normy0 + h / ellh;
    var tmp_0;
    if (normy0 > 0.0) {
      tmp_0 = normy0;
    } else if (normy1 < 0.0) {
      tmp_0 = normy1;
    } else {
      tmp_0 = 0.0;
    }
    neary = tmp_0;
    return nearx * nearx + neary * neary < 0.25;
  }
  k1h() {
    return this.y1q_1 + this.a1r_1 / 2.0;
  }
  m1h() {
    return this.z1q_1 + this.b1r_1 / 2.0;
  }
  n1h() {
    return this.o1h(null);
  }
  o1h(at) {
    return new EllipseIterator(this, at);
  }
  toString() {
    return 'Ellipse2D.Double{x=' + this.y1q_1 + ', y=' + this.z1q_1 + ', width=' + this.a1r_1 + ', height=' + this.b1r_1 + toString(_Char___init__impl__6a9atx(125));
  }
}
class Companion_42 {
  constructor() {
    Companion_instance_42 = this;
    this.c1r_1 = 0.5522847498307933;
    this.d1r_1 = 0.7761423749153966;
    this.e1r_1 = 0.22385762508460333;
    var tmp = this;
    // Inline function 'kotlin.doubleArrayOf' call
    var tmp_0 = new Float64Array([1.0, 0.7761423749153966, 0.7761423749153966, 1.0, 0.5, 1.0]);
    // Inline function 'kotlin.doubleArrayOf' call
    var tmp_1 = new Float64Array([0.22385762508460333, 1.0, 0.0, 0.7761423749153966, 0.0, 0.5]);
    // Inline function 'kotlin.doubleArrayOf' call
    var tmp_2 = new Float64Array([0.0, 0.22385762508460333, 0.22385762508460333, 0.0, 0.5, 0.0]);
    // Inline function 'kotlin.doubleArrayOf' call
    // Inline function 'kotlin.arrayOf' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    tmp.f1r_1 = [tmp_0, tmp_1, tmp_2, new Float64Array([0.7761423749153966, 0.0, 1.0, 0.22385762508460333, 1.0, 0.5])];
  }
}
class EllipseIterator {
  constructor(e, at) {
    Companion_getInstance_42();
    this.l1r_1 = 0;
    this.g1r_1 = e.g1h();
    this.h1r_1 = e.h1h();
    this.i1r_1 = e.gm();
    this.j1r_1 = e.hm();
    this.k1r_1 = at;
    if (this.i1r_1 < 0 || this.j1r_1 < 0) {
      this.l1r_1 = 6;
    }
  }
  q1l() {
    return 1;
  }
  m17() {
    return this.l1r_1 > 5;
  }
  r1l() {
    this.l1r_1 = this.l1r_1 + 1 | 0;
  }
  s1l(coords) {
    if (this.m17()) {
      throw NoSuchElementException.g1('ellipse iterator out of bounds');
    }
    if (this.l1r_1 === 5) {
      return 4;
    }
    if (this.l1r_1 === 0) {
      var ctrls = Companion_getInstance_42().f1r_1[3];
      coords[0] = this.g1r_1 + ctrls[4] * this.i1r_1;
      coords[1] = this.h1r_1 + ctrls[5] * this.j1r_1;
      var tmp0_safe_receiver = this.k1r_1;
      if (tmp0_safe_receiver == null)
        null;
      else {
        tmp0_safe_receiver.b1k(coords, 0, coords, 0, 1);
      }
      return 0;
    }
    var ctrls_0 = Companion_getInstance_42().f1r_1[this.l1r_1 - 1 | 0];
    coords[0] = this.g1r_1 + ctrls_0[0] * this.i1r_1;
    coords[1] = this.h1r_1 + ctrls_0[1] * this.j1r_1;
    coords[2] = this.g1r_1 + ctrls_0[2] * this.i1r_1;
    coords[3] = this.h1r_1 + ctrls_0[3] * this.j1r_1;
    coords[4] = this.g1r_1 + ctrls_0[4] * this.i1r_1;
    coords[5] = this.h1r_1 + ctrls_0[5] * this.j1r_1;
    var tmp1_safe_receiver = this.k1r_1;
    if (tmp1_safe_receiver == null)
      null;
    else {
      tmp1_safe_receiver.b1k(coords, 0, coords, 0, 3);
    }
    return 3;
  }
}
class Companion_43 {
  z1k(x1, y1, x2, y2, px, py) {
    var x2_0 = x2;
    var y2_0 = y2;
    var px_0 = px;
    var py_0 = py;
    x2_0 = x2_0 - x1;
    y2_0 = y2_0 - y1;
    px_0 = px_0 - x1;
    py_0 = py_0 - y1;
    var ccw = px_0 * y2_0 - py_0 * x2_0;
    if (ccw === 0.0) {
      ccw = px_0 * x2_0 + py_0 * y2_0;
      if (ccw > 0.0) {
        px_0 = px_0 - x2_0;
        py_0 = py_0 - y2_0;
        ccw = px_0 * x2_0 + py_0 * y2_0;
        if (ccw < 0.0) {
          ccw = 0.0;
        }
      }
    }
    return ccw < 0.0 ? -1 : ccw > 0.0 ? 1 : 0;
  }
}
class Order0 extends Curve {
  constructor(x, y) {
    super(1);
    this.n1r_1 = x;
    this.o1r_1 = y;
  }
  o1m() {
    return 0;
  }
  g1m() {
    return this.n1r_1;
  }
  h1m() {
    return this.o1r_1;
  }
  p1m() {
    return this.n1r_1;
  }
  q1m() {
    return this.o1r_1;
  }
  p1n() {
    return this.n1r_1;
  }
  o1n() {
    return this.o1r_1;
  }
  a1o() {
    return this.o1r_1;
  }
  m1q() {
    return this.n1r_1;
  }
  l1q() {
    return this.n1r_1;
  }
  i1q() {
    return this;
  }
  k1q(t) {
    return this.o1r_1;
  }
  v1m(x, y) {
    return 0;
  }
  n1q(y) {
    return y;
  }
  v1p(c) {
    return this.n1r_1 > c.y1m_1 && this.n1r_1 < c.a1n_1 && this.o1r_1 > c.z1m_1 && this.o1r_1 < c.b1n_1;
  }
  o1q(y) {
    return 0.0;
  }
  p1q(t) {
    return this.n1r_1;
  }
  i1m(r) {
    return r.d1i(this.n1r_1, this.o1r_1);
  }
  q1q(t0, t1) {
    return t1;
  }
  r1q(ystart, yend, dir) {
    return this;
  }
  r1m(coords) {
    coords[0] = this.n1r_1;
    coords[1] = this.o1r_1;
    return 0;
  }
}
class Order1 extends Curve {
  constructor(xTop, yTop, xBot, yBot, direction) {
    super(direction);
    this.q1r_1 = xTop;
    this.r1r_1 = yTop;
    this.s1r_1 = xBot;
    this.t1r_1 = yBot;
    this.u1r_1 = 0.0;
    this.v1r_1 = 0.0;
    if (this.q1r_1 < this.s1r_1) {
      this.u1r_1 = this.q1r_1;
      this.v1r_1 = this.s1r_1;
    } else {
      this.u1r_1 = this.s1r_1;
      this.v1r_1 = this.q1r_1;
    }
  }
  p1n() {
    return this.q1r_1;
  }
  o1n() {
    return this.r1r_1;
  }
  a1o() {
    return this.t1r_1;
  }
  m1q() {
    return this.u1r_1;
  }
  l1q() {
    return this.v1r_1;
  }
  i1q() {
    return new Order1(this.q1r_1, this.r1r_1, this.s1r_1, this.t1r_1, -this.f1m_1 | 0);
  }
  o1m() {
    return 1;
  }
  g1m() {
    return this.f1m_1 === 1 ? this.q1r_1 : this.s1r_1;
  }
  h1m() {
    return this.f1m_1 === 1 ? this.r1r_1 : this.t1r_1;
  }
  p1m() {
    return this.f1m_1 === -1 ? this.q1r_1 : this.s1r_1;
  }
  q1m() {
    return this.f1m_1 === -1 ? this.r1r_1 : this.t1r_1;
  }
  k1q(t) {
    return this.r1r_1 + t * (this.t1r_1 - this.r1r_1);
  }
  n1q(y) {
    if (this.q1r_1 === this.s1r_1 || y <= this.r1r_1) {
      return this.q1r_1;
    }
    var tmp;
    if (y >= this.t1r_1) {
      tmp = this.s1r_1;
    } else {
      tmp = this.q1r_1 + (y - this.r1r_1) * (this.s1r_1 - this.q1r_1) / (this.t1r_1 - this.r1r_1);
    }
    return tmp;
  }
  v1p(c) {
    var xlo = c.y1m_1;
    var ylo = c.z1m_1;
    var xhi = c.a1n_1;
    var yhi = c.b1n_1;
    if (this.u1r_1 >= xhi) {
      return false;
    }
    var xstart;
    var ystart;
    if (this.r1r_1 < ylo) {
      if (this.t1r_1 <= ylo) {
        return false;
      }
      ystart = ylo;
      xstart = this.n1q(ylo);
    } else {
      if (this.r1r_1 >= yhi) {
        return false;
      }
      ystart = this.r1r_1;
      xstart = this.q1r_1;
    }
    var yend;
    var xend;
    if (this.t1r_1 > yhi) {
      yend = yhi;
      xend = this.n1q(yhi);
    } else {
      yend = this.t1r_1;
      xend = this.s1r_1;
    }
    if (xstart >= xhi && xend >= xhi) {
      return false;
    }
    if (xstart > xlo || xend > xlo) {
      return true;
    }
    c.t1p(ystart, yend, this.f1m_1);
    return false;
  }
  o1q(y) {
    if (y <= this.r1r_1) {
      return 0.0;
    }
    var tmp;
    if (y >= this.t1r_1) {
      tmp = 1.0;
    } else {
      tmp = (y - this.r1r_1) / (this.t1r_1 - this.r1r_1);
    }
    return tmp;
  }
  p1q(t) {
    return this.q1r_1 + t * (this.s1r_1 - this.q1r_1);
  }
  i1m(r) {
    var r_0 = r;
    r_0 = r_0.d1i(this.q1r_1, this.r1r_1);
    return r_0.d1i(this.s1r_1, this.t1r_1);
  }
  q1q(t0, t1) {
    return t1;
  }
  r1q(ystart, yend, dir) {
    if (ystart === this.r1r_1 && yend === this.t1r_1) {
      return this.h1q(dir);
    }
    if (this.q1r_1 === this.s1r_1) {
      return new Order1(this.q1r_1, ystart, this.s1r_1, yend, dir);
    }
    var num = this.q1r_1 - this.s1r_1;
    var denom = this.r1r_1 - this.t1r_1;
    var xstart = this.q1r_1 + (ystart - this.r1r_1) * num / denom;
    var xend = this.q1r_1 + (yend - this.r1r_1) * num / denom;
    return new Order1(xstart, ystart, xend, yend, dir);
  }
  s1q(other, yrange) {
    if (!(other instanceof Order1)) {
      return super.s1q(other, yrange);
    }
    if (yrange[1] <= yrange[0]) {
      throw UnsupportedOperationException.y8('yrange already screwed up...');
    }
    var tmp0 = yrange[1];
    // Inline function 'kotlin.math.min' call
    var b = this.t1r_1;
    var tmp0_0 = Math.min(tmp0, b);
    // Inline function 'kotlin.math.min' call
    var b_0 = other.t1r_1;
    yrange[1] = Math.min(tmp0_0, b_0);
    if (yrange[1] <= yrange[0]) {
      throw UnsupportedOperationException.y8('backstepping from ' + yrange[0] + ' to ' + yrange[1]);
    }
    if (this.v1r_1 <= other.u1r_1) {
      return this.u1r_1 === other.v1r_1 ? 0 : -1;
    }
    if (this.u1r_1 >= other.v1r_1) {
      return 1;
    }
    var dxa = this.s1r_1 - this.q1r_1;
    var dya = this.t1r_1 - this.r1r_1;
    var dxb = other.s1r_1 - other.q1r_1;
    var dyb = other.t1r_1 - other.r1r_1;
    var denom = dxb * dya - dxa * dyb;
    var y;
    if (!(denom === 0.0)) {
      var num = (this.q1r_1 - other.q1r_1) * dya * dyb - this.r1r_1 * dxa * dyb + other.r1r_1 * dxb * dya;
      y = num / denom;
      if (y <= yrange[0]) {
        var tmp0_1 = this.t1r_1;
        // Inline function 'kotlin.math.min' call
        var b_1 = other.t1r_1;
        y = Math.min(tmp0_1, b_1);
      } else {
        if (y < yrange[1]) {
          yrange[1] = y;
        }
        var tmp0_2 = this.r1r_1;
        // Inline function 'kotlin.math.max' call
        var b_2 = other.r1r_1;
        y = Math.max(tmp0_2, b_2);
      }
    } else {
      var tmp0_3 = this.r1r_1;
      // Inline function 'kotlin.math.max' call
      var b_3 = other.r1r_1;
      y = Math.max(tmp0_3, b_3);
    }
    return Companion_instance_40.e1q(this.n1q(y), other.n1q(y));
  }
  r1m(coords) {
    if (this.f1m_1 === 1) {
      coords[0] = this.s1r_1;
      coords[1] = this.t1r_1;
    } else {
      coords[0] = this.q1r_1;
      coords[1] = this.r1r_1;
    }
    return 1;
  }
}
class Companion_44 {
  w1p(curves, tmp, x0, y0, cx0, cy0, x1, y1, direction) {
    var numparams = this.w1r(y0, cy0, y1, tmp);
    if (numparams === 0) {
      this.x1r(curves, x0, y0, cx0, cy0, x1, y1, direction);
      return Unit_instance;
    }
    var t = tmp[0];
    tmp[0] = x0;
    tmp[1] = y0;
    tmp[2] = cx0;
    tmp[3] = cy0;
    tmp[4] = x1;
    tmp[5] = y1;
    this.y1r(tmp, 0, t);
    var i0 = direction === 1 ? 0 : 4;
    this.x1r(curves, tmp[i0], tmp[i0 + 1 | 0], tmp[i0 + 2 | 0], tmp[i0 + 3 | 0], tmp[i0 + 4 | 0], tmp[i0 + 5 | 0], direction);
    var i1 = 4 - i0 | 0;
    this.x1r(curves, tmp[i1], tmp[i1 + 1 | 0], tmp[i1 + 2 | 0], tmp[i1 + 3 | 0], tmp[i1 + 4 | 0], tmp[i1 + 5 | 0], direction);
  }
  x1r(curves, x0, y0, cx0, cy0, x1, y1, direction) {
    if (y0 > y1) {
      curves.c1(new Order2(x1, y1, cx0, cy0, x0, y0, -direction | 0));
    } else if (y1 > y0) {
      curves.c1(new Order2(x0, y0, cx0, cy0, x1, y1, direction));
    }
  }
  w1r(c0, cp, c1, ret) {
    var c0_0 = c0;
    var c1_0 = c1;
    if (c0_0 <= cp && cp <= c1_0) {
      return 0;
    }
    c0_0 = c0_0 - cp;
    c1_0 = c1_0 - cp;
    var denom = c0_0 + c1_0;
    if (denom === 0.0) {
      return 0;
    }
    var t = c0_0 / denom;
    if (t <= 0 || t >= 1) {
      return 0;
    }
    ret[0] = t;
    return 1;
  }
  y1r(coords, pos, t) {
    var x1;
    x1 = coords[pos + 4 | 0];
    coords[pos + 8 | 0] = x1;
    var y1;
    y1 = coords[pos + 5 | 0];
    coords[pos + 9 | 0] = y1;
    var cx = coords[pos + 2 | 0];
    var cy = coords[pos + 3 | 0];
    x1 = cx + (x1 - cx) * t;
    y1 = cy + (y1 - cy) * t;
    var x0 = coords[pos + 0 | 0];
    var y0 = coords[pos + 1 | 0];
    x0 = x0 + (cx - x0) * t;
    y0 = y0 + (cy - y0) * t;
    cx = x0 + (x1 - x0) * t;
    cy = y0 + (y1 - y0) * t;
    coords[pos + 2 | 0] = x0;
    coords[pos + 3 | 0] = y0;
    coords[pos + 4 | 0] = cx;
    coords[pos + 5 | 0] = cy;
    coords[pos + 6 | 0] = x1;
    coords[pos + 7 | 0] = y1;
  }
  z1r(y, ycoeff0, ycoeff1, ycoeff2) {
    var ycoeff0_0 = ycoeff0;
    ycoeff0_0 = ycoeff0_0 - y;
    if (ycoeff2 === 0.0) {
      var root = -ycoeff0_0 / ycoeff1;
      if (root >= 0 && root <= 1) {
        return root;
      }
    } else {
      var d = ycoeff1 * ycoeff1 - 4.0 * ycoeff2 * ycoeff0_0;
      if (d >= 0.0) {
        // Inline function 'kotlin.math.sqrt' call
        var x = d;
        d = Math.sqrt(x);
        if (ycoeff1 < 0.0) {
          d = -d;
        }
        var q = (ycoeff1 + d) / -2.0;
        var root_0 = q / ycoeff2;
        if (root_0 >= 0 && root_0 <= 1) {
          return root_0;
        }
        if (!(q === 0.0)) {
          root_0 = ycoeff0_0 / q;
          if (root_0 >= 0 && root_0 <= 1) {
            return root_0;
          }
        }
      }
    }
    var y0 = ycoeff0_0;
    var y1 = ycoeff0_0 + ycoeff1 + ycoeff2;
    return 0 < (y0 + y1) / 2 ? 0.0 : 1.0;
  }
}
class Order2 extends Curve {
  constructor(x0, y0, cx0, cy0, x1, y1, direction) {
    super(direction);
    var cy0_0 = cy0;
    if (cy0_0 < y0) {
      cy0_0 = y0;
    } else if (cy0_0 > y1) {
      cy0_0 = y1;
    }
    this.b1s_1 = x0;
    this.c1s_1 = y0;
    this.d1s_1 = cx0;
    this.e1s_1 = cy0_0;
    this.f1s_1 = x1;
    this.g1s_1 = y1;
    var tmp = this;
    // Inline function 'kotlin.math.min' call
    // Inline function 'kotlin.math.min' call
    var a = Math.min(x0, x1);
    tmp.h1s_1 = Math.min(a, cx0);
    var tmp_0 = this;
    // Inline function 'kotlin.math.max' call
    // Inline function 'kotlin.math.max' call
    var a_0 = Math.max(x0, x1);
    tmp_0.i1s_1 = Math.max(a_0, cx0);
    this.j1s_1 = x0;
    this.k1s_1 = cx0 + cx0 - x0 - x0;
    this.l1s_1 = x0 - cx0 - cx0 + x1;
    this.m1s_1 = y0;
    this.n1s_1 = cy0_0 + cy0_0 - y0 - y0;
    this.o1s_1 = y0 - cy0_0 - cy0_0 + y1;
  }
  p1n() {
    return this.b1s_1;
  }
  o1n() {
    return this.c1s_1;
  }
  a1o() {
    return this.g1s_1;
  }
  m1q() {
    return this.h1s_1;
  }
  l1q() {
    return this.i1s_1;
  }
  i1q() {
    return new Order2(this.b1s_1, this.c1s_1, this.d1s_1, this.e1s_1, this.f1s_1, this.g1s_1, -this.f1m_1 | 0);
  }
  j1q() {
    return '(' + Companion_instance_40.g1q(this.d1s_1).toString() + ', ' + Companion_instance_40.g1q(this.e1s_1).toString() + '), ';
  }
  o1m() {
    return 2;
  }
  g1m() {
    return this.f1m_1 === 1 ? this.b1s_1 : this.f1s_1;
  }
  h1m() {
    return this.f1m_1 === 1 ? this.c1s_1 : this.g1s_1;
  }
  p1m() {
    return this.f1m_1 === -1 ? this.b1s_1 : this.f1s_1;
  }
  q1m() {
    return this.f1m_1 === -1 ? this.c1s_1 : this.g1s_1;
  }
  k1q(t) {
    return (this.o1s_1 * t + this.n1s_1) * t + this.m1s_1;
  }
  n1q(y) {
    if (y <= this.c1s_1) {
      return this.b1s_1;
    }
    var tmp;
    if (y >= this.g1s_1) {
      tmp = this.f1s_1;
    } else {
      tmp = this.p1q(this.o1q(y));
    }
    return tmp;
  }
  o1q(y) {
    if (y <= this.c1s_1) {
      return 0.0;
    }
    var tmp;
    if (y >= this.g1s_1) {
      tmp = 1.0;
    } else {
      tmp = Companion_instance_44.z1r(y, this.m1s_1, this.n1s_1, this.o1s_1);
    }
    return tmp;
  }
  i1m(r) {
    var r_0 = r;
    r_0 = r_0.d1i(this.b1s_1, this.c1s_1);
    var t = -this.k1s_1 / (2 * this.l1s_1);
    if (t > 0 && t < 1) {
      r_0 = r_0.d1i(this.p1q(t), this.k1q(t));
    }
    return r_0.d1i(this.f1s_1, this.g1s_1);
  }
  p1q(t) {
    return (this.l1s_1 * t + this.k1s_1) * t + this.j1s_1;
  }
  q1q(t0, t1) {
    var t = -this.k1s_1 / (2 * this.l1s_1);
    var tmp;
    if (t > t0 && t < t1) {
      tmp = t;
    } else {
      tmp = t1;
    }
    return tmp;
  }
  r1q(ystart, yend, dir) {
    var t0;
    var tmp;
    if (ystart <= this.c1s_1) {
      if (yend >= this.g1s_1) {
        return this.h1q(dir);
      }
      tmp = 0.0;
    } else {
      tmp = Companion_instance_44.z1r(ystart, this.m1s_1, this.n1s_1, this.o1s_1);
    }
    t0 = tmp;
    var t1;
    var tmp_0;
    if (yend >= this.g1s_1) {
      tmp_0 = 1.0;
    } else {
      tmp_0 = Companion_instance_44.z1r(yend, this.m1s_1, this.n1s_1, this.o1s_1);
    }
    t1 = tmp_0;
    var eqn = new Float64Array(10);
    eqn[0] = this.b1s_1;
    eqn[1] = this.c1s_1;
    eqn[2] = this.d1s_1;
    eqn[3] = this.e1s_1;
    eqn[4] = this.f1s_1;
    eqn[5] = this.g1s_1;
    if (t1 < 1) {
      Companion_instance_44.y1r(eqn, 0, t1);
    }
    var i;
    var tmp_1;
    if (t0 <= 0) {
      tmp_1 = 0;
    } else {
      Companion_instance_44.y1r(eqn, 0, t0 / t1);
      tmp_1 = 4;
    }
    i = tmp_1;
    return new Order2(eqn[i + 0 | 0], ystart, eqn[i + 2 | 0], eqn[i + 3 | 0], eqn[i + 4 | 0], yend, dir);
  }
  r1m(coords) {
    coords[0] = this.d1s_1;
    coords[1] = this.e1s_1;
    if (this.f1m_1 === 1) {
      coords[2] = this.f1s_1;
      coords[3] = this.g1s_1;
    } else {
      coords[2] = this.b1s_1;
      coords[3] = this.c1s_1;
    }
    return 2;
  }
}
class Companion_45 {
  x1p(curves, tmp, x0, y0, cx0, cy0, cx1, cy1, x1, y1, direction) {
    var numparams = this.p1s(y0, cy0, cy1, y1, tmp);
    if (numparams === 0) {
      this.q1s(curves, x0, y0, cx0, cy0, cx1, cy1, x1, y1, direction);
      return Unit_instance;
    }
    tmp[3] = x0;
    tmp[4] = y0;
    tmp[5] = cx0;
    tmp[6] = cy0;
    tmp[7] = cx1;
    tmp[8] = cy1;
    tmp[9] = x1;
    tmp[10] = y1;
    var t = tmp[0];
    if (numparams > 1 && t > tmp[1]) {
      tmp[0] = tmp[1];
      tmp[1] = t;
      t = tmp[0];
    }
    this.y1r(tmp, 3, t);
    if (numparams > 1) {
      t = (tmp[1] - t) / (1 - t);
      this.y1r(tmp, 9, t);
    }
    var index = 3;
    if (direction === -1) {
      index = index + imul_0(numparams, 6) | 0;
    }
    while (numparams >= 0) {
      this.q1s(curves, tmp[index + 0 | 0], tmp[index + 1 | 0], tmp[index + 2 | 0], tmp[index + 3 | 0], tmp[index + 4 | 0], tmp[index + 5 | 0], tmp[index + 6 | 0], tmp[index + 7 | 0], direction);
      numparams = numparams - 1 | 0;
      if (direction === 1) {
        index = index + 6 | 0;
      } else {
        index = index - 6 | 0;
      }
    }
  }
  q1s(curves, x0, y0, cx0, cy0, cx1, cy1, x1, y1, direction) {
    if (y0 > y1) {
      curves.c1(new Order3(x1, y1, cx1, cy1, cx0, cy0, x0, y0, -direction | 0));
    } else if (y1 > y0) {
      curves.c1(new Order3(x0, y0, cx0, cy0, cx1, cy1, x1, y1, direction));
    }
  }
  p1s(c0, cp0, cp1, c1, ret) {
    var cp0_0 = cp0;
    var cp1_0 = cp1;
    var c1_0 = c1;
    if (c0 <= cp0_0 && cp0_0 <= cp1_0 && cp1_0 <= c1_0) {
      return 0;
    }
    c1_0 = c1_0 - cp1_0;
    cp1_0 = cp1_0 - cp0_0;
    cp0_0 = cp0_0 - c0;
    ret[0] = cp0_0;
    ret[1] = (cp1_0 - cp0_0) * 2;
    ret[2] = c1_0 - cp1_0 - cp1_0 + cp0_0;
    var numroots = Companion_instance_48.w1s(ret, ret);
    var j = 0;
    var inductionVariable = 0;
    if (inductionVariable < numroots)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        var t = ret[i];
        if (t > 0 && t < 1) {
          if (j < i) {
            ret[j] = t;
          }
          j = j + 1 | 0;
        }
      }
       while (inductionVariable < numroots);
    return j;
  }
  y1r(coords, pos, t) {
    var x1;
    x1 = coords[pos + 6 | 0];
    coords[pos + 12 | 0] = x1;
    var y1;
    y1 = coords[pos + 7 | 0];
    coords[pos + 13 | 0] = y1;
    var cx1 = coords[pos + 4 | 0];
    var cy1 = coords[pos + 5 | 0];
    x1 = cx1 + (x1 - cx1) * t;
    y1 = cy1 + (y1 - cy1) * t;
    var x0 = coords[pos + 0 | 0];
    var y0 = coords[pos + 1 | 0];
    var cx0 = coords[pos + 2 | 0];
    var cy0 = coords[pos + 3 | 0];
    x0 = x0 + (cx0 - x0) * t;
    y0 = y0 + (cy0 - y0) * t;
    cx0 = cx0 + (cx1 - cx0) * t;
    cy0 = cy0 + (cy1 - cy0) * t;
    cx1 = cx0 + (x1 - cx0) * t;
    cy1 = cy0 + (y1 - cy0) * t;
    cx0 = x0 + (cx0 - x0) * t;
    cy0 = y0 + (cy0 - y0) * t;
    coords[pos + 2 | 0] = x0;
    coords[pos + 3 | 0] = y0;
    coords[pos + 4 | 0] = cx0;
    coords[pos + 5 | 0] = cy0;
    coords[pos + 6 | 0] = cx0 + (cx1 - cx0) * t;
    coords[pos + 7 | 0] = cy0 + (cy1 - cy0) * t;
    coords[pos + 8 | 0] = cx1;
    coords[pos + 9 | 0] = cy1;
    coords[pos + 10 | 0] = x1;
    coords[pos + 11 | 0] = y1;
  }
}
class Order3 extends Curve {
  constructor(x0, y0, cx0, cy0, cx1, cy1, x1, y1, direction) {
    super(direction);
    this.q1t_1 = 0.0;
    this.s1t_1 = 0.0;
    this.u1t_1 = 0.0;
    var cy0_0 = cy0;
    var cy1_0 = cy1;
    if (cy0_0 < y0)
      cy0_0 = y0;
    if (cy1_0 > y1)
      cy1_0 = y1;
    this.y1s_1 = x0;
    this.z1s_1 = y0;
    this.a1t_1 = cx0;
    this.b1t_1 = cy0_0;
    this.c1t_1 = cx1;
    this.d1t_1 = cy1_0;
    this.e1t_1 = x1;
    this.f1t_1 = y1;
    var tmp = this;
    // Inline function 'kotlin.math.min' call
    var tmp0 = Math.min(x0, x1);
    // Inline function 'kotlin.math.min' call
    // Inline function 'kotlin.math.min' call
    var b = Math.min(cx0, cx1);
    tmp.g1t_1 = Math.min(tmp0, b);
    var tmp_0 = this;
    // Inline function 'kotlin.math.max' call
    var tmp0_0 = Math.max(x0, x1);
    // Inline function 'kotlin.math.max' call
    // Inline function 'kotlin.math.max' call
    var b_0 = Math.max(cx0, cx1);
    tmp_0.h1t_1 = Math.max(tmp0_0, b_0);
    this.i1t_1 = x0;
    this.j1t_1 = (cx0 - x0) * 3.0;
    this.k1t_1 = (cx1 - cx0 - cx0 + x0) * 3.0;
    this.l1t_1 = x1 - (cx1 - cx0) * 3.0 - x0;
    this.m1t_1 = y0;
    this.n1t_1 = (cy0_0 - y0) * 3.0;
    this.o1t_1 = (cy1_0 - cy0_0 - cy0_0 + y0) * 3.0;
    this.p1t_1 = y1 - (cy1_0 - cy0_0) * 3.0 - y0;
    this.v1t_1 = y0;
    this.t1t_1 = this.v1t_1;
    this.r1t_1 = this.t1t_1;
  }
  p1n() {
    return this.y1s_1;
  }
  o1n() {
    return this.z1s_1;
  }
  a1o() {
    return this.f1t_1;
  }
  m1q() {
    return this.g1t_1;
  }
  l1q() {
    return this.h1t_1;
  }
  i1q() {
    return new Order3(this.y1s_1, this.z1s_1, this.a1t_1, this.b1t_1, this.c1t_1, this.d1t_1, this.e1t_1, this.f1t_1, -this.f1m_1 | 0);
  }
  j1q() {
    return '(' + Companion_instance_40.g1q(this.w1t()).toString() + ', ' + Companion_instance_40.g1q(this.x1t()).toString() + '), ' + ('(' + Companion_instance_40.g1q(this.y1t()).toString() + ', ' + Companion_instance_40.g1q(this.z1t()).toString() + '), ');
  }
  o1m() {
    return 3;
  }
  g1m() {
    return this.f1m_1 === 1 ? this.y1s_1 : this.e1t_1;
  }
  h1m() {
    return this.f1m_1 === 1 ? this.z1s_1 : this.f1t_1;
  }
  p1m() {
    return this.f1m_1 === 1 ? this.z1s_1 : this.f1t_1;
  }
  q1m() {
    return this.f1m_1 === -1 ? this.z1s_1 : this.f1t_1;
  }
  k1q(t) {
    return ((this.p1t_1 * t + this.o1t_1) * t + this.n1t_1) * t + this.m1t_1;
  }
  a1u(t, deriv) {
    switch (deriv) {
      case 0:
        return ((this.p1t_1 * t + this.o1t_1) * t + this.n1t_1) * t + this.m1t_1;
      case 1:
        return (3 * this.p1t_1 * t + 2 * this.o1t_1) * t + this.n1t_1;
      case 2:
        return 6 * this.p1t_1 * t + 2 * this.o1t_1;
      case 3:
        return 6 * this.p1t_1;
      default:
        return 0.0;
    }
  }
  n1q(y) {
    if (y <= this.z1s_1) {
      return this.y1s_1;
    }
    var tmp;
    if (y >= this.f1t_1) {
      tmp = this.e1t_1;
    } else {
      tmp = this.p1q(this.o1q(y));
    }
    return tmp;
  }
  o1q(y) {
    if (y <= this.z1s_1)
      return 0.0;
    if (y >= this.f1t_1)
      return 1.0;
    if (y === this.r1t_1)
      return this.q1t_1;
    if (y === this.t1t_1)
      return this.s1t_1;
    if (y === this.v1t_1)
      return this.u1t_1;
    if (this.p1t_1 === 0.0) {
      return Companion_instance_44.z1r(y, this.m1t_1, this.n1t_1, this.o1t_1);
    }
    var a = this.o1t_1 / this.p1t_1;
    var b = this.n1t_1 / this.p1t_1;
    var c = (this.m1t_1 - y) / this.p1t_1;
    var roots = 0;
    var Q = (a * a - 3.0 * b) / 9.0;
    var R = (2.0 * a * a * a - 9.0 * a * b + 27.0 * c) / 54.0;
    var R2 = R * R;
    var Q3 = Q * Q * Q;
    var a_3 = a / 3.0;
    var t;
    if (R2 < Q3) {
      var tmp = R;
      // Inline function 'kotlin.math.sqrt' call
      // Inline function 'kotlin.math.acos' call
      var x = tmp / Math.sqrt(Q3);
      var theta = Math.acos(x);
      var tmp_0 = -2.0;
      // Inline function 'kotlin.math.sqrt' call
      var x_0 = Q;
      Q = tmp_0 * Math.sqrt(x_0);
      var tmp_1 = Q;
      // Inline function 'kotlin.math.cos' call
      var x_1 = theta / 3.0;
      var tmp$ret$3 = Math.cos(x_1);
      t = this.b1u(a, b, c, y, tmp_1 * tmp$ret$3 - a_3);
      if (t < 0) {
        var tmp_2 = Q;
        // Inline function 'kotlin.math.cos' call
        var x_2 = (theta + 3.141592653589793 * 2.0) / 3.0;
        var tmp$ret$4 = Math.cos(x_2);
        t = this.b1u(a, b, c, y, tmp_2 * tmp$ret$4 - a_3);
      }
      if (t < 0) {
        var tmp_3 = Q;
        // Inline function 'kotlin.math.cos' call
        var x_3 = (theta - 3.141592653589793 * 2.0) / 3.0;
        var tmp$ret$5 = Math.cos(x_3);
        t = this.b1u(a, b, c, y, tmp_3 * tmp$ret$5 - a_3);
      }
    } else {
      var neg = R < 0.0;
      if (neg) {
        R = -R;
      }
      // Inline function 'kotlin.math.sqrt' call
      var x_4 = R2 - Q3;
      var S = Math.sqrt(x_4);
      var tmp0 = R + S;
      // Inline function 'kotlin.math.pow' call
      var x_5 = 1.0 / 3.0;
      var A = Math.pow(tmp0, x_5);
      if (!neg) {
        A = -A;
      }
      var B = A === 0.0 ? 0.0 : Q / A;
      t = this.b1u(a, b, c, y, A + B - a_3);
    }
    if (t < 0) {
      var t0 = 0.0;
      var t1 = 1.0;
      $l$loop_0: while (true) {
        t = (t0 + t1) / 2;
        if (t === t0 || t === t1) {
          break $l$loop_0;
        }
        var yt = this.k1q(t);
        if (yt < y) {
          t0 = t;
        } else if (yt > y) {
          t1 = t;
        } else {
          break $l$loop_0;
        }
      }
    }
    if (t >= 0) {
      this.u1t_1 = this.s1t_1;
      this.v1t_1 = this.t1t_1;
      this.s1t_1 = this.q1t_1;
      this.t1t_1 = this.r1t_1;
      this.q1t_1 = t;
      this.r1t_1 = y;
    }
    return t;
  }
  b1u(a, b, c, target, t) {
    var t_0 = t;
    if (t_0 < -0.1 || t_0 > 1.1) {
      return -1;
    }
    var y = this.k1q(t_0);
    var t0;
    var t1;
    if (y < target) {
      t0 = t_0;
      t1 = 1.0;
    } else {
      t0 = 0.0;
      t1 = t_0;
    }
    var origt = t_0;
    var origy = y;
    var useslope = true;
    $l$loop_2: while (!(y === target)) {
      if (!useslope) {
        var t2 = (t0 + t1) / 2;
        if (t2 === t0 || t2 === t1) {
          break $l$loop_2;
        }
        t_0 = t2;
      } else {
        var slope = this.a1u(t_0, 1);
        if (slope === 0.0) {
          useslope = false;
          continue $l$loop_2;
        }
        var t2_0 = t_0 + (target - y) / slope;
        if (t2_0 === t_0 || t2_0 <= t0 || t2_0 >= t1) {
          useslope = false;
          continue $l$loop_2;
        }
        t_0 = t2_0;
      }
      y = this.k1q(t_0);
      if (y < target) {
        t0 = t_0;
      } else if (y > target) {
        t1 = t_0;
      } else {
        break $l$loop_2;
      }
    }
    if (false && t_0 >= 0 && t_0 <= 1) {
      y = this.k1q(t_0);
      var tdiff = Companion_instance_40.f1q(t_0, origt);
      var ydiff = Companion_instance_40.f1q(y, origy);
      var yerr = Companion_instance_40.f1q(y, target);
      var verbose = false;
    }
    return t_0 > 1 ? -1.0 : t_0;
  }
  p1q(t) {
    return ((this.l1t_1 * t + this.k1t_1) * t + this.j1t_1) * t + this.i1t_1;
  }
  q1q(t0, t1) {
    var t1_0 = t1;
    // Inline function 'kotlin.doubleArrayOf' call
    var eqn = new Float64Array([this.j1t_1, 2 * this.k1t_1, 3 * this.l1t_1]);
    var numroots = Companion_instance_48.w1s(eqn, eqn);
    var inductionVariable = 0;
    if (inductionVariable < numroots)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        if (eqn[i] > t0 && eqn[i] < t1_0) {
          t1_0 = eqn[i];
        }
      }
       while (inductionVariable < numroots);
    return t1_0;
  }
  r1q(ystart, yend, dir) {
    if (ystart <= this.z1s_1 && yend >= this.f1t_1) {
      return this.h1q(dir);
    }
    var t0 = this.o1q(ystart);
    var t1 = this.o1q(yend);
    var eqn = new Float64Array(14);
    eqn[0] = this.y1s_1;
    eqn[1] = this.z1s_1;
    eqn[2] = this.a1t_1;
    eqn[3] = this.b1t_1;
    eqn[4] = this.c1t_1;
    eqn[5] = this.d1t_1;
    eqn[6] = this.e1t_1;
    eqn[7] = this.f1t_1;
    if (t0 > t1) {
      var t = t0;
      t0 = t1;
      t1 = t;
    }
    if (t1 < 1) {
      Companion_instance_45.y1r(eqn, 0, t1);
    }
    var i;
    var tmp;
    if (t0 <= 0) {
      tmp = 0;
    } else {
      Companion_instance_45.y1r(eqn, 0, t0 / t1);
      tmp = 6;
    }
    i = tmp;
    return new Order3(eqn[i + 0 | 0], ystart, eqn[i + 2 | 0], eqn[i + 3 | 0], eqn[i + 4 | 0], eqn[i + 5 | 0], eqn[i + 6 | 0], yend, dir);
  }
  r1m(coords) {
    if (this.f1m_1 === 1) {
      coords[0] = this.a1t_1;
      coords[1] = this.b1t_1;
      coords[2] = this.c1t_1;
      coords[3] = this.d1t_1;
      coords[4] = this.e1t_1;
      coords[5] = this.f1t_1;
    } else {
      coords[0] = this.c1t_1;
      coords[1] = this.d1t_1;
      coords[2] = this.a1t_1;
      coords[3] = this.b1t_1;
      coords[4] = this.y1s_1;
      coords[5] = this.z1s_1;
    }
    return 3;
  }
  i1m(r) {
    var r_0 = r;
    r_0 = r_0.d1i(this.y1s_1, this.z1s_1);
    // Inline function 'kotlin.doubleArrayOf' call
    var eqn = new Float64Array([this.j1t_1, 2 * this.k1t_1, 3 * this.l1t_1]);
    var numroots = Companion_instance_48.w1s(eqn, eqn);
    var inductionVariable = 0;
    if (inductionVariable < numroots)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        var t = eqn[i];
        if (t > 0 && t < 1) {
          r_0 = r_0.d1i(this.p1q(t), this.k1q(t));
        }
      }
       while (inductionVariable < numroots);
    return r_0.d1i(this.e1t_1, this.f1t_1);
  }
  w1t() {
    return this.f1m_1 === 1 ? this.a1t_1 : this.c1t_1;
  }
  x1t() {
    return this.f1m_1 === 1 ? this.b1t_1 : this.d1t_1;
  }
  y1t() {
    return this.f1m_1 === -1 ? this.a1t_1 : this.c1t_1;
  }
  z1t() {
    return this.f1m_1 === -1 ? this.b1t_1 : this.d1t_1;
  }
}
class Iterator {
  constructor(path) {
    Companion_getInstance_46();
    this.k1u_1 = path;
    this.l1u_1 = 0;
    this.m1u_1 = 0;
  }
  q1l() {
    return this.k1u_1.j1u_1;
  }
  m17() {
    return this.l1u_1 >= this.k1u_1.h1u_1;
  }
  r1l() {
    var tmp = this.k1u_1.g1u_1;
    var _unary__edvuaz = this.l1u_1;
    this.l1u_1 = _unary__edvuaz + 1 | 0;
    var type = tmp[_unary__edvuaz];
    this.m1u_1 = this.m1u_1 + Companion_getInstance_46().n1u_1[type] | 0;
  }
}
class CopyIterator extends Iterator {
  constructor(p2dd) {
    super(p2dd);
    this.f1u_1 = p2dd.h1k_1;
  }
  s1l(coords) {
    var type = this.k1u_1.g1u_1[this.l1u_1];
    var numCoords = Companion_getInstance_46().n1u_1[type];
    if (numCoords > 0) {
      var inductionVariable = 0;
      if (inductionVariable < numCoords)
        do {
          var i = inductionVariable;
          inductionVariable = inductionVariable + 1 | 0;
          coords[i] = this.f1u_1[this.m1u_1 + i | 0];
        }
         while (inductionVariable < numCoords);
    }
    return type;
  }
}
class TxIterator extends Iterator {
  constructor(p2dd, at) {
    super(p2dd);
    this.r1u_1 = p2dd.h1k_1;
    this.s1u_1 = at;
  }
  s1l(coords) {
    var type = this.k1u_1.g1u_1[this.l1u_1];
    var numCoords = Companion_getInstance_46().n1u_1[type];
    if (numCoords > 0) {
      this.s1u_1.b1k(this.r1u_1, this.m1u_1, coords, 0, numCoords / 2 | 0);
    }
    return type;
  }
}
class Companion_46 {
  constructor() {
    Companion_instance_46 = this;
    var tmp = this;
    // Inline function 'kotlin.intArrayOf' call
    tmp.n1u_1 = new Int32Array([2, 2, 4, 6, 0]);
  }
}
class Path2D {
  static v1u() {
    var $this = createThis(this);
    init_org_mkui_geom_Path2D($this);
    $this.g1u_1 = new Int8Array(0);
    return $this;
  }
  static u1u(rule, initialTypes) {
    var $this = createThis(this);
    init_org_mkui_geom_Path2D($this);
    $this.j1u_1 = rule;
    $this.g1u_1 = new Int8Array(initialTypes);
    return $this;
  }
  q1v() {
    if (this.h1u_1 === 0 || !(this.g1u_1[this.h1u_1 - 1 | 0] === 4)) {
      this.j1v(true, 0);
      var tmp = this.g1u_1;
      var _unary__edvuaz = this.h1u_1;
      this.h1u_1 = _unary__edvuaz + 1 | 0;
      tmp[_unary__edvuaz] = 4;
    }
  }
  j1h(point) {
    return this.f1i(point.g1h(), point.h1h());
  }
  f1i(x, y) {
    var tmp;
    if (x * 0.0 + y * 0.0 === 0.0) {
      if (this.h1u_1 < 2) {
        return false;
      }
      var mask = this.j1u_1 === 1 ? -1 : 1;
      tmp = !((this.k1v(x, y) & mask) === 0);
    } else {
      tmp = false;
    }
    return tmp;
  }
  l1h(rect) {
    return this.e1i(rect.g1h(), rect.h1h(), rect.gm(), rect.hm());
  }
  e1i(x, y, w, h) {
    if (isNaN_0(x + w) || isNaN_0(y + h)) {
      return false;
    }
    if (w <= 0 || h <= 0) {
      return false;
    }
    var mask = this.j1u_1 === 1 ? -1 : 2;
    var crossings = this.l1v(x, y, x + w, y + h);
    return crossings === -2147483648 || !((crossings & mask) === 0);
  }
}
class Double_1 extends Path2D {
  static t1u(rule, initialCapacity) {
    rule = rule === VOID ? 1 : rule;
    initialCapacity = initialCapacity === VOID ? 20 : initialCapacity;
    var $this = this.u1u(rule, initialCapacity);
    init_org_mkui_geom_Path2D_Double($this);
    $this.h1k_1 = new Float64Array(imul_0(initialCapacity, 2));
    return $this;
  }
  static i1k(s, at) {
    var $this = this.v1u();
    init_org_mkui_geom_Path2D_Double($this);
    if (s instanceof Path2D) {
      $this.j1u_1 = s.j1u_1;
      $this.h1u_1 = s.h1u_1;
      $this.g1u_1 = Companion_instance_47.g1v(s.g1u_1, s.h1u_1);
      $this.i1u_1 = s.i1u_1;
      $this.h1k_1 = s.h1v(at);
    } else {
      var pi = s.o1h(at);
      $this.j1u_1 = pi.q1l();
      $this.g1u_1 = new Int8Array(20);
      $this.h1k_1 = new Float64Array(40);
      $this.w1u(pi, false);
    }
    return $this;
  }
  h1v(at) {
    var ret;
    if (at == null) {
      ret = Companion_instance_47.i1v(this.h1k_1, this.i1u_1);
    } else {
      ret = new Float64Array(this.i1u_1);
      at.b1k(this.h1k_1, 0, ret, 0, this.i1u_1 / 2 | 0);
    }
    return ret;
  }
  j1v(needMove, newCoords) {
    // Inline function 'kotlin.check' call
    if (!!(needMove && this.h1u_1 === 0)) {
      var message = 'missing initial moveto in path definition';
      throw IllegalStateException.w3(toString_1(message));
    }
    var size = this.g1u_1.length;
    if (this.h1u_1 >= size) {
      var grow = size;
      if (grow > 500) {
        grow = 500;
      }
      this.g1u_1 = Companion_instance_47.g1v(this.g1u_1, size + grow | 0);
    }
    size = this.h1k_1.length;
    if ((this.i1u_1 + newCoords | 0) > size) {
      var grow_0 = size;
      if (grow_0 > 1000) {
        grow_0 = 1000;
      }
      if (grow_0 < newCoords) {
        grow_0 = newCoords;
      }
      this.h1k_1 = Companion_instance_47.i1v(this.h1k_1, size + grow_0 | 0);
    }
  }
  k1v(px, py) {
    if (this.h1u_1 === 0) {
      return 0;
    }
    var movx;
    var coords = this.h1k_1;
    movx = coords[0];
    var curx = movx;
    var movy;
    movy = coords[1];
    var cury = movy;
    var crossings = 0;
    var ci = 2;
    var inductionVariable = 1;
    var last = this.h1u_1;
    if (inductionVariable < last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        var endy;
        var endx;
        var tmp0_subject = this.g1u_1[i];
        if (tmp0_subject === 0) {
          if (!(cury === movy)) {
            crossings = crossings + Companion_instance_40.y1p(px, py, curx, cury, movx, movy) | 0;
          }
          // Inline function 'kotlin.run' call
          var _unary__edvuaz = ci;
          ci = _unary__edvuaz + 1 | 0;
          curx = coords[_unary__edvuaz];
          movx = curx;
          // Inline function 'kotlin.run' call
          var _unary__edvuaz_0 = ci;
          ci = _unary__edvuaz_0 + 1 | 0;
          cury = coords[_unary__edvuaz_0];
          movy = cury;
        } else if (tmp0_subject === 1) {
          var tmp = crossings;
          var tmp_0 = Companion_instance_40;
          var tmp_1 = curx;
          var tmp_2 = cury;
          var _unary__edvuaz_1 = ci;
          ci = _unary__edvuaz_1 + 1 | 0;
          // Inline function 'kotlin.also' call
          var this_0 = coords[_unary__edvuaz_1];
          endx = this_0;
          var tmp_3 = this_0;
          var _unary__edvuaz_2 = ci;
          ci = _unary__edvuaz_2 + 1 | 0;
          // Inline function 'kotlin.also' call
          var this_1 = coords[_unary__edvuaz_2];
          endy = this_1;
          crossings = tmp + tmp_0.y1p(px, py, tmp_1, tmp_2, tmp_3, this_1) | 0;
          curx = endx;
          cury = endy;
        } else if (tmp0_subject === 2) {
          var tmp_4 = crossings;
          var tmp_5 = Companion_instance_40;
          var tmp_6 = curx;
          var tmp_7 = cury;
          var _unary__edvuaz_3 = ci;
          ci = _unary__edvuaz_3 + 1 | 0;
          var tmp_8 = coords[_unary__edvuaz_3];
          var _unary__edvuaz_4 = ci;
          ci = _unary__edvuaz_4 + 1 | 0;
          var tmp_9 = coords[_unary__edvuaz_4];
          var _unary__edvuaz_5 = ci;
          ci = _unary__edvuaz_5 + 1 | 0;
          // Inline function 'kotlin.also' call
          var this_2 = coords[_unary__edvuaz_5];
          endx = this_2;
          var tmp_10 = this_2;
          var _unary__edvuaz_6 = ci;
          ci = _unary__edvuaz_6 + 1 | 0;
          // Inline function 'kotlin.also' call
          var this_3 = coords[_unary__edvuaz_6];
          endy = this_3;
          crossings = tmp_4 + tmp_5.z1p(px, py, tmp_6, tmp_7, tmp_8, tmp_9, tmp_10, this_3, 0) | 0;
          curx = endx;
          cury = endy;
        } else if (tmp0_subject === 3) {
          var tmp_11 = crossings;
          var tmp_12 = Companion_instance_40;
          var tmp_13 = curx;
          var tmp_14 = cury;
          var _unary__edvuaz_7 = ci;
          ci = _unary__edvuaz_7 + 1 | 0;
          var tmp_15 = coords[_unary__edvuaz_7];
          var _unary__edvuaz_8 = ci;
          ci = _unary__edvuaz_8 + 1 | 0;
          var tmp_16 = coords[_unary__edvuaz_8];
          var _unary__edvuaz_9 = ci;
          ci = _unary__edvuaz_9 + 1 | 0;
          var tmp_17 = coords[_unary__edvuaz_9];
          var _unary__edvuaz_10 = ci;
          ci = _unary__edvuaz_10 + 1 | 0;
          var tmp_18 = coords[_unary__edvuaz_10];
          var _unary__edvuaz_11 = ci;
          ci = _unary__edvuaz_11 + 1 | 0;
          // Inline function 'kotlin.also' call
          var this_4 = coords[_unary__edvuaz_11];
          endx = this_4;
          var tmp_19 = this_4;
          var _unary__edvuaz_12 = ci;
          ci = _unary__edvuaz_12 + 1 | 0;
          // Inline function 'kotlin.also' call
          var this_5 = coords[_unary__edvuaz_12];
          endy = this_5;
          crossings = tmp_11 + tmp_12.a1q(px, py, tmp_13, tmp_14, tmp_15, tmp_16, tmp_17, tmp_18, tmp_19, this_5, 0) | 0;
          curx = endx;
          cury = endy;
        } else if (tmp0_subject === 4) {
          if (!(cury === movy)) {
            crossings = crossings + Companion_instance_40.y1p(px, py, curx, cury, movx, movy) | 0;
          }
          curx = movx;
          cury = movy;
        }
      }
       while (inductionVariable < last);
    if (!(cury === movy)) {
      crossings = crossings + Companion_instance_40.y1p(px, py, curx, cury, movx, movy) | 0;
    }
    return crossings;
  }
  l1v(rxmin, rymin, rxmax, rymax) {
    if (this.h1u_1 === 0) {
      return 0;
    }
    var coords = this.h1k_1;
    var movx;
    movx = coords[0];
    var curx = movx;
    var movy;
    movy = coords[1];
    var cury = movy;
    var crossings = 0;
    var ci = 2;
    var i = 1;
    while (!(crossings === -2147483648) && i < this.h1u_1) {
      var endy;
      var endx;
      var tmp0_subject = this.g1u_1[i];
      if (tmp0_subject === 0) {
        if (!(curx === movx) || !(cury === movy)) {
          crossings = Companion_instance_40.b1q(crossings, rxmin, rymin, rxmax, rymax, curx, cury, movx, movy);
        }
        // Inline function 'kotlin.run' call
        var _unary__edvuaz = ci;
        ci = _unary__edvuaz + 1 | 0;
        curx = coords[_unary__edvuaz];
        movx = curx;
        // Inline function 'kotlin.run' call
        var _unary__edvuaz_0 = ci;
        ci = _unary__edvuaz_0 + 1 | 0;
        cury = coords[_unary__edvuaz_0];
        movy = cury;
      } else if (tmp0_subject === 1) {
        var _unary__edvuaz_1 = ci;
        ci = _unary__edvuaz_1 + 1 | 0;
        endx = coords[_unary__edvuaz_1];
        var _unary__edvuaz_2 = ci;
        ci = _unary__edvuaz_2 + 1 | 0;
        endy = coords[_unary__edvuaz_2];
        crossings = Companion_instance_40.b1q(crossings, rxmin, rymin, rxmax, rymax, curx, cury, endx, endy);
        curx = endx;
        cury = endy;
      } else if (tmp0_subject === 2) {
        var tmp = Companion_instance_40;
        var tmp_0 = crossings;
        var tmp_1 = curx;
        var tmp_2 = cury;
        var _unary__edvuaz_3 = ci;
        ci = _unary__edvuaz_3 + 1 | 0;
        var tmp_3 = coords[_unary__edvuaz_3];
        var _unary__edvuaz_4 = ci;
        ci = _unary__edvuaz_4 + 1 | 0;
        var tmp_4 = coords[_unary__edvuaz_4];
        var _unary__edvuaz_5 = ci;
        ci = _unary__edvuaz_5 + 1 | 0;
        // Inline function 'kotlin.also' call
        var this_0 = coords[_unary__edvuaz_5];
        endx = this_0;
        var tmp_5 = this_0;
        var _unary__edvuaz_6 = ci;
        ci = _unary__edvuaz_6 + 1 | 0;
        // Inline function 'kotlin.also' call
        var this_1 = coords[_unary__edvuaz_6];
        endy = this_1;
        crossings = tmp.c1q(tmp_0, rxmin, rymin, rxmax, rymax, tmp_1, tmp_2, tmp_3, tmp_4, tmp_5, this_1, 0);
        curx = endx;
        cury = endy;
      } else if (tmp0_subject === 3) {
        var tmp_6 = Companion_instance_40;
        var tmp_7 = crossings;
        var tmp_8 = curx;
        var tmp_9 = cury;
        var _unary__edvuaz_7 = ci;
        ci = _unary__edvuaz_7 + 1 | 0;
        var tmp_10 = coords[_unary__edvuaz_7];
        var _unary__edvuaz_8 = ci;
        ci = _unary__edvuaz_8 + 1 | 0;
        var tmp_11 = coords[_unary__edvuaz_8];
        var _unary__edvuaz_9 = ci;
        ci = _unary__edvuaz_9 + 1 | 0;
        var tmp_12 = coords[_unary__edvuaz_9];
        var _unary__edvuaz_10 = ci;
        ci = _unary__edvuaz_10 + 1 | 0;
        var tmp_13 = coords[_unary__edvuaz_10];
        var _unary__edvuaz_11 = ci;
        ci = _unary__edvuaz_11 + 1 | 0;
        // Inline function 'kotlin.also' call
        var this_2 = coords[_unary__edvuaz_11];
        endx = this_2;
        var tmp_14 = this_2;
        var _unary__edvuaz_12 = ci;
        ci = _unary__edvuaz_12 + 1 | 0;
        // Inline function 'kotlin.also' call
        var this_3 = coords[_unary__edvuaz_12];
        endy = this_3;
        crossings = tmp_6.d1q(tmp_7, rxmin, rymin, rxmax, rymax, tmp_8, tmp_9, tmp_10, tmp_11, tmp_12, tmp_13, tmp_14, this_3, 0);
        curx = endx;
        cury = endy;
      } else if (tmp0_subject === 4) {
        if (!(curx === movx) || !(cury === movy)) {
          crossings = Companion_instance_40.b1q(crossings, rxmin, rymin, rxmax, rymax, curx, cury, movx, movy);
        }
        curx = movx;
        cury = movy;
      }
      i = i + 1 | 0;
    }
    if (!(crossings === -2147483648) && (!(curx === movx) || !(cury === movy))) {
      crossings = Companion_instance_40.b1q(crossings, rxmin, rymin, rxmax, rymax, curx, cury, movx, movy);
    }
    return crossings;
  }
  m1v(x, y) {
    if (this.h1u_1 > 0 && this.g1u_1[this.h1u_1 - 1 | 0] === 0) {
      this.h1k_1[this.i1u_1 - 2 | 0] = x;
      this.h1k_1[this.i1u_1 - 1 | 0] = y;
    } else {
      this.j1v(false, 2);
      var tmp = this.g1u_1;
      var _unary__edvuaz = this.h1u_1;
      this.h1u_1 = _unary__edvuaz + 1 | 0;
      tmp[_unary__edvuaz] = 0;
      var tmp_0 = this.h1k_1;
      var _unary__edvuaz_0 = this.i1u_1;
      this.i1u_1 = _unary__edvuaz_0 + 1 | 0;
      tmp_0[_unary__edvuaz_0] = x;
      var tmp_1 = this.h1k_1;
      var _unary__edvuaz_1 = this.i1u_1;
      this.i1u_1 = _unary__edvuaz_1 + 1 | 0;
      tmp_1[_unary__edvuaz_1] = y;
    }
  }
  n1v(x, y) {
    this.j1v(true, 2);
    var tmp = this.g1u_1;
    var _unary__edvuaz = this.h1u_1;
    this.h1u_1 = _unary__edvuaz + 1 | 0;
    tmp[_unary__edvuaz] = 1;
    var tmp_0 = this.h1k_1;
    var _unary__edvuaz_0 = this.i1u_1;
    this.i1u_1 = _unary__edvuaz_0 + 1 | 0;
    tmp_0[_unary__edvuaz_0] = x;
    var tmp_1 = this.h1k_1;
    var _unary__edvuaz_1 = this.i1u_1;
    this.i1u_1 = _unary__edvuaz_1 + 1 | 0;
    tmp_1[_unary__edvuaz_1] = y;
  }
  o1v(x1, y1, x2, y2) {
    this.j1v(true, 4);
    var tmp = this.g1u_1;
    var _unary__edvuaz = this.h1u_1;
    this.h1u_1 = _unary__edvuaz + 1 | 0;
    tmp[_unary__edvuaz] = 2;
    var tmp_0 = this.h1k_1;
    var _unary__edvuaz_0 = this.i1u_1;
    this.i1u_1 = _unary__edvuaz_0 + 1 | 0;
    tmp_0[_unary__edvuaz_0] = x1;
    var tmp_1 = this.h1k_1;
    var _unary__edvuaz_1 = this.i1u_1;
    this.i1u_1 = _unary__edvuaz_1 + 1 | 0;
    tmp_1[_unary__edvuaz_1] = y1;
    var tmp_2 = this.h1k_1;
    var _unary__edvuaz_2 = this.i1u_1;
    this.i1u_1 = _unary__edvuaz_2 + 1 | 0;
    tmp_2[_unary__edvuaz_2] = x2;
    var tmp_3 = this.h1k_1;
    var _unary__edvuaz_3 = this.i1u_1;
    this.i1u_1 = _unary__edvuaz_3 + 1 | 0;
    tmp_3[_unary__edvuaz_3] = y2;
  }
  p1v(x1, y1, x2, y2, x3, y3) {
    this.j1v(true, 6);
    var tmp = this.g1u_1;
    var _unary__edvuaz = this.h1u_1;
    this.h1u_1 = _unary__edvuaz + 1 | 0;
    tmp[_unary__edvuaz] = 3;
    var tmp_0 = this.h1k_1;
    var _unary__edvuaz_0 = this.i1u_1;
    this.i1u_1 = _unary__edvuaz_0 + 1 | 0;
    tmp_0[_unary__edvuaz_0] = x1;
    var tmp_1 = this.h1k_1;
    var _unary__edvuaz_1 = this.i1u_1;
    this.i1u_1 = _unary__edvuaz_1 + 1 | 0;
    tmp_1[_unary__edvuaz_1] = y1;
    var tmp_2 = this.h1k_1;
    var _unary__edvuaz_2 = this.i1u_1;
    this.i1u_1 = _unary__edvuaz_2 + 1 | 0;
    tmp_2[_unary__edvuaz_2] = x2;
    var tmp_3 = this.h1k_1;
    var _unary__edvuaz_3 = this.i1u_1;
    this.i1u_1 = _unary__edvuaz_3 + 1 | 0;
    tmp_3[_unary__edvuaz_3] = y2;
    var tmp_4 = this.h1k_1;
    var _unary__edvuaz_4 = this.i1u_1;
    this.i1u_1 = _unary__edvuaz_4 + 1 | 0;
    tmp_4[_unary__edvuaz_4] = x3;
    var tmp_5 = this.h1k_1;
    var _unary__edvuaz_5 = this.i1u_1;
    this.i1u_1 = _unary__edvuaz_5 + 1 | 0;
    tmp_5[_unary__edvuaz_5] = y3;
  }
  w1u(pi, connect) {
    var connect_0 = connect;
    var coords = new Float64Array(6);
    while (!pi.m17()) {
      var tmp0_subject = toByte(pi.s1l(coords));
      if (tmp0_subject === 0) {
        if (!connect_0 || this.h1u_1 < 1 || this.i1u_1 < 1) {
          this.m1v(coords[0], coords[1]);
        } else if (this.g1u_1[this.h1u_1 - 1 | 0] === 4 || this.h1k_1[this.i1u_1 - 2 | 0] !== coords[0] || this.h1k_1[this.i1u_1 - 1 | 0] !== coords[1]) {
          this.n1v(coords[0], coords[1]);
        }
      } else if (tmp0_subject === 1) {
        this.n1v(coords[0], coords[1]);
      } else if (tmp0_subject === 2) {
        this.o1v(coords[0], coords[1], coords[2], coords[3]);
      } else if (tmp0_subject === 3) {
        this.p1v(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
      } else if (tmp0_subject === 4) {
        this.q1v();
      }
      pi.r1l();
      connect_0 = false;
    }
  }
  i1h() {
    return this.u1k();
  }
  u1k() {
    var x1;
    var y1;
    var x2;
    var y2;
    var i = this.i1u_1;
    if (i > 0) {
      var tmp = this.h1k_1;
      i = i - 1 | 0;
      y2 = tmp[i];
      y1 = y2;
      var tmp_0 = this.h1k_1;
      i = i - 1 | 0;
      x2 = tmp_0[i];
      x1 = x2;
      while (i > 0) {
        var tmp_1 = this.h1k_1;
        i = i - 1 | 0;
        var y = tmp_1[i];
        var tmp_2 = this.h1k_1;
        i = i - 1 | 0;
        var x = tmp_2[i];
        if (x < x1)
          x1 = x;
        if (y < y1)
          y1 = y;
        if (x > x2)
          x2 = x;
        if (y > y2)
          y2 = y;
      }
    } else {
      y2 = 0.0;
      x2 = y2;
      y1 = x2;
      x1 = y1;
    }
    return Double_3.z1h(x1, y1, x2 - x1, y2 - y1);
  }
  n1h() {
    return this.o1h(null);
  }
  o1h(at) {
    var tmp;
    if (at == null) {
      tmp = new CopyIterator(this);
    } else {
      tmp = new TxIterator(this, at);
    }
    return tmp;
  }
}
class Companion_47 {
  constructor() {
    this.x1u_1 = 0;
    this.y1u_1 = 1;
    this.z1u_1 = 20;
    this.a1v_1 = 500;
    this.b1v_1 = 0;
    this.c1v_1 = 1;
    this.d1v_1 = 2;
    this.e1v_1 = 3;
    this.f1v_1 = 4;
  }
  g1v(original, newLength) {
    var copy = new Int8Array(newLength);
    // Inline function 'kotlin.math.min' call
    var a = original.length;
    var tmp$ret$0 = Math.min(a, newLength);
    arraycopy_1(original, 0, copy, 0, tmp$ret$0);
    return copy;
  }
  i1v(original, newLength) {
    var copy = new Float64Array(newLength);
    // Inline function 'kotlin.math.min' call
    var a = original.length;
    var tmp$ret$0 = Math.min(a, newLength);
    arraycopy_0(original, 0, copy, 0, tmp$ret$0);
    return copy;
  }
}
class Point {
  constructor(ix, iy) {
    this.r1v_1 = ix;
    this.s1v_1 = iy;
  }
  toString() {
    return 'Point.Integer{x=' + this.g1h() + ', y=' + this.h1h() + toString(_Char___init__impl__6a9atx(125));
  }
  g1h() {
    return this.r1v_1;
  }
  h1h() {
    return this.s1v_1;
  }
  a1k(x, y) {
    var tmp = this;
    // Inline function 'kotlin.math.floor' call
    var x_0 = x + 0.5;
    var tmp$ret$0 = Math.floor(x_0);
    tmp.r1v_1 = numberToInt(tmp$ret$0);
    var tmp_0 = this;
    // Inline function 'kotlin.math.floor' call
    var x_1 = y + 0.5;
    var tmp$ret$1 = Math.floor(x_1);
    tmp_0.s1v_1 = numberToInt(tmp$ret$1);
  }
  t1v(e) {
    var px = e.g1h() - this.g1h();
    var py = e.h1h() - this.h1h();
    // Inline function 'kotlin.math.sqrt' call
    var x = px * px + py * py;
    return Math.sqrt(x);
  }
}
class Double_2 {
  g1h() {
    return this.x1j_1;
  }
  h1h() {
    return this.y1j_1;
  }
  static z1j() {
    var $this = createThis(this);
    init_org_mkui_geom_Point2D_Double($this);
    return $this;
  }
  static c1l(x, y) {
    var $this = createThis(this);
    init_org_mkui_geom_Point2D_Double($this);
    $this.x1j_1 = x;
    $this.y1j_1 = y;
    return $this;
  }
  toString() {
    return 'Point.Double{x=' + this.x1j_1 + ', y=' + this.y1j_1 + toString(_Char___init__impl__6a9atx(125));
  }
  a1k(x, y) {
    this.x1j_1 = x;
    this.y1j_1 = y;
  }
  t1v(pt) {
    var px = pt.g1h() - this.x1j_1;
    var py = pt.h1h() - this.y1j_1;
    // Inline function 'kotlin.math.sqrt' call
    var x = px * px + py * py;
    return Math.sqrt(x);
  }
}
class Float {
  static w1j() {
    var $this = createThis(this);
    init_org_mkui_geom_Point2D_Float($this);
    return $this;
  }
  g1h() {
    return this.u1j_1;
  }
  h1h() {
    return this.v1j_1;
  }
  toString() {
    return 'Point.Float{x=' + this.u1j_1 + ', y=' + this.v1j_1 + toString(_Char___init__impl__6a9atx(125));
  }
  a1k(x, y) {
    this.u1j_1 = x;
    this.v1j_1 = y;
  }
  t1v(e) {
    var px = e.g1h() - this.g1h();
    var py = e.h1h() - this.h1h();
    // Inline function 'kotlin.math.sqrt' call
    var x = px * px + py * py;
    return Math.sqrt(x);
  }
}
class Companion_48 {
  constructor() {
    this.r1s_1 = -2;
    this.s1s_1 = -1;
    this.t1s_1 = 0;
    this.u1s_1 = 1;
    this.v1s_1 = 2;
  }
  w1s(eqn, res) {
    var a = eqn[2];
    var b = eqn[1];
    var c = eqn[0];
    var roots = 0;
    if (a === 0.0) {
      if (b === 0.0) {
        return -1;
      }
      var _unary__edvuaz = roots;
      roots = _unary__edvuaz + 1 | 0;
      res[_unary__edvuaz] = -c / b;
    } else {
      var d = b * b - 4.0 * a * c;
      if (d < 0.0) {
        return 0;
      }
      // Inline function 'kotlin.math.sqrt' call
      var x = d;
      d = Math.sqrt(x);
      if (b < 0.0) {
        d = -d;
      }
      var q = (b + d) / -2.0;
      var _unary__edvuaz_0 = roots;
      roots = _unary__edvuaz_0 + 1 | 0;
      res[_unary__edvuaz_0] = q / a;
      if (!(q === 0.0)) {
        var _unary__edvuaz_1 = roots;
        roots = _unary__edvuaz_1 + 1 | 0;
        res[_unary__edvuaz_1] = c / q;
      }
    }
    return roots;
  }
}
class RectIterator {
  constructor(r, at) {
    this.z1v_1 = 0;
    this.u1v_1 = r.g1h();
    this.v1v_1 = r.h1h();
    this.w1v_1 = r.gm();
    this.x1v_1 = r.hm();
    this.y1v_1 = at;
    if (this.w1v_1 < 0 || this.x1v_1 < 0) {
      this.z1v_1 = 6;
    }
  }
  q1l() {
    return 1;
  }
  m17() {
    return this.z1v_1 > 5;
  }
  r1l() {
    this.z1v_1 = this.z1v_1 + 1 | 0;
  }
  s1l(coords) {
    if (this.m17()) {
      throw NoSuchElementException.g1('rect iterator out of bounds');
    }
    if (this.z1v_1 === 5) {
      return 4;
    }
    coords[0] = this.u1v_1;
    coords[1] = this.v1v_1;
    if (this.z1v_1 === 1 || this.z1v_1 === 2) {
      coords[0] = coords[0] + this.w1v_1;
    }
    if (this.z1v_1 === 2 || this.z1v_1 === 3) {
      coords[1] = coords[1] + this.x1v_1;
    }
    var tmp0_safe_receiver = this.y1v_1;
    if (tmp0_safe_receiver == null)
      null;
    else {
      tmp0_safe_receiver.b1k(coords, 0, coords, 0, 1);
    }
    return this.z1v_1 === 0 ? 0 : 1;
  }
}
class Rectangle extends AbstractRectangle2D {
  static empty() {
    var $this = this.e1h();
    init_org_mkui_geom_Rectangle($this);
    return $this;
  }
  static fromRectangle(rectangle) {
    var $this = this.e1h();
    init_org_mkui_geom_Rectangle($this);
    $this.a1w_1 = rectangle.a1w_1;
    $this.b1w_1 = rectangle.b1w_1;
    $this.c1w_1 = rectangle.c1w_1;
    $this.d1w_1 = rectangle.d1w_1;
    return $this;
  }
  static from(x, y, width, height) {
    var $this = this.e1h();
    init_org_mkui_geom_Rectangle($this);
    $this.a1w_1 = x;
    $this.b1w_1 = y;
    $this.c1w_1 = width;
    $this.d1w_1 = height;
    return $this;
  }
  d1i(x, y) {
    // Inline function 'kotlin.math.min' call
    var a = this.p1h();
    var x1 = Math.min(a, x);
    // Inline function 'kotlin.math.max' call
    var a_0 = this.s1h();
    var x2 = Math.max(a_0, x);
    // Inline function 'kotlin.math.min' call
    var a_1 = this.r1h();
    var y1 = Math.min(a_1, y);
    // Inline function 'kotlin.math.max' call
    var a_2 = this.t1h();
    var y2 = Math.max(a_2, y);
    return Double_3.z1h(x1, y1, x2 - x1, y2 - y1);
  }
  e1w(r) {
    var tx1 = this.a1w_1;
    var ty1 = this.b1w_1;
    var rx1 = r.a1w_1;
    var ry1 = r.b1w_1;
    var tx2 = tx1;
    tx2 = tx2 + this.c1w_1 | 0;
    var ty2 = ty1;
    ty2 = ty2 + this.d1w_1 | 0;
    var rx2 = rx1;
    rx2 = rx2 + r.c1w_1 | 0;
    var ry2 = ry1;
    ry2 = ry2 + r.d1w_1 | 0;
    if (tx1 < rx1)
      tx1 = rx1;
    if (ty1 < ry1)
      ty1 = ry1;
    if (tx2 > rx2)
      tx2 = rx2;
    if (ty2 > ry2)
      ty2 = ry2;
    tx2 = tx2 - tx1 | 0;
    ty2 = ty2 - ty1 | 0;
    if (tx2 < -2147483648)
      tx2 = -2147483648;
    if (ty2 < -2147483648)
      ty2 = -2147483648;
    return Rectangle.from(tx1, ty1, tx2, ty2);
  }
  toString() {
    return 'Rectangle{x=' + this.g1h() + ', y=' + this.h1h() + ', width=' + this.gm() + ', height=' + this.hm() + toString(_Char___init__impl__6a9atx(125));
  }
  g1h() {
    return this.a1w_1;
  }
  h1h() {
    return this.b1w_1;
  }
  gm() {
    return this.c1w_1;
  }
  hm() {
    return this.d1w_1;
  }
  j1h(point) {
    return point.h1h() >= this.h1h() && point.h1h() <= this.h1h() + this.hm() && point.g1h() >= this.g1h() && point.g1h() <= this.g1h() + this.gm();
  }
  c1i() {
    if (_get_isNormalized__vs9aom(this))
      return this;
    var normalizedX = this.a1w_1;
    var normalizedY = this.b1w_1;
    var normalizedWidth = this.c1w_1;
    var normalizedHeight = this.d1w_1;
    if (normalizedWidth < 0) {
      normalizedWidth = -normalizedWidth | 0;
      normalizedX = normalizedX - normalizedWidth | 0;
    }
    if (normalizedHeight < 0) {
      normalizedHeight = -normalizedHeight | 0;
      normalizedY = normalizedY - this.d1w_1 | 0;
    }
    return Rectangle.from(normalizedX, normalizedY, normalizedWidth, normalizedHeight);
  }
  e1i(x, y, w, h) {
    return this.l1h(Double_3.z1h(x, y, w, h));
  }
  f1i(x, y) {
    return this.j1h(Double_2.c1l(x, y));
  }
}
class Companion_49 {
  f1w(x1, y1, x2, y2) {
    var x1_0 = x1;
    var y1_0 = y1;
    var x2_0 = x2;
    var y2_0 = y2;
    if (x2_0 < x1_0) {
      var t = x1_0;
      x1_0 = x2_0;
      x2_0 = t;
    }
    if (y2_0 < y1_0) {
      var t_0 = y1_0;
      y1_0 = y2_0;
      y2_0 = t_0;
    }
    return Double_3.z1h(x1_0, y1_0, x2_0 - x1_0, y2_0 - y1_0);
  }
}
class Double_3 extends AbstractRectangle2D {
  static z1h(x, y, width, height) {
    var $this = this.e1h();
    $this.v1h_1 = x;
    $this.w1h_1 = y;
    $this.x1h_1 = width;
    $this.y1h_1 = height;
    return $this;
  }
  g1h() {
    return this.v1h_1;
  }
  h1h() {
    return this.w1h_1;
  }
  gm() {
    return this.x1h_1;
  }
  hm() {
    return this.y1h_1;
  }
  d1i(x, y) {
    // Inline function 'kotlin.math.min' call
    var a = this.p1h();
    var x1 = Math.min(a, x);
    // Inline function 'kotlin.math.max' call
    var a_0 = this.s1h();
    var x2 = Math.max(a_0, x);
    // Inline function 'kotlin.math.min' call
    var a_1 = this.r1h();
    var y1 = Math.min(a_1, y);
    // Inline function 'kotlin.math.max' call
    var a_2 = this.t1h();
    var y2 = Math.max(a_2, y);
    return Double_3.z1h(x1, y1, x2 - x1, y2 - y1);
  }
  toString() {
    return 'Rectangle2D.Double{x=' + this.g1h() + ', y=' + this.h1h() + ', width=' + this.gm() + ', height=' + this.hm() + toString(_Char___init__impl__6a9atx(125));
  }
  c1i() {
    if (_get_isNormalized__vs9aom_0(this))
      return this;
    var normalizedX = this.g1h();
    var normalizedWidth = this.gm();
    if (normalizedWidth < 0) {
      normalizedWidth = -normalizedWidth;
      normalizedX = normalizedX - normalizedWidth;
    }
    var normalizedHeight = this.hm();
    var normalizedY = this.h1h();
    if (normalizedHeight < 0) {
      normalizedHeight = -normalizedHeight;
      normalizedY = normalizedY - normalizedHeight;
    }
    return Double_3.z1h(normalizedX, normalizedY, normalizedWidth, normalizedHeight);
  }
  e1i(x, y, w, h) {
    return this.l1h(Double_3.z1h(x, y, w, h));
  }
  f1i(x, y) {
    return this.j1h(Double_2.c1l(x, y));
  }
}
class Companion_50 {
  constructor() {
    Companion_instance_50 = this;
    this.g1w_1 = 0.7853981633974483;
    var tmp = this;
    // Inline function 'kotlin.math.cos' call
    var x = 0.7853981633974483;
    tmp.h1w_1 = 1.0 - Math.cos(x);
    var tmp_0 = this;
    // Inline function 'kotlin.math.tan' call
    var x_0 = 0.7853981633974483;
    tmp_0.i1w_1 = Math.tan(x_0);
    var tmp_1 = this;
    // Inline function 'kotlin.math.sqrt' call
    var x_1 = 1.0 + this.i1w_1 * this.i1w_1;
    tmp_1.j1w_1 = Math.sqrt(x_1) - 1 + this.h1w_1;
    this.k1w_1 = 4.0 / 3.0 * this.h1w_1 * this.i1w_1 / this.j1w_1;
    this.l1w_1 = (1.0 - this.k1w_1) / 2.0;
    var tmp_2 = this;
    // Inline function 'kotlin.doubleArrayOf' call
    var tmp_3 = new Float64Array([0.0, 0.0, 0.0, 0.5]);
    // Inline function 'kotlin.doubleArrayOf' call
    var tmp_4 = new Float64Array([0.0, 0.0, 1.0, -0.5]);
    // Inline function 'kotlin.doubleArrayOf' call
    var tmp_5 = new Float64Array([0.0, 0.0, 1.0, -this.l1w_1, 0.0, this.l1w_1, 1.0, 0.0, 0.0, 0.5, 1.0, 0.0]);
    // Inline function 'kotlin.doubleArrayOf' call
    var tmp_6 = new Float64Array([1.0, -0.5, 1.0, 0.0]);
    // Inline function 'kotlin.doubleArrayOf' call
    var tmp_7 = new Float64Array([1.0, -this.l1w_1, 1.0, 0.0, 1.0, 0.0, 1.0, -this.l1w_1, 1.0, 0.0, 1.0, -0.5]);
    // Inline function 'kotlin.doubleArrayOf' call
    var tmp_8 = new Float64Array([1.0, 0.0, 0.0, 0.5]);
    // Inline function 'kotlin.doubleArrayOf' call
    var tmp_9 = new Float64Array([1.0, 0.0, 0.0, this.l1w_1, 1.0, -this.l1w_1, 0.0, 0.0, 1.0, -0.5, 0.0, 0.0]);
    // Inline function 'kotlin.doubleArrayOf' call
    var tmp_10 = new Float64Array([0.0, 0.5, 0.0, 0.0]);
    // Inline function 'kotlin.doubleArrayOf' call
    var tmp_11 = new Float64Array([0.0, this.l1w_1, 0.0, 0.0, 0.0, 0.0, 0.0, this.l1w_1, 0.0, 0.0, 0.0, 0.5]);
    // Inline function 'kotlin.doubleArrayOf' call
    // Inline function 'kotlin.arrayOf' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    tmp_2.m1w_1 = [tmp_3, tmp_4, tmp_5, tmp_6, tmp_7, tmp_8, tmp_9, tmp_10, tmp_11, new Float64Array([])];
    var tmp_12 = this;
    // Inline function 'kotlin.intArrayOf' call
    tmp_12.n1w_1 = new Int32Array([0, 1, 3, 1, 3, 1, 3, 1, 3, 4]);
  }
}
class RoundRectIterator {
  constructor(rr, at) {
    Companion_getInstance_50();
    this.v1w_1 = 0;
    this.o1w_1 = rr.g1h();
    this.p1w_1 = rr.h1h();
    this.q1w_1 = rr.gm();
    this.r1w_1 = rr.hm();
    var tmp = this;
    var tmp0 = this.q1w_1;
    // Inline function 'kotlin.math.abs' call
    var x = rr.w1w();
    // Inline function 'kotlin.math.min' call
    var b = Math.abs(x);
    tmp.s1w_1 = Math.min(tmp0, b);
    var tmp_0 = this;
    var tmp0_0 = this.r1w_1;
    // Inline function 'kotlin.math.abs' call
    var x_0 = rr.x1w();
    // Inline function 'kotlin.math.min' call
    var b_0 = Math.abs(x_0);
    tmp_0.t1w_1 = Math.min(tmp0_0, b_0);
    this.u1w_1 = at;
    if (this.s1w_1 < 0 || this.t1w_1 < 0) {
      this.v1w_1 = Companion_getInstance_50().m1w_1.length;
    }
  }
  q1l() {
    return 1;
  }
  m17() {
    return this.v1w_1 >= Companion_getInstance_50().m1w_1.length;
  }
  r1l() {
    this.v1w_1 = this.v1w_1 + 1 | 0;
  }
  s1l(coords) {
    if (this.m17()) {
      throw NoSuchElementException.g1('roundrect iterator out of bounds');
    }
    var ctrls = Companion_getInstance_50().m1w_1[this.v1w_1];
    var nc = 0;
    var i = 0;
    while (i < ctrls.length) {
      var _unary__edvuaz = nc;
      nc = _unary__edvuaz + 1 | 0;
      coords[_unary__edvuaz] = this.o1w_1 + ctrls[i + 0 | 0] * this.q1w_1 + ctrls[i + 1 | 0] * this.s1w_1;
      var _unary__edvuaz_0 = nc;
      nc = _unary__edvuaz_0 + 1 | 0;
      coords[_unary__edvuaz_0] = this.p1w_1 + ctrls[i + 2 | 0] * this.r1w_1 + ctrls[i + 3 | 0] * this.t1w_1;
      i = i + 4 | 0;
    }
    var tmp0_safe_receiver = this.u1w_1;
    if (tmp0_safe_receiver == null)
      null;
    else {
      tmp0_safe_receiver.b1k(coords, 0, coords, 0, nc / 2 | 0);
    }
    return Companion_getInstance_50().n1w_1[this.v1w_1];
  }
}
class RoundRectangle2D extends AbstractRectangle2D {
  static f1x() {
    return this.e1h();
  }
  e1i(x, y, w, h) {
    var x_0 = x;
    var y_0 = y;
    if (this.v1k() || w <= 0 || h <= 0) {
      return false;
    }
    var rrx0 = x_0;
    var rry0 = y_0;
    var rrx1 = rrx0 + this.gm();
    var rry1 = rry0 + this.hm();
    if (x_0 + w <= rrx0 || x_0 >= rrx1 || y_0 + h <= rry0 || y_0 >= rry1) {
      return false;
    }
    var tmp0 = this.gm();
    // Inline function 'kotlin.math.abs' call
    var x_1 = this.w1w();
    // Inline function 'kotlin.math.min' call
    var b = Math.abs(x_1);
    var aw = Math.min(tmp0, b) / 2.0;
    var tmp0_0 = this.hm();
    // Inline function 'kotlin.math.abs' call
    var x_2 = this.x1w();
    // Inline function 'kotlin.math.min' call
    var b_0 = Math.abs(x_2);
    var ah = Math.min(tmp0_0, b_0) / 2.0;
    var x0class = classify(this, x_0, rrx0, rrx1, aw);
    var x1class = classify(this, x_0 + w, rrx0, rrx1, aw);
    var y0class = classify(this, y_0, rry0, rry1, ah);
    var y1class = classify(this, y_0 + h, rry0, rry1, ah);
    if (x0class === 2 || x1class === 2 || y0class === 2 || y1class === 2) {
      return true;
    }
    if (x0class < 2 && x1class > 2 || (y0class < 2 && y1class > 2)) {
      return true;
    }
    x_0 = x1class === 1 ? x_0 + w - (rrx0 + aw) : x_0 - (rrx1 - aw);
    y_0 = y1class === 1 ? y_0 + h - (rry0 + ah) : y_0 - (rry1 - ah);
    x_0 = x_0 / aw;
    y_0 = y_0 / ah;
    return x_0 * x_0 + y_0 * y_0 <= 1.0;
  }
  f1i(x, y) {
    var x_0 = x;
    var y_0 = y;
    if (this.v1k()) {
      return false;
    }
    var rrx0 = x_0;
    var rry0 = y_0;
    var rrx1 = rrx0 + this.gm();
    var rry1 = rry0 + this.hm();
    if (x_0 < rrx0 || y_0 < rry0 || x_0 >= rrx1 || y_0 >= rry1) {
      return false;
    }
    var tmp0 = this.gm();
    // Inline function 'kotlin.math.absoluteValue' call
    var this_0 = this.w1w();
    // Inline function 'kotlin.math.min' call
    var b = Math.abs(this_0);
    var aw = Math.min(tmp0, b) / 2.0;
    var tmp0_0 = this.hm();
    // Inline function 'kotlin.math.absoluteValue' call
    var this_1 = this.x1w();
    // Inline function 'kotlin.math.min' call
    var b_0 = Math.abs(this_1);
    var ah = Math.min(tmp0_0, b_0) / 2.0;
    var tmp;
    var tmp_0 = x_0;
    // Inline function 'kotlin.let' call
    rrx0 = rrx0 + aw;
    if (tmp_0 >= rrx0) {
      var tmp_1 = x_0;
      // Inline function 'kotlin.also' call
      rrx0 = aw;
      tmp = tmp_1 < rrx1 - aw;
    } else {
      tmp = false;
    }
    if (tmp) {
      return true;
    }
    var tmp_2;
    var tmp_3 = y_0;
    // Inline function 'kotlin.let' call
    rry0 = rry0 + ah;
    if (tmp_3 >= rry0) {
      var tmp_4 = y_0;
      // Inline function 'kotlin.also' call
      rry0 = ah;
      tmp_2 = tmp_4 < rry1 - ah;
    } else {
      tmp_2 = false;
    }
    if (tmp_2) {
      return true;
    }
    x_0 = (x_0 - rrx0) / aw;
    y_0 = (y_0 - rry0) / ah;
    return x_0 * x_0 + y_0 * y_0 <= 1.0;
  }
  o1h(at) {
    return new RoundRectIterator(this, at);
  }
  hashCode() {
    var bits = toRawBits(this.g1h());
    var tmp = bits;
    // Inline function 'kotlin.Long.times' call
    var this_0 = toRawBits(this.h1h());
    var tmp$ret$0 = multiply_0(this_0, fromInt_0(37));
    bits = add_0(tmp, tmp$ret$0);
    var tmp_0 = bits;
    // Inline function 'kotlin.Long.times' call
    var this_1 = toRawBits(this.gm());
    var tmp$ret$1 = multiply_0(this_1, fromInt_0(43));
    bits = add_0(tmp_0, tmp$ret$1);
    var tmp_1 = bits;
    // Inline function 'kotlin.Long.times' call
    var this_2 = toRawBits(this.hm());
    var tmp$ret$2 = multiply_0(this_2, fromInt_0(47));
    bits = add_0(tmp_1, tmp$ret$2);
    var tmp_2 = bits;
    // Inline function 'kotlin.Long.times' call
    var this_3 = toRawBits(this.w1w());
    var tmp$ret$3 = multiply_0(this_3, fromInt_0(53));
    bits = add_0(tmp_2, tmp$ret$3);
    var tmp_3 = bits;
    // Inline function 'kotlin.Long.times' call
    var this_4 = toRawBits(this.x1w());
    var tmp$ret$4 = multiply_0(this_4, fromInt_0(59));
    bits = add_0(tmp_3, tmp$ret$4);
    return convertToInt(bits) ^ convertToInt(shiftRight(bits, 32));
  }
  equals(other) {
    if (other === this) {
      return true;
    }
    if (other instanceof RoundRectangle2D) {
      return this.g1h() === other.g1h() && this.h1h() === other.h1h() && this.gm() === other.gm() && this.hm() === other.hm() && this.w1w() === other.w1w() && this.x1w() === other.x1w();
    }
    return false;
  }
}
class Double_4 extends RoundRectangle2D {
  g1h() {
    return this.y1w_1;
  }
  h1h() {
    return this.z1w_1;
  }
  gm() {
    return this.a1x_1;
  }
  hm() {
    return this.b1x_1;
  }
  w1w() {
    return this.c1x_1;
  }
  x1w() {
    return this.d1x_1;
  }
  static e1x() {
    var $this = this.f1x();
    init_org_mkui_geom_RoundRectangle2D_Double($this);
    return $this;
  }
  static g1x(x, y, w, h, arcw, arch) {
    var $this = this.f1x();
    init_org_mkui_geom_RoundRectangle2D_Double($this);
    $this.h1x(x, y, w, h, arcw, arch);
    return $this;
  }
  d1i(x, y) {
    // Inline function 'kotlin.math.min' call
    var a = this.p1h();
    var x1 = Math.min(a, x);
    // Inline function 'kotlin.math.max' call
    var a_0 = this.s1h();
    var x2 = Math.max(a_0, x);
    // Inline function 'kotlin.math.min' call
    var a_1 = this.r1h();
    var y1 = Math.min(a_1, y);
    // Inline function 'kotlin.math.max' call
    var a_2 = this.t1h();
    var y2 = Math.max(a_2, y);
    return Double_4.g1x(x1, y1, x2 - x1, y2 - y1, this.c1x_1, this.d1x_1);
  }
  c1i() {
    if (_get_isNormalized__vs9aom_1(this))
      return this;
    var normalizedX = this.y1w_1;
    var normalizedY = this.z1w_1;
    var normalizedWidth = this.a1x_1;
    var normalizedHeight = this.b1x_1;
    if (normalizedWidth < 0) {
      normalizedWidth = -normalizedWidth;
      normalizedX = normalizedX - normalizedWidth;
    }
    if (normalizedHeight < 0) {
      normalizedHeight = -normalizedHeight;
      normalizedY = normalizedY - normalizedHeight;
    }
    return Double_4.g1x(normalizedX, normalizedY, normalizedWidth, normalizedHeight, this.c1x_1, this.d1x_1);
  }
  h1x(x, y, w, h, arcWidth, arcHeight) {
    this.y1w_1 = x;
    this.z1w_1 = y;
    this.a1x_1 = w;
    this.b1x_1 = h;
    this.c1x_1 = arcWidth;
    this.d1x_1 = arcHeight;
  }
  v1k() {
    return this.a1x_1 <= 0.0 || this.b1x_1 <= 0.0;
  }
}
class ScreenTransformHelper {
  i1x(xModel, yModel) {
    var tmp;
    if (yModel.f16()) {
      var xs = xModel.x15() / xModel.e16();
      var ys = yModel.x15() / yModel.e16();
      var at = AffineTransform.j1j();
      at.n1j(xs, ys);
      at.o1j(-xModel.d16(), -yModel.d16());
      tmp = at;
    } else {
      var xs_0 = xModel.x15() / xModel.e16();
      var ys_0 = yModel.x15() / yModel.e16();
      var tx = -xModel.d16() * xs_0;
      var ty = yModel.d16() * ys_0 + yModel.x15();
      tmp = AffineTransform.m1j(xs_0, 0.0, 0.0, -ys_0, tx, ty);
    }
    return tmp;
  }
}
class TextShape {
  m1x() {
    return true;
  }
  i1h() {
    return this.k1x_1.i1h();
  }
  n1x(at) {
    throw NotImplementedError.ui();
  }
}
class Companion_51 {}
class AbstractIGraphics {
  constructor() {
    this.o1x_1 = null;
    this.p1x_1 = null;
  }
}
class Insets {
  constructor(top, left, bottom, right) {
    this.t1x_1 = 0;
    this.u1x_1 = 0;
    this.v1x_1 = 0;
    this.w1x_1 = 0;
    this.t1x_1 = top;
    this.u1x_1 = left;
    this.v1x_1 = bottom;
    this.w1x_1 = right;
  }
}
class Companion_52 {
  constructor() {
    Companion_instance_52 = this;
    this.x1x_1 = 0.5;
    this.y1x_1 = listOf_0([Off_getInstance(), Brightness_getInstance(), BlackWhite_getInstance(), Complement_getInstance()]);
  }
}
class ContrastEnhancement {
  constructor() {
    Companion_getInstance_52();
  }
}
class Off extends ContrastEnhancement {
  constructor() {
    Off_instance = null;
    super();
    Off_instance = this;
  }
  z1x(foreground, background) {
    return foreground;
  }
}
class Brightness extends ContrastEnhancement {
  constructor() {
    Brightness_instance = null;
    super();
    Brightness_instance = this;
  }
  z1x(foreground, background) {
    var foreground_0 = foreground;
    var diff_0 = diff(foreground_0, background);
    var tmp;
    if (diff_0 <= 0.5) {
      var foregroundBrightness = brightness(foreground_0);
      var tmp_0 = foreground_0;
      // Inline function 'kotlin.math.min' call
      var b = foregroundBrightness + (0.5 - diff_0);
      var tmp$ret$0 = Math.min(1.0, b);
      var brighterForeground = replaceBrightness(tmp_0, tmp$ret$0);
      var tmp_1 = foreground_0;
      // Inline function 'kotlin.math.max' call
      var b_0 = foregroundBrightness - (0.5 - diff_0);
      var tmp$ret$1 = Math.max(0.0, b_0);
      var darkerForeground = replaceBrightness(tmp_1, tmp$ret$1);
      var backgroundLuminance = luminance(background);
      // Inline function 'kotlin.math.abs' call
      var x = luminance(brighterForeground) - backgroundLuminance;
      var brighterDiff = Math.abs(x);
      // Inline function 'kotlin.math.abs' call
      var x_0 = luminance(darkerForeground) - backgroundLuminance;
      var darkerDiff = Math.abs(x_0);
      var tmp_2;
      if (brighterDiff > darkerDiff) {
        tmp_2 = brighterForeground;
      } else {
        tmp_2 = darkerForeground;
      }
      foreground_0 = tmp_2;
      tmp = foreground_0;
    } else {
      tmp = foreground_0;
    }
    return tmp;
  }
}
class BlackWhite extends ContrastEnhancement {
  constructor() {
    BlackWhite_instance = null;
    super();
    BlackWhite_instance = this;
  }
  z1x(foreground, background) {
    var diff_0 = diff(foreground, background);
    var tmp;
    if (diff_0 <= 0.5) {
      var backgroundLuminance = lum(background);
      tmp = backgroundLuminance >= 186 ? get_Black() : get_White();
    } else {
      tmp = foreground;
    }
    return tmp;
  }
  toString() {
    return 'Black&White';
  }
}
class Complement extends ContrastEnhancement {
  constructor() {
    Complement_instance = null;
    super();
    Complement_instance = this;
  }
  z1x(foreground, background) {
    var foreground_0 = foreground;
    var diff_0 = diff(foreground_0, background);
    var tmp;
    if (diff_0 <= 0.5) {
      var alpha = getUAlpha(foreground_0);
      var red = getURed(foreground_0);
      var blue = getUBlue(foreground_0);
      var green = getUBlue(foreground_0);
      // Inline function 'kotlin.UByte.inv' call
      var this_0 = red;
      // Inline function 'kotlin.experimental.inv' call
      var this_1 = _UByte___get_data__impl__jof9qr(this_0);
      var tmp$ret$0 = toByte(~this_1);
      red = _UByte___init__impl__g9hnc4(tmp$ret$0);
      // Inline function 'kotlin.UByte.inv' call
      var this_2 = blue;
      // Inline function 'kotlin.experimental.inv' call
      var this_3 = _UByte___get_data__impl__jof9qr(this_2);
      var tmp$ret$2 = toByte(~this_3);
      blue = _UByte___init__impl__g9hnc4(tmp$ret$2);
      // Inline function 'kotlin.UByte.inv' call
      var this_4 = green;
      // Inline function 'kotlin.experimental.inv' call
      var this_5 = _UByte___get_data__impl__jof9qr(this_4);
      var tmp$ret$4 = toByte(~this_5);
      green = _UByte___init__impl__g9hnc4(tmp$ret$4);
      var complement = colorOf_0(red, green, blue, alpha);
      var backgroundLuminance = luminance(background);
      // Inline function 'kotlin.math.abs' call
      var x = luminance(foreground_0) - backgroundLuminance;
      var brighterDiff = Math.abs(x);
      // Inline function 'kotlin.math.abs' call
      var x_0 = luminance(complement) - backgroundLuminance;
      var darkerDiff = Math.abs(x_0);
      var tmp_0;
      if (brighterDiff > darkerDiff) {
        tmp_0 = foreground_0;
      } else {
        tmp_0 = complement;
      }
      foreground_0 = tmp_0;
      tmp = foreground_0;
    } else {
      tmp = foreground_0;
    }
    return tmp;
  }
}
class Effect {}
class Plain extends Effect {
  constructor() {
    Plain_instance = null;
    super();
    Plain_instance = this;
  }
}
class Shadow extends Effect {
  constructor() {
    Shadow_instance = null;
    super();
    Shadow_instance = this;
  }
}
class Glow extends Effect {
  constructor() {
    Glow_instance = null;
    super();
    Glow_instance = this;
  }
}
class Outline extends Effect {
  constructor() {
    Outline_instance = null;
    super();
    Outline_instance = this;
  }
}
class Emphasize extends Effect {
  constructor() {
    Emphasize_instance = null;
    super();
    Emphasize_instance = this;
  }
}
class Rendering extends Enum {
  get name() {
    return this.h3();
  }
  get ordinal() {
    return this.i3();
  }
}
class Companion_53 {
  constructor() {
    this.CENTER = 0;
    this.TOP = 1;
    this.LEFT = 2;
    this.BOTTOM = 3;
    this.RIGHT = 4;
    this.HORIZONTAL = 0;
    this.VERTICAL = 1;
    this.LEADING = 10;
    this.TRAILING = 11;
    this.NEXT = 12;
  }
  c1y() {
    return this.CENTER;
  }
  d1y() {
    return this.TOP;
  }
  e1y() {
    return this.LEFT;
  }
  f1y() {
    return this.BOTTOM;
  }
  g1y() {
    return this.RIGHT;
  }
  h1y() {
    return this.HORIZONTAL;
  }
  i1y() {
    return this.VERTICAL;
  }
  j1y() {
    return this.LEADING;
  }
  k1y() {
    return this.TRAILING;
  }
  l1y() {
    return this.NEXT;
  }
}
class EnhancedLabel {
  constructor() {
    return new.target.j1z();
  }
  static j1z() {
    var $this = createThis(this);
    $this.isOpaque = false;
    $this.properties = new SimpleProperties();
    $this.m1y_1 = $this.properties.bz('rendering', Rendering_Clip_getInstance());
    $this.n1y_1 = $this.properties.bz('justified', false);
    $this.o1y_1 = $this.properties.bz('effect', Plain_getInstance());
    $this.p1y_1 = $this.properties.bz('effectOpacity', 110.0 / 255.0);
    $this.q1y_1 = $this.properties.bz('minimumCharactersToDisplay', null);
    $this.r1y_1 = $this.properties.bz('angle', 0.0);
    $this.s1y_1 = $this.properties.bz('desiredWidth', 2147483647);
    $this.t1y_1 = $this.properties.bz('desiredHeight', 2147483647);
    $this.u1y_1 = $this.properties.bz('text', null);
    $this.v1y_1 = $this.properties.bz('html', false);
    $this.w1y_1 = $this.properties.bz('font', Companion_getInstance_57().k1z_1.l1z());
    $this.x1y_1 = $this.properties.bz('verticalAlignment', 0);
    $this.y1y_1 = $this.properties.bz('horizontalAlignment', 10);
    $this.z1y_1 = $this.properties.bz('width', null);
    $this.a1z_1 = $this.properties.bz('height', null);
    $this.b1z_1 = $this.properties.bz('insetTop', 0);
    $this.c1z_1 = $this.properties.bz('insetLeft', 0);
    $this.d1z_1 = $this.properties.bz('insetBottom', 0);
    $this.e1z_1 = $this.properties.bz('insetRight', 0);
    $this.f1z_1 = $this.properties.bz('background', null);
    $this.g1z_1 = $this.properties.bz('foreground', null);
    $this.h1z_1 = $this.properties.bz('enabled', true);
    $this.i1z_1 = $this.properties.bz('name', null);
    $this.setVerticalAlignment(1);
    return $this;
  }
  m1z(_set____db54di) {
    this.isOpaque = _set____db54di;
  }
  n1z() {
    return this.isOpaque;
  }
  o1z(_set____db54di) {
    this.properties = _set____db54di;
  }
  p1z() {
    return this.properties;
  }
  static fromString(text) {
    var $this = this.j1z();
    $this.setText(text);
    return $this;
  }
  setName(name) {
    this.i1z_1.ap(name);
  }
  getName() {
    return this.i1z_1.z2();
  }
  getText() {
    return this.u1y_1.z2();
  }
  setText(text) {
    this.u1y_1.ap(text);
  }
  q1z(html) {
    this.v1y_1.ap(html);
  }
  r1z() {
    return this.v1y_1.z2();
  }
  getFont() {
    return this.w1y_1.z2();
  }
  setFont(font) {
    this.w1y_1.ap(font);
  }
  getVerticalAlignment() {
    return this.x1y_1.z2();
  }
  setVerticalAlignment(verticalAlignment) {
    this.x1y_1.ap(verticalAlignment);
  }
  getHorizontalAlignment() {
    return this.y1y_1.z2();
  }
  setHorizontalAlignment(horizontalAlignment) {
    this.y1y_1.ap(horizontalAlignment);
  }
  getHeight() {
    return this.a1z_1.z2();
  }
  getWidth() {
    return this.z1y_1.z2();
  }
  getBackground() {
    return this.f1z_1.z2();
  }
  setBackground(background) {
    this.f1z_1.ap(background);
  }
  getForeground() {
    return this.g1z_1.z2();
  }
  setForeground(foreground) {
    this.g1z_1.ap(foreground);
  }
  isEnabled() {
    return this.h1z_1.z2();
  }
  getInsetTop() {
    return this.b1z_1.z2();
  }
  getInsetLeft() {
    return this.c1z_1.z2();
  }
  getInsetBottom() {
    return this.d1z_1.z2();
  }
  getInsetRight() {
    return this.e1z_1.z2();
  }
  setInsetTop(value) {
    this.b1z_1.ap(value);
  }
  setInsetLeft(value) {
    this.c1z_1.ap(value);
  }
  setInsetBottom(value) {
    this.d1z_1.ap(value);
  }
  setInsetRight(value) {
    this.e1z_1.ap(value);
  }
  setInsets(top, left, bottom, right) {
    this.b1z_1.ap(top);
    this.c1z_1.ap(left);
    this.d1z_1.ap(bottom);
    this.e1z_1.ap(right);
  }
  getEffect() {
    return this.o1y_1.z2();
  }
  setEffect(effect) {
    this.o1y_1.ap(effect);
  }
  getEffectOpacity() {
    return this.p1y_1.z2();
  }
  setEffectOpacity(effectOpacity) {
    this.p1y_1.ap(effectOpacity);
  }
  getRendering() {
    return this.m1y_1.z2();
  }
  setRendering(rendering) {
    this.m1y_1.ap(rendering);
  }
  getMinimumCharactersToDisplay() {
    return this.q1y_1.z2();
  }
  setMinimumCharactersToDisplay(minimumCharactersToDisplay) {
    this.q1y_1.ap(minimumCharactersToDisplay);
  }
  isJustified() {
    return this.n1y_1.z2();
  }
  setJustified(justified) {
    this.n1y_1.ap(justified);
  }
  getAngle() {
    return this.r1y_1.z2();
  }
  setAngle(angle) {
    this.r1y_1.ap(angle);
  }
  getDesiredWidth() {
    return this.s1y_1.z2();
  }
  setDesiredWidth(desiredSize) {
    this.s1y_1.ap(desiredSize);
  }
  getDesiredHeight() {
    return this.t1y_1.z2();
  }
  setDesiredHeight(desiredSize) {
    this.t1y_1.ap(desiredSize);
  }
  get isHTML() {
    return this.r1z();
  }
  set isHTML(value) {
    this.q1z(value);
  }
}
class AbstractPalette {
  static z1z() {
    var $this = createThis(this);
    $this.x1z_1 = 0;
    $this.y1z_1 = Cycle_NONE_getInstance();
    return $this;
  }
  u1d(_set____db54di) {
    this.x1z_1 = _set____db54di;
  }
  a1b() {
    return this.x1z_1;
  }
  a20() {
    return this.y1z_1;
  }
  c20(fraction, colorCount, paletteSize) {
    var entry = round(fraction * (colorCount - 1 | 0));
    var f = entry / (colorCount - 1 | 0);
    var tmp0 = colorCount - 1 | 0;
    // Inline function 'kotlin.math.max' call
    var b = numberToInt(round(f * (paletteSize - 1 | 0)));
    // Inline function 'kotlin.math.min' call
    var b_0 = Math.max(0, b);
    return Math.min(tmp0, b_0);
  }
}
class MutablePalette {}
class AbstractMutablePalette extends AbstractPalette {
  static w1z() {
    var $this = this.z1z();
    $this.u1z_1 = CollectionFactory_instance.nk();
    $this.v1z_1 = protoOf(AbstractPalette).a20.call($this);
    return $this;
  }
  a20() {
    return this.v1z_1;
  }
  c1e(listener) {
    this.u1z_1.c1(listener);
  }
  b1e(listener) {
    var toRemove = null;
    var _iterator__ex2g4s = this.u1z_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var PaletteListener = _iterator__ex2g4s.j1();
      var comparable;
      comparable = PaletteListener;
      if (equals(listener, comparable)) {
        toRemove = PaletteListener;
      }
    }
    if (!(toRemove == null)) {
      var removed = this.u1z_1.e3(toRemove);
    }
  }
  b20(event) {
    var _iterator__ex2g4s = this.u1z_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var listener = _iterator__ex2g4s.j1();
      listener.z1d(event);
    }
  }
}
class Mode extends Enum {}
class Entry_0 {
  constructor(fraction, color) {
    this.t1f_1 = fraction;
    this.u1f_1 = color;
  }
  j20() {
    return this.u1f_1;
  }
  k20(other) {
    return compareTo(this.t1f_1, other.t1f_1);
  }
  d(other) {
    return this.k20(other instanceof Entry_0 ? other : THROW_CCE());
  }
  equals(other) {
    if (this === other)
      return true;
    if (other == null || !getKClassFromExpression(this).equals(getKClassFromExpression(other)))
      return false;
    if (!(other instanceof Entry_0))
      THROW_CCE();
    if (!(this.t1f_1 === other.t1f_1))
      return false;
    return true;
  }
  hashCode() {
    return getNumberHashCode(this.t1f_1);
  }
}
class sam$kotlin_Comparator$0_1 {
  constructor(function_0) {
    this.l20_1 = function_0;
  }
  he(a, b) {
    return this.l20_1(a, b);
  }
  compare(a, b) {
    return this.he(a, b);
  }
  k3() {
    return this.l20_1;
  }
  equals(other) {
    var tmp;
    if (!(other == null) ? isInterface(other, Comparator) : false) {
      var tmp_0;
      if (!(other == null) ? isInterface(other, FunctionAdapter) : false) {
        tmp_0 = equals(this.k3(), other.k3());
      } else {
        tmp_0 = false;
      }
      tmp = tmp_0;
    } else {
      tmp = false;
    }
    return tmp;
  }
  hashCode() {
    return hashCode(this.k3());
  }
}
class CustomPalette$1 {
  constructor(this$0) {
    this.m20_1 = this$0;
  }
  n20(event) {
    this.m20_1.b20(new PaletteEvent());
    updateFixedColorGradient(this.m20_1);
  }
  vo(event) {
    return this.n20(event);
  }
}
class DynamicPalette extends AbstractMutablePalette {
  static p20(colors) {
    var $this = this.w1z();
    init_org_mkui_palette_DynamicPalette($this);
    $this.h20_1 = toMutableList(colors);
    $this.u1d($this.h20_1.k1());
    return $this;
  }
  n1c(fraction) {
    var fraction_0 = fraction;
    var inverted = this.i20_1;
    var tmp0_subject = this.a20();
    switch (tmp0_subject == null ? -1 : tmp0_subject.g3_1) {
      case 2:
        inverted = (numberToInt(fraction_0) % 2 | 0) === 0;
        fraction_0 = fraction_0 - numberToInt(fraction_0);
        break;
      case 1:
        fraction_0 = fraction_0 - numberToInt(fraction_0);
        break;
      default:
        break;
    }
    var tmp;
    if (fraction_0 < this.r1f()) {
      tmp = this.n1c(this.r1f());
    } else if (fraction_0 > this.q1f()) {
      tmp = this.n1c(this.q1f());
    } else {
      var index = this.c20(!inverted ? fraction_0 : 1 - fraction_0, this.a1b(), this.h20_1.k1());
      tmp = this.h20_1.l1(index);
    }
    return tmp;
  }
  r1f() {
    return 0.0;
  }
  q1f() {
    return 1.0;
  }
  p1f(fraction) {
    var tmp;
    if (this.a1b() === this.h20_1.k1()) {
      var tmp_0;
      if (fraction < 0) {
        tmp_0 = this.p1f(0);
      } else if (fraction > (this.a1b() - 1 | 0)) {
        tmp_0 = this.p1f(this.a1b() - 1 | 0);
      } else {
        tmp_0 = this.h20_1.l1(fraction);
      }
      tmp = tmp_0;
    } else {
      tmp = this.n1c(this.a1b() / fraction);
    }
    return tmp;
  }
}
class CustomPalette extends DynamicPalette {
  static o20(entries) {
    var $this = this.p20([]);
    $this.y1b_1 = new SimpleProperty(Mode_Ramps_getInstance());
    $this.z1b_1 = entries;
    $this.y1b_1.zo(new CustomPalette$1($this));
    return $this;
  }
  static a1c(entries) {
    // Inline function 'kotlin.comparisons.compareBy' call
    var tmp = CustomPalette$_init_$lambda_rc1wld;
    var tmp$ret$0 = new sam$kotlin_Comparator$0_1(tmp);
    var $this = this.o20(SortedSet.wj(tmp$ret$0, asList(entries)));
    updateFixedColorGradient($this);
    return $this;
  }
  s1f() {
    return this.z1b_1;
  }
  r1f() {
    var tmp;
    if (!this.z1b_1.p1()) {
      tmp = first(this.z1b_1).t1f_1;
    } else {
      tmp = super.r1f();
    }
    return tmp;
  }
  q1f() {
    var tmp;
    if (!this.z1b_1.p1()) {
      tmp = last(this.z1b_1).t1f_1;
    } else {
      tmp = super.q1f();
    }
    return tmp;
  }
}
class Cycle extends Enum {}
class Companion_54 {}
class FixedPalette extends AbstractPalette {
  static u20(isInverted, colors) {
    var $this = this.z1z();
    $this.s20_1 = isInverted;
    $this.t20_1 = colors;
    $this.u1d(!($this.t20_1 == null) ? $this.t20_1.k1() : 0);
    return $this;
  }
  t1d(_set____db54di) {
    this.s20_1 = _set____db54di;
  }
  fn() {
    return this.s20_1;
  }
  v20(_set____db54di) {
    this.t20_1 = _set____db54di;
  }
  w20() {
    return this.t20_1;
  }
  static x20(colors) {
    return this.y20(false, colors.slice());
  }
  static y20(inverted, colors) {
    return this.u20(false, toCPColorList(Companion_instance_54, colors));
  }
  static z20(colors) {
    return this.u20(false, toMutableList(colors));
  }
  n1c(fraction) {
    var fraction_0 = fraction;
    var inverted = this.fn();
    var tmp0_subject = this.a20();
    switch (tmp0_subject == null ? -1 : tmp0_subject.g3_1) {
      case 2:
        inverted = (numberToInt(fraction_0) % 2 | 0) === 0;
        fraction_0 = fraction_0 - numberToInt(fraction_0);
        break;
      case 1:
        fraction_0 = fraction_0 - numberToInt(fraction_0);
        break;
      default:
        break;
    }
    var tmp;
    if (fraction_0 < this.r1f()) {
      tmp = this.n1c(this.r1f());
    } else if (fraction_0 > this.q1f()) {
      tmp = this.n1c(this.q1f());
    } else {
      var index = this.c20(!inverted ? fraction_0 : 1 - fraction_0, this.a1b(), this.t20_1.k1());
      tmp = this.t20_1.l1(index);
    }
    return tmp;
  }
  r1f() {
    return 0.0;
  }
  q1f() {
    return 1.0;
  }
  p1f(fraction) {
    var tmp;
    if (this.a1b() === this.t20_1.k1()) {
      var tmp_0;
      if (fraction < 0) {
        tmp_0 = this.p1f(0);
      } else if (fraction > (this.a1b() - 1 | 0)) {
        tmp_0 = this.p1f(this.a1b() - 1 | 0);
      } else {
        tmp_0 = this.t20_1.l1(fraction);
      }
      tmp = tmp_0;
    } else {
      tmp = this.n1c(this.a1b() / fraction);
    }
    return tmp;
  }
  c1e(listener) {
  }
  b1e(listener) {
  }
  a21(value) {
    throw UnsupportedOperationException.q3();
  }
  a20() {
    return super.a20();
  }
  toString() {
    return toString_1(this.n1c(0.0)) + '-' + toString_1(this.n1c(1.0));
  }
}
class Mode_0 extends Enum {}
class Entry_1 {
  constructor(fraction, color) {
    this.fraction = fraction;
    this.v1f_1 = color;
  }
  g21() {
    return this.fraction;
  }
  getColor() {
    return this.v1f_1;
  }
  h21(other) {
    return compareTo(this.fraction, other.fraction);
  }
  d(other) {
    return this.h21(other instanceof Entry_1 ? other : THROW_CCE());
  }
  equals(other) {
    if (this === other)
      return true;
    if (other == null || !getKClassFromExpression(this).equals(getKClassFromExpression(other)))
      return false;
    if (!(other instanceof Entry_1))
      THROW_CCE();
    if (!(this.fraction === other.fraction))
      return false;
    return true;
  }
  hashCode() {
    return getNumberHashCode(this.fraction);
  }
}
class sam$kotlin_Comparator$0_2 {
  constructor(function_0) {
    this.i21_1 = function_0;
  }
  he(a, b) {
    return this.i21_1(a, b);
  }
  compare(a, b) {
    return this.he(a, b);
  }
  k3() {
    return this.i21_1;
  }
  equals(other) {
    var tmp;
    if (!(other == null) ? isInterface(other, Comparator) : false) {
      var tmp_0;
      if (!(other == null) ? isInterface(other, FunctionAdapter) : false) {
        tmp_0 = equals(this.k3(), other.k3());
      } else {
        tmp_0 = false;
      }
      tmp = tmp_0;
    } else {
      tmp = false;
    }
    return tmp;
  }
  hashCode() {
    return hashCode(this.k3());
  }
}
class sam$kotlin_Comparator$0_3 {
  constructor(function_0) {
    this.j21_1 = function_0;
  }
  he(a, b) {
    return this.j21_1(a, b);
  }
  compare(a, b) {
    return this.he(a, b);
  }
  k3() {
    return this.j21_1;
  }
  equals(other) {
    var tmp;
    if (!(other == null) ? isInterface(other, Comparator) : false) {
      var tmp_0;
      if (!(other == null) ? isInterface(other, FunctionAdapter) : false) {
        tmp_0 = equals(this.k3(), other.k3());
      } else {
        tmp_0 = false;
      }
      tmp = tmp_0;
    } else {
      tmp = false;
    }
    return tmp;
  }
  hashCode() {
    return hashCode(this.k3());
  }
}
class InterpolatedPalette extends FixedPalette {
  constructor(entries) {
    return new.target.k21(entries);
  }
  static k21(entries) {
    var $this = this.u20(false, emptyList());
    $this.entries = entries;
    $this.f21_1 = new SimpleProperty(Mode_Ramps_getInstance_0());
    updateFixedColorGradient_0($this);
    return $this;
  }
  l21(_set____db54di) {
    this.entries = _set____db54di;
  }
  d3() {
    return this.entries;
  }
  static paletteConstructor(p) {
    // Inline function 'kotlin.comparisons.compareBy' call
    var tmp = InterpolatedPalette$_init_$lambda_qt4r8t;
    var tmp$ret$0 = new sam$kotlin_Comparator$0_2(tmp);
    var $this = this.k21(SortedSet.wj(tmp$ret$0));
    var inductionVariable = 0;
    var last = p.a1b();
    if (inductionVariable < last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        var c = p.p1f(i);
        $this.entries.c1(new Entry_1(i / (p.a1b() - 1 | 0), c));
      }
       while (inductionVariable < last);
    updateFixedColorGradient_0($this);
    return $this;
  }
  static entriesConstructor(e) {
    // Inline function 'kotlin.comparisons.compareBy' call
    var tmp = InterpolatedPalette$_init_$lambda_qt4r8t_0;
    var tmp$ret$0 = new sam$kotlin_Comparator$0_3(tmp);
    var $this = this.k21(SortedSet.wj(tmp$ret$0, asList(e)));
    updateFixedColorGradient_0($this);
    return $this;
  }
  getEntries() {
    return this.entries;
  }
  r1f() {
    var tmp;
    if (!this.entries.p1()) {
      tmp = first(this.entries).fraction;
    } else {
      tmp = super.r1f();
    }
    return tmp;
  }
  q1f() {
    var tmp;
    if (!this.entries.p1()) {
      tmp = last(this.entries).fraction;
    } else {
      tmp = super.q1f();
    }
    return tmp;
  }
}
class PaletteEvent {}
class Entry_2 {
  constructor(name, type, colors) {
    this.name = name;
    this.type = type;
    this.m21_1 = colors;
  }
  h3() {
    return this.name;
  }
  n21() {
    return this.type;
  }
  getPalette() {
    return this.m21_1;
  }
}
class Companion_55 {
  constructor() {
    Companion_instance_55 = this;
    this.instance = new PaletteFactory();
  }
  o21() {
    return this.instance;
  }
}
class PaletteFactory {
  constructor() {
    Companion_getInstance_55();
    this.v23_1 = ArrayList.q1();
    this.p21_1 = new Entry_2('negpos', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.entriesConstructor([new Entry_1(0.0, colorOf_1(255, 0, 0)), new Entry_1(0.498, colorOf_1(255, 230, 230)), new Entry_1(0.4981, colorOf_1(255, 255, 255)), new Entry_1(0.502, colorOf_1(255, 255, 255)), new Entry_1(0.5021, colorOf_1(230, 255, 230)), new Entry_1(1.0, colorOf_1(0, 128, 0))]));
    this.q21_1 = new Entry_2('treemapper', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.entriesConstructor([new Entry_1(0.0, colorOf_1(255, 0, 0)), new Entry_1(0.5, colorOf_1(255, 255, 255)), new Entry_1(1.0, colorOf_1(0, 128, 0))]));
    this.r21_1 = new Entry_2('composite', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.entriesConstructor([new Entry_1(0.0, colorOf_1(255, 0, 0)), new Entry_1(0.19327731092437, colorOf_1(247, 52, 0)), new Entry_1(0.428571428571429, colorOf_1(83, 10, 0)), new Entry_1(0.563025210084034, colorOf_1(19, 58, 0)), new Entry_1(1.0, colorOf_1(127, 255, 0))]));
    this.s21_1 = new Entry_2('bty', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-16316418, -15263748, -14803206, -14408456, -14145289, -13882123, -13684749, -13487374, -13355792, -13158417, -13026834, -12895252, -12763669, -12632086, -12500503, -12434713, -12303130, -12237339, -12105756, -12039965, -11908382, -11842591, -11776799, -11645216, -11579425, -11513634, -11447843, -11382051, -11250468, -11184677, -11118886, -11053094, -10987303, -10921512, -10855720, -10789929, -10724138, -10658346, -10592555, -10526763, -10460972, -10395180, -10329389, -10329390, -10263598, -10197807, -10132015, -10066224, -10000432, -9934640, -9868849, -9868849, -9803058, -9737266, -9671475, -9605683, -9539892, -9539892, -9474100, -9408309, -9342517, -9276726, -9276726, -9210934, -9145143, -9079351, -9013560, -9013560, -8947768, -8881977, -8816185, -8816185, -8750394, -8684602, -8618810, -8618811, -8553019, -8487227, -8421436, -8355644, -8355645, -8289853, -8224061, -8224062, -8158270, -8092478, -8026687, -8026687, -7960895, -7895104, -7829312, -7829312, -7763521, -7697729, -7631937, -7631938, -7566146, -7500354, -7434563, -7434563, -7368771, -7302980, -7302980, -7237188, -7171397, -7105605, -7105605, -7039814, -6974022, -6974022, -6908231, -6842439, -6776647, -6776648, -6710856, -6645064, -6645065, -6579273, -6513482, -6447690, -6447690, -6381899, -6316107, -6316107, -6250316, -6184524, -6118732, -6118733, -6052941, -5987150, -5987150, -5921358, -5855567, -5789775, -5789776, -5723984, -5658192, -5658193, -5592401, -5526610, -5460818, -5460819, -5395027, -5329235, -5329236, -5263444, -5197653, -5131861, -5131862, -5066070, -5000279, -5000279, -4934488, -4868696, -4868697, -4802905, -4737114, -4671322, -4671323, -4605531, -4539740, -4539740, -4473949, -4408157, -4342366, -4342366, -4276575, -4210783, -4210784, -4144993, -4079201, -4013410, -4013410, -3947619, -3881827, -3881828, -3816037, -3750245, -3684454, -3684455, -3618663, -3552872, -3552873, -3487081, -3421290, -3355499, -3355499, -3289708, -3223917, -3223918, -3158126, -3092335, -3026544, -3026545, -2960753, -2894962, -2894963, -2829172, -2763381, -2697590, -2697590, -2631799, -2566008, -2566009, -2500218, -2434427, -2368636, -2368637, -2302846, -2237055, -2237056, -2171265, -2105474, -2039683, -2039684, -1973893, -1908102, -1908103, -1842313, -1776522, -1710731, -1710732, -1644942, -1579151, -1513360, -1513362, -1447571, -1381781, -1381782, -1315992, -1250201, -1184411, -1184412, -1118622, -1052832, -1052834, -987044, -921253, -855463, -855466, -789676, -723886, -658096, -658099, -592310, -526520, -526523, -460735, -394946, -329158, -329162, -263375, -197588, -131803, -131812, -66035]))));
    this.t21_1 = new Entry_2('heated', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-10544128, -10347008, -10215680, -10084096, -10018304, -9886976, -9821184, -9689600, -9623808, -9492480, -9426432, -9295104, -9229312, -9097984, -8966400, -8966400, -8900608, -8769280, -8703232, -8571904, -8571904, -8506112, -8374784, -8308736, -8308736, -8177408, -8111616, -7980288, -7980288, -7848704, -7782912, -7782912, -7651584, -7651584, -7585536, -7454208, -7454208, -7388416, -7388416, -7257088, -7257088, -7191040, -7191040, -7059712, -7059712, -6993920, -6993920, -6862592, -6862592, -6731008, -6731008, -6665216, -6665216, -6665216, -6533888, -6533888, -6467840, -6467840, -6336512, -6336512, -6336512, -6270720, -6270720, -6139392, -6139392, -6073344, -6073344, -5942016, -5942016, -5876224, -5876224, -5876224, -5744896, -5744896, -5613312, -5613312, -5547520, -5547520, -5416192, -5416192, -5350144, -5350144, -5218816, -5218816, -5153024, -5153024, -5021696, -5021696, -4955648, -4824320, -4824320, -4758528, -4758528, -4626944, -4626944, -4495616, -4495616, -4429824, -4429824, -4298496, -4232448, -4232448, -4101120, -4101120, -4035328, -3904000, -3904000, -3837952, -3837952, -3706624, -3640832, -3640832, -3509248, -3509248, -3377920, -3312128, -3312128, -3180800, -3114752, -3114752, -2983424, -2917632, -2917632, -2786304, -2720256, -2720256, -2588928, -2523136, -2523136, -2391552, -2260224, -2260224, -2194432, -2063104, -2063104, -1997056, -1865728, -1865728, -1799936, -1668608, -1668608, -1602560, -1471232, -1471232, -1405440, -1273856, -1273856, -1142528, -1076736, -945408, -945408, -879360, -748032, -748032, -682240, -550656, -550656, -484864, -353536, -287744, -287744, -156160, -24832, -24832, -24576, -24320, -23808, -23808, -23552, -23296, -22784, -22784, -22528, -22272, -22272, -22016, -21504, -21248, -21248, -20992, -20736, -20224, -19968, -19712, -19200, -19200, -18944, -18688, -18432, -17657, -17398, -17138, -16622, -16363, -16103, -15587, -15068, -14808, -14293, -13773, -13258, -12739, -12479, -11704, -11444, -10669, -10149, -9374, -8855, -8339, -7820, -7045, -6010, -5490, -4715, -4196, -3936, -3161, -2386, -1866, -1607, -831, -572, -52, -49, -45, -38, -34, -31, -27, -23, -20, -16, -12, -9]))));
    this.u21_1 = new Entry_2('rainy', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-16385, -1592075, -3167765, -4743455, -6319145, -7894835, -9470525, -11046215, -12621905, -14197595, -15773285]))));
    this.v21_1 = new Entry_2('linred', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16711680, -16711680, -16711680, -16711680, -16711680, -16711680, -16711680, -16711680, -16711680, -16646144, -16646144, -16646144, -16646144, -16646144, -16646144, -16646144, -16580608, -16580608, -16580608, -16580608, -16580608, -16580608, -16580608, -16515072, -16515072, -16515072, -16515072, -16515072, -16449536, -16449536, -16449536, -16449536, -16449536, -16384000, -16384000, -16384000, -16384000, -16384000, -16318464, -16318464, -16318464, -16318464, -16318464, -16252928, -16252928, -16187392, -16187392, -16187392, -16187392, -16121856, -16121856, -16121856, -16121856, -16121856, -16056320, -16056320, -15990784, -15990784, -15990784, -15925248, -15925248, -15859712, -15859712, -15794176, -15794176, -15794176, -15728640, -15728640, -15663104, -15663104, -15597568, -15597568, -15532032, -15532032, -15532032, -15532032, -15532032, -15466496, -15466496, -15335424, -15335424, -15335424, -15269888, -15269888, -15204352, -15204352, -15073280, -15073280, -15073280, -15007744, -15007744, -14876672, -14876672, -14811136, -14811136, -14680064, -14680064, -14680064, -14680064, -14680064, -14548992, -14548992, -14483456, -14483456, -14483456, -14352384, -14352384, -14221312, -14221312, -14090240, -14090240, -14090240, -13959168, -13959168, -13828096, -13828096, -13762560, -13762560, -13762560, -13697024, -13697024, -13565952, -13565952, -13434880, -13434880, -13369344, -13369344, -13369344, -13238272, -13238272, -13107200, -13107200, -12910592, -12910592, -12910592, -12779520, -12779520, -12582912, -12582912, -12386304, -12386304, -12386304, -12255232, -12255232, -12058624, -12058624, -11862016, -11862016, -11796480, -11796480, -11796480, -11665408, -11665408, -11468800, -11468800, -11272192, -11272192, -11272192, -11075584, -11075584, -10813440, -10813440, -10616832, -10616832, -10616832, -10420224, -10420224, -10158080, -10158080, -9961472, -9961472, -9764864, -9764864, -9764864, -9699328, -9699328, -9437184, -9437184, -9175040, -9175040, -9175040, -8912896, -8912896, -8650752, -8650752, -8388608, -8388608, -8388608, -8126464, -8126464, -7864320, -7864320, -7536640, -7536640, -7274496, -7274496, -7274496, -7143424, -7143424, -6946816, -6946816, -6684672, -6684672, -6684672, -6356992, -6356992, -6029312, -6029312, -5701632, -5701632, -5701632, -5373952, -5373952, -5046272, -5046272, -4653056, -4653056, -4325376, -4325376, -4325376, -3997696, -3997696, -3997696, -3997696, -3604480, -3604480, -3604480, -3211264, -3211264, -2883584, -2883584, -2490368, -2490368, -2490368, -2097152, -2097152, -1703936, -1703936, -1245184, -1245184, -851968, -851968, -851968, -458752, -458752, -262144, -262144, -262144, -65536]))));
    this.w21_1 = new Entry_2('publimedia', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-1, -3634808, -3778215, -4182484, -6087908, -8907752, -11333360, -16777216, -16777216, -16777216, -16777216]))));
    this.x21_1 = new Entry_2('magenta', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-16777216, -14155776, -13107196, -12779511, -12582900, -12451826, -12255215, -11993068, -11927530, -11665383, -11599845, -11337698, -11206625, -11141087, -10878940, -10813402, -10682329, -10551255, -10485717, -10223570, -10092497, -10026959, -9895885, -9764812, -9699274, -9568201, -9437127, -9437127, -9371590, -9240516, -9109442, -8978369, -8912831, -8781758, -8650684, -8585146, -8454073, -8322999, -8322999, -8257462, -8126388, -7995314, -7864241, -7798703, -7667630, -7536556, -7471018, -7339945, -7208871, -7143334, -7012260, -6881186, -6881186, -6750113, -6684575, -6553502, -6422428, -6356890, -6225817, -6094743, -6029206, -5898132, -5767059, -5635985, -5570447, -5439374, -5308300, -5242763, -5111689, -4980615, -4980615, -4915078, -4784004, -4652931, -4521857, -4456319, -4325246, -4194172, -4128635, -3997561, -3866487, -3800950, -3669876, -3538803, -3407729, -3407729, -3342191, -3211118, -3080044, -3014507, -2883433, -2752359, -2686822, -2555748, -2424675, -2293601, -2228064, -2228064, -2096990, -1965916, -1900379, -1769305, -1638232, -1572694, -1441620, -1310547, -1179473, -1179473, -1113936, -982862, -851788, -786251, -655177, -523592, -457542, -457542, -457542, -325956, -325956, -194115, -194115, -62529, -62529, -62016, -62016, -62016, -61246, -60732, -60219, -60219, -59449, -58936, -58422, -57652, -57139, -56625, -55856, -55856, -55342, -54829, -54059, -53545, -53032, -52262, -51749, -51749, -51235, -50721, -49952, -49438, -48925, -48155, -48155, -47641, -47128, -46358, -45845, -45331, -44561, -44561, -44048, -43534, -42765, -42251, -41737, -40968, -40968, -40454, -39941, -39171, -38657, -38145, -38145, -37633, -36865, -36353, -35841, -35841, -35073, -34561, -34049, -34049, -33281, -32769, -32257, -32257, -31489, -30977, -30465, -30465, -29697, -29185, -28673, -28673, -27905, -27393, -26881, -26881, -26113, -25601, -25601, -25089, -24577, -24577, -23809, -23297, -23297, -22785, -22017, -21505, -21505, -20993, -20225, -20225, -19713, -19201, -19201, -18433, -17921, -17921, -17409, -16641, -16641, -16129, -15617, -14849, -14849, -14337, -13825, -13057, -13057, -12545, -12033, -11521, -11521, -10753, -10241, -9729, -9729, -8961, -8449, -7937, -7169, -6657, -6657, -6145, -5377, -4865, -4353, -3585, -3073, -3073, -2561, -1793, -1281, -1]))));
    this.y21_1 = new Entry_2('rainbow', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-16777216, -13828060, -13107154, -12845007, -12386250, -12189637, -12124099, -11861948, -11927479, -11927475, -11993007, -12124073, -12254886, -12320162, -12450975, -12646810, -12777622, -12973459, -13104015, -13299852, -13626761, -13691783, -13887620, -14083200, -14148479, -14344060, -14539642, -14865527, -15125366, -15189621, -15188339, -15187826, -15253106, -15252081, -15251570, -15251570, -15251058, -15250546, -15250546, -15249778, -15249266, -15249266, -15248755, -15247987, -15247987, -15247476, -15247476, -15181172, -15181172, -15180405, -15180405, -15180405, -15180405, -15179381, -15179381, -15112822, -15112822, -15112055, -15112055, -15112055, -15045495, -15045495, -14979192, -14979192, -14979192, -14978169, -14978169, -14911866, -14911866, -14845307, -14845307, -14845307, -14845307, -14844540, -14844540, -14778237, -14778237, -14711934, -14711934, -14711934, -14645632, -14645632, -14579329, -14579329, -14579329, -14513027, -14513027, -14446981, -14446981, -14380679, -14380679, -14380679, -14314634, -14314634, -14248332, -14248332, -14116751, -14116751, -14050705, -14050705, -13984660, -13984660, -13918614, -13918614, -13918614, -13787032, -13787032, -13720987, -13720987, -13589405, -13589405, -13457823, -13457823, -13391777, -13260195, -13260195, -13260195, -13128613, -13128613, -12997032, -12997032, -12865706, -12668588, -12537262, -12537262, -12340144, -12340144, -12208817, -12011699, -12011699, -12011699, -11814836, -11683254, -11486391, -11289272, -11026872, -10764473, -10502074, -10239674, -9977274, -9714874, -9452474, -9452474, -9190330, -8927930, -8665786, -8206777, -8009913, -7747768, -7551160, -7354551, -7354551, -7092407, -6895798, -6699190, -6502581, -6240180, -5781426, -5584817, -5388209, -5388209, -5126064, -4929455, -4733102, -4536494, -4274349, -3881131, -3684779, -3684779, -3422634, -3226281, -2833063, -2636710, -2440357, -2047394, -2047394, -1654432, -1458078, -1261980, -1131160, -1000342, -1000342, -869522, -738958, -673676, -542856, -477573, -477573, -346755, -281472, -215934, -150395, -150395, -84858, -85110, -19570, -19567, -19567, -19560, -19295, -19292, -19289, -19289, -19031, -19030, -18771, -18512, -18512, -18253, -17997, -17994, -17738, -17738, -17479, -17223, -16964, -16964, -16708, -16449, -16193, -15678, -15678, -14907, -14650, -14136, -13879, -13879, -13622, -13365, -12851, -12594, -12594, -12080, -11823, -11309, -10281, -10024, -10024, -9510, -9253, -8739, -8225, -7454, -6940, -6426, -6426, -5912, -5141, -4627, -3856, -3085, -2314, -1543, -1029, -515, -1]))));
    this.z21_1 = new Entry_2('locs', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-16777216, -16777216, -16777216, -16711680, -16646144, -16646144, -16580608, -16580608, -16515072, -16449536, -16449536, -16384000, -16318464, -16318464, -16252928, -16187392, -16187392, -16121856, -16056320, -15990784, -15925248, -15859712, -15794176, -15728640, -15663104, -15597568, -15532032, -15466496, -15400960, -15335424, -15269888, -15138816, -15073280, -15007744, -14942208, -14811136, -14745600, -14614528, -14548992, -14483456, -14352384, -14221312, -14155776, -13959168, -13828096, -13762560, -13565952, -13434880, -13303808, -13238272, -13107200, -12976128, -12845056, -12713984, -12582912, -12386304, -12255232, -12124160, -11927552, -11796480, -11534336, -11468800, -11272192, -11141120, -10944512, -10747904, -10616832, -10420224, -10223616, -10027008, -9830400, -9633792, -9437184, -9240576, -9109504, -8781824, -8519680, -8388608, -8192000, -7929856, -7929856, -7929600, -7929344, -7929088, -7928832, -7928320, -7928320, -7927808, -7927552, -7927296, -7927040, -7926528, -7926528, -7926016, -7925504, -7925504, -7924992, -7924480, -7924224, -7923968, -7923456, -7923200, -7922944, -7922432, -7921920, -7921664, -7921408, -7920896, -7920640, -7920128, -7919616, -7919104, -7918592, -7918080, -7917824, -7917312, -7916800, -7916544, -7916032, -7915520, -7915264, -7914752, -7913984, -7913728, -7913216, -7912704, -7912192, -7911424, -7911168, -7910400, -7909888, -7909376, -7908864, -7908352, -7907584, -7907328, -7906816, -7906048, -7905536, -7904768, -7904000, -7903488, -7902720, -7902464, -7901696, -7900928, -7900416, -7899648, -7898880, -7898112, -7897344, -7896832, -7895808, -7895296, -7894528, -7893760, -7892992, -7891968, -7891456, -7890176, -7889664, -7888896, -7888128, -7887360, -7886336, -7885312, -7884544, -7883776, -7882752, -7881728, -7880704, -7879936, -7878656, -7877888, -7877376, -7876096, -7875072, -7874048, -7873024, -7872000, -7870720, -7869440, -7868672, -7867392, -7866112, -7864832, -7864575, -7864571, -7864566, -7864561, -7864556, -7864553, -7864548, -7864543, -7864538, -7864533, -7864531, -7864527, -7864522, -7864517, -7864511, -7864506, -7864502, -7864496, -7864492, -7864486, -7864481, -7864478, -7864472, -7864466, -7864460, -7864456, -7864451, -7864445, -7864439, -7864432, -7864427, -7864422, -7864418, -7864411, -7864404, -7864397, -7864390, -7864385, -7864378, -7864373, -7864365, -7864360, -7864352, -7864344, -7864336, -7864328, -7864322, -7864321, -7536641, -7143425, -6684673, -6488065, -6160385, -5701633, -5439489, -5111809, -4784129, -4325377, -4128769, -3670017, -3342337, -2949121, -2621441, -2293761, -1966081, -1507329, -1245185, -983041, -458753, -1]))));
    this.a22_1 = new Entry_2('ocs', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-16777216, -16515072, -16252928, -15990784, -15728640, -15466496, -15204352, -14942208, -14680064, -14417920, -14155776, -13893632, -13631488, -13369344, -13107200, -12845056, -12582912, -12320768, -12058624, -11796480, -11534336, -11272192, -11010048, -10747904, -10485760, -10223616, -9961472, -9699328, -9437184, -9175040, -8912128, -8911616, -8910848, -8910336, -8909568, -8909056, -8908288, -8907776, -8907008, -8906496, -8905728, -8905216, -8904448, -8903936, -8903168, -8902656, -8901888, -8901376, -8900608, -8900096, -8899328, -8898816, -8898048, -8897536, -8896768, -8896256, -8895488, -8894976, -8894208, -8893696, -8892928, -8892416, -8891648, -8891136, -8890368, -8889856, -8889088, -8888576, -8887808, -8887296, -8886528, -8886016, -8885248, -8884736, -8883968, -8883456, -8882688, -8882176, -8881408, -8880893, -8880123, -8879608, -8878838, -8878323, -8877553, -8877038, -8876268, -8875753, -8809447, -8743396, -8677090, -8611039, -8544733, -8478682, -8412376, -8346325, -8280019, -8213968, -8147662, -8081611, -8080841, -8080326, -8079556, -8079041, -8078271, -8077756, -8076986, -8076471, -8075701, -8075186, -8074416, -8073901, -8073131, -8072616, -8071846, -8071331, -8070561, -8070046, -8069276, -8068761, -8067991, -8067476, -8066706, -8066191, -8065421, -8064906, -8064136, -8063621, -8062851, -8062336, -8061566, -8061051, -8061049, -8061046, -8061044, -8061041, -8061039, -8061036, -8061034, -8061031, -8061029, -8061026, -8061024, -8061021, -8061019, -8061016, -8061014, -8061011, -8061009, -8061006, -8061004, -8061001, -8060999, -8060996, -8060994, -8060991, -8060989, -8060986, -8060984, -8060981, -8060979, -8060976, -8060974, -8060971, -8060969, -8060966, -8060964, -8060961, -8060959, -8060956, -8060954, -8060951, -8060949, -8060946, -8060944, -8060941, -8060939, -8060936, -8060934, -8060931, -8060929, -8060929, -8060929, -8060929, -8060929, -8060929, -8060929, -8060929, -8060929, -8060929, -8060929, -8060929, -8060929, -8060929, -8060929, -8060929, -8060929, -8060929, -8060929, -8060929, -8060929, -8060929, -8060929, -8060929, -8060929, -7864321, -7733249, -7536641, -7340033, -7208961, -7012353, -6881281, -6684673, -6553601, -6356993, -6225921, -6029313, -5898241, -5701633, -5570561, -5373953, -5242881, -5046273, -4915201, -4718593, -4587521, -4390913, -4259841, -4063233, -3932161, -3735553, -3604481, -3407873, -3276801, -3080193, -2949121, -2752513, -2621441, -2424833, -2293761, -2097153, -1966081, -1769473, -1638401, -1441793, -1310721, -1114113, -983041, -786433, -655361, -458753, -327681, -131073, -1, -1, -1]))));
    this.b22_1 = new Entry_2('lingrey', PaletteType_SEQUENTIAL_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16711423, -16711423, -16711423, -16711423, -16711423, -16711423, -16711423, -16711423, -16711423, -16645630, -16645630, -16645630, -16645630, -16645630, -16645630, -16645630, -16579837, -16579837, -16579837, -16579837, -16579837, -16579837, -16579837, -16514044, -16514044, -16514044, -16514044, -16514044, -16448251, -16448251, -16448251, -16448251, -16448251, -16382458, -16382458, -16382458, -16382458, -16382458, -16316665, -16316665, -16316665, -16316665, -16316665, -16250872, -16250872, -16185079, -16185079, -16185079, -16185079, -16119286, -16119286, -16119286, -16119286, -16119286, -16053493, -16053493, -15987700, -15987700, -15987700, -15921907, -15921907, -15856114, -15856114, -15790321, -15790321, -15790321, -15724528, -15724528, -15658735, -15658735, -15592942, -15592942, -15527149, -15527149, -15527149, -15527149, -15527149, -15461356, -15461356, -15329770, -15329770, -15329770, -15263977, -15263977, -15198184, -15198184, -15066598, -15066598, -15066598, -15000805, -15000805, -14869219, -14869219, -14803426, -14803426, -14671840, -14671840, -14671840, -14671840, -14671840, -14540254, -14540254, -14474461, -14474461, -14474461, -14342875, -14342875, -14211289, -14211289, -14079703, -14079703, -14079703, -13948117, -13948117, -13816531, -13816531, -13750738, -13750738, -13750738, -13684945, -13684945, -13553359, -13553359, -13421773, -13421773, -13355980, -13355980, -13355980, -13224394, -13224394, -13092808, -13092808, -12895429, -12895429, -12895429, -12763843, -12763843, -12566464, -12566464, -12369085, -12369085, -12369085, -12237499, -12237499, -12040120, -12040120, -11842741, -11842741, -11776948, -11776948, -11776948, -11645362, -11645362, -11447983, -11447983, -11250604, -11250604, -11250604, -11053225, -11053225, -10790053, -10790053, -10592674, -10592674, -10592674, -10395295, -10395295, -10132123, -10132123, -9934744, -9934744, -9737365, -9737365, -9737365, -9671572, -9671572, -9408400, -9408400, -9145228, -9145228, -9145228, -8882056, -8882056, -8618884, -8618884, -8355712, -8355712, -8355712, -8092540, -8092540, -7829368, -7829368, -7500403, -7500403, -7237231, -7237231, -7237231, -7105645, -7105645, -6908266, -6908266, -6645094, -6645094, -6645094, -6316129, -6316129, -5987164, -5987164, -5658199, -5658199, -5658199, -5329234, -5329234, -5000269, -5000269, -4605511, -4605511, -4276546, -4276546, -4276546, -3947581, -3947581, -3947581, -3947581, -3552823, -3552823, -3552823, -3158065, -3158065, -2829100, -2829100, -2434342, -2434342, -2434342, -2039584, -2039584, -1644826, -1644826, -1184275, -1184275, -789517, -789517, -789517, -394759, -394759, -197380, -197380, -197380, -1]))));
    this.c22_1 = new Entry_2('YlOrRd', PaletteType_SEQUENTIAL_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-52, -78, -4704, -75402, -78756, -85428, -160452, -242134, -1033440, -1893860, -4390874, -5177306, -8388570]))));
    this.d22_1 = new Entry_2('PRGn', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-12582837, -9033085, -8703340, -6721365, -5272125, -4020785, -1583896, -526345, -2494253, -5842016, -8405125, -10834335, -16742345, -14976969, -16759781]))));
    this.e22_1 = new Entry_2('PuOr', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-8439032, -5023738, -1679103, -2063852, -941248, -149405, -73546, -526345, -2565397, -5067822, -6713661, -8358996, -10601319, -11262072, -13828021]))));
    this.f22_1 = new Entry_2('RdGy', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-10026977, -5105621, -3538912, -2727859, -1078686, -744062, -140345, -1, -2039584, -4539718, -6710887, -7895161, -12566464, -11711155, -15066598]))));
    this.g22_1 = new Entry_2('Spectral', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-6422206, -2802097, -2680548, -758461, -225959, -151967, -73589, -65, -1641064, -5513820, -6695532, -10042715, -13925446, -13465411, -10596446]))));
    this.h22_1 = new Entry_2('Grays', PaletteType_SEQUENTIAL_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-1, -526345, -986896, -2500135, -3355444, -4342339, -6908266, -9211021, -10263709, -11382190, -14342875, -14342875, -16777216]))));
    this.i22_1 = new Entry_2('PuBuGn', PaletteType_SEQUENTIAL_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-2053, -593929, -1252624, -3091994, -4339231, -5849637, -9131569, -13201216, -14905191, -16612982, -16683943, -16686000, -16693706]))));
    this.j22_1 = new Entry_2('RdPu', PaletteType_SEQUENTIAL_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-2061, -70686, -139043, -211520, -281415, -352331, -563039, -2280297, -3859574, -5373570, -8781449, -8781449, -11992982]))));
    this.k22_1 = new Entry_2('BuPu', PaletteType_SEQUENTIAL_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-525059, -1181445, -2036492, -4205594, -4993565, -6374182, -7563578, -7574607, -7842137, -7847523, -8319108, -9567893, -11730869]))));
    this.l22_1 = new Entry_2('YlOrBr', PaletteType_SEQUENTIAL_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-27, -44, -2116, -72815, -75378, -80817, -91863, -1282028, -2531570, -3388414, -6736892, -7590652, -10083066]))));
    this.m22_1 = new Entry_2('Greens', PaletteType_SEQUENTIAL_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-525067, -1181463, -1706528, -3675712, -4528973, -6170213, -9124746, -12473507, -13524140, -14447803, -16749268, -16754126, -16759781]))));
    this.n22_1 = new Entry_2('BuGn', PaletteType_SEQUENTIAL_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-525059, -1181445, -1706503, -3347226, -5053726, -6694711, -10042716, -12472714, -13852065, -14447803, -16749268, -16754652, -16759781]))));
    this.o22_1 = new Entry_2('Accents', PaletteType_QUALITATIVE_getInstance(), FixedPalette.x20(new Int32Array([-8402561, -4280620, -147322, -103, -13079376, -1047937, -4236521, -10066330])));
    this.p22_1 = new Entry_2('GnBu', PaletteType_SEQUENTIAL_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-525072, -984600, -2034725, -3347515, -4528964, -5710411, -8663868, -11619373, -12344630, -13923138, -16226132, -16230242, -16236415]))));
    this.q22_1 = new Entry_2('PuRd', PaletteType_SEQUENTIAL_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-527111, -921866, -1580561, -2836006, -2640424, -3566393, -2136656, -1627766, -2286473, -3272106, -6815677, -7274433, -10026977]))));
    this.r22_1 = new Entry_2('Purples', PaletteType_SEQUENTIAL_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-197635, -855817, -1053195, -2434325, -3421726, -4407844, -6382904, -8356422, -9081935, -9809501, -11262065, -11922298, -12648323]))));
    this.s22_1 = new Entry_2('RdYlGn', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-5963738, -2674649, -2680548, -758461, -225959, -151967, -73589, -65, -2494581, -5842582, -7221408, -10044061, -15034815, -15034288, -16750537]))));
    this.t22_1 = new Entry_2('Paired', PaletteType_QUALITATIVE_getInstance(), FixedPalette.x20(new Int32Array([-5845277, -14714700, -5054582, -13393876, -288103, -1893860, -147601, -33024, -3493162, -9814630, -103, -5154520])));
    this.u22_1 = new Entry_2('Blues', PaletteType_SEQUENTIAL_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-525313, -1051649, -2167817, -3744785, -4335641, -6370591, -9720106, -12414266, -13532483, -14585419, -16232036, -16235116, -16240533]))));
    this.v22_1 = new Entry_2('RdBu', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-10026977, -5105621, -3538912, -2727859, -1078686, -744062, -140345, -526345, -3021328, -7158306, -9983537, -12348477, -16420432, -14588244, -16437151]))));
    this.w22_1 = new Entry_2('Oranges', PaletteType_SEQUENTIAL_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-2581, -70178, -71986, -143198, -147835, -151957, -160452, -956141, -1682163, -2537471, -5884413, -7590652, -8444156]))));
    this.x22_1 = new Entry_2('RdYlBu', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-5963738, -2674649, -2680548, -758461, -225959, -151967, -73584, -65, -2034696, -5514775, -7225381, -9130543, -13861962, -12225100, -13551979]))));
    this.y22_1 = new Entry_2('PuBu', PaletteType_SEQUENTIAL_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-2053, -921866, -1251342, -3091994, -4339231, -5849637, -9983537, -13201216, -13923138, -16420688, -16491891, -16560517, -16631720]))));
    this.z22_1 = new Entry_2('OrRd', PaletteType_SEQUENTIAL_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-2068, -69415, -71480, -142178, -144246, -148604, -225959, -1088184, -1881549, -2674657, -5046272, -6750208, -8454144]))));
    this.a23_1 = new Entry_2('Set3', PaletteType_QUALITATIVE_getInstance(), FixedPalette.x20(new Int32Array([-7482425, -77, -4277542, -294798, -8343085, -150430, -4989335, -209435, -2500135, -4423491, -3347515, -4753])));
    this.b23_1 = new Entry_2('Set2', PaletteType_QUALITATIVE_getInstance(), FixedPalette.x20(new Int32Array([-10042715, -225950, -7495477, -1602877, -5842860, -9937, -1719148, -5000269])));
    this.c23_1 = new Entry_2('Set1', PaletteType_QUALITATIVE_getInstance(), FixedPalette.x20(new Int32Array([-1828324, -13140296, -11686070, -6795613, -33024, -205, -5876184, -556609, -6710887])));
    this.d23_1 = new Entry_2('Reds', PaletteType_SEQUENTIAL_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-2576, -72231, -73518, -214111, -217455, -224654, -300470, -1098964, -2216666, -3467235, -5959915, -6750195, -10026995]))));
    this.e23_1 = new Entry_2('PiYG', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-7470766, -3859587, -3138421, -2197586, -1465399, -936230, -139025, -526345, -1641008, -4660858, -6170774, -8405951, -11686874, -11693535, -14195687]))));
    this.f23_1 = new Entry_2('Dark2', PaletteType_QUALITATIVE_getInstance(), FixedPalette.x20(new Int32Array([-14967177, -2531582, -9080653, -1627766, -10050018, -1660158, -5868003, -10066330])));
    this.g23_1 = new Entry_2('YlGn', PaletteType_SEQUENTIAL_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-27, -52, -525127, -2494301, -4004199, -5382770, -8862087, -12473507, -13524140, -14449597, -16750537, -16754126, -16759511]))));
    this.h23_1 = new Entry_2('BrBG', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-11259899, -7581430, -5873382, -4226771, -2575515, -2112899, -595773, -657931, -3675419, -8335935, -10832724, -13265009, -16677519, -16685474, -16761808]))));
    this.i23_1 = new Entry_2('YlGnBu', PaletteType_SEQUENTIAL_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.x20(new Int32Array([-39, -52, -1181519, -3675724, -6169932, -8401477, -12470615, -14839360, -13860936, -14524248, -14338924, -15979388, -16245416]))));
    this.j23_1 = new Entry_2('Pastel2', PaletteType_QUALITATIVE_getInstance(), FixedPalette.x20(new Int32Array([-4988211, -143956, -3418648, -734492, -1641015, -3410, -924980, -3355444])));
    this.k23_1 = new Entry_2('Pastel1', PaletteType_QUALITATIVE_getInstance(), FixedPalette.x20(new Int32Array([-281426, -4993565, -3347515, -2176028, -75354, -52, -1713987, -140564, -855310])));
    this.l23_1 = new Entry_2('IsoL', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.z20([colorOf_2(0.9102, 0.2236, 0.8997), colorOf_2(0.4027, 0.3711, 1.0), colorOf_2(0.0422, 0.5904, 0.5899), colorOf_2(0.0386, 0.6206, 0.0201), colorOf_2(0.5441, 0.5428, 0.011), colorOf_2(1.0, 0.2288, 0.1631)])));
    this.m23_1 = new Entry_2('CubicL', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.z20([colorOf_2(0.4706, 0.0, 0.5216), colorOf_2(0.5137, 0.0527, 0.7096), colorOf_2(0.4942, 0.2507, 0.8781), colorOf_2(0.4296, 0.3858, 0.9922), colorOf_2(0.3691, 0.5172, 0.9495), colorOf_2(0.2963, 0.6191, 0.8515), colorOf_2(0.2199, 0.7134, 0.7225), colorOf_2(0.2643, 0.7836, 0.5756), colorOf_2(0.3094, 0.8388, 0.4248), colorOf_2(0.3623, 0.8917, 0.2858), colorOf_2(0.52, 0.921, 0.3137), colorOf_2(0.68, 0.9255, 0.3386), colorOf_2(0.8, 0.9255, 0.3529), colorOf_2(0.8706, 0.8549, 0.3608), colorOf_2(0.9514, 0.7466, 0.3686), colorOf_2(0.9765, 0.5887, 0.3569)])));
    this.n23_1 = new Entry_2('Edge', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.z20([colorOf_2(0.0, 0.0, 0.0), colorOf_2(0.0, 0.0, 1.0), colorOf_2(0.0, 1.0, 1.0), colorOf_2(1.0, 1.0, 1.0), colorOf_2(1.0, 1.0, 0.0), colorOf_2(1.0, 0.0, 0.0), colorOf_2(0.0, 0.0, 0.0)])));
    this.o23_1 = new Entry_2('coolwarm', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.z20([colorOf_2(0.2298057, 0.29871798, 0.75368315), colorOf_2(0.23437709, 0.30554172, 0.75967956), colorOf_2(0.23894846, 0.3123655, 0.7656759), colorOf_2(0.24351984, 0.31918925, 0.77167225), colorOf_2(0.24809122, 0.32601303, 0.77766865), colorOf_2(0.2526626, 0.33283678, 0.783665), colorOf_2(0.25723398, 0.33966056, 0.7896614), colorOf_2(0.26180536, 0.3464843, 0.79565775), colorOf_2(0.26638147, 0.35330442, 0.8016373), colorOf_2(0.2711043, 0.36001065, 0.8070951), colorOf_2(0.2758271, 0.36671692, 0.8125529), colorOf_2(0.28054994, 0.37342316, 0.81801075), colorOf_2(0.28527278, 0.38012943, 0.82346857), colorOf_2(0.2899956, 0.38683566, 0.8289264), colorOf_2(0.29471844, 0.39354193, 0.83438414), colorOf_2(0.29944125, 0.40024817, 0.83984196), colorOf_2(0.30417427, 0.40694487, 0.8452627), colorOf_2(0.3090603, 0.41349828, 0.85012764), colorOf_2(0.31394634, 0.42005166, 0.85499257), colorOf_2(0.3188324, 0.42660505, 0.85985744), colorOf_2(0.32371843, 0.43315843, 0.8647224), colorOf_2(0.32860446, 0.43971184, 0.86958724), colorOf_2(0.3334905, 0.44626522, 0.8744522), colorOf_2(0.33837652, 0.4528186, 0.8793171), colorOf_2(0.3432775, 0.45935363, 0.8841219), colorOf_2(0.34832335, 0.46571115, 0.88834614), colorOf_2(0.35336915, 0.47206867, 0.8925704), colorOf_2(0.35841498, 0.47842616, 0.8967946), colorOf_2(0.3634608, 0.48478368, 0.90101886), colorOf_2(0.3685066, 0.4911412, 0.9052431), colorOf_2(0.37355244, 0.4974987, 0.9094674), colorOf_2(0.37859824, 0.50385624, 0.91369164), colorOf_2(0.38366207, 0.5101834, 0.91783065), colorOf_2(0.38885188, 0.5162984, 0.9213735), colorOf_2(0.3940417, 0.52241343, 0.92491627), colorOf_2(0.3992315, 0.52852845, 0.9284591), colorOf_2(0.4044213, 0.5346435, 0.9320019), colorOf_2(0.4096111, 0.5407585, 0.9355447), colorOf_2(0.4148009, 0.5468735, 0.9390875), colorOf_2(0.41999072, 0.5529885, 0.94263035), colorOf_2(0.42519897, 0.5590582, 0.94606143), colorOf_2(0.43050689, 0.56488276, 0.94888943), colorOf_2(0.4358148, 0.5707073, 0.9517174), colorOf_2(0.4411227, 0.5765319, 0.9545453), colorOf_2(0.44643065, 0.58235645, 0.9573733), colorOf_2(0.45173857, 0.58818096, 0.96020126), colorOf_2(0.45704648, 0.5940055, 0.9630292), colorOf_2(0.4623544, 0.5998301, 0.9658572), colorOf_2(0.4676781, 0.60559124, 0.9685463), colorOf_2(0.47307017, 0.6110774, 0.97063357), colorOf_2(0.47846225, 0.6165636, 0.9727209), colorOf_2(0.48385432, 0.62204987, 0.9748082), colorOf_2(0.4892464, 0.62753606, 0.9768955), colorOf_2(0.49463847, 0.63302225, 0.9789828), colorOf_2(0.5000306, 0.63850844, 0.9810701), colorOf_2(0.50542265, 0.6439947, 0.98315746), colorOf_2(0.5108243, 0.6493966, 0.98507875), colorOf_2(0.5162603, 0.6544976, 0.9864074), colorOf_2(0.52169627, 0.6595986, 0.98773605), colorOf_2(0.5271323, 0.6646996, 0.98906463), colorOf_2(0.5325682, 0.6698006, 0.9903933), colorOf_2(0.5380042, 0.6749016, 0.99172187), colorOf_2(0.5434402, 0.68000257, 0.9930505), colorOf_2(0.54887617, 0.6851036, 0.99437916), colorOf_2(0.5543119, 0.69009703, 0.9955155), colorOf_2(0.55974674, 0.6947677, 0.99607533), colorOf_2(0.56518155, 0.69943845, 0.9966351), colorOf_2(0.5706164, 0.70410913, 0.9971948), colorOf_2(0.5760513, 0.7087799, 0.9977546), colorOf_2(0.58148617, 0.7134506, 0.9983144), colorOf_2(0.586921, 0.7181213, 0.9988741), colorOf_2(0.59235585, 0.722792, 0.9994339), colorOf_2(0.5977768, 0.72732973, 0.9997767), colorOf_2(0.60316205, 0.73152745, 0.9995653), colorOf_2(0.6085474, 0.7357252, 0.9993538), colorOf_2(0.61393267, 0.739923, 0.99914235), colorOf_2(0.61931795, 0.7441207, 0.99893093), colorOf_2(0.6247032, 0.7483185, 0.99871945), colorOf_2(0.6300885, 0.7525162, 0.99850804), colorOf_2(0.63547385, 0.756714, 0.99829656), colorOf_2(0.6408278, 0.7607515, 0.99784577), colorOf_2(0.6461128, 0.7644365, 0.9968685), colorOf_2(0.6513978, 0.7681215, 0.99589115), colorOf_2(0.65668285, 0.7718065, 0.9949138), colorOf_2(0.6619679, 0.7754915, 0.99393654), colorOf_2(0.6672529, 0.7791765, 0.9929592), colorOf_2(0.672538, 0.7828615, 0.9919819), colorOf_2(0.677823, 0.7865464, 0.9910046), colorOf_2(0.6830557, 0.79004264, 0.98976845), colorOf_2(0.6881885, 0.7931784, 0.9880381), colorOf_2(0.6933213, 0.7963141, 0.9863078), colorOf_2(0.6984541, 0.79944986, 0.9845775), colorOf_2(0.7035869, 0.80258566, 0.98284715), colorOf_2(0.7087197, 0.8057214, 0.98111683), colorOf_2(0.71385247, 0.80885714, 0.9793865), colorOf_2(0.7189853, 0.8119929, 0.9776562), colorOf_2(0.72404134, 0.8149104, 0.97565097), colorOf_2(0.7289696, 0.8174641, 0.9731877), colorOf_2(0.7338978, 0.8200179, 0.97072434), colorOf_2(0.738826, 0.82257164, 0.96826106), colorOf_2(0.7437542, 0.82512534, 0.9657978), colorOf_2(0.74868244, 0.8276791, 0.96333444), colorOf_2(0.7536106, 0.83023286, 0.96087116), colorOf_2(0.75853884, 0.8327866, 0.9584079), colorOf_2(0.76336277, 0.83509225, 0.95565766), colorOf_2(0.76803434, 0.83703524, 0.95248824), colorOf_2(0.772706, 0.83897823, 0.94931877), colorOf_2(0.77737755, 0.8409212, 0.9461493), colorOf_2(0.7820491, 0.8428642, 0.9429799), colorOf_2(0.7867207, 0.8448072, 0.9398104), colorOf_2(0.79139227, 0.8467502, 0.9366409), colorOf_2(0.79606384, 0.8486932, 0.93347144), colorOf_2(0.8006008, 0.8503583, 0.9300076), colorOf_2(0.8049648, 0.85166615, 0.9261651), colorOf_2(0.8093287, 0.852974, 0.9223226), colorOf_2(0.81369257, 0.85428184, 0.9184801), colorOf_2(0.81805646, 0.8555897, 0.9146376), colorOf_2(0.8224204, 0.85689753, 0.91079515), colorOf_2(0.8267843, 0.8582054, 0.9069526), colorOf_2(0.8311482, 0.8595132, 0.90311015), colorOf_2(0.83534473, 0.860514, 0.8989704), colorOf_2(0.8393514, 0.86116683, 0.89449376), colorOf_2(0.84335816, 0.8618196, 0.8900171), colorOf_2(0.8473649, 0.8624725, 0.8855405), colorOf_2(0.85137165, 0.8631253, 0.8810638), colorOf_2(0.8553784, 0.8637781, 0.87658715), colorOf_2(0.8593851, 0.86443096, 0.87211055), colorOf_2(0.8633918, 0.8650838, 0.8676339), colorOf_2(0.86742765, 0.8643766, 0.8626025), colorOf_2(0.8714925, 0.8623094, 0.85701627), colorOf_2(0.87555736, 0.8602422, 0.85143006), colorOf_2(0.8796223, 0.8581749, 0.84584385), colorOf_2(0.88368714, 0.8561077, 0.84025764), colorOf_2(0.887752, 0.8540405, 0.8346715), colorOf_2(0.8918169, 0.8519733, 0.8290853), colorOf_2(0.8958818, 0.849906, 0.8234991), colorOf_2(0.8995432, 0.84750026, 0.8177891), colorOf_2(0.90284866, 0.84479564, 0.8119698), colorOf_2(0.90615416, 0.8420911, 0.8061506), colorOf_2(0.9094596, 0.83938646, 0.80033135), colorOf_2(0.9127651, 0.8366819, 0.7945121), colorOf_2(0.9160705, 0.8339773, 0.7886929), colorOf_2(0.919376, 0.8312727, 0.78287363), colorOf_2(0.92268145, 0.82856816, 0.77705437), colorOf_2(0.9255634, 0.8255173, 0.7711363), colorOf_2(0.928116, 0.82219714, 0.76514137), colorOf_2(0.9306686, 0.818877, 0.7591464), colorOf_2(0.93322116, 0.8155568, 0.7531514), colorOf_2(0.9357738, 0.8122367, 0.7471565), colorOf_2(0.93832636, 0.80891657, 0.7411615), colorOf_2(0.9408789, 0.8055964, 0.73516655), colorOf_2(0.94343156, 0.80227625, 0.7291716), colorOf_2(0.9455403, 0.79860574, 0.72310543), colorOf_2(0.9473454, 0.7946955, 0.71699053), colorOf_2(0.9491505, 0.79078525, 0.7108756), colorOf_2(0.9509556, 0.786875, 0.7047607), colorOf_2(0.9527607, 0.7829648, 0.6986458), colorOf_2(0.9545658, 0.7790546, 0.6925309), colorOf_2(0.95637095, 0.77514434, 0.686416), colorOf_2(0.958176, 0.7712341, 0.680301), colorOf_2(0.95951766, 0.76697284, 0.6741447), colorOf_2(0.9605812, 0.762501, 0.66796356), colorOf_2(0.9616447, 0.75802916, 0.6617824), colorOf_2(0.9627083, 0.7535573, 0.6556012), colorOf_2(0.9637718, 0.7490855, 0.64942), colorOf_2(0.96483535, 0.74461365, 0.6432389), colorOf_2(0.9658989, 0.7401418, 0.6370577), colorOf_2(0.96696246, 0.73567003, 0.63087654), colorOf_2(0.9675443, 0.73084974, 0.62468547), colorOf_2(0.9678739, 0.7258469, 0.6184892), colorOf_2(0.9682034, 0.7208441, 0.612293), colorOf_2(0.9685329, 0.7158413, 0.60609674), colorOf_2(0.9688625, 0.7108385, 0.5999005), colorOf_2(0.969192, 0.7058357, 0.5937043), colorOf_2(0.9695216, 0.70083284, 0.587508), colorOf_2(0.96985114, 0.69583005, 0.58131176), colorOf_2(0.969683, 0.6904839, 0.5751384), colorOf_2(0.9692886, 0.68498176, 0.5689753), colorOf_2(0.9688942, 0.67947954, 0.56281227), colorOf_2(0.9684997, 0.6739774, 0.55664927), colorOf_2(0.9681053, 0.6684752, 0.5504862), colorOf_2(0.9677109, 0.662973, 0.5443232), colorOf_2(0.9673165, 0.6574708, 0.53816015), colorOf_2(0.9669221, 0.65196866, 0.53199714), colorOf_2(0.9660167, 0.6461297, 0.52589035), colorOf_2(0.9649114, 0.6401591, 0.5198056), colorOf_2(0.96380603, 0.6341884, 0.51372087), colorOf_2(0.9627007, 0.62821776, 0.5076361), colorOf_2(0.9615954, 0.6222471, 0.50155133), colorOf_2(0.96049005, 0.61627644, 0.4954666), colorOf_2(0.95938474, 0.6103058, 0.48938185), colorOf_2(0.9582794, 0.60433507, 0.4832971), colorOf_2(0.95665324, 0.59803385, 0.47730228), colorOf_2(0.9548534, 0.59162235, 0.47133747), colorOf_2(0.9530536, 0.58521086, 0.46537262), colorOf_2(0.9512538, 0.57879937, 0.4594078), colorOf_2(0.949454, 0.57238793, 0.453443), colorOf_2(0.9476542, 0.56597644, 0.44747815), colorOf_2(0.94585437, 0.55956495, 0.44151333), colorOf_2(0.94405454, 0.55315346, 0.43554848), colorOf_2(0.94172794, 0.5464135, 0.42970708), colorOf_2(0.93925375, 0.5395815, 0.42390022), colorOf_2(0.9367796, 0.5327495, 0.41809335), colorOf_2(0.9343054, 0.52591753, 0.41228646), colorOf_2(0.9318313, 0.5190855, 0.4064796), colorOf_2(0.9293571, 0.5122535, 0.40067273), colorOf_2(0.926883, 0.5054215, 0.39486587), colorOf_2(0.9244088, 0.49858955, 0.389059), colorOf_2(0.9214062, 0.49142042, 0.38340843), colorOf_2(0.9182817, 0.48417348, 0.37779394), colorOf_2(0.91515714, 0.47692654, 0.37217942), colorOf_2(0.9120326, 0.4696796, 0.3665649), colorOf_2(0.908908, 0.46243262, 0.36095038), colorOf_2(0.9057835, 0.45518568, 0.3553359), colorOf_2(0.90265894, 0.44793874, 0.34972137), colorOf_2(0.8995344, 0.4406918, 0.34410685), colorOf_2(0.8958846, 0.43307456, 0.33868062), colorOf_2(0.8921375, 0.42538872, 0.33328927), colorOf_2(0.8883905, 0.4177029, 0.3278979), colorOf_2(0.88464344, 0.4100171, 0.32250655), colorOf_2(0.8808964, 0.4023313, 0.3171152), colorOf_2(0.87714934, 0.39464545, 0.31172383), colorOf_2(0.8734023, 0.38695964, 0.30633247), colorOf_2(0.86965525, 0.37927383, 0.3009411), colorOf_2(0.8653913, 0.37112767, 0.29576895), colorOf_2(0.8610536, 0.36291575, 0.29062814), colorOf_2(0.85671586, 0.35470384, 0.2854873), colorOf_2(0.85237813, 0.34649193, 0.28034648), colorOf_2(0.8480404, 0.33828005, 0.27520564), colorOf_2(0.8437027, 0.33006814, 0.2700648), colorOf_2(0.83936495, 0.32185623, 0.264924), colorOf_2(0.8350272, 0.31364432, 0.25978315), colorOf_2(0.83018655, 0.30473277, 0.25489143), colorOf_2(0.82529384, 0.29574883, 0.25002548), colorOf_2(0.8204011, 0.28676492, 0.24515952), colorOf_2(0.81550837, 0.27778098, 0.24029356), colorOf_2(0.81061566, 0.26879707, 0.23542762), colorOf_2(0.80572295, 0.25981313, 0.23056166), colorOf_2(0.80083025, 0.25082922, 0.2256957), colorOf_2(0.79593754, 0.24184528, 0.22082976), colorOf_2(0.79056156, 0.231397, 0.21624205), colorOf_2(0.7851533, 0.2208511, 0.21167287), colorOf_2(0.7797451, 0.21030518, 0.20710371), colorOf_2(0.7743369, 0.19975927, 0.20253456), colorOf_2(0.76892865, 0.18921335, 0.1979654), colorOf_2(0.7635204, 0.17866744, 0.19339623), colorOf_2(0.7581122, 0.16812153, 0.18882707), colorOf_2(0.75270396, 0.15757562, 0.18425791), colorOf_2(0.74683803, 0.14002103, 0.1799961), colorOf_2(0.7409573, 0.12224033, 0.1757442), colorOf_2(0.7350766, 0.10445963, 0.17149231), colorOf_2(0.72919595, 0.08667894, 0.1672404), colorOf_2(0.72331524, 0.068898246, 0.1629885), colorOf_2(0.7174345, 0.051117547, 0.1587366), colorOf_2(0.7115539, 0.033336855, 0.1544847), colorOf_2(0.70567316, 0.01555616, 0.1502328)])));
    this.q23_1 = new Entry_2('magma', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.z20([colorOf_2(0.001462, 4.66E-4, 0.013866), colorOf_2(0.002258, 0.001295, 0.018331), colorOf_2(0.003279, 0.002305, 0.023708), colorOf_2(0.004512, 0.00349, 0.029965), colorOf_2(0.00595, 0.004843, 0.03713), colorOf_2(0.007588, 0.006356, 0.044973), colorOf_2(0.009426, 0.008022, 0.052844), colorOf_2(0.011465, 0.009828, 0.06075), colorOf_2(0.013708, 0.011771, 0.068667), colorOf_2(0.016156, 0.01384, 0.076603), colorOf_2(0.018815, 0.016026, 0.084584), colorOf_2(0.021692, 0.01832, 0.09261), colorOf_2(0.024792, 0.020715, 0.100676), colorOf_2(0.028123, 0.023201, 0.108787), colorOf_2(0.031696, 0.025765, 0.116965), colorOf_2(0.03552, 0.028397, 0.125209), colorOf_2(0.039608, 0.03109, 0.133515), colorOf_2(0.04383, 0.03383, 0.141886), colorOf_2(0.048062, 0.036607, 0.150327), colorOf_2(0.05232, 0.039407, 0.158841), colorOf_2(0.056615, 0.04216, 0.167446), colorOf_2(0.060949, 0.044794, 0.176129), colorOf_2(0.06533, 0.047318, 0.184892), colorOf_2(0.069764, 0.049726, 0.193735), colorOf_2(0.074257, 0.052017, 0.20266), colorOf_2(0.078815, 0.054184, 0.211667), colorOf_2(0.083446, 0.056225, 0.220755), colorOf_2(0.088155, 0.058133, 0.229922), colorOf_2(0.092949, 0.059904, 0.239164), colorOf_2(0.097833, 0.061531, 0.248477), colorOf_2(0.102815, 0.06301, 0.257854), colorOf_2(0.107899, 0.064335, 0.267289), colorOf_2(0.113094, 0.065492, 0.276784), colorOf_2(0.118405, 0.066479, 0.286321), colorOf_2(0.123833, 0.067295, 0.295879), colorOf_2(0.12938, 0.067935, 0.305443), colorOf_2(0.135053, 0.068391, 0.315), colorOf_2(0.140858, 0.068654, 0.324538), colorOf_2(0.146785, 0.068738, 0.334011), colorOf_2(0.152839, 0.068637, 0.343404), colorOf_2(0.159018, 0.068354, 0.352688), colorOf_2(0.165308, 0.067911, 0.361816), colorOf_2(0.171713, 0.067305, 0.370771), colorOf_2(0.178212, 0.066576, 0.379497), colorOf_2(0.184801, 0.065732, 0.387973), colorOf_2(0.19146, 0.064818, 0.396152), colorOf_2(0.198177, 0.063862, 0.404009), colorOf_2(0.204935, 0.062907, 0.411514), colorOf_2(0.211718, 0.061992, 0.418647), colorOf_2(0.218512, 0.061158, 0.425392), colorOf_2(0.225302, 0.060445, 0.431742), colorOf_2(0.232077, 0.059889, 0.437695), colorOf_2(0.238826, 0.059517, 0.443256), colorOf_2(0.245543, 0.059352, 0.448436), colorOf_2(0.25222, 0.059415, 0.453248), colorOf_2(0.258857, 0.059706, 0.45771), colorOf_2(0.265447, 0.060237, 0.46184), colorOf_2(0.271994, 0.060994, 0.46566), colorOf_2(0.278493, 0.061978, 0.46919), colorOf_2(0.284951, 0.063168, 0.472451), colorOf_2(0.291366, 0.064553, 0.475462), colorOf_2(0.29774, 0.066117, 0.478243), colorOf_2(0.304081, 0.067835, 0.480812), colorOf_2(0.310382, 0.069702, 0.483186), colorOf_2(0.316654, 0.07169, 0.48538), colorOf_2(0.322899, 0.073782, 0.487408), colorOf_2(0.329114, 0.075972, 0.489287), colorOf_2(0.335308, 0.078236, 0.491024), colorOf_2(0.341482, 0.080564, 0.492631), colorOf_2(0.347636, 0.082946, 0.494121), colorOf_2(0.353773, 0.085373, 0.495501), colorOf_2(0.359898, 0.087831, 0.496778), colorOf_2(0.366012, 0.090314, 0.49796), colorOf_2(0.372116, 0.092816, 0.499053), colorOf_2(0.378211, 0.095332, 0.500067), colorOf_2(0.384299, 0.097855, 0.501002), colorOf_2(0.390384, 0.100379, 0.501864), colorOf_2(0.396467, 0.102902, 0.502658), colorOf_2(0.402548, 0.10542, 0.503386), colorOf_2(0.408629, 0.10793, 0.504052), colorOf_2(0.414709, 0.110431, 0.504662), colorOf_2(0.420791, 0.11292, 0.505215), colorOf_2(0.426877, 0.115395, 0.505714), colorOf_2(0.432967, 0.117855, 0.50616), colorOf_2(0.439062, 0.120298, 0.506555), colorOf_2(0.445163, 0.122724, 0.506901), colorOf_2(0.451271, 0.125132, 0.507198), colorOf_2(0.457386, 0.127522, 0.507448), colorOf_2(0.463508, 0.129893, 0.507652), colorOf_2(0.46964, 0.132245, 0.507809), colorOf_2(0.47578, 0.134577, 0.507921), colorOf_2(0.481929, 0.136891, 0.507989), colorOf_2(0.488088, 0.139186, 0.508011), colorOf_2(0.494258, 0.141462, 0.507988), colorOf_2(0.500438, 0.143719, 0.50792), colorOf_2(0.506629, 0.145958, 0.507806), colorOf_2(0.512831, 0.148179, 0.507648), colorOf_2(0.519045, 0.150383, 0.507443), colorOf_2(0.52527, 0.152569, 0.507192), colorOf_2(0.531507, 0.154739, 0.506895), colorOf_2(0.537755, 0.156894, 0.506551), colorOf_2(0.544015, 0.159033, 0.506159), colorOf_2(0.550287, 0.161158, 0.505719), colorOf_2(0.556571, 0.163269, 0.50523), colorOf_2(0.562866, 0.165368, 0.504692), colorOf_2(0.569172, 0.167454, 0.504105), colorOf_2(0.57549, 0.16953, 0.503466), colorOf_2(0.581819, 0.171596, 0.502777), colorOf_2(0.588158, 0.173652, 0.502035), colorOf_2(0.594508, 0.175701, 0.501241), colorOf_2(0.600868, 0.177743, 0.500394), colorOf_2(0.607238, 0.179779, 0.499492), colorOf_2(0.613617, 0.181811, 0.498536), colorOf_2(0.620005, 0.18384, 0.497524), colorOf_2(0.626401, 0.185867, 0.496456), colorOf_2(0.632805, 0.187893, 0.495332), colorOf_2(0.639216, 0.189921, 0.49415), colorOf_2(0.645633, 0.191952, 0.49291), colorOf_2(0.652056, 0.193986, 0.491611), colorOf_2(0.658483, 0.196027, 0.490253), colorOf_2(0.664915, 0.198075, 0.488836), colorOf_2(0.671349, 0.200133, 0.487358), colorOf_2(0.677786, 0.202203, 0.485819), colorOf_2(0.684224, 0.204286, 0.484219), colorOf_2(0.690661, 0.206384, 0.482558), colorOf_2(0.697098, 0.208501, 0.480835), colorOf_2(0.703532, 0.210638, 0.479049), colorOf_2(0.709962, 0.212797, 0.477201), colorOf_2(0.716387, 0.214982, 0.47529), colorOf_2(0.722805, 0.217194, 0.473316), colorOf_2(0.729216, 0.219437, 0.471279), colorOf_2(0.735616, 0.221713, 0.46918), colorOf_2(0.742004, 0.224025, 0.467018), colorOf_2(0.748378, 0.226377, 0.464794), colorOf_2(0.754737, 0.228772, 0.462509), colorOf_2(0.761077, 0.231214, 0.460162), colorOf_2(0.767398, 0.233705, 0.457755), colorOf_2(0.773695, 0.236249, 0.455289), colorOf_2(0.779968, 0.238851, 0.452765), colorOf_2(0.786212, 0.241514, 0.450184), colorOf_2(0.792427, 0.244242, 0.447543), colorOf_2(0.798608, 0.24704, 0.444848), colorOf_2(0.804752, 0.249911, 0.442102), colorOf_2(0.810855, 0.252861, 0.439305), colorOf_2(0.816914, 0.255895, 0.436461), colorOf_2(0.822926, 0.259016, 0.433573), colorOf_2(0.828886, 0.262229, 0.430644), colorOf_2(0.834791, 0.26554, 0.427671), colorOf_2(0.840636, 0.268953, 0.424666), colorOf_2(0.846416, 0.272473, 0.421631), colorOf_2(0.852126, 0.276106, 0.418573), colorOf_2(0.857763, 0.279857, 0.415496), colorOf_2(0.86332, 0.283729, 0.412403), colorOf_2(0.868793, 0.287728, 0.409303), colorOf_2(0.874176, 0.291859, 0.406205), colorOf_2(0.879464, 0.296125, 0.403118), colorOf_2(0.884651, 0.30053, 0.400047), colorOf_2(0.889731, 0.305079, 0.397002), colorOf_2(0.8947, 0.309773, 0.393995), colorOf_2(0.899552, 0.314616, 0.391037), colorOf_2(0.904281, 0.31961, 0.388137), colorOf_2(0.908884, 0.324755, 0.385308), colorOf_2(0.913354, 0.330052, 0.382563), colorOf_2(0.917689, 0.3355, 0.379915), colorOf_2(0.921884, 0.341098, 0.377376), colorOf_2(0.925937, 0.346844, 0.374959), colorOf_2(0.929845, 0.352734, 0.372677), colorOf_2(0.933606, 0.358764, 0.370541), colorOf_2(0.937221, 0.364929, 0.368567), colorOf_2(0.940687, 0.371224, 0.366762), colorOf_2(0.944006, 0.377643, 0.365136), colorOf_2(0.94718, 0.384178, 0.363701), colorOf_2(0.95021, 0.39082, 0.362468), colorOf_2(0.953099, 0.397563, 0.361438), colorOf_2(0.955849, 0.4044, 0.360619), colorOf_2(0.958464, 0.411324, 0.360014), colorOf_2(0.960949, 0.418323, 0.35963), colorOf_2(0.96331, 0.42539, 0.359469), colorOf_2(0.965549, 0.432519, 0.359529), colorOf_2(0.967671, 0.439703, 0.35981), colorOf_2(0.96968, 0.446936, 0.360311), colorOf_2(0.971582, 0.45421, 0.36103), colorOf_2(0.973381, 0.46152, 0.361965), colorOf_2(0.975082, 0.468861, 0.363111), colorOf_2(0.97669, 0.476226, 0.364466), colorOf_2(0.97821, 0.483612, 0.366025), colorOf_2(0.979645, 0.491014, 0.367783), colorOf_2(0.981, 0.498428, 0.369734), colorOf_2(0.982279, 0.505851, 0.371874), colorOf_2(0.983485, 0.51328, 0.374198), colorOf_2(0.984622, 0.520713, 0.376698), colorOf_2(0.985693, 0.528148, 0.379371), colorOf_2(0.9867, 0.535582, 0.38221), colorOf_2(0.987646, 0.543015, 0.38521), colorOf_2(0.988533, 0.550446, 0.388365), colorOf_2(0.989363, 0.557873, 0.391671), colorOf_2(0.990138, 0.565296, 0.395122), colorOf_2(0.990871, 0.572706, 0.398714), colorOf_2(0.991558, 0.580107, 0.402441), colorOf_2(0.992196, 0.587502, 0.406299), colorOf_2(0.992785, 0.594891, 0.410283), colorOf_2(0.993326, 0.602275, 0.41439), colorOf_2(0.993834, 0.609644, 0.418613), colorOf_2(0.994309, 0.616999, 0.42295), colorOf_2(0.994738, 0.62435, 0.427397), colorOf_2(0.995122, 0.631696, 0.431951), colorOf_2(0.99548, 0.639027, 0.436607), colorOf_2(0.99581, 0.646344, 0.441361), colorOf_2(0.996096, 0.653659, 0.446213), colorOf_2(0.996341, 0.660969, 0.45116), colorOf_2(0.99658, 0.668256, 0.456192), colorOf_2(0.996775, 0.675541, 0.461314), colorOf_2(0.996925, 0.682828, 0.466526), colorOf_2(0.997077, 0.690088, 0.471811), colorOf_2(0.997186, 0.697349, 0.477182), colorOf_2(0.997254, 0.704611, 0.482635), colorOf_2(0.997325, 0.711848, 0.488154), colorOf_2(0.997351, 0.719089, 0.493755), colorOf_2(0.997351, 0.726324, 0.499428), colorOf_2(0.997341, 0.733545, 0.505167), colorOf_2(0.997285, 0.740772, 0.510983), colorOf_2(0.997228, 0.747981, 0.516859), colorOf_2(0.997138, 0.75519, 0.522806), colorOf_2(0.997019, 0.762398, 0.528821), colorOf_2(0.996898, 0.769591, 0.534892), colorOf_2(0.996727, 0.776795, 0.541039), colorOf_2(0.996571, 0.783977, 0.547233), colorOf_2(0.996369, 0.791167, 0.553499), colorOf_2(0.996162, 0.798348, 0.55982), colorOf_2(0.995932, 0.805527, 0.566202), colorOf_2(0.99568, 0.812706, 0.572645), colorOf_2(0.995424, 0.819875, 0.57914), colorOf_2(0.995131, 0.827052, 0.585701), colorOf_2(0.994851, 0.834213, 0.592307), colorOf_2(0.994524, 0.841387, 0.598983), colorOf_2(0.994222, 0.84854, 0.605696), colorOf_2(0.993866, 0.855711, 0.612482), colorOf_2(0.993545, 0.862859, 0.619299), colorOf_2(0.99317, 0.870024, 0.626189), colorOf_2(0.992831, 0.877168, 0.633109), colorOf_2(0.99244, 0.88433, 0.640099), colorOf_2(0.992089, 0.89147, 0.647116), colorOf_2(0.991688, 0.898627, 0.654202), colorOf_2(0.991332, 0.905763, 0.661309), colorOf_2(0.99093, 0.912915, 0.668481), colorOf_2(0.99057, 0.920049, 0.675675), colorOf_2(0.990175, 0.927196, 0.682926), colorOf_2(0.989815, 0.934329, 0.690198), colorOf_2(0.989434, 0.94147, 0.697519), colorOf_2(0.989077, 0.948604, 0.704863), colorOf_2(0.988717, 0.955742, 0.712242), colorOf_2(0.988367, 0.962878, 0.719649), colorOf_2(0.988033, 0.970012, 0.727077), colorOf_2(0.987691, 0.977154, 0.734536), colorOf_2(0.987387, 0.984288, 0.742002), colorOf_2(0.987053, 0.991438, 0.749504)])));
    this.s23_1 = new Entry_2('inferno', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.z20([colorOf_2(0.001462, 4.66E-4, 0.013866), colorOf_2(0.002267, 0.00127, 0.01857), colorOf_2(0.003299, 0.002249, 0.024239), colorOf_2(0.004547, 0.003392, 0.030909), colorOf_2(0.006006, 0.004692, 0.038558), colorOf_2(0.007676, 0.006136, 0.046836), colorOf_2(0.009561, 0.007713, 0.055143), colorOf_2(0.011663, 0.009417, 0.06346), colorOf_2(0.013995, 0.011225, 0.071862), colorOf_2(0.016561, 0.013136, 0.080282), colorOf_2(0.019373, 0.015133, 0.088767), colorOf_2(0.022447, 0.017199, 0.097327), colorOf_2(0.025793, 0.019331, 0.10593), colorOf_2(0.029432, 0.021503, 0.114621), colorOf_2(0.033385, 0.023702, 0.123397), colorOf_2(0.037668, 0.025921, 0.132232), colorOf_2(0.042253, 0.028139, 0.141141), colorOf_2(0.046915, 0.030324, 0.150164), colorOf_2(0.051644, 0.032474, 0.159254), colorOf_2(0.056449, 0.034569, 0.168414), colorOf_2(0.06134, 0.03659, 0.177642), colorOf_2(0.066331, 0.038504, 0.186962), colorOf_2(0.071429, 0.040294, 0.196354), colorOf_2(0.076637, 0.041905, 0.205799), colorOf_2(0.081962, 0.043328, 0.215289), colorOf_2(0.087411, 0.044556, 0.224813), colorOf_2(0.09299, 0.045583, 0.234358), colorOf_2(0.098702, 0.046402, 0.243904), colorOf_2(0.104551, 0.047008, 0.25343), colorOf_2(0.110536, 0.047399, 0.262912), colorOf_2(0.116656, 0.047574, 0.272321), colorOf_2(0.122908, 0.047536, 0.281624), colorOf_2(0.129285, 0.047293, 0.290788), colorOf_2(0.135778, 0.046856, 0.299776), colorOf_2(0.142378, 0.046242, 0.308553), colorOf_2(0.149073, 0.045468, 0.317085), colorOf_2(0.15585, 0.044559, 0.325338), colorOf_2(0.162689, 0.043554, 0.333277), colorOf_2(0.169575, 0.042489, 0.340874), colorOf_2(0.176493, 0.041402, 0.348111), colorOf_2(0.183429, 0.040329, 0.354971), colorOf_2(0.190367, 0.039309, 0.361447), colorOf_2(0.197297, 0.0384, 0.367535), colorOf_2(0.204209, 0.037632, 0.373238), colorOf_2(0.211095, 0.03703, 0.378563), colorOf_2(0.217949, 0.036615, 0.383522), colorOf_2(0.224763, 0.036405, 0.388129), colorOf_2(0.231538, 0.036405, 0.3924), colorOf_2(0.238273, 0.036621, 0.396353), colorOf_2(0.244967, 0.037055, 0.400007), colorOf_2(0.25162, 0.037705, 0.403378), colorOf_2(0.258234, 0.038571, 0.406485), colorOf_2(0.26481, 0.039647, 0.409345), colorOf_2(0.271347, 0.040922, 0.411976), colorOf_2(0.27785, 0.042353, 0.414392), colorOf_2(0.284321, 0.043933, 0.416608), colorOf_2(0.290763, 0.045644, 0.418637), colorOf_2(0.297178, 0.04747, 0.420491), colorOf_2(0.303568, 0.049396, 0.422182), colorOf_2(0.309935, 0.051407, 0.423721), colorOf_2(0.316282, 0.05349, 0.425116), colorOf_2(0.32261, 0.055634, 0.426377), colorOf_2(0.328921, 0.057827, 0.427511), colorOf_2(0.335217, 0.06006, 0.428524), colorOf_2(0.3415, 0.062325, 0.429425), colorOf_2(0.347771, 0.064616, 0.430217), colorOf_2(0.354032, 0.066925, 0.430906), colorOf_2(0.360284, 0.069247, 0.431497), colorOf_2(0.366529, 0.071579, 0.431994), colorOf_2(0.372768, 0.073915, 0.4324), colorOf_2(0.379001, 0.076253, 0.432719), colorOf_2(0.385228, 0.078591, 0.432955), colorOf_2(0.391453, 0.080927, 0.433109), colorOf_2(0.397674, 0.083257, 0.433183), colorOf_2(0.403894, 0.08558, 0.433179), colorOf_2(0.410113, 0.087896, 0.433098), colorOf_2(0.416331, 0.090203, 0.432943), colorOf_2(0.422549, 0.092501, 0.432714), colorOf_2(0.428768, 0.09479, 0.432412), colorOf_2(0.434987, 0.097069, 0.432039), colorOf_2(0.441207, 0.099338, 0.431594), colorOf_2(0.447428, 0.101597, 0.43108), colorOf_2(0.453651, 0.103848, 0.430498), colorOf_2(0.459875, 0.106089, 0.429846), colorOf_2(0.4661, 0.108322, 0.429125), colorOf_2(0.472328, 0.110547, 0.428334), colorOf_2(0.478558, 0.112764, 0.427475), colorOf_2(0.484789, 0.114974, 0.426548), colorOf_2(0.491022, 0.117179, 0.425552), colorOf_2(0.497257, 0.119379, 0.424488), colorOf_2(0.503493, 0.121575, 0.423356), colorOf_2(0.50973, 0.123769, 0.422156), colorOf_2(0.515967, 0.12596, 0.420887), colorOf_2(0.522206, 0.12815, 0.419549), colorOf_2(0.528444, 0.130341, 0.418142), colorOf_2(0.534683, 0.132534, 0.416667), colorOf_2(0.54092, 0.134729, 0.415123), colorOf_2(0.547157, 0.136929, 0.413511), colorOf_2(0.553392, 0.139134, 0.411829), colorOf_2(0.559624, 0.141346, 0.410078), colorOf_2(0.565854, 0.143567, 0.408258), colorOf_2(0.572081, 0.145797, 0.406369), colorOf_2(0.578304, 0.148039, 0.404411), colorOf_2(0.584521, 0.150294, 0.402385), colorOf_2(0.590734, 0.152563, 0.40029), colorOf_2(0.59694, 0.154848, 0.398125), colorOf_2(0.603139, 0.157151, 0.395891), colorOf_2(0.60933, 0.159474, 0.393589), colorOf_2(0.615513, 0.161817, 0.391219), colorOf_2(0.621685, 0.164184, 0.388781), colorOf_2(0.627847, 0.166575, 0.386276), colorOf_2(0.633998, 0.168992, 0.383704), colorOf_2(0.640135, 0.171438, 0.381065), colorOf_2(0.64626, 0.173914, 0.378359), colorOf_2(0.652369, 0.176421, 0.375586), colorOf_2(0.658463, 0.178962, 0.372748), colorOf_2(0.66454, 0.181539, 0.369846), colorOf_2(0.670599, 0.184153, 0.366879), colorOf_2(0.676638, 0.186807, 0.363849), colorOf_2(0.682656, 0.189501, 0.360757), colorOf_2(0.688653, 0.192239, 0.357603), colorOf_2(0.694627, 0.195021, 0.354388), colorOf_2(0.700576, 0.197851, 0.351113), colorOf_2(0.7065, 0.200728, 0.347777), colorOf_2(0.712396, 0.203656, 0.344383), colorOf_2(0.718264, 0.206636, 0.340931), colorOf_2(0.724103, 0.20967, 0.337424), colorOf_2(0.729909, 0.212759, 0.333861), colorOf_2(0.735683, 0.215906, 0.330245), colorOf_2(0.741423, 0.219112, 0.326576), colorOf_2(0.747127, 0.222378, 0.322856), colorOf_2(0.752794, 0.225706, 0.319085), colorOf_2(0.758422, 0.229097, 0.315266), colorOf_2(0.76401, 0.232554, 0.311399), colorOf_2(0.769556, 0.236077, 0.307485), colorOf_2(0.775059, 0.239667, 0.303526), colorOf_2(0.780517, 0.243327, 0.299523), colorOf_2(0.785929, 0.247056, 0.295477), colorOf_2(0.791293, 0.250856, 0.29139), colorOf_2(0.796607, 0.254728, 0.287264), colorOf_2(0.801871, 0.258674, 0.283099), colorOf_2(0.807082, 0.262692, 0.278898), colorOf_2(0.812239, 0.266786, 0.274661), colorOf_2(0.817341, 0.270954, 0.27039), colorOf_2(0.822386, 0.275197, 0.266085), colorOf_2(0.827372, 0.279517, 0.26175), colorOf_2(0.832299, 0.283913, 0.257383), colorOf_2(0.837165, 0.288385, 0.252988), colorOf_2(0.841969, 0.292933, 0.248564), colorOf_2(0.846709, 0.297559, 0.244113), colorOf_2(0.851384, 0.30226, 0.239636), colorOf_2(0.855992, 0.307038, 0.235133), colorOf_2(0.860533, 0.311892, 0.230606), colorOf_2(0.865006, 0.316822, 0.226055), colorOf_2(0.869409, 0.321827, 0.221482), colorOf_2(0.873741, 0.326906, 0.216886), colorOf_2(0.878001, 0.33206, 0.212268), colorOf_2(0.882188, 0.337287, 0.207628), colorOf_2(0.886302, 0.342586, 0.202968), colorOf_2(0.890341, 0.347957, 0.198286), colorOf_2(0.894305, 0.353399, 0.193584), colorOf_2(0.898192, 0.358911, 0.18886), colorOf_2(0.902003, 0.364492, 0.184116), colorOf_2(0.905735, 0.37014, 0.17935), colorOf_2(0.90939, 0.375856, 0.174563), colorOf_2(0.912966, 0.381636, 0.169755), colorOf_2(0.916462, 0.387481, 0.164924), colorOf_2(0.919879, 0.393389, 0.16007), colorOf_2(0.923215, 0.399359, 0.155193), colorOf_2(0.92647, 0.405389, 0.150292), colorOf_2(0.929644, 0.411479, 0.145367), colorOf_2(0.932737, 0.417627, 0.140417), colorOf_2(0.935747, 0.423831, 0.13544), colorOf_2(0.938675, 0.430091, 0.130438), colorOf_2(0.941521, 0.436405, 0.125409), colorOf_2(0.944285, 0.442772, 0.120354), colorOf_2(0.946965, 0.449191, 0.115272), colorOf_2(0.949562, 0.45566, 0.110164), colorOf_2(0.952075, 0.462178, 0.105031), colorOf_2(0.954506, 0.468744, 0.099874), colorOf_2(0.956852, 0.475356, 0.094695), colorOf_2(0.959114, 0.482014, 0.089499), colorOf_2(0.961293, 0.488716, 0.084289), colorOf_2(0.963387, 0.495462, 0.079073), colorOf_2(0.965397, 0.502249, 0.073859), colorOf_2(0.967322, 0.509078, 0.068659), colorOf_2(0.969163, 0.515946, 0.063488), colorOf_2(0.970919, 0.522853, 0.058367), colorOf_2(0.97259, 0.529798, 0.053324), colorOf_2(0.974176, 0.53678, 0.048392), colorOf_2(0.975677, 0.543798, 0.043618), colorOf_2(0.977092, 0.55085, 0.03905), colorOf_2(0.978422, 0.557937, 0.034931), colorOf_2(0.979666, 0.565057, 0.031409), colorOf_2(0.980824, 0.572209, 0.028508), colorOf_2(0.981895, 0.579392, 0.02625), colorOf_2(0.982881, 0.586606, 0.024661), colorOf_2(0.983779, 0.593849, 0.02377), colorOf_2(0.984591, 0.601122, 0.023606), colorOf_2(0.985315, 0.608422, 0.024202), colorOf_2(0.985952, 0.61575, 0.025592), colorOf_2(0.986502, 0.623105, 0.027814), colorOf_2(0.986964, 0.630485, 0.030908), colorOf_2(0.987337, 0.63789, 0.034916), colorOf_2(0.987622, 0.64532, 0.039886), colorOf_2(0.987819, 0.652773, 0.045581), colorOf_2(0.987926, 0.66025, 0.05175), colorOf_2(0.987945, 0.667748, 0.058329), colorOf_2(0.987874, 0.675267, 0.065257), colorOf_2(0.987714, 0.682807, 0.072489), colorOf_2(0.987464, 0.690366, 0.07999), colorOf_2(0.987124, 0.697944, 0.087731), colorOf_2(0.986694, 0.70554, 0.095694), colorOf_2(0.986175, 0.713153, 0.103863), colorOf_2(0.985566, 0.720782, 0.112229), colorOf_2(0.984865, 0.728427, 0.120785), colorOf_2(0.984075, 0.736087, 0.129527), colorOf_2(0.983196, 0.743758, 0.138453), colorOf_2(0.982228, 0.751442, 0.147565), colorOf_2(0.981173, 0.759135, 0.156863), colorOf_2(0.980032, 0.766837, 0.166353), colorOf_2(0.978806, 0.774545, 0.176037), colorOf_2(0.977497, 0.782258, 0.185923), colorOf_2(0.976108, 0.789974, 0.196018), colorOf_2(0.974638, 0.797692, 0.206332), colorOf_2(0.973088, 0.805409, 0.216877), colorOf_2(0.971468, 0.813122, 0.227658), colorOf_2(0.969783, 0.820825, 0.238686), colorOf_2(0.968041, 0.828515, 0.249972), colorOf_2(0.966243, 0.836191, 0.261534), colorOf_2(0.964394, 0.843848, 0.273391), colorOf_2(0.962517, 0.851476, 0.285546), colorOf_2(0.960626, 0.859069, 0.29801), colorOf_2(0.95872, 0.866624, 0.31082), colorOf_2(0.956834, 0.874129, 0.323974), colorOf_2(0.954997, 0.881569, 0.337475), colorOf_2(0.953215, 0.888942, 0.351369), colorOf_2(0.951546, 0.896226, 0.365627), colorOf_2(0.950018, 0.903409, 0.380271), colorOf_2(0.948683, 0.910473, 0.395289), colorOf_2(0.947594, 0.917399, 0.410665), colorOf_2(0.946809, 0.924168, 0.426373), colorOf_2(0.946392, 0.930761, 0.442367), colorOf_2(0.946403, 0.937159, 0.458592), colorOf_2(0.946903, 0.943348, 0.47497), colorOf_2(0.947937, 0.949318, 0.491426), colorOf_2(0.949545, 0.955063, 0.50786), colorOf_2(0.95174, 0.960587, 0.524203), colorOf_2(0.954529, 0.965896, 0.540361), colorOf_2(0.957896, 0.971003, 0.556275), colorOf_2(0.961812, 0.975924, 0.571925), colorOf_2(0.966249, 0.980678, 0.587206), colorOf_2(0.971162, 0.985282, 0.602154), colorOf_2(0.976511, 0.989753, 0.61676), colorOf_2(0.982257, 0.994109, 0.631017), colorOf_2(0.988362, 0.998364, 0.644924)])));
    this.r23_1 = new Entry_2('plasma', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.z20([colorOf_2(0.050383, 0.029803, 0.527975), colorOf_2(0.063536, 0.028426, 0.533124), colorOf_2(0.075353, 0.027206, 0.538007), colorOf_2(0.086222, 0.026125, 0.542658), colorOf_2(0.096379, 0.025165, 0.547103), colorOf_2(0.10598, 0.024309, 0.551368), colorOf_2(0.115124, 0.023556, 0.555468), colorOf_2(0.123903, 0.022878, 0.559423), colorOf_2(0.132381, 0.022258, 0.56325), colorOf_2(0.140603, 0.021687, 0.566959), colorOf_2(0.148607, 0.021154, 0.570562), colorOf_2(0.156421, 0.020651, 0.574065), colorOf_2(0.16407, 0.020171, 0.577478), colorOf_2(0.171574, 0.019706, 0.580806), colorOf_2(0.17895, 0.019252, 0.584054), colorOf_2(0.186213, 0.018803, 0.587228), colorOf_2(0.193374, 0.018354, 0.59033), colorOf_2(0.200445, 0.017902, 0.593364), colorOf_2(0.207435, 0.017442, 0.596333), colorOf_2(0.21435, 0.016973, 0.599239), colorOf_2(0.221197, 0.016497, 0.602083), colorOf_2(0.227983, 0.016007, 0.604867), colorOf_2(0.234715, 0.015502, 0.607592), colorOf_2(0.241396, 0.014979, 0.610259), colorOf_2(0.248032, 0.014439, 0.612868), colorOf_2(0.254627, 0.013882, 0.615419), colorOf_2(0.261183, 0.013308, 0.617911), colorOf_2(0.267703, 0.012716, 0.620346), colorOf_2(0.274191, 0.012109, 0.622722), colorOf_2(0.280648, 0.011488, 0.625038), colorOf_2(0.287076, 0.010855, 0.627295), colorOf_2(0.293478, 0.010213, 0.62949), colorOf_2(0.299855, 0.009561, 0.631624), colorOf_2(0.30621, 0.008902, 0.633694), colorOf_2(0.312543, 0.008239, 0.6357), colorOf_2(0.318856, 0.007576, 0.63764), colorOf_2(0.32515, 0.006915, 0.639512), colorOf_2(0.331426, 0.006261, 0.641316), colorOf_2(0.337683, 0.005618, 0.643049), colorOf_2(0.343925, 0.004991, 0.64471), colorOf_2(0.35015, 0.004382, 0.646298), colorOf_2(0.356359, 0.003798, 0.64781), colorOf_2(0.362553, 0.003243, 0.649245), colorOf_2(0.368733, 0.002724, 0.650601), colorOf_2(0.374897, 0.002245, 0.651876), colorOf_2(0.381047, 0.001814, 0.653068), colorOf_2(0.387183, 0.001434, 0.654177), colorOf_2(0.393304, 0.001114, 0.655199), colorOf_2(0.399411, 8.59E-4, 0.656133), colorOf_2(0.405503, 6.78E-4, 0.656977), colorOf_2(0.41158, 5.77E-4, 0.65773), colorOf_2(0.417642, 5.64E-4, 0.65839), colorOf_2(0.423689, 6.46E-4, 0.658956), colorOf_2(0.429719, 8.31E-4, 0.659425), colorOf_2(0.435734, 0.001127, 0.659797), colorOf_2(0.441732, 0.00154, 0.660069), colorOf_2(0.447714, 0.00208, 0.66024), colorOf_2(0.453677, 0.002755, 0.66031), colorOf_2(0.459623, 0.003574, 0.660277), colorOf_2(0.46555, 0.004545, 0.660139), colorOf_2(0.471457, 0.005678, 0.659897), colorOf_2(0.477344, 0.00698, 0.659549), colorOf_2(0.48321, 0.00846, 0.659095), colorOf_2(0.489055, 0.010127, 0.658534), colorOf_2(0.494877, 0.01199, 0.657865), colorOf_2(0.500678, 0.014055, 0.657088), colorOf_2(0.506454, 0.016333, 0.656202), colorOf_2(0.512206, 0.018833, 0.655209), colorOf_2(0.517933, 0.021563, 0.654109), colorOf_2(0.523633, 0.024532, 0.652901), colorOf_2(0.529306, 0.027747, 0.651586), colorOf_2(0.534952, 0.031217, 0.650165), colorOf_2(0.54057, 0.03495, 0.64864), colorOf_2(0.546157, 0.038954, 0.64701), colorOf_2(0.551715, 0.043136, 0.645277), colorOf_2(0.557243, 0.047331, 0.643443), colorOf_2(0.562738, 0.051545, 0.641509), colorOf_2(0.568201, 0.055778, 0.639477), colorOf_2(0.573632, 0.060028, 0.637349), colorOf_2(0.579029, 0.064296, 0.635126), colorOf_2(0.584391, 0.068579, 0.632812), colorOf_2(0.589719, 0.072878, 0.630408), colorOf_2(0.595011, 0.07719, 0.627917), colorOf_2(0.600266, 0.081516, 0.625342), colorOf_2(0.605485, 0.085854, 0.622686), colorOf_2(0.610667, 0.090204, 0.619951), colorOf_2(0.615812, 0.094564, 0.61714), colorOf_2(0.620919, 0.098934, 0.614257), colorOf_2(0.625987, 0.103312, 0.611305), colorOf_2(0.631017, 0.107699, 0.608287), colorOf_2(0.636008, 0.112092, 0.605205), colorOf_2(0.640959, 0.116492, 0.602065), colorOf_2(0.645872, 0.120898, 0.598867), colorOf_2(0.650746, 0.125309, 0.595617), colorOf_2(0.65558, 0.129725, 0.592317), colorOf_2(0.660374, 0.134144, 0.588971), colorOf_2(0.665129, 0.138566, 0.585582), colorOf_2(0.669845, 0.142992, 0.582154), colorOf_2(0.674522, 0.147419, 0.578688), colorOf_2(0.67916, 0.151848, 0.575189), colorOf_2(0.683758, 0.156278, 0.57166), colorOf_2(0.688318, 0.160709, 0.568103), colorOf_2(0.69284, 0.165141, 0.564522), colorOf_2(0.697324, 0.169573, 0.560919), colorOf_2(0.701769, 0.174005, 0.557296), colorOf_2(0.706178, 0.178437, 0.553657), colorOf_2(0.710549, 0.182868, 0.550004), colorOf_2(0.714883, 0.187299, 0.546338), colorOf_2(0.719181, 0.191729, 0.542663), colorOf_2(0.723444, 0.196158, 0.538981), colorOf_2(0.72767, 0.200586, 0.535293), colorOf_2(0.731862, 0.205013, 0.531601), colorOf_2(0.736019, 0.209439, 0.527908), colorOf_2(0.740143, 0.213864, 0.524216), colorOf_2(0.744232, 0.218288, 0.520524), colorOf_2(0.748289, 0.222711, 0.516834), colorOf_2(0.752312, 0.227133, 0.513149), colorOf_2(0.756304, 0.231555, 0.509468), colorOf_2(0.760264, 0.235976, 0.505794), colorOf_2(0.764193, 0.240396, 0.502126), colorOf_2(0.76809, 0.244817, 0.498465), colorOf_2(0.771958, 0.249237, 0.494813), colorOf_2(0.775796, 0.253658, 0.491171), colorOf_2(0.779604, 0.258078, 0.487539), colorOf_2(0.783383, 0.2625, 0.483918), colorOf_2(0.787133, 0.266922, 0.480307), colorOf_2(0.790855, 0.271345, 0.476706), colorOf_2(0.794549, 0.27577, 0.473117), colorOf_2(0.798216, 0.280197, 0.469538), colorOf_2(0.801855, 0.284626, 0.465971), colorOf_2(0.805467, 0.289057, 0.462415), colorOf_2(0.809052, 0.293491, 0.45887), colorOf_2(0.812612, 0.297928, 0.455338), colorOf_2(0.816144, 0.302368, 0.451816), colorOf_2(0.819651, 0.306812, 0.448306), colorOf_2(0.823132, 0.311261, 0.444806), colorOf_2(0.826588, 0.315714, 0.441316), colorOf_2(0.830018, 0.320172, 0.437836), colorOf_2(0.833422, 0.324635, 0.434366), colorOf_2(0.836801, 0.329105, 0.430905), colorOf_2(0.840155, 0.33358, 0.427455), colorOf_2(0.843484, 0.338062, 0.424013), colorOf_2(0.846788, 0.342551, 0.420579), colorOf_2(0.850066, 0.347048, 0.417153), colorOf_2(0.853319, 0.351553, 0.413734), colorOf_2(0.856547, 0.356066, 0.410322), colorOf_2(0.85975, 0.360588, 0.406917), colorOf_2(0.862927, 0.365119, 0.403519), colorOf_2(0.866078, 0.36966, 0.400126), colorOf_2(0.869203, 0.374212, 0.396738), colorOf_2(0.872303, 0.378774, 0.393355), colorOf_2(0.875376, 0.383347, 0.389976), colorOf_2(0.878423, 0.387932, 0.3866), colorOf_2(0.881443, 0.392529, 0.383229), colorOf_2(0.884436, 0.397139, 0.37986), colorOf_2(0.887402, 0.401762, 0.376494), colorOf_2(0.89034, 0.406398, 0.37313), colorOf_2(0.89325, 0.411048, 0.369768), colorOf_2(0.896131, 0.415712, 0.366407), colorOf_2(0.898984, 0.420392, 0.363047), colorOf_2(0.901807, 0.425087, 0.359688), colorOf_2(0.904601, 0.429797, 0.356329), colorOf_2(0.907365, 0.434524, 0.35297), colorOf_2(0.910098, 0.439268, 0.34961), colorOf_2(0.9128, 0.444029, 0.346251), colorOf_2(0.915471, 0.448807, 0.34289), colorOf_2(0.918109, 0.453603, 0.339529), colorOf_2(0.920714, 0.458417, 0.336166), colorOf_2(0.923287, 0.463251, 0.332801), colorOf_2(0.925825, 0.468103, 0.329435), colorOf_2(0.928329, 0.472975, 0.326067), colorOf_2(0.930798, 0.477867, 0.322697), colorOf_2(0.933232, 0.48278, 0.319325), colorOf_2(0.93563, 0.487712, 0.315952), colorOf_2(0.93799, 0.492667, 0.312575), colorOf_2(0.940313, 0.497642, 0.309197), colorOf_2(0.942598, 0.502639, 0.305816), colorOf_2(0.944844, 0.507658, 0.302433), colorOf_2(0.947051, 0.512699, 0.299049), colorOf_2(0.949217, 0.517763, 0.295662), colorOf_2(0.951344, 0.52285, 0.292275), colorOf_2(0.953428, 0.52796, 0.288883), colorOf_2(0.95547, 0.533093, 0.28549), colorOf_2(0.957469, 0.53825, 0.282096), colorOf_2(0.959424, 0.543431, 0.278701), colorOf_2(0.961336, 0.548636, 0.275305), colorOf_2(0.963203, 0.553865, 0.271909), colorOf_2(0.965024, 0.559118, 0.268513), colorOf_2(0.966798, 0.564396, 0.265118), colorOf_2(0.968526, 0.5697, 0.261721), colorOf_2(0.970205, 0.575028, 0.258325), colorOf_2(0.971835, 0.580382, 0.254931), colorOf_2(0.973416, 0.585761, 0.25154), colorOf_2(0.974947, 0.591165, 0.248151), colorOf_2(0.976428, 0.596595, 0.244767), colorOf_2(0.977856, 0.602051, 0.241387), colorOf_2(0.979233, 0.607532, 0.238013), colorOf_2(0.980556, 0.613039, 0.234646), colorOf_2(0.981826, 0.618572, 0.231287), colorOf_2(0.983041, 0.624131, 0.227937), colorOf_2(0.984199, 0.629718, 0.224595), colorOf_2(0.985301, 0.63533, 0.221265), colorOf_2(0.986345, 0.640969, 0.217948), colorOf_2(0.987332, 0.646633, 0.214648), colorOf_2(0.98826, 0.652325, 0.211364), colorOf_2(0.989128, 0.658043, 0.2081), colorOf_2(0.989935, 0.663787, 0.204859), colorOf_2(0.990681, 0.669558, 0.201642), colorOf_2(0.991365, 0.675355, 0.198453), colorOf_2(0.991985, 0.681179, 0.195295), colorOf_2(0.992541, 0.68703, 0.19217), colorOf_2(0.993032, 0.692907, 0.189084), colorOf_2(0.993456, 0.69881, 0.186041), colorOf_2(0.993814, 0.704741, 0.183043), colorOf_2(0.994103, 0.710698, 0.180097), colorOf_2(0.994324, 0.716681, 0.177208), colorOf_2(0.994474, 0.722691, 0.174381), colorOf_2(0.994553, 0.728728, 0.171622), colorOf_2(0.994561, 0.734791, 0.168938), colorOf_2(0.994495, 0.74088, 0.166335), colorOf_2(0.994355, 0.746995, 0.163821), colorOf_2(0.994141, 0.753137, 0.161404), colorOf_2(0.993851, 0.759304, 0.159092), colorOf_2(0.993482, 0.765499, 0.156891), colorOf_2(0.993033, 0.77172, 0.154808), colorOf_2(0.992505, 0.777967, 0.152855), colorOf_2(0.991897, 0.784239, 0.151042), colorOf_2(0.991209, 0.790537, 0.149377), colorOf_2(0.990439, 0.796859, 0.14787), colorOf_2(0.989587, 0.803205, 0.146529), colorOf_2(0.988648, 0.809579, 0.145357), colorOf_2(0.987621, 0.815978, 0.144363), colorOf_2(0.986509, 0.822401, 0.143557), colorOf_2(0.985314, 0.828846, 0.142945), colorOf_2(0.984031, 0.835315, 0.142528), colorOf_2(0.982653, 0.841812, 0.142303), colorOf_2(0.98119, 0.848329, 0.142279), colorOf_2(0.979644, 0.854866, 0.142453), colorOf_2(0.977995, 0.861432, 0.142808), colorOf_2(0.976265, 0.868016, 0.143351), colorOf_2(0.974443, 0.874622, 0.144061), colorOf_2(0.97253, 0.88125, 0.144923), colorOf_2(0.970533, 0.887896, 0.145919), colorOf_2(0.968443, 0.894564, 0.147014), colorOf_2(0.966271, 0.901249, 0.14818), colorOf_2(0.964021, 0.90795, 0.14937), colorOf_2(0.961681, 0.914672, 0.15052), colorOf_2(0.959276, 0.921407, 0.151566), colorOf_2(0.956808, 0.928152, 0.152409), colorOf_2(0.954287, 0.934908, 0.152921), colorOf_2(0.951726, 0.941671, 0.152925), colorOf_2(0.949151, 0.948435, 0.152178), colorOf_2(0.946602, 0.95519, 0.150328), colorOf_2(0.944152, 0.961916, 0.146861), colorOf_2(0.941896, 0.96859, 0.140956), colorOf_2(0.940015, 0.975158, 0.131326)])));
    this.p23_1 = new Entry_2('viridis', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.z20([colorOf_2(0.267004, 0.004874, 0.329415), colorOf_2(0.26851, 0.009605, 0.335427), colorOf_2(0.269944, 0.014625, 0.341379), colorOf_2(0.271305, 0.019942, 0.347269), colorOf_2(0.272594, 0.025563, 0.353093), colorOf_2(0.273809, 0.031497, 0.358853), colorOf_2(0.274952, 0.037752, 0.364543), colorOf_2(0.276022, 0.044167, 0.370164), colorOf_2(0.277018, 0.050344, 0.375715), colorOf_2(0.277941, 0.056324, 0.381191), colorOf_2(0.278791, 0.062145, 0.386592), colorOf_2(0.279566, 0.067836, 0.391917), colorOf_2(0.280267, 0.073417, 0.397163), colorOf_2(0.280894, 0.078907, 0.402329), colorOf_2(0.281446, 0.08432, 0.407414), colorOf_2(0.281924, 0.089666, 0.412415), colorOf_2(0.282327, 0.094955, 0.417331), colorOf_2(0.282656, 0.100196, 0.42216), colorOf_2(0.28291, 0.105393, 0.426902), colorOf_2(0.283091, 0.110553, 0.431554), colorOf_2(0.283197, 0.11568, 0.436115), colorOf_2(0.283229, 0.120777, 0.440584), colorOf_2(0.283187, 0.125848, 0.44496), colorOf_2(0.283072, 0.130895, 0.449241), colorOf_2(0.282884, 0.13592, 0.453427), colorOf_2(0.282623, 0.140926, 0.457517), colorOf_2(0.28229, 0.145912, 0.46151), colorOf_2(0.281887, 0.150881, 0.465405), colorOf_2(0.281412, 0.155834, 0.469201), colorOf_2(0.280868, 0.160771, 0.472899), colorOf_2(0.280255, 0.165693, 0.476498), colorOf_2(0.279574, 0.170599, 0.479997), colorOf_2(0.278826, 0.17549, 0.483397), colorOf_2(0.278012, 0.180367, 0.486697), colorOf_2(0.277134, 0.185228, 0.489898), colorOf_2(0.276194, 0.190074, 0.493001), colorOf_2(0.275191, 0.194905, 0.496005), colorOf_2(0.274128, 0.199721, 0.498911), colorOf_2(0.273006, 0.20452, 0.501721), colorOf_2(0.271828, 0.209303, 0.504434), colorOf_2(0.270595, 0.214069, 0.507052), colorOf_2(0.269308, 0.218818, 0.509577), colorOf_2(0.267968, 0.223549, 0.512008), colorOf_2(0.26658, 0.228262, 0.514349), colorOf_2(0.265145, 0.232956, 0.516599), colorOf_2(0.263663, 0.237631, 0.518762), colorOf_2(0.262138, 0.242286, 0.520837), colorOf_2(0.260571, 0.246922, 0.522828), colorOf_2(0.258965, 0.251537, 0.524736), colorOf_2(0.257322, 0.25613, 0.526563), colorOf_2(0.255645, 0.260703, 0.528312), colorOf_2(0.253935, 0.265254, 0.529983), colorOf_2(0.252194, 0.269783, 0.531579), colorOf_2(0.250425, 0.27429, 0.533103), colorOf_2(0.248629, 0.278775, 0.534556), colorOf_2(0.246811, 0.283237, 0.535941), colorOf_2(0.244972, 0.287675, 0.53726), colorOf_2(0.243113, 0.292092, 0.538516), colorOf_2(0.241237, 0.296485, 0.539709), colorOf_2(0.239346, 0.300855, 0.540844), colorOf_2(0.237441, 0.305202, 0.541921), colorOf_2(0.235526, 0.309527, 0.542944), colorOf_2(0.233603, 0.313828, 0.543914), colorOf_2(0.231674, 0.318106, 0.544834), colorOf_2(0.229739, 0.322361, 0.545706), colorOf_2(0.227802, 0.326594, 0.546532), colorOf_2(0.225863, 0.330805, 0.547314), colorOf_2(0.223925, 0.334994, 0.548053), colorOf_2(0.221989, 0.339161, 0.548752), colorOf_2(0.220057, 0.343307, 0.549413), colorOf_2(0.21813, 0.347432, 0.550038), colorOf_2(0.21621, 0.351535, 0.550627), colorOf_2(0.214298, 0.355619, 0.551184), colorOf_2(0.212395, 0.359683, 0.55171), colorOf_2(0.210503, 0.363727, 0.552206), colorOf_2(0.208623, 0.367752, 0.552675), colorOf_2(0.206756, 0.371758, 0.553117), colorOf_2(0.204903, 0.375746, 0.553533), colorOf_2(0.203063, 0.379716, 0.553925), colorOf_2(0.201239, 0.38367, 0.554294), colorOf_2(0.19943, 0.387607, 0.554642), colorOf_2(0.197636, 0.391528, 0.554969), colorOf_2(0.19586, 0.395433, 0.555276), colorOf_2(0.1941, 0.399323, 0.555565), colorOf_2(0.192357, 0.403199, 0.555836), colorOf_2(0.190631, 0.407061, 0.556089), colorOf_2(0.188923, 0.41091, 0.556326), colorOf_2(0.187231, 0.414746, 0.556547), colorOf_2(0.185556, 0.41857, 0.556753), colorOf_2(0.183898, 0.422383, 0.556944), colorOf_2(0.182256, 0.426184, 0.55712), colorOf_2(0.180629, 0.429975, 0.557282), colorOf_2(0.179019, 0.433756, 0.55743), colorOf_2(0.177423, 0.437527, 0.557565), colorOf_2(0.175841, 0.44129, 0.557685), colorOf_2(0.174274, 0.445044, 0.557792), colorOf_2(0.172719, 0.448791, 0.557885), colorOf_2(0.171176, 0.45253, 0.557965), colorOf_2(0.169646, 0.456262, 0.55803), colorOf_2(0.168126, 0.459988, 0.558082), colorOf_2(0.166617, 0.463708, 0.558119), colorOf_2(0.165117, 0.467423, 0.558141), colorOf_2(0.163625, 0.471133, 0.558148), colorOf_2(0.162142, 0.474838, 0.55814), colorOf_2(0.160665, 0.47854, 0.558115), colorOf_2(0.159194, 0.482237, 0.558073), colorOf_2(0.157729, 0.485932, 0.558013), colorOf_2(0.15627, 0.489624, 0.557936), colorOf_2(0.154815, 0.493313, 0.55784), colorOf_2(0.153364, 0.497, 0.557724), colorOf_2(0.151918, 0.500685, 0.557587), colorOf_2(0.150476, 0.504369, 0.55743), colorOf_2(0.149039, 0.508051, 0.55725), colorOf_2(0.147607, 0.511733, 0.557049), colorOf_2(0.14618, 0.515413, 0.556823), colorOf_2(0.144759, 0.519093, 0.556572), colorOf_2(0.143343, 0.522773, 0.556295), colorOf_2(0.141935, 0.526453, 0.555991), colorOf_2(0.140536, 0.530132, 0.555659), colorOf_2(0.139147, 0.533812, 0.555298), colorOf_2(0.13777, 0.537492, 0.554906), colorOf_2(0.136408, 0.541173, 0.554483), colorOf_2(0.135066, 0.544853, 0.554029), colorOf_2(0.133743, 0.548535, 0.553541), colorOf_2(0.132444, 0.552216, 0.553018), colorOf_2(0.131172, 0.555899, 0.552459), colorOf_2(0.129933, 0.559582, 0.551864), colorOf_2(0.128729, 0.563265, 0.551229), colorOf_2(0.127568, 0.566949, 0.550556), colorOf_2(0.126453, 0.570633, 0.549841), colorOf_2(0.125394, 0.574318, 0.549086), colorOf_2(0.124395, 0.578002, 0.548287), colorOf_2(0.123463, 0.581687, 0.547445), colorOf_2(0.122606, 0.585371, 0.546557), colorOf_2(0.121831, 0.589055, 0.545623), colorOf_2(0.121148, 0.592739, 0.544641), colorOf_2(0.120565, 0.596422, 0.543611), colorOf_2(0.120092, 0.600104, 0.54253), colorOf_2(0.119738, 0.603785, 0.5414), colorOf_2(0.119512, 0.607464, 0.540218), colorOf_2(0.119423, 0.611141, 0.538982), colorOf_2(0.119483, 0.614817, 0.537692), colorOf_2(0.119699, 0.61849, 0.536347), colorOf_2(0.120081, 0.622161, 0.534946), colorOf_2(0.120638, 0.625828, 0.533488), colorOf_2(0.12138, 0.629492, 0.531973), colorOf_2(0.122312, 0.633153, 0.530398), colorOf_2(0.123444, 0.636809, 0.528763), colorOf_2(0.12478, 0.640461, 0.527068), colorOf_2(0.126326, 0.644107, 0.525311), colorOf_2(0.128087, 0.647749, 0.523491), colorOf_2(0.130067, 0.651384, 0.521608), colorOf_2(0.132268, 0.655014, 0.519661), colorOf_2(0.134692, 0.658636, 0.517649), colorOf_2(0.137339, 0.662252, 0.515571), colorOf_2(0.14021, 0.665859, 0.513427), colorOf_2(0.143303, 0.669459, 0.511215), colorOf_2(0.146616, 0.67305, 0.508936), colorOf_2(0.150148, 0.676631, 0.506589), colorOf_2(0.153894, 0.680203, 0.504172), colorOf_2(0.157851, 0.683765, 0.501686), colorOf_2(0.162016, 0.687316, 0.499129), colorOf_2(0.166383, 0.690856, 0.496502), colorOf_2(0.170948, 0.694384, 0.493803), colorOf_2(0.175707, 0.6979, 0.491033), colorOf_2(0.180653, 0.701402, 0.488189), colorOf_2(0.185783, 0.704891, 0.485273), colorOf_2(0.19109, 0.708366, 0.482284), colorOf_2(0.196571, 0.711827, 0.479221), colorOf_2(0.202219, 0.715272, 0.476084), colorOf_2(0.20803, 0.718701, 0.472873), colorOf_2(0.214, 0.722114, 0.469588), colorOf_2(0.220124, 0.725509, 0.466226), colorOf_2(0.226397, 0.728888, 0.462789), colorOf_2(0.232815, 0.732247, 0.459277), colorOf_2(0.239374, 0.735588, 0.455688), colorOf_2(0.24607, 0.73891, 0.452024), colorOf_2(0.252899, 0.742211, 0.448284), colorOf_2(0.259857, 0.745492, 0.444467), colorOf_2(0.266941, 0.748751, 0.440573), colorOf_2(0.274149, 0.751988, 0.436601), colorOf_2(0.281477, 0.755203, 0.432552), colorOf_2(0.288921, 0.758394, 0.428426), colorOf_2(0.296479, 0.761561, 0.424223), colorOf_2(0.304148, 0.764704, 0.419943), colorOf_2(0.311925, 0.767822, 0.415586), colorOf_2(0.319809, 0.770914, 0.411152), colorOf_2(0.327796, 0.77398, 0.40664), colorOf_2(0.335885, 0.777018, 0.402049), colorOf_2(0.344074, 0.780029, 0.397381), colorOf_2(0.35236, 0.783011, 0.392636), colorOf_2(0.360741, 0.785964, 0.387814), colorOf_2(0.369214, 0.788888, 0.382914), colorOf_2(0.377779, 0.791781, 0.377939), colorOf_2(0.386433, 0.794644, 0.372886), colorOf_2(0.395174, 0.797475, 0.367757), colorOf_2(0.404001, 0.800275, 0.362552), colorOf_2(0.412913, 0.803041, 0.357269), colorOf_2(0.421908, 0.805774, 0.35191), colorOf_2(0.430983, 0.808473, 0.346476), colorOf_2(0.440137, 0.811138, 0.340967), colorOf_2(0.449368, 0.813768, 0.335384), colorOf_2(0.458674, 0.816363, 0.329727), colorOf_2(0.468053, 0.818921, 0.323998), colorOf_2(0.477504, 0.821444, 0.318195), colorOf_2(0.487026, 0.823929, 0.312321), colorOf_2(0.496615, 0.826376, 0.306377), colorOf_2(0.506271, 0.828786, 0.300362), colorOf_2(0.515992, 0.831158, 0.294279), colorOf_2(0.525776, 0.833491, 0.288127), colorOf_2(0.535621, 0.835785, 0.281908), colorOf_2(0.545524, 0.838039, 0.275626), colorOf_2(0.555484, 0.840254, 0.269281), colorOf_2(0.565498, 0.84243, 0.262877), colorOf_2(0.575563, 0.844566, 0.256415), colorOf_2(0.585678, 0.846661, 0.249897), colorOf_2(0.595839, 0.848717, 0.243329), colorOf_2(0.606045, 0.850733, 0.236712), colorOf_2(0.616293, 0.852709, 0.230052), colorOf_2(0.626579, 0.854645, 0.223353), colorOf_2(0.636902, 0.856542, 0.21662), colorOf_2(0.647257, 0.8584, 0.209861), colorOf_2(0.657642, 0.860219, 0.203082), colorOf_2(0.668054, 0.861999, 0.196293), colorOf_2(0.678489, 0.863742, 0.189503), colorOf_2(0.688944, 0.865448, 0.182725), colorOf_2(0.699415, 0.867117, 0.175971), colorOf_2(0.709898, 0.868751, 0.169257), colorOf_2(0.720391, 0.87035, 0.162603), colorOf_2(0.730889, 0.871916, 0.156029), colorOf_2(0.741388, 0.873449, 0.149561), colorOf_2(0.751884, 0.874951, 0.143228), colorOf_2(0.762373, 0.876424, 0.137064), colorOf_2(0.772852, 0.877868, 0.131109), colorOf_2(0.783315, 0.879285, 0.125405), colorOf_2(0.79376, 0.880678, 0.120005), colorOf_2(0.804182, 0.882046, 0.114965), colorOf_2(0.814576, 0.883393, 0.110347), colorOf_2(0.82494, 0.88472, 0.106217), colorOf_2(0.83527, 0.886029, 0.102646), colorOf_2(0.845561, 0.887322, 0.099702), colorOf_2(0.85581, 0.888601, 0.097452), colorOf_2(0.866013, 0.889868, 0.095953), colorOf_2(0.876168, 0.891125, 0.09525), colorOf_2(0.886271, 0.892374, 0.095374), colorOf_2(0.89632, 0.893616, 0.096335), colorOf_2(0.906311, 0.894855, 0.098125), colorOf_2(0.916242, 0.896091, 0.100717), colorOf_2(0.926106, 0.89733, 0.104071), colorOf_2(0.935904, 0.89857, 0.108131), colorOf_2(0.945636, 0.899815, 0.112838), colorOf_2(0.9553, 0.901065, 0.118128), colorOf_2(0.964894, 0.902323, 0.123941), colorOf_2(0.974417, 0.90359, 0.130215), colorOf_2(0.983868, 0.904867, 0.136897), colorOf_2(0.993248, 0.906157, 0.143936)])));
    this.t23_1 = new Entry_2('cividis', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.z20([colorOf_2(0.0, 0.135112, 0.304751), colorOf_2(0.0, 0.138068, 0.311105), colorOf_2(0.0, 0.141013, 0.317579), colorOf_2(0.0, 0.143951, 0.323982), colorOf_2(0.0, 0.146877, 0.330479), colorOf_2(0.0, 0.149791, 0.337065), colorOf_2(0.0, 0.152673, 0.343704), colorOf_2(0.0, 0.155377, 0.3505), colorOf_2(0.0, 0.157932, 0.357521), colorOf_2(0.0, 0.160495, 0.364534), colorOf_2(0.0, 0.163058, 0.371608), colorOf_2(0.0, 0.165621, 0.378769), colorOf_2(0.0, 0.168204, 0.385902), colorOf_2(0.0, 0.1708, 0.3931), colorOf_2(0.0, 0.17342, 0.400353), colorOf_2(0.0, 0.176082, 0.407577), colorOf_2(0.0, 0.178802, 0.414764), colorOf_2(0.0, 0.18161, 0.421859), colorOf_2(0.0, 0.18455, 0.428802), colorOf_2(0.0, 0.186915, 0.435532), colorOf_2(0.0, 0.188769, 0.439563), colorOf_2(0.0, 0.19095, 0.441085), colorOf_2(0.0, 0.193366, 0.441561), colorOf_2(0.003602, 0.195911, 0.441564), colorOf_2(0.017852, 0.198528, 0.441248), colorOf_2(0.03211, 0.201199, 0.440785), colorOf_2(0.046205, 0.203903, 0.440196), colorOf_2(0.058378, 0.206629, 0.439531), colorOf_2(0.068968, 0.209372, 0.438863), colorOf_2(0.078624, 0.212122, 0.438105), colorOf_2(0.087465, 0.214879, 0.437342), colorOf_2(0.095645, 0.217643, 0.436593), colorOf_2(0.103401, 0.220406, 0.43579), colorOf_2(0.110658, 0.22317, 0.435067), colorOf_2(0.117612, 0.225935, 0.434308), colorOf_2(0.124291, 0.228697, 0.433547), colorOf_2(0.130669, 0.231458, 0.43284), colorOf_2(0.13683, 0.234216, 0.432148), colorOf_2(0.142852, 0.236972, 0.431404), colorOf_2(0.148638, 0.239724, 0.430752), colorOf_2(0.154261, 0.242475, 0.43012), colorOf_2(0.159733, 0.245221, 0.429528), colorOf_2(0.165113, 0.247965, 0.428908), colorOf_2(0.170362, 0.250707, 0.428325), colorOf_2(0.17549, 0.253444, 0.42779), colorOf_2(0.180503, 0.25618, 0.427299), colorOf_2(0.185453, 0.258914, 0.426788), colorOf_2(0.190303, 0.261644, 0.426329), colorOf_2(0.195057, 0.264372, 0.425924), colorOf_2(0.199764, 0.267099, 0.425497), colorOf_2(0.204385, 0.269823, 0.425126), colorOf_2(0.208926, 0.272546, 0.424809), colorOf_2(0.213431, 0.275266, 0.42448), colorOf_2(0.217863, 0.277985, 0.424206), colorOf_2(0.222264, 0.280702, 0.423914), colorOf_2(0.226598, 0.283419, 0.423678), colorOf_2(0.230871, 0.286134, 0.423498), colorOf_2(0.23512, 0.288848, 0.423304), colorOf_2(0.239312, 0.291562, 0.423167), colorOf_2(0.243485, 0.294274, 0.423014), colorOf_2(0.247605, 0.296986, 0.422917), colorOf_2(0.251675, 0.299698, 0.422873), colorOf_2(0.255731, 0.302409, 0.422814), colorOf_2(0.25974, 0.30512, 0.42281), colorOf_2(0.263738, 0.307831, 0.422789), colorOf_2(0.267693, 0.310542, 0.422821), colorOf_2(0.271639, 0.313253, 0.422837), colorOf_2(0.275513, 0.315965, 0.422979), colorOf_2(0.279411, 0.318677, 0.423031), colorOf_2(0.28324, 0.32139, 0.423211), colorOf_2(0.287065, 0.324103, 0.423373), colorOf_2(0.290884, 0.326816, 0.423517), colorOf_2(0.294669, 0.329531, 0.423716), colorOf_2(0.298421, 0.332247, 0.423973), colorOf_2(0.302169, 0.334963, 0.424213), colorOf_2(0.305886, 0.337681, 0.424512), colorOf_2(0.309601, 0.340399, 0.42479), colorOf_2(0.313287, 0.34312, 0.42512), colorOf_2(0.316941, 0.345842, 0.425512), colorOf_2(0.320595, 0.348565, 0.425889), colorOf_2(0.32425, 0.351289, 0.42625), colorOf_2(0.327875, 0.354016, 0.42667), colorOf_2(0.331474, 0.356744, 0.427144), colorOf_2(0.335073, 0.359474, 0.427605), colorOf_2(0.338673, 0.362206, 0.428053), colorOf_2(0.342246, 0.364939, 0.428559), colorOf_2(0.345793, 0.367676, 0.429127), colorOf_2(0.349341, 0.370414, 0.429685), colorOf_2(0.352892, 0.373153, 0.430226), colorOf_2(0.356418, 0.375896, 0.430823), colorOf_2(0.359916, 0.378641, 0.431501), colorOf_2(0.363446, 0.381388, 0.432075), colorOf_2(0.366923, 0.384139, 0.432796), colorOf_2(0.37043, 0.38689, 0.433428), colorOf_2(0.373884, 0.389646, 0.434209), colorOf_2(0.377371, 0.392404, 0.43489), colorOf_2(0.38083, 0.395164, 0.435653), colorOf_2(0.384268, 0.397928, 0.436475), colorOf_2(0.387705, 0.400694, 0.437305), colorOf_2(0.391151, 0.403464, 0.438096), colorOf_2(0.394568, 0.406236, 0.438986), colorOf_2(0.397991, 0.409011, 0.439848), colorOf_2(0.401418, 0.41179, 0.440708), colorOf_2(0.40482, 0.414572, 0.441642), colorOf_2(0.408226, 0.417357, 0.44257), colorOf_2(0.411607, 0.420145, 0.443577), colorOf_2(0.414992, 0.422937, 0.444578), colorOf_2(0.418383, 0.425733, 0.44556), colorOf_2(0.421748, 0.428531, 0.44664), colorOf_2(0.42512, 0.431334, 0.447692), colorOf_2(0.428462, 0.43414, 0.448864), colorOf_2(0.431817, 0.43695, 0.449982), colorOf_2(0.435168, 0.439763, 0.451134), colorOf_2(0.438504, 0.44258, 0.452341), colorOf_2(0.44181, 0.445402, 0.453659), colorOf_2(0.445148, 0.448226, 0.454885), colorOf_2(0.448447, 0.451053, 0.456264), colorOf_2(0.451759, 0.453887, 0.457582), colorOf_2(0.455072, 0.456718, 0.458976), colorOf_2(0.458366, 0.459552, 0.460457), colorOf_2(0.461616, 0.462405, 0.461969), colorOf_2(0.464947, 0.465241, 0.463395), colorOf_2(0.468254, 0.468083, 0.464908), colorOf_2(0.471501, 0.47096, 0.466357), colorOf_2(0.474812, 0.473832, 0.467681), colorOf_2(0.478186, 0.476699, 0.468845), colorOf_2(0.481622, 0.479573, 0.469767), colorOf_2(0.485141, 0.482451, 0.470384), colorOf_2(0.488697, 0.485318, 0.471008), colorOf_2(0.492278, 0.488198, 0.471453), colorOf_2(0.495913, 0.491076, 0.471751), colorOf_2(0.499552, 0.49396, 0.472032), colorOf_2(0.503185, 0.496851, 0.472305), colorOf_2(0.506866, 0.499743, 0.472432), colorOf_2(0.51054, 0.502643, 0.47255), colorOf_2(0.514226, 0.505546, 0.47264), colorOf_2(0.51792, 0.508454, 0.472707), colorOf_2(0.521643, 0.511367, 0.472639), colorOf_2(0.525348, 0.514285, 0.47266), colorOf_2(0.529086, 0.517207, 0.472543), colorOf_2(0.532829, 0.520135, 0.472401), colorOf_2(0.536553, 0.523067, 0.472352), colorOf_2(0.540307, 0.526005, 0.472163), colorOf_2(0.544069, 0.528948, 0.471947), colorOf_2(0.54784, 0.531895, 0.471704), colorOf_2(0.551612, 0.534849, 0.471439), colorOf_2(0.555393, 0.537807, 0.471147), colorOf_2(0.559181, 0.540771, 0.470829), colorOf_2(0.562972, 0.543741, 0.470488), colorOf_2(0.566802, 0.546715, 0.469988), colorOf_2(0.570607, 0.549695, 0.469593), colorOf_2(0.574417, 0.552682, 0.469172), colorOf_2(0.578236, 0.555673, 0.468724), colorOf_2(0.582087, 0.55867, 0.468118), colorOf_2(0.585916, 0.561674, 0.467618), colorOf_2(0.589753, 0.564682, 0.46709), colorOf_2(0.593622, 0.567697, 0.466401), colorOf_2(0.597469, 0.570718, 0.465821), colorOf_2(0.601354, 0.573743, 0.465074), colorOf_2(0.605211, 0.576777, 0.464441), colorOf_2(0.609105, 0.579816, 0.463638), colorOf_2(0.612977, 0.582861, 0.46295), colorOf_2(0.616852, 0.585913, 0.462237), colorOf_2(0.620765, 0.58897, 0.461351), colorOf_2(0.624654, 0.592034, 0.460583), colorOf_2(0.628576, 0.595104, 0.459641), colorOf_2(0.632506, 0.59818, 0.458668), colorOf_2(0.636412, 0.601264, 0.457818), colorOf_2(0.640352, 0.604354, 0.456791), colorOf_2(0.64427, 0.60745, 0.455886), colorOf_2(0.648222, 0.610553, 0.454801), colorOf_2(0.652178, 0.613664, 0.453689), colorOf_2(0.656114, 0.61678, 0.452702), colorOf_2(0.660082, 0.619904, 0.451534), colorOf_2(0.664055, 0.623034, 0.450338), colorOf_2(0.668008, 0.626171, 0.44927), colorOf_2(0.671991, 0.629316, 0.448018), colorOf_2(0.675981, 0.632468, 0.446736), colorOf_2(0.679979, 0.635626, 0.445424), colorOf_2(0.68395, 0.638793, 0.444251), colorOf_2(0.687957, 0.641966, 0.442886), colorOf_2(0.691971, 0.645145, 0.441491), colorOf_2(0.695985, 0.648334, 0.440072), colorOf_2(0.700008, 0.651529, 0.438624), colorOf_2(0.704037, 0.654731, 0.437147), colorOf_2(0.708067, 0.657942, 0.435647), colorOf_2(0.712105, 0.66116, 0.434117), colorOf_2(0.716177, 0.664384, 0.432386), colorOf_2(0.720222, 0.667618, 0.430805), colorOf_2(0.724274, 0.670859, 0.429194), colorOf_2(0.728334, 0.674107, 0.427554), colorOf_2(0.732422, 0.677364, 0.425717), colorOf_2(0.736488, 0.680629, 0.424028), colorOf_2(0.740589, 0.6839, 0.422131), colorOf_2(0.744664, 0.687181, 0.420393), colorOf_2(0.748772, 0.69047, 0.418448), colorOf_2(0.752886, 0.693766, 0.416472), colorOf_2(0.756975, 0.697071, 0.414659), colorOf_2(0.761096, 0.700384, 0.412638), colorOf_2(0.765223, 0.703705, 0.410587), colorOf_2(0.769353, 0.707035, 0.408516), colorOf_2(0.773486, 0.710373, 0.406422), colorOf_2(0.777651, 0.713719, 0.404112), colorOf_2(0.781795, 0.717074, 0.401966), colorOf_2(0.785965, 0.720438, 0.399613), colorOf_2(0.790116, 0.72381, 0.397423), colorOf_2(0.794298, 0.72719, 0.395016), colorOf_2(0.79848, 0.73058, 0.392597), colorOf_2(0.802667, 0.733978, 0.390153), colorOf_2(0.806859, 0.737385, 0.387684), colorOf_2(0.811054, 0.740801, 0.385198), colorOf_2(0.815274, 0.744226, 0.382504), colorOf_2(0.819499, 0.747659, 0.379785), colorOf_2(0.823729, 0.751101, 0.377043), colorOf_2(0.827959, 0.754553, 0.374292), colorOf_2(0.832192, 0.758014, 0.371529), colorOf_2(0.836429, 0.761483, 0.368747), colorOf_2(0.840693, 0.764962, 0.365746), colorOf_2(0.844957, 0.76845, 0.362741), colorOf_2(0.849223, 0.771947, 0.359729), colorOf_2(0.853515, 0.775454, 0.3565), colorOf_2(0.857809, 0.778969, 0.353259), colorOf_2(0.862105, 0.782494, 0.350011), colorOf_2(0.866421, 0.786028, 0.346571), colorOf_2(0.870717, 0.789572, 0.343333), colorOf_2(0.875057, 0.793125, 0.339685), colorOf_2(0.879378, 0.796687, 0.336241), colorOf_2(0.88372, 0.800258, 0.332599), colorOf_2(0.888081, 0.803839, 0.32877), colorOf_2(0.89244, 0.80743, 0.324968), colorOf_2(0.896818, 0.81103, 0.320982), colorOf_2(0.901195, 0.814639, 0.317021), colorOf_2(0.905589, 0.818257, 0.312889), colorOf_2(0.91, 0.821885, 0.308594), colorOf_2(0.914407, 0.825522, 0.304348), colorOf_2(0.918828, 0.829168, 0.29996), colorOf_2(0.923279, 0.832822, 0.295244), colorOf_2(0.927724, 0.836486, 0.290611), colorOf_2(0.93218, 0.840159, 0.28588), colorOf_2(0.93666, 0.843841, 0.280876), colorOf_2(0.941147, 0.84753, 0.275815), colorOf_2(0.945654, 0.851228, 0.270532), colorOf_2(0.950178, 0.854933, 0.265085), colorOf_2(0.954725, 0.858646, 0.259365), colorOf_2(0.959284, 0.862365, 0.253563), colorOf_2(0.963872, 0.866089, 0.247445), colorOf_2(0.968469, 0.869819, 0.24131), colorOf_2(0.973114, 0.87355, 0.234677), colorOf_2(0.97778, 0.877281, 0.227954), colorOf_2(0.982497, 0.881008, 0.220878), colorOf_2(0.987293, 0.884718, 0.213336), colorOf_2(0.992218, 0.888385, 0.205468), colorOf_2(0.994847, 0.892954, 0.203445), colorOf_2(0.995249, 0.898384, 0.207561), colorOf_2(0.995503, 0.903866, 0.21237), colorOf_2(0.995737, 0.909344, 0.217772)])));
    this.u23_1 = new Entry_2('twilight', PaletteType_DIVERGING_getInstance(), InterpolatedPalette.paletteConstructor(FixedPalette.z20([colorOf_2(0.8857502, 0.85000926, 0.88797367), colorOf_2(0.8837852, 0.8507294, 0.88723224), colorOf_2(0.88172233, 0.8512759, 0.88638055), colorOf_2(0.87954104, 0.85165673, 0.88541436), colorOf_2(0.8772488, 0.8518703, 0.8843412), colorOf_2(0.8748535, 0.85191524, 0.8831693), colorOf_2(0.8723313, 0.85180163, 0.88189703), colorOf_2(0.8697047, 0.85152406, 0.8805388), colorOf_2(0.86696017, 0.8510896, 0.87909764), colorOf_2(0.86408985, 0.8505039, 0.8775793), colorOf_2(0.86110246, 0.84976757, 0.8759924), colorOf_2(0.8579826, 0.84888935, 0.8743404), colorOf_2(0.85472596, 0.8478749, 0.8726283), colorOf_2(0.85133713, 0.8467274, 0.8708608), colorOf_2(0.8478071, 0.84545463, 0.86904037), colorOf_2(0.84412616, 0.84406483, 0.86716974), colorOf_2(0.8403042, 0.8425606, 0.8652509), colorOf_2(0.8363403, 0.840948, 0.8632853), colorOf_2(0.83222705, 0.8392349, 0.8612756), colorOf_2(0.82796896, 0.837426, 0.859224), colorOf_2(0.8235743, 0.83552486, 0.8571319), colorOf_2(0.81904656, 0.8335365, 0.85500205), colorOf_2(0.8143898, 0.8314656, 0.85283756), colorOf_2(0.8096, 0.82931894, 0.8506444), colorOf_2(0.8046917, 0.82709837, 0.8484245), colorOf_2(0.79967076, 0.8248078, 0.8461821), colorOf_2(0.794543, 0.8224512, 0.84392184), colorOf_2(0.78931445, 0.8200321, 0.84164864), colorOf_2(0.78399104, 0.81755424, 0.83936745), colorOf_2(0.77857894, 0.8150209, 0.83708346), colorOf_2(0.77308416, 0.81243527, 0.83480173), colorOf_2(0.76751107, 0.80980074, 0.8325282), colorOf_2(0.7618691, 0.8071195, 0.8302665), colorOf_2(0.75616443, 0.80439407, 0.8280214), colorOf_2(0.75040346, 0.801627, 0.8257974), colorOf_2(0.7445925, 0.7988205, 0.8235987), colorOf_2(0.7387377, 0.79597664, 0.82142925), colorOf_2(0.7328454, 0.79309744, 0.8192926), colorOf_2(0.7269218, 0.7901847, 0.8171922), colorOf_2(0.72097284, 0.78723997, 0.8151307), colorOf_2(0.715004, 0.78426486, 0.8131112), colorOf_2(0.7090208, 0.7812609, 0.81113595), colorOf_2(0.70302975, 0.77822906, 0.8092062), colorOf_2(0.69703656, 0.7751705, 0.80732334), colorOf_2(0.6910464, 0.7720863, 0.8054884), colorOf_2(0.68506444, 0.7689774, 0.80370206), colorOf_2(0.67909557, 0.7658447, 0.80196464), colorOf_2(0.6731442, 0.7626891, 0.8002763), colorOf_2(0.6672148, 0.7595113, 0.79863673), colorOf_2(0.66131127, 0.756312, 0.7970456), colorOf_2(0.65543693, 0.7530921, 0.7955027), colorOf_2(0.64959574, 0.749852, 0.79400676), colorOf_2(0.6437911, 0.7465924, 0.7925565), colorOf_2(0.6380259, 0.7433138, 0.791151), colorOf_2(0.6323027, 0.7400167, 0.7897889), colorOf_2(0.62662405, 0.7367017, 0.788469), colorOf_2(0.62099195, 0.73336935, 0.78718996), colorOf_2(0.6154085, 0.7300199, 0.78595024), colorOf_2(0.60987544, 0.726654, 0.7847484), colorOf_2(0.6043943, 0.72327185, 0.783583), colorOf_2(0.5989666, 0.71987396, 0.7824526), colorOf_2(0.59359336, 0.7164606, 0.78135586), colorOf_2(0.5882758, 0.7130321, 0.78029144), colorOf_2(0.58301485, 0.7095889, 0.77925783), colorOf_2(0.57781166, 0.70613104, 0.77825344), colorOf_2(0.5726669, 0.70265895, 0.77727705), colorOf_2(0.5675812, 0.6991728, 0.7763275), colorOf_2(0.56255513, 0.6956728, 0.7754036), colorOf_2(0.5575894, 0.6921591, 0.7745041), colorOf_2(0.5526845, 0.68863195, 0.77362794), colorOf_2(0.54784095, 0.68509144, 0.77277386), colorOf_2(0.54305935, 0.6815377, 0.77194077), colorOf_2(0.53834015, 0.6779708, 0.77112734), colorOf_2(0.5336839, 0.6743909, 0.7703325), colorOf_2(0.5290909, 0.6707981, 0.7695555), colorOf_2(0.5245615, 0.66719246, 0.76879543), colorOf_2(0.5200963, 0.6635739, 0.7680512), colorOf_2(0.5156956, 0.6599426, 0.76732194), colorOf_2(0.51135993, 0.6562985, 0.7666066), colorOf_2(0.5070897, 0.6526417, 0.7659045), colorOf_2(0.50288534, 0.64897215, 0.76521444), colorOf_2(0.49874735, 0.6452899, 0.7645358), colorOf_2(0.49467617, 0.6415948, 0.7638672), colorOf_2(0.49067226, 0.63788706, 0.76320815), colorOf_2(0.48673597, 0.6341665, 0.7625578), colorOf_2(0.48286778, 0.630433, 0.7619154), colorOf_2(0.47906816, 0.62668675, 0.76128), colorOf_2(0.47533754, 0.62292755, 0.7606509), colorOf_2(0.4716763, 0.6191554, 0.7600271), colorOf_2(0.4680849, 0.6153703, 0.7594079), colorOf_2(0.46456376, 0.6115721, 0.7587924), colorOf_2(0.46111327, 0.6077608, 0.75817984), colorOf_2(0.45773378, 0.6039363, 0.7575694), colorOf_2(0.45442563, 0.6000986, 0.75696015), colorOf_2(0.4511892, 0.5962476, 0.75635123), colorOf_2(0.44802472, 0.5923833, 0.7557418), colorOf_2(0.44493246, 0.5885056, 0.7551311), colorOf_2(0.4419127, 0.5846144, 0.7545184), colorOf_2(0.43896565, 0.5807097, 0.75390273), colorOf_2(0.4360914, 0.5767914, 0.7532834), colorOf_2(0.4332901, 0.5728594, 0.75265944), colorOf_2(0.43056178, 0.56891376, 0.7520301), colorOf_2(0.4279065, 0.5649543, 0.75139445), colorOf_2(0.42532423, 0.56098104, 0.7507517), colorOf_2(0.42281485, 0.5569939, 0.75010085), colorOf_2(0.42037824, 0.5529929, 0.74944127), colorOf_2(0.41801414, 0.54897785, 0.7487719), colorOf_2(0.41572234, 0.5449488, 0.74809206), colorOf_2(0.41350245, 0.5409058, 0.74740076), colorOf_2(0.41135415, 0.5368486, 0.7466971), colorOf_2(0.4092769, 0.5327773, 0.7459803), colorOf_2(0.4072702, 0.5286919, 0.74524945), colorOf_2(0.40533343, 0.5245923, 0.7445037), colorOf_2(0.40346602, 0.5204785, 0.74374217), colorOf_2(0.40166715, 0.51635045, 0.742964), colorOf_2(0.39993608, 0.51220816, 0.7421684), colorOf_2(0.39827192, 0.5080517, 0.7413545), colorOf_2(0.39667374, 0.5038809, 0.7405214), colorOf_2(0.3951406, 0.49969587, 0.7396682), colorOf_2(0.39367136, 0.49549657, 0.7387941), colorOf_2(0.39226496, 0.491283, 0.73789823), colorOf_2(0.39092016, 0.4870552, 0.7369798), colorOf_2(0.3896358, 0.48281318, 0.73603785), colorOf_2(0.38841054, 0.4785569, 0.7350716), colorOf_2(0.387243, 0.47428647, 0.7340802), colorOf_2(0.38613185, 0.47000185, 0.7330628), colorOf_2(0.38507557, 0.46570307, 0.73201853), colorOf_2(0.3840727, 0.4613902, 0.73094666), colorOf_2(0.38312167, 0.45706323, 0.72984624), colorOf_2(0.38222095, 0.45272225, 0.72871655), colorOf_2(0.38136888, 0.44836727, 0.7275567), colorOf_2(0.3805638, 0.44399837, 0.72636586), colorOf_2(0.37980404, 0.43961558, 0.72514325), colorOf_2(0.3790879, 0.435219, 0.723888), colorOf_2(0.37841365, 0.4308086, 0.7225993), colorOf_2(0.37777948, 0.4263845, 0.7212764), colorOf_2(0.3771837, 0.4219468, 0.71991843), colorOf_2(0.3766245, 0.41749555, 0.7185246), colorOf_2(0.3761, 0.4130308, 0.71709394), colorOf_2(0.37560847, 0.40855268, 0.7156258), colorOf_2(0.37514803, 0.40406126, 0.7141194), colorOf_2(0.37471685, 0.39955664, 0.7125737), colorOf_2(0.37431315, 0.39503896, 0.710988), colorOf_2(0.37393498, 0.39050826, 0.7093613), colorOf_2(0.37358063, 0.38596475, 0.707693), colorOf_2(0.37324816, 0.38140848, 0.705982), colorOf_2(0.37293577, 0.37683964, 0.70422757), colorOf_2(0.37264165, 0.37225834, 0.70242876), colorOf_2(0.37236398, 0.36766478, 0.70058465), colorOf_2(0.3721009, 0.3630591, 0.69869435), colorOf_2(0.3718506, 0.35844147, 0.69675696), colorOf_2(0.37161133, 0.35381213, 0.6947715), colorOf_2(0.37138125, 0.34917128, 0.69273704), colorOf_2(0.37115857, 0.3445191, 0.69065255), colorOf_2(0.37094152, 0.3398559, 0.68851703), colorOf_2(0.37072834, 0.33518195, 0.6863295), colorOf_2(0.37051737, 0.3304974, 0.6840889), colorOf_2(0.37030682, 0.32580268, 0.6817941), colorOf_2(0.37009487, 0.32109815, 0.6794441), colorOf_2(0.3698798, 0.3163841, 0.67703754), colorOf_2(0.36965987, 0.31166098, 0.6745734), colorOf_2(0.36943334, 0.30692923, 0.67205054), colorOf_2(0.36919847, 0.30218932, 0.66946757), colorOf_2(0.36895356, 0.29744175, 0.6668232), colorOf_2(0.3686968, 0.2926871, 0.66411626), colorOf_2(0.36842656, 0.28792596, 0.66134524), colorOf_2(0.36814103, 0.28315902, 0.6585089), colorOf_2(0.36783844, 0.27838698, 0.6556057), colorOf_2(0.36751708, 0.27361062, 0.65263414), colorOf_2(0.36717513, 0.26883087, 0.6495927), colorOf_2(0.36681086, 0.26404858, 0.6464799), colorOf_2(0.36642244, 0.2592648, 0.6432941), colorOf_2(0.36600855, 0.25448045, 0.6400336), colorOf_2(0.36556697, 0.24969684, 0.63669676), colorOf_2(0.3650958, 0.24491537, 0.6332817), colorOf_2(0.3645931, 0.24013747, 0.6297868), colorOf_2(0.36405694, 0.2353647, 0.62621015), colorOf_2(0.36348537, 0.23059876, 0.6225499), colorOf_2(0.36287645, 0.22584149, 0.61880416), colorOf_2(0.3622281, 0.22109489, 0.6149711), colorOf_2(0.3615383, 0.21636112, 0.6110488), colorOf_2(0.36080495, 0.21164252, 0.60703534), colorOf_2(0.3600268, 0.20694123, 0.60292846), colorOf_2(0.3592009, 0.20226038, 0.5987265), colorOf_2(0.3583249, 0.19760294, 0.5944277), colorOf_2(0.35739663, 0.19297208, 0.59003013), colorOf_2(0.3564138, 0.1883712, 0.58553207), colorOf_2(0.35537416, 0.18380393, 0.5809319), colorOf_2(0.35427535, 0.17927413, 0.5762281), colorOf_2(0.35311574, 0.1747857, 0.5714187), colorOf_2(0.35189247, 0.1703432, 0.56650287), colorOf_2(0.35060304, 0.1659513, 0.5614796), colorOf_2(0.34924513, 0.16161478, 0.5563484), colorOf_2(0.34781653, 0.15733863, 0.55110854), colorOf_2(0.3463151, 0.15312803, 0.54576), colorOf_2(0.34473902, 0.1489882, 0.54030246), colorOf_2(0.343086, 0.14492466, 0.53473705), colorOf_2(0.3413541, 0.1409428, 0.529065), colorOf_2(0.33954167, 0.13704802, 0.52328795), colorOf_2(0.33764732, 0.13324562, 0.5174081), colorOf_2(0.3356698, 0.12954074, 0.51142806), colorOf_2(0.33360806, 0.12593818, 0.50535166), colorOf_2(0.33146155, 0.122442454, 0.49918276), colorOf_2(0.32923004, 0.11905764, 0.49292594), colorOf_2(0.3269137, 0.11578735, 0.48658645), colorOf_2(0.32451308, 0.1126346, 0.48017007), colorOf_2(0.32202882, 0.10960114, 0.47368494), colorOf_2(0.31946263, 0.1066888, 0.46713728), colorOf_2(0.31681648, 0.103898615, 0.46053416), colorOf_2(0.3140928, 0.10123078, 0.45388335), colorOf_2(0.31129435, 0.09868477, 0.44719315), colorOf_2(0.30842444, 0.096259385, 0.44047195), colorOf_2(0.30548677, 0.09395277, 0.4337285), colorOf_2(0.30248538, 0.09176119, 0.42697403), colorOf_2(0.29942483, 0.08968225, 0.4202162), colorOf_2(0.29631, 0.08771325, 0.41346258), colorOf_2(0.29314592, 0.085850656, 0.40672177), colorOf_2(0.2899379, 0.08409079, 0.40000215), colorOf_2(0.28669152, 0.08242987, 0.39331183), colorOf_2(0.2834124, 0.080864154, 0.3866587), colorOf_2(0.2801064, 0.07939, 0.38005027), colorOf_2(0.27677938, 0.07800394, 0.37349382), colorOf_2(0.27343738, 0.0767028, 0.36699617), colorOf_2(0.27008638, 0.07548367, 0.36056376), colorOf_2(0.26673234, 0.07434402, 0.35420275), colorOf_2(0.2633812, 0.07328166, 0.3479189), colorOf_2(0.26003894, 0.07229478, 0.34171757), colorOf_2(0.25671193, 0.07138011, 0.3356065), colorOf_2(0.25340685, 0.07053358, 0.32959458), colorOf_2(0.25012845, 0.06975821, 0.323681), colorOf_2(0.24688226, 0.06905364, 0.31786993), colorOf_2(0.24367373, 0.06841986, 0.31216523), colorOf_2(0.24050814, 0.0678571, 0.30657056), colorOf_2(0.23739062, 0.067365885, 0.30108923), colorOf_2(0.23433055, 0.0669356, 0.2957401), colorOf_2(0.23132955, 0.06657619, 0.2905136), colorOf_2(0.22839177, 0.066289976, 0.28541073), colorOf_2(0.22552164, 0.06607817, 0.28043398), colorOf_2(0.22272706, 0.065933794, 0.27559716), colorOf_2(0.22001252, 0.06585792, 0.2709028), colorOf_2(0.21737845, 0.06585966, 0.2663421), colorOf_2(0.21482843, 0.06594039, 0.26191676), colorOf_2(0.2123741, 0.066085026, 0.25765166), colorOf_2(0.21001214, 0.06630857, 0.2535289), colorOf_2(0.20774424, 0.06661453, 0.24954644), colorOf_2(0.20558052, 0.066990465, 0.24572498), colorOf_2(0.20352007, 0.06744418, 0.24205576), colorOf_2(0.20156133, 0.06798327, 0.23852974), colorOf_2(0.19971572, 0.06859271, 0.23517095), colorOf_2(0.19794834, 0.06931406, 0.23194647), colorOf_2(0.1960826, 0.070321225, 0.22874673), colorOf_2(0.19410351, 0.071608305, 0.22558728), colorOf_2(0.19199449, 0.07318283, 0.22243385), colorOf_2(0.18975854, 0.07501986, 0.21930051), colorOf_2(0.18739228, 0.077102095, 0.21618876), colorOf_2(0.18488036, 0.07942573, 0.21307652), colorOf_2(0.18774483, 0.07725159, 0.21387449), colorOf_2(0.19049579, 0.07531128, 0.21465623), colorOf_2(0.19315486, 0.07360682, 0.21542363), colorOf_2(0.19571854, 0.07215778, 0.21617499), colorOf_2(0.19819343, 0.070974626, 0.21690975), colorOf_2(0.2005876, 0.070064574, 0.21762721), colorOf_2(0.20290366, 0.06943525, 0.21833168), colorOf_2(0.20531726, 0.06891959, 0.21911517), colorOf_2(0.20785704, 0.068484396, 0.22000134), colorOf_2(0.21052884, 0.068121955, 0.22098759), colorOf_2(0.21333139, 0.067830145, 0.22207043), colorOf_2(0.2162528, 0.06761633, 0.22324568), colorOf_2(0.21930504, 0.06746579, 0.22451024), colorOf_2(0.22247308, 0.067388214, 0.2258596), colorOf_2(0.22575396, 0.067382134, 0.22728984), colorOf_2(0.2291562, 0.06743473, 0.22879681), colorOf_2(0.232663, 0.067557104, 0.23037617), colorOf_2(0.23627496, 0.0677436, 0.23202361), colorOf_2(0.23999587, 0.06798503, 0.23373434), colorOf_2(0.2438115, 0.06828985, 0.23550427), colorOf_2(0.24772093, 0.06865334, 0.2373288), colorOf_2(0.251729, 0.06906463, 0.2392026), colorOf_2(0.25582135, 0.06953231, 0.2411219), colorOf_2(0.25999463, 0.07005385, 0.2430822), colorOf_2(0.26425514, 0.070616595, 0.2450776), colorOf_2(0.26859096, 0.071226716, 0.24710444), colorOf_2(0.27299702, 0.07188355, 0.24915847), colorOf_2(0.2774715, 0.07258297, 0.25123495), colorOf_2(0.28201747, 0.073315695, 0.253328), colorOf_2(0.2866231, 0.07408846, 0.25543478), colorOf_2(0.29128516, 0.07489905, 0.257551), colorOf_2(0.29600048, 0.07574534, 0.25967246), colorOf_2(0.30077276, 0.07661782, 0.26179293), colorOf_2(0.30559227, 0.077521965, 0.26391006), colorOf_2(0.3104552, 0.07845687, 0.26602006), colorOf_2(0.3153587, 0.079421, 0.26811904), colorOf_2(0.32029986, 0.08041299, 0.27020323), colorOf_2(0.32527888, 0.08142839, 0.27226773), colorOf_2(0.33029175, 0.08246763, 0.2743093), colorOf_2(0.33533353, 0.08353244, 0.27632535), colorOf_2(0.34040165, 0.084622234, 0.27831253), colorOf_2(0.34549356, 0.085736655, 0.2802677), colorOf_2(0.35060677, 0.08687555, 0.2821877), colorOf_2(0.3557389, 0.08803897, 0.2840696), colorOf_2(0.36088753, 0.08922719, 0.28591052), colorOf_2(0.3660503, 0.09044068, 0.28770775), colorOf_2(0.3712251, 0.09168, 0.28945866), colorOf_2(0.3764103, 0.092945196, 0.29116026), colorOf_2(0.38160247, 0.09423873, 0.29281107), colorOf_2(0.3867994, 0.09556182, 0.294409), colorOf_2(0.3919989, 0.09691583, 0.2959521), colorOf_2(0.39719877, 0.09830232, 0.29743856), colorOf_2(0.40239692, 0.09972293, 0.29886675), colorOf_2(0.4075912, 0.10117946, 0.30023518), colorOf_2(0.41277987, 0.102673404, 0.30154225), colorOf_2(0.41796106, 0.10420645, 0.30278653), colorOf_2(0.42313215, 0.10578121, 0.3039676), colorOf_2(0.42829102, 0.10739978, 0.3050848), colorOf_2(0.4334356, 0.10906424, 0.30613768), colorOf_2(0.4385638, 0.11077668, 0.30712602), colorOf_2(0.44367358, 0.11253913, 0.30804974), colorOf_2(0.44876298, 0.11435355, 0.30890906), colorOf_2(0.45383006, 0.11622184, 0.30970442), colorOf_2(0.45887288, 0.11814571, 0.31043637), colorOf_2(0.46389103, 0.120125614, 0.31110343), colorOf_2(0.4688811, 0.12216446, 0.3117091), colorOf_2(0.47384143, 0.12426354, 0.3122547), colorOf_2(0.47877035, 0.12642401, 0.31274173), colorOf_2(0.4836663, 0.12864679, 0.3131719), colorOf_2(0.48852846, 0.13093211, 0.31354553), colorOf_2(0.49335504, 0.13328092, 0.31386563), colorOf_2(0.49814436, 0.1356938, 0.3141352), colorOf_2(0.50289524, 0.13817087, 0.31435663), colorOf_2(0.5076068, 0.14071193, 0.314532), colorOf_2(0.5122784, 0.14331657, 0.31466308), colorOf_2(0.51690847, 0.14598463, 0.31475407), colorOf_2(0.52149653, 0.14871545, 0.31480768), colorOf_2(0.5260419, 0.15150818, 0.31482655), colorOf_2(0.5305442, 0.15436183, 0.314813), colorOf_2(0.53500277, 0.15727541, 0.31477085), colorOf_2(0.5394174, 0.1602477, 0.31470296), colorOf_2(0.5437877, 0.16327739, 0.31461203), colorOf_2(0.5481137, 0.16636309, 0.31450102), colorOf_2(0.5523952, 0.16950339, 0.31437293), colorOf_2(0.5566323, 0.17269677, 0.31423044), colorOf_2(0.560825, 0.1759417, 0.3140764), colorOf_2(0.5649734, 0.17923665, 0.3139136), colorOf_2(0.56907785, 0.18258004, 0.3137444), colorOf_2(0.5731385, 0.18597037, 0.31357127), colorOf_2(0.57715553, 0.18940601, 0.31339705), colorOf_2(0.5811293, 0.19288549, 0.313224), colorOf_2(0.58506024, 0.19640738, 0.31305403), colorOf_2(0.5889486, 0.19997022, 0.31288922), colorOf_2(0.5927948, 0.20357251, 0.31273234), colorOf_2(0.59659916, 0.20721295, 0.31258523), colorOf_2(0.6003621, 0.21089031, 0.31244934), colorOf_2(0.604084, 0.21460332, 0.31232652), colorOf_2(0.60776526, 0.21835071, 0.31221902), colorOf_2(0.6114062, 0.22213125, 0.3121288), colorOf_2(0.6150072, 0.22594403, 0.3120568), colorOf_2(0.61856866, 0.22978799, 0.31200463), colorOf_2(0.6220908, 0.23366219, 0.31197384), colorOf_2(0.6255742, 0.23756535, 0.311967), colorOf_2(0.6290189, 0.24149689, 0.31198448), colorOf_2(0.63242537, 0.245456, 0.31202766), colorOf_2(0.6357937, 0.24944186, 0.31209794), colorOf_2(0.63912433, 0.25345364, 0.3121969), colorOf_2(0.64241755, 0.25749052, 0.3123263), colorOf_2(0.6456735, 0.26155204, 0.31248674), colorOf_2(0.6488923, 0.26563755, 0.3126794), colorOf_2(0.65207416, 0.2697465, 0.3129056), colorOf_2(0.6552193, 0.27387828, 0.31316668), colorOf_2(0.65832806, 0.27803212, 0.31346434), colorOf_2(0.6614004, 0.2822078, 0.31379914), colorOf_2(0.66443634, 0.28640485, 0.31417224), colorOf_2(0.66743606, 0.2906228, 0.31458485), colorOf_2(0.6703996, 0.29486126, 0.31503814), colorOf_2(0.67332727, 0.29911962, 0.31553373), colorOf_2(0.676219, 0.30339763, 0.3160725), colorOf_2(0.67907476, 0.30769497, 0.31665546), colorOf_2(0.6818946, 0.31201133, 0.3172838), colorOf_2(0.6846785, 0.31634635, 0.3179587), colorOf_2(0.68742657, 0.3206997, 0.3186814), colorOf_2(0.69013894, 0.32507092, 0.31945333), colorOf_2(0.6928154, 0.32945985, 0.32027543), colorOf_2(0.6954561, 0.3338662, 0.32114884), colorOf_2(0.6980608, 0.33828977, 0.3220748), colorOf_2(0.70062965, 0.3427302, 0.3230545), colorOf_2(0.7031625, 0.34718725, 0.32408914), colorOf_2(0.7056595, 0.35166052, 0.32518014), colorOf_2(0.7081206, 0.35614985, 0.3263286), colorOf_2(0.71054566, 0.360655, 0.32753575), colorOf_2(0.7129347, 0.3651757, 0.32880273), colorOf_2(0.7152876, 0.3697117, 0.33013088), colorOf_2(0.71760446, 0.37426272, 0.3315214), colorOf_2(0.71988523, 0.3788285, 0.33297557), colorOf_2(0.72213, 0.38340864, 0.3344947), colorOf_2(0.72433865, 0.38800302, 0.33607996), colorOf_2(0.72651124, 0.39261132, 0.33773258), colorOf_2(0.7286477, 0.39723325, 0.33945385), colorOf_2(0.73074824, 0.40186852, 0.34124497), colorOf_2(0.7328127, 0.40651685, 0.34310716), colorOf_2(0.73484135, 0.41117787, 0.3450417), colorOf_2(0.7368342, 0.41585127, 0.34704977), colorOf_2(0.7387914, 0.42053673, 0.3491326), colorOf_2(0.740713, 0.42523393, 0.3512913), colorOf_2(0.7425992, 0.42994255, 0.3535271), colorOf_2(0.7444502, 0.43466216, 0.35584107), colorOf_2(0.7462662, 0.43939245, 0.3582344), colorOf_2(0.7480474, 0.44413298, 0.36070815), colorOf_2(0.7497942, 0.44888332, 0.36326337), colorOf_2(0.75150687, 0.45364314, 0.3659011), colorOf_2(0.7531857, 0.458412, 0.36862236), colorOf_2(0.7548311, 0.46318942, 0.37142804), colorOf_2(0.75644344, 0.46797502, 0.37431908), colorOf_2(0.75802326, 0.47276828, 0.37729636), colorOf_2(0.75957114, 0.47756872, 0.38036066), colorOf_2(0.76108766, 0.4823758, 0.38351277), colorOf_2(0.76257336, 0.48718905, 0.38675335), colorOf_2(0.76402885, 0.49200803, 0.39008307), colorOf_2(0.76545495, 0.49683213, 0.39350253), colorOf_2(0.7668523, 0.5016608, 0.3970122), colorOf_2(0.7682218, 0.5064936, 0.40061256), colorOf_2(0.7695642, 0.5113299, 0.40430397), colorOf_2(0.77088094, 0.51616895, 0.4080867), colorOf_2(0.7721726, 0.5210103, 0.4119609), colorOf_2(0.77344024, 0.52585334, 0.41592678), colorOf_2(0.77468497, 0.53069746, 0.4199844), colorOf_2(0.77590793, 0.5355422, 0.4241337), colorOf_2(0.77711034, 0.54038674, 0.4283745), colorOf_2(0.77829343, 0.54523057, 0.43270665), colorOf_2(0.77945864, 0.5500731, 0.4371298), colorOf_2(0.78060776, 0.55491334, 0.44164333), colorOf_2(0.7817418, 0.559751, 0.44624686), colorOf_2(0.78286225, 0.5645853, 0.45093986), colorOf_2(0.7839706, 0.5694158, 0.45572156), colorOf_2(0.78506845, 0.5742417, 0.46059117), colorOf_2(0.78615737, 0.57906246, 0.46554777), colorOf_2(0.787239, 0.58387744, 0.47059038), colorOf_2(0.7883151, 0.588686, 0.47571793), colorOf_2(0.7893874, 0.59348756, 0.48092914), colorOf_2(0.7904578, 0.5982813, 0.48622257), colorOf_2(0.79152834, 0.6030667, 0.49159667), colorOf_2(0.79260033, 0.6078432, 0.4970502), colorOf_2(0.7936756, 0.6126103, 0.5025816), colorOf_2(0.7947559, 0.6173673, 0.5081892), colorOf_2(0.79584295, 0.62211376, 0.51387125), colorOf_2(0.79693854, 0.62684906, 0.51962584), colorOf_2(0.7980445, 0.6315726, 0.52545106), colorOf_2(0.79916245, 0.6362838, 0.53134495), colorOf_2(0.80029416, 0.64098215, 0.53730536), colorOf_2(0.80144125, 0.645667, 0.5433301), colorOf_2(0.80260533, 0.65033793, 0.5494169), colorOf_2(0.80378795, 0.65499425, 0.5555635), colorOf_2(0.80499053, 0.6596354, 0.56176746), colorOf_2(0.80621463, 0.6642609, 0.5680263), colorOf_2(0.8074614, 0.66887003, 0.5743375), colorOf_2(0.8087322, 0.67346215, 0.5806984), colorOf_2(0.8100281, 0.67803675, 0.5871063), colorOf_2(0.81135017, 0.682593, 0.5935585), colorOf_2(0.8126992, 0.68713033, 0.6000522), colorOf_2(0.8140761, 0.69164795, 0.60658437), colorOf_2(0.8154815, 0.69614506, 0.6131522), colorOf_2(0.81691575, 0.70062083, 0.6197526), colorOf_2(0.8183793, 0.70507437, 0.62638247), colorOf_2(0.8198723, 0.7095047, 0.6330386), colorOf_2(0.82139474, 0.71391094, 0.63971764), colorOf_2(0.82294637, 0.71829176, 0.6464164), colorOf_2(0.8245268, 0.7226461, 0.65313137), colorOf_2(0.8261355, 0.72697276, 0.659859), colorOf_2(0.8277716, 0.73127025, 0.6665957), colorOf_2(0.8294341, 0.7355371, 0.6733377), colorOf_2(0.8311216, 0.73977184, 0.68008125), colorOf_2(0.83283275, 0.7439727, 0.68682235), colorOf_2(0.8345657, 0.74813795, 0.69355696), colorOf_2(0.83631897, 0.7522655, 0.70028), colorOf_2(0.83809125, 0.75635314, 0.7069856), colorOf_2(0.8398784, 0.76039904, 0.7136715), colorOf_2(0.8416775, 0.764401, 0.720333), colorOf_2(0.8434853, 0.7683566, 0.72696537), colorOf_2(0.8452981, 0.7722634, 0.73356366), colorOf_2(0.84711194, 0.7761188, 0.74012274), colorOf_2(0.84892243, 0.7799202, 0.74663717), colorOf_2(0.85072696, 0.7836646, 0.7530975), colorOf_2(0.8525191, 0.78734934, 0.75949943), colorOf_2(0.8542922, 0.790972, 0.765838), colorOf_2(0.85604024, 0.7945296, 0.7721061), colorOf_2(0.8577566, 0.79801965, 0.7782957), colorOf_2(0.85943466, 0.8014392, 0.7843979), colorOf_2(0.86107117, 0.8047852, 0.7903953), colorOf_2(0.862656, 0.8080552, 0.79628265), colorOf_2(0.8641834, 0.81124645, 0.8020461), colorOf_2(0.86564934, 0.81435543, 0.8076697), colorOf_2(0.86705315, 0.81737804, 0.8131342), colorOf_2(0.86839956, 0.82030874, 0.8184164), colorOf_2(0.8696913, 0.8231416, 0.82350475), colorOf_2(0.8709385, 0.8258686, 0.828385), colorOf_2(0.87215334, 0.82848054, 0.83304864), colorOf_2(0.8733517, 0.8309671, 0.83748853), colorOf_2(0.87453794, 0.8333197, 0.84171927), colorOf_2(0.8757146, 0.8355302, 0.8457554), colorOf_2(0.8768785, 0.83759236, 0.8496137), colorOf_2(0.87802297, 0.8395017, 0.8533065), colorOf_2(0.87913245, 0.84125555, 0.85685575), colorOf_2(0.88019294, 0.84285223, 0.860274), colorOf_2(0.8811917, 0.8442907, 0.863566), colorOf_2(0.8821154, 0.8455701, 0.86673766), colorOf_2(0.8829517, 0.8466897, 0.86979616), colorOf_2(0.88369125, 0.8476489, 0.87274146), colorOf_2(0.8843271, 0.84844744, 0.87556785), colorOf_2(0.8848514, 0.84908426, 0.87828237), colorOf_2(0.885259, 0.84955895, 0.8808842), colorOf_2(0.88554716, 0.84987175, 0.88336205), colorOf_2(0.88571155, 0.85002184, 0.8857254)])));
    this.v23_1.o1(arrayListOf([this.s21_1, this.t21_1, this.u21_1, this.v21_1, this.p21_1, this.q21_1, this.r21_1, this.o23_1, this.q23_1, this.s23_1, this.r23_1, this.p23_1, this.t23_1, this.u23_1, this.w21_1, this.x21_1, this.y21_1, this.z21_1, this.a22_1, this.b22_1, this.c22_1, this.d22_1, this.e22_1, this.f22_1, this.g22_1, this.h22_1, this.i22_1, this.j22_1, this.k22_1, this.l22_1, this.m22_1, this.n22_1, this.o22_1, this.p22_1, this.q22_1, this.r22_1, this.s22_1, this.t22_1, this.u22_1, this.v22_1, this.w22_1, this.x22_1, this.y22_1, this.z22_1, this.a23_1, this.b23_1, this.c23_1, this.d23_1, this.e23_1, this.f23_1, this.g23_1, this.h23_1, this.i23_1, this.j23_1, this.k23_1, this.l23_1, this.m23_1, this.n23_1]));
  }
  getEntries() {
    return this.v23_1;
  }
  getPalette(name) {
    return ensureNotNull(this.get(name)).getPalette();
  }
  add(entry) {
    this.v23_1.c1(entry);
  }
  get(name) {
    var _iterator__ex2g4s = this.v23_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var entry = _iterator__ex2g4s.j1();
      if (entry.name === name) {
        return entry;
      }
    }
    return null;
  }
  find(palette) {
    var _iterator__ex2g4s = this.v23_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var entry = _iterator__ex2g4s.j1();
      if (equals(entry.getPalette(), palette)) {
        return entry;
      }
    }
    return null;
  }
  createDefaultDivergingPalette() {
    return this.s22_1.getPalette();
  }
  createDefaultSequentialPalette() {
    return this.u22_1.getPalette();
  }
  createDefaultQualititativePalette() {
    return this.t22_1.getPalette();
  }
  createColorGradient(name) {
    var _iterator__ex2g4s = this.v23_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var entry = _iterator__ex2g4s.j1();
      if (entry.name === name) {
        return entry.getPalette();
      }
    }
    return null;
  }
}
class PaletteType extends Enum {}
class ScreenTransformRubberBand {
  constructor(screenTransform) {
    this.w23_1 = SimpleSingleSelection.i15(null);
    this.x23_1 = screenTransform;
  }
  y23() {
    return this.w23_1;
  }
  z23(x, y) {
    var xWorld = this.x23_1.g1h().z15(x);
    var yWorld = this.x23_1.h1h().z15(y);
    this.w23_1.y13(Double_3.z1h(xWorld, yWorld, 0.0, 0.0));
  }
  a24(x, y) {
    if (this.w23_1.f13()) {
      var xWorld = this.x23_1.g1h().z15(x);
      var yWorld = this.x23_1.h1h().z15(y);
      var r = ensureNotNull(this.w23_1.z13());
      this.w23_1.y13(Double_3.z1h(r.g1h(), r.h1h(), xWorld - r.g1h(), yWorld - r.h1h()));
    }
  }
  b24() {
    this.w23_1.i13();
  }
  c24() {
    var tmp;
    if (this.w23_1.f13()) {
      tmp = this.d24(ensureNotNull(this.w23_1.z13())).c1i();
    } else {
      tmp = null;
    }
    return tmp;
  }
  d24(r) {
    var x1 = numberToInt(round(this.x23_1.g1h().b16(r.p1h())));
    var x2 = numberToInt(round(this.x23_1.g1h().b16(r.s1h())));
    var y1 = numberToInt(round(this.x23_1.h1h().b16(r.r1h())));
    var y2 = numberToInt(round(this.x23_1.h1h().b16(r.t1h())));
    var width = x2 - x1 | 0;
    var height = y2 - y1 | 0;
    return Rectangle.from(x1, y1, width, height);
  }
}
class AbstractTwoDScreenTransform {
  static g24() {
    return createThis(this);
  }
}
class AbstractMutableTwoDScreenTransform extends AbstractTwoDScreenTransform {
  static f24() {
    var $this = this.g24();
    $this.e24_1 = CollectionFactory_instance.nk();
    return $this;
  }
  h24(listener) {
    this.e24_1.c1(listener);
  }
  u15(event) {
    var _iterator__ex2g4s = this.e24_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var listener = _iterator__ex2g4s.j1();
      listener.v15(event);
    }
  }
}
class SimpleTwoDScreenTransform$intervalListener$1 {
  constructor(this$0) {
    this.t24_1 = this$0;
  }
  kn(event) {
    this.t24_1.u15(new ScreenTransformEvent());
  }
}
class SimpleTwoDScreenTransform extends AbstractMutableTwoDScreenTransform {
  g1h() {
    return this.o24_1;
  }
  h1h() {
    return this.p24_1;
  }
  static u24(x, y, screenWidth, screenHeight, worldAspectRatio) {
    var $this = this.f24();
    init_org_mkui_transform_SimpleTwoDScreenTransform($this);
    $this.m24_1 = x.c16();
    $this.n24_1 = y.c16();
    $this.o24_1 = x;
    $this.p24_1 = y;
    $this.k24_1 = screenWidth;
    $this.l24_1 = screenHeight;
    $this.r24_1 = worldAspectRatio;
    $this.m24_1.addIntervalListener($this.s24_1);
    $this.n24_1.addIntervalListener($this.s24_1);
    return $this;
  }
  i24(screenWidth, screenHeight) {
    if (!(this.k24_1 === screenWidth) || !(this.l24_1 === screenHeight)) {
      this.k24_1 = screenWidth;
      this.l24_1 = screenHeight;
      updateAspectRatio(this);
      this.o24_1.w15(screenWidth);
      this.p24_1.w15(screenHeight);
      this.u15(new ScreenTransformEvent());
    }
  }
  toString() {
    return 'SimpleTwoDScreenTransform{screenWidth=' + this.k24_1 + ', screenHeight=' + this.l24_1 + ', xInterval=' + this.m24_1 + ', yInterval=' + this.n24_1 + toString(_Char___init__impl__6a9atx(125));
  }
}
class Visual {}
class CPCanvas {
  constructor() {
    this.n25_1 = CollectionFactory_instance.nk();
    this.o25_1 = CollectionFactory_instance.c17();
    this.p25_1 = ArrayList.q1();
    this.q25_1 = new SimpleProperty(false);
    this.r25_1 = new FunctionalCPCanvas(this.n25_1, this.p25_1, this.q25_1);
    this.s25_1 = this.r25_1.j26_1;
  }
  l26() {
    return this.s25_1;
  }
  m26(d) {
    this.n25_1.c1(d);
  }
  n26() {
    return this.r25_1.e26_1;
  }
  o26() {
    return this.r25_1.f26_1;
  }
  p26(l) {
    this.p25_1.c1(l);
  }
  q26() {
    this.r25_1.q26();
  }
  y1g(l) {
    this.r25_1.y1g(l);
  }
  z1g(l) {
    this.r25_1.z1g(l);
  }
  r26(l) {
    this.r25_1.r26(l);
  }
  s26(l) {
    this.r25_1.s26(l);
  }
  t26(l) {
    this.r25_1.t26(l);
  }
}
class FunctionalCPCanvas$timer$1 {
  constructor(this$0) {
    this.c27_1 = this$0;
  }
  j18() {
    prepare(this.c27_1);
  }
}
class FunctionalCPCanvas {
  constructor(layers, listeners, showTiming) {
    this.t25_1 = layers;
    this.u25_1 = listeners;
    this.v25_1 = showTiming;
    this.w25_1 = HashSet.c9();
    var tmp = this;
    var tmp_0 = Companion_getInstance_29().s17_1;
    tmp.x25_1 = tmp_0.x17('Canvas$Prepare', 40, true, new FunctionalCPCanvas$timer$1(this));
    this.y25_1 = new Timing();
    this.z25_1 = new Timing();
    this.a26_1 = new Timing();
    this.b26_1 = true;
    this.d26_1 = new InteractiveComponentListeners();
    this.e26_1 = 0;
    this.f26_1 = 0;
    this.g26_1 = 1.0;
    this.h26_1 = 0;
    this.i26_1 = 0;
    var tmp_1 = this;
    tmp_1.j26_1 = FC(FunctionalCPCanvas$nativeComponent$lambda(this));
    this.k26_1 = null;
  }
  a27() {
    this.v26();
    var _iterator__ex2g4s = this.t25_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var layer = _iterator__ex2g4s.j1();
      this.w25_1.c1(layer);
    }
    if (this.b26_1) {
      this.x25_1.r15();
    }
  }
  v26() {
    this.q26();
  }
  q26() {
    requestAnimationFrame(FunctionalCPCanvas$redraw$lambda(this));
  }
  b27(width, height, scaleFactor) {
    return width > 0 && height > 0 && !(this.e26_1 === width) || !(this.f26_1 === height) || !(this.g26_1 === scaleFactor);
  }
  y26(canvasRef, width, height, scaleFactor) {
    println('syncCanvasDimension  ' + this.e26_1 + ' x ' + this.f26_1 + ' - ' + width + ' x ' + height);
    this.e26_1 = width;
    this.f26_1 = height;
    this.g26_1 = scaleFactor;
    this.h26_1 = numberToInt(width * scaleFactor);
    this.i26_1 = numberToInt(height * scaleFactor);
    var canvas = canvasRef.current;
    if (!(canvas == null)) {
      println('Resizing ' + width + 'x' + height + '@' + scaleFactor + ' -> ' + this.h26_1 + 'x' + this.i26_1);
      canvas.width = this.h26_1;
      canvas.height = this.i26_1;
    }
  }
  w26(g) {
    g.setTransform(this.g26_1, 0.0, 0.0, this.g26_1, 0.0, 0.0);
    g.clearRect(0.0, 0.0, this.e26_1, this.f26_1);
  }
  l26() {
    return this.j26_1;
  }
  z26(width, height) {
    var _iterator__ex2g4s = this.u25_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var listener = _iterator__ex2g4s.j1();
      listener.d27(width, height);
    }
  }
  y1g(l) {
    this.d26_1.y1g(l);
  }
  z1g(l) {
    this.d26_1.z1g(l);
  }
  r26(l) {
    this.d26_1.v1g_1.c1(l);
  }
  s26(l) {
    this.d26_1.w1g_1.c1(l);
  }
  t26(l) {
    this.d26_1.x1g_1.c1(l);
  }
}
class JSMouseEvent {
  constructor(event, clickCount) {
    this.e27_1 = event;
    this.f27_1 = clickCount;
  }
  g27() {
    return this.f27_1;
  }
  g1h() {
    return numberToInt(this.e27_1.offsetX);
  }
  h1h() {
    return numberToInt(this.e27_1.offsetY);
  }
  h27() {
    return this.e27_1.ctrlKey || this.e27_1.metaKey;
  }
  i27() {
    return this.e27_1.ctrlKey || this.e27_1.metaKey;
  }
  j27() {
    return this.e27_1.altKey;
  }
  k27() {
    return this.e27_1.shiftKey;
  }
  l27() {
    return false;
  }
  m27() {
    var tmp = this.e27_1.button;
    // Inline function 'web.mouse.MAIN' call
    // Inline function 'js.reflect.unsafeCast' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    return equals(tmp, 0);
  }
  n27() {
    var tmp = this.e27_1.button;
    // Inline function 'web.mouse.AUXILIARY' call
    // Inline function 'js.reflect.unsafeCast' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    return equals(tmp, 1);
  }
}
class Companion_56 {
  constructor() {
    Companion_instance_56 = this;
    this.e1b_1 = new MkColorFactory();
  }
}
class MkColorFactory {
  constructor() {
    Companion_getInstance_56();
    var tmp = this;
    tmp.m1b_1 = lazy(MkColorFactory$white$delegate$lambda);
    var tmp_0 = this;
    tmp_0.n1b_1 = lazy(MkColorFactory$lightGray$delegate$lambda);
    var tmp_1 = this;
    tmp_1.o1b_1 = lazy(MkColorFactory$gray$delegate$lambda);
    var tmp_2 = this;
    tmp_2.p1b_1 = lazy(MkColorFactory$darkGray$delegate$lambda);
    var tmp_3 = this;
    tmp_3.q1b_1 = lazy(MkColorFactory$black$delegate$lambda);
  }
  r1b() {
    var tmp0 = this.m1b_1;
    var tmp = KProperty1;
    // Inline function 'kotlin.getValue' call
    getPropertyCallableRef('white', 1, tmp, MkColorFactory$_get_white_$ref_49ijo8(), null);
    return tmp0.z2();
  }
  z27() {
    var tmp0 = this.n1b_1;
    var tmp = KProperty1;
    // Inline function 'kotlin.getValue' call
    getPropertyCallableRef('lightGray', 1, tmp, MkColorFactory$_get_lightGray_$ref_c3gn8o(), null);
    return tmp0.z2();
  }
  n1e() {
    var tmp0 = this.o1b_1;
    var tmp = KProperty1;
    // Inline function 'kotlin.getValue' call
    getPropertyCallableRef('gray', 1, tmp, MkColorFactory$_get_gray_$ref_di7bka(), null);
    return tmp0.z2();
  }
  a28() {
    var tmp0 = this.p1b_1;
    var tmp = KProperty1;
    // Inline function 'kotlin.getValue' call
    getPropertyCallableRef('darkGray', 1, tmp, MkColorFactory$_get_darkGray_$ref_syni1s(), null);
    return tmp0.z2();
  }
  b28() {
    var tmp0 = this.q1b_1;
    var tmp = KProperty1;
    // Inline function 'kotlin.getValue' call
    getPropertyCallableRef('black', 1, tmp, MkColorFactory$_get_black_$ref_r3mqym(), null);
    return tmp0.z2();
  }
}
class CPColor {
  static u27(r, g, b, a) {
    var $this = createThis(this);
    $this.o27_1 = r;
    $this.p27_1 = g;
    $this.q27_1 = b;
    $this.r27_1 = a;
    $this.s27_1 = $this.p19();
    return $this;
  }
  static y27(r, g, b) {
    return this.u27(r, g, b, _UByte___init__impl__g9hnc4(-1));
  }
  static v27(r, g, b) {
    // Inline function 'kotlin.toUByte' call
    var tmp = _UByte___init__impl__g9hnc4(toByte(r));
    // Inline function 'kotlin.toUByte' call
    var tmp_0 = _UByte___init__impl__g9hnc4(toByte(g));
    // Inline function 'kotlin.toUByte' call
    var tmp$ret$2 = _UByte___init__impl__g9hnc4(toByte(b));
    return this.u27(tmp, tmp_0, tmp$ret$2, _UByte___init__impl__g9hnc4(-1));
  }
  static t27(r, g, b, a) {
    // Inline function 'kotlin.toUByte' call
    var tmp = _UByte___init__impl__g9hnc4(toByte(r));
    // Inline function 'kotlin.toUByte' call
    var tmp_0 = _UByte___init__impl__g9hnc4(toByte(g));
    // Inline function 'kotlin.toUByte' call
    var tmp_1 = _UByte___init__impl__g9hnc4(toByte(b));
    // Inline function 'kotlin.toUByte' call
    var tmp$ret$3 = _UByte___init__impl__g9hnc4(toByte(a));
    return this.u27(tmp, tmp_0, tmp_1, tmp$ret$3);
  }
  static w27(r, g, b) {
    return this.t27(numberToInt(r * 255 + 0.5), numberToInt(g * 255 + 0.5), numberToInt(b * 255 + 0.5), 255);
  }
  static x27(rgba) {
    return this.t27(rgba >> 16 & 255, rgba >> 8 & 255, rgba >> 0 & 255, rgba >> 24 & 255);
  }
  k19() {
    return this.o27_1;
  }
  l19() {
    return this.p27_1;
  }
  m19() {
    return this.q27_1;
  }
  n19() {
    return this.r27_1;
  }
}
class ElementalKeyEvent {
  constructor(keyCode) {
    this.c28_1 = keyCode;
  }
  d28() {
    return this.c28_1;
  }
}
class CPInteractiveHandler$registerMouseWheelListener$2$1 {
  constructor($it) {
    this.v28_1 = $it;
  }
  g1h() {
    return numberToInt(this.v28_1.x);
  }
  h1h() {
    return numberToInt(this.v28_1.y);
  }
  w28() {
    return this.v28_1.deltaY;
  }
}
class CPInteractiveHandler$registerContextMenuListener$2$1 {
  constructor($it) {
    this.z28_1 = $it;
  }
  g1h() {
    return this.z28_1.clientX;
  }
  h1h() {
    return this.z28_1.clientY;
  }
}
class CPInteractiveHandler {
  constructor(canvas, listeners, interactTiming) {
    listeners = listeners === VOID ? new InteractiveComponentListeners() : listeners;
    interactTiming = interactTiming === VOID ? null : interactTiming;
    this.e28_1 = canvas;
    this.f28_1 = listeners;
    this.g28_1 = interactTiming;
    this.h28_1 = false;
    this.i28_1 = false;
    this.j28_1 = false;
    this.k28_1 = null;
    var tmp = this;
    tmp.l28_1 = CPInteractiveHandler$onmousedrag$lambda(this);
    this.b29();
    this.c29();
    this.d29();
    this.e29();
    this.f29();
  }
  b29() {
    if (!(this.e28_1 == null)) {
      // Inline function 'web.mouse.MOUSE_UP' call
      // Inline function 'web.events.EventType' call
      // Inline function 'js.reflect.unsafeCast' call
      // Inline function 'kotlin.js.unsafeCast' call
      // Inline function 'kotlin.js.asDynamic' call
      var tmp = 'mouseup';
      addEventHandler(this.e28_1, tmp, CPInteractiveHandler$registerMouseListener$lambda(this));
      // Inline function 'web.mouse.MOUSE_DOWN' call
      // Inline function 'web.events.EventType' call
      // Inline function 'js.reflect.unsafeCast' call
      // Inline function 'kotlin.js.unsafeCast' call
      // Inline function 'kotlin.js.asDynamic' call
      var tmp_0 = 'mousedown';
      addEventHandler(this.e28_1, tmp_0, CPInteractiveHandler$registerMouseListener$lambda_0(this));
      // Inline function 'web.mouse.MOUSE_OVER' call
      // Inline function 'web.events.EventType' call
      // Inline function 'js.reflect.unsafeCast' call
      // Inline function 'kotlin.js.unsafeCast' call
      // Inline function 'kotlin.js.asDynamic' call
      var tmp_1 = 'mouseover';
      addEventHandler(this.e28_1, tmp_1, CPInteractiveHandler$registerMouseListener$lambda_1(this));
    }
    // Inline function 'web.mouse.MOUSE_OUT' call
    // Inline function 'web.events.EventType' call
    // Inline function 'js.reflect.unsafeCast' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var tmp_2 = 'mouseout';
    addEventHandler(this.e28_1, tmp_2, CPInteractiveHandler$registerMouseListener$lambda_2(this));
    // Inline function 'web.mouse.DBL_CLICK' call
    // Inline function 'web.events.EventType' call
    // Inline function 'js.reflect.unsafeCast' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var tmp_3 = 'dblclick';
    addEventHandler(this.e28_1, tmp_3, CPInteractiveHandler$registerMouseListener$lambda_3(this));
  }
  c29() {
    if (!(this.e28_1 == null)) {
      var tmp = this;
      tmp.k28_1 = CPInteractiveHandler$registerMouseMotionListener$lambda(this);
      // Inline function 'web.mouse.MOUSE_MOVE' call
      // Inline function 'web.events.EventType' call
      // Inline function 'js.reflect.unsafeCast' call
      // Inline function 'kotlin.js.unsafeCast' call
      // Inline function 'kotlin.js.asDynamic' call
      var tmp$ret$4 = 'mousemove';
      addEventHandler(this.e28_1, tmp$ret$4, ensureNotNull(this.k28_1));
    }
  }
  d29() {
    if (!(this.e28_1 == null)) {
      // Inline function 'web.mouse.WHEEL' call
      // Inline function 'web.events.EventType' call
      // Inline function 'js.reflect.unsafeCast' call
      // Inline function 'kotlin.js.unsafeCast' call
      // Inline function 'kotlin.js.asDynamic' call
      var tmp = 'wheel';
      addEventHandler(this.e28_1, tmp, CPInteractiveHandler$registerMouseWheelListener$lambda(this));
    }
  }
  q28() {
    this.j28_1 = true;
    if (!(this.e28_1 == null)) {
      // Inline function 'web.mouse.MOUSE_MOVE' call
      // Inline function 'web.events.EventType' call
      // Inline function 'js.reflect.unsafeCast' call
      // Inline function 'kotlin.js.unsafeCast' call
      // Inline function 'kotlin.js.asDynamic' call
      var tmp$ret$4 = 'mousemove';
      removeEventListener(this.e28_1, tmp$ret$4, ensureNotNull(this.k28_1));
      // Inline function 'web.mouse.MOUSE_MOVE' call
      // Inline function 'web.events.EventType' call
      // Inline function 'js.reflect.unsafeCast' call
      // Inline function 'kotlin.js.unsafeCast' call
      // Inline function 'kotlin.js.asDynamic' call
      var tmp$ret$9 = 'mousemove';
      addEventHandler(this.e28_1, tmp$ret$9, this.l28_1);
    }
  }
  o28() {
    if (this.j28_1) {
      this.j28_1 = false;
      // Inline function 'web.mouse.MOUSE_MOVE' call
      // Inline function 'web.events.EventType' call
      // Inline function 'js.reflect.unsafeCast' call
      // Inline function 'kotlin.js.unsafeCast' call
      // Inline function 'kotlin.js.asDynamic' call
      var tmp$ret$4 = 'mousemove';
      removeEventListener(this.e28_1, tmp$ret$4, ensureNotNull(this.l28_1));
      // Inline function 'web.mouse.MOUSE_MOVE' call
      // Inline function 'web.events.EventType' call
      // Inline function 'js.reflect.unsafeCast' call
      // Inline function 'kotlin.js.unsafeCast' call
      // Inline function 'kotlin.js.asDynamic' call
      var tmp$ret$9 = 'mousemove';
      addEventHandler(this.e28_1, tmp$ret$9, ensureNotNull(this.k28_1));
    }
  }
  e29() {
    this.h28_1 = true;
    // Inline function 'web.keyboard.KEY_DOWN' call
    // Inline function 'web.events.EventType' call
    // Inline function 'js.reflect.unsafeCast' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var tmp = 'keydown';
    addEventHandler(this.e28_1, tmp, CPInteractiveHandler$registerKeyListener$lambda(this));
  }
  f29() {
    // Inline function 'web.pointer.CONTEXT_MENU' call
    // Inline function 'web.events.EventType' call
    // Inline function 'js.reflect.unsafeCast' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var tmp = 'contextmenu';
    addEventHandler(this.e28_1, tmp, CPInteractiveHandler$registerContextMenuListener$lambda(this));
  }
}
class CPPopupMenu {
  constructor() {
    var tmp = this;
    var reason = 'Not yet implemented';
    throw NotImplementedError.ui('An operation is not implemented: ' + reason);
  }
  h29(command) {
  }
  i29(component, x, y) {
  }
  l26() {
    return this.g29_1;
  }
}
class Companion_57 {
  constructor() {
    Companion_instance_57 = this;
    this.k1z_1 = new CPFontFactory();
  }
}
class CPFontFactory {
  constructor() {
    Companion_getInstance_57();
  }
  j29(family) {
    return new CPFont(ensureNotNull(family), 12.0);
  }
  l1z() {
    return ensureNotNull(this.j29('Arial'));
  }
}
class CPFont {
  constructor(family, size, weight, posture) {
    weight = weight === VOID ? Weight_NORMAL_getInstance() : weight;
    posture = posture === VOID ? Posture_REGULAR_getInstance() : posture;
    this.k29_1 = family;
    this.l29_1 = size;
    this.m29_1 = weight;
    this.n29_1 = posture;
    var tmp = this;
    tmp.o29_1 = lazy(CPFont$name$delegate$lambda(this));
  }
  p29() {
    return this.l29_1;
  }
  q29(fontSize) {
    return new CPFont(this.k29_1, fontSize, this.m29_1, this.n29_1);
  }
  r29() {
    return this.l29_1;
  }
  s29(weight) {
    return new CPFont(this.k29_1, this.l29_1, weight, this.n29_1);
  }
  toString() {
    return _get_name__das4rk(this);
  }
}
class CPImage {
  constructor(width, height) {
    this.t29_1 = width;
    this.u29_1 = height;
    this.v29_1 = new Image(this.t29_1, this.u29_1);
    this.w29_1 = CPImageFactory_getInstance().z29_1;
    this.x29_1 = CPImageFactory_getInstance().a2a_1;
    this.y29_1 = ensureNotNull(this.x29_1).createImageData(this.t29_1, this.u29_1);
  }
  b2a() {
    return _get__nativeImage__47l87u(this);
  }
  c2a(x, y, w, h, iArray) {
    var data = ensureNotNull(this.y29_1).data;
    var inductionVariable = 0;
    var last = ensureNotNull(iArray).length - 1 | 0;
    if (inductionVariable <= last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        data[i] = toShort(iArray[i]);
      }
       while (inductionVariable <= last);
    ensureNotNull(this.w29_1).width = _get__nativeImage__47l87u(this).width;
    ensureNotNull(this.w29_1).height = _get__nativeImage__47l87u(this).height;
    ensureNotNull(this.x29_1).putImageData(ensureNotNull(this.y29_1), 0, 0);
    _get__nativeImage__47l87u(this).src = ensureNotNull(this.w29_1).toDataURL('image/png');
  }
  d2a() {
    return true;
  }
  e2a() {
    return _get__nativeImage__47l87u(this).complete;
  }
  fb() {
    this.w29_1 = null;
    this.x29_1 = null;
    this.v29_1 = null;
    this.y29_1 = null;
  }
}
class CPImageFactory {
  constructor() {
    CPImageFactory_instance = this;
    var tmp = this;
    var tmp_0 = document.createElement('canvas');
    tmp.z29_1 = tmp_0 instanceof HTMLCanvasElement ? tmp_0 : THROW_CCE();
    var tmp_1 = this;
    // Inline function 'web.canvas.ID' call
    // Inline function 'js.reflect.unsafeCast' call
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var tmp_2 = this.z29_1.getContext('2d');
    tmp_1.a2a_1 = tmp_2 instanceof CanvasRenderingContext2D ? tmp_2 : THROW_CCE();
  }
}
class CanvasRenderingContext2DIGraphics extends AbstractIGraphics {
  constructor(gc) {
    super();
    this.h2a_1 = gc;
  }
  q1x(color) {
    var javaScriptColor = color.p19();
    this.h2a_1.fillStyle = javaScriptColor;
    this.h2a_1.strokeStyle = javaScriptColor;
  }
  r1x() {
    this.h2a_1.beginPath();
  }
  m1v(x, y) {
    this.h2a_1.moveTo(x, y);
  }
  n1v(x, y) {
    this.h2a_1.lineTo(x, y);
  }
  q1v() {
    this.h2a_1.closePath();
  }
  s1x() {
    this.h2a_1.fill();
  }
}
class AbstractAggregation {
  h3() {
    return toString_1(this);
  }
}
class SumAggregation extends AbstractAggregation {
  constructor(column, filter) {
    filter = filter === VOID ? null : filter;
    super();
    this.j2a_1 = column;
    this.k2a_1 = filter;
  }
  n21() {
    var tmp = PrimitiveClasses_getInstance().bd();
    return isInterface(tmp, KClass) ? tmp : THROW_CCE();
  }
  i2a(cuboid, group) {
    var distributiveStatistics = ensureNotNull(cuboid).l2a(group, this.j2a_1, this.k2a_1);
    return distributiveStatistics == null ? null : distributiveStatistics.o2a_1;
  }
  toString() {
    return 'Sum(' + toString_0(this.j2a_1.h3()) + ')';
  }
}
class Companion_58 {
  s2a(path) {
    return new ArrayGroup(path.slice());
  }
}
class Group {}
class ArrayGroup {
  constructor(path) {
    this.t2a_1 = path;
  }
  u2a() {
    return this.t2a_1;
  }
  v2a(i) {
    return ensureNotNull(ensureNotNull(this.u2a())[i]);
  }
  equals(o) {
    if (this === o)
      return true;
    if (!(!(o == null) ? isInterface(o, Group) : false))
      return false;
    var path1 = isInterface(o, Group) ? o : THROW_CCE();
    return contentEquals(this.u2a(), ensureNotNull(path1).u2a());
  }
  hashCode() {
    return contentHashCode(this.u2a());
  }
  toString() {
    return 'ArrayGroup{path=' + contentToString(this.u2a()) + toString(_Char___init__impl__6a9atx(125));
  }
}
class Companion_59 {
  w2a(path) {
    return get_0(this, path.slice());
  }
}
class Dice {
  constructor(path) {
    this.x2a_1 = path;
  }
  equals(o) {
    if (this === o)
      return true;
    if (!(o instanceof Dice))
      return false;
    return contentEquals(this.x2a_1, o.x2a_1);
  }
  hashCode() {
    return contentHashCode(this.x2a_1);
  }
  toString() {
    return 'Dice{path=' + contentToString(this.x2a_1) + toString(_Char___init__impl__6a9atx(125));
  }
}
class Companion_60 {
  y2a(path) {
    return get_1(this, path.slice());
  }
}
class Dimensions {
  constructor(path) {
    this.z2a_1 = path;
    this.a2b_1 = HashMap.i7();
    var inductionVariable = 0;
    var last = path.length;
    if (inductionVariable < last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        var column = path[i];
        // Inline function 'kotlin.collections.set' call
        ensureNotNull(this.a2b_1).o6(column, i);
      }
       while (inductionVariable < last);
  }
  equals(o) {
    if (this === o)
      return true;
    if (!(o instanceof Dimensions))
      return false;
    var path1 = o instanceof Dimensions ? o : THROW_CCE();
    return contentEquals(this.z2a_1, ensureNotNull(path1).z2a_1);
  }
  hashCode() {
    return contentHashCode(this.z2a_1);
  }
  b2b(column) {
    return ensureNotNull(this.a2b_1).c3(column);
  }
}
class DistributiveStatistics {
  static c2b() {
    var $this = createThis(this);
    $this.m2a_1 = 0n;
    $this.n2a_1 = 0n;
    $this.o2a_1 = null;
    $this.p2a_1 = null;
    $this.q2a_1 = null;
    $this.r2a_1 = null;
    return $this;
  }
  static d2b(series, keys, filter) {
    var $this = this.c2b();
    var _iterator__ex2g4s = ensureNotNull(keys).h1();
    while (_iterator__ex2g4s.i1()) {
      var row = _iterator__ex2g4s.j1();
      if (filter == null || filter.h2b(row)) {
        var value = series.c3(row);
        if (!(value == null)) {
          if (isNumber(value)) {
            $this.g2b(value);
          } else {
            if (value instanceof Quantity) {
              $this.g2b(value.f2b_1);
            }
          }
        } else {
          $this.e2b();
        }
      }
    }
    return $this;
  }
  g2b(value) {
    var count = this.m2a_1;
    var countOfMissing = this.n2a_1;
    var sum = this.o2a_1;
    var uncorrectedSumOfSquares = this.p2a_1;
    var minimum = this.q2a_1;
    var maximum = this.r2a_1;
    var v = numberToDouble(value);
    if (!(sum == null)) {
      sum = sum + v;
    } else {
      sum = v;
    }
    if (!(uncorrectedSumOfSquares == null)) {
      uncorrectedSumOfSquares = uncorrectedSumOfSquares + v * v;
    } else {
      uncorrectedSumOfSquares = v * v;
    }
    if (minimum == null || v < numberToDouble(minimum)) {
      minimum = value;
    }
    if (maximum == null || v > numberToDouble(maximum)) {
      maximum = value;
    }
    var _unary__edvuaz = count;
    count = add_0(_unary__edvuaz, get_ONE());
    this.m2a_1 = count;
    this.n2a_1 = countOfMissing;
    this.o2a_1 = sum;
    this.p2a_1 = uncorrectedSumOfSquares;
    this.q2a_1 = minimum;
    this.r2a_1 = maximum;
  }
  e2b() {
    var _unary__edvuaz = this.n2a_1;
    this.n2a_1 = add_0(_unary__edvuaz, get_ONE());
  }
  i2b(distributiveStatistics) {
    var sum = this.o2a_1;
    var uncorrectedSumOfSquares = this.p2a_1;
    var minimum = this.q2a_1;
    var maximum = this.r2a_1;
    this.m2a_1 = add_0(this.m2a_1, distributiveStatistics.m2a_1);
    this.n2a_1 = add_0(this.n2a_1, distributiveStatistics.n2a_1);
    var osum = distributiveStatistics.o2a_1;
    if (!(osum == null)) {
      if (!(sum == null)) {
        sum = sum + osum;
      } else {
        this.o2a_1 = osum;
      }
    }
    var otherUncorrectedSumOfSquares = distributiveStatistics.p2a_1;
    if (!(otherUncorrectedSumOfSquares == null)) {
      if (!(uncorrectedSumOfSquares == null)) {
        uncorrectedSumOfSquares = uncorrectedSumOfSquares + otherUncorrectedSumOfSquares;
      } else {
        uncorrectedSumOfSquares = otherUncorrectedSumOfSquares;
      }
    }
    var otherMinimum = distributiveStatistics.q2a_1;
    if (minimum == null || (!(otherMinimum == null) && numberToDouble(otherMinimum) < numberToDouble(minimum))) {
      minimum = otherMinimum;
    }
    var otherMaximum = distributiveStatistics.r2a_1;
    if (maximum == null || (!(otherMaximum == null) && numberToDouble(otherMaximum) > numberToDouble(maximum))) {
      maximum = otherMaximum;
    }
    this.o2a_1 = sum;
    this.p2a_1 = uncorrectedSumOfSquares;
    this.q2a_1 = minimum;
    this.r2a_1 = maximum;
  }
  j2b() {
    var tmp;
    if (this.m2a_1 > 0n) {
      tmp = ensureNotNull(this.o2a_1) / toNumber_0(this.m2a_1);
    } else {
      tmp = null;
    }
    return tmp;
  }
  k2b() {
    var mean = this.j2b();
    var tmp;
    if (!(mean == null)) {
      tmp = ensureNotNull(this.p2a_1) / toNumber_0(this.m2a_1) - mean * mean;
    } else {
      tmp = null;
    }
    return tmp;
  }
  l2b() {
    var variance = this.k2b();
    var tmp;
    if (!(variance == null)) {
      // Inline function 'kotlin.math.sqrt' call
      tmp = Math.sqrt(variance);
    } else {
      tmp = null;
    }
    return tmp;
  }
  toString() {
    return 'DistributiveStatistics{count=' + this.m2a_1 + ', countOfMissing=' + this.n2a_1 + ', sum=' + this.o2a_1 + ', uncorrectedSumOfSquares=' + this.p2a_1 + ', minimum=' + this.q2a_1 + ', maximum=' + this.r2a_1 + ', mean=' + this.j2b() + ', variance=' + this.k2b() + ', stdDev=' + this.l2b() + toString(_Char___init__impl__6a9atx(125));
  }
}
class GroupFactory {
  m2b() {
    var tmp;
    if (false) {
      tmp = Companion_instance_58.s2a([]);
    } else {
      tmp = LinkedGroup.r2b();
    }
    return tmp;
  }
}
class DimensionsDiceStructure {
  constructor(dimensions, dice, structure) {
    this.s2b_1 = dimensions;
    this.t2b_1 = dice;
    this.u2b_1 = structure;
  }
  equals(o) {
    if (this === o)
      return true;
    if (o == null || !getKClassFromExpression(this).equals(getKClassFromExpression(o)))
      return false;
    var that = o instanceof DimensionsDiceStructure ? o : THROW_CCE();
    if (!ensureNotNull(this.t2b_1).equals(that.t2b_1))
      return false;
    return !equals(this.s2b_1, that.s2b_1) ? false : equals(this.u2b_1, that.u2b_1);
  }
  hashCode() {
    // Inline function 'kotlin.hashCode' call
    var tmp0_safe_receiver = this.s2b_1;
    var tmp1_elvis_lhs = tmp0_safe_receiver == null ? null : hashCode(tmp0_safe_receiver);
    var result = tmp1_elvis_lhs == null ? 0 : tmp1_elvis_lhs;
    var tmp = imul_0(31, result);
    // Inline function 'kotlin.hashCode' call
    var tmp0_safe_receiver_0 = this.t2b_1;
    var tmp1_elvis_lhs_0 = tmp0_safe_receiver_0 == null ? null : hashCode(tmp0_safe_receiver_0);
    result = tmp + (tmp1_elvis_lhs_0 == null ? 0 : tmp1_elvis_lhs_0) | 0;
    var tmp_0 = imul_0(31, result);
    // Inline function 'kotlin.hashCode' call
    var tmp0_safe_receiver_1 = this.u2b_1;
    var tmp1_elvis_lhs_1 = tmp0_safe_receiver_1 == null ? null : hashCode(tmp0_safe_receiver_1);
    result = tmp_0 + (tmp1_elvis_lhs_1 == null ? 0 : tmp1_elvis_lhs_1) | 0;
    return result;
  }
  toString() {
    return 'DimensionsDiceStructure{dimensions=' + this.s2b_1 + ', dice=' + this.t2b_1 + ', structure=' + this.u2b_1 + toString(_Char___init__impl__6a9atx(125));
  }
}
class InMemoryCube$listener$1 {
  constructor(this$0) {
    this.v2b_1 = this$0;
  }
  w2b(event) {
    var _iterator__ex2g4s = this.v2b_1.c2c_1.n6().h1();
    while (_iterator__ex2g4s.i1()) {
      var cuboid = _iterator__ex2g4s.j1();
      cuboid.f2c(true);
    }
  }
  g2c(event) {
    return this.w2b(event);
  }
}
class InMemoryCube {
  constructor(dataFrame) {
    this.c2c_1 = HashMap.i7();
    this.d2c_1 = HashMap.i7();
    var tmp = this;
    tmp.e2c_1 = new InMemoryCube$listener$1(this);
    this.x2b_1 = dataFrame;
    this.z2b_1 = Companion_instance_60.y2a([]);
    this.a2c_1 = Companion_instance_59.w2a([]);
    this.b2c_1 = Companion_instance_63.h2c(booleanArrayOf([]));
    this.y2b_1 = new ApexCuboid(this, this.z2b_1);
    var tmp0 = this.c2c_1;
    var tmp2 = new DimensionsDiceStructure(this.z2b_1, this.a2c_1, this.b2c_1);
    // Inline function 'kotlin.collections.set' call
    var value = this.y2b_1;
    tmp0.o6(tmp2, value);
    dataFrame.i2c(this.e2c_1);
  }
  j2c() {
    return this.x2b_1;
  }
  k2c() {
    return this.y2b_1;
  }
  l2c(cuboid) {
    return this.d2c_1.c3(cuboid);
  }
  toString() {
    return 'InMemoryCube{cuboids=' + this.c2c_1.m6() + toString(_Char___init__impl__6a9atx(125));
  }
}
class LinkedGroup {
  static r2b() {
    var $this = createThis(this);
    init_org_molap_aggregates_cube_LinkedGroup($this);
    $this.n2b_1 = 0;
    $this.o2b_1 = null;
    $this.p2b_1 = null;
    return $this;
  }
  v2a(level) {
    var current = this;
    var inductionVariable = this.n2b_1 - 1 | 0;
    var last = level + 1 | 0;
    if (last <= inductionVariable)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + -1 | 0;
        current = ensureNotNull(current).o2b_1;
      }
       while (!(i === last));
    return ensureNotNull(current).p2b_1;
  }
  u2a() {
    // Inline function 'kotlin.arrayOfNulls' call
    var size = this.n2b_1;
    var path = Array(size);
    var current = this;
    var inductionVariable = this.n2b_1 - 1 | 0;
    if (0 <= inductionVariable)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + -1 | 0;
        path[i] = ensureNotNull(current).p2b_1;
        current = current.o2b_1;
      }
       while (0 <= inductionVariable);
    return path;
  }
  toString() {
    return 'LinkedGroup{path=' + contentToString(this.u2a()) + toString(_Char___init__impl__6a9atx(125));
  }
}
class GroupColumn {
  constructor(group, column, rowFilter) {
    this.m2c_1 = group;
    this.n2c_1 = column;
    this.o2c_1 = rowFilter;
  }
  equals(o) {
    if (this === o)
      return true;
    if (o == null || !getKClassFromExpression(this).equals(getKClassFromExpression(o)))
      return false;
    var that = o instanceof GroupColumn ? o : THROW_CCE();
    if (!equals(this.m2c_1, that.m2c_1))
      return false;
    return !equals(this.n2c_1, that.n2c_1) ? false : !(!(this.o2c_1 == null) ? !equals(this.o2c_1, that.o2c_1) : !(that.o2c_1 == null));
  }
  hashCode() {
    // Inline function 'kotlin.hashCode' call
    var tmp0_safe_receiver = this.m2c_1;
    var tmp1_elvis_lhs = tmp0_safe_receiver == null ? null : hashCode(tmp0_safe_receiver);
    var result = tmp1_elvis_lhs == null ? 0 : tmp1_elvis_lhs;
    var tmp = imul_0(31, result);
    // Inline function 'kotlin.hashCode' call
    var tmp0_safe_receiver_0 = this.n2c_1;
    var tmp1_elvis_lhs_0 = tmp0_safe_receiver_0 == null ? null : hashCode(tmp0_safe_receiver_0);
    result = tmp + (tmp1_elvis_lhs_0 == null ? 0 : tmp1_elvis_lhs_0) | 0;
    result = imul_0(31, result) + (!(this.o2c_1 == null) ? hashCode(this.o2c_1) : 0) | 0;
    return result;
  }
  toString() {
    var tmp = 'GroupColumn{group=' + this.m2c_1 + 'group=';
    // Inline function 'kotlin.hashCode' call
    var tmp0_safe_receiver = this.m2c_1;
    var tmp1_elvis_lhs = tmp0_safe_receiver == null ? null : hashCode(tmp0_safe_receiver);
    var tmp_0 = tmp + (tmp1_elvis_lhs == null ? 0 : tmp1_elvis_lhs) + ', column=' + this.n2c_1 + ', column=';
    // Inline function 'kotlin.hashCode' call
    var tmp0_safe_receiver_0 = this.n2c_1;
    var tmp1_elvis_lhs_0 = tmp0_safe_receiver_0 == null ? null : hashCode(tmp0_safe_receiver_0);
    return tmp_0 + (tmp1_elvis_lhs_0 == null ? 0 : tmp1_elvis_lhs_0) + toString(_Char___init__impl__6a9atx(125));
  }
}
class AbstractCuboid {
  constructor(cube) {
    this.p2c_1 = cube;
    this.q2c_1 = true;
    this.r2c_1 = null;
    this.s2c_1 = null;
    this.t2c_1 = null;
    this.u2c_1 = null;
  }
  v2c() {
    return this.p2c_1;
  }
  f2c(_set____db54di) {
    this.q2c_1 = _set____db54di;
  }
  w2c() {
    return this.q2c_1;
  }
  ta() {
    this.f2c(false);
    this.r2c_1 = CollectionFactory_instance.c17();
    this.s2c_1 = CollectionFactory_instance.c17();
    this.t2c_1 = CollectionFactory_instance.c17();
    this.u2c_1 = CollectionFactory_instance.c17();
  }
  l2a(group, column, rowExcluder) {
    if (this.w2c()) {
      this.ta();
    }
    var tmp;
    if (!(group == null)) {
      var key = new GroupColumn(group, column, rowExcluder);
      if (!ensureNotNull(this.r2c_1).a3(key)) {
        var child = this.v2c().l2c(this);
        var distributiveStatistics;
        if (!(child == null)) {
          distributiveStatistics = DistributiveStatistics.c2b();
          var _iterator__ex2g4s = ensureNotNull(child.y2c(group)).h1();
          while (_iterator__ex2g4s.i1()) {
            var childGroup = _iterator__ex2g4s.j1();
            var childDistributiveStatistics = child.l2a(childGroup, column, rowExcluder);
            distributiveStatistics.i2b(ensureNotNull(childDistributiveStatistics));
          }
        } else {
          var rows = this.x2c(group);
          if (!(rows == null)) {
            distributiveStatistics = DistributiveStatistics.d2b(column, rows, rowExcluder);
          } else {
            distributiveStatistics = null;
          }
        }
        var tmp0 = ensureNotNull(this.r2c_1);
        // Inline function 'kotlin.collections.set' call
        var value = distributiveStatistics;
        tmp0.o6(key, value);
        return distributiveStatistics;
      }
      tmp = ensureNotNull(this.r2c_1).c3(key);
    } else {
      tmp = null;
    }
    return tmp;
  }
}
class ApexCuboid$listener$1 {
  constructor(this$0) {
    this.b2d_1 = this$0;
  }
  w2b(event) {
    this.b2d_1.f2c(true);
  }
  g2c(event) {
    return this.w2b(event);
  }
}
class ApexCuboid extends AbstractCuboid {
  constructor(cube, dimensions) {
    super(cube);
    this.i2d_1 = cube;
    this.k2d_1 = GroupFactory_instance.m2b();
    this.l2d_1 = listOf(this.k2d_1);
    var tmp = this;
    tmp.m2d_1 = new ApexCuboid$listener$1(this);
    this.n2d_1 = emptySet();
    this.j2d_1 = dimensions;
    cube.x2b_1.i2c(this.m2d_1);
  }
  v2c() {
    return this.i2d_1;
  }
  z2c() {
    return this.j2d_1;
  }
  a2d() {
    return this.l2d_1;
  }
  y2c(group) {
    return null;
  }
  x2c(group) {
    return this.i2d_1.j2c().o2d();
  }
}
class Cuboid$Companion$ALL$1 {
  toString() {
    return '(all)';
  }
}
class Companion_61 {
  constructor() {
    Companion_instance_61 = this;
    var tmp = this;
    tmp.p2d_1 = new Cuboid$Companion$ALL$1();
  }
}
class WeakQueryListener {
  constructor($outer, listener) {
    this.r2d_1 = $outer;
    this.q2d_1 = new WeakReference(listener);
  }
  s2d() {
    var l = this.jk();
    if (!(l == null)) {
      l.s2d();
    } else {
      this.r2d_1.v2d(this);
    }
  }
  jk() {
    return this.q2d_1.zj();
  }
  toString() {
    var l = this.jk();
    var tmp;
    if (!(l == null)) {
      tmp = 'Weak[' + toString_1(l) + ']';
    } else {
      tmp = anyToString(this);
    }
    return tmp;
  }
}
class Companion_62 {}
class AbstractQuery {
  static w2d() {
    var $this = createThis(this);
    $this.t2d_1 = true;
    $this.u2d_1 = CollectionFactory_instance.nk();
    return $this;
  }
  x2d(listener) {
    var weakListener = new WeakQueryListener(this, listener);
    this.u2d_1.c1(weakListener);
  }
  v2d(listener) {
    if (listener instanceof WeakQueryListener) {
      var removed = this.u2d_1.e3(listener);
    } else {
      var toRemove = null;
      var _iterator__ex2g4s = this.u2d_1.h1();
      while (_iterator__ex2g4s.i1()) {
        var queryListener = _iterator__ex2g4s.j1();
        var comparable;
        if (queryListener instanceof WeakQueryListener) {
          comparable = queryListener.jk();
        } else {
          comparable = queryListener;
        }
        if (equals(listener, comparable)) {
          toRemove = queryListener;
        }
      }
      if (!(toRemove == null)) {
        var removed_0 = this.u2d_1.e3(toRemove);
      }
    }
  }
  y2d() {
    var _iterator__ex2g4s = this.u2d_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var listener = _iterator__ex2g4s.j1();
      listener.s2d();
    }
  }
}
class CuboidQuery$queryListener$1 {
  constructor(this$0) {
    this.l2e_1 = this$0;
  }
  s2d() {
    this.l2e_1.e2e_1 = null;
    this.l2e_1.t2d_1 = true;
    this.l2e_1.y2d();
  }
}
class CuboidQuery$dataFrameListener$1 {
  constructor(this$0) {
    this.m2e_1 = this$0;
  }
  w2b(event) {
    this.m2e_1.t2d_1 = true;
    this.m2e_1.y2d();
  }
  g2c(event) {
    return this.w2b(event);
  }
}
class CuboidQuery extends AbstractQuery {
  b2e() {
    if (this.e2e_1 == null) {
      this.e2e_1 = ensureNotNull(this.g2e_1).n2e(ensureNotNull(this.f2e_1).b2e());
    }
    return this.e2e_1;
  }
  a2e() {
    return this.h2e_1;
  }
  a2d() {
    if (this.t2d_1) {
      run(this);
    }
    return this.i2e_1;
  }
  static o2e(cuboid, aggregations) {
    var $this = this.w2d();
    init_org_molap_aggregates_query_CuboidQuery($this);
    $this.e2e_1 = cuboid;
    var tmp = $this;
    tmp.h2e_1 = isArray(aggregations) ? aggregations : THROW_CCE();
    ensureNotNull(ensureNotNull($this.b2e()).v2c()).j2c().i2c($this.k2e_1);
    return $this;
  }
  z2d(path, aggregation) {
    return aggregation.i2a(this.b2e(), path);
  }
  z2c() {
    return ensureNotNull(ensureNotNull(this.b2e()).z2c());
  }
}
class Series {}
class AbstractSeries {
  static f2f($box) {
    return createThis(this, $box);
  }
  toString() {
    var tmp;
    if (!(this.h3() == null)) {
      tmp = toString_0(this.h3());
    } else {
      tmp = anyToString(this);
    }
    return tmp;
  }
}
class DimensionSeries extends AbstractSeries {
  static e2f($outer, dataFrame, column, columnIndex, $box) {
    if ($box === VOID)
      $box = {};
    $box.d2f_1 = $outer;
    var $this = this.f2f($box);
    $this.a2f_1 = dataFrame;
    $this.b2f_1 = column;
    $this.c2f_1 = columnIndex;
    return $this;
  }
  h3() {
    return this.b2f_1;
  }
  n21() {
    return this.a2f_1.g2f(this.b2f_1);
  }
  h2f(key) {
    var tmp;
    if (!(key == null)) {
      tmp = key.v2a(this.c2f_1);
    } else {
      tmp = null;
    }
    return tmp;
  }
  c3(key) {
    return this.h2f((key == null ? true : isInterface(key, Group)) ? key : THROW_CCE());
  }
}
class AggregationSeries extends AbstractSeries {
  static l2f($outer, aggregation, column, $box) {
    if ($box === VOID)
      $box = {};
    $box.k2f_1 = $outer;
    var $this = this.f2f($box);
    $this.i2f_1 = aggregation;
    $this.j2f_1 = column;
    return $this;
  }
  h3() {
    return this.j2f_1;
  }
  n21() {
    var tmp = PrimitiveClasses_getInstance().bd();
    return isInterface(tmp, KClass) ? tmp : THROW_CCE();
  }
  h2f(key) {
    return this.k2f_1.r2e_1.z2d(key, this.i2f_1);
  }
  c3(key) {
    return this.h2f((key == null ? true : isInterface(key, Group)) ? key : THROW_CCE());
  }
}
class QueryDataFrame$queryListener$1 {
  constructor(this$0) {
    this.m2f_1 = this$0;
  }
  s2d() {
    this.m2f_1.t2e_1 = null;
    this.m2f_1.u2e_1 = null;
    this.m2f_1.p2f(new DataFrameEvent(emptyList(), null, true));
  }
}
class DataFrame {}
function get_length() {
  return this.e2g();
}
class AbstractDataFrame {
  static r2f() {
    var $this = createThis(this);
    $this.n2f_1 = CollectionFactory_instance.nk();
    var tmp = $this;
    tmp.o2f_1 = lazy(AbstractDataFrame$cube$delegate$lambda($this));
    return $this;
  }
  v2c() {
    var tmp0 = this.o2f_1;
    var tmp = KProperty1;
    // Inline function 'kotlin.getValue' call
    getPropertyCallableRef('cube', 1, tmp, AbstractDataFrame$_get_cube_$ref_umz014(), null);
    return tmp0.z2();
  }
  o2d() {
    return this.s2f().jm();
  }
  a2g() {
    return this.t2f().jm();
  }
  b2g(index) {
    return this.s2f().km(index);
  }
  z2e(index) {
    return this.t2f().km(index);
  }
  s2g(row) {
    return this.s2f().v2f(row);
  }
  d2g(column) {
    return this.t2f().v2f(column);
  }
  e2g() {
    return this.s2f().k1();
  }
  y2e() {
    return this.t2f().k1();
  }
  z2f(column) {
    return ColumnSeries.o2g(this, column);
  }
  t2g(aggregations) {
    return this.f2g(true, aggregations.slice());
  }
  f2g(includeIndex, aggregations) {
    var query = CuboidQuery.o2e(this.v2c().k2c(), aggregations.slice());
    return QueryDataFrame.q2f(query, includeIndex);
  }
  u2g(column) {
    var tmp = this.z2f(column);
    return new SumAggregation((!(tmp == null) ? isInterface(tmp, Series) : false) ? tmp : THROW_CCE());
  }
  g2g(column) {
    return column == null ? null : toString_1(column);
  }
  v2g() {
    var _iterator__ex2g4s = this.a2g().h1();
    while (_iterator__ex2g4s.i1()) {
      var column = _iterator__ex2g4s.j1();
      print(Companion_instance_64.q2g(this.g2g(column), 19));
      print(': ');
      var value = this.g2f(column);
      print(Companion_instance_64.q2g(!(value == null) ? value.kc() : '', 19));
      println_0();
    }
  }
  u1p() {
    var _iterator__ex2g4s = this.a2g().h1();
    while (_iterator__ex2g4s.i1()) {
      var column = _iterator__ex2g4s.j1();
      print(Companion_instance_64.r2g(20, Companion_instance_64.q2g(this.g2g(column), 19)));
    }
    println_0();
    var _iterator__ex2g4s_0 = ensureNotNull(this.o2d()).h1();
    while (_iterator__ex2g4s_0.i1()) {
      var row = _iterator__ex2g4s_0.j1();
      var _iterator__ex2g4s_1 = ensureNotNull(this.a2g()).h1();
      while (_iterator__ex2g4s_1.i1()) {
        var column_0 = _iterator__ex2g4s_1.j1();
        var value = this.x2f(row, column_0);
        if (!(value == null) ? isByteArray(value) : false) {
          var tmp = value;
          // Inline function 'kotlin.text.HexFormat' call
          // Inline function 'kotlin.apply' call
          var this_0 = new Builder_0();
          this_0.nh().ih('0x');
          var tmp$ret$2 = this_0.s3();
          value = toHexString(tmp, tmp$ret$2);
        }
        if (!(value == null)) {
          print(Companion_instance_64.r2g(20, Companion_instance_64.q2g(toString_1(value), 19)));
        } else {
          print(Companion_instance_64.r2g(20, Companion_instance_64.q2g('(null)', 19)));
        }
      }
      println_0();
    }
  }
  w2g(listener) {
    this.n2f_1.c1(listener);
  }
  i2c(listener) {
    this.n2f_1.c1(new WeakDataFrameListener(this, listener));
  }
  h2g(listener) {
    if (listener instanceof WeakDataFrameListener) {
      this.n2f_1.e3(listener);
    } else {
      var toRemove = null;
      var _iterator__ex2g4s = this.n2f_1.h1();
      while (_iterator__ex2g4s.i1()) {
        var dataFrameListener = _iterator__ex2g4s.j1();
        var comparable;
        if (dataFrameListener instanceof WeakDataFrameListener) {
          comparable = dataFrameListener.jk();
        } else {
          comparable = dataFrameListener;
        }
        if (equals(listener, comparable)) {
          toRemove = dataFrameListener;
        }
      }
      if (!(toRemove == null)) {
        this.n2f_1.e3(toRemove);
      }
    }
  }
  x2g() {
    this.n2f_1.u4();
  }
  p2f(event) {
    var _iterator__ex2g4s = this.n2f_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var listener = _iterator__ex2g4s.j1();
      listener.g2c(event);
    }
  }
}
class QueryDataFrame extends AbstractDataFrame {
  static q2f(query, includeIndex) {
    var $this = this.r2f();
    $this.t2e_1 = null;
    $this.u2e_1 = null;
    var tmp = $this;
    tmp.v2e_1 = new QueryDataFrame$queryListener$1($this);
    $this.r2e_1 = query;
    $this.s2e_1 = includeIndex;
    query.x2d($this.v2e_1);
    return $this;
  }
  s2f() {
    return ensureNotNull(_get_cacheRowIndex__mo0sbb(this));
  }
  t2f() {
    return ensureNotNull(_get_cacheColumnIndex__9igbhr(this));
  }
  u2f(column) {
    var columnIndex = this.t2f().v2f(ensureNotNull(column));
    var tmp;
    if (columnIndex >= 0) {
      if (this.s2e_1) {
        if (columnIndex < ensureNotNull(this.r2e_1.z2c()).z2a_1.length) {
          var c = ensureNotNull(this.r2e_1.z2c()).z2a_1[columnIndex];
          var dataFrame = ensureNotNull(ensureNotNull(this.r2e_1.b2e()).v2c()).j2c();
          return dataFrame.g2f(c);
        }
        columnIndex = columnIndex - ensureNotNull(this.r2e_1.z2c()).z2a_1.length | 0;
      }
      tmp = this.r2e_1.a2e()[columnIndex].n21();
    } else {
      tmp = PrimitiveClasses_getInstance().sc();
    }
    return tmp;
  }
  g2f(column) {
    return this.u2f((column == null ? true : typeof column === 'string') ? column : THROW_CCE());
  }
  w2f(path, column) {
    var columnIndex = this.t2f().v2f(ensureNotNull(column));
    var tmp;
    if (columnIndex == null || columnIndex >= 0) {
      if (path == null) {
        println('QueryDataFrame: path is null');
      }
      if (this.s2e_1) {
        if (ensureNotNull(columnIndex) < ensureNotNull(this.r2e_1.z2c()).z2a_1.length) {
          if (!(this.r2e_1.z2c() == null)) {
            var c = ensureNotNull(this.r2e_1.z2c()).z2a_1[columnIndex];
            columnIndex = ensureNotNull(this.r2e_1.z2c()).b2b(c);
          }
          var tmp_0;
          if (!(path == null)) {
            tmp_0 = path.v2a(ensureNotNull(columnIndex));
          } else {
            tmp_0 = null;
          }
          return tmp_0;
        }
        columnIndex = columnIndex - ensureNotNull(this.r2e_1.z2c()).z2a_1.length | 0;
      }
      tmp = this.r2e_1.z2d(path, this.r2e_1.a2e()[ensureNotNull(columnIndex)]);
    } else {
      tmp = null;
    }
    return tmp;
  }
  x2f(row, column) {
    var tmp = (row == null ? true : isInterface(row, Group)) ? row : THROW_CCE();
    return this.w2f(tmp, (column == null ? true : typeof column === 'string') ? column : THROW_CCE());
  }
  y2f(column) {
    var columnIndex = this.t2f().v2f(ensureNotNull(column));
    if (this.s2e_1) {
      if (columnIndex < ensureNotNull(this.r2e_1.z2c()).z2a_1.length) {
        var tmp = ensureNotNull(ensureNotNull(this.r2e_1.b2e()).v2c()).j2c();
        return DimensionSeries.e2f(this, isInterface(tmp, DataFrame) ? tmp : THROW_CCE(), column, columnIndex);
      }
      columnIndex = columnIndex - ensureNotNull(this.r2e_1.z2c()).z2a_1.length | 0;
    }
    return AggregationSeries.l2f(this, this.r2e_1.a2e()[columnIndex], column);
  }
  z2f(column) {
    return this.y2f((column == null ? true : typeof column === 'string') ? column : THROW_CCE());
  }
  o2d() {
    var tmp = this.r2e_1.a2d();
    return (!(tmp == null) ? isInterface(tmp, Iterable) : false) ? tmp : THROW_CCE();
  }
  a2g() {
    return this.t2f().jm();
  }
  b2g(index) {
    var tmp = ensureNotNull(this.r2e_1).a2d();
    var groups = (!(tmp == null) ? isInterface(tmp, KtList) : false) ? tmp : THROW_CCE();
    var tmp_0;
    if (index >= 0 && index < groups.k1()) {
      tmp_0 = groups.l1(index);
    } else {
      tmp_0 = null;
    }
    return tmp_0;
  }
  z2e(index) {
    var index_0 = index;
    if (this.s2e_1) {
      if (index_0 < ensureNotNull(this.r2e_1.z2c()).z2a_1.length) {
        return toString_0(ensureNotNull(this.r2e_1.z2c()).z2a_1[index_0]);
      }
      index_0 = index_0 - ensureNotNull(this.r2e_1.z2c()).z2a_1.length | 0;
    }
    return ensureNotNull(this.r2e_1.a2e()[index_0].h3());
  }
  c2g(column) {
    return this.t2f().v2f(ensureNotNull(column));
  }
  d2g(column) {
    return this.c2g((column == null ? true : typeof column === 'string') ? column : THROW_CCE());
  }
  e2g() {
    return ensureNotNull(this.r2e_1.a2d()).k1();
  }
  y2e() {
    var tmp;
    if (this.s2e_1) {
      tmp = ensureNotNull(this.r2e_1.z2c()).z2a_1.length + this.r2e_1.a2e().length | 0;
    } else {
      tmp = this.r2e_1.a2e().length;
    }
    return tmp;
  }
}
class Companion_63 {
  h2c(path) {
    return get_2(this, taggedArrayCopy(path));
  }
}
class Structure {
  constructor(path) {
    this.i2g_1 = path;
  }
  equals(o) {
    if (this === o)
      return true;
    if (!(o instanceof Structure))
      return false;
    return contentEquals_0(this.i2g_1, o.i2g_1);
  }
  hashCode() {
    return contentHashCode_0(this.i2g_1);
  }
  toString() {
    return 'Structure{path=' + contentToString_0(this.i2g_1) + toString(_Char___init__impl__6a9atx(125));
  }
}
class WeakDataFrameListener {
  constructor($outer, listener) {
    this.k2g_1 = $outer;
    this.j2g_1 = new WeakReference(listener);
  }
  l2g(event) {
    var l = this.jk();
    if (!(l == null)) {
      l.g2c(event);
    } else {
      this.k2g_1.h2g(this);
    }
  }
  g2c(event) {
    return this.l2g(event);
  }
  jk() {
    return this.j2g_1.zj();
  }
}
class ColumnSeries extends AbstractSeries {
  static o2g($outer, column, $box) {
    if ($box === VOID)
      $box = {};
    $box.n2g_1 = $outer;
    var $this = this.f2f($box);
    $this.m2g_1 = column;
    $this.m2g_1 = $this.m2g_1;
    return $this;
  }
  h3() {
    return this.m2g_1;
  }
  n21() {
    return this.n2g_1.g2f(this.m2g_1);
  }
  p2g(key) {
    return this.n2g_1.x2f(key, this.m2g_1);
  }
  c3(key) {
    return this.p2g((key == null ? true : !(key == null)) ? key : THROW_CCE());
  }
}
class Companion_64 {
  q2g(str, maxWidth) {
    if (str == null) {
      return null;
    }
    var tmp;
    if (str.length <= maxWidth) {
      tmp = str;
    } else {
      tmp = substring(str, 0, maxWidth - 3 | 0) + '...';
    }
    return tmp;
  }
  r2g(width, str) {
    if (str == null) {
      return null;
    }
    var tmp;
    if (str.length < width) {
      var tmp_0 = 0;
      var tmp_1 = width - str.length | 0;
      var tmp_2 = charArray(tmp_1);
      while (tmp_0 < tmp_1) {
        tmp_2[tmp_0] = _Char___init__impl__6a9atx(32);
        tmp_0 = tmp_0 + 1 | 0;
      }
      tmp = str + concatToString(tmp_2);
    } else {
      tmp = substring(str, 0, width);
    }
    return tmp;
  }
}
class ColumnStatistics {
  constructor(min, max, sum, count) {
    this.y2g_1 = min;
    this.z2g_1 = max;
    this.a2h_1 = sum;
    this.b2h_1 = count;
  }
  toString() {
    return 'ColumnStatistics{min=' + this.y2g_1 + ', max=' + this.z2g_1 + ', sum=' + this.a2h_1 + ', count=' + this.b2h_1 + toString(_Char___init__impl__6a9atx(125));
  }
}
class DataFrameEvent {
  constructor(affectedRows, affectedColumns, isStructureChanged) {
    this.c2h_1 = affectedRows;
    this.d2h_1 = affectedColumns;
    this.e2h_1 = isStructureChanged;
  }
}
class DataFrameHelper {
  f2h(dataFrame, column) {
    var min = null;
    var max = null;
    var sum = 0.0;
    var count = 0n;
    var series = ensureNotNull(dataFrame.z2f(column));
    var _iterator__ex2g4s = dataFrame.o2d().h1();
    while (_iterator__ex2g4s.i1()) {
      var row = _iterator__ex2g4s.j1();
      var value = series.c3(row);
      if (!(value == null)) {
        if (isNumber(value)) {
          var number = value;
          var d = numberToDouble(number);
          if (typeof number === 'number') {
            if (!isNaN_3(d) && !isInfinite_1(d)) {
              if (min == null || d < numberToDouble(min)) {
                min = number;
              }
              if (max == null || d > numberToDouble(max)) {
                max = number;
              }
              sum = sum + number;
              var _unary__edvuaz = count;
              count = add_0(_unary__edvuaz, get_ONE());
            }
          } else {
            if (typeof number === 'number') {
              var f = number;
              if (!isNaN_4(f) && !isInfinite_2(f)) {
                if (min == null || d < numberToDouble(min)) {
                  min = number;
                }
                if (max == null || d > numberToDouble(max)) {
                  max = number;
                }
              }
            } else {
              if (min == null || d < numberToDouble(min)) {
                min = number;
              }
              if (max == null || d > numberToDouble(max)) {
                max = number;
              }
              sum = sum + d;
              var _unary__edvuaz_0 = count;
              count = add_0(_unary__edvuaz_0, get_ONE());
            }
          }
        }
      }
    }
    return new ColumnStatistics(min, max, sum, count);
  }
}
class DefaultDataFrame extends AbstractDataFrame {
  constructor(dataFrame) {
    return new.target.q2h(dataFrame);
  }
  static q2h(dataFrame) {
    var $this = this.r2f();
    $this.o2h_1 = IntegerRangeUniqueIndex.t2h(0, dataFrame.e2g() - 1 | 0);
    var columns = ArrayList.n1(dataFrame.y2e());
    var series = ArrayList.n1(dataFrame.y2e());
    var c = 0;
    var _iterator__ex2g4s = dataFrame.a2g().h1();
    while (_iterator__ex2g4s.i1()) {
      var column = _iterator__ex2g4s.j1();
      var columnKey = dataFrame.z2e(c);
      if (!(columnKey == null)) {
        var toString = toString_1(columnKey);
        var serie = createSeries($this, dataFrame, column);
        if (!(serie == null)) {
          columns.c1(toString);
          series.c1(serie);
        }
      }
      c = c + 1 | 0;
    }
    var tmp = $this;
    // Inline function 'kotlin.collections.toTypedArray' call
    var tmp$ret$0 = copyToArray(columns);
    tmp.p2h_1 = DefaultUniqueIndex.x2e(tmp$ret$0.slice());
    var tmp_0 = $this;
    // Inline function 'kotlin.collections.toTypedArray' call
    tmp_0.series = copyToArray(series);
    return $this;
  }
  u2h(_set____db54di) {
    this.o2h_1 = _set____db54di;
  }
  s2f() {
    return this.o2h_1;
  }
  v2h(_set____db54di) {
    this.p2h_1 = _set____db54di;
  }
  t2f() {
    return this.p2h_1;
  }
  w2h(_set____db54di) {
    this.series = _set____db54di;
  }
  x2h() {
    return this.series;
  }
  y2h(row) {
    return PrimitiveClasses_getInstance().sc();
  }
  z2h(row) {
    return this.y2h((!(row == null) ? typeof row === 'number' : false) ? row : THROW_CCE());
  }
  a2i(column) {
    return this.series[this.p2h_1.v2f(column)].n21();
  }
  g2f(column) {
    return this.a2i((!(column == null) ? typeof column === 'string' : false) ? column : THROW_CCE());
  }
  b2i(row, column) {
    return this.series[this.p2h_1.v2f(column)].c3(row);
  }
  x2f(row, column) {
    var tmp = (!(row == null) ? typeof row === 'number' : false) ? row : THROW_CCE();
    return this.b2i(tmp, (!(column == null) ? typeof column === 'string' : false) ? column : THROW_CCE());
  }
  c2i(column) {
    var serie = this.series[this.d2g(column)];
    return serie;
  }
  z2f(column) {
    return this.c2i((!(column == null) ? typeof column === 'string' : false) ? column : THROW_CCE());
  }
}
class AbstractUniqueIndex$keys$1$iterator$1 {
  constructor(this$0) {
    this.e2i_1 = this$0;
    this.d2i_1 = 0;
  }
  i1() {
    return this.d2i_1 < this.e2i_1.k1();
  }
  j1() {
    var _unary__edvuaz = this.d2i_1;
    this.d2i_1 = _unary__edvuaz + 1 | 0;
    return this.e2i_1.km(_unary__edvuaz);
  }
  t4() {
    throw UnsupportedOperationException.q3();
  }
}
class AbstractUniqueIndex$keys$1 {
  constructor(this$0) {
    this.f2i_1 = this$0;
  }
  h1() {
    return new AbstractUniqueIndex$keys$1$iterator$1(this.f2i_1);
  }
}
class AbstractUniqueIndex extends AbstractIndex {
  static g2i() {
    return this.im();
  }
  jm() {
    return new AbstractUniqueIndex$keys$1(this);
  }
}
class Lazy {
  constructor($outer, $box) {
    boxApply(this, $box);
    this.m2i_1 = $outer;
    var tmp = this;
    tmp.h2i_1 = lazy(DefaultUniqueIndex$Lazy$indexDelegate$lambda(this));
    this.i2i_1 = this.h2i_1;
    var tmp_0 = this;
    tmp_0.j2i_1 = lazy(DefaultUniqueIndex$Lazy$listDelegate$lambda(this));
    this.k2i_1 = this.j2i_1;
    this.l2i_1 = false;
  }
  o2i() {
    var tmp0 = this.i2i_1;
    var tmp = KProperty1;
    // Inline function 'kotlin.getValue' call
    getPropertyCallableRef('index', 1, tmp, DefaultUniqueIndex$Lazy$_get_index_$ref_czlexq(), null);
    return tmp0.z2();
  }
  q2i() {
    var tmp0 = this.k2i_1;
    var tmp = KProperty1;
    // Inline function 'kotlin.getValue' call
    getPropertyCallableRef('list', 1, tmp, DefaultUniqueIndex$Lazy$_get_list_$ref_cf7120(), null);
    return tmp0.z2();
  }
  v2f(key) {
    var index = this.o2i();
    if (!this.l2i_1) {
      this.r2i(index);
      this.l2i_1 = true;
    }
    var i = index.c3(key);
    if (!(i == null)) {
      return i;
    } else {
      throw RuntimeException.o9('Illegal key ' + toString_0(key) + ' not found in ' + toString_1(index));
    }
  }
  k1() {
    return this.q2i().k1();
  }
  r2i(index) {
  }
}
class Companion_65 {}
class DefaultUniqueIndex$3 extends Lazy {
  constructor(this$0, $index, $list, $box) {
    if ($box === VOID)
      $box = {};
    $box.y2i_1 = $index;
    $box.z2i_1 = $list;
    super(this$0, $box);
  }
  n2i() {
    return this.y2i_1;
  }
  p2i() {
    return this.z2i_1;
  }
}
class DefaultUniqueIndex extends AbstractUniqueIndex {
  static x2e(keys) {
    return this.a2j(Duplicate_UseFirstWarn_getInstance(), keys.slice());
  }
  static a2j(duplicate, keys) {
    var $this = this.g2i();
    init_org_molap_index_DefaultUniqueIndex($this);
    var tmp0_elvis_lhs = keys.length;
    var index = HashMap.w7(tmp0_elvis_lhs == null ? 0 : tmp0_elvis_lhs);
    var list = ArrayList.q1();
    var inductionVariable = 0;
    var last = keys.length;
    if (inductionVariable < last)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        var key = keys[i];
        if (!index.a3(key)) {
          index.o6(key, i);
          list.c1(key);
        } else {
          switch (duplicate.g3_1) {
            case 2:
              break;
            case 3:
              try {
                throw IllegalStateException.w3('Index not unique for value ' + toString_0(key) + ' (address=' + i + ')');
              } catch ($p) {
                if ($p instanceof IllegalStateException) {
                  var e = $p;
                } else {
                  throw $p;
                }
              }

              break;
            case 4:
              index.o6(key, i);
              list.e3(key);
              list.c1(key);
              println('Index not unique for value ' + toString_0(key) + ' (address=' + i + '): will use last');
              break;
            case 0:
              index.o6(key, i);
              list.e3(key);
              list.c1(key);
              println('Index not unique for value ' + toString_0(key) + ' (address=' + i + '): will remove first');
              break;
            case 1:
              break;
            case 5:
              throw IllegalStateException.w3('Index not unique for value ' + toString_0(key) + ' (address=' + i + ')');
            default:
              noWhenBranchMatchedException();
              break;
          }
        }
      }
       while (inductionVariable < last);
    var tmp = $this;
    tmp.w2e_1 = new DefaultUniqueIndex$3($this, index, list);
    return $this;
  }
  v2f(key) {
    return ensureNotNull(this.w2e_1).v2f(key);
  }
  jm() {
    return ensureNotNull(this.w2e_1).q2i();
  }
  km(i) {
    var tmp;
    if (i >= 0 && i < this.k1()) {
      tmp = ensureNotNull(this.w2e_1).q2i().l1(i);
    } else {
      throw RuntimeException.o9('Key is out of range');
    }
    return tmp;
  }
  k1() {
    return ensureNotNull(this.w2e_1).k1();
  }
}
class IntegerRangeUniqueIndex$keys$1$iterator$1 {
  constructor(this$0) {
    this.c2j_1 = this$0;
    this.b2j_1 = this$0.r2h_1;
  }
  i1() {
    return this.b2j_1 <= this.c2j_1.s2h_1;
  }
  j1() {
    var _unary__edvuaz = this.b2j_1;
    this.b2j_1 = _unary__edvuaz + 1 | 0;
    return _unary__edvuaz;
  }
  t4() {
    throw UnsupportedOperationException.q3();
  }
}
class IntegerRangeUniqueIndex$keys$1 {
  constructor(this$0) {
    this.d2j_1 = this$0;
  }
  h1() {
    return new IntegerRangeUniqueIndex$keys$1$iterator$1(this.d2j_1);
  }
}
class IntegerRangeUniqueIndex extends AbstractUniqueIndex {
  static t2h(from, to) {
    var $this = this.g2i();
    $this.r2h_1 = from;
    $this.s2h_1 = to;
    return $this;
  }
  e2j(key) {
    return this.cg(key) ? key - this.r2h_1 | 0 : -1;
  }
  v2f(key) {
    return this.e2j((!(key == null) ? typeof key === 'number' : false) ? key : THROW_CCE());
  }
  cg(key) {
    return key >= this.r2h_1 && key <= this.s2h_1;
  }
  km(i) {
    return this.r2h_1 + i | 0;
  }
  jm() {
    return new IntegerRangeUniqueIndex$keys$1(this);
  }
  k1() {
    return (this.s2h_1 - this.r2h_1 | 0) + 1 | 0;
  }
  toString() {
    return 'IntegerRangeUniqueIndex{from=' + this.r2h_1 + ', to=' + this.s2h_1 + toString(_Char___init__impl__6a9atx(125));
  }
}
class Duplicate extends Enum {}
class Graph {}
class MutableSeries {}
class DefaultSeries extends AbstractSeries {
  h3() {
    return this.h2j_1;
  }
  n21() {
    return this.k2j_1;
  }
  static l2j(values, name, type, index) {
    name = name === VOID ? null : name;
    type = type === VOID ? PrimitiveClasses_getInstance().sc() : type;
    index = index === VOID ? IntegerRangeUniqueIndex.t2h(0, values.length - 1 | 0) : index;
    var $this = this.f2f();
    init_org_molap_series_DefaultSeries($this);
    $this.i2j_1 = values;
    $this.k2j_1 = type;
    $this.h2j_1 = name;
    $this.j2j_1 = index;
    return $this;
  }
  l1(key) {
    return this.i2j_1[key];
  }
  c3(key) {
    return this.l1((!(key == null) ? typeof key === 'number' : false) ? key : THROW_CCE());
  }
}
class DoubleSeries extends AbstractSeries {
  h3() {
    return this.m2j_1;
  }
  static q2j(values, available) {
    var $this = this.f2f();
    init_org_molap_series_DoubleSeries($this);
    $this.m2j_1 = null;
    $this.o2j_1 = values;
    $this.p2j_1 = IntegerRangeUniqueIndex.t2h(0, values.length - 1 | 0);
    $this.n2j_1 = available;
    return $this;
  }
  n21() {
    var tmp = PrimitiveClasses_getInstance().bd();
    return isInterface(tmp, KClass) ? tmp : THROW_CCE();
  }
  l1(key) {
    var tmp;
    if (this.r2j(key)) {
      tmp = (null == null ? true : typeof null === 'number') ? null : THROW_CCE();
    } else {
      tmp = this.o2j_1[key];
    }
    return tmp;
  }
  c3(key) {
    return this.l1((!(key == null) ? typeof key === 'number' : false) ? key : THROW_CCE());
  }
  r2j(key) {
    return !(this.n2j_1 == null) && !this.n2j_1[key];
  }
}
class FloatSeries extends AbstractSeries {
  h3() {
    return this.s2j_1;
  }
  static w2j(values, available) {
    var $this = this.f2f();
    init_org_molap_series_FloatSeries($this);
    $this.s2j_1 = null;
    $this.u2j_1 = values;
    $this.v2j_1 = IntegerRangeUniqueIndex.t2h(0, values.length - 1 | 0);
    $this.t2j_1 = available;
    return $this;
  }
  n21() {
    var tmp = PrimitiveClasses_getInstance().ad();
    return isInterface(tmp, KClass) ? tmp : THROW_CCE();
  }
  l1(key) {
    var tmp;
    if (this.r2j(key)) {
      tmp = (null == null ? true : typeof null === 'number') ? null : THROW_CCE();
    } else {
      tmp = this.u2j_1[key];
    }
    return tmp;
  }
  c3(key) {
    return this.l1((!(key == null) ? typeof key === 'number' : false) ? key : THROW_CCE());
  }
  r2j(key) {
    return !(this.t2j_1 == null) && !this.t2j_1[key];
  }
}
class IntegerSeries extends AbstractSeries {
  h3() {
    return this.x2j_1;
  }
  static b2k(values, available) {
    var $this = this.f2f();
    init_org_molap_series_IntegerSeries($this);
    $this.x2j_1 = null;
    $this.z2j_1 = values;
    $this.a2k_1 = IntegerRangeUniqueIndex.t2h(0, values.length - 1 | 0);
    $this.y2j_1 = available;
    return $this;
  }
  n21() {
    var tmp = PrimitiveClasses_getInstance().yc();
    return isInterface(tmp, KClass) ? tmp : THROW_CCE();
  }
  l1(key) {
    return this.r2j(key) ? null : this.z2j_1[key];
  }
  c3(key) {
    return this.l1((!(key == null) ? typeof key === 'number' : false) ? key : THROW_CCE());
  }
  r2j(key) {
    return !(this.y2j_1 == null) && !this.y2j_1[key];
  }
}
class LongSeries extends AbstractSeries {
  h3() {
    return this.c2k_1;
  }
  static g2k(values, available) {
    var $this = this.f2f();
    init_org_molap_series_LongSeries($this);
    $this.c2k_1 = null;
    $this.e2k_1 = values;
    $this.f2k_1 = IntegerRangeUniqueIndex.t2h(0, values.length - 1 | 0);
    $this.d2k_1 = available;
    return $this;
  }
  n21() {
    var tmp = PrimitiveClasses_getInstance().zc();
    return isInterface(tmp, KClass) ? tmp : THROW_CCE();
  }
  l1(key) {
    var tmp;
    if (this.r2j(key)) {
      tmp = (null == null ? true : typeof null === 'bigint') ? null : THROW_CCE();
    } else {
      tmp = this.e2k_1[key];
    }
    return tmp;
  }
  c3(key) {
    return this.l1((!(key == null) ? typeof key === 'number' : false) ? key : THROW_CCE());
  }
  r2j(key) {
    return !(this.d2k_1 == null) && !this.d2k_1[key];
  }
}
class Companion_66 {
  constructor() {
    Companion_instance_66 = this;
    this.g2h_1 = new SeriesFactory();
  }
  l2h(values, available) {
    return buildInteger(this.g2h_1, values, available);
  }
  k2h(values, available) {
    return buildLong(this.g2h_1, values, available);
  }
  j2h(values, available) {
    return buildFloat(this.g2h_1, values, available);
  }
  i2h(values, available) {
    return buildDouble(this.g2h_1, values, available);
  }
  h2h(values, type) {
    return build(this.g2h_1, values, type);
  }
}
class SeriesFactory {
  constructor() {
    Companion_getInstance_66();
  }
}
class JsonDataFrame extends AbstractDataFrame {
  constructor(array) {
    return new.target.o2k(array);
  }
  static o2k(array) {
    var $this = this.r2f();
    $this.j2k_1 = array;
    var columns = LinkedHashSet.m1();
    var types = HashMap.i7();
    var inductionVariable = 0;
    var last = $this.j2k_1.length;
    if (inductionVariable < last)
      do {
        var row = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        // Inline function 'kotlin.js.unsafeCast' call
        // Inline function 'kotlin.js.asDynamic' call
        var o = $this.j2k_1[row];
        var _iterator__ex2g4s = iterator(Object.keys(o));
        while (_iterator__ex2g4s.i1()) {
          var column = _iterator__ex2g4s.j1();
          if (!columns.q2(column)) {
            columns.c1(column);
            var value = o[column];
            var type = getClass($this, value);
            if (!(type == null)) {
              // Inline function 'kotlin.collections.set' call
              types.o6(column, type);
            }
          } else {
            var value_0 = o[column];
            var type_0 = getClass($this, value_0);
            if (!(type_0 == null)) {
              var currentType = types.c3(column);
              if (currentType == null) {
                // Inline function 'kotlin.collections.set' call
                types.o6(column, type_0);
              } else if (!equals(currentType, type_0)) {
                // Inline function 'kotlin.collections.set' call
                var value_1 = PrimitiveClasses_getInstance().sc();
                types.o6(column, value_1);
              }
            }
          }
        }
      }
       while (inductionVariable < last);
    var tmp = $this;
    // Inline function 'kotlin.collections.toTypedArray' call
    tmp.k2k_1 = copyToArray(columns);
    var tmp_0 = $this;
    // Inline function 'kotlin.arrayOfNulls' call
    var size = columns.k1();
    tmp_0.l2k_1 = Array(size);
    var index = 0;
    var _iterator__ex2g4s_0 = columns.h1();
    while (_iterator__ex2g4s_0.i1()) {
      var column_0 = _iterator__ex2g4s_0.j1();
      var type_1 = types.c3(column_0);
      $this.l2k_1[index] = !(type_1 == null) ? type_1 : PrimitiveClasses_getInstance().sc();
      index = index + 1 | 0;
    }
    var tmp_1 = $this;
    tmp_1.m2k_1 = lazy(JsonDataFrame$rowIndex$delegate$lambda($this));
    var tmp_2 = $this;
    tmp_2.n2k_1 = lazy(JsonDataFrame$columnIndex$delegate$lambda($this));
    return $this;
  }
  s2f() {
    var tmp0 = this.m2k_1;
    var tmp = KProperty1;
    // Inline function 'kotlin.getValue' call
    getPropertyCallableRef('rowIndex', 1, tmp, JsonDataFrame$_get_rowIndex_$ref_np9oyz(), null);
    return tmp0.z2();
  }
  t2f() {
    var tmp0 = this.n2k_1;
    var tmp = KProperty1;
    // Inline function 'kotlin.getValue' call
    getPropertyCallableRef('columnIndex', 1, tmp, JsonDataFrame$_get_columnIndex_$ref_23ske3(), null);
    return tmp0.z2();
  }
  static fromString(json) {
    // Inline function 'kotlin.js.unsafeCast' call
    // Inline function 'kotlin.js.asDynamic' call
    var tmp$ret$1 = JSON.parse(json)['data'];
    return this.o2k(tmp$ret$1);
  }
  p2k(column) {
    var address = this.t2f().v2f(column);
    return this.k2k_1[address];
  }
  g2g(column) {
    return this.p2k((!(column == null) ? typeof column === 'string' : false) ? column : THROW_CCE());
  }
  a2i(column) {
    var address = this.t2f().v2f(column);
    return ensureNotNull(this.l2k_1[address]);
  }
  g2f(column) {
    return this.a2i((!(column == null) ? typeof column === 'string' : false) ? column : THROW_CCE());
  }
  e2g() {
    return this.j2k_1.length;
  }
  y2e() {
    return this.k2k_1.length;
  }
  y2h(row) {
    return PrimitiveClasses_getInstance().sc();
  }
  z2h(row) {
    return this.y2h((!(row == null) ? typeof row === 'number' : false) ? row : THROW_CCE());
  }
  b2i(row, column) {
    var jsonObject = this.j2k_1[row];
    if (!(jsonObject == null)) {
      var jsonValue = (!(jsonObject == null) ? jsonObject : THROW_CCE())[ensureNotNull(column)];
      var tmp;
      if (jsonValue == null) {
        tmp = null;
      } else {
        var tmp_0;
        if (this.a2i(column).equals(PrimitiveClasses_getInstance().bd())) {
          tmp_0 = isNumber(jsonValue) ? jsonValue : THROW_CCE();
        } else if (this.a2i(column).equals(PrimitiveClasses_getInstance().vc())) {
          tmp_0 = typeof jsonValue === 'boolean' ? jsonValue : THROW_CCE();
        } else {
          var tmp_1;
          try {
            tmp_1 = getObject(this, jsonValue);
          } catch ($p) {
            var tmp_2;
            if ($p instanceof ClassCastException) {
              var e = $p;
              printStackTrace(e);
              tmp_2 = null;
            } else {
              throw $p;
            }
            tmp_1 = tmp_2;
          }
          tmp_0 = tmp_1;
        }
        tmp = tmp_0;
      }
      return tmp;
    } else {
      return null;
    }
  }
  x2f(row, column) {
    var tmp = (!(row == null) ? typeof row === 'number' : false) ? row : THROW_CCE();
    return this.b2i(tmp, (!(column == null) ? typeof column === 'string' : false) ? column : THROW_CCE());
  }
}
class Scale {}
class AbsScale {
  q2k(value, min, max) {
    // Inline function 'kotlin.math.absoluteValue' call
    return Math.abs(value);
  }
  toString() {
    return 'Absolute value';
  }
}
class Algorithm {}
class AbstractAlgorithm {
  p1z() {
    return null;
  }
  iterator(model, root) {
    return model.breadthFirstIterator(root);
  }
  depthFirstLayout(shape, parent, children, sumSizes, horizontalVanishingPoint, verticalVanishingPoint, accessor, worker) {
    return false;
  }
  startLayout(bounds, model, root, worker) {
  }
  finishLayout(bounds, model, root) {
  }
  r2k() {
    return true;
  }
  s2k() {
    return true;
  }
  t2k() {
    return false;
  }
  u2k() {
    return true;
  }
  v2k() {
    return true;
  }
  w2k(children, start, end, accessor) {
    var sum = 0.0;
    var inductionVariable = start;
    if (inductionVariable <= end)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        sum = sum + accessor.getSize(children[i]);
      }
       while (!(i === end));
    return sum;
  }
  get properties() {
    return this.p1z();
  }
  get isRenderingLeafLabelsSupported() {
    return this.r2k();
  }
  get isRenderingParentLabelSupported() {
    return this.s2k();
  }
  get isColorParent() {
    return this.t2k();
  }
  get isChildContained() {
    return this.u2k();
  }
  get isSpaceFilling() {
    return this.v2k();
  }
}
class Companion_67 {
  constructor() {
    this.x2k_1 = 0.15;
    this.y2k_1 = 0.5;
  }
  z2k(shape, y, height) {
    var tmp;
    if (shape instanceof Rectangle) {
      var bounds = shape;
      tmp = Rectangle.from(bounds.a1w_1, y, bounds.c1w_1, height);
    } else {
      if (isInterface(shape, Rectangle2D)) {
        var bounds_0 = shape;
        // Inline function 'kotlin.math.ceil' call
        var x = bounds_0.g1h();
        var tmp$ret$0 = Math.ceil(x);
        var tmp_0 = numberToInt(tmp$ret$0);
        // Inline function 'kotlin.math.floor' call
        var x_0 = bounds_0.gm();
        var tmp$ret$1 = Math.floor(x_0);
        tmp = Rectangle.from(tmp_0, y, numberToInt(tmp$ret$1), height);
      } else {
        var bounds_1 = shape.i1h();
        var hh = 0.001;
        var topHit = Double_3.z1h(bounds_1.g1h(), y, bounds_1.gm(), hh);
        var bottomHit = Double_3.z1h(bounds_1.g1h(), (y + height | 0) - hh, bounds_1.gm(), hh);
        var shapeArea = Area.t1m(shape);
        var topArea = Area.t1m(topHit);
        topArea.u1m(shapeArea);
        var bottomArea = Area.t1m(bottomHit);
        bottomArea.u1m(shapeArea);
        var topBounds = topArea.i1h();
        var bottomBounds = bottomArea.i1h();
        var tmp0 = topBounds.p1h();
        // Inline function 'kotlin.math.max' call
        var b = bottomBounds.p1h();
        // Inline function 'kotlin.math.ceil' call
        var x_1 = Math.max(tmp0, b);
        var tmp$ret$3 = Math.ceil(x_1);
        var x_2 = numberToInt(tmp$ret$3);
        var tmp0_0 = topBounds.s1h();
        // Inline function 'kotlin.math.min' call
        var b_0 = bottomBounds.s1h();
        // Inline function 'kotlin.math.floor' call
        var x_3 = Math.min(tmp0_0, b_0);
        var tmp$ret$5 = Math.floor(x_3);
        var width = numberToInt(tmp$ret$5) - x_2 | 0;
        tmp = Rectangle.from(x_2, y, width, height);
      }
    }
    return tmp;
  }
  a2l(points) {
    var N = points.length;
    var cx = 0.0;
    var cy = 0.0;
    var area = calcSignedPolygonArea(this, points);
    var i;
    var j;
    var factor;
    i = 0;
    while (i < N) {
      j = (i + 1 | 0) % N | 0;
      factor = points[i].g1h() * points[j].h1h() - points[j].g1h() * points[i].h1h();
      cx = cx + (points[i].g1h() + points[j].g1h()) * factor;
      cy = cy + (points[i].h1h() + points[j].h1h()) * factor;
      i = i + 1 | 0;
    }
    area = area * 6.0;
    factor = 1 / area;
    cx = cx * factor;
    cy = cy * factor;
    return Double_2.c1l(cx, cy);
  }
  b2l(shape) {
    var points = this.c2l(shape);
    return this.a2l(points);
  }
  c2l(shape) {
    var pointList = ArrayList.n1(32);
    var pathIterator = shape.n1h();
    var lastMoveToIndex = -1;
    while (!pathIterator.m17()) {
      var coordinates = new Float64Array(6);
      switch (pathIterator.s1l(coordinates)) {
        case 0:
          pointList.c1(Double_2.c1l(coordinates[0], coordinates[1]));
          lastMoveToIndex = lastMoveToIndex + 1 | 0;
          break;
        case 1:
          pointList.c1(Double_2.c1l(coordinates[0], coordinates[1]));
          break;
        case 2:
          pointList.c1(Double_2.c1l(coordinates[0], coordinates[1]));
          pointList.c1(Double_2.c1l(coordinates[2], coordinates[3]));
          break;
        case 3:
          pointList.c1(Double_2.c1l(coordinates[0], coordinates[1]));
          pointList.c1(Double_2.c1l(coordinates[2], coordinates[3]));
          pointList.c1(Double_2.c1l(coordinates[4], coordinates[5]));
          break;
        case 4:
          if (lastMoveToIndex >= 0) {
            pointList.c1(pointList.l1(lastMoveToIndex));
          }

          break;
      }
      pathIterator.r1l();
    }
    // Inline function 'kotlin.collections.toTypedArray' call
    var points = copyToArray(pointList);
    return points;
  }
}
class Labeling {}
class AbstractLabeling {
  d2l(model, shape, node) {
    return shape;
  }
  e2l(model) {
    return 0.0;
  }
  f2l(model) {
    return 0.0;
  }
  g2l(g2, shape, bounds, node, view) {
    var model = ensureNotNull(view.h2l());
    if (!model.filter.qk(node) && !model.search.qk(node)) {
      var columns = model.settings.labelsColumns;
      // Inline function 'kotlin.collections.isNotEmpty' call
      if (!columns.p1()) {
        var initialY;
        var parent = ensureNotNull(model.getParent(node));
        var tmp;
        if (!model.isRoot(parent)) {
          var groupByColumnSettings = model.settings.getColumnSettings(ensureNotNull(model.getGroupByColumn(parent)));
          var labeling = ensureNotNull(groupByColumnSettings.getLabeling());
          tmp = bounds.b1w_1 + numberToInt(round(labeling.i2l(parent, node, view, model))) | 0;
        } else {
          tmp = bounds.b1w_1;
        }
        initialY = tmp;
        var y = initialY;
        var todo = columns.k1();
        // Inline function 'kotlin.run' call
        var topFields = this.j2l(model, columns, 1);
        if (!(topFields == null)) {
          var topHeight = this.k2l(g2, shape, bounds, node, view, model, topFields, true, y);
          if (topHeight > 0) {
            y = y + topHeight | 0;
            todo = todo - topFields.k1() | 0;
          } else {
            return Unit_instance;
          }
        }
        if (todo > 0) {
          var centerFields = this.j2l(model, columns, 0);
          if (!(centerFields == null)) {
            var centerHeight = this.k2l(g2, shape, bounds, node, view, model, centerFields, false, initialY);
            if (centerHeight > 0) {
              var center = bounds.b1w_1 + ((bounds.d1w_1 - centerHeight | 0) / 2 | 0) | 0;
              if (center > y) {
                y = center;
              }
              this.k2l(g2, shape, bounds, node, view, model, centerFields, true, y);
              y = y + centerHeight | 0;
              todo = todo - centerFields.k1() | 0;
            } else {
              return Unit_instance;
            }
          }
        }
        if (todo > 0) {
          var bottomFields = this.j2l(model, columns, 3);
          if (!(bottomFields == null)) {
            var bottomHeight = this.k2l(g2, shape, bounds, node, view, model, bottomFields, false, initialY);
            if (bottomHeight > 0) {
              var top = bounds.b1w_1 + (bounds.d1w_1 - bottomHeight | 0) | 0;
              if (top > y) {
                y = top;
              }
              this.k2l(g2, shape, bounds, node, view, model, bottomFields, true, y);
              y = y + bottomHeight | 0;
            } else {
              return Unit_instance;
            }
          }
        }
      }
    }
  }
  j2l(model, columns, alignement) {
    var list = null;
    var _iterator__ex2g4s = columns.h1();
    while (_iterator__ex2g4s.i1()) {
      var column = _iterator__ex2g4s.j1();
      if (model.settings.getColumnSettings(column).getLabelingVerticalAlignment() === alignement) {
        if (list == null) {
          list = ArrayList.q1();
        }
        list.c1(column);
      }
    }
    return list;
  }
  k2l(g2, shape, bounds, node, view, model, columns, paint, y) {
    var height = 0;
    var _iterator__ex2g4s = columns.h1();
    $l$loop: while (_iterator__ex2g4s.i1()) {
      var column = _iterator__ex2g4s.j1();
      if (!(column == null)) {
        var columnSettings = model.settings.getColumnSettings(column);
        var background = columnSettings.getLabelingEffectColor();
        var foreground = columnSettings.getLabelingForeground();
        if (!(foreground == null)) {
          var font = columnSettings.getLabelingFont();
          var shrink = ensureNotNull(columnSettings.getLabelingShrinkTextToFitShape());
          var expand = ensureNotNull(columnSettings.getLabelingResizeTextToFitShape());
          if (!shrink && !expand) {
            if (getFontSize(ensureNotNull(font)) <= bounds.hm() && bounds.gm() > 4) {
              var zoomFactor = view.s2l();
              var derivedFont;
              var tmp;
              if (!(zoomFactor === 1.0)) {
                var tmp_0 = getFontSize(font);
                // Inline function 'kotlin.math.sqrt' call
                var zoomedSize = tmp_0 * (1.0 + (Math.sqrt(zoomFactor) - 1.0) * 0.15);
                var tmp_1;
                if (!(zoomedSize === getFontSize(font))) {
                  tmp_1 = font.q29(zoomedSize);
                } else {
                  tmp_1 = font;
                }
                tmp = tmp_1;
              } else {
                tmp = font;
              }
              derivedFont = tmp;
              if (getFontSize(derivedFont) <= bounds.hm()) {
                var label = ensureNotNull(view.l2l()).m2l(view, column, node, Dimension.fm(bounds.c1w_1, bounds.d1w_1));
                if (!(label == null)) {
                  var nodeColor = model.getColor(node);
                  if (!(!(background == null) || nodeColor == null)) {
                    foreground = this.n2l(columnSettings, foreground, nodeColor);
                  }
                  label.setFont(derivedFont);
                  label.setForeground(foreground);
                  label.setBackground(background);
                  var size = g2.o2l(label, bounds.c1w_1, bounds.d1w_1);
                  var preferredHeight = size.t2l();
                  var cy = y + height | 0;
                  if (cy + preferredHeight <= bounds.h1h() + bounds.hm()) {
                    if (paint) {
                      var drawingArea = Companion_instance_67.z2k(shape, cy, numberToInt(preferredHeight));
                      this.r2l(g2, node, column, label, bounds, drawingArea);
                    }
                    if (!ensureNotNull(columnSettings.getLabelingFloat())) {
                      height = height + numberToInt(preferredHeight) | 0;
                    }
                  } else {
                    break $l$loop;
                  }
                }
              }
            }
          } else {
            if (bounds.gm() > 5 && bounds.hm() > 5 && (expand && bounds.hm() >= getFontSize(ensureNotNull(font)) || shrink)) {
              var elabel = ensureNotNull(view.l2l()).m2l(view, column, node, Dimension.fm(bounds.c1w_1, bounds.d1w_1));
              if (!(elabel == null)) {
                var innerWidth;
                var innerHeight;
                var insetWidth;
                var insetHeight;
                insetWidth = elabel.getInsetRight() + elabel.getInsetLeft() | 0;
                insetHeight = elabel.getInsetTop() + elabel.getInsetBottom() | 0;
                innerWidth = bounds.c1w_1 - insetWidth | 0;
                innerHeight = bounds.d1w_1 - insetHeight | 0;
                elabel.setFont(ensureNotNull(font));
                var nodeColor_0 = model.getColor(node);
                if (!(!(background == null) || nodeColor_0 == null)) {
                  foreground = this.n2l(columnSettings, foreground, nodeColor_0);
                }
                elabel.setForeground(foreground);
                elabel.setBackground(background);
                var pf = g2.o2l(elabel, bounds.c1w_1, bounds.d1w_1);
                var fontSize;
                var scaleFactor = 0.9;
                var tmp_2;
                if (!(columnSettings.getLabelingRendering() === Rendering_WordWrap_getInstance())) {
                  var legacy = true;
                  var tmp_3;
                  if (legacy) {
                    var preferredSize = pf.q2l();
                    var scaleX = bounds.gm() / preferredSize.gm();
                    var scaleY = bounds.hm() / preferredSize.hm();
                    // Inline function 'kotlin.math.min' call
                    var scale = Math.min(scaleX, scaleY);
                    tmp_3 = getFontSize(font) * scale * scaleFactor;
                  } else {
                    var preferredSize_0 = pf.q2l();
                    var w = preferredSize_0.gm() - insetWidth;
                    var h = preferredSize_0.hm() - insetHeight;
                    var scaleX_0 = innerWidth / w;
                    var scaleY_0 = innerHeight / h;
                    // Inline function 'kotlin.math.min' call
                    var scale_0 = Math.min(scaleX_0, scaleY_0);
                    // Inline function 'kotlin.math.floor' call
                    var x = getFontSize(font) * scale_0 * 1.0;
                    tmp_3 = Math.floor(x);
                  }
                  tmp_2 = tmp_3;
                } else {
                  tmp_2 = g2.p2l(elabel, pf, font, bounds, scaleFactor, expand);
                }
                fontSize = tmp_2;
                if (!shrink) {
                  var tmp0 = getFontSize(font);
                  // Inline function 'kotlin.math.max' call
                  var b = fontSize;
                  fontSize = Math.max(tmp0, b);
                }
                if (!expand) {
                  var tmp0_0 = getFontSize(font);
                  // Inline function 'kotlin.math.min' call
                  var b_0 = fontSize;
                  fontSize = Math.min(tmp0_0, b_0);
                }
                if (fontSize >= 5.0) {
                  var scaledFont = font.q29(fontSize);
                  elabel.setFont(scaledFont);
                  equals(columnSettings.getLabelingRendering(), Rendering_WordWrap_getInstance());
                  var preferredSize_1 = pf.q2l();
                  if (paint) {
                    var cy_0 = y + height | 0;
                    var drawingArea_0 = Companion_instance_67.z2k(shape, cy_0, preferredSize_1.dm_1);
                    this.r2l(g2, node, column, elabel, bounds, drawingArea_0);
                  }
                  if (!ensureNotNull(columnSettings.getLabelingFloat())) {
                    height = height + preferredSize_1.dm_1 | 0;
                  }
                }
              }
            }
          }
        }
      }
    }
    return height;
  }
  r2l(g2, node, column, label, bounds, drawingArea) {
    g2.u2l(label, drawingArea.a1w_1, drawingArea.b1w_1, drawingArea.c1w_1, drawingArea.d1w_1);
  }
  n2l(settings, foreground, nodeColor) {
    return ensureNotNull(settings.getLabelingContrastEnhancement()).z1x(foreground, nodeColor);
  }
  i2l(parent, node, view, model) {
    return 0.0;
  }
}
class Companion_68 {
  constructor() {
    this.w2l_1 = true;
  }
}
class Nesting {}
class AbstractNesting {
  y2l(treeMapModel, currentRoot, node, shape) {
    var tmp;
    if (true || !(node === currentRoot)) {
      var r;
      var nested;
      var columnSettings = treeMapModel.settings.getColumnSettings(treeMapModel.getGroupByColumn(node));
      var tmp_0;
      if (columnSettings.getAlgorithm().isChildContained) {
        tmp_0 = this.x2l(treeMapModel, shape, node, ensureNotNull(columnSettings.getNestingAmount()));
      } else {
        tmp_0 = shape;
      }
      nested = tmp_0;
      var tmp_1;
      if (columnSettings.getAlgorithm().isChildContained) {
        var label = ensureNotNull(columnSettings.getLabeling()).d2l(treeMapModel, shape, node);
        var tmp_2;
        var tmp_3;
        var tmp_4;
        if (!(label === nested)) {
          tmp_4 = !(label == null) ? isInterface(label, Rectangle2D) : false;
        } else {
          tmp_4 = false;
        }
        if (tmp_4) {
          tmp_3 = isInterface(nested, Rectangle2D);
        } else {
          tmp_3 = false;
        }
        if (tmp_3) {
          var n = nested;
          var l = label;
          var tmp0 = n.p1h();
          // Inline function 'kotlin.math.max' call
          var b = l.p1h();
          var x1 = Math.max(tmp0, b);
          var tmp0_0 = n.r1h();
          // Inline function 'kotlin.math.max' call
          var b_0 = l.r1h();
          var y1 = Math.max(tmp0_0, b_0);
          var tmp0_1 = n.s1h();
          // Inline function 'kotlin.math.min' call
          var b_1 = l.s1h();
          var x2 = Math.min(tmp0_1, b_1);
          var tmp0_2 = n.t1h();
          // Inline function 'kotlin.math.min' call
          var b_2 = l.t1h();
          var y2 = Math.min(tmp0_2, b_2);
          tmp_2 = Double_3.z1h(x1, y1, x2 - x1, y2 - y1);
        } else {
          tmp_2 = nested;
        }
        tmp_1 = tmp_2;
      } else {
        tmp_1 = nested;
      }
      r = tmp_1;
      tmp = r;
    } else {
      tmp = shape;
    }
    return tmp;
  }
}
class AbstractNodeRenderer {
  z2l(view, root, pass) {
    return ensureNotNull(view.h2l()).preorderEnumeration(root);
  }
}
class Companion_69 {
  constructor() {
    this.e2m_1 = 0.5;
  }
  f2m(bounds, font, elabel, pf, fontSize, shrink, expand) {
    elabel.setFont(font.q29(fontSize));
    var preferredSize = pf.q2l();
    var preferredWidth = preferredSize.gm() - elabel.getInsetLeft() - (-elabel.getInsetRight() | 0);
    var preferredHeight = preferredSize.hm() - elabel.getInsetTop() - (-elabel.getInsetBottom() | 0);
    var targetWidth = bounds.gm();
    var targetheight = bounds.hm();
    var tmp0 = targetWidth * fontSize / preferredWidth;
    // Inline function 'kotlin.math.min' call
    var b = targetheight * fontSize / preferredHeight;
    var s = Math.min(tmp0, b) * 0.9;
    if (!shrink) {
      // Inline function 'kotlin.math.max' call
      var b_0 = s;
      s = Math.max(fontSize, b_0);
    }
    if (!expand) {
      // Inline function 'kotlin.math.min' call
      var b_1 = s;
      s = Math.min(fontSize, b_1);
    }
    return font.q29(s);
  }
}
class AbstractRendering$getOrder$1 {
  constructor($view, $model) {
    this.g2m_1 = $view;
    this.h2m_1 = $model;
  }
  i2m(a, b) {
    var p1 = this.g2m_1.j2m(a);
    var p2 = this.g2m_1.j2m(b);
    var tmp;
    if (!(p1 == null)) {
      var tmp_0;
      if (!(p2 == null)) {
        var dimension = this.h2m_1.settings.getDimension();
        var tmp_1;
        if (!(dimension == null)) {
          var width = dimension.gm();
          var height = dimension.hm();
          var rx1 = p1.i1h().k1h() / width;
          var ry1 = p1.i1h().m1h() / height;
          var rx2 = p2.i1h().k1h() / width;
          var ry2 = p2.i1h().m1h() / height;
          tmp_1 = compare_0(rx1 + ry1, rx2 + ry2);
        } else {
          tmp_1 = compare_0(p1.i1h().k1h() + p1.i1h().m1h(), p2.i1h().k1h() + p2.i1h().m1h());
        }
        tmp_0 = tmp_1;
      } else {
        tmp_0 = 1;
      }
      tmp = tmp_0;
    } else {
      var tmp_2;
      if (!(p2 == null)) {
        tmp_2 = -1;
      } else {
        tmp_2 = 0;
      }
      tmp = tmp_2;
    }
    return tmp;
  }
  compare(a, b) {
    var tmp = (a == null ? true : !(a == null)) ? a : THROW_CCE();
    return this.i2m(tmp, (b == null ? true : !(b == null)) ? b : THROW_CCE());
  }
}
class Rendering_0 {}
class AbstractRendering {
  getPasses(model) {
    var heightColumn = model.settings.heightColumn;
    var tmp;
    if (!(heightColumn == null) && (model.isNumericType(heightColumn) || model.isTemporalType(heightColumn))) {
      tmp = 2;
    } else {
      tmp = 1;
    }
    return tmp;
  }
  getParentOrder(view, root, pass) {
    return pass === 0 ? ensureNotNull(view.h2l()).parentPreorderEnumeration(root) : emptyList();
  }
  getOrder(view, root, pass) {
    var model = ensureNotNull(view.h2l());
    var tmp;
    if (pass === 0) {
      tmp = model.preorderEnumeration(root);
    } else {
      var nodes = ArrayList.q1();
      var _iterator__ex2g4s = model.preorderEnumeration(root).h1();
      while (_iterator__ex2g4s.i1()) {
        var node = _iterator__ex2g4s.j1();
        if (model.hasNoChildren(node)) {
          nodes.c1(node);
        }
      }
      sortedWith_0(nodes, new AbstractRendering$getOrder$1(view, model));
      tmp = nodes;
    }
    return tmp;
  }
  paintParent(g, view, node, pass, bounds, shape) {
    var model = ensureNotNull(view.h2l());
    if (pass === 0 && !model.hasNoChildren(node)) {
      var depth = model.getLevel(node) - model.getLevel(ensureNotNull(model.currentRoot)) | 0;
      var algorithm = model.settings.getColumnSettings(model.getGroupByColumn(node)).getAlgorithm();
      if (ensureNotNull(model.settings.getDepth()).n2m(depth + 1 | 0) && algorithm.isCompatible(model.getShape(node)) && !algorithm.isColorParent) {
        var color = this.getNestingBackground(node, model);
        if (!(color == null)) {
          g.l2m(color);
        } else {
          g.l2m(view.k2m());
        }
        g.m2m(shape);
      } else {
        if (!(model.currentRoot === node)) {
          this.paintNode(g, view, node, pass, bounds, shape);
        }
      }
    }
  }
  getRenderedShape(view, model, node, shape) {
    if (!(node == null) && model.hasNoChildren(node)) {
      var heightColumn = model.settings.heightColumn;
      if (!(heightColumn == null) && (model.isNumericType(heightColumn) || model.isTemporalType(heightColumn))) {
        var minHeight = model.getNumericMin(heightColumn);
        var maxHeight = model.getNumericMax(heightColumn);
        var value = model.getValueAt(node, heightColumn);
        if (!(value == null) && !(maxHeight == null) && !(minHeight == null)) {
          var height;
          var tmp;
          if (isNumber(value)) {
            tmp = numberToDouble(value);
          } else {
            tmp = 0.0;
          }
          height = tmp;
          var range = maxHeight - minHeight;
          // Inline function 'kotlin.math.abs' call
          var x = (height - minHeight) / range;
          var ratio = Math.abs(x);
          if (isInterface(shape, Rectangle2D)) {
            var top = shape;
            var tmp_0 = view.s2l() * -model.settings.getMaximumHeight();
            var tmp0 = ensureNotNull(model.settings.getDimension()).gm();
            // Inline function 'kotlin.math.min' call
            var b = ensureNotNull(model.settings.getDimension()).hm();
            var maxSize = tmp_0 * Math.min(tmp0, b);
            var shift = numberToInt(maxSize * ratio);
            var at = RectangularTransform.s2m();
            at.o1j(shift, shift);
            return at.t2m(top);
          }
        }
      }
    }
    return shape;
  }
  paintBackground(g, view, node, pass, passes, bounds, shape) {
    var shape_0 = shape;
    if (pass === (passes - 1 | 0)) {
      var model = ensureNotNull(view.h2l());
      shape_0 = this.getRenderedShape(view, model, node, shape_0);
      var bounds_0 = computeBounds(this, shape_0);
      g.u2m();
      g.v2m(shape_0);
      var column = model.settings.backgroundColumn;
      if (!(column == null)) {
        if (bounds_0.gm() > 1 && bounds_0.hm() > 1) {
          var columnSettings = model.settings.getColumnSettings(column);
          var font = columnSettings.getLabelingFont();
          if (bounds_0.gm() > 5 && bounds_0.hm() >= getFontSize(ensureNotNull(font))) {
            var elabel = ensureNotNull(ensureNotNull(view.l2l()).m2l(view, column, node, Dimension.fm(bounds_0.c1w_1, bounds_0.d1w_1)));
            var pf = g.o2l(elabel, bounds_0.c1w_1, bounds_0.d1w_1);
            var innerWidth = (bounds_0.c1w_1 - elabel.getInsetRight() | 0) - elabel.getInsetLeft() | 0;
            var innerHeight = (bounds_0.d1w_1 - elabel.getInsetTop() | 0) - elabel.getInsetBottom() | 0;
            var background = model.settings.getColumnSettings(column).getLabelingEffectColor();
            var foreground = model.settings.getColumnSettings(column).getLabelingForeground();
            var nodeColor = model.getColor(node);
            if (!(foreground == null)) {
              if (!(!(background == null) || nodeColor == null)) {
                foreground = ensureNotNull(model.settings.getColumnSettings(column).getLabelingContrastEnhancement()).z1x(foreground, nodeColor);
              }
            }
            elabel.setFont(font);
            elabel.setForeground(ensureNotNull(foreground));
            elabel.setBackground(background);
            var preferredSize = pf.q2l();
            var fontSize;
            var tmp;
            if (!(columnSettings.getLabelingRendering() === Rendering_WordWrap_getInstance())) {
              var scaleX = innerWidth / (preferredSize.gm() - elabel.getInsetRight() - elabel.getInsetLeft());
              var scaleY = innerHeight / (preferredSize.hm() - elabel.getInsetTop() - elabel.getInsetBottom());
              // Inline function 'kotlin.math.min' call
              var scale = Math.min(scaleX, scaleY);
              var tmp0 = getFontSize(font);
              // Inline function 'kotlin.math.max' call
              var b = getFontSize(font) * scale * 1.0;
              tmp = Math.max(tmp0, b);
            } else {
              var tmp0_0 = getFontSize(font);
              // Inline function 'kotlin.math.max' call
              var b_0 = g.p2l(elabel, pf, font, Rectangle.from(0, 0, innerWidth, innerHeight), 0.9, true);
              tmp = Math.max(tmp0_0, b_0);
            }
            fontSize = tmp;
            if (fontSize >= getFontSize(font) / 4) {
              var scaledFont = font.q29(fontSize);
              elabel.setFont(scaledFont);
              if (!(columnSettings.getLabelingRendering() === Rendering_WordWrap_getInstance())) {
                scaledFont = Companion_instance_69.f2m(bounds_0, font, elabel, pf, fontSize, false, true);
                elabel.setFont(scaledFont);
              }
              preferredSize = pf.q2l();
              var y = 0;
              switch (model.settings.getColumnSettings(column).getLabelingVerticalAlignment()) {
                case 1:
                  y = bounds_0.b1w_1;
                  break;
                case 0:
                  var tmp_0;
                  if (bounds_0.d1w_1 > preferredSize.hm()) {
                    tmp_0 = bounds_0.b1w_1 + ((bounds_0.d1w_1 - preferredSize.dm_1 | 0) / 2 | 0) | 0;
                  } else {
                    tmp_0 = bounds_0.b1w_1;
                  }

                  y = tmp_0;
                  break;
                case 3:
                  var tmp_1;
                  if (bounds_0.d1w_1 > preferredSize.dm_1) {
                    tmp_1 = bounds_0.b1w_1 + (bounds_0.d1w_1 - preferredSize.dm_1 | 0) | 0;
                  } else {
                    tmp_1 = bounds_0.b1w_1;
                  }

                  y = tmp_1;
                  break;
              }
              var drawingArea = Companion_instance_67.z2k(shape_0, y, preferredSize.dm_1);
              g.u2l(elabel, drawingArea.a1w_1, drawingArea.b1w_1, drawingArea.c1w_1, drawingArea.d1w_1);
            }
          }
        }
      }
      g.w2m();
    }
  }
  getNestingBackground(node, model) {
    return model.settings.getColumnSettings(model.getGroupByColumn(node)).getNestingBackground();
  }
  paintLabel(g, view, node, pass, passes, bounds, shape) {
    var bounds_0 = bounds;
    var shape_0 = shape;
    if (pass === (passes - 1 | 0)) {
      var model = ensureNotNull(view.h2l());
      var algorithm;
      var parent = ensureNotNull(model.getParent(node));
      if (!(parent == null)) {
        var groupByColumn = model.getGroupByColumn(parent);
        var tmp;
        if (!(groupByColumn == null)) {
          var columnSettings = model.settings.getColumnSettings(groupByColumn);
          tmp = columnSettings.getAlgorithm();
        } else {
          tmp = model.settings.getDefaultColumnSettings().getAlgorithm();
        }
        algorithm = tmp;
        if (algorithm.isRenderingLeafLabelsSupported) {
          shape_0 = this.getRenderedShape(view, model, node, shape_0);
          g.u2m();
          g.v2m(shape_0);
          bounds_0 = computeBounds(this, shape_0);
          ensureNotNull(model.settings.getColumnSettings(model.getGroupByColumn(node)).getLabeling()).g2l(g, shape_0, bounds_0, node, view);
          g.w2m();
        }
      }
    }
  }
  paintParentBorder(g, node, bounds, shape, model) {
    if (bounds.gm() > 1 && bounds.hm() > 1) {
      if (!model.isRoot(node) && !model.hasNoChildren(node)) {
        if (!model.filter.qk(node) && !model.search.qk(node)) {
          var borderThickness = model.settings.getColumnSettings(model.getGroupByColumn(node)).getBorderThickness();
          var tmp;
          if (borderThickness > 0) {
            tmp = !(shape instanceof TextShape);
          } else {
            tmp = false;
          }
          if (tmp) {
            g.u2m();
            g.x2m(borderThickness);
            g.y2m(model.settings.getColumnSettings(model.getGroupByColumn(node)).getBorderColor());
            g.z2m(shape);
            g.w2m();
          }
        }
      }
    }
  }
  paintParentHighlight(g2, view, node, pass, bounds, shape) {
    var model = ensureNotNull(view.h2l());
    if (!model.isRoot(node) && !model.filter.qk(node) && !model.search.qk(node)) {
      if (model.highlighting.f13() && model.highlighting.g13(node)) {
        g2.u2m();
        g2.x2m(2.0);
        g2.y2m(model.settings.getProbingColor());
        g2.z2m(shape);
        g2.w2m();
      }
    }
  }
}
class Companion_70 {
  constructor() {
    this.a2n_1 = null;
  }
}
class TreeMap {}
class AbstractTreeMap {
  static e2n() {
    var $this = createThis(this);
    $this.b2n_1 = null;
    $this.c2n_1 = null;
    $this.d2n_1 = null;
    return $this;
  }
  f2n(view) {
    if (!(this.b2n_1 === view)) {
      if (!(this.b2n_1 == null)) {
        ensureNotNull(this.b2n_1).g2n(null);
      }
      this.b2n_1 = view;
      if (!(view == null)) {
        view.g2n(this.model);
        ensureNotNull(this.b2n_1).h2n(Companion_instance_70.a2n_1);
      }
    }
  }
  i2n(_set____db54di) {
    return this.f2n(_set____db54di);
  }
  j2n() {
    return this.b2n_1;
  }
  k2n(controller) {
    if (!(this.c2n_1 === controller)) {
      if (!(this.c2n_1 == null)) {
        ensureNotNull(this.c2n_1).l2n(null);
      }
      this.c2n_1 = controller;
      if (!(controller == null)) {
        controller.l2n(this.view);
      }
    }
  }
  m2n(_set____db54di) {
    return this.k2n(_set____db54di);
  }
  n2n() {
    return this.c2n_1;
  }
  o2n(model) {
    if (!(this.d2n_1 === model)) {
      this.d2n_1 = model;
      if (!(this.view == null)) {
        ensureNotNull(this.view).g2n(model);
      }
    }
  }
  g2n(_set____db54di) {
    return this.o2n(_set____db54di);
  }
  h2l() {
    return this.d2n_1;
  }
  setGroupBy(columns) {
    ensureNotNull(this.model).settings.setGroupBy(columns.slice());
  }
  setGroupByByNames(columnNames) {
    ensureNotNull(this.model).settings.setGroupByByNames(columnNames.slice());
  }
  setLabels(columns) {
    ensureNotNull(this.model).settings.setLabels(columns.slice());
  }
  setLabelsByNames(columnNames) {
    ensureNotNull(this.model).settings.setLabelsByNames(columnNames.slice());
  }
  setBackground(column) {
    ensureNotNull(this.model).settings.setBackground(column);
  }
  setBackgroundByName(columnName) {
    ensureNotNull(this.model).settings.setBackgroundByName(columnName);
  }
  setSize(column) {
    ensureNotNull(this.model).settings.setSize(column);
  }
  setSizeByName(columnName) {
    ensureNotNull(this.model).settings.setSizeByName(columnName);
  }
  setColor(column) {
    ensureNotNull(this.model).settings.setColor(column);
  }
  setColorByName(columnName) {
    ensureNotNull(this.model).settings.setColorByName(columnName);
  }
  setHeight(column) {
    ensureNotNull(this.model).settings.setHeight(column);
  }
  setHeightByName(columnName) {
    ensureNotNull(this.model).settings.setHeightByName(columnName);
  }
  setToolTip(columns) {
    ensureNotNull(this.model).settings.setToolTip(columns.slice());
  }
  setToolTipByNames(columnNames) {
    ensureNotNull(this.model).settings.setToolTipByNames(columnNames.slice());
  }
  setAlgorithm(algorithm) {
    ensureNotNull(this.model).settings.getDefaultColumnSettings().setAlgorithm(algorithm);
  }
  setAggregation(aggregation) {
    ensureNotNull(this.model).settings.getDefaultColumnSettings().setAggregation(aggregation);
  }
  setScale(scale) {
    ensureNotNull(this.model).settings.getDefaultColumnSettings().setScale(scale);
  }
  setNesting(nesting) {
    ensureNotNull(this.model).settings.getDefaultColumnSettings().setNesting(ensureNotNull(nesting));
  }
  setOrdering(ordering) {
    ensureNotNull(this.model).settings.getDefaultColumnSettings().setOrdering(ordering);
  }
  setDepth(depth) {
    ensureNotNull(this.model).settings.setDepth(depth);
  }
  setLabeling(labeling) {
    ensureNotNull(this.model).settings.getDefaultColumnSettings().setLabeling(labeling);
  }
  setRendering(rendering) {
    ensureNotNull(this.model).settings.p2n(rendering);
  }
  setLightSourceHeight(value) {
    ensureNotNull(this.model).settings.setLightSourceHeight(value);
  }
  setLightSourceAmbient(value) {
    ensureNotNull(this.model).settings.setLightSourceAmbient(value);
  }
  setLightSourceX(value) {
    ensureNotNull(this.model).settings.setLightSourceX(value);
  }
  setLightSourceY(value) {
    ensureNotNull(this.model).settings.setLightSourceY(value);
  }
  setLightSourceZ(value) {
    ensureNotNull(this.model).settings.setLightSourceZ(value);
  }
  setLabelingFont(font) {
    ensureNotNull(this.model).settings.getDefaultColumnSettings().setLabelingFont(font);
  }
  setLabelingForegroundColor(color) {
    ensureNotNull(this.model).settings.getDefaultColumnSettings().setLabelingForeground(color);
  }
  setLabelingBackgroundColor(color) {
    ensureNotNull(this.model).settings.getDefaultColumnSettings().setLabelingEffectColor(color);
  }
  setHeaderFont(font) {
    ensureNotNull(this.model).settings.getDefaultColumnSettings().setHeaderFont(font);
  }
  setHeaderForegroundColor(color) {
    ensureNotNull(this.model).settings.getDefaultColumnSettings().setHeaderForeground(color);
  }
  setHeaderBackgroundColor(color) {
    ensureNotNull(this.model).settings.getDefaultColumnSettings().setHeaderBackground(color);
  }
  get view() {
    return this.j2n();
  }
  set view(value) {
    this.f2n(value);
  }
  get controller() {
    return this.n2n();
  }
  set controller(value) {
    this.k2n(value);
  }
  get model() {
    return this.h2l();
  }
  set model(value) {
    this.o2n(value);
  }
  get component() {
    return this.q2n();
  }
}
class Companion_71 {
  constructor() {
    this.r2n_1 = 'algorithm';
    this.s2n_1 = 'aggregation';
    this.t2n_1 = 'scale';
    this.u2n_1 = 'nesting';
    this.v2n_1 = 'ordering';
    this.w2n_1 = 'orderingDirection';
    this.x2n_1 = 'orderingVerticalVanishingPoint';
    this.y2n_1 = 'orderingHorizontalVanishingPoint';
    this.z2n_1 = 'labeling';
    this.a2o_1 = 'labelingForeground';
    this.b2o_1 = 'labelingEffectColor';
    this.c2o_1 = 'labelingFont';
    this.d2o_1 = 'labelingEffect';
    this.e2o_1 = 'labelingHorizontalAlignment';
    this.f2o_1 = 'labelingVerticalAlignment';
    this.g2o_1 = 'labelingRendering';
    this.h2o_1 = 'labelingMinimumCharactersToDisplay';
    this.i2o_1 = 'labelingEffectOpacity';
    this.j2o_1 = 'labelingShrinkTextToFitShape';
    this.k2o_1 = 'labelingResizeTextToFitShape';
    this.l2o_1 = 'labelingFloat';
    this.m2o_1 = 'labelingContrastEnhancement';
    this.n2o_1 = 'nestingAmount';
    this.o2o_1 = 'nestingBackground';
    this.p2o_1 = 'headerForeground';
    this.q2o_1 = 'headerEffectColor';
    this.r2o_1 = 'headerBackground';
    this.s2o_1 = 'headerFont';
    this.t2o_1 = 'headerEffect';
    this.u2o_1 = 'headerHorizontalAlignment';
    this.v2o_1 = 'headerVerticalAlignment';
    this.w2o_1 = 'headerRendering';
    this.x2o_1 = 'headerMinimumCharactersToDisplay';
    this.y2o_1 = 'headerEffectOpacity';
    this.z2o_1 = 'headerInsets';
    this.a2p_1 = 'tooltipForeground';
    this.b2p_1 = 'tooltipFont';
    this.c2p_1 = 'tooltipRendering';
    this.d2p_1 = 'borderColor';
    this.e2p_1 = 'borderThickness';
    this.f2p_1 = 'format';
    this.g2p_1 = 'showLabel';
    this.h2p_1 = 'colormap';
    this.i2p_1 = 'overrideDefaults';
  }
}
class TreeMapColumnSettings {}
class AbstractTreeMapColumnSettings {
  setProperty(property, value) {
    if (property.equals(TreeMapColumnPropertyType_algorithm_getInstance())) {
      this.setAlgorithm((!(value == null) ? isInterface(value, Algorithm) : false) ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_aggregation_getInstance())) {
      this.setAggregation((!(value == null) ? isInterface(value, Aggregation) : false) ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_scale_getInstance())) {
      this.setScale((!(value == null) ? isInterface(value, Scale) : false) ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_nesting_getInstance())) {
      this.setNesting((!(value == null) ? isInterface(value, Nesting) : false) ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_ordering_getInstance())) {
      this.setOrdering((!(value == null) ? isInterface(value, Ordering) : false) ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_orderingDirection_getInstance())) {
      this.setOrderingDirection(value instanceof SortOrder ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_orderingHorizontalVanishingPoint_getInstance())) {
      this.setOrderingHorizontalVanishingPoint((!(value == null) ? typeof value === 'number' : false) ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_orderingVerticalVanishingPoint_getInstance())) {
      this.setOrderingVerticalVanishingPoint((!(value == null) ? typeof value === 'number' : false) ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_labeling_getInstance())) {
      this.setLabeling((!(value == null) ? isInterface(value, Labeling) : false) ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_labelingForeground_getInstance())) {
      this.setLabelingForeground(value instanceof CPColor ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_labelingEffectColor_getInstance())) {
      this.setLabelingEffectColor(value instanceof CPColor ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_labelingFont_getInstance())) {
      this.setLabelingFont(value instanceof CPFont ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_labelingEffect_getInstance())) {
      this.setLabelingEffect(value instanceof Effect ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_labelingHorizontalAlignment_getInstance())) {
      this.setLabelingHorizontalAlignment((!(value == null) ? typeof value === 'number' : false) ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_labelingVerticalAlignment_getInstance())) {
      this.setLabelingVerticalAlignment((!(value == null) ? typeof value === 'number' : false) ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_labelingRendering_getInstance())) {
      this.setLabelingRendering(value instanceof Rendering ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_labelingMinimumCharactersToDisplay_getInstance())) {
      this.setLabelingMinimumCharactersToDisplay((!(value == null) ? typeof value === 'number' : false) ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_labelingEffectOpacity_getInstance())) {
      this.setLabelingEffectOpacity((!(value == null) ? typeof value === 'number' : false) ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_labelingShrinkTextToFitShape_getInstance())) {
      this.setLabelingShrinkTextToFitShape((!(value == null) ? typeof value === 'boolean' : false) ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_labelingResizeTextToFitShape_getInstance())) {
      this.setLabelingResizeTextToFitShape((!(value == null) ? typeof value === 'boolean' : false) ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_labelingFloat_getInstance())) {
      this.setLabelingFloat((!(value == null) ? typeof value === 'boolean' : false) ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_nestingAmount_getInstance())) {
      this.setNestingAmount((!(value == null) ? typeof value === 'number' : false) ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_nestingBackground_getInstance())) {
      this.setNestingBackground(value instanceof CPColor ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_headerForeground_getInstance())) {
      this.setHeaderForeground(value instanceof CPColor ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_headerEffectColor_getInstance())) {
      this.setHeaderEffectColor(value instanceof CPColor ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_headerBackground_getInstance())) {
      this.setHeaderBackground(value instanceof CPColor ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_headerFont_getInstance())) {
      this.setHeaderFont(value instanceof CPFont ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_headerEffect_getInstance())) {
      this.setHeaderEffect(value instanceof Effect ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_headerHorizontalAlignment_getInstance())) {
      this.setHeaderHorizontalAlignment((!(value == null) ? typeof value === 'number' : false) ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_headerVerticalAlignment_getInstance())) {
      this.setHeaderVerticalAlignment((!(value == null) ? typeof value === 'number' : false) ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_headerRendering_getInstance())) {
      this.setHeaderRendering(value instanceof Rendering ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_headerMinimumCharactersToDisplay_getInstance())) {
      this.setHeaderMinimumCharactersToDisplay((!(value == null) ? typeof value === 'number' : false) ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_headerEffectOpacity_getInstance())) {
      this.setHeaderEffectOpacity((!(value == null) ? typeof value === 'number' : false) ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_tooltipForeground_getInstance())) {
      this.setTooltipForeground(value instanceof CPColor ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_tooltipFont_getInstance())) {
      this.setTooltipFont(value instanceof CPFont ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_tooltipRendering_getInstance())) {
      this.setTooltipRendering(value instanceof Rendering ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_borderColor_getInstance())) {
      this.setBorderColor(value instanceof CPColor ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_borderThickness_getInstance())) {
      this.setBorderThickness((!(value == null) ? typeof value === 'number' : false) ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_format_getInstance())) {
      this.setFormat((!(value == null) ? isInterface(value, CPFormat) : false) ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_showLabel_getInstance())) {
      this.setShowLabel((!(value == null) ? typeof value === 'boolean' : false) ? value : THROW_CCE());
    } else if (property.equals(TreeMapColumnPropertyType_colormap_getInstance())) {
      this.setColorMap((!(value == null) ? !(value == null) : false) ? value : THROW_CCE());
    } else {
      println('Unknonw property ' + property.toString());
    }
  }
  get properties() {
    return this.p1z();
  }
}
class Mode_1 extends Enum {}
class Range {
  constructor($outer, _amount, _center, _start, _extent, _minRange, _maxRange, _maxExtent) {
    this.j2q_1 = $outer;
    this.a2q_1 = _amount;
    this.b2q_1 = _center;
    this.c2q_1 = _start;
    this.d2q_1 = _extent;
    this.e2q_1 = _minRange;
    this.f2q_1 = _maxRange;
    this.g2q_1 = _maxExtent;
    this.h2q_1 = 0.0;
    this.i2q_1 = 0.0;
  }
  l2q() {
    return this.h2q_1;
  }
  m2q() {
    return this.i2q_1;
  }
  k2q() {
    var range = this.d2q_1;
    var tmp0 = this.g2q_1;
    // Inline function 'kotlin.math.min' call
    var b = range + range * this.a2q_1;
    var newRange = Math.min(tmp0, b);
    if (!(this.b2q_1 == null)) {
      this.h2q_1 = this.b2q_1 - newRange * ((this.b2q_1 - this.c2q_1) / range);
      this.i2q_1 = this.b2q_1 + newRange * ((this.c2q_1 + this.d2q_1 - this.b2q_1) / range);
    } else {
      this.h2q_1 = this.c2q_1;
      this.i2q_1 = this.c2q_1 + newRange;
    }
    if (this.h2q_1 < this.e2q_1) {
      this.i2q_1 = this.i2q_1 + (this.e2q_1 - this.h2q_1);
      this.h2q_1 = this.e2q_1;
    }
    if (this.i2q_1 > this.f2q_1) {
      this.h2q_1 = this.h2q_1 - (this.i2q_1 - this.f2q_1);
      this.i2q_1 = this.f2q_1;
    }
    var tmp = this;
    var tmp0_0 = this.e2q_1;
    // Inline function 'kotlin.math.max' call
    var b_0 = this.h2q_1;
    tmp.h2q_1 = Math.max(tmp0_0, b_0);
    var tmp_0 = this;
    var tmp0_1 = this.f2q_1;
    // Inline function 'kotlin.math.min' call
    var b_1 = this.i2q_1;
    tmp_0.i2q_1 = Math.min(tmp0_1, b_1);
    return this;
  }
}
class DefaultMouseListener {
  constructor($outer) {
    this.w2p_1 = $outer;
    this.r2p_1 = null;
    this.s2p_1 = null;
    this.t2p_1 = null;
    this.u2p_1 = null;
    this.v2p_1 = null;
  }
  n28(event) {
  }
  r28(event) {
    if (!(this.w2p_1.j2p_1 == null) && !(ensureNotNull(this.w2p_1.j2p_1).h2l() == null)) {
      this.v2p_1 = new Point(event.g1h(), event.h1h());
      if (event.g27() > 1) {
        ensureNotNull(this.w2p_1.j2p_1).v2r(ensureNotNull(this.v2p_1).r1v_1, ensureNotNull(this.v2p_1).s1v_1);
      } else {
        var bestrow = ensureNotNull(this.w2p_1.j2p_1).s2r(new Point(event.g1h(), event.h1h()));
        if (!(bestrow == null)) {
          if (!event.i27()) {
            if (!ensureNotNull(ensureNotNull(this.w2p_1.j2p_1).h2l()).selection.g13(bestrow) || ensureNotNull(ensureNotNull(this.w2p_1.j2p_1).h2l()).selection.h13() > 1) {
              ensureNotNull(ensureNotNull(this.w2p_1.j2p_1).h2l()).selection.i13();
              ensureNotNull(ensureNotNull(this.w2p_1.j2p_1).h2l()).selection.j13(bestrow);
              ensureNotNull(this.w2p_1.j2p_1).t2r(ensureNotNull(ensureNotNull(this.w2p_1.j2p_1).h2l()).selection.g13(bestrow));
            }
          } else {
            ensureNotNull(this.w2p_1.j2p_1).t2r(!ensureNotNull(ensureNotNull(this.w2p_1.j2p_1).h2l()).selection.g13(bestrow));
            if (ensureNotNull(this.w2p_1.j2p_1).u2r()) {
              ensureNotNull(ensureNotNull(this.w2p_1.j2p_1).h2l()).selection.k13(bestrow, true);
            } else {
              ensureNotNull(ensureNotNull(this.w2p_1.j2p_1).h2l()).selection.k13(bestrow, false);
            }
          }
        } else {
          ensureNotNull(ensureNotNull(this.w2p_1.j2p_1).h2l()).selection.i13();
        }
      }
    }
  }
  p28(event) {
    if (!(this.w2p_1.j2p_1 == null) && !(ensureNotNull(this.w2p_1.j2p_1).h2l() == null)) {
      if (!event.l27()) {
        if (!(this.s2p_1 == null)) {
          if (event.m27()) {
            ensureNotNull(ensureNotNull(this.w2p_1.j2p_1).h2l()).selection.i13();
            if (this.w2p_1.l2p_1) {
              addToSelection(this, ensureNotNull(this.s2p_1));
            } else {
              setSelection(this, this.s2p_1);
            }
            this.s2p_1 = null;
          }
        }
        if (!(this.t2p_1 == null)) {
          event.m27();
          this.t2p_1 = null;
        }
        ensureNotNull(this.w2p_1.j2p_1).y23().b24();
      } else {
        if (this.w2p_1.m2p_1) {
          var node = ensureNotNull(this.w2p_1.j2p_1).s2r(new Point(event.g1h(), event.h1h()));
          setSelection(this, node);
        }
      }
      this.r2p_1 = null;
    }
  }
  s28(event) {
    if (!(this.w2p_1.j2p_1 == null)) {
      if (!(ensureNotNull(this.w2p_1.j2p_1).h2l() == null)) {
        ensureNotNull(ensureNotNull(this.w2p_1.j2p_1).h2l()).probing.j13(ensureNotNull(this.w2p_1.j2p_1).s2r(new Point(event.g1h(), event.h1h())));
      }
    }
  }
  t28(event) {
    if (!(this.w2p_1.j2p_1 == null)) {
      if (!(ensureNotNull(this.w2p_1.j2p_1).h2l() == null)) {
        ensureNotNull(ensureNotNull(this.w2p_1.j2p_1).h2l()).probing.i13();
      }
    }
  }
  m28(event) {
    if (!(this.w2p_1.j2p_1 == null)) {
      if (!(ensureNotNull(this.w2p_1.j2p_1).h2l() == null)) {
        if (!(this.r2p_1 == null)) {
          switch (this.w2p_1.k2p_1.g3_1) {
            case 0:
              if (event.m27()) {
                if (event.j27() || event.k27()) {
                  ensureNotNull(ensureNotNull(this.w2p_1.j2p_1).h2l()).probing.i13();
                  if (this.w2p_1.l2p_1) {
                    if (!ensureNotNull(this.w2p_1.j2p_1).y23().y23().f13()) {
                      ensureNotNull(this.w2p_1.j2p_1).y23().z23(ensureNotNull(this.v2p_1).r1v_1, ensureNotNull(this.v2p_1).s1v_1);
                    }
                    ensureNotNull(this.w2p_1.j2p_1).y23().a24(event.g1h(), event.h1h());
                    var r = ensureNotNull(ensureNotNull(this.w2p_1.j2p_1).y23().c24());
                    var rect = Rectangle.from(numberToInt(r.g1h()), numberToInt(r.h1h()), numberToInt(r.gm()), numberToInt(r.hm()));
                    if (!(rect == null)) {
                      var toSelect = ensureNotNull(ensureNotNull(this.w2p_1.j2p_1).w2r(rect));
                      if (event.i27()) {
                        addToSelection_0(this, toSelect);
                      } else {
                        ensureNotNull(ensureNotNull(this.w2p_1.j2p_1).h2l()).selection.n13(toSelect);
                      }
                      this.s2p_1 = null;
                    }
                  }
                } else {
                  var observation = ensureNotNull(ensureNotNull(this.w2p_1.j2p_1).s2r(new Point(event.g1h(), event.h1h())));
                  ensureNotNull(ensureNotNull(this.w2p_1.j2p_1).h2l()).probing.j13(observation);
                  this.s2p_1 = null;
                  var isAlreadySelected = !(ensureNotNull(ensureNotNull(this.w2p_1.j2p_1).h2l()).selection == null) && ensureNotNull(ensureNotNull(this.w2p_1.j2p_1).h2l()).selection.g13(observation);
                  if (!isAlreadySelected && !event.h27()) {
                    ensureNotNull(ensureNotNull(this.w2p_1.j2p_1).h2l()).selection.i13();
                  }
                  if (event.h27()) {
                    if (this.w2p_1.l2p_1) {
                      addToSelection(this, observation);
                    } else {
                      setSelection(this, observation);
                    }
                  } else {
                    if (isAlreadySelected) {
                      this.s2p_1 = observation;
                    } else {
                      if (this.w2p_1.l2p_1) {
                        addToSelection(this, observation);
                      } else {
                        setSelection(this, observation);
                      }
                    }
                  }
                }
              }

              break;
            case 2:
              if (event.m27()) {
                var viewport = this.w2p_1.x2r();
                var world = this.w2p_1.y2r();
                var x1 = ensureNotNull(this.w2p_1.j2p_1).z2r().g1h().z15(ensureNotNull(this.r2p_1).g1h());
                var x2 = ensureNotNull(this.w2p_1.j2p_1).z2r().g1h().z15(event.g1h());
                var worldDiffX = x1 - x2;
                var xMin = viewport.p1h() + worldDiffX;
                var xMax = viewport.s1h() + worldDiffX;
                var y1 = ensureNotNull(this.w2p_1.j2p_1).z2r().h1h().z15(ensureNotNull(this.r2p_1).h1h());
                var y2 = ensureNotNull(this.w2p_1.j2p_1).z2r().h1h().z15(event.h1h());
                var worldDiffY = y1 - y2;
                var yMin = viewport.r1h() + worldDiffY;
                var yMax = viewport.r1h() + worldDiffY;
                if (xMin < world.p1h()) {
                  xMax = xMax + (world.p1h() - xMin);
                  xMin = world.p1h();
                }
                if (xMax > world.s1h()) {
                  xMin = xMin - (xMax - world.s1h());
                  xMax = world.s1h();
                }
                var tmp0 = world.p1h();
                // Inline function 'kotlin.math.max' call
                var b = xMin;
                xMin = Math.max(tmp0, b);
                var tmp0_0 = world.s1h();
                // Inline function 'kotlin.math.min' call
                var b_0 = xMax;
                xMax = Math.min(tmp0_0, b_0);
                if (yMin < world.r1h()) {
                  yMax = yMax + (world.r1h() - yMin);
                  yMin = world.r1h();
                }
                if (yMax > world.t1h()) {
                  yMin = yMin - (yMax - world.t1h());
                  yMax = world.t1h();
                }
                var tmp0_1 = world.r1h();
                // Inline function 'kotlin.math.max' call
                var b_1 = yMin;
                yMin = Math.max(tmp0_1, b_1);
                var tmp0_2 = world.t1h();
                // Inline function 'kotlin.math.min' call
                var b_2 = yMax;
                yMax = Math.min(tmp0_2, b_2);
                if (xMin < xMax && yMin < yMax) {
                  ensureNotNull(this.w2p_1.j2p_1).n2q(false, xMin, xMax, yMin, yMax);
                }
              }

              break;
            case 1:
              if (event.n27()) {
                zoom(this.w2p_1, event.h1h() - ensureNotNull(this.r2p_1).h1h() / 100.0, ensureNotNull(this.w2p_1.j2p_1).z2r().g1h().z15(event.g1h()), ensureNotNull(this.w2p_1.j2p_1).z2r().h1h().z15(event.h1h()));
                this.t2p_1 = null;
              }

              break;
            default:
              noWhenBranchMatchedException();
              break;
          }
        }
        this.r2p_1 = event;
      }
    }
  }
  u28(event) {
    var tmp0_safe_receiver = this.w2p_1.j2p_1;
    var closest = tmp0_safe_receiver == null ? null : tmp0_safe_receiver.s2r(new Point(event.g1h(), event.h1h()));
    var tmp1_safe_receiver = this.w2p_1.j2p_1;
    var tmp2_safe_receiver = tmp1_safe_receiver == null ? null : tmp1_safe_receiver.h2l();
    var tmp3_safe_receiver = tmp2_safe_receiver == null ? null : tmp2_safe_receiver.probing;
    if (tmp3_safe_receiver == null)
      null;
    else {
      tmp3_safe_receiver.j13(closest);
    }
  }
  x28(event) {
    if (!(this.w2p_1.j2p_1 == null)) {
      var amount = event.w28();
      zoom(this.w2p_1, amount / 500.0, ensureNotNull(this.w2p_1.j2p_1).z2r().g1h().z15(event.g1h()), ensureNotNull(this.w2p_1.j2p_1).z2r().h1h().z15(event.h1h()));
    }
  }
}
class AbstractTreeMapController$keyListener$1 {
  constructor(this$0, $view) {
    this.b2s_1 = this$0;
    this.c2s_1 = $view;
    this.a2s_1 = null;
  }
  y28(event) {
    if (event.d28() === 83) {
      if (this.a2s_1 == null) {
        this.a2s_1 = this.b2s_1.k2p_1;
      }
      this.b2s_1.k2p_1 = Mode_Selection_getInstance();
    }
    if (event.d28() === 90 || event.d28() === 16) {
      if (this.a2s_1 == null) {
        this.a2s_1 = this.b2s_1.k2p_1;
      }
      this.b2s_1.k2p_1 = Mode_Zooming_getInstance();
    }
    if (event.d28() === 90 || event.d28() === 32) {
      if (this.a2s_1 == null) {
        this.a2s_1 = this.b2s_1.k2p_1;
      }
      this.b2s_1.k2p_1 = Mode_Panning_getInstance();
    }
    if (event.d28() === 40) {
      this.c2s_1.d2s();
    }
    if (event.d28() === 38) {
      this.c2s_1.e2s();
    }
    if (event.d28() === 34) {
      this.c2s_1.f2s();
    }
    if (event.d28() === 33) {
      this.c2s_1.g2s();
    }
  }
}
class AbstractTreeMapController$setView$1 {
  constructor(this$0) {
    this.h2s_1 = this$0;
  }
  a29(event) {
    openPopupMenu(this.h2s_1, event);
  }
}
class AbstractTreeMapController$openPopupMenu$drillDownCommand$1 extends AbstractUICommand {
  static w2q(this$0, $x, $y, $box) {
    if ($box === VOID)
      $box = {};
    $box.t2q_1 = this$0;
    $box.u2q_1 = $x;
    $box.v2q_1 = $y;
    return this.gk('Drill down', $box);
  }
}
class AbstractTreeMapController$openPopupMenu$drillUpCommand$1 extends AbstractUICommand {
  static d2r(this$0, $box) {
    if ($box === VOID)
      $box = {};
    $box.c2r_1 = this$0;
    return this.gk('Drill up', $box);
  }
}
class AbstractTreeMapController$openPopupMenu$zoomInCommand$1 extends AbstractUICommand {
  static k2r(this$0, $box) {
    if ($box === VOID)
      $box = {};
    $box.j2r_1 = this$0;
    return this.gk('Zoom in', $box);
  }
}
class AbstractTreeMapController$openPopupMenu$zoomOutCommand$1 extends AbstractUICommand {
  static r2r(this$0, $box) {
    if ($box === VOID)
      $box = {};
    $box.q2r_1 = this$0;
    return this.gk('Zoom out', $box);
  }
}
class AbstractTreeMapController {
  constructor(view) {
    this.j2p_1 = null;
    this.k2p_1 = Mode_Selection_getInstance();
    this.l2p_1 = true;
    this.m2p_1 = false;
    this.n2p_1 = true;
    this.o2p_1 = false;
    this.p2p_1 = new DefaultMouseListener(this);
    var tmp = this;
    tmp.q2p_1 = new AbstractTreeMapController$keyListener$1(this, view);
    this.l2n(view);
  }
  z2p(center) {
    // Inline function 'kotlin.math.tanh' call
    var x = center * 3;
    return tanh(x);
  }
  l2n(view) {
    this.j2p_1 = view;
    if (!(view == null)) {
      view.s26(this.q2p_1);
      view.y1g(this.p2p_1);
      view.z1g(this.p2p_1);
      view.r26(this.p2p_1);
      view.t26(new AbstractTreeMapController$setView$1(this));
    }
  }
  x2r() {
    return Double_3.z1h(ensureNotNull(this.j2p_1).i2s().start, ensureNotNull(this.j2p_1).i2s().start, ensureNotNull(this.j2p_1).i2s().extent, ensureNotNull(this.j2p_1).i2s().extent);
  }
  y2r() {
    return Double_3.z1h(ensureNotNull(this.j2p_1).j2s().gn(), ensureNotNull(this.j2p_1).j2s().gn(), ensureNotNull(this.j2p_1).j2s().hn() - ensureNotNull(this.j2p_1).i2s().gn(), ensureNotNull(this.j2p_1).j2s().hn() - ensureNotNull(this.j2p_1).j2s().gn());
  }
}
class NodeField {
  constructor($outer, node, field) {
    this.n2u_1 = $outer;
    this.l2u_1 = node;
    this.m2u_1 = field;
  }
  equals(other) {
    if (this === other)
      return true;
    if (other == null || !getKClassFromExpression(this).equals(getKClassFromExpression(other)))
      return false;
    if (!(other instanceof NodeField))
      THROW_CCE();
    if (!equals(this.l2u_1, other.l2u_1))
      return false;
    if (!equals(this.m2u_1, other.m2u_1))
      return false;
    return true;
  }
  hashCode() {
    var tmp0_safe_receiver = this.l2u_1;
    var tmp1_elvis_lhs = tmp0_safe_receiver == null ? null : hashCode(tmp0_safe_receiver);
    var result = tmp1_elvis_lhs == null ? 0 : tmp1_elvis_lhs;
    var tmp = imul_0(31, result);
    // Inline function 'kotlin.hashCode' call
    var tmp0_safe_receiver_0 = this.m2u_1;
    var tmp1_elvis_lhs_0 = tmp0_safe_receiver_0 == null ? null : hashCode(tmp0_safe_receiver_0);
    result = tmp + (tmp1_elvis_lhs_0 == null ? 0 : tmp1_elvis_lhs_0) | 0;
    return result;
  }
}
class Worker {
  constructor($outer) {
    this.l2s_1 = $outer;
    this.k2s_1 = false;
  }
  o17() {
    return this.k2s_1;
  }
  o2u() {
    try {
      if (this.l2s_1.k2t_1 || this.l2s_1.l2t_1 || this.l2s_1.m2t_1) {
        if (!this.k2s_1) {
          this.p2u(0);
          var newRoot;
          var newCurrentRoot;
          if (this.l2s_1.k2t_1) {
            if (!this.k2s_1) {
              var groupByTreeMapColumns = this.l2s_1.settings.groupByColumns;
              var tmp;
              if (groupByTreeMapColumns == null || groupByTreeMapColumns.k1() === 0) {
                var tmp_0 = this.l2s_1.settings.sizeColumn;
                tmp = this.l2s_1.q2u((tmp_0 == null ? true : !(tmp_0 == null)) ? tmp_0 : THROW_CCE());
              } else {
                tmp = this.l2s_1.q2u(groupByTreeMapColumns.l1(0));
              }
              newRoot = tmp;
              newCurrentRoot = newRoot;
              this.l2s_1.r2u(newRoot, this);
              if (this.k2s_1) {
                this.l2s_1.k2t_1 = true;
                return Unit_instance;
              } else {
                this.l2s_1.s2u(newRoot);
                this.l2s_1.n2t_1 = true;
                this.l2s_1.k2t_1 = false;
                this.l2s_1.l2t_1 = true;
                this.l2s_1.h2t_1.ap(newCurrentRoot);
              }
            } else {
              newRoot = this.l2s_1.root;
              newCurrentRoot = this.l2s_1.h2t_1.z2();
            }
          } else {
            newRoot = this.l2s_1.root;
            newCurrentRoot = this.l2s_1.h2t_1.z2();
          }
          if (this.l2s_1.l2t_1) {
            if (!this.k2s_1 && !(newCurrentRoot == null) && !(this.l2s_1.settings.getDimension() == null)) {
              this.l2s_1.t2u(newCurrentRoot, this);
            }
            if (this.k2s_1) {
              this.l2s_1.l2t_1 = true;
              return Unit_instance;
            } else {
              this.l2s_1.o2t_1 = true;
              this.l2s_1.l2t_1 = false;
              this.l2s_1.m2t_1 = true;
            }
          }
          if (this.l2s_1.m2t_1) {
            if (!this.k2s_1 && !(newRoot == null)) {
              this.l2s_1.u2u();
              this.l2s_1.v2u(newRoot, this);
            }
            if (this.k2s_1) {
              this.l2s_1.m2t_1 = true;
              return Unit_instance;
            } else {
              this.l2s_1.p2t_1 = true;
              this.l2s_1.m2t_1 = false;
            }
          }
          if (!this.k2s_1) {
            this.l2s_1.s2u(newRoot);
            this.l2s_1.h2t_1.ap(newCurrentRoot);
            this.l2s_1.w2u();
            this.l2s_1.x2u(new TreeMapEvent(this.l2s_1.n2t_1, this.l2s_1.o2t_1, this.l2s_1.p2t_1));
            this.l2s_1.n2t_1 = false;
            this.l2s_1.o2t_1 = false;
            this.l2s_1.p2t_1 = false;
            this.p2u(100);
          }
        }
      }
    } catch ($p) {
      if ($p instanceof Error) {
        var e = $p;
        printStackTrace(e);
      } else {
        throw $p;
      }
    }
    return Unit_instance;
  }
  l17() {
    this.o2u();
    return Unit_instance;
  }
  n18() {
    this.k2s_1 = true;
    this.p2u(0);
  }
  p2u(progress) {
    this.l2s_1.p2u(progress);
  }
}
class Companion_72 {
  constructor() {
    this.y2u_1 = 40;
    this.z2u_1 = 'progress';
    this.a2v_1 = 'currentRoot';
  }
}
class AbstractTreeMapModel$colorMapListener$1 {
  constructor(this$0) {
    this.b2v_1 = this$0;
  }
  r19(event) {
    this.b2v_1.c2v();
  }
}
class AbstractTreeMapModel$colorProvider$1 {
  d2v(element) {
    return ensureNotNull(element.e2v());
  }
  f2v(element) {
    return this.d2v(element instanceof AbstractTreeMapNode ? element : THROW_CCE());
  }
}
class AbstractTreeMapModel$groupByColumns$1 {
  constructor(this$0) {
    this.g2v_1 = this$0;
  }
  h2v(column) {
    return column == null || !this.g2v_1.isEveryValueUnique(column) || this.g2v_1.v2t_1.d18(ensureNotNull(this.g2v_1.getColumnClass(column)));
  }
  rj(var1) {
    return this.h2v((var1 == null ? true : !(var1 == null)) ? var1 : THROW_CCE());
  }
}
class AbstractTreeMapModel$sizeColumns$1 {
  constructor(this$0) {
    this.i2v_1 = this$0;
  }
  h2v(column) {
    return column == null || this.i2v_1.isNumericType(column) || this.i2v_1.isTemporalType(column);
  }
  rj(var1) {
    return this.h2v((var1 == null ? true : !(var1 == null)) ? var1 : THROW_CCE());
  }
}
class AbstractTreeMapModel$colorColumns$1 {
  constructor(this$0) {
    this.j2v_1 = this$0;
  }
  h2v(column) {
    return column == null || !this.j2v_1.v2t_1.d18(ensureNotNull(this.j2v_1.getColumnClass(column)));
  }
  rj(var1) {
    return this.h2v((var1 == null ? true : !(var1 == null)) ? var1 : THROW_CCE());
  }
}
class AbstractTreeMapModel$heightColumns$1 {
  constructor(this$0) {
    this.k2v_1 = this$0;
  }
  h2v(column) {
    return column == null || this.k2v_1.isNumericType(column) || this.k2v_1.isTemporalType(column);
  }
  rj(var1) {
    return this.h2v((var1 == null ? true : !(var1 == null)) ? var1 : THROW_CCE());
  }
}
class AbstractTreeMapModel$labelsColumns$1 {
  constructor(this$0) {
    this.l2v_1 = this$0;
  }
  h2v(column) {
    return !(column == null) && !this.l2v_1.isVisualType(column);
  }
  rj(var1) {
    return this.h2v((var1 == null ? true : !(var1 == null)) ? var1 : THROW_CCE());
  }
}
class AbstractTreeMapModel$tooltipColumns$1 {
  constructor(this$0) {
    this.m2v_1 = this$0;
  }
  h2v(column) {
    return !(column == null) && !this.m2v_1.isVisualType(column);
  }
  rj(var1) {
    return this.h2v((var1 == null ? true : !(var1 == null)) ? var1 : THROW_CCE());
  }
}
class AbstractTreeMapModel$parentPreorderEnumeration$1 {
  constructor(this$0, $parent) {
    this.n2v_1 = this$0;
    this.o2v_1 = $parent;
  }
  h1() {
    return new ParentPreorderIterator(this.n2v_1, this.o2v_1);
  }
}
class AbstractTreeMapModel$preorderEnumeration$1 {
  constructor(this$0, $parent) {
    this.p2v_1 = this$0;
    this.q2v_1 = $parent;
  }
  h1() {
    return new PreorderIterator(this.p2v_1, this.q2v_1);
  }
}
class AbstractTreeMapModel$breadthFirstIterator$1 {
  constructor(this$0, $parent) {
    this.r2v_1 = this$0;
    this.s2v_1 = $parent;
  }
  h1() {
    return new BreadthFirstIterator(this.r2v_1, this.s2v_1);
  }
}
class AbstractTreeMapModel$depthFirstIterator$1 {
  constructor(this$0, $parent) {
    this.t2v_1 = this$0;
    this.u2v_1 = $parent;
  }
  h1() {
    return new PostorderIterator(this.t2v_1, this.u2v_1);
  }
}
class AbstractTreeMapModel$1 {
  constructor(this$0) {
    this.v2v_1 = this$0;
  }
  j18() {
    this.v2v_1.w2v();
  }
}
class AbstractTreeMapModel$2 {
  constructor(this$0) {
    this.x2v_1 = this$0;
  }
  y2v(event) {
    if (event.j2w()) {
      this.x2v_1.i2w();
    } else if (event.h2w()) {
      this.x2v_1.w2u();
      this.x2v_1.f2w();
    } else if (event.g2w()) {
      this.x2v_1.f2w();
    } else if (event.e2w()) {
      this.x2v_1.c2v();
    } else {
      this.x2v_1.x2u(new TreeMapEvent(false, false, false));
    }
  }
}
class AbstractTreeMapModel$3 {
  constructor(this$0) {
    this.k2w_1 = this$0;
  }
  l2w(event) {
    var node = event.n15_1;
    if (!(node == null)) {
      var toHighlight = ArrayList.q1();
      do {
        toHighlight.c1(ensureNotNull(node));
        node = this.k2w_1.getParent(node);
      }
       while (!(node == null));
      this.k2w_1.highlighting.n13(toHighlight);
    } else {
      this.k2w_1.highlighting.i13();
    }
  }
  x13(event) {
    return this.l2w(event);
  }
}
class AbstractTreeMapModel$4 {
  constructor(this$0) {
    this.m2w_1 = this$0;
  }
}
class AbstractTreeMapModel$5 {
  constructor(this$0) {
    this.n2w_1 = this$0;
  }
}
class AbstractTreeMapModel$6 {
  constructor(this$0) {
    this.o2w_1 = this$0;
  }
  p2w(event) {
    this.o2w_1.selection.i13();
    this.o2w_1.f2w();
  }
  vo(event) {
    return this.p2w(event);
  }
}
class TreeMapModel {}
class AbstractTreeMapModel {
  constructor() {
    this.m2s_1 = Companion_getInstance_56().e1b_1;
    this.n2s_1 = Companion_getInstance_57().k1z_1;
    this.o2s_1 = Companion_getInstance_32().b1b_1;
    this.p2s_1 = this.q2w();
    this.q2s_1 = new SimpleProperties();
    this.r2s_1 = HashMap.i7();
    this.s2s_1 = HashMap.i7();
    this.t2s_1 = SimpleSingleSelection.i15(null);
    this.u2s_1 = SimpleSelection.x14();
    this.v2s_1 = SimpleSelection.x14();
    this.w2s_1 = new SimpleFilter();
    this.x2s_1 = new SimpleFilter();
    this.a2t_1 = true;
    this.b2t_1 = true;
    this.c2t_1 = true;
    this.e2t_1 = CollectionFactory_instance.c17();
    var tmp = this;
    tmp.f2t_1 = new AbstractTreeMapModel$colorMapListener$1(this);
    this.g2t_1 = null;
    this.h2t_1 = this.properties.bz('currentRoot', null);
    this.i2t_1 = null;
    this.j2t_1 = null;
    this.k2t_1 = true;
    this.l2t_1 = true;
    this.m2t_1 = true;
    this.n2t_1 = false;
    this.o2t_1 = false;
    this.p2t_1 = false;
    this.q2t_1 = 0.0;
    this.r2t_1 = 0.0;
    this.s2t_1 = 0.0;
    this.t2t_1 = this.properties.bz('progress', 0);
    this.u2t_1 = 0.0;
    this.v2t_1 = Companion_getInstance_29().s17_1;
    var tmp_0 = this;
    tmp_0.x2t_1 = new AbstractTreeMapModel$colorProvider$1();
    this.y2t_1 = HashMap.i7();
    this.z2t_1 = HashMap.i7();
    this.a2u_1 = HashMap.i7();
    this.w2t_1 = Companion_getInstance_30().v18_1;
    this.y2s_1 = CollectionFactory_instance.nk();
    this.d2t_1 = this.a2t_1 ? Companion_getInstance_29().s17_1.v17(ensureNotNull(getKClassFromExpression(getSelf(this)).kc()), 0, 1) : null;
    var tmp_1 = this;
    tmp_1.z2s_1 = this.v2t_1.x17('TreeMapModelUpdater', 40, true, new AbstractTreeMapModel$1(this));
    var tmp_2 = this.settings;
    tmp_2.addTreeMapSettingsListener(new AbstractTreeMapModel$2(this));
    this.u2u();
    var tmp_3 = this.probing;
    tmp_3.u13(new AbstractTreeMapModel$3(this));
    var tmp_4 = this.filter;
    tmp_4.ok(new AbstractTreeMapModel$4(this));
    var tmp_5 = this.search;
    tmp_5.ok(new AbstractTreeMapModel$5(this));
    this.h2t_1.zo(new AbstractTreeMapModel$6(this));
  }
  r2w() {
    return this.m2s_1;
  }
  s2w() {
    return this.n2s_1;
  }
  t2w() {
    return this.o2s_1;
  }
  u2w() {
    return this.p2s_1;
  }
  p1z() {
    return this.q2s_1;
  }
  v2w() {
    return this.r2s_1;
  }
  w2w() {
    return this.s2s_1;
  }
  w24() {
    return this.t2s_1;
  }
  x2w() {
    return this.u2s_1;
  }
  x24() {
    return this.v2s_1;
  }
  y24() {
    return this.w2s_1;
  }
  y2w() {
    return this.x2s_1;
  }
  s2u(_set____db54di) {
    this.g2t_1 = _set____db54di;
  }
  z2w() {
    return this.g2t_1;
  }
  a2x(_set____db54di) {
    this.i2t_1 = _set____db54di;
  }
  b2x() {
    return this.i2t_1;
  }
  c2x(_set____db54di) {
    this.j2t_1 = _set____db54di;
  }
  d2x() {
    return this.j2t_1;
  }
  w2c() {
    return this.m2t_1 || this.l2t_1 || this.k2t_1;
  }
  e2x(_set____db54di) {
    this.q2t_1 = _set____db54di;
  }
  f2x() {
    return this.q2t_1;
  }
  g2x(_set____db54di) {
    this.r2t_1 = _set____db54di;
  }
  h2x() {
    return this.r2t_1;
  }
  i2x(_set____db54di) {
    this.s2t_1 = _set____db54di;
  }
  j2x() {
    return this.s2t_1;
  }
  k2x(_set____db54di) {
    this.u2t_1 = _set____db54di;
  }
  l2x() {
    return this.u2t_1;
  }
  m2x() {
    return this.v2t_1;
  }
  n2x() {
    return this.w2t_1;
  }
  o2x(colorProvider) {
    if (!(this.x2t_1 === colorProvider)) {
      this.x2t_1 = colorProvider;
      this.c2v();
    }
  }
  p2x(_set____db54di) {
    return this.o2x(_set____db54di);
  }
  q2x() {
    return this.x2t_1;
  }
  r2x() {
    var tmp = Iterables_instance;
    var tmp_0 = this.getTreeMapColumnsInclude(true);
    return tmp.qj(tmp_0, new AbstractTreeMapModel$groupByColumns$1(this));
  }
  s2x() {
    var tmp = Iterables_instance;
    var tmp_0 = this.getTreeMapColumnsInclude(true);
    return tmp.qj(tmp_0, new AbstractTreeMapModel$sizeColumns$1(this));
  }
  t2x() {
    var tmp = Iterables_instance;
    var tmp_0 = this.getTreeMapColumnsInclude(true);
    return tmp.qj(tmp_0, new AbstractTreeMapModel$colorColumns$1(this));
  }
  u2x() {
    var tmp = Iterables_instance;
    var tmp_0 = this.getTreeMapColumnsInclude(true);
    return tmp.qj(tmp_0, new AbstractTreeMapModel$heightColumns$1(this));
  }
  v2x() {
    var tmp = Iterables_instance;
    var tmp_0 = this.getTreeMapColumnsInclude(false);
    return tmp.qj(tmp_0, new AbstractTreeMapModel$labelsColumns$1(this));
  }
  w2x() {
    var tmp = Iterables_instance;
    var tmp_0 = this.getTreeMapColumnsInclude(false);
    return tmp.qj(tmp_0, new AbstractTreeMapModel$tooltipColumns$1(this));
  }
  getTreeMapColumnsInclude(includeNone) {
    var list = ArrayList.q1();
    if (includeNone) {
      list.c1(null);
    }
    var inductionVariable = 0;
    var last = this.columnCount;
    if (inductionVariable < last)
      do {
        var c = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        list.c1(this.getTreeMapColumn(c));
      }
       while (inductionVariable < last);
    return list;
  }
  isNumericType(column) {
    var type = this.getColumnClass(column);
    return !(type == null) && this.v2t_1.a18(type);
  }
  isTemporalType(column) {
    var type = this.getColumnClass(column);
    return !(type == null) && this.v2t_1.b18(type);
  }
  isVisualType(column) {
    var type = this.getColumnClass(column);
    return !(type == null) && this.v2t_1.c18(type);
  }
  x2x() {
    var groupBy;
    var label;
    var background;
    var color;
    var size;
    var height = null;
    var firstCategorical = null;
    var secondCategorical = null;
    var inductionVariable = 0;
    var last = this.columnCount;
    if (inductionVariable < last)
      $l$loop: do {
        var c = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        var column = this.getTreeMapColumn(c);
        if (equals(this.getColumnClass(ensureNotNull(column)), PrimitiveClasses_getInstance().dd())) {
          if (firstCategorical == null) {
            firstCategorical = column;
          } else {
            if (!this.isEveryValueUnique(column)) {
              secondCategorical = column;
            }
            break $l$loop;
          }
        }
      }
       while (inductionVariable < last);
    var inductionVariable_0 = 0;
    var last_0 = this.columnCount;
    if (inductionVariable_0 < last_0)
      $l$loop_0: do {
        var c_0 = inductionVariable_0;
        inductionVariable_0 = inductionVariable_0 + 1 | 0;
        var column_0 = this.getTreeMapColumn(c_0);
        if (this.v2t_1.d18(ensureNotNull(this.getColumnClass(ensureNotNull(column_0))))) {
          secondCategorical = column_0;
          break $l$loop_0;
        }
      }
       while (inductionVariable_0 < last_0);
    label = firstCategorical;
    groupBy = secondCategorical;
    var firstVisual = null;
    var inductionVariable_1 = 0;
    var last_1 = this.columnCount;
    if (inductionVariable_1 < last_1)
      $l$loop_1: do {
        var c_1 = inductionVariable_1;
        inductionVariable_1 = inductionVariable_1 + 1 | 0;
        var column_1 = this.getTreeMapColumn(c_1);
        if (!(column_1 == null) && this.isVisualType(column_1) && !this.v2t_1.z17(getKClass(CPColor), ensureNotNull(this.getColumnClass(column_1)))) {
          if (firstVisual == null) {
            firstVisual = column_1;
            break $l$loop_1;
          }
        }
      }
       while (inductionVariable_1 < last_1);
    background = firstVisual;
    var firstNumerical = null;
    var secondNumerical = null;
    var inductionVariable_2 = 0;
    var last_2 = this.columnCount;
    if (inductionVariable_2 < last_2)
      $l$loop_2: do {
        var c_2 = inductionVariable_2;
        inductionVariable_2 = inductionVariable_2 + 1 | 0;
        var column_2 = this.getTreeMapColumn(c_2);
        if (this.v2t_1.a18(ensureNotNull(this.getColumnClass(ensureNotNull(column_2))))) {
          if (firstNumerical == null) {
            firstNumerical = column_2;
          } else {
            secondNumerical = column_2;
            break $l$loop_2;
          }
        }
      }
       while (inductionVariable_2 < last_2);
    var firstColor = null;
    var inductionVariable_3 = 0;
    var last_3 = this.columnCount;
    if (inductionVariable_3 < last_3)
      $l$loop_3: do {
        var c_3 = inductionVariable_3;
        inductionVariable_3 = inductionVariable_3 + 1 | 0;
        var column_3 = this.getTreeMapColumn(c_3);
        if (this.v2t_1.z17(getKClass(CPColor), ensureNotNull(this.getColumnClass(ensureNotNull(column_3))))) {
          firstColor = column_3;
          break $l$loop_3;
        }
      }
       while (inductionVariable_3 < last_3);
    size = firstNumerical;
    var tmp;
    if (!(firstColor == null)) {
      tmp = firstColor;
    } else {
      var tmp_0;
      if (!(secondNumerical == null)) {
        tmp_0 = secondNumerical;
      } else {
        tmp_0 = firstNumerical;
      }
      tmp = tmp_0;
    }
    color = tmp;
    if (!(groupBy == null)) {
      var columns = listOf(groupBy);
      this.settings.y2x(columns);
    } else {
      this.i2w();
    }
    var columns_0 = listOfNotNull(label);
    this.settings.z2x(columns_0);
    this.settings.a2y(size);
    this.settings.b2y(height);
    this.settings.c2y(color);
    this.settings.d2y(background);
    var count = 0;
    // Inline function 'kotlin.run' call
    var i = 0;
    while (i < this.columnCount && count < 5) {
      var column_4 = this.getTreeMapColumn(i);
      if (this.v2t_1.z17(PrimitiveClasses_getInstance().dd(), ensureNotNull(this.getColumnClass(ensureNotNull(column_4)))) || this.isNumericType(column_4)) {
        this.settings.setShowPopup(this.getTreeMapColumn(i), true);
        count = count + 1 | 0;
      }
      i = i + 1 | 0;
    }
    var inductionVariable_4 = 0;
    var last_4 = this.columnCount;
    if (inductionVariable_4 < last_4)
      do {
        var i_0 = inductionVariable_4;
        inductionVariable_4 = inductionVariable_4 + 1 | 0;
        var column_5 = this.getTreeMapColumn(i_0);
        if (this.isNumericType(ensureNotNull(column_5))) {
          this.settings.getColumnSettings(column_5).setShowLabel(true);
        }
      }
       while (inductionVariable_4 < last_4);
  }
  i2w() {
    cancelDoUpdate(this);
    this.k2t_1 = true;
    if (this.b2t_1) {
      this.z2s_1.r15();
    } else {
      this.w2v();
    }
  }
  w2v() {
    var dimension = this.settings.getDimension();
    if (!(dimension == null) && dimension.gm() > 0 && dimension.hm() > 0) {
      if (!(this.workerFuture == null) && ensureNotNull(this.workerFuture).m17()) {
        try {
          ensureNotNull(this.workerFuture).zj();
        } catch ($p) {
          if ($p instanceof IllegalStateException) {
            var e = $p;
          } else {
            if ($p instanceof Exception) {
              var e_0 = $p;
              printStackTrace(e_0);
            } else {
              throw $p;
            }
          }
        }
      }
      cancelDoUpdate(this);
      this.a2x(new Worker(this));
      if (this.a2t_1 && !(this.d2t_1 == null)) {
        try {
          this.c2x(this.d2t_1.p17(this.worker));
        } catch ($p) {
          if ($p instanceof Error) {
            var t = $p;
            printStackTrace(t);
          } else {
            throw $p;
          }
        }
      } else {
        try {
          ensureNotNull(this.worker).o2u();
          this.a2x(null);
        } catch ($p) {
          if ($p instanceof Error) {
            var e_1 = $p;
            printStackTrace(e_1);
          } else {
            throw $p;
          }
        }
      }
    }
  }
  q2w() {
    return new DefaultTreeMapSettings(this, this.colorFactory, this.n2s_1, this.o2s_1);
  }
  w2u() {
    this.e2t_1.u4();
  }
  c2v() {
    cancelDoUpdate(this);
    this.m2t_1 = true;
    if (this.b2t_1) {
      this.z2s_1.r15();
    } else {
      this.w2v();
    }
  }
  u2u() {
    var lx = this.settings.getLightSourceX();
    var ly = this.settings.getLightSourceY();
    var lz = this.settings.getLightSourceZ();
    // Inline function 'kotlin.math.sqrt' call
    var x = lx * lx + ly * ly + lz * lz;
    var len = Math.sqrt(x);
    this.e2x(lx / len);
    this.g2x(ly / len);
    this.i2x(lz / len);
  }
  e2y() {
    var _iterator__ex2g4s = this.y2s_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var treeMapListener = _iterator__ex2g4s.j1();
      treeMapListener.f2y();
    }
  }
  x2u(event) {
    var _iterator__ex2g4s = this.y2s_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var treeMapListener = _iterator__ex2g4s.j1();
      treeMapListener.g2y(event);
    }
  }
  getTreeMapColumnsByIndices(columns) {
    // Inline function 'kotlin.collections.mapIndexed' call
    // Inline function 'kotlin.collections.mapIndexedTo' call
    var destination = ArrayList.n1(columns.length);
    var index = 0;
    var inductionVariable = 0;
    var last = columns.length;
    while (inductionVariable < last) {
      var item = columns[inductionVariable];
      inductionVariable = inductionVariable + 1 | 0;
      index = index + 1 | 0;
      var tmp$ret$0 = this.getTreeMapColumn(columns[item]);
      destination.c1(tmp$ret$0);
    }
    var mapIndexed = destination;
    return filterNotNull(mapIndexed);
  }
  getTreeMapColumns(columns) {
    return filterNotNull(toList(columns));
  }
  getTreeMapColumnsByNames(columnNames) {
    // Inline function 'kotlin.collections.mapIndexed' call
    // Inline function 'kotlin.collections.mapIndexedTo' call
    var destination = ArrayList.n1(columnNames.length);
    var index = 0;
    var inductionVariable = 0;
    var last = columnNames.length;
    while (inductionVariable < last) {
      var item = columnNames[inductionVariable];
      inductionVariable = inductionVariable + 1 | 0;
      index = index + 1 | 0;
      var tmp$ret$0 = this.getTreeMapColumnByName(item);
      destination.c1(tmp$ret$0);
    }
    var mapIndexed = destination;
    return filterNotNull(mapIndexed);
  }
  t2u(parent, worker) {
    this.k2x(0.0);
    this.h2y(parent, worker);
    this.w2u();
    var dimension = this.settings.getDimension();
    var tmp;
    if (!(dimension == null)) {
      var viewport = this.x2r();
      this.i2y(parent, viewport);
      tmp = this.j2y(parent, worker);
    } else {
      tmp = false;
    }
    return tmp;
  }
  x2r() {
    var d = ensureNotNull(this.settings.getDimension());
    var heightColumn = this.settings.heightColumn;
    var border = this.settings.getDefaultColumnSettings().getBorderThickness();
    var halfBorder = border / 2;
    var tmp;
    if (!(heightColumn == null) && (this.isNumericType(heightColumn) || this.isTemporalType(heightColumn))) {
      var tmp_0 = -this.settings.getMaximumHeight();
      var tmp0 = d.gm();
      // Inline function 'kotlin.math.min' call
      var b = d.hm();
      var tmp$ret$0 = Math.min(tmp0, b);
      var shift = numberToInt(tmp_0 * tmp$ret$0);
      var labeling = this.settings.getDefaultColumnSettings().getLabeling();
      var levels = this.settings.groupByColumns.k1();
      var xShift = -(shift + levels * ensureNotNull(labeling).f2l(this));
      // Inline function 'kotlin.math.min' call
      var b_0 = shift + levels * labeling.e2l(this);
      var yShift = -Math.min(0.0, b_0);
      tmp = Double_3.z1h(xShift + halfBorder, yShift + halfBorder, d.gm() - xShift - border, d.hm() - yShift - border);
    } else {
      tmp = Double_3.z1h(0 + halfBorder, 0 + halfBorder, d.gm() - border, d.hm() - border);
    }
    return tmp;
  }
  h2y(node, worker) {
    this.k2y(node, worker);
    this.l2y(node, worker);
    this.m2y(node, worker);
  }
  k2y(root, worker) {
    var sizeColumn = this.settings.sizeColumn;
    var min = this.getNumericMin(sizeColumn);
    var max = this.getNumericMax(sizeColumn);
    if (min == null || max == null) {
      min = 0.0;
      max = 1.0;
    }
    var scale = this.settings.getColumnSettings(sizeColumn).getScale();
    var hideFilterResults = ensureNotNull(this.settings.isHideFilterResults());
    var hideSearchResults = ensureNotNull(this.settings.isHideSearchResults());
    var _iterator__ex2g4s = this.r2s_1.n6().h1();
    while (_iterator__ex2g4s.i1()) {
      var node = _iterator__ex2g4s.j1();
      var size;
      if (hideFilterResults && this.filter.qk(node)) {
        size = 0.0;
      } else {
        if (hideSearchResults && this.search.qk(node)) {
          size = 0.0;
        } else {
          if (this.b2u(node)) {
            if (sizeColumn == null || this.isRoot(node)) {
              size = 1.0;
            } else {
              var o = this.getValueAt(node, sizeColumn);
              if (!(o == null)) {
                var tmp;
                if (isNumber(o)) {
                  tmp = ensureNotNull(scale).q2k(numberToDouble(o), min, max);
                } else {
                  tmp = 0.0;
                }
                size = tmp;
              } else {
                size = 0.0;
              }
            }
          } else {
            size = 0.0;
          }
        }
      }
      if (isInfinite(size) || isNaN_0(size)) {
        node.n2y(0.0);
      } else {
        // Inline function 'kotlin.math.max' call
        var b = size;
        var tmp$ret$0 = Math.max(0.0, b);
        node.n2y(tmp$ret$0);
        if (node.o2y()) {
          var tmp0 = this.maximumSize;
          // Inline function 'kotlin.math.max' call
          var b_0 = size;
          var tmp$ret$1 = Math.max(tmp0, b_0);
          this.k2x(tmp$ret$1);
        }
      }
    }
  }
  l2y(node, worker) {
    if (!node.z2y()) {
      if (worker == null || !worker.o17()) {
        var size;
        var sizeColumn = this.settings.sizeColumn;
        if (sizeColumn == null || this.settings.getColumnSettings(sizeColumn).getAggregation() === Companion_getInstance_74().r2y_1) {
          var sumSizes = new Float64Array(this.getChildCount(node));
          var c = 0;
          var _iterator__ex2g4s = this.getChildren(node).h1();
          while (_iterator__ex2g4s.i1()) {
            var child = _iterator__ex2g4s.j1();
            this.l2y(child, worker);
            var value = child.k1();
            sumSizes[c] = value;
            c = c + 1 | 0;
          }
          size = Companion_getInstance_74().r2y_1.p2y(sumSizes);
        } else {
          var _iterator__ex2g4s_0 = this.getChildren(node).h1();
          while (_iterator__ex2g4s_0.i1()) {
            var child_0 = _iterator__ex2g4s_0.j1();
            this.l2y(child_0, worker);
          }
          var columnIndex = sizeColumn;
          var count = 0;
          var _iterator__ex2g4s_1 = this.preorderEnumeration(node).h1();
          while (_iterator__ex2g4s_1.i1()) {
            var child_1 = _iterator__ex2g4s_1.j1();
            if (this.isLeaf(child_1) && !this.filter.qk(child_1)) {
              var tmp = this.getValueAt(child_1, columnIndex);
              var value_0 = (tmp == null ? true : isNumber(tmp)) ? tmp : THROW_CCE();
              if (!(value_0 == null)) {
                count = count + 1 | 0;
              }
            }
          }
          var sizes = new Float64Array(count);
          var i = 0;
          var _iterator__ex2g4s_2 = this.preorderEnumeration(node).h1();
          while (_iterator__ex2g4s_2.i1()) {
            var child_2 = _iterator__ex2g4s_2.j1();
            if (this.isLeaf(child_2) && !this.filter.qk(child_2)) {
              var tmp_0 = this.getValueAt(child_2, columnIndex);
              var value_1 = (tmp_0 == null ? true : isNumber(tmp_0)) ? tmp_0 : THROW_CCE();
              if (!(value_1 == null) && i < sizes.length) {
                sizes[i] = child_2.k1();
                i = i + 1 | 0;
              }
            }
          }
          var d = ensureNotNull(this.settings.getColumnSettings(sizeColumn).getAggregation()).p2y(sizes);
          size = d == null ? count : d;
        }
        if (size == null || isInfinite(size) || isNaN_0(size)) {
          node.n2y(0.0);
        } else {
          // Inline function 'kotlin.math.max' call
          var b = size;
          var tmp$ret$0 = Math.max(0.0, b);
          node.n2y(tmp$ret$0);
          if (node.o2y()) {
            var tmp0 = this.maximumSize;
            // Inline function 'kotlin.math.max' call
            var b_0 = size;
            var tmp$ret$1 = Math.max(tmp0, b_0);
            this.k2x(tmp$ret$1);
          }
        }
      }
    }
  }
  m2y(node, worker) {
    if (!node.z2y()) {
      if (worker == null || !worker.o17()) {
        var size;
        var sumSizes = new Float64Array(this.getChildCount(node));
        var c = 0;
        var _iterator__ex2g4s = this.getChildren(node).h1();
        while (_iterator__ex2g4s.i1()) {
          var child = _iterator__ex2g4s.j1();
          this.m2y(child, worker);
          var value = child.k1();
          sumSizes[c] = value;
          c = c + 1 | 0;
        }
        size = ensureNotNull(Companion_getInstance_74().r2y_1.p2y(sumSizes));
        node.a2z(size);
      }
    }
  }
  j2y(currentRoot, worker) {
    if (!worker.o17()) {
      var rootAlgorithm = this.settings.getColumnSettings(this.getGroupByColumn(currentRoot)).getAlgorithm();
      rootAlgorithm.startLayout(ensureNotNull(this.k2u(currentRoot)).i1h(), this, currentRoot, worker);
    }
    if (!worker.o17()) {
      var iterable = this.depthFirstIterator(currentRoot);
      var _iterator__ex2g4s = iterable.h1();
      while (_iterator__ex2g4s.i1()) {
        var node = _iterator__ex2g4s.j1();
        if (!worker.o17()) {
          if (!this.b2u(node)) {
            var columnSettings = this.settings.getColumnSettings(this.getGroupByColumn(node));
            var sortOrder = !(columnSettings.getOrderingDirection() == null) ? ensureNotNull(columnSettings.getOrderingDirection()) : SortOrder_Descending_getInstance();
            var arrayList = ArrayList.s(toList_0(this.getChildren(node)));
            // Inline function 'kotlin.collections.toTypedArray' call
            var array = copyToArray(arrayList);
            var sizes = array;
            sizes = columnSettings.getOrdering().b2z(this, sizes, sortOrder);
            // Inline function 'kotlin.collections.isNotEmpty' call
            // Inline function 'kotlin.collections.isEmpty' call
            if (!(sizes.length === 0)) {
              var algorithm = columnSettings.getAlgorithm();
              var horizontalVashingPoint = columnSettings.getOrderingHorizontalVanishingPoint();
              var verticalVashingPoint = columnSettings.getOrderingVerticalVanishingPoint();
              var tmp = currentRoot === node ? this.k2u(node) : null;
              var tmp_0 = sizes;
              var tmp_1 = this.getSumSize(node);
              var tmp_2 = horizontalVashingPoint == null ? 4 : horizontalVashingPoint;
              algorithm.depthFirstLayout(tmp, node, tmp_0, tmp_1, tmp_2, verticalVashingPoint == null ? 3 : verticalVashingPoint, this, worker);
            }
          }
        } else {
          return true;
        }
      }
    } else {
      return true;
    }
    if (!worker.o17()) {
      var iterable_0 = this.breadthFirstIterator(currentRoot);
      var progress = 0;
      var _iterator__ex2g4s_0 = iterable_0.h1();
      while (_iterator__ex2g4s_0.i1()) {
        var node_0 = _iterator__ex2g4s_0.j1();
        if (!worker.o17()) {
          if (!this.b2u(node_0)) {
            if (currentRoot === this.getParent(node_0)) {
              this.p2u(imul_0(progress, 99) / this.getChildCount(currentRoot) | 0);
              progress = progress + 1 | 0;
            }
            var arrayList_0 = ArrayList.s(toList_0(this.getChildren(node_0)));
            // Inline function 'kotlin.collections.toTypedArray' call
            var array_0 = copyToArray(arrayList_0);
            var sizes_0 = array_0;
            var columnSettings_0 = this.settings.getColumnSettings(this.getGroupByColumn(node_0));
            var sortOrder_0 = !(columnSettings_0.getOrderingDirection() == null) ? columnSettings_0.getOrderingDirection() : SortOrder_Descending_getInstance();
            sizes_0 = columnSettings_0.getOrdering().b2z(this, sizes_0, ensureNotNull(sortOrder_0));
            // Inline function 'kotlin.collections.isNotEmpty' call
            // Inline function 'kotlin.collections.isEmpty' call
            if (!(sizes_0.length === 0)) {
              var algorithm_0 = columnSettings_0.getAlgorithm();
              var shape = this.k2u(node_0);
              if (algorithm_0.isCompatible(shape)) {
                shape = ensureNotNull(columnSettings_0.getNesting()).y2l(this, currentRoot, node_0, ensureNotNull(shape));
                node_0.d2z(shape);
                var horizontalVashingPoint_0 = ensureNotNull(columnSettings_0.getOrderingHorizontalVanishingPoint());
                var verticalVashingPoint_0 = ensureNotNull(columnSettings_0.getOrderingVerticalVanishingPoint());
                algorithm_0.breadthFirstLayout(shape, node_0, sizes_0, this.getSumSize(node_0), horizontalVashingPoint_0, verticalVashingPoint_0, this, worker);
              } else {
                var indexedObject = sizes_0;
                var inductionVariable = 0;
                var last = indexedObject.length;
                while (inductionVariable < last) {
                  var child = indexedObject[inductionVariable];
                  inductionVariable = inductionVariable + 1 | 0;
                  child.c2z(null);
                }
              }
            }
          }
        } else {
          return true;
        }
      }
    } else {
      return true;
    }
    var tmp_3;
    if (!worker.o17()) {
      var rootAlgorithm_0 = this.settings.getColumnSettings(this.getChildrenGroupByColumn(currentRoot)).getAlgorithm();
      rootAlgorithm_0.finishLayout(Double_3.z1h(0.0, 0.0, ensureNotNull(this.settings.getDimension()).gm(), ensureNotNull(this.settings.getDimension()).hm()), this, currentRoot);
      tmp_3 = false;
    } else {
      tmp_3 = true;
    }
    return tmp_3;
  }
  getSumSize(node) {
    return node.e2z();
  }
  v2u(parent, worker) {
    var selected = this.settings.colorColumn;
    if (!(selected == null)) {
      var colorMap = this.getColorMapCurrent();
      var _iterator__ex2g4s = this.preorderEnumeration(parent).h1();
      while (_iterator__ex2g4s.i1()) {
        var node = _iterator__ex2g4s.j1();
        if (worker == null || !worker.o17()) {
          if (this.b2u(node)) {
            var object = this.getValueAt(node, selected);
            if (!(colorMap == null)) {
              var color = colorMap.getColor(object);
              this.setColor(node, color);
            } else {
              var tmp;
              if (!(object == null)) {
                tmp = object instanceof CPColor;
              } else {
                tmp = false;
              }
              if (tmp) {
                this.setColor(node, object);
              } else {
                this.setColor(node, this.colorFactory.z27());
              }
            }
          } else {
            var object_0;
            var tmp_0;
            if (this.v2t_1.z17(PrimitiveClasses_getInstance().tc(), ensureNotNull(this.getColumnClass(selected)))) {
              var sizes = getSizeWeightedValues(this, node, selected);
              tmp_0 = Companion_getInstance_74().s2y_1.p2y(sizes);
            } else {
              tmp_0 = this.getAggregateValue(node, selected);
            }
            object_0 = tmp_0;
            if (!(colorMap == null)) {
              var color_0 = colorMap.getColor(object_0);
              this.setColor(node, color_0);
            } else {
              var tmp_1;
              if (!(object_0 == null)) {
                tmp_1 = object_0 instanceof CPColor;
              } else {
                tmp_1 = false;
              }
              if (tmp_1) {
                this.setColor(node, object_0);
              } else {
                this.setColor(node, this.colorFactory.z27());
              }
            }
          }
        } else {
          return true;
        }
      }
    }
    return false;
  }
  getColorMapCurrent() {
    var column = this.settings.colorColumn;
    return this.getColorMap(column);
  }
  getColorMap(column) {
    var tmp;
    if (!(column == null)) {
      var columnSettings = this.settings.getColumnSettings(column);
      var colorMap = columnSettings.getColorMap();
      if (colorMap == null) {
        colorMap = this.createDefaultColorMap(column);
        columnSettings.setColorMap(colorMap);
      }
      tmp = colorMap;
    } else {
      tmp = null;
    }
    return tmp;
  }
  getCategoricalColorMap(column) {
    var colorMap = this.y2t_1.c3(column);
    if (colorMap == null) {
      colorMap = this.f2z(column);
      var tmp0 = this.y2t_1;
      // Inline function 'kotlin.collections.set' call
      var value = colorMap;
      tmp0.o6(column, value);
    }
    return colorMap;
  }
  getPredefinedColorMap(column) {
    var colorMap = this.z2t_1.c3(column);
    if (colorMap == null) {
      colorMap = this.o2s_1.k1b(this.getNumericMin(column), this.getNumericMax(column));
      var tmp0 = this.z2t_1;
      // Inline function 'kotlin.collections.set' call
      var value = colorMap;
      tmp0.o6(column, value);
    }
    return colorMap;
  }
  getCustomColorMap(column) {
    var colorMap = this.a2u_1.c3(column);
    if (colorMap == null) {
      colorMap = this.o2s_1.l1b(this.getNumericMin(column), this.getNumericMax(column));
      var tmp0 = this.a2u_1;
      // Inline function 'kotlin.collections.set' call
      var value = colorMap;
      tmp0.o6(column, value);
    }
    return colorMap;
  }
  g2z(node) {
    return node.k1();
  }
  getSize(node) {
    return this.g2z(node instanceof AbstractTreeMapNode ? node : THROW_CCE());
  }
  i2y(node, shape) {
    node.c2z(shape);
  }
  setShape(node, shape) {
    return this.i2y(node instanceof AbstractTreeMapNode ? node : THROW_CCE(), shape);
  }
  k2u(node) {
    return node.h2z();
  }
  getShape(node) {
    return this.k2u(node instanceof AbstractTreeMapNode ? node : THROW_CCE());
  }
  setNestedShape(node, shape) {
    node.d2z(shape);
  }
  getNestedShape(node) {
    return ensureNotNull(node.i2z());
  }
  j2z(node) {
    return ensureNotNull(node.f1h());
  }
  getBounds(node) {
    return this.j2z(node instanceof AbstractTreeMapNode ? node : THROW_CCE());
  }
  k2z(node) {
    return node.l2z();
  }
  getLevel(node) {
    return this.k2z(node instanceof AbstractTreeMapNode ? node : THROW_CCE());
  }
  getGroupByColumn(node) {
    return node.m2z();
  }
  getChildrenGroupByColumn(node) {
    return node.n2z();
  }
  b2u(node) {
    return node == null || node.o2y();
  }
  hasNoChildren(node) {
    return this.b2u(node instanceof AbstractTreeMapNode ? node : THROW_CCE());
  }
  isLeaf(node) {
    return node.z2y();
  }
  parentPreorderEnumeration(parent) {
    return new AbstractTreeMapModel$parentPreorderEnumeration$1(this, parent);
  }
  preorderEnumeration(parent) {
    return new AbstractTreeMapModel$preorderEnumeration$1(this, parent);
  }
  breadthFirstIterator(parent) {
    return new AbstractTreeMapModel$breadthFirstIterator$1(this, parent);
  }
  depthFirstIterator(parent) {
    return new AbstractTreeMapModel$depthFirstIterator$1(this, parent);
  }
  getAggregateValue(node, column) {
    var tmp;
    if (!(column == null)) {
      var columnIndex = column;
      var tmp_0;
      if (this.b2u(node)) {
        tmp_0 = this.getValueAt(node, columnIndex);
      } else {
        var key = new NodeField(this, node, column);
        var tmp_1;
        if (this.e2t_1.a3(key)) {
          tmp_1 = this.e2t_1.c3(key);
        } else {
          var tmp_2;
          if (this.v2t_1.z17(PrimitiveClasses_getInstance().tc(), ensureNotNull(this.getColumnClass(columnIndex)))) {
            var agg = this.settings.getColumnSettings(columnIndex).getAggregation();
            var tmp_3;
            if (agg === Companion_getInstance_74().r2y_1) {
              var count = 0;
              var _iterator__ex2g4s = this.getChildren(node).h1();
              while (_iterator__ex2g4s.i1()) {
                var child = _iterator__ex2g4s.j1();
                if (!this.filter.qk(child) && !this.search.qk(child)) {
                  count = count + 1 | 0;
                }
              }
              var sizes = new Float64Array(count);
              var i = 0;
              var _iterator__ex2g4s_0 = this.getChildren(node).h1();
              while (_iterator__ex2g4s_0.i1()) {
                var child_0 = _iterator__ex2g4s_0.j1();
                if (!this.filter.qk(child_0) && !this.search.qk(child_0)) {
                  var tmp_4 = this.getAggregateValue(child_0, column);
                  var value = (tmp_4 == null ? true : isNumber(tmp_4)) ? tmp_4 : THROW_CCE();
                  if (!(value == null)) {
                    sizes[i] = numberToDouble(value);
                  } else {
                    sizes[i] = NaN;
                  }
                  i = i + 1 | 0;
                }
              }
              var aggregate = agg.p2y(sizes);
              if (!(aggregate == null)) {
                // Inline function 'kotlin.collections.set' call
                this.e2t_1.o6(key, aggregate);
              }
              tmp_3 = aggregate;
            } else {
              var values;
              var tmp_5;
              if (ensureNotNull(agg).o2z()) {
                tmp_5 = getSizeWeightedValues(this, node, column);
              } else {
                tmp_5 = getValues(this, node, column);
              }
              values = tmp_5;
              var aggregate_0 = agg.p2y(values);
              if (!(aggregate_0 == null)) {
                // Inline function 'kotlin.collections.set' call
                this.e2t_1.o6(key, aggregate_0);
              }
              tmp_3 = aggregate_0;
            }
            tmp_2 = tmp_3;
          } else if (this.v2t_1.z17(PrimitiveClasses_getInstance().dd(), ensureNotNull(this.getColumnClass(columnIndex)))) {
            var aggregate_1 = null;
            var first = true;
            var _iterator__ex2g4s_1 = this.getChildren(node).h1();
            $l$loop: while (_iterator__ex2g4s_1.i1()) {
              var child_1 = _iterator__ex2g4s_1.j1();
              if (!this.filter.qk(child_1) && !this.search.qk(child_1)) {
                var tmp_6 = this.getAggregateValue(child_1, column);
                var value_0 = (tmp_6 == null ? true : typeof tmp_6 === 'string') ? tmp_6 : THROW_CCE();
                if (first) {
                  aggregate_1 = value_0;
                  first = false;
                } else {
                  if (!(aggregate_1 == null) && !(aggregate_1 == value_0)) {
                    aggregate_1 = null;
                    break $l$loop;
                  }
                }
              }
            }
            tmp_2 = aggregate_1;
          } else {
            tmp_2 = null;
          }
          tmp_1 = tmp_2;
        }
        tmp_0 = tmp_1;
      }
      tmp = tmp_0;
    } else {
      tmp = null;
    }
    return tmp;
  }
  getStringValue(node, column) {
    var tmp;
    if (!(column == null) && !(node == null)) {
      var value;
      if (this.b2u(node)) {
        value = this.getValueAt(node, column);
      } else {
        value = this.getAggregateValue(node, column);
      }
      var format = this.settings.getColumnSettings(column).getFormat();
      var tmp_0;
      if (!(format == null)) {
        var tmp_1;
        try {
          tmp_1 = format.zk(value, false);
        } catch ($p) {
          var tmp_2;
          if ($p instanceof IllegalArgumentException) {
            var e = $p;
            tmp_2 = ' ';
          } else {
            throw $p;
          }
          tmp_1 = tmp_2;
        }
        tmp_0 = tmp_1;
      } else {
        if (value == null) {
          value = ' ';
        }
        var string;
        var tmp_3;
        if (typeof value === 'string') {
          tmp_3 = value;
        } else {
          if (isNumber(value)) {
            tmp_3 = ensureNotNull(this.w2t_1.x18().zk(value, false));
          } else {
            tmp_3 = toString_1(value);
          }
        }
        string = tmp_3;
        tmp_0 = string;
      }
      tmp = tmp_0;
    } else {
      tmp = null;
    }
    return tmp;
  }
  p2z(currentRoot) {
    this.h2t_1.ap(currentRoot);
  }
  q2z(_set____db54di) {
    return this.p2z((_set____db54di == null ? true : _set____db54di instanceof AbstractTreeMapNode) ? _set____db54di : THROW_CCE());
  }
  r2z() {
    return this.h2t_1.z2();
  }
  f2w() {
    cancelDoUpdate(this);
    this.l2t_1 = true;
    if (this.b2t_1) {
      this.z2s_1.r15();
    } else {
      this.w2v();
    }
  }
  addListener(treeMapListener) {
    this.y2s_1.c1(treeMapListener);
  }
  removeListener(treeMapListener) {
    this.y2s_1.e3(treeMapListener);
  }
  getNode(position) {
    if (!(position == null)) {
      var currentRoot = this.currentRoot;
      if (!(currentRoot == null)) {
        var rectangle = this.k2u(currentRoot);
        if (!(rectangle == null) && rectangle.j1h(position)) {
          var node = visit(this, currentRoot, position);
          if (!(node == null) && !(node === currentRoot) && !this.filter.qk(node) && !this.search.qk(node)) {
            return node;
          }
        }
      }
    }
    return null;
  }
  waitUntilReady() {
    this.v2t_1.y17(80n);
    while (this.isDirty) {
      this.v2t_1.y17(50n);
      while (this.root == null || this.k2u(ensureNotNull(this.root)) == null) {
        this.v2t_1.y17(50n);
      }
      var workerFuture = this.workerFuture;
      while (workerFuture == null || !workerFuture.m17() || workerFuture.o17()) {
        try {
          ensureNotNull(workerFuture).zj();
        } catch ($p) {
          if ($p instanceof IllegalStateException) {
            var e = $p;
          } else {
            if ($p instanceof Exception) {
              var e_0 = $p;
              printStackTrace(e_0);
            } else {
              throw $p;
            }
          }
        }
        workerFuture = this.workerFuture;
      }
    }
  }
  getColor(node) {
    return this.colorProvider.f2v(node);
  }
  setColor(node, color) {
    node.s2z(color);
  }
  progressProperty() {
    return this.t2t_1;
  }
  p2u(progress) {
    this.t2t_1.ap(progress);
  }
  getFormatPattern(columnIndex) {
    var format = this.settings.getColumnSettings(this.getTreeMapColumn(columnIndex)).getFormat();
    var tmp;
    if (!(format == null)) {
      tmp = format.yk();
    } else {
      tmp = null;
    }
    return tmp;
  }
  setFormatPattern(columnIndex, pattern) {
    var column = this.getTreeMapColumn(columnIndex);
    if (!(column == null)) {
      if (this.isNumericType(column)) {
        this.settings.getColumnSettings(column).setFormat(this.w2t_1.z18(pattern));
      } else if (this.isTemporalType(column)) {
        this.settings.getColumnSettings(column).setFormat(this.w2t_1.y18(pattern));
      }
    }
  }
  get colorFactory() {
    return this.r2w();
  }
  get settings() {
    return this.u2w();
  }
  get properties() {
    return this.p1z();
  }
  get probing() {
    return this.w24();
  }
  get highlighting() {
    return this.x2w();
  }
  get selection() {
    return this.x24();
  }
  get filter() {
    return this.y24();
  }
  get search() {
    return this.y2w();
  }
  get root() {
    return this.z2w();
  }
  get worker() {
    return this.b2x();
  }
  get workerFuture() {
    return this.d2x();
  }
  get isDirty() {
    return this.w2c();
  }
  get normalizedLightSourceX() {
    return this.f2x();
  }
  get normalizedLightSourceY() {
    return this.h2x();
  }
  get normalizedLightSourceZ() {
    return this.j2x();
  }
  get maximumSize() {
    return this.l2x();
  }
  get colorProvider() {
    return this.q2x();
  }
  set colorProvider(value) {
    this.o2x(value);
  }
  get groupByColumns() {
    return this.r2x();
  }
  get sizeColumns() {
    return this.s2x();
  }
  get colorColumns() {
    return this.t2x();
  }
  get heightColumns() {
    return this.u2x();
  }
  get labelsColumns() {
    return this.v2x();
  }
  get tooltipColumns() {
    return this.w2x();
  }
  get currentRoot() {
    return this.r2z();
  }
  set currentRoot(value) {
    this.p2z(value);
  }
  get dataFrame() {
    return this.j2c();
  }
  get rowCount() {
    return this.e2g();
  }
  get columnCount() {
    return this.y2e();
  }
}
class AbstractTreeMapNode {
  constructor(model) {
    this.c2u_1 = 1.0;
    this.d2u_1 = null;
    this.f2u_1 = null;
    this.g2u_1 = null;
    this.h2u_1 = null;
    this.i2u_1 = null;
    this.j2u_1 = 0;
    this.e2u_1 = model;
    this.s2z(!(model == null) ? model.colorFactory.z27() : null);
  }
  n2y(_set____db54di) {
    this.c2u_1 = _set____db54di;
  }
  k1() {
    return this.c2u_1;
  }
  c2z(shape) {
    if (this.d2u_1 == null || !equals(ensureNotNull(this.d2u_1), shape)) {
      this.d2u_1 = shape;
      this.g2u_1 = null;
      if (!(this.h2u_1 == null)) {
        var cushionImage = ensureNotNull(this.h2u_1).zj();
        if (!(cushionImage == null)) {
          cushionImage.fb();
        }
        this.h2u_1 = null;
      }
    }
  }
  h2z() {
    return this.d2u_1;
  }
  s2z(c) {
    this.f2u_1 = c;
    this.g2u_1 = null;
    if (!(this.h2u_1 == null)) {
      var cushionImage = ensureNotNull(this.h2u_1).zj();
      if (!(cushionImage == null)) {
        cushionImage.fb();
      }
      this.h2u_1 = null;
    }
  }
  e2v() {
    return this.f2u_1;
  }
  d2z(value) {
  }
  i2z() {
    return this.h2z();
  }
  w2z(_set____db54di) {
    this.j2u_1 = _set____db54di;
  }
  l2z() {
    return this.j2u_1;
  }
  y2z() {
    return this.i2u_1;
  }
  z2z() {
    return this.i2u_1 == null;
  }
  d30(parent) {
    this.i2u_1 = parent;
    this.w2z(ensureNotNull(this.y2z()).l2z() + 1 | 0);
  }
  h30() {
    if (!(this.e2u_1.settings.backgroundColumn == null)) {
      var column = this.e2u_1.settings.backgroundColumn;
      if (!(column == null) && this.o2y()) {
        var tmp;
        if (!this.e2u_1.isNumericType(column)) {
          var value = this.e2u_1.getValueAt(this, column);
          tmp = value == null ? null : toString_1(value);
        } else {
          var value_0 = this.e2u_1.getValueAt(this, column);
          tmp = value_0 == null ? null : toString_1(value_0);
        }
        return tmp;
      }
    }
    var tmp_0;
    var tmp_1;
    if (!(this.e2u_1.settings.labelsColumns == null)) {
      // Inline function 'kotlin.collections.isNotEmpty' call
      tmp_1 = !this.e2u_1.settings.labelsColumns.p1();
    } else {
      tmp_1 = false;
    }
    if (tmp_1) {
      var column_0 = this.e2u_1.settings.labelsColumns.l1(0);
      var tmp_2;
      if (!(column_0 == null) || !this.o2y()) {
        var tmp_3;
        if (!(this.f30() == null)) {
          tmp_3 = toString_0(this.f30());
        } else {
          tmp_3 = null;
        }
        tmp_2 = tmp_3;
      } else if (!this.e2u_1.isNumericType(column_0)) {
        var value_1 = this.e2u_1.getValueAt(this, column_0);
        tmp_2 = value_1 == null ? null : toString_1(value_1);
      } else {
        var value_2 = this.e2u_1.getValueAt(this, column_0);
        tmp_2 = value_2 == null ? null : toString_1(value_2);
      }
      tmp_0 = tmp_2;
    } else {
      var tmp_4;
      if (!(this.f30() == null)) {
        tmp_4 = toString_0(this.f30());
      } else {
        tmp_4 = null;
      }
      tmp_0 = tmp_4;
    }
    return tmp_0;
  }
  f1h() {
    var tmp;
    if (!(this.h2z() == null)) {
      tmp = ensureNotNull(this.h2z()).i1h();
    } else {
      tmp = null;
    }
    return tmp;
  }
  toString() {
    return ensureNotNull(this.h30());
  }
  t2z() {
    var tmp;
    if (!(this.g2u_1 == null)) {
      tmp = this.g2u_1;
    } else {
      var data = null;
      var parent = this.y2z();
      if (!(parent == null) && !(this.h2z() == null)) {
        var bounds;
        var tmp_0 = this.h2z();
        if (tmp_0 instanceof Rectangle) {
          var tmp_1 = this.h2z();
          bounds = tmp_1 instanceof Rectangle ? tmp_1 : THROW_CCE();
        } else {
          var b = ensureNotNull(this.h2z()).i1h();
          bounds = Rectangle.from(numberToInt(b.g1h()), numberToInt(b.h1h()), numberToInt(b.gm()), numberToInt(b.hm()));
        }
        var top = bounds.b1w_1;
        var bottom = bounds.b1w_1 + bounds.d1w_1 | 0;
        var left = bounds.a1w_1;
        var right = bounds.a1w_1 + bounds.c1w_1 | 0;
        if (parent.y2z() == null) {
          data = Cushion.j30(this.e2u_1, left, right, bounds.c1w_1, top, bottom, bounds.d1w_1);
        } else {
          data = Cushion.i30(parent.t2z(), this.e2u_1, left, right, bounds.c1w_1, top, bottom, bounds.d1w_1);
        }
      }
      this.g2u_1 = data;
      tmp = data;
    }
    return tmp;
  }
  k30() {
    var tmp;
    if (this.h2u_1 == null) {
      var image = createCushionImage(this);
      var tmp_0;
      if (!(image == null)) {
        this.h2u_1 = new SoftReference(image);
        tmp_0 = image;
      } else {
        tmp_0 = null;
      }
      tmp = tmp_0;
    } else {
      var image_0 = ensureNotNull(this.h2u_1).zj();
      if (image_0 == null) {
        image_0 = createCushionImage(this);
        if (!(image_0 == null)) {
          this.h2u_1 = new SoftReference(image_0);
        } else {
          return null;
        }
      }
      tmp = image_0;
    }
    return tmp;
  }
  l30() {
    if (this.h2z() == null)
      return null;
    var bounds;
    var tmp = this.h2z();
    if (tmp instanceof Rectangle) {
      var tmp_0 = this.h2z();
      bounds = tmp_0 instanceof Rectangle ? tmp_0 : THROW_CCE();
    } else {
      var b = ensureNotNull(this.h2z()).i1h();
      bounds = Rectangle.from(numberToInt(b.g1h()), numberToInt(b.h1h()), numberToInt(b.gm()), numberToInt(b.hm()));
    }
    // Inline function 'kotlin.math.max' call
    var b_0 = bounds.c1w_1;
    var width = Math.max(1, b_0);
    // Inline function 'kotlin.math.max' call
    var b_1 = bounds.d1w_1;
    var height = Math.max(1, b_1);
    return ensureNotNull(this.t2z()).m30(this.e2u_1, this.e2v(), bounds.a1w_1, bounds.b1w_1, width, height);
  }
  n30() {
    return this;
  }
}
class TreeMapSettings {}
class AbstractTreeMapSettings {
  constructor() {
    this.o30_1 = CollectionFactory_instance.nk();
  }
  addTreeMapSettingsListener(listener) {
    this.o30_1.c1(listener);
  }
  removeTreeMapSettingsListener(listener) {
    this.o30_1.e3(listener);
  }
  removeTreeMapSettingsListeners() {
    this.o30_1.u4();
  }
  p30(event) {
    var _iterator__ex2g4s = this.o30_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var listener = _iterator__ex2g4s.j1();
      listener.y2v(event);
    }
  }
  get properties() {
    return this.p1z();
  }
  get groupByColumns() {
    return this.r2x();
  }
  set groupByColumns(value) {
    this.y2x(value);
  }
  get sizeColumn() {
    return this.q30();
  }
  set sizeColumn(value) {
    this.a2y(value);
  }
  get colorColumn() {
    return this.r30();
  }
  set colorColumn(value) {
    this.c2y(value);
  }
  get labelsColumns() {
    return this.v2x();
  }
  set labelsColumns(value) {
    this.z2x(value);
  }
  get toolTipColumns() {
    return this.t30();
  }
  set toolTipColumns(value) {
    this.s30(value);
  }
  get backgroundColumn() {
    return this.u30();
  }
  set backgroundColumn(value) {
    this.d2y(value);
  }
  get heightColumn() {
    return this.v30();
  }
  set heightColumn(value) {
    this.b2y(value);
  }
  get rendering() {
    return this.w30();
  }
  set rendering(value) {
    this.p2n(value);
  }
  get renderingSelection() {
    return this.x30();
  }
  get maximumHeightInterval() {
    return this.y30();
  }
  get lightSourceHeightInterval() {
    return this.z30();
  }
  get lightSourceAmbientInterval() {
    return this.a31();
  }
  get lightSourceXInterval() {
    return this.b31();
  }
  get lightSourceYInterval() {
    return this.c31();
  }
  get lightSourceZInterval() {
    return this.d31();
  }
}
class Companion_73 {
  constructor() {
    this.e31_1 = 7;
    this.f31_1 = 20;
  }
}
class AbstractTreeMapToolTip {
  constructor(view) {
    this.h31_1 = null;
    this.i31_1 = null;
    this.j31_1 = 230;
    this.k31_1 = new ToolTipTreeMapRenderer();
    this.g31_1 = view;
  }
  l31(node) {
    if (!(this.h31_1 === node)) {
      this.h31_1 = node;
      if (this.h31_1 == null) {
        this.m31();
      }
    }
  }
  n31() {
    return this.h31_1;
  }
  o31() {
    if (this.i31_1 == null) {
      this.i31_1 = this.p31();
    }
    return this.i31_1;
  }
  q31() {
    return this.j31_1;
  }
  r31() {
    return this.k31_1;
  }
  s31() {
    return new Insets(2, 2, 2, 2);
  }
  t31(g) {
    var model = this.g31_1.h2l();
    if (!(model == null)) {
      if (!(this.n31() == null)) {
        var bounds = this.r31().v31(g, this.g31_1, model, ensureNotNull(this.n31()), this.q31(), 20, 7, false);
        var tmp;
        if (!(bounds == null)) {
          var insets = this.s31();
          tmp = Dimension.fm(((bounds.c1w_1 + 1 | 0) + insets.u1x_1 | 0) + insets.w1x_1 | 0, ((bounds.d1w_1 + 1 | 0) + insets.t1x_1 | 0) + insets.v1x_1 | 0);
        } else {
          tmp = null;
        }
        return tmp;
      }
    }
    return null;
  }
  w31() {
    var probingColor = ensureNotNull(this.g31_1.h2l()).settings.getProbingColor();
    var tmp;
    if (!(probingColor == null)) {
      tmp = alpha(probingColor, 0.5);
    } else {
      tmp = null;
    }
    return tmp;
  }
  x31(g) {
    var background = ensureNotNull(this.g31_1.h2l()).settings.getTooltipBackground();
    if (!(background == null)) {
      var insets = this.s31();
      var x = insets.u1x_1;
      var y = insets.t1x_1;
      var width = (this.gm() - insets.u1x_1 | 0) - insets.w1x_1 | 0;
      var height = (this.hm() - insets.t1x_1 | 0) - insets.v1x_1 | 0;
      g.l2m(background);
      g.y31(x, y, width, height, 10.0, 10.0);
      var borderColor = this.w31();
      if (!(borderColor == null)) {
        g.y2m(borderColor);
        var borderThickness = insets.u1x_1;
        g.x2m(borderThickness);
        var halfThickness = borderThickness / 2;
        g.z31(halfThickness, halfThickness, width, height, 10.0, 10.0);
      }
    }
  }
  a32(g) {
    var insets = this.s31();
    var x = insets.u1x_1;
    var y = insets.t1x_1;
    var width = (this.gm() - insets.u1x_1 | 0) - insets.w1x_1 | 0;
    var height = (this.hm() - insets.t1x_1 | 0) - insets.v1x_1 | 0;
    g.u2m();
    g.o1j(x, y);
    g.v2m(Double_3.z1h(0, 0, width, height));
    g.b32(true);
    this.r31().c32(g, this.g31_1, this.n31(), this.q31(), 20, 7, null);
    g.w2m();
  }
  d32() {
    var tmp;
    if (!(this.o31() == null)) {
      tmp = ensureNotNull(this.o31()).e32();
    } else {
      tmp = null;
    }
    return tmp;
  }
  p31() {
    return new DefaultTreeMapPopup(this.g31_1);
  }
  f32(node) {
    if (!(this.n31() === node)) {
      this.l31(node);
      var tooltipPosition = this.g32();
      var tooltipDimension = this.t31(null);
      if (!(tooltipPosition == null) && !(tooltipDimension == null)) {
        var popup = this.o31();
        if (!(popup == null)) {
          this.h32(tooltipPosition.r1v_1, tooltipPosition.s1v_1);
        }
      }
      if (node == null) {
        this.m31();
      }
      if (!(this.o31() == null)) {
        ensureNotNull(this.o31()).i32();
      }
    }
  }
  j32(p) {
    var p_0 = p;
    var model = ensureNotNull(this.g31_1.h2l());
    if (!(model == null)) {
      if (!(this.n31() == null)) {
        var shape = this.g31_1.k32(ensureNotNull(model.currentRoot));
        if (p_0 == null) {
          var nodeShape = this.g31_1.k32(ensureNotNull(this.n31()));
          if (!(nodeShape == null)) {
            p_0 = new Point(numberToInt(nodeShape.i1h().k1h()), numberToInt(nodeShape.i1h().m1h()));
          } else {
            return null;
          }
        }
        var mouseX = p_0.r1v_1;
        var mouseY = p_0.s1v_1;
        if (!(shape == null)) {
          var size = this.t31(null);
          if (!(size == null)) {
            var width = size.cm_1;
            var height = size.dm_1;
            var bounds = Rectangle.from(mouseX + 20 | 0, mouseY + 7 | 0, width, height);
            var d = this.g31_1.k1();
            if (mouseX > d.gm() - 20 - width)
              bounds.a1w_1 = mouseX - (20 + width | 0) | 0;
            if (mouseY > d.hm() - height - 7)
              bounds.b1w_1 = (d.dm_1 - height | 0) - 7 | 0;
            return new Point(bounds.a1w_1, bounds.b1w_1);
          }
        }
      }
    }
    return null;
  }
  h32(x, y) {
    var popup = this.o31();
    if (!(popup == null)) {
      popup.l32(x, y, this.g31_1.q2n());
    }
  }
  m31() {
    var popup = this.o31();
    if (!(popup == null)) {
      popup.m31();
    }
  }
}
class AbstractTreeMapView$probingListener$1 {
  constructor(this$0) {
    this.q33_1 = this$0;
  }
  r33(event) {
    var toolTip = this.q33_1.s33();
    if (!(toolTip == null)) {
      var node = ensureNotNull(this.q33_1.h2l()).probing.z13();
      ensureNotNull(this.q33_1.h33_1).f32(node);
    }
    this.q33_1.i32();
  }
  x13(event) {
    return this.r33(event);
  }
}
class AbstractTreeMapView$selectionListener$1 {
  constructor(this$0) {
    this.t33_1 = this$0;
  }
  u33(event) {
    var toolTip = this.t33_1.v33();
    if (!(toolTip == null)) {
      if (ensureNotNull(this.t33_1.h2l()).selection.f13() && ensureNotNull(this.t33_1.h2l()).selection.h13() === 1) {
        var node = ensureNotNull(this.t33_1.h2l()).selection.h1().j1();
        ensureNotNull(this.t33_1.v33()).f32(node);
      } else {
        ensureNotNull(this.t33_1.v33()).f32(null);
      }
    }
    this.t33_1.i32();
  }
  b14(event) {
    return this.u33(event);
  }
}
class AbstractTreeMapView$_treeMapListener$1 {
  constructor(this$0) {
    this.w33_1 = this$0;
  }
  f2y() {
  }
  g2y(event) {
    if (event.a34_1) {
      this.w33_1.y33();
      this.w33_1.i32();
    } else {
      this.w33_1.x33();
    }
  }
}
class AbstractTreeMapView$modelPropertyChangeListener$1 {
  constructor(this$0) {
    this.c34_1 = this$0;
  }
  d34(name, event) {
    if (!equals('progress', name)) {
      this.c34_1.i32();
    } else {
      this.c34_1.y33();
      this.c34_1.e34(300n);
    }
  }
  ey(name, event) {
    return this.d34((name == null ? true : typeof name === 'string') ? name : THROW_CCE(), event);
  }
}
class AbstractTreeMapView$filterListener$1 {
  constructor(this$0) {
    this.f34_1 = this$0;
  }
}
class AbstractTreeMapView$propertyChangeListener$1 {
  constructor(this$0) {
    this.g34_1 = this$0;
  }
  h34(name, event) {
    if (TreeMapPropertyType_dimension_getInstance().equals(name) || TreeMapPropertyType_heightField_getInstance().equals(name) || TreeMapPropertyType_groupByField_getInstance().equals(name)) {
      this.g34_1.j34();
    } else if (TreeMapPropertyType_dimensionFixed_getInstance().equals(name)) {
      this.g34_1.i34();
    }
    this.g34_1.i32();
  }
  ey(name, event) {
    return this.h34(name instanceof TreeMapPropertyType ? name : THROW_CCE(), event);
  }
}
class AbstractTreeMapView$treeMapSettingsListener$1 {
  constructor(this$0) {
    this.k34_1 = this$0;
  }
  y2v(event) {
    if (event.l34()) {
      this.k34_1.j34();
      this.k34_1.i32();
    }
  }
}
class AbstractTreeMapView$1 {
  constructor(this$0) {
    this.m34_1 = this$0;
  }
  n34(event) {
    this.m34_1.i32();
  }
  x13(event) {
    return this.n34(event);
  }
}
class AbstractTreeMapView$2 {
  constructor(this$0) {
    this.o34_1 = this$0;
  }
  v15(event) {
    this.o34_1.y33();
    this.o34_1.i32();
  }
}
class AbstractTreeMapView {
  constructor(headless) {
    this.n32_1 = headless;
    var tmp = this;
    tmp.w32_1 = new AbstractTreeMapView$probingListener$1(this);
    var tmp_0 = this;
    tmp_0.x32_1 = new AbstractTreeMapView$selectionListener$1(this);
    var tmp_1 = this;
    tmp_1.y32_1 = new AbstractTreeMapView$_treeMapListener$1(this);
    var tmp_2 = this;
    tmp_2.z32_1 = new AbstractTreeMapView$modelPropertyChangeListener$1(this);
    var tmp_3 = this;
    tmp_3.a33_1 = new AbstractTreeMapView$filterListener$1(this);
    var tmp_4 = this;
    tmp_4.b33_1 = new AbstractTreeMapView$propertyChangeListener$1(this);
    var tmp_5 = this;
    tmp_5.c33_1 = new AbstractTreeMapView$treeMapSettingsListener$1(this);
    this.d33_1 = null;
    this.e33_1 = DefaultTreeMapLabelRenderer.m35();
    this.f33_1 = DefaultTreeMapHeaderRenderer.l36();
    this.g33_1 = DefaultTreeMapTooltipRenderer.j37();
    this.h33_1 = new DefaultTreeMapToolTip(this);
    this.i33_1 = null;
    this.j33_1 = true;
    this.k33_1 = Progressive_Disabled_getInstance();
    this.l33_1 = false;
    this.m33_1 = true;
    this.o33_1 = true;
    this.r32_1 = ArrayList.q1();
    this.s32_1 = ArrayList.q1();
    this.t32_1 = ArrayList.q1();
    this.u32_1 = ArrayList.q1();
    this.v32_1 = HashMap.i7();
    this.r32_1.c1(new BackgroundRootNodeTreeMapRenderer());
    this.r32_1.c1(NodesTreeMapRenderer.m37(new BackgroundParentNodeRenderer(), 0));
    this.s32_1.c1(NodesTreeMapRenderer.m37(new LeafNodeRenderer(false), 0));
    this.s32_1.c1(NodesTreeMapRenderer.m37(new LeafNodeRenderer(false), 1));
    this.t32_1.c1(NodesTreeMapRenderer.m37(new LeafNodeRenderer(true), 0));
    this.t32_1.c1(NodesTreeMapRenderer.m37(new TextParentNodeRenderer(), 0));
    this.t32_1.c1(NodesTreeMapRenderer.m37(new BorderParentNodeRenderer(), 0));
    this.t32_1.c1(NodesTreeMapRenderer.m37(new HighlightParentNodeRenderer(), 0));
    this.u32_1.c1(NodesTreeMapRenderer.m37(new LeafNodeRenderer(true), 1));
    this.u32_1.c1(NodesTreeMapRenderer.m37(new TextParentNodeRenderer(), 1));
    this.u32_1.c1(NodesTreeMapRenderer.n37(new SelectionNodeRenderer()));
    this.o37(null);
    var width = 0;
    var height = 0;
    this.o32_1 = SimpleBoundedInterval.qp(0.0, width, 0.0, width);
    this.p32_1 = SimpleBoundedInterval.qp(0.0, height, 0.0, height);
    this.q32_1 = SimpleTwoDScreenTransform.u24(SimpleOneDScreenTransform.z16(this.o32_1, width), SimpleOneDScreenTransform.a17(this.p32_1, height, true, true), width, height, 1.0);
    this.n33_1 = new ScreenTransformRubberBand(this.q32_1);
    this.n33_1.w23_1.u13(new AbstractTreeMapView$1(this));
    new RangesScreenTransformCoordinator(this.o32_1, this.p32_1);
    this.q32_1.h24(new AbstractTreeMapView$2(this));
    this.o32_1.lp(10.0);
    this.p32_1.lp(10.0);
  }
  p37() {
    return this.n32_1;
  }
  i2s() {
    return this.o32_1;
  }
  j2s() {
    return this.p32_1;
  }
  z2r() {
    return this.q32_1;
  }
  q37() {
    return this.r32_1;
  }
  r37() {
    return this.t32_1;
  }
  s37() {
    return this.u32_1;
  }
  g2n(model) {
    if (!(this.d33_1 == null)) {
      ensureNotNull(this.d33_1).removeListener(this.y32_1);
      ensureNotNull(this.d33_1).settings.removeTreeMapSettingsListener(this.c33_1);
      ensureNotNull(this.d33_1).properties.gy(this.z32_1);
      ensureNotNull(this.d33_1).filter.pk(this.a33_1);
      ensureNotNull(this.d33_1).search.pk(this.a33_1);
      ensureNotNull(this.d33_1).settings.properties.gy(this.b33_1);
      ensureNotNull(this.d33_1).probing.v13(this.w32_1);
      ensureNotNull(this.d33_1).selection.d13(this.x32_1);
    }
    this.d33_1 = model;
    this.y33();
    if (!(this.d33_1 == null)) {
      ensureNotNull(this.d33_1).addListener(this.y32_1);
      ensureNotNull(this.d33_1).settings.addTreeMapSettingsListener(this.c33_1);
      ensureNotNull(this.d33_1).properties.hy(this.z32_1);
      ensureNotNull(this.d33_1).filter.ok(this.a33_1);
      ensureNotNull(this.d33_1).search.ok(this.a33_1);
      ensureNotNull(this.d33_1).settings.properties.hy(this.b33_1);
      ensureNotNull(this.d33_1).probing.u13(this.w32_1);
      ensureNotNull(this.d33_1).selection.c13(this.x32_1);
    }
    this.i34();
    this.j34();
  }
  h2l() {
    return this.d33_1;
  }
  l2l() {
    return this.e33_1;
  }
  t37() {
    return this.f33_1;
  }
  u37() {
    return this.g33_1;
  }
  o37(tooltip) {
    if (!(this.i33_1 === tooltip)) {
      this.i33_1 = tooltip;
      this.i32();
    }
  }
  v33() {
    return this.i33_1;
  }
  v37() {
    return this.j33_1;
  }
  w37() {
    return this.l33_1;
  }
  t2r(_set____db54di) {
    this.m33_1 = _set____db54di;
  }
  u2r() {
    return this.m33_1;
  }
  y23() {
    return this.n33_1;
  }
  f2c(_set____db54di) {
    this.o33_1 = _set____db54di;
  }
  x2p() {
    return Companion_instance_49.f1w(this.o32_1.start, this.p32_1.start, this.o32_1.start + this.o32_1.extent, this.p32_1.start + this.p32_1.extent);
  }
  x33() {
    this.f2c(true);
    this.i32();
  }
  y33() {
    this.f2c(true);
    if (!(this.v32_1 == null)) {
      this.v32_1.u4();
    }
  }
  j2m(node) {
    var tmp0_safe_receiver = this.v32_1;
    var shape = tmp0_safe_receiver == null ? null : tmp0_safe_receiver.c3(node);
    if (!(this.h2l() == null) && shape == null && !(node == null)) {
      shape = ensureNotNull(this.h2l()).getShape(node);
      if (!(shape == null)) {
        shape = this.x37(shape);
        var tmp0 = ensureNotNull(this.v32_1);
        // Inline function 'kotlin.collections.set' call
        var value = shape;
        tmp0.o6(node, value);
      }
    }
    return shape;
  }
  x37(shape) {
    var shape_0 = shape;
    var tmp;
    if (isInterface(shape_0, Rectangle2D)) {
      var r = shape_0;
      tmp = this.y37(r);
    } else {
      if (shape_0 instanceof TextShape) {
        var at = ScreenTransformHelper_instance.i1x(this.q32_1.g1h(), this.q32_1.h1h());
        tmp = shape_0.n1x(at);
      } else {
        var at_0 = ScreenTransformHelper_instance.i1x(this.q32_1.g1h(), this.q32_1.h1h());
        tmp = ensureNotNull(at_0.c1k(shape_0));
      }
    }
    shape_0 = tmp;
    return shape_0;
  }
  worldToScreenShape(shape) {
    return this.x37(shape);
  }
  k32(node) {
    var screenShape = this.j2m(node);
    if (!(screenShape == null)) {
      return ensureNotNull(ensureNotNull(this.h2l()).settings.rendering).getRenderedShape(this, ensureNotNull(this.h2l()), node, screenShape);
    } else {
      return Rectangle.from(0, 0, 0, 0);
    }
  }
  y2p() {
    return Companion_instance_49.f1w(this.o32_1.gn(), this.p32_1.gn(), this.o32_1.hn(), this.p32_1.hn());
  }
  z37(x) {
    return getXCoordinateAxis(this).a16(x);
  }
  a38(y) {
    return getYCoordinateAxis(this).a16(y);
  }
  n2q(animate, x1, x2, y1, y2) {
    this.o32_1.qo(x1, x2 - x1);
    this.p32_1.qo(y1, y2 - y1);
  }
  s2r(p) {
    if (!(this.h2l() == null) && !(p == null)) {
      var currentRoot = ensureNotNull(this.h2l()).currentRoot;
      if (!(currentRoot == null)) {
        var rectangle = this.k32(currentRoot);
        if (!(rectangle == null) && this.p33(p, rectangle)) {
          var node = visit_0(this, ensureNotNull(this.h2l()), currentRoot, p);
          if (!(node == null) && !(node === currentRoot) && !ensureNotNull(this.h2l()).filter.qk(node) && !ensureNotNull(this.h2l()).search.qk(node)) {
            return node;
          }
        }
      }
    }
    return null;
  }
  p33(p, shape) {
    var tmp;
    if (shape instanceof TextShape) {
      tmp = shape.i1h().j1h(p);
    } else {
      tmp = shape.j1h(p);
    }
    return tmp;
  }
  w2r(rect) {
    if (!(this.h2l() == null) && !(rect == null)) {
      var list = ArrayList.q1();
      var currentRoot = ensureNotNull(ensureNotNull(this.h2l()).currentRoot);
      if (this.k32(currentRoot).l1h(rect)) {
        if (ensureNotNull(this.h2l()).hasNoChildren(currentRoot)) {
          list.c1(ensureNotNull(currentRoot));
        }
        visit_1(this, ensureNotNull(this.h2l()), ensureNotNull(currentRoot), rect, list);
      }
      return list;
    }
    return null;
  }
  b38(rectangle) {
    var x1 = numberToInt(round(this.q32_1.g1h().b16(rectangle.p1h())));
    var x2 = numberToInt(round(this.q32_1.g1h().b16(rectangle.s1h())));
    var y1 = numberToInt(round(this.q32_1.h1h().b16(rectangle.r1h())));
    var y2 = numberToInt(round(this.q32_1.h1h().b16(rectangle.t1h())));
    var width = x2 - x1 | 0;
    var height = y2 - y1 | 0;
    var tmp;
    if (width < 0 || height < 0) {
      tmp = Rectangle.from(x1, y1, 0, 0);
    } else {
      tmp = Rectangle.from(x1, y1, width, height);
    }
    return tmp;
  }
  y37(r) {
    var x1 = this.q32_1.g1h().b16(r.p1h());
    var x2 = this.q32_1.g1h().b16(r.s1h());
    var y1 = this.q32_1.h1h().b16(r.r1h());
    var y2 = this.q32_1.h1h().b16(r.t1h());
    var width = x2 - x1;
    var height = y2 - y1;
    var tmp;
    if (width < 0 || height < 0) {
      tmp = Double_3.z1h(x1, y1, 0.0, 0.0);
    } else {
      tmp = Double_3.z1h(x1, y1, width, height);
    }
    return tmp;
  }
  s2l() {
    var zoomFactorX = this.o32_1.pp() / this.o32_1.extent;
    var zoomFactorY = this.p32_1.pp() / this.p32_1.extent;
    // Inline function 'kotlin.math.min' call
    return Math.min(zoomFactorX, zoomFactorY);
  }
  s33() {
    return this.h33_1;
  }
  i32() {
    this.e34(0n);
  }
  v2r(x, y) {
    var model = ensureNotNull(this.h2l());
    var root = ensureNotNull(model.currentRoot);
    model.probing.i13();
    var location = new Point(x, y);
    if (!(location == null)) {
      var v = ArrayList.q1();
      var _iterator__ex2g4s = model.breadthFirstIterator(root).h1();
      $l$loop_0: while (_iterator__ex2g4s.i1()) {
        var treeMapNode = _iterator__ex2g4s.j1();
        if (this.p33(location, this.k32(treeMapNode))) {
          if (model.hasNoChildren(treeMapNode)) {
            var world = this.y2p();
            this.n2q(false, world.p1h(), world.s1h(), world.r1h(), world.t1h());
            model.q2z(model.root);
            break $l$loop_0;
          }
          v.c1(treeMapNode);
          if (v.k1() > 1) {
            var world_0 = this.y2p();
            this.n2q(false, world_0.p1h(), world_0.s1h(), world_0.r1h(), world_0.t1h());
            model.q2z(v.l1(1));
            break $l$loop_0;
          }
        }
      }
    }
  }
  d2s() {
    var model = ensureNotNull(this.h2l());
    var node = model.probing.z13();
    if (!(node == null)) {
      $l$loop: while (!(model.getParent(ensureNotNull(node)) === model.currentRoot)) {
        node = model.getParent(ensureNotNull(node));
        if (node == null) {
          break $l$loop;
        }
      }
    }
    if (!(node == null)) {
      if (!model.hasNoChildren(node)) {
        var xRange = this.o32_1;
        var yRange = this.p32_1;
        this.n2q(false, xRange.gn(), xRange.hn(), yRange.gn(), yRange.hn());
        model.q2z(node);
      }
    }
  }
  e2s() {
    var model = ensureNotNull(this.h2l());
    model.probing.i13();
    if (!model.isRoot(ensureNotNull(model.currentRoot))) {
      var xRange = this.o32_1;
      var yRange = this.p32_1;
      this.n2q(false, xRange.gn(), xRange.hn(), yRange.gn(), yRange.hn());
      var root = model.getParent(ensureNotNull(model.currentRoot));
      model.q2z(ensureNotNull(root));
    }
  }
  f2s() {
    var model = ensureNotNull(this.h2l());
    var node = model.probing.z13();
    if (!(node == null)) {
      $l$loop: while (!(model.getParent(ensureNotNull(node)) === model.currentRoot)) {
        node = model.getParent(ensureNotNull(node));
        if (node == null) {
          break $l$loop;
        }
      }
    }
    if (!(node == null) && !model.hasNoChildren(node)) {
      var rect = model.getBounds(node);
      var world = this.y2p();
      var xExtent = rect.gm();
      var yExtent = rect.hm();
      var xRangeRatio = xExtent / world.gm();
      var yRangeRatio = yExtent / world.hm();
      // Inline function 'kotlin.math.max' call
      var rangeRatio = Math.max(xRangeRatio, yRangeRatio);
      xExtent = rangeRatio * world.gm();
      yExtent = rangeRatio * world.hm();
      var x1 = rect.g1h();
      var x2 = x1 + xExtent;
      var y1 = world.t1h() - (rect.h1h() + yExtent);
      var y2 = world.t1h() - rect.h1h();
      if (x1 < world.p1h()) {
        x1 = world.p1h();
        x2 = x1 + xExtent;
      }
      if (x2 > world.s1h()) {
        x1 = world.s1h() - xExtent;
        x2 = world.s1h();
      }
      if (y1 < world.r1h()) {
        y1 = world.r1h();
        y2 = y1 + yExtent;
      }
      if (y2 > world.t1h()) {
        y1 = world.t1h() - yExtent;
        y2 = world.t1h();
      }
      this.n2q(true, x1, x2, y1, y2);
    }
  }
  g2s() {
    var world = this.y2p();
    this.n2q(true, world.p1h(), world.s1h(), world.r1h(), world.t1h());
  }
}
class Aggregation {}
class Companion_74 {
  constructor() {
    Companion_instance_74 = this;
    this.q2y_1 = new NoneAggregation();
    this.r2y_1 = new SumAggregation_0();
    this.s2y_1 = new SizeWeightedAggregation();
    this.t2y_1 = new AverageAggregation();
    this.u2y_1 = new CountAggregation();
    this.v2y_1 = new MinAggregation();
    this.w2y_1 = new MaxAggregation();
    this.x2y_1 = new StdDevAggregation();
    this.y2y_1 = new AggregationFactory([this.q2y_1, this.r2y_1, this.s2y_1, this.t2y_1, this.u2y_1, this.v2y_1, this.w2y_1, this.x2y_1]);
  }
  c38() {
    return this.y2y_1;
  }
}
class AggregationFactory {
  constructor(entries) {
    Companion_getInstance_74();
    this.d38_1 = ArrayList.q1();
    addAll(this.d38_1, entries);
  }
  e38() {
    return Companion_getInstance_74().r2y_1;
  }
}
class Companion_75 {
  constructor() {
    Companion_instance_75 = this;
    this.BINARY_TREE = new BinaryTreeAlgorithm();
    this.SLICE = new SliceAndDiceAlgorithm();
    this.SQUARIFIED = new SquarifiedAlgorithm();
    this.SQUARIFIEDPLUS = new SquarifiedPlusAlgorithm();
    this.STRIP = new StripAlgorithm();
    this.PIVOT_BY_SPLIT_SIZE = new PivotByAlgorithm();
    this.SPLIT = new SplitAlgorithm();
    this.CIRCULAR = new CircularAlgorithm();
    this.CIRCLEPACKING = new CirclePackingAlgorithm();
    this.PIE = new PieAlgorithm();
    this.BAR = new BarAlgorithm();
    this.MATRIX = new MatrixAlgorithm();
    this.SUNBURST = new SunburstAlgorithm();
    this.ICICLE = new IcicleAlgorithm();
    this.f38_1 = new AlgorithmFactory([this.BINARY_TREE, this.SLICE, this.SQUARIFIED, this.SQUARIFIEDPLUS, this.STRIP, this.PIVOT_BY_SPLIT_SIZE, this.SPLIT, this.CIRCULAR, this.BAR, this.PIE, this.SUNBURST, this.MATRIX, this.ICICLE]);
    this.instance = this.f38_1;
  }
  g38() {
    return this.BINARY_TREE;
  }
  h38() {
    return this.SLICE;
  }
  i38() {
    return this.SQUARIFIED;
  }
  j38() {
    return this.SQUARIFIEDPLUS;
  }
  k38() {
    return this.STRIP;
  }
  l38() {
    return this.PIVOT_BY_SPLIT_SIZE;
  }
  m38() {
    return this.SPLIT;
  }
  n38() {
    return this.CIRCULAR;
  }
  o38() {
    return this.CIRCLEPACKING;
  }
  p38() {
    return this.PIE;
  }
  q38() {
    return this.BAR;
  }
  r38() {
    return this.MATRIX;
  }
  s38() {
    return this.SUNBURST;
  }
  t38() {
    return this.ICICLE;
  }
  o21() {
    return this.instance;
  }
}
class AlgorithmFactory {
  constructor(entries) {
    Companion_getInstance_75();
    this.u38_1 = ArrayList.q1();
    addAll(this.u38_1, entries);
  }
  add(entry) {
    this.u38_1.c1(entry);
  }
  getDefault() {
    return Companion_getInstance_75().SQUARIFIEDPLUS;
  }
  getAlgorithms() {
    return this.u38_1;
  }
  get(name) {
    var _iterator__ex2g4s = this.u38_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var algorithm = _iterator__ex2g4s.j1();
      if (equals(toString_1(algorithm), name)) {
        return algorithm;
      }
    }
    return this.getDefault();
  }
  find(name) {
    var _iterator__ex2g4s = this.u38_1.h1();
    while (_iterator__ex2g4s.i1()) {
      var algorithm = _iterator__ex2g4s.j1();
      if (equals(toString_1(algorithm), name)) {
        return algorithm;
      }
    }
    return this.getDefault();
  }
}
class AverageAggregation {
  p2y(values) {
    var count = 0;
    var sum = 0.0;
    var inductionVariable = 0;
    var last = values.length;
    while (inductionVariable < last) {
      var value = values[inductionVariable];
      inductionVariable = inductionVariable + 1 | 0;
      if (isFinite_0(value)) {
        count = count + 1 | 0;
        sum = sum + value;
      }
    }
    return sum / count;
  }
  o2z() {
    return false;
  }
  toString() {
    return 'Average';
  }
}
class BackgroundParentNodeRenderer extends AbstractNodeRenderer {
  a2m(view) {
    return true;
  }
  z2l(view, root, pass) {
    return ensureNotNull(ensureNotNull(view.h2l()).settings.rendering).getParentOrder(view, root, pass);
  }
  c2m(view, node) {
    var model = ensureNotNull(view.h2l());
    return !model.isRoot(node) && !model.hasNoChildren(node);
  }
  b2m(model) {
    return ensureNotNull(model.settings.rendering).getPasses(model);
  }
  d2m(g, view, node, pass, passes, bounds, shape) {
    var model = view.h2l();
    if (!(model == null) && bounds.gm() > 0 && bounds.hm() > 0) {
      var rendering = ensureNotNull(model.settings.rendering);
      rendering.paintParent(g, view, node, pass, bounds, shape);
    }
    return true;
  }
}
class BackgroundRootNodeTreeMapRenderer {
  v38(g, view, progress) {
    var model = view.h2l();
    if (!((model == null ? null : model.currentRoot) == null)) {
      var shape = view.k32(ensureNotNull(model.currentRoot));
      if (!(shape == null)) {
        var background = model.settings.getBackground();
        if (background == null) {
          background = view.k2m();
          if (background == null) {
            background = colorOf_4(_UByte___init__impl__g9hnc4(-17), _UByte___init__impl__g9hnc4(-17), _UByte___init__impl__g9hnc4(-17));
          }
        }
        if (!(background == null)) {
          g.l2m(background);
          var d = view.k1();
          g.w38(0.0, 0.0, d.gm(), d.hm());
        }
      }
    }
  }
}
class Orientation extends Enum {}
class BarAlgorithm extends AbstractAlgorithm {
  constructor(marginProportion, orientation) {
    marginProportion = marginProportion === VOID ? 0.0 : marginProportion;
    orientation = orientation === VOID ? Orientation_Horizontal_getInstance() : orientation;
    super();
    this.x38_1 = marginProportion;
    this.y38_1 = orientation;
  }
  iterator(model, root) {
    return model.depthFirstIterator(root);
  }
  breadthFirstLayout(shape, parent, children, sumSizes, horizontalVanishingPoint, verticalVanishingPoint, accessor, worker) {
    var bounds = shape.i1h();
    var maxSize = 0.0;
    var count = 0;
    var inductionVariable = 0;
    var last = children.length;
    while (inductionVariable < last) {
      var child = children[inductionVariable];
      inductionVariable = inductionVariable + 1 | 0;
      if (accessor.getSize(child) > maxSize) {
        maxSize = accessor.getSize(child);
      }
      if (accessor.getSize(child) > 0) {
        count = count + 1 | 0;
      }
    }
    switch (this.y38_1.g3_1) {
      case 0:
        var margin = bounds.hm() * this.x38_1 / count;
        var size = bounds.hm() * (1.0 - this.x38_1) / count;
        var start = bounds.r1h() + margin / 2;
        var inductionVariable_0 = 0;
        var last_0 = children.length;
        while (inductionVariable_0 < last_0) {
          var child_0 = children[inductionVariable_0];
          inductionVariable_0 = inductionVariable_0 + 1 | 0;
          if (accessor.getSize(child_0) > 0) {
            var w = bounds.gm() * accessor.getSize(child_0) / maxSize;
            accessor.setShape(child_0, Double_3.z1h(0.0, start, w, size));
            start = start + (size + margin);
          } else {
            accessor.setShape(child_0, null);
          }
        }

        break;
      case 1:
        var margin_0 = bounds.gm() * this.x38_1 / count;
        var size_0 = bounds.gm() * (1.0 - this.x38_1) / count;
        var start_0 = bounds.p1h() + margin_0 / 2;
        var inductionVariable_1 = 0;
        var last_1 = children.length;
        while (inductionVariable_1 < last_1) {
          var child_1 = children[inductionVariable_1];
          inductionVariable_1 = inductionVariable_1 + 1 | 0;
          if (accessor.getSize(child_1) > 0) {
            var h = bounds.hm() * accessor.getSize(child_1) / maxSize;
            accessor.setShape(child_1, Double_3.z1h(start_0, bounds.t1h() - h, size_0, h));
            start_0 = start_0 + (size_0 + margin_0);
          } else {
            accessor.setShape(child_1, null);
          }
        }

        break;
      default:
        noWhenBranchMatchedException();
        break;
    }
    return false;
  }
  isCompatible(shape) {
    return !(shape == null) ? isInterface(shape, Rectangle2D) : false;
  }
  v2k() {
    return false;
  }
  toString() {
    return 'Bar';
  }
}
class BinaryTreeAlgorithm extends AbstractAlgorithm {
  constructor(vertical) {
    vertical = vertical === VOID ? true : vertical;
    super();
    this.z38_1 = vertical;
  }
  breadthFirstLayout(shape, parent, children, sumSizes, horizontalVanishingPoint, verticalVanishingPoint, accessor, worker) {
    var bounds = shape.i1h();
    this.a39(children, 0, children.length - 1 | 0, bounds, this.z38_1, accessor);
    return false;
  }
  a39(items, start, end, bounds, vertical, accessor) {
    if (start < end) {
      var total = this.w2k(items, start, end, accessor);
      var middle = (start + end | 0) / 2 | 0;
      var first = this.w2k(items, start, middle, accessor);
      var share = first / total;
      var x = bounds.g1h();
      var y = bounds.h1h();
      var w = bounds.gm();
      var h = bounds.hm();
      var r1;
      var r2;
      if (vertical) {
        r1 = Double_3.z1h(x, y, w * share, h);
        r2 = Double_3.z1h(x + w * share, y, w * (1 - share), h);
      } else {
        r1 = Double_3.z1h(x, y, w, h * share);
        r2 = Double_3.z1h(x, y + h * share, w, h * (1 - share));
      }
      this.a39(items, start, middle, r1, !vertical, accessor);
      this.a39(items, middle + 1 | 0, end, r2, !vertical, accessor);
    } else {
      accessor.setShape(items[start], bounds);
    }
  }
  isCompatible(shape) {
    return !(shape == null) ? isInterface(shape, Rectangle2D) : false;
  }
  b39() {
    return 'Binary Tree';
  }
  toString() {
    return this.b39();
  }
}
class BorderParentNodeRenderer extends AbstractNodeRenderer {
  a2m(view) {
    return true;
  }
  z2l(view, root, pass) {
    return ensureNotNull(ensureNotNull(view.h2l()).settings.rendering).getParentOrder(view, root, pass);
  }
  c2m(view, node) {
    return !ensureNotNull(view.h2l()).hasNoChildren(node);
  }
  b2m(model) {
    return ensureNotNull(model.settings.rendering).getPasses(model);
  }
  d2m(g, view, node, pass, passes, bounds, shape) {
    var model = ensureNotNull(view.h2l());
    if (bounds.gm() > 0 && bounds.hm() > 0) {
      var rendering = ensureNotNull(model.settings.rendering);
      rendering.paintParentBorder(g, node, bounds, shape, model);
    }
    return true;
  }
}
class Queue {
  constructor($outer) {
    this.e39_1 = $outer;
    this.c39_1 = null;
    this.d39_1 = null;
  }
  f39(anObject) {
    if (this.c39_1 == null) {
      this.d39_1 = new QNode(this.e39_1, anObject, null);
      this.c39_1 = this.d39_1;
    } else {
      ensureNotNull(this.d39_1).h39_1 = new QNode(this.e39_1, anObject, null);
      this.d39_1 = ensureNotNull(this.d39_1).h39_1;
    }
  }
  j39() {
    var head = this.c39_1;
    if (!(head == null)) {
      var retval = head.g39_1;
      var oldHead = head;
      this.c39_1 = head.h39_1;
      if (head == null) {
        this.d39_1 = null;
      } else {
        oldHead.h39_1 = null;
      }
      return retval;
    } else {
      throw NoSuchElementException.g1('No more elements');
    }
  }
  k39() {
    var head = this.c39_1;
    if (!(head == null)) {
      return head.g39_1;
    } else {
      throw NoSuchElementException.g1('No more elements');
    }
  }
  p1() {
    return this.c39_1 == null;
  }
}
class QNode {
  constructor($outer, _object, next) {
    this.i39_1 = $outer;
    this.g39_1 = _object;
    this.h39_1 = next;
  }
}
class BreadthFirstIterator {
  constructor(model, rootNode) {
    this.m39_1 = model;
    var v = ArrayList.n1(1);
    v.c1(rootNode);
    this.l39_1 = new Queue(this);
    this.l39_1.f39(v.h1());
  }
  i1() {
    return !this.l39_1.p1() && this.l39_1.k39().i1();
  }
  j1() {
    var enumer = this.l39_1.k39();
    var node = enumer.j1();
    var children = this.m39_1.getChildren(node).h1();
    if (!enumer.i1()) {
      this.l39_1.j39();
    }
    if (children.i1()) {
      this.l39_1.f39(children);
    }
    return node;
  }
  t4() {
    throw UnsupportedOperationException.q3();
  }
}
class Circle {
  static z39() {
    var $this = createThis(this);
    init_com_treemap_CirclePackingAlgorithm_Circle($this);
    return $this;
  }
  static q39(cx, cy, r) {
    var $this = createThis(this);
    init_com_treemap_CirclePackingAlgorithm_Circle($this);
    $this.n39_1 = cx;
    $this.o39_1 = cy;
    $this.p39_1 = r;
    return $this;
  }
  b3a() {
    return Double_3.z1h(this.n39_1 - this.p39_1, this.o39_1 - this.p39_1, this.p39_1 * 2.0, this.p39_1 * 2);
  }
  c3a(c2) {
    var cmp = this.p39_1 - c2.p39_1;
    return cmp < 0 ? 1 : cmp > 0 ? -1 : 0;
  }
  d(other) {
    return this.c3a(other instanceof Circle ? other : THROW_CCE());
  }
  equals(other) {
    if (this === other)
      return true;
    if (other == null || !getKClassFromExpression(this).equals(getKClassFromExpression(other)))
      return false;
    if (!(other instanceof Circle))
      THROW_CCE();
    if (!(this.n39_1 === other.n39_1))
      return false;
    if (!(this.o39_1 === other.o39_1))
      return false;
    if (!(this.p39_1 === other.p39_1))
      return false;
    return true;
  }
  hashCode() {
    var result = getNumberHashCode(this.n39_1);
    result = imul_0(31, result) + getNumberHashCode(this.o39_1) | 0;
    result = imul_0(31, result) + getNumberHashCode(this.p39_1) | 0;
    return result;
  }
  toString() {
    return toString_1(getKClassFromExpression(this)) + '[x:' + this.n39_1 + ',y:' + this.o39_1 + ',r:' + this.p39_1 + ']';
  }
}
class Complex {
  constructor(x, y) {
    this.r39_1 = x;
    this.s39_1 = y;
  }
  x39() {
    return this.r39_1;
  }
  y39() {
    return this.s39_1;
  }
  u39(that) {
    return new Complex(this.r39_1 + that.r39_1, this.s39_1 + that.s39_1);
  }
  v39(that) {
    return new Complex(this.r39_1 - that.r39_1, this.s39_1 - that.s39_1);
  }
  t39(that) {
    return new Complex(this.r39_1 * that.r39_1 - this.s39_1 * that.s39_1, this.r39_1 * that.s39_1 + this.s39_1 * that.r39_1);
  }
  w39(that) {
    return new Complex((this.r39_1 * that.r39_1 + this.s39_1 * that.s39_1) / (that.r39_1 * that.r39_1 + that.s39_1 * that.s39_1), (this.s39_1 * that.r39_1 - this.r39_1 * that.s39_1) / (that.r39_1 * that.r39_1 + that.s39_1 * that.s39_1));
  }
  d3a() {
    var tmp0 = this.s39_1;
    // Inline function 'kotlin.math.atan2' call
    var x = this.r39_1;
    return Math.atan2(tmp0, x);
  }
  e3a() {
    // Inline function 'kotlin.math.sqrt' call
    var x = this.r39_1 * this.r39_1 + this.s39_1 * this.s39_1;
    return Math.sqrt(x);
  }
  cw() {
    // Inline function 'kotlin.math.sqrt' call
    var x = this.e3a();
    var r = Math.sqrt(x);
    var theta = this.d3a() / 2;
    // Inline function 'kotlin.math.cos' call
    var tmp = r * Math.cos(theta);
    // Inline function 'kotlin.math.sin' call
    var tmp$ret$2 = Math.sin(theta);
    return new Complex(tmp, r * tmp$ret$2);
  }
  equals(o) {
    if (o instanceof Complex) {
      var that = o;
      return that.r39_1 === this.r39_1 && that.s39_1 === this.s39_1;
    }
    return false;
  }
  hashCode() {
    var bits = doubleToLongBits(this.r39_1);
    var tmp = bits;
    // Inline function 'kotlin.Long.times' call
    var this_0 = doubleToLongBits(this.s39_1);
    bits = tmp ^ multiply_0(this_0, fromInt_0(31));
    return convertToInt(bits) ^ convertToInt(shiftRight(bits, 32));
  }
  toString() {
    var tmp;
    if (this.s39_1 >= 0) {
      tmp = '(' + this.r39_1 + '+' + this.s39_1 + 'i)';
    } else {
      tmp = '(' + this.r39_1 + '' + this.s39_1 + 'i)';
    }
    return tmp;
  }
  a3a() {
    return isNaN_0(this.r39_1) || isNaN_0(this.s39_1);
  }
}
class Companion_76 {
  constructor() {
    this.f3a_1 = true;
  }
  g3a(circles) {
    var tmp;
    switch (circles.k1()) {
      case 0:
        tmp = circles;
        break;
      case 1:
        var circle = circles.l1(0);
        circle.n39_1 = 0.0;
        circle.o39_1 = 0.0;
        tmp = circles;
        break;
      default:
        var placed_circles = ArrayList.q1();
        var _eps = 2.220446049250313E-16;
        var _iterator__ex2g4s = circles.h1();
        $l$loop: while (_iterator__ex2g4s.i1()) {
          var value = _iterator__ex2g4s.j1();
          println('Processing ' + value.toString());
          var radius = value.p39_1;
          var n_circles = placed_circles.k1();
          if (n_circles <= 1) {
            var x = n_circles === 0 ? radius : -radius;
            var circle_0;
            if (false) {
              circle_0 = Circle.q39(x, 0.0, radius);
            } else {
              circle_0 = value;
              circle_0.n39_1 = x;
              circle_0.o39_1 = 0.0;
              circle_0.p39_1 = radius;
            }
            placed_circles.c1(circle_0);
            println('Initial ' + circle_0.toString());
            continue $l$loop;
          }
          var mhd = null;
          var lead_candidate = null;
          var _iterator__ex2g4s_0 = Itertools_instance.h3a(placed_circles, 2).h1();
          while (_iterator__ex2g4s_0.i1()) {
            var c = _iterator__ex2g4s_0.j1();
            var c1 = c.l1(0);
            var c2 = c.l1(1);
            var indexedObject = get_placement_candidates(this, radius, c1, c2, _eps);
            var inductionVariable = 0;
            var last = indexedObject.length;
            $l$loop_1: while (inductionVariable < last) {
              var cand = indexedObject[inductionVariable];
              inductionVariable = inductionVariable + 1 | 0;
              if (!(cand == null)) {
                var other_placed_circles = ArrayList.s(placed_circles);
                if (!(c1 == null)) {
                  other_placed_circles.e3(c1);
                }
                if (!(c2 == null)) {
                  other_placed_circles.e3(c2);
                }
                var overlap = false;
                var _iterator__ex2g4s_1 = other_placed_circles.h1();
                $l$loop_0: while (_iterator__ex2g4s_1.i1()) {
                  var pc = _iterator__ex2g4s_1.j1();
                  var dist = distance(this, pc, cand);
                  if (dist < -_eps) {
                    overlap = true;
                    break $l$loop_0;
                  }
                }
                if (overlap) {
                  continue $l$loop_1;
                }
                var hd = get_hole_degree(this, cand, placed_circles, c1, c2);
                if (mhd == null || hd > mhd) {
                  mhd = hd;
                  lead_candidate = cand;
                }
              }
            }
          }
          if (lead_candidate == null) {
            println('cannot place circle for value ' + value.toString());
            var _iterator__ex2g4s_2 = circles.h1();
            while (_iterator__ex2g4s_2.i1()) {
              var circle_1 = _iterator__ex2g4s_2.j1();
              println('Circle: ' + circle_1.toString());
            }
            lead_candidate = value;
          }
          println('Placing ' + lead_candidate.toString());
          placed_circles.c1(lead_candidate);
        }

        tmp = placed_circles;
        break;
    }
    return tmp;
  }
}
class CirclePackingAlgorithm {
  constructor() {
    this.i3a_1 = 0;
    this.j3a_1 = 0;
    this.k3a_1 = true;
    this.l3a_1 = true;
    this.m3a_1 = false;
    this.n3a_1 = true;
    this.o3a_1 = false;
  }
  p1z() {
    return null;
  }
  iterator(model, root) {
    return model.depthFirstIterator(root);
  }
  startLayout(bounds, model, root, worker) {
  }
  depthFirstLayout(shape, parent, children, sumSizes, horizontalVanishingPoint, verticalVanishingPoint, accessor, worker) {
    var circles = ArrayList.q1();
    var inductionVariable = 0;
    var last = children.length;
    while (inductionVariable < last) {
      var child = children[inductionVariable];
      inductionVariable = inductionVariable + 1 | 0;
      var circle = Circle.z39();
      if (accessor.hasNoChildren(child)) {
        var tmp = circle;
        // Inline function 'kotlin.math.sqrt' call
        var x = accessor.getSize(child) / 3.141592653589793;
        // Inline function 'kotlin.math.max' call
        var b = Math.sqrt(x);
        tmp.p39_1 = Math.max(0.0, b);
      } else {
        var s = accessor.getShape(child);
        if (!(s == null)) {
          if (isInterface(s, Ellipse2D)) {
            var b_0 = s;
            circle.p39_1 = b_0.gm() / 2;
          } else {
            var tmp_0 = circle;
            // Inline function 'kotlin.math.sqrt' call
            var x_0 = accessor.getSize(child) / 3.141592653589793;
            // Inline function 'kotlin.math.max' call
            var b_1 = Math.sqrt(x_0);
            tmp_0.p39_1 = Math.max(0.0, b_1);
          }
        } else {
          var tmp_1 = circle;
          // Inline function 'kotlin.math.sqrt' call
          var x_1 = accessor.getSize(child) / 3.141592653589793;
          // Inline function 'kotlin.math.max' call
          var b_2 = Math.sqrt(x_1);
          tmp_1.p39_1 = Math.max(0.0, b_2);
        }
      }
      circles.c1(circle);
    }
    var sorted = ArrayList.s(circles);
    sort(sorted);
    var placed_circles = Companion_instance_76.g3a(sorted);
    var inductionVariable_0 = 0;
    var last_0 = placed_circles.k1() - 1 | 0;
    if (inductionVariable_0 <= last_0)
      do {
        var i = inductionVariable_0;
        inductionVariable_0 = inductionVariable_0 + 1 | 0;
        var circle_0 = placed_circles.l1(i);
        var t = sorted.l1(i);
        t.n39_1 = circle_0.n39_1;
        t.o39_1 = circle_0.o39_1;
        t.p39_1 = circle_0.p39_1;
      }
       while (inductionVariable_0 <= last_0);
    var boundingCircle_0 = boundingCircle(Companion_instance_76, circles);
    var _iterator__ex2g4s = circles.h1();
    while (_iterator__ex2g4s.i1()) {
      var child_0 = _iterator__ex2g4s.j1();
      child_0.n39_1 = child_0.n39_1 - boundingCircle_0.n39_1;
      child_0.o39_1 = child_0.o39_1 - boundingCircle_0.o39_1;
    }
    boundingCircle_0 = boundingCircle(Companion_instance_76, circles);
    if (shape == null) {
      if (!(boundingCircle_0 == null) && !isNaN_3(boundingCircle_0.p39_1)) {
        var b_3 = boundingCircle_0.b3a();
        accessor.setShape(parent, new Double_0(b_3.g1h(), b_3.h1h(), b_3.gm(), b_3.hm()));
      } else {
        accessor.setShape(parent, null);
      }
    }
    var inductionVariable_1 = 0;
    var last_1 = children.length - 1 | 0;
    if (inductionVariable_1 <= last_1)
      do {
        var i_0 = inductionVariable_1;
        inductionVariable_1 = inductionVariable_1 + 1 | 0;
        var circle_1 = circles.l1(i_0);
        var child_1 = children[i_0];
        if (!isNaN_3(circle_1.p39_1) && circle_1.p39_1 > 0) {
          var b_4 = circle_1.b3a();
          accessor.setShape(child_1, new Double_0(b_4.g1h(), b_4.h1h(), b_4.gm(), b_4.hm()));
        } else {
          accessor.setShape(child_1, null);
        }
      }
       while (inductionVariable_1 <= last_1);
    return false;
  }
  breadthFirstLayout(shape, parent, children, sumSizes, horizontalVanishingPoint, verticalVanishingPoint, accessor, worker) {
    var bounds = shape.i1h();
    var cb = computeBoundingBox(this, children, accessor);
    if (!(cb == null)) {
      var tmp0 = bounds.gm();
      // Inline function 'kotlin.math.min' call
      var b = bounds.hm();
      var size = Math.min(tmp0, b);
      var xs = size / cb.gm();
      var ys = size / cb.hm();
      var inductionVariable = 0;
      var last = children.length;
      while (inductionVariable < last) {
        var node = children[inductionVariable];
        inductionVariable = inductionVariable + 1 | 0;
        var tx = -cb.p1h() * xs + bounds.g1h();
        var ty = -cb.r1h() * ys + bounds.h1h();
        var tmp0_subject = this.j3a_1;
        if (tmp0_subject === 0)
          tx = tx + (bounds.gm() - size) / 2;
        else if (tmp0_subject === 2)
          tx = tx + (bounds.gm() - size);
        var tmp1_subject = this.i3a_1;
        if (tmp1_subject === 0)
          ty = ty + (bounds.hm() - size) / 2;
        else if (tmp1_subject === 3)
          ty = ty + (bounds.hm() - size);
        var at = AffineTransform.m1j(xs, 0.0, 0.0, ys, tx, ty);
        var s = accessor.getShape(node);
        if (!(s == null)) {
          var b1 = s.i1h();
          var x = ensureNotNull(at.c1k(Double_3.z1h(b1.g1h(), b1.h1h(), b1.gm(), b1.hm())));
          var b_0 = x.i1h();
          accessor.setShape(node, new Double_0(b_0.g1h(), b_0.h1h(), b_0.gm(), b_0.hm()));
        } else {
          accessor.setShape(node, null);
        }
      }
    } else {
      var inductionVariable_0 = 0;
      var last_0 = children.length;
      while (inductionVariable_0 < last_0) {
        var node_0 = children[inductionVariable_0];
        inductionVariable_0 = inductionVariable_0 + 1 | 0;
        accessor.setShape(node_0, null);
      }
    }
    return false;
  }
  finishLayout(bounds, model, root) {
  }
  isCompatible(shape) {
    var tmp;
    if (!(shape == null) ? isInterface(shape, Rectangle2D) : false) {
      tmp = true;
    } else {
      tmp = !(shape == null) ? isInterface(shape, Ellipse2D) : false;
    }
    return tmp;
  }
  r2k() {
    return this.k3a_1;
  }
  s2k() {
    return this.l3a_1;
  }
  t2k() {
    return this.m3a_1;
  }
  u2k() {
    return this.n3a_1;
  }
  v2k() {
    return this.o3a_1;
  }
  toString() {
    return 'CirclePackging';
  }
  get properties() {
    return this.p1z();
  }
  get isRenderingLeafLabelsSupported() {
    return this.r2k();
  }
  get isRenderingParentLabelSupported() {
    return this.s2k();
  }
  get isColorParent() {
    return this.t2k();
  }
  get isChildContained() {
    return this.u2k();
  }
  get isSpaceFilling() {
    return this.v2k();
  }
}
class Pair_0 {
  static v3a(ca, cb) {
    var $this = createThis(this);
    init_com_treemap_CircularAlgorithm_Pair($this);
    $this.p3a_1 = ca;
    $this.q3a_1 = cb;
    return $this;
  }
  static w3a(ca, cb, innerSoddyRadius) {
    var $this = createThis(this);
    init_com_treemap_CircularAlgorithm_Pair($this);
    $this.p3a_1 = ca;
    $this.q3a_1 = cb;
    $this.r3a_1 = innerSoddyRadius;
    return $this;
  }
}
class Circle_0 {
  static g3b() {
    var $this = createThis(this);
    init_com_treemap_CircularAlgorithm_Circle($this);
    return $this;
  }
  static f3b(cx, cy, r) {
    var $this = createThis(this);
    init_com_treemap_CircularAlgorithm_Circle($this);
    $this.s3a_1 = cx;
    $this.t3a_1 = cy;
    $this.u3a_1 = r;
    return $this;
  }
  y3a(that, error) {
    var dist = (this.s3a_1 - that.s3a_1) * (this.s3a_1 - that.s3a_1) + (this.t3a_1 - that.t3a_1) * (this.t3a_1 - that.t3a_1);
    return dist < (this.u3a_1 + that.u3a_1) * (this.u3a_1 + that.u3a_1) - error;
  }
  x3a(that) {
    var dist = (this.s3a_1 - that.s3a_1) * (this.s3a_1 - that.s3a_1) + (this.t3a_1 - that.t3a_1) * (this.t3a_1 - that.t3a_1);
    // Inline function 'kotlin.math.sqrt' call
    return Math.sqrt(dist) - that.u3a_1;
  }
  b3a() {
    return Double_3.z1h(this.s3a_1 - this.u3a_1, this.t3a_1 - this.u3a_1, this.u3a_1 * 2.0, this.u3a_1 * 2);
  }
  h3b(c2) {
    var cmp = this.u3a_1 - c2.u3a_1;
    return cmp < 0 ? 1 : cmp > 0 ? -1 : 0;
  }
  d(other) {
    return this.h3b(other instanceof Circle_0 ? other : THROW_CCE());
  }
  toString() {
    return toString_1(getKClassFromExpression(this)) + '[x:' + this.s3a_1 + ',y:' + this.t3a_1 + ',r:' + this.u3a_1 + ']';
  }
}
class Complex_0 {
  constructor(x, y) {
    this.z3a_1 = x;
    this.a3b_1 = y;
  }
  x39() {
    return this.z3a_1;
  }
  y39() {
    return this.a3b_1;
  }
  c3b(that) {
    return new Complex_0(this.z3a_1 + that.z3a_1, this.a3b_1 + that.a3b_1);
  }
  d3b(that) {
    return new Complex_0(this.z3a_1 - that.z3a_1, this.a3b_1 - that.a3b_1);
  }
  b3b(that) {
    return new Complex_0(this.z3a_1 * that.z3a_1 - this.a3b_1 * that.a3b_1, this.z3a_1 * that.a3b_1 + this.a3b_1 * that.z3a_1);
  }
  e3b(that) {
    return new Complex_0((this.z3a_1 * that.z3a_1 + this.a3b_1 * that.a3b_1) / (that.z3a_1 * that.z3a_1 + that.a3b_1 * that.a3b_1), (this.a3b_1 * that.z3a_1 - this.z3a_1 * that.a3b_1) / (that.z3a_1 * that.z3a_1 + that.a3b_1 * that.a3b_1));
  }
  d3a() {
    var tmp0 = this.a3b_1;
    // Inline function 'kotlin.math.atan2' call
    var x = this.z3a_1;
    return Math.atan2(tmp0, x);
  }
  e3a() {
    // Inline function 'kotlin.math.sqrt' call
    var x = this.z3a_1 * this.z3a_1 + this.a3b_1 * this.a3b_1;
    return Math.sqrt(x);
  }
  cw() {
    // Inline function 'kotlin.math.sqrt' call
    var x = this.e3a();
    var r = Math.sqrt(x);
    var theta = this.d3a() / 2;
    // Inline function 'kotlin.math.cos' call
    var tmp = r * Math.cos(theta);
    // Inline function 'kotlin.math.sin' call
    var tmp$ret$2 = Math.sin(theta);
    return new Complex_0(tmp, r * tmp$ret$2);
  }
  equals(o) {
    if (o instanceof Complex_0) {
      var that = o;
      return that.z3a_1 === this.z3a_1 && that.a3b_1 === this.a3b_1;
    }
    return false;
  }
  hashCode() {
    var bits = doubleToLongBits(this.z3a_1);
    var tmp = bits;
    // Inline function 'kotlin.Long.times' call
    var this_0 = doubleToLongBits(this.a3b_1);
    bits = tmp ^ multiply_0(this_0, fromInt_0(31));
    return convertToInt(bits) ^ convertToInt(shiftRight(bits, 32));
  }
  toString() {
    var tmp;
    if (this.a3b_1 >= 0) {
      tmp = '(' + this.z3a_1 + '+' + this.a3b_1 + 'i)';
    } else {
      tmp = '(' + this.z3a_1 + '' + this.a3b_1 + 'i)';
    }
    return tmp;
  }
  a3a() {
    return isNaN_3(this.z3a_1) || isNaN_3(this.a3b_1);
  }
}
class Companion_77 {}
class CircularAlgorithm extends AbstractAlgorithm {
  constructor() {
    super();
    this.i3b_1 = 0;
    this.j3b_1 = 0;
  }
  p1z() {
    return null;
  }
  iterator(model, root) {
    return model.depthFirstIterator(root);
  }
  startLayout(bounds, model, root, worker) {
  }
  depthFirstLayout(shape, parent, children, sumSizes, horizontalVanishingPoint, verticalVanishingPoint, accessor, worker) {
    var equalSize = true;
    var lastRadius = null;
    var circles = ArrayList.q1();
    var inductionVariable = 0;
    var last = children.length;
    while (inductionVariable < last) {
      var child = children[inductionVariable];
      inductionVariable = inductionVariable + 1 | 0;
      var circle = Circle_0.g3b();
      if (accessor.hasNoChildren(child)) {
        var tmp = circle;
        // Inline function 'kotlin.math.sqrt' call
        var x = accessor.getSize(child) / 3.141592653589793;
        // Inline function 'kotlin.math.max' call
        var b = Math.sqrt(x);
        tmp.u3a_1 = Math.max(0.0, b);
      } else {
        var s = ensureNotNull(accessor.getShape(child));
        if (!(s == null)) {
          if (isInterface(s, Ellipse2D)) {
            var b_0 = s;
            circle.u3a_1 = b_0.gm() / 2;
          } else {
            var tmp_0 = circle;
            // Inline function 'kotlin.math.sqrt' call
            var x_0 = accessor.getSize(child) / 3.141592653589793;
            // Inline function 'kotlin.math.max' call
            var b_1 = Math.sqrt(x_0);
            tmp_0.u3a_1 = Math.max(0.0, b_1);
          }
        } else {
          var tmp_1 = circle;
          // Inline function 'kotlin.math.sqrt' call
          var x_1 = accessor.getSize(child) / 3.141592653589793;
          // Inline function 'kotlin.math.max' call
          var b_2 = Math.sqrt(x_1);
          tmp_1.u3a_1 = Math.max(0.0, b_2);
        }
      }
      if (equalSize) {
        if (lastRadius == null) {
          lastRadius = circle.u3a_1;
        } else {
          if (!(lastRadius === circle.u3a_1)) {
            equalSize = false;
          }
        }
      }
      circles.c1(circle);
    }
    if (equalSize && circles.k1() > 1 && circles.k1() <= EqualCirclesInCircle_getInstance().k3b_1.length) {
      var coordinates = EqualCirclesInCircle_getInstance().k3b_1[circles.k1() - 1 | 0];
      var radii = EqualCirclesInCircle_getInstance().l3b_1[circles.k1() - 1 | 0];
      var scale = ensureNotNull(lastRadius);
      var inductionVariable_0 = 0;
      var last_0 = circles.k1() - 1 | 0;
      if (inductionVariable_0 <= last_0)
        do {
          var i = inductionVariable_0;
          inductionVariable_0 = inductionVariable_0 + 1 | 0;
          var circle_0 = circles.l1(i);
          circle_0.s3a_1 = coordinates[imul_0(i, 2)] / radii * scale;
          circle_0.t3a_1 = coordinates[imul_0(i, 2) + 1 | 0] / radii * scale;
        }
         while (inductionVariable_0 <= last_0);
    } else {
      pairPack(Companion_instance_77, circles);
    }
    var boundingCircle = boundingCircle_0(Companion_instance_77, circles);
    var _iterator__ex2g4s = circles.h1();
    while (_iterator__ex2g4s.i1()) {
      var child_0 = _iterator__ex2g4s.j1();
      child_0.s3a_1 = child_0.s3a_1 - boundingCircle.s3a_1;
      child_0.t3a_1 = child_0.t3a_1 - boundingCircle.t3a_1;
    }
    boundingCircle = boundingCircle_0(Companion_instance_77, circles);
    if (shape == null) {
      if (!(boundingCircle == null) && !isNaN_3(boundingCircle.u3a_1)) {
        var b_3 = boundingCircle.b3a();
        accessor.setShape(parent, new Double_0(b_3.g1h(), b_3.h1h(), b_3.gm(), b_3.hm()));
      } else {
        accessor.setShape(parent, null);
      }
    }
    var inductionVariable_1 = 0;
    var last_1 = children.length - 1 | 0;
    if (inductionVariable_1 <= last_1)
      do {
        var i_0 = inductionVariable_1;
        inductionVariable_1 = inductionVariable_1 + 1 | 0;
        var circle_1 = circles.l1(i_0);
        var child_1 = children[i_0];
        if (!isNaN_3(circle_1.u3a_1) && circle_1.u3a_1 > 0) {
          var b_4 = circle_1.b3a();
          accessor.setShape(child_1, new Double_0(b_4.g1h(), b_4.h1h(), b_4.gm(), b_4.hm()));
        } else {
          accessor.setShape(child_1, null);
        }
      }
       while (inductionVariable_1 <= last_1);
    return false;
  }
  breadthFirstLayout(shape, parent, children, sumSizes, horizontalVanishingPoint, verticalVanishingPoint, accessor, worker) {
    var bounds = shape.i1h();
    var cb = computeBoundingBox_0(this, children, accessor);
    if (!(cb == null)) {
      var tmp0 = bounds.gm();
      // Inline function 'kotlin.math.min' call
      var b = bounds.hm();
      var size = Math.min(tmp0, b);
      var xs = size / cb.gm();
      var ys = size / cb.hm();
      var inductionVariable = 0;
      var last = children.length;
      while (inductionVariable < last) {
        var node = children[inductionVariable];
        inductionVariable = inductionVariable + 1 | 0;
        var tx = -cb.p1h() * xs + bounds.g1h();
        var ty = -cb.r1h() * ys + bounds.h1h();
        var tmp0_subject = this.j3b_1;
        if (tmp0_subject === 0)
          tx = tx + (bounds.gm() - size) / 2;
        else if (tmp0_subject === 2)
          tx = tx + (bounds.gm() - size);
        var tmp1_subject = this.i3b_1;
        if (tmp1_subject === 0)
          ty = ty + (bounds.hm() - size) / 2;
        else if (tmp1_subject === 3)
          ty = ty + (bounds.hm() - size);
        var at = AffineTransform.m1j(xs, 0.0, 0.0, ys, tx, ty);
        var s = accessor.getShape(node);
        if (!(s == null)) {
          var b1 = s.i1h();
          var x = ensureNotNull(at.c1k(b1));
          var b_0 = x.i1h();
          accessor.setShape(node, new Double_0(b_0.g1h(), b_0.h1h(), b_0.gm(), b_0.hm()));
        } else {
          accessor.setShape(node, null);
        }
      }
    } else {
      var inductionVariable_0 = 0;
      var last_0 = children.length;
      while (inductionVariable_0 < last_0) {
        var node_0 = children[inductionVariable_0];
        inductionVariable_0 = inductionVariable_0 + 1 | 0;
        accessor.setShape(node_0, null);
      }
    }
    return false;
  }
  finishLayout(bounds, model, root) {
  }
  isCompatible(shape) {
    var tmp;
    if (!(shape == null) ? isInterface(shape, Rectangle2D) : false) {
      tmp = true;
    } else {
      tmp = !(shape == null) ? isInterface(shape, Ellipse2D) : false;
    }
    return tmp;
  }
  r2k() {
    return true;
  }
  s2k() {
    return true;
  }
  t2k() {
    return true;
  }
  u2k() {
    return false;
  }
  v2k() {
    return false;
  }
  b39() {
    return 'Circular';
  }
  toString() {
    return this.b39();
  }
}
class AscendingTreeMapNodeComparator {
  constructor(model, universal) {
    this.m3b_1 = model;
    this.n3b_1 = universal;
  }
  i2m(a, b) {
    var column = this.m3b_1.settings.colorColumn;
    return this.n3b_1.compare(this.m3b_1.getAggregateValue(a, column), this.m3b_1.getAggregateValue(b, column));
  }
  compare(a, b) {
    var tmp = (a == null ? true : !(a == null)) ? a : THROW_CCE();
    return this.i2m(tmp, (b == null ? true : !(b == null)) ? b : THROW_CCE());
  }
}
class DescendingTreeMapNodeComparator {
  constructor(model, universal) {
    this.o3b_1 = model;
    this.p3b_1 = universal;
  }
  i2m(a, b) {
    var column = this.o3b_1.settings.colorColumn;
    return this.p3b_1.compare(this.o3b_1.getAggregateValue(b, column), this.o3b_1.getAggregateValue(a, column));
  }
  compare(a, b) {
    var tmp = (a == null ? true : !(a == null)) ? a : THROW_CCE();
    return this.i2m(tmp, (b == null ? true : !(b == null)) ? b : THROW_CCE());
  }
}
class Companion_78 {
  q3b(model, nodes, sortOrder) {
    // Inline function 'kotlin.collections.copyOf' call
    // Inline function 'kotlin.js.asDynamic' call
    var copy = nodes.slice();
    var universal = new UniversalComparator();
    var comparator;
    var tmp;
    switch (sortOrder.g3_1) {
      case 0:
        tmp = new AscendingTreeMapNodeComparator(model, universal);
        break;
      case 1:
        tmp = new DescendingTreeMapNodeComparator(model, universal);
        break;
      default:
        noWhenBranchMatchedException();
        break;
    }
    comparator = tmp;
    sortedWith(copy, comparator);
    return copy;
  }
}
class Ordering {}
class ColorOrdering {
  b2z(model, nodes, sortOrder) {
    return Companion_instance_78.q3b(model, nodes, sortOrder);
  }
  toString() {
    return 'By color';
  }
}
class SurroundLabeling extends AbstractLabeling {
  constructor() {
    super();
    this.x3b_1 = null;
    this.y3b_1 = 0.0;
    this.z3b_1 = 0.0;
  }
  e2l(model) {
    var font = ensureNotNull(model).settings.getDefaultColumnSettings().getHeaderFont();
    return numberToDouble(!(font == null) ? getFontSize(font) + 2 : 0);
  }
  f2l(model) {
    return 3.0;
  }
  d2l(model, shape, node) {
    var tmp;
    var tmp_0;
    if (!ensureNotNull(model).isRoot(node)) {
      var tmp_1 = model.getShape(node);
      tmp_0 = !(tmp_1 == null) ? isInterface(tmp_1, Rectangle2D) : false;
    } else {
      tmp_0 = false;
    }
    if (tmp_0) {
      var rectangle = (!(shape == null) ? isInterface(shape, Rectangle2D) : false) ? shape : THROW_CCE();
      var preferredHeight = this.a3c(model, null, rectangle, node);
      var allocatedHeight = computeAllocatedHeight(this, preferredHeight, rectangle);
      var thickness = computeThickness(this, model, rectangle, node);
      var width = rectangle.gm() - 2 * thickness;
      var height = rectangle.hm() - (thickness + allocatedHeight);
      var tmp_2;
      if (width > 0 && height > 0) {
        tmp_2 = Double_3.z1h(rectangle.g1h() + thickness, rectangle.h1h() + allocatedHeight, width, height);
      } else {
        tmp_2 = rectangle;
      }
      tmp = tmp_2;
    } else {
      tmp = shape;
    }
    return tmp;
  }
  a3c(model, g2, rectangle, node) {
    var height = 0.0;
    var columnSettings = model.settings.getColumnSettings(model.getGroupByColumn(node));
    var headerFont = columnSettings.getHeaderFont();
    if (!(headerFont == null) && !(model.getLabelName(node) == null)) {
      try {
        if (!(rectangle == null) && rectangle.hm() > 3) {
          var headerRenderer = DefaultTreeMapHeaderRenderer.l36();
          headerRenderer.setFont(headerFont);
          var elabel = headerRenderer.q3h(model, node, Dimension.fm(numberToInt(rectangle.gm()), numberToInt(rectangle.hm())));
          var pf = ensureNotNull(this.x3b_1).g3u(elabel, g2, numberToInt(rectangle.gm()), numberToInt(rectangle.hm()));
          return pf.t2l();
        }
      } catch ($p) {
        if ($p instanceof NullPointerException) {
          var e = $p;
          printStackTrace(e);
          height = 0.0;
        } else {
          throw $p;
        }
      }
    } else {
      height = 0.0;
    }
    return height;
  }
  v2l(g2, bounds, node, view, pass, passes) {
    if (pass === 0) {
      var model = ensureNotNull(view.h2l());
      var column = model.getGroupByColumn(node);
      var columnSettings = model.settings.getColumnSettings(column);
      var headerFont = columnSettings.getHeaderFont();
      if (!(headerFont == null) && !(model.getLabelName(node) == null)) {
        var shape = ensureNotNull(model.getShape(node));
        var rectangle = shape.i1h();
        var position;
        if (isInterface(shape, Arc2D)) {
          position = Companion_instance_67.b2l(shape);
        } else {
          position = null;
        }
        var preferedHeight = this.a3c(model, g2, rectangle, node);
        var height = computeAllocatedHeight(this, preferedHeight, rectangle);
        if (!(rectangle == null) || (!(position == null) && height > 0)) {
          var screenRectangle = view.y37(rectangle);
          var fontSize = getFontSize(headerFont) * view.s2l();
          var rect;
          var elabel;
          if (fontSize >= 5.0) {
            var foreground = this.u3b(node, model);
            elabel = ensureNotNull(view.t37()).q3h(model, node, Dimension.fm(bounds.c1w_1, bounds.d1w_1));
            var pf = g2.o2l(elabel, bounds.c1w_1, bounds.d1w_1);
            var insets = ensureNotNull(columnSettings.getHeaderInsets());
            elabel.setInsets(numberToInt(insets.t1x_1 * view.s2l()), numberToInt(insets.u1x_1 * view.s2l()), numberToInt(insets.v1x_1 * view.s2l()), numberToInt(insets.w1x_1 * view.s2l()));
            var background = this.w3b(node, model);
            var derivedFont;
            var tmp;
            if (!(fontSize === getFontSize(headerFont))) {
              tmp = headerFont.q29(fontSize);
            } else {
              tmp = headerFont;
            }
            derivedFont = tmp;
            elabel.setFont(derivedFont);
            elabel.setForeground(ensureNotNull(foreground));
            elabel.setBackground(ensureNotNull(background));
            var size = pf.q2l();
            if (!(position == null)) {
              var tmp0 = size.gm();
              // Inline function 'kotlin.math.min' call
              var b = screenRectangle.gm();
              var w = Math.min(tmp0, b);
              if (isInterface(shape, Arc2D)) {
                var arc = shape;
                var startPoint = arc.a1l();
                var endPoint = arc.b1l();
                var s = Double_2.c1l(view.z37(startPoint.g1h()), view.a38(startPoint.h1h()));
                var e = Double_2.c1l(view.z37(endPoint.g1h()), view.a38(endPoint.h1h()));
                var tmp0_0 = s.t1v(e);
                // Inline function 'kotlin.math.min' call
                var b_0 = w;
                w = Math.min(tmp0_0, b_0);
              }
              var tmp0_1 = size.hm();
              // Inline function 'kotlin.math.min' call
              var b_1 = screenRectangle.hm();
              var h = Math.min(tmp0_1, b_1);
              var x = view.z37(position.g1h()) - w / 2;
              var y = view.a38(position.h1h()) - h / 2;
              rect = Double_3.z1h(x, y, w, h).u1h(bounds);
            } else {
              var nestedShapeWorld = model.getNestedShape(node);
              var nestedShapeWorldBounds = ensureNotNull(nestedShapeWorld).i1h();
              var preferredHeight = this.a3c(model, null, rectangle, node);
              var allocatedHeight = computeAllocatedHeight(this, preferredHeight, rectangle);
              var thickness = computeThickness(this, model, rectangle, node);
              rect = view.y37(Double_3.z1h(nestedShapeWorldBounds.g1h() + thickness, rectangle.h1h(), nestedShapeWorldBounds.gm() - 2 * thickness, allocatedHeight));
            }
          } else {
            elabel = null;
            var nestedShapeWorld_0 = model.getNestedShape(node);
            var nestedShapeWorldBounds_0 = ensureNotNull(nestedShapeWorld_0).i1h();
            var preferredHeight_0 = this.a3c(model, null, rectangle, node);
            var allocatedHeight_0 = computeAllocatedHeight(this, preferredHeight_0, rectangle);
            var thickness_0 = computeThickness(this, model, rectangle, node);
            rect = view.y37(Double_3.z1h(nestedShapeWorldBounds_0.g1h() + thickness_0, rectangle.h1h(), nestedShapeWorldBounds_0.gm() - 2 * thickness_0, allocatedHeight_0));
          }
          if (isInterface(shape, Rectangle2D)) {
            var backgroundColor = this.v3b(node, model);
            g2.l2m(backgroundColor);
            g2.w38(rect.g1h(), rect.h1h(), rect.gm(), rect.hm());
          }
          if (!(elabel == null) && rect.gm() > 8) {
            var b_2 = rect.i1h();
            elabel.setDesiredWidth(numberToInt(b_2.gm() - elabel.getInsetLeft() - elabel.getInsetRight()));
            elabel.setDesiredHeight(numberToInt(b_2.hm() - elabel.getInsetTop() - elabel.getInsetBottom()));
            var font = ensureNotNull(elabel.getFont());
            var pf_0 = g2.o2l(elabel, numberToInt(b_2.gm()), numberToInt(b_2.hm()));
            var shrink = true;
            var expand = false;
            var tmp_0;
            if (!(columnSettings.getHeaderRendering() === Rendering_WordWrap_getInstance())) {
              var preferredSize = pf_0.q2l();
              var scaleY = (b_2.hm() - elabel.getInsetTop() - elabel.getInsetBottom()) / (preferredSize.hm() - elabel.getInsetTop() - elabel.getInsetBottom());
              tmp_0 = getFontSize(headerFont) * view.s2l() * scaleY * 1;
            } else {
              tmp_0 = g2.p2l(elabel, pf_0, font, b_2, 0.99, expand);
            }
            fontSize = tmp_0;
            if (!shrink) {
              var tmp0_2 = getFontSize(font);
              // Inline function 'kotlin.math.max' call
              var b_3 = fontSize;
              fontSize = Math.max(tmp0_2, b_3);
            }
            if (!expand) {
              var tmp0_3 = getFontSize(font);
              // Inline function 'kotlin.math.min' call
              var b_4 = fontSize;
              fontSize = Math.min(tmp0_3, b_4);
            }
            var derivedFont_0;
            var tmp_1;
            if (!(fontSize === getFontSize(ensureNotNull(elabel.getFont())))) {
              tmp_1 = ensureNotNull(elabel.getFont()).q29(fontSize);
            } else {
              tmp_1 = ensureNotNull(elabel.getFont());
            }
            derivedFont_0 = tmp_1;
            elabel.setFont(derivedFont_0);
            g2.u2l(elabel, numberToInt(b_2.g1h()), numberToInt(b_2.h1h()), numberToInt(b_2.gm()), numberToInt(b_2.hm()));
          }
        }
      }
    }
  }
  v3b(node, model) {
    return model.settings.getColumnSettings(model.getGroupByColumn(node)).getHeaderBackground();
  }
  u3b(node, model) {
    return model.settings.getColumnSettings(model.getGroupByColumn(node)).getHeaderForeground();
  }
  w3b(node, model) {
    return model.settings.getColumnSettings(model.getGroupByColumn(node)).getHeaderEffectColor();
  }
  toString() {
    return 'Surround';
  }
}
class ColoredSurroundLabeling extends SurroundLabeling {
  u3b(node, model) {
    var foreground = model.settings.getColumnSettings(model.getGroupByColumn(node)).getHeaderForeground();
    var background = this.v3b(node, model);
    if (!(background == null)) {
      foreground = ensureNotNull(model.settings.getColumnSettings(model.getGroupByColumn(node)).getLabelingContrastEnhancement()).z1x(ensureNotNull(foreground), background);
    }
    return foreground;
  }
  w3b(node, model) {
    return model.settings.getColumnSettings(model.getGroupByColumn(node)).getHeaderEffectColor();
  }
  v3b(node, model) {
    return model.getColor(node);
  }
  toString() {
    return 'Surround (Colored)';
  }
}
class CombinationGenerator {
  b3c(n, r) {
    var rfact = 1;
    var nfact = 1;
    var nrfact = 1;
    var temp1 = n - r | 0;
    var temp2 = r;
    if (r > (n - r | 0)) {
      temp1 = r;
      temp2 = n - r | 0;
    }
    var inductionVariable = 1;
    if (inductionVariable <= n)
      do {
        var i = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        if (i <= temp2) {
          rfact = imul_0(rfact, i);
          nrfact = imul_0(nrfact, i);
        } else if (i <= temp1) {
          nrfact = imul_0(nrfact, i);
        }
        nfact = imul_0(nfact, i);
      }
       while (!(i === n));
    return nfact / imul_0(rfact, nrfact);
  }
  c3c(temp, n, r) {
    var m = r;
    var maxVal = n;
    while (temp[m - 1 | 0] === maxVal) {
      m = m - 1 | 0;
      maxVal = maxVal - 1 | 0;
    }
    var _index_0__fvwizt = m - 1 | 0;
    temp[_index_0__fvwizt] = temp[_index_0__fvwizt] + 1 | 0;
    var inductionVariable = m;
    if (inductionVariable < r)
      do {
        var j = inductionVariable;
        inductionVariable = inductionVariable + 1 | 0;
        temp[j] = temp[j - 1 | 0] + 1 | 0;
      }
       while (inductionVariable < r);
    return temp;
  }
}
class CountAggregation {
  p2y(values) {
    var count = 0;
    var inductionVariable = 0;
    var last = values.length;
    while (inductionVariable < last) {
      var value = values[inductionVariable];
      inductionVariable = inductionVariable + 1 | 0;
      if (isFinite_0(value)) {
        count = count + 1 | 0;
      }
    }
    return count;
  }
  o2z() {
    return false;
  }
  toString() {
    return 'Count';
  }
}
class Cushion {
  static j30(model, left, right, width, top, bottom, height) {
    var $this = createThis(this);
    init_com_treemap_Cushion($this);
    var h4 = 4 * model.settings.getLightSourceHeight();
    var wf;
    var tmp;
    if (width <= 0) {
      tmp = 0.0;
    } else {
      tmp = h4 / width;
    }
    wf = tmp;
    $this.u2z_1[2] = wf * (right + left | 0);
    $this.u2z_1[0] = -wf;
    var hf;
    var tmp_0;
    if (height <= 0) {
      tmp_0 = 0.0;
    } else {
      tmp_0 = h4 / height;
    }
    hf = tmp_0;
    $this.u2z_1[3] = +(hf * (bottom + top | 0));
    $this.u2z_1[1] = -hf;
    return $this;
  }
  static i30(master, model, left, right, width, top, bottom, height) {
    var $this = createThis(this);
    init_com_treemap_Cushion($this);
    if (!(master == null)) {
      var h4 = 4 * ensureNotNull(model).settings.getLightSourceHeight();
      var wf;
      var tmp;
      if (width <= 0) {
        tmp = 0.0;
      } else {
        tmp = h4 / width;
      }
      wf = tmp;
      $this.u2z_1[2] = master.u2z_1[2] + wf * (right + left | 0);
      $this.u2z_1[0] = master.u2z_1[0] - wf;
      var hf;
      var tmp_0;
      if (height <= 0) {
        tmp_0 = 0.0;
      } else {
        tmp_0 = h4 / height;
      }
      hf = tmp_0;
      $this.u2z_1[3] = master.u2z_1[3] + hf * (bottom + top | 0);
      $this.u2z_1[1] = master.u2z_1[1] - hf;
    }
    return $this;
  }
  v2z(model, color, x, y, width, height, raster) {
    if (!(color == null)) {
      var bottom = y + height | 0;
      var right = x + width | 0;
      // Inline function 'kotlin.UByte.toDouble' call
      // Inline function 'kotlin.UByte.toInt' call
      var this_0 = getURed(color);
      var tmp$ret$0 = _UByte___get_data__impl__jof9qr(this_0) & 255;
      var colR = uintToDouble(tmp$ret$0);
      // Inline function 'kotlin.UByte.toDouble' call
      // Inline function 'kotlin.UByte.toInt' call
      var this_1 = getUGreen(color);
      var tmp$ret$2 = _UByte___get_data__impl__jof9qr(this_1) & 255;
      var colG = uintToDouble(tmp$ret$2);
      // Inline function 'kotlin.UByte.toDouble' call
      // Inline function 'kotlin.UByte.toInt' call
      var this_2 = getUBlue(color);
      var tmp$ret$4 = _UByte___get_data__impl__jof9qr(this_2) & 255;
      var colB = uintToDouble(tmp$ret$4);
      var ia = ensureNotNull(model).settings.getLightSourceAmbient();
      var is = 1 - model.settings.getLightSourceAmbient();
      var lx = model.normalizedLightSourceX;
      var ly = model.normalizedLightSourceY;
      var lz = model.normalizedLightSourceZ;
      var s0 = 2 * this.u2z_1[0];
      var s1 = 2 * this.u2z_1[1];
      var s2 = this.u2z_1[2];
      var s3 = this.u2z_1[3];
      if (!raster.d2a()) {
        var base = 0;
        var data = new Int32Array(imul_0(width, height));
        var inductionVariable = y;
        if (inductionVariable < bottom)
          do {
            var iy = inductionVariable;
            inductionVariable = inductionVariable + 1 | 0;
            var ny = -(s1 * (iy + 0.5) + s3);
            var inductionVariable_0 = x;
            if (inductionVariable_0 < right)
              do {
                var ix = inductionVariable_0;
                inductionVariable_0 = inductionVariable_0 + 1 | 0;
                var nx = -(s0 * (ix + 0.5) + s2);
                var tmp = nx * lx + ny * ly + lz;
                // Inline function 'kotlin.math.sqrt' call
                var x_0 = nx * nx + ny * ny + 1.0;
                // Inline function 'kotlin.math.min' call
                var b = tmp / Math.sqrt(x_0);
                var cosa = Math.min(1.0, b);
                // Inline function 'kotlin.math.max' call
                var b_0 = is * cosa + ia;
                // Inline function 'kotlin.math.min' call
                var b_1 = Math.max(0.0, b_0);
                var pixel = Math.min(1.0, b_1);
                var red = numberToInt(colR * pixel);
                var green = numberToInt(colG * pixel);
                var blue = numberToInt(colB * pixel);
                // Inline function 'kotlin.UByte.toInt' call
                var this_3 = getUAlpha(color);
                var alpha = _UByte___get_data__impl__jof9qr(this_3) & 255;
                data[base] = (((alpha << 24) + (red << 16) | 0) + (green << 8) | 0) + blue | 0;
                base = base + 1 | 0;
              }
               while (inductionVariable_0 < right);
          }
           while (inductionVariable < bottom);
        raster.c2a(0, 0, width, height, data);
      } else {
        var base_0 = 0;
        var data_0 = new Int32Array(imul_0(width, height) << 2);
        var inductionVariable_1 = y;
        if (inductionVariable_1 < bottom)
          do {
            var iy_0 = inductionVariable_1;
            inductionVariable_1 = inductionVariable_1 + 1 | 0;
            var ny_0 = -(s1 * (iy_0 + 0.5) + s3);
            var inductionVariable_2 = x;
            if (inductionVariable_2 < right)
              do {
                var ix_0 = inductionVariable_2;
                inductionVariable_2 = inductionVariable_2 + 1 | 0;
                var nx_0 = -(s0 * (ix_0 + 0.5) + s2);
                var tmp_0 = nx_0 * lx + ny_0 * ly + lz;
                // Inline function 'kotlin.math.sqrt' call
                var x_1 = nx_0 * nx_0 + ny_0 * ny_0 + 1.0;
                // Inline function 'kotlin.math.min' call
                var b_2 = tmp_0 / Math.sqrt(x_1);
                var cosa_0 = Math.min(1.0, b_2);
                // Inline function 'kotlin.math.max' call
                var b_3 = is * cosa_0 + ia;
                // Inline function 'kotlin.math.min' call
                var b_4 = Math.max(0.0, b_3);
                var pixel_0 = Math.min(1.0, b_4);
                var red_0 = numberToInt(colR * pixel_0);
                var green_0 = numberToInt(colG * pixel_0);
                var blue_0 = numberToInt(colB * pixel_0);
                // Inline function 'kotlin.UByte.toInt' call
                var this_4 = getUAlpha(color);
                var alpha_0 = _UByte___get_data__impl__jof9qr(this_4) & 255;
                var _unary__edvuaz = base_0;
                base_0 = _unary__edvuaz + 1 | 0;
                data_0[_unary__edvuaz] = red_0;
                var _unary__edvuaz_0 = base_0;
                base_0 = _unary__edvuaz_0 + 1 | 0;
                data_0[_unary__edvuaz_0] = green_0;
                var _unary__edvuaz_1 = base_0;
                base_0 = _unary__edvuaz_1 + 1 | 0;
                data_0[_unary__edvuaz_1] = blue_0;
                var _unary__edvuaz_2 = base_0;
                base_0 = _unary__edvuaz_2 + 1 | 0;
                data_0[_unary__edvuaz_2] = alpha_0;
              }
               while (inductionVariable_2 < right);
          }
           while (inductionVariable_1 < bottom);
        raster.c2a(0, 0, width, height, data_0);
      }
    }
  }
  m30(model, color, x, y, width, height) {
    var tmp;
    if (!(color == null)) {
      var bottom = y + height | 0;
      var right = x + width | 0;
      // Inline function 'kotlin.UByte.toDouble' call
      // Inline function 'kotlin.UByte.toInt' call
      var this_0 = getURed(color);
      var tmp$ret$0 = _UByte___get_data__impl__jof9qr(this_0) & 255;
      var colR = uintToDouble(tmp$ret$0);
      // Inline function 'kotlin.UByte.toDouble' call
      // Inline function 'kotlin.UByte.toInt' call
      var this_1 = getUGreen(color);
      var tmp$ret$2 = _UByte___get_data__impl__jof9qr(this_1) & 255;
      var colG = uintToDouble(tmp$ret$2);
      // Inline function 'kotlin.UByte.toDouble' call
      // Inline function 'kotlin.UByte.toInt' call
      var this_2 = getUBlue(color);
      var tmp$ret$4 = _UByte___get_data__impl__jof9qr(this_2) & 255;
      var colB = uintToDouble(tmp$ret$4);
      var ia = model.settings.getLightSourceAmbient();
      var is = 1 - model.settings.getLightSourceAmbient();
      var lx = model.normalizedLightSourceX;
      var ly = model.normalizedLightSourceY;
      var lz = model.normalizedLightSourceZ;
      var s0 = 2 * this.u2z_1[0];
      var s1 = 2 * this.u2z_1[1];
      var s2 = this.u2z_1[2];
      var s3 = this.u2z_1[3];
      var iy = (y + bottom | 0) / 2 | 0;
      var ix = (x + right | 0) / 2 | 0;
      var nx = -(s0 * (ix + 0.5) + s2);
      var ny = -(s1 * (iy + 0.5) + s3);
      var tmp_0 = nx * lx + ny * ly + lz;
      // Inline function 'kotlin.math.sqrt' call
      var x_0 = nx * nx + ny * ny + 1.0;
      // Inline function 'kotlin.math.min' call
      var b = tmp_0 / Math.sqrt(x_0);
      var cosa = Math.min(1.0, b);
      // Inline function 'kotlin.math.max' call
      var b_0 = is * cosa + ia;
      // Inline function 'kotlin.math.min' call
      var b_1 = Math.max(0.0, b_0);
      var pixel = Math.min(1.0, b_1);
      var red = numberToInt(colR * pixel);
      var green = numberToInt(colG * pixel);
      var blue = numberToInt(colB * pixel);
      tmp = colorOf_1(red, green, blue);
    } else {
      tmp = null;
    }
    return tmp;
  }
}
class CushionRendering extends AbstractRendering {
  constructor() {
    super();
    this.h3c_1 = false;
  }
  paintNode(g, view, node, pass, bounds, shape) {
    var completed = true;
    var model = ensureNotNull(view.h2l());
    if (pass === 0) {
      if (!model.filter.qk(node) && !model.search.qk(node)) {
        if (shape instanceof TextShape) {
          var textShape = shape;
          var cushionColor = model.getCushionColor(node);
          var color = !(cushionColor == null) ? cushionColor : model.getColor(node);
          if (!(color == null)) {
            g.l2m(color);
            if (textShape.m1x()) {
              g.m2m(shape);
            } else {
              g.l3c(ensureNotNull(textShape.l1x_1));
              var bounds2D = textShape.i1h();
              g.m3c(textShape.j1x_1, bounds2D.g1h(), bounds2D.t1h());
            }
          }
        } else {
          var image;
          var tmp;
          var tmp_0;
          var tmp_1;
          if (isInterface(shape, Rectangle2D)) {
            tmp_1 = bounds.gm() > 4;
          } else {
            tmp_1 = false;
          }
          if (tmp_1) {
            tmp_0 = bounds.hm() > 4;
          } else {
            tmp_0 = false;
          }
          if (tmp_0) {
            tmp = true;
          } else {
            var tmp_2;
            var tmp_3;
            if (!isInterface(shape, Rectangle2D)) {
              tmp_3 = bounds.gm() > 6;
            } else {
              tmp_3 = false;
            }
            if (tmp_3) {
              tmp_2 = bounds.hm() > 6;
            } else {
              tmp_2 = false;
            }
            tmp = tmp_2;
          }
          var cushionEnabled = tmp;
          var tmp_4;
          if (cushionEnabled) {
            var tmp_5;
            try {
              tmp_5 = model.getCushionImage(node);
            } catch ($p) {
              var tmp_6;
              if ($p instanceof Error) {
                var e = $p;
                printStackTrace(e);
                tmp_6 = null;
              } else {
                throw $p;
              }
              tmp_5 = tmp_6;
            }
            tmp_4 = tmp_5;
          } else {
            tmp_4 = null;
          }
          image = tmp_4;
          if (!(image == null)) {
            completed = paintCushion(this, g, view, image, bounds, shape);
          } else {
            var cushionColor_0 = model.getCushionColor(node);
            var color_0 = !(cushionColor_0 == null) ? cushionColor_0 : model.getColor(node);
            if (!(color_0 == null)) {
              g.l2m(color_0);
              g.m2m(shape);
            }
          }
        }
      } else {
        var color_1 = view.k2m();
        if (!(color_1 == null)) {
          g.l2m(color_1);
          g.m2m(shape);
        }
      }
    } else if (pass === 1) {
      if (isInterface(shape, Rectangle2D)) {
        if (!model.filter.qk(node) && !model.search.qk(node)) {
          var bottom = shape;
          var tmp_7 = this.getRenderedShape(view, model, node, shape);
          var top = isInterface(tmp_7, Rectangle2D) ? tmp_7 : THROW_CCE();
          var image_0;
          var cushionEnabled_0 = bounds.gm() > 4 && bounds.hm() > 4;
          var tmp_8;
          if (cushionEnabled_0) {
            var tmp_9;
            try {
              tmp_9 = model.getCushionImage(node);
            } catch ($p) {
              var tmp_10;
              if ($p instanceof Error) {
                var e_0 = $p;
                printStackTrace(e_0);
                tmp_10 = null;
              } else {
                throw $p;
              }
              tmp_9 = tmp_10;
            }
            tmp_8 = tmp_9;
          } else {
            tmp_8 = null;
          }
          image_0 = tmp_8;
          if (!(image_0 == null)) {
            var b = top.i1h();
            completed = paintCushion(this, g, view, image_0, Rectangle.from(numberToInt(b.g1h()), numberToInt(b.h1h()), numberToInt(b.gm()), numberToInt(b.hm())), top);
          } else {
            var cushionColor_1 = model.getCushionColor(node);
            g.l2m(!(cushionColor_1 == null) ? cushionColor_1 : model.getColor(node));
            g.m2m(shape);
          }
          var color_2 = ensureNotNull(model.getColor(node));
          var g2 = g.i3c();
          g2.r1x();
          g2.m1v(top.p1h(), top.t1h());
          g2.n1v(bottom.g1h(), bottom.t1h());
          g2.n1v(bottom.s1h(), bottom.t1h());
          g2.n1v(top.s1h(), top.t1h());
          g2.q1v();
          g2.q1x(darker(color_2));
          g2.s1x();
          g2.r1x();
          g2.m1v(top.s1h(), top.t1h());
          g2.n1v(bottom.s1h(), bottom.t1h());
          g2.n1v(bottom.s1h(), bottom.r1h());
          g2.n1v(top.s1h(), top.r1h());
          g2.q1v();
          g2.q1x(darker(color_2));
          g2.s1x();
          if (this.h3c_1) {
            g.y2m(g.r2w().a28());
            g.j3c(top.g1h(), top.h1h(), top.gm(), top.hm());
            g.k3c(numberToInt(top.p1h()), numberToInt(top.t1h()), numberToInt(bottom.g1h()), numberToInt(bottom.t1h()));
            g.k3c(numberToInt(top.s1h()), numberToInt(top.t1h()), numberToInt(bottom.s1h()), numberToInt(bottom.t1h()));
            g.k3c(numberToInt(top.s1h()), numberToInt(top.r1h()), numberToInt(bottom.s1h()), numberToInt(bottom.r1h()));
          }
        }
      }
    }
    return completed;
  }
  paintBorder(g2, view, node, pass, bounds, shape) {
  }
  toString() {
    return 'Cushion';
  }
}
class DefaultAlgorithmFactory_0 {
  constructor() {
    DefaultAlgorithmFactory_instance = this;
    this.instance = Companion_getInstance_75().instance;
  }
  o21() {
    return this.instance;
  }
}
class DefaultTreeMap extends AbstractTreeMap {
  static q3c() {
    var $this = this.e2n();
    $this.f2n($this.r3c());
    $this.k2n($this.s3c($this.view));
    return $this;
  }
  static t3c(model) {
    var $this = this.q3c();
    $this.o2n(model);
    return $this;
  }
  q2n() {
    return ensureNotNull(this.view).q2n();
  }
  u3c(dataFrame) {
    this.o2n(this.v3c(dataFrame));
  }
  v3c(dataFrame) {
    return new DefaultTreeMapModel(dataFrame);
  }
  r3c() {
    return new DefaultTreeMapView();
  }
  s3c(view) {
    return new DefaultTreeMapController(ensureNotNull(view));
  }
  get component() {
    return this.q2n();
  }
}
class Companion_79 {
  constructor() {
    this.w3c_1 = 'Tahoma, Trebuchet MS, Arial, Helvetica, sans-serif';
  }
  getDefaultTooltipFont(fontFactory) {
    return findFont(this, 'Tahoma, Trebuchet MS, Arial, Helvetica, sans-serif', 0, 12.0, fontFactory.l1z(), fontFactory);
  }
  getDefaultLabelingFont(fontFactory) {
    return findFont(this, 'Tahoma, Trebuchet MS, Arial, Helvetica, sans-serif', 0, 12.0, fontFactory.l1z(), fontFactory);
  }
  getDefaultHeaderFont(fontFactory) {
    return findFont(this, 'Tahoma, Trebuchet MS, Arial, Helvetica, sans-serif', 0, 13.0, fontFactory.l1z(), fontFactory);
  }
}
class DefaultTreeMapColumnSettings extends AbstractTreeMapColumnSettings {
  constructor(colorFactory, fontFactory, colorMapFactory) {
    super();
    this.x3c_1 = new EnumProperties(values_2());
    this.borderThickness = SimpleBoundedInterval.qp(0.0, 0.0, 10.0);
    this.format = null;
    this.colorMap = null;
    this.y3c_1 = colorFactory;
    this.z3c_1 = fontFactory;
    this._algorithm = this.x3c_1.cz(TreeMapColumnPropertyType_algorithm_getInstance(), new MutableAlgorithmProperty(Companion_getInstance_75().instance.getDefault()));
    this.algorithm = PropertySingleSelection.s14(this._algorithm);
    this._aggregation = this.x3c_1.bz(TreeMapColumnPropertyType_aggregation_getInstance(), Companion_getInstance_74().c38().e38());
    this._scale = this.x3c_1.bz(TreeMapColumnPropertyType_scale_getInstance(), Companion_getInstance_93().k3d_1.m3d());
    this._nesting = this.x3c_1.bz(TreeMapColumnPropertyType_nesting_getInstance(), Companion_getInstance_86().c38().e38());
    this._ordering = this.x3c_1.bz(TreeMapColumnPropertyType_ordering_getInstance(), Companion_getInstance_88().c38().e38());
    this.orderingDirection = this.x3c_1.bz(TreeMapColumnPropertyType_orderingDirection_getInstance(), SortOrder_Descending_getInstance());
    this.orderingHorizontalVanishingPoint = this.x3c_1.bz(TreeMapColumnPropertyType_orderingHorizontalVanishingPoint_getInstance(), 4);
    this.orderingVerticalVanishingPoint = this.x3c_1.bz(TreeMapColumnPropertyType_orderingVerticalVanishingPoint_getInstance(), 3);
    this._labeling = this.x3c_1.bz(TreeMapColumnPropertyType_labeling_getInstance(), Companion_getInstance_84().c38().e38());
    this._labelingFont = this.x3c_1.bz(TreeMapColumnPropertyType_labelingFont_getInstance(), Companion_instance_79.getDefaultLabelingFont(fontFactory));
    this._labelingForeground = this.x3c_1.bz(TreeMapColumnPropertyType_labelingForeground_getInstance(), colorOf_1(32, 32, 32));
    this._labelingBackground = this.x3c_1.bz(TreeMapColumnPropertyType_labelingEffectColor_getInstance(), null);
    this.labelingEffect = this.x3c_1.bz(TreeMapColumnPropertyType_labelingEffect_getInstance(), null);
    this.labelingHorizontalAlignment = this.x3c_1.bz(TreeMapColumnPropertyType_labelingHorizontalAlignment_getInstance(), 2);
    this.labelingVerticalAlignment = this.x3c_1.bz(TreeMapColumnPropertyType_labelingVerticalAlignment_getInstance(), 1);
    this.labelingRendering = this.x3c_1.bz(TreeMapColumnPropertyType_labelingRendering_getInstance(), Rendering_Clip_getInstance());
    this.labelingMinimumCharactersToDisplay = this.x3c_1.bz(TreeMapColumnPropertyType_labelingMinimumCharactersToDisplay_getInstance(), 1);
    this.labelingEffectOpacity = this.x3c_1.bz(TreeMapColumnPropertyType_labelingEffectOpacity_getInstance(), null);
    this.labelingShrinkTextToFitShape = this.x3c_1.bz(TreeMapColumnPropertyType_labelingShrinkTextToFitShape_getInstance(), false);
    this.labelingResizeTextToFitShape = this.x3c_1.bz(TreeMapColumnPropertyType_labelingResizeTextToFitShape_getInstance(), false);
    this.labelingFloat = this.x3c_1.bz(TreeMapColumnPropertyType_labelingFloat_getInstance(), false);
    this.labelingContrastEnhancement = this.x3c_1.bz(TreeMapColumnPropertyType_labelingContrastEnhancement_getInstance(), Brightness_getInstance());
    this.nestingAmount = this.x3c_1.bz(TreeMapColumnPropertyType_nestingAmount_getInstance(), 1.0);
    this.nestingBackground = this.x3c_1.bz(TreeMapColumnPropertyType_nestingBackground_getInstance(), colorOf_1(180, 180, 180));
    this._headerFont = this.x3c_1.bz(TreeMapColumnPropertyType_headerFont_getInstance(), Companion_instance_79.getDefaultHeaderFont(fontFactory));
    this._headerForeground = this.x3c_1.bz(TreeMapColumnPropertyType_headerForeground_getInstance(), colorOf_1(64, 64, 64));
    this._headerEffectColor = this.x3c_1.bz(TreeMapColumnPropertyType_headerEffectColor_getInstance(), colorOf_1(255, 255, 255));
    this._headerBackground = this.x3c_1.bz(TreeMapColumnPropertyType_headerBackground_getInstance(), colorOf_1(204, 204, 204));
    this.headerEffect = this.x3c_1.bz(TreeMapColumnPropertyType_headerEffect_getInstance(), null);
    this.headerHorizontalAlignment = this.x3c_1.bz(TreeMapColumnPropertyType_headerHorizontalAlignment_getInstance(), 0);
    this.headerVerticalAlignment = this.x3c_1.bz(TreeMapColumnPropertyType_headerVerticalAlignment_getInstance(), 0);
    this.headerRendering = this.x3c_1.bz(TreeMapColumnPropertyType_headerRendering_getInstance(), Rendering_Clip_getInstance());
    this.headerMinimumCharactersToDisplay = this.x3c_1.bz(TreeMapColumnPropertyType_headerMinimumCharactersToDisplay_getInstance(), 1);
    this.headerEffectOpacity = this.x3c_1.bz(TreeMapColumnPropertyType_headerEffectOpacity_getInstance(), null);
    this.headerInsets = this.x3c_1.bz(TreeMapColumnPropertyType_headerInsets_getInstance(), new Insets(1, 1, 0, 1));
    this.tooltipFont = this.x3c_1.bz(TreeMapColumnPropertyType_tooltipFont_getInstance(), Companion_instance_79.getDefaultLabelingFont(fontFactory));
    this.tooltipForeground = this.x3c_1.bz(TreeMapColumnPropertyType_tooltipForeground_getInstance(), colorOf_1(32, 32, 32));
    this.tooltipShowLabel = this.x3c_1.bz(TreeMapColumnPropertyType_showLabel_getInstance(), false);
    this.tooltipRendering = this.x3c_1.bz(TreeMapColumnPropertyType_tooltipRendering_getInstance(), Rendering_Truncate_getInstance());
    this._borderThickness = this.x3c_1.cz(TreeMapColumnPropertyType_borderThickness_getInstance(), new BoundedIntervalProperty(this.borderThickness, StartEnd_Start_getInstance()));
    this.borderColor = this.x3c_1.bz(TreeMapColumnPropertyType_borderColor_getInstance(), colorOf_1(96, 96, 96));
    this.format = this.x3c_1.bz(TreeMapColumnPropertyType_format_getInstance(), null);
    this.colorMap = this.x3c_1.cz(TreeMapColumnPropertyType_colormap_getInstance(), new MutableColorMapProperty(null));
    this.reset();
  }
  p1z() {
    return this.x3c_1;
  }
  f3e() {
    return this.algorithm;
  }
  g3e() {
    return this.borderThickness;
  }
  h3e(_set____db54di) {
    this.labelingEffect = _set____db54di;
  }
  i3e() {
    return this.labelingEffect;
  }
  j3e(_set____db54di) {
    this.labelingHorizontalAlignment = _set____db54di;
  }
  k3e() {
    return this.labelingHorizontalAlignment;
  }
  l3e(_set____db54di) {
    this.labelingVerticalAlignment = _set____db54di;
  }
  m3e() {
    return this.labelingVerticalAlignment;
  }
  n3e(_set____db54di) {
    this.labelingRendering = _set____db54di;
  }
  o3e() {
    return this.labelingRendering;
  }
  p3e(_set____db54di) {
    this.headerEffect = _set____db54di;
  }
  q3e() {
    return this.headerEffect;
  }
  r3e(_set____db54di) {
    this.headerHorizontalAlignment = _set____db54di;
  }
  s3e() {
    return this.headerHorizontalAlignment;
  }
  t3e(_set____db54di) {
    this.headerVerticalAlignment = _set____db54di;
  }
  u3e() {
    return this.headerVerticalAlignment;
  }
  v3e(_set____db54di) {
    this.headerRendering = _set____db54di;
  }
  w3e() {
    return this.headerRendering;
  }
  x3e(_set____db54di) {
    this.tooltipRendering = _set____db54di;
  }
  y3e() {
    return this.tooltipRendering;
  }
  z3e(_set____db54di) {
    this._algorithm = _set____db54di;
  }
  a3f() {
    return this._algorithm;
  }
  b3f(_set____db54di) {
    this._aggregation = _set____db54di;
  }
  c3f() {
    return this._aggregation;
  }
  d3f(_set____db54di) {
    this._scale = _set____db54di;
  }
  e3f() {
    return this._scale;
  }
  f3f(_set____db54di) {
    this._nesting = _set____db54di;
  }
  g3f() {
    return this._nesting;
  }
  h3f(_set____db54di) {
    this._ordering = _set____db54di;
  }
  i3f() {
    return this._ordering;
  }
  j3f(_set____db54di) {
    this.orderingDirection = _set____db54di;
  }
  k3f() {
    return this.orderingDirection;
  }
  l3f(_set____db54di) {
    this.orderingHorizontalVanishingPoint = _set____db54di;
  }
  m3f() {
    return this.orderingHorizontalVanishingPoint;
  }
  n3f(_set____db54di) {
    this.orderingVerticalVanishingPoint = _set____db54di;
  }
  o3f() {
    return this.orderingVerticalVanishingPoint;
  }
  p3f(_set____db54di) {
    this._labeling = _set____db54di;
  }
  q3f() {
    return this._labeling;
  }
  r3f(_set____db54di) {
    this._labelingFont = _set____db54di;
  }
  s3f() {
    return this._labelingFont;
  }
  t3f(_set____db54di) {
    this._labelingForeground = _set____db54di;
  }
  u3f() {
    return this._labelingForeground;
  }
  v3f(_set____db54di) {
    this._labelingBackground = _set____db54di;
  }
  w3f() {
    return this._labelingBackground;
  }
  x3f(_set____db54di) {
    this.labelingMinimumCharactersToDisplay = _set____db54di;
  }
  y3f() {
    return this.labelingMinimumCharactersToDisplay;
  }
  z3f(_set____db54di) {
    this.labelingEffectOpacity = _set____db54di;
  }
  a3g() {
    return this.labelingEffectOpacity;
  }
  b3g(_set____db54di) {
    this.labelingShrinkTextToFitShape = _set____db54di;
  }
  c3g() {
    return this.labelingShrinkTextToFitShape;
  }
  d3g(_set____db54di) {
    this.labelingResizeTextToFitShape = _set____db54di;
  }
  e3g() {
    return this.labelingResizeTextToFitShape;
  }
  f3g(_set____db54di) {
    this.labelingFloat = _set____db54di;
  }
  g3g() {
    return this.labelingFloat;
  }
  h3g(_set____db54di) {
    this.labelingContrastEnhancement = _set____db54di;
  }
  i3g() {
    return this.labelingContrastEnhancement;
  }
  j3g(_set____db54di) {
    this.nestingAmount = _set____db54di;
  }
  k3g() {
    return this.nestingAmount;
  }
  l3g(_set____db54di) {
    this.nestingBackground = _set____db54di;
  }
  m3g() {
    return this.nestingBackground;
  }
  n3g(_set____db54di) {
    this._headerFont = _set____db54di;
  }
  o3g() {
    return this._headerFont;
  }
  p3g(_set____db54di) {
    this._headerForeground = _set____db54di;
  }
  q3g() {
    return this._headerForeground;
  }
  r3g(_set____db54di) {
    this._headerEffectColor = _set____db54di;
  }
  s3g() {
    return this._headerEffectColor;
  }
  t3g(_set____db54di) {
    this._headerBackground = _set____db54di;
  }
  u3g() {
    return this._headerBackground;
  }
  v3g(_set____db54di) {
    this.headerMinimumCharactersToDisplay = _set____db54di;
  }
  w3g() {
    return this.headerMinimumCharactersToDisplay;
  }
  x3g(_set____db54di) {
    this.headerEffectOpacity = _set____db54di;
  }
  y3g() {
    return this.headerEffectOpacity;
  }
  z3g(_set____db54di) {
    this.headerInsets = _set____db54di;
  }
  a3h() {
    return this.headerInsets;
  }
  b3h(_set____db54di) {
    this.tooltipFont = _set____db54di;
  }
  c3h() {
    return this.tooltipFont;
  }
  d3h(_set____db54di) {
    this.tooltipForeground = _set____db54di;
  }
  e3h() {
    return this.tooltipForeground;
  }
  f3h(_set____db54di) {
    this.tooltipShowLabel = _set____db54di;
  }
  g3h() {
    return this.tooltipShowLabel;
  }
  h3h(_set____db54di) {
    this.borderColor = _set____db54di;
  }
  i3h() {
    return this.borderColor;
  }
  j3h(_set____db54di) {
    this._borderThickness = _set____db54di;
  }
  k3h() {
    return this._borderThickness;
  }
  l3h(_set____db54di) {
    this.format = _set____db54di;
  }
  m3h() {
    return this.format;
  }
  n3h(_set____db54di) {
    this.colorMap = _set____db54di;
  }
  o3h() {
    return this.colorMap;
  }
  getAlgorithmProperty() {
    return this._algorithm;
  }
  getAlgorithm() {
    return ensureNotNull(this._algorithm.z2());
  }
  setAlgorithm(algorithm) {
    this._algorithm.ap(algorithm);
  }
  getAlgorithmSelection() {
    return this.algorithm;
  }
  getAggregationProperty() {
    return this._aggregation;
  }
  getAggregation() {
    return this._aggregation.z2();
  }
  setAggregation(aggregation) {
    this._aggregation.ap(aggregation);
  }
  getScaleProperty() {
    return this._scale;
  }
  getScale() {
    return ensureNotNull(this._scale.z2());
  }
  setScale(scale) {
    this._scale.ap(scale);
  }
  getNestingProperty() {
    return this._nesting;
  }
  getNesting() {
    return this._nesting.z2();
  }
  setNesting(nesting) {
    this._nesting.ap(nesting);
  }
  getOrderingProperty() {
    return this._ordering;
  }
  getOrdering() {
    return ensureNotNull(this._ordering.z2());
  }
  setOrdering(ordering) {
    this._ordering.ap(ordering);
  }
  getOrderingDirectionProperty() {
    return this.orderingDirection;
  }
  getOrderingDirection() {
    return ensureNotNull(this.orderingDirection.z2());
  }
  setOrderingDirection(sortOrder) {
    this.orderingDirection.ap(sortOrder);
  }
  getOrderingVerticalVanishingPointProperty() {
    return this.orderingVerticalVanishingPoint;
  }
  getOrderingVerticalVanishingPoint() {
    return this.orderingVerticalVanishingPoint.z2();
  }
  setOrderingVerticalVanishingPoint(verticalVanishingPoint) {
    this.orderingVerticalVanishingPoint.ap(verticalVanishingPoint);
  }
  getOrderingHorizontalVanishingPointProperty() {
    return this.orderingHorizontalVanishingPoint;
  }
  getOrderingHorizontalVanishingPoint() {
    return this.orderingHorizontalVanishingPoint.z2();
  }
  setOrderingHorizontalVanishingPoint(horizontalVanishingPoint) {
    this.orderingHorizontalVanishingPoint.ap(horizontalVanishingPoint);
  }
  getLabelingProperty() {
    return this._labeling;
  }
  getLabeling() {
    return this._labeling.z2();
  }
  setLabeling(labeling) {
    this._labeling.ap(labeling);
  }
  getLabelingFontProperty() {
    return this._labelingFont;
  }
  getLabelingFont() {
    return this._labelingFont.z2();
  }
  setLabelingFont(font) {
    this._labelingFont.ap(font);
  }
  getLabelingForegroundProperty() {
    return this._labelingForeground;
  }
  getLabelingForeground() {
    return this._labelingForeground.z2();
  }
  setLabelingForeground(color) {
    this._labelingForeground.ap(color);
  }
  getLabelingEffectColorProperty() {
    return this._labelingBackground;
  }
  getLabelingEffectColor() {
    return this._labelingBackground.z2();
  }
  setLabelingEffectColor(color) {
    this._labelingBackground.ap(color);
  }
  getLabelingEffectProperty() {
    return this.labelingEffect;
  }
  getLabelingEffect() {
    return this.labelingEffect.z2();
  }
  setLabelingEffect(effect) {
    this.labelingEffect.ap(effect);
  }
  getLabelingHorizontalAlignmentProperty() {
    return this.labelingHorizontalAlignment;
  }
  getLabelingHorizontalAlignment() {
    return this.labelingHorizontalAlignment.z2();
  }
  setLabelingHorizontalAlignment(alignment) {
    this.labelingHorizontalAlignment.ap(alignment);
  }
  getLabelingVerticalAlignmentProperty() {
    return this.labelingVerticalAlignment;
  }
  getLabelingVerticalAlignment() {
    return this.labelingVerticalAlignment.z2();
  }
  setLabelingVerticalAlignment(alignment) {
    this.labelingVerticalAlignment.ap(alignment);
  }
  getLabelingRenderingProperty() {
    return this.labelingRendering;
  }
  getLabelingRendering() {
    return this.labelingRendering.z2();
  }
  setLabelingRendering(rendering) {
    this.labelingRendering.ap(rendering);
  }
  getLabelingMinimumCharactersToDisplayProperty() {
    return this.labelingMinimumCharactersToDisplay;
  }
  getLabelingMinimumCharactersToDisplay() {
    return this.labelingMinimumCharactersToDisplay.z2();
  }
  setLabelingMinimumCharactersToDisplay(minimumCharactersToDisplay) {
    this.labelingMinimumCharactersToDisplay.ap(minimumCharactersToDisplay);
  }
  getLabelingEffectOpacityProperty() {
    return this.labelingEffectOpacity;
  }
  getLabelingEffectOpacity() {
    return this.labelingEffectOpacity.z2();
  }
  setLabelingEffectOpacity(opacity) {
    this.labelingEffectOpacity.ap(opacity);
  }
  getLabelingShrinkTextToFitShapeProperty() {
    return this.labelingShrinkTextToFitShape;
  }
  getLabelingShrinkTextToFitShape() {
    return this.labelingShrinkTextToFitShape.z2();
  }
  setLabelingShrinkTextToFitShape(labelingShrinkTextToFitShape) {
    this.labelingShrinkTextToFitShape.ap(labelingShrinkTextToFitShape);
  }
  getLabelingResizeTextToFitShapeProperty() {
    return this.labelingResizeTextToFitShape;
  }
  getLabelingResizeTextToFitShape() {
    return this.labelingResizeTextToFitShape.z2();
  }
  setLabelingResizeTextToFitShape(labelingResizeTextToFitShape) {
    this.labelingResizeTextToFitShape.ap(labelingResizeTextToFitShape);
  }
  getLabelingFloatProperty() {
    return this.labelingFloat;
  }
  getLabelingFloat() {
    return this.labelingFloat.z2();
  }
  setLabelingFloat(labelingFloat) {
    this.labelingFloat.ap(labelingFloat);
  }
  getLabelingContrastEnhancementProperty() {
    return this.labelingContrastEnhancement;
  }
  getLabelingContrastEnhancement() {
    return this.labelingContrastEnhancement.z2();
  }
  setLabelingContrastEnhancement(contrastEnhancement) {
    this.labelingContrastEnhancement.ap(contrastEnhancement);
  }
  getNestingAmountProperty() {
    return this.nestingAmount;
  }
  getNestingAmount() {
    return this.nestingAmount.z2();
  }
  setNestingAmount(amount) {
    this.nestingAmount.ap(amount);
  }
  getNestingBackgroundProperty() {
    return this.nestingBackground;
  }
  getNestingBackground() {
    return this.nestingBackground.z2();
  }
  setNestingBackground(color) {
    this.nestingBackground.ap(color);
  }
  getHeaderFontProperty() {
    return this._headerFont;
  }
  getHeaderFont() {
    return this._headerFont.z2();
  }
  setHeaderFont(font) {
    this._headerFont.ap(font);
  }
  getHeaderForegroundProperty() {
    return this._headerForeground;
  }
  getHeaderForeground() {
    return this._headerForeground.z2();
  }
  setHeaderForeground(color) {
    this._headerForeground.ap(color);
  }
  getHeaderBackgroundProperty() {
    return this._headerBackground;
  }
  getHeaderBackground() {
    return this._headerBackground.z2();
  }
  setHeaderBackground(color) {
    this._headerBackground.ap(color);
  }
  getHeaderEffectColorProperty() {
    return this._headerEffectColor;
  }
  getHeaderEffectColor() {
    return this._headerEffectColor.z2();
  }
  setHeaderEffectColor(color) {
    this._headerEffectColor.ap(color);
  }
  getHeaderEffectProperty() {
    return this.headerEffect;
  }
  getHeaderEffect() {
    return this.headerEffect.z2();
  }
  setHeaderEffect(effect) {
    this.headerEffect.ap(effect);
  }
  getHeaderHorizontalAlignmentProperty() {
    return this.headerHorizontalAlignment;
  }
  getHeaderHorizontalAlignment() {
    return this.headerHorizontalAlignment.z2();
  }
  setHeaderHorizontalAlignment(alignment) {
    this.headerHorizontalAlignment.ap(alignment);
  }
  getHeaderVerticalAlignmentProperty() {
    return this.headerVerticalAlignment;
  }
  getHeaderVerticalAlignment() {
    return this.headerVerticalAlignment.z2();
  }
  setHeaderVerticalAlignment(alignment) {
    this.headerVerticalAlignment.ap(alignment);
  }
  getHeaderRenderingProperty() {
    return this.headerRendering;
  }
  getHeaderRendering() {
    return this.headerRendering.z2();
  }
  setHeaderRendering(rendering) {
    this.headerRendering.ap(rendering);
  }
  getHeaderMinimumCharactersToDisplayProperty() {
    return this.headerMinimumCharactersToDisplay;
  }
  getHeaderMinimumCharactersToDisplay() {
    return this.headerMinimumCharactersToDisplay.z2();
  }
  setHeaderMinimumCharactersToDisplay(minimumCharactersToDisplay) {
    this.headerMinimumCharactersToDisplay.ap(minimumCharactersToDisplay);
  }
  getHeaderEffectOpacityProperty() {
    return this.headerEffectOpacity;
  }
  getHeaderEffectOpacity() {
    return this.headerEffectOpacity.z2();
  }
  setHeaderEffectOpacity(opacity) {
    this.headerEffectOpacity.ap(opacity);
  }
  getHeaderInsetsProperty() {
    return this.headerInsets;
  }
  getHeaderInsets() {
    return this.headerInsets.z2();
  }
  setHeaderInsets(insets) {
    this.headerInsets.ap(insets);
  }
  getTooltipFontProperty() {
    return this.tooltipFont;
  }
  getTooltipFont() {
    return this.tooltipFont.z2();
  }
  setTooltipFont(font) {
    this.tooltipFont.ap(font);
  }
  getTooltipForegroundProperty() {
    return this.tooltipForeground;
  }
  getTooltipForeground() {
    return this.tooltipForeground.z2();
  }
  setTooltipForeground(color) {
    this.tooltipForeground.ap(color);
  }
  getTooltipRenderingProperty() {
    return this.tooltipRendering;
  }
  getTooltipRendering() {
    return this.tooltipRendering.z2();
  }
  setTooltipRendering(rendering) {
    this.tooltipRendering.ap(rendering);
  }
  getBorderColorProperty() {
    return this.borderColor;
  }
  getBorderColor() {
    return this.borderColor.z2();
  }
  setBorderColor(color) {
    this.borderColor.ap(color);
  }
  getBorderThicknessInterval() {
    return this.borderThickness;
  }
  getBorderThickness() {
    return this.borderThickness.start;
  }
  setBorderThickness(value) {
    this.borderThickness.start = value;
  }
  getFormatProperty() {
    return ensureNotNull(this.format);
  }
  getFormat() {
    return ensureNotNull(this.format).z2();
  }
  setFormat(format) {
    ensureNotNull(this.format).ap(format);
  }
  getShowLabelProperty() {
    return this.tooltipShowLabel;
  }
  getShowLabel() {
    return this.tooltipShowLabel.z2();
  }
  setShowLabel(show) {
    this.tooltipShowLabel.ap(show);
  }
  getColorMapProperty() {
    return this.colorMap;
  }
  getColorMap() {
    return ensureNotNull(this.colorMap).z2();
  }
  setColorMap(colorMap) {
    ensureNotNull(this.colorMap).ap(colorMap);
  }
  getProperty(key) {
    return ensureNotNull(this.x3c_1.fz(key).z2());
  }
  isDefaults() {
    return true;
  }
  getOverrideDefaultsProperty() {
    return null;
  }
  isOverrideDefaults() {
    return false;
  }
  setOverrideDefaults(overrideDefaults) {
    if (overrideDefaults) {
      throw UnsupportedOperationException.y8('Default settings cannot be overridden');
    }
  }
  getPropertyOverride(key) {
    return this.getProperty(key);
  }
  reset() {
    this.setAlgorithm(Companion_getInstance_75().instance.getDefault());
    this.setAggregation(Companion_getInstance_74().c38().e38());
    this.setScale(Companion_getInstance_93().k3d_1.m3d());
    this.setNesting(Companion_getInstance_86().c38().e38());
    this.setOrdering(Companion_getInstance_88().c38().e38());
    this.setOrderingDirection(SortOrder_Descending_getInstance());
    this.setOrderingHorizontalVanishingPoint(4);
    this.setOrderingVerticalVanishingPoint(3);
    this.setLabeling(Companion_getInstance_84().c38().e38());
    this.setLabelingForeground(colorOf_1(32, 32, 32));
    this.setLabelingEffectColor(null);
    this.setLabelingEffect(null);
    this.setLabelingHorizontalAlignment(2);
    this.setLabelingVerticalAlignment(1);
    this.setLabelingRendering(Rendering_Clip_getInstance());
    this.setLabelingMinimumCharactersToDisplay(1);
    this.setLabelingEffectOpacity(null);
    this.setLabelingShrinkTextToFitShape(false);
    this.setLabelingResizeTextToFitShape(false);
    this.setLabelingFloat(false);
    this.setLabelingContrastEnhancement(Brightness_getInstance());
    this.setNestingAmount(1.0);
    this.setNestingBackground(colorOf_1(180, 180, 180));
    this.setHeaderForeground(colorOf_1(64, 64, 64));
    this.setHeaderEffectColor(colorOf_1(255, 255, 255));
    this.setHeaderBackground(colorOf_1(204, 204, 204));
    this.setHeaderEffect(null);
    this.setHeaderHorizontalAlignment(0);
    this.setHeaderVerticalAlignment(0);
    this.setHeaderRendering(Rendering_Clip_getInstance());
    this.setHeaderMinimumCharactersToDisplay(1);
    this.setHeaderEffectOpacity(null);
    this.setHeaderInsets(new Insets(1, 1, 0, 1));
    this.setTooltipForeground(colorOf_1(32, 32, 32));
    this.setShowLabel(false);
    this.setTooltipRendering(Rendering_Truncate_getInstance());
    this.setBorderThickness(0.5);
    this.setBorderColor(colorOf_1(96, 96, 96));
    this.setFormat(null);
    this.setHeaderFont(Companion_instance_79.getDefaultHeaderFont(this.z3c_1));
    this.setLabelingFont(Companion_instance_79.getDefaultLabelingFont(this.z3c_1));
    this.setTooltipFont(Companion_instance_79.getDefaultLabelingFont(this.z3c_1));
  }
  createDefaultColorMap(column) {
    return null;
  }
  get properties() {
    return this.p1z();
  }
}
class DefaultTreeMapController extends AbstractTreeMapController {}
class Companion_80 {
  constructor() {
    Companion_instance_80 = this;
    this.p3h_1 = new Insets(0, 0, 0, 0);
  }
}
class DefaultTreeMapHeaderRenderer extends EnhancedLabel {
  static l36() {
    Companion_getInstance_80();
    var $this = this.j1z();
    $this.k36_1 = null;
    $this.isOpaque = false;
    $this.setName('TreeMap.headerRenderer');
    $this.setInsets(Companion_getInstance_80().p3h_1.t1x_1, Companion_getInstance_80().p3h_1.u1x_1, Companion_getInstance_80().p3h_1.v1x_1, Companion_getInstance_80().p3h_1.w1x_1);
    $this.setEffect(Emphasize_getInstance());
    $this.setHorizontalAlignment(0);
    $this.setVerticalAlignment(1);
    $this.setRendering(Rendering_Clip_getInstance());
    return $this;
  }
  q3h(model, node, dimension) {
    var value = model.getLabelName(node);
    this.r3h(value);
    var settings = model.settings.getColumnSettings(model.getGroupByColumn(node));
    var effect = settings.getHeaderEffect();
    if (!(effect == null)) {
      this.setEffect(effect);
    }
    var horizontalAlignment = settings.getHeaderHorizontalAlignment();
    if (horizontalAlignment == null)
      null;
    else {
      // Inline function 'kotlin.let' call
      this.setHorizontalAlignment(horizontalAlignment);
    }
    var verticalAlignment = settings.getHeaderVerticalAlignment();
    if (verticalAlignment == null)
      null;
    else {
      // Inline function 'kotlin.let' call
      this.setVerticalAlignment(verticalAlignment);
    }
    var rendering = settings.getHeaderRendering();
    if (!(rendering == null)) {
      this.setRendering(rendering);
    }
    var minimumCharactersToDisplay = settings.getHeaderMinimumCharactersToDisplay();
    if (minimumCharactersToDisplay == null)
      null;
    else {
      // Inline function 'kotlin.let' call
      this.setMinimumCharactersToDisplay(minimumCharactersToDisplay);
    }
    var effectOpacity = settings.getHeaderEffectOpacity();
    if (effectOpacity == null)
      null;
    else {
      // Inline function 'kotlin.let' call
      this.setEffectOpacity(effectOpacity);
    }
    var insets = settings.getHeaderInsets();
    if (!(insets == null)) {
      this.setInsets(insets.t1x_1, insets.u1x_1, insets.v1x_1, insets.w1x_1);
    } else {
      this.setInsets(0, 0, 0, 0);
    }
    this.setDesiredWidth(dimension.cm_1);
    this.setDesiredHeight(dimension.dm_1);
    return this;
  }
  r3h(value) {
    var tmp1_elvis_lhs = value == null ? null : toString_1(value);
    this.setText(tmp1_elvis_lhs == null ? '' : tmp1_elvis_lhs);
  }
  setName(name) {
    this.k36_1 = name;
  }
  getName() {
    return this.k36_1;
  }
}
class Companion_81 {
  constructor() {
    Companion_instance_81 = this;
    this.s3h_1 = new Insets(0, 2, 0, 1);
  }
}
class DefaultTreeMapLabelRenderer extends EnhancedLabel {
  static m35() {
    Companion_getInstance_81();
    var $this = this.j1z();
    $this.isOpaque = false;
    $this.setName('TreeMap.labelRenderer');
    $this.setEffect(Plain_getInstance());
    $this.setHorizontalAlignment(2);
    $this.setRendering(Rendering_Clip_getInstance());
    return $this;
  }
  m2l(view, column, node, dimension) {
    var value = ensureNotNull(view.h2l()).getStringValue(node, column);
    this.setInsets(Companion_getInstance_81().s3h_1.t1x_1, Companion_getInstance_81().s3h_1.u1x_1, Companion_getInstance_81().s3h_1.v1x_1, Companion_getInstance_81().s3h_1.w1x_1);
    this.setText(value);
    this.q1z(ensureNotNull(view.h2l()).getColumnClass(column) === getKClass(HtmlString));
    var settings = ensureNotNull(view.h2l()).settings.getColumnSettings(column);
    var effect = settings.getLabelingEffect();
    if (!(effect == null)) {
      this.setEffect(effect);
    }
    var horizontalAlignment = settings.getLabelingHorizontalAlignment();
    if (horizontalAlignment == null)
      null;
    else {
      // Inline function 'kotlin.let' call
      this.setHorizontalAlignment(horizontalAlignment);
    }
    var verticalAlignment = settings.getLabelingVerticalAlignment();
    if (verticalAlignment == null)
      null;
    else {
      // Inline function 'kotlin.let' call
      this.setVerticalAlignment(verticalAlignment);
    }
    var rendering = settings.getLabelingRendering();
    if (!(rendering == null)) {
      this.setRendering(rendering);
    }
    var minimumCharactersToDisplay = settings.getLabelingMinimumCharactersToDisplay();
    if (minimumCharactersToDisplay == null)
      null;
    else {
      // Inline function 'kotlin.let' call
      this.setMinimumCharactersToDisplay(minimumCharactersToDisplay);
    }
    var effectOpacity = settings.getLabelingEffectOpacity();
    if (effectOpacity == null)
      null;
    else {
      // Inline function 'kotlin.let' call
      this.setEffectOpacity(effectOpacity);
    }
    this.setDesiredWidth(dimension.cm_1);
    this.setDesiredHeight(dimension.dm_1);
    return this;
  }
}
class DefaultTreeMapModel$dataFrameListener$1 {
  constructor(this$0) {
    this.t3h_1 = this$0;
  }
  l2g(event) {
    var groupByTreeMapColumns = this.t3h_1.settings.groupByColumns;
    this.t3h_1.m3j_1.u4();
    this.t3h_1.l3j_1.u4();
    this.t3h_1.w2u();
    this.t3h_1.e2y();
    var affectedColumns = event.d2h_1;
    if (affectedColumns == null) {
      this.t3h_1.i2w();
      return Unit_instance;
    } else {
      if (!(groupByTreeMapColumns == null)) {
        var _iterator__ex2g4s = groupByTreeMapColumns.h1();
        while (_iterator__ex2g4s.i1()) {
          var column = _iterator__ex2g4s.j1();
          if (!(column == null)) {
            var _iterator__ex2g4s_0 = affectedColumns.h1();
            while (_iterator__ex2g4s_0.i1()) {
              var column_0 = _iterator__ex2g4s_0.j1();
              if (column_0 === column_0) {
                this.t3h_1.i2w();
                return Unit_instance;
              }
            }
          }
        }
      }
    }
    this.t3h_1.f2w();
  }
  g2c(event) {
    return this.l2g(event);
  }
}
class DefaultTreeMapModel extends AbstractTreeMapModel {
  constructor(dataFrame) {
    super();
    this.j3j_1 = null;
    this.k3j_1 = HashMap.i7();
    this.l3j_1 = HashMap.i7();
    this.m3j_1 = HashMap.i7();
    var tmp = this;
    tmp.dataFrameListener = new DefaultTreeMapModel$dataFrameListener$1(this);
    this.n3j(dataFrame);
    this.x2x();
  }
  n3j(dataFrame) {
    if (!(this.j3j_1 === dataFrame)) {
      var tmp0_safe_receiver = this.j3j_1;
      if (tmp0_safe_receiver == null)
        null;
      else {
        tmp0_safe_receiver.h2g(this.dataFrameListener);
      }
      this.j3j_1 = dataFrame;
      var tmp1_safe_receiver = this.j3j_1;
      if (tmp1_safe_receiver == null)
        null;
      else {
        tmp1_safe_receiver.i2c(this.dataFrameListener);
      }
      this.e2y();
      this.i2w();
    }
  }
  j2c() {
    return this.j3j_1;
  }
  o3j() {
    return this.dataFrameListener;
  }
  getLabelName(node) {
    return node.h30();
  }
  getParent(node) {
    return node.y2z();
  }
  isRoot(node) {
    return node.z2z();
  }
  getChildCount(node) {
    return node.x2z();
  }
  getChildren(parent) {
    return ensureNotNull(parent.a30());
  }
  getChildrenOfTypeParent(parent) {
    return ensureNotNull(parent.b30());
  }
  getCushionImage(node) {
    return node.k30();
  }
  getCushionColor(node) {
    return node.l30();
  }
  q2u(childrenGroupByColumn) {
    return new ParentTreeMapNode('root', this, null, childrenGroupByColumn);
  }
  createLeafNode(row) {
    var tmp;
    if (this.r2s_1.a3(row)) {
      tmp = ensureNotNull(this.r2s_1.c3(row));
    } else {
      var tmp_0 = new LeafTreeMapNode(row, this);
      var node = tmp_0 instanceof AbstractTreeMapNode ? tmp_0 : THROW_CCE();
      this.r2s_1.o6(row, node);
      tmp = node;
    }
    return tmp;
  }
  getNodeForRow(row) {
    return ensureNotNull(this.r2s_1.c3(row));
  }
  createParentNode(name, groupByColumn, childrenGroupByColumn) {
    return new ParentTreeMapNode(name, this, groupByColumn, childrenGroupByColumn);
  }
  findChild(parent, name) {
    return parent.e30(name);
  }
  addChildToParent(parent, child) {
    parent.c30(child);
  }
  r2u(parent, worker) {
    var groupByTreeMapColumns;
    if (!(this.settings.groupByColumns == null)) {
      var count = 0;
      var inductionVariable = 0;
      var last = this.settings.groupByColumns.k1();
      if (inductionVariable < last)
        do {
          var i = inductionVariable;
          inductionVariable = inductionVariable + 1 | 0;
          var column = this.settings.groupByColumns.l1(i);
          if (!(column == null)) {
            count = count + 1 | 0;
          }
        }
         while (inductionVariable < last);
      if (count === this.settings.groupByColumns.k1()) {
        groupByTreeMapColumns = toMutableList_0(this.settings.groupByColumns);
      } else {
        var filter1 = filterNotNull(this.settings.groupByColumns);
        groupByTreeMapColumns = toMutableList_0(filter1);
        var index = 0;
        var inductionVariable_0 = 0;
        var last_0 = this.settings.groupByColumns.k1();
        if (inductionVariable_0 < last_0)
          do {
            var i_0 = inductionVariable_0;
            inductionVariable_0 = inductionVariable_0 + 1 | 0;
            var column_0 = this.settings.groupByColumns.l1(i_0);
            if (!(column_0 == null)) {
              groupByTreeMapColumns.p4(index, column_0);
              index = index + 1 | 0;
            }
          }
           while (inductionVariable_0 < last_0);
      }
    } else {
      groupByTreeMapColumns = toMutableList_0(this.settings.groupByColumns);
    }
    if (!(this.j3j_1 == null)) {
      var _iterator__ex2g4s = ensureNotNull(this.j3j_1).o2d().h1();
      while (_iterator__ex2g4s.i1()) {
        var row = _iterator__ex2g4s.j1();
        if (!ensureNotNull(worker).o17()) {
          var pathList;
          var groupByList;
          var childrenGroupByList;
          if (groupByTreeMapColumns == null || groupByTreeMapColumns.k1() === 0) {
            pathList = emptyList();
            groupByList = emptyList();
            childrenGroupByList = emptyList();
          } else {
            pathList = ArrayList.n1(groupByTreeMapColumns.k1());
            groupByList = ArrayList.n1(groupByTreeMapColumns.k1());
            childrenGroupByList = ArrayList.n1(groupByTreeMapColumns.k1());
            var inductionVariable_1 = 0;
            var last_1 = groupByTreeMapColumns.k1() - 1 | 0;
            if (inductionVariable_1 <= last_1)
              do {
                var i_1 = inductionVariable_1;
                inductionVariable_1 = inductionVariable_1 + 1 | 0;
                var column_1 = groupByTreeMapColumns.l1(i_1);
                var groupByColumn = i_1 < (groupByTreeMapColumns.k1() - 1 | 0) ? groupByTreeMapColumns.l1(i_1 + 1 | 0) : null;
                var index_0 = ensureNotNull(column_1);
                var value = ensureNotNull(this.j3j_1).x2f(row, index_0);
                if (!(value == null) && this.v2t_1.d18(getKClassFromExpression(value))) {
                  var objects = isArray(value) ? value : THROW_CCE();
                  addAll(pathList, requireNoNulls(objects));
                  var inductionVariable_2 = 0;
                  var last_2 = objects.length - 1 | 0;
                  if (inductionVariable_2 <= last_2)
                    do {
                      var j = inductionVariable_2;
                      inductionVariable_2 = inductionVariable_2 + 1 | 0;
                      if (!(column_1 == null) && !(groupByColumn == null)) {
                        groupByList.c1(column_1);
                        childrenGroupByList.c1(groupByColumn);
                      }
                    }
                     while (inductionVariable_2 <= last_2);
                } else {
                  if (!(value == null)) {
                    var settings = this.settings.getColumnSettings(column_1);
                    if (!(settings.getFormat() == null)) {
                      var s = ensureNotNull(ensureNotNull(settings.getFormat()).zk(value, false));
                      pathList.c1(s);
                    } else {
                      pathList.c1(value);
                    }
                    groupByList.c1(column_1);
                    childrenGroupByList.c1(groupByColumn);
                  }
                }
              }
               while (inductionVariable_1 <= last_1);
          }
          this.addChild(ensureNotNull(parent), pathList, groupByList, childrenGroupByList, row);
        } else {
          return true;
        }
      }
    }
    return false;
  }
  addChild(parent, path, groupBy, childrenGroupBy, row) {
    var parent_0 = parent;
    var groupByIterator = groupBy.h1();
    var childrenGroupByIterator = childrenGroupBy.h1();
    var _iterator__ex2g4s = path.h1();
    while (_iterator__ex2g4s.i1()) {
      var name = _iterator__ex2g4s.j1();
      var g = groupByIterator.j1();
      var c = childrenGroupByIterator.j1();
      var node;
      if (this.b2u(parent_0) || this.findChild(parent_0, name) == null) {
        node = this.createParentNode(ensureNotNull(name), g, c);
        this.addChildToParent(parent_0, node);
      } else {
        var tmp = this.findChild(parent_0, name);
        node = tmp instanceof AbstractTreeMapNode ? tmp : THROW_CCE();
      }
      parent_0 = node;
    }
    this.addChildToParent(parent_0, this.createLeafNode(row));
  }
  getTreeMapColumn(columnIndex) {
    var tmp;
    if (columnIndex >= 0 && columnIndex <= ensureNotNull(this.j3j_1).y2e()) {
      tmp = ensureNotNull(this.j3j_1).z2e(columnIndex);
    } else {
      tmp = null;
    }
    return tmp;
  }
  getTreeMapColumnByName(columnName) {
    var _iterator__ex2g4s = ensureNotNull(this.j3j_1).a2g().h1();
    while (_iterator__ex2g4s.i1()) {
      var c = _iterator__ex2g4s.j1();
      if (equals_0(ensureNotNull(this.j3j_1).g2g(c), columnName)) {
        return this.getTreeMapColumn(ensureNotNull(this.j3j_1).d2g(c));
      }
    }
    return null;
  }
  e2g() {
    var df = this.j3j_1;
    return !(df == null) ? df.e2g() : 0;
  }
  y2e() {
    var df = this.j3j_1;
    return !(df == null) ? df.y2e() : 0;
  }
  columns() {
    return ensureNotNull(this.j3j_1).a2g();
  }
  getColumnName(columnIndex) {
    return !(this.j3j_1 == null) ? ensureNotNull(this.j3j_1).g2g(columnIndex) : null;
  }
  getColumnClass(columnIndex) {
    return ensureNotNull(this.j3j_1).g2f(columnIndex);
  }
  getValueAt(node, columnIndex) {
    var row = node.g30();
    var tmp;
    if (!(row == null)) {
      tmp = ensureNotNull(this.j3j_1).x2f(row, columnIndex);
    } else {
      tmp = null;
    }
    return tmp;
  }
  isEveryValueUnique(column) {
    var isEveryValueUnique = this.getColumnClass(ensureNotNull(column)).equals(PrimitiveClasses_getInstance().ad()) || this.getColumnClass(column).equals(PrimitiveClasses_getInstance().bd());
    if (!isEveryValueUnique) {
      isEveryValueUnique = true;
      var values = HashSet.c9();
      var series = ensureNotNull(this.j3j_1).z2f(column);
      var _iterator__ex2g4s = ensureNotNull(this.j3j_1).o2d().h1();
      $l$loop: while (_iterator__ex2g4s.i1()) {
        var row = _iterator__ex2g4s.j1();
        var value = ensureNotNull(series).c3(row);
        if (values.q2(value)) {
          isEveryValueUnique = false;
          break $l$loop;
        } else {
          values.c1(value);
        }
      }
    }
    return isEveryValueUnique;
  }
  getNumericMax(columnIndex) {
    var tmp;
    if (!(columnIndex == null)) {
      if (!this.l3j_1.a3(columnIndex)) {
        var max = DataFrameHelper_instance.f2h(ensureNotNull(this.j3j_1), columnIndex).z2g_1;
        if (!(max == null)) {
          var tmp0 = this.l3j_1;
          // Inline function 'kotlin.collections.set' call
          var value = numberToDouble(max);
          tmp0.o6(columnIndex, value);
        } else {
          // Inline function 'kotlin.collections.set' call
          this.l3j_1.o6(columnIndex, null);
        }
      }
      return this.l3j_1.c3(columnIndex);
    } else {
      tmp = null;
    }
    return tmp;
  }
  getNumericMin(columnIndex) {
    var tmp;
    if (!(columnIndex == null)) {
      if (!this.m3j_1.a3(columnIndex)) {
        var min = DataFrameHelper_instance.f2h(ensureNotNull(this.j3j_1), columnIndex).y2g_1;
        if (!(min == null)) {
          var tmp0 = this.m3j_1;
          // Inline function 'kotlin.collections.set' call
          var value = numberToDouble(min);
          tmp0.o6(columnIndex, value);
        } else {
          // Inline function 'kotlin.collections.set' call
          this.m3j_1.o6(columnIndex, null);
        }
      }
      return this.m3j_1.c3(columnIndex);
    } else {
      tmp = null;
    }
    return tmp;
  }
  setNumericMax(columnIndex, max) {
    this.l3j_1.o6(ensureNotNull(columnIndex), max);
    this.f2w();
  }
  setNumericMin(columnIndex, min) {
    this.m3j_1.o6(ensureNotNull(columnIndex), min);
    this.f2w();
  }
  createDefaultColorMap(column) {
    var stat = DataFrameHelper_instance.f2h(ensureNotNull(this.j3j_1), column);
    return DataFrameColorMapFactory_instance.p3j(this.o2s_1, this.j3j_1, column, stat.y2g_1, stat.z2g_1);
  }
  f2z(column) {
    return DataFrameColorMapFactory_instance.q3j(this.o2s_1, this.j3j_1, ensureNotNull(column));
  }
  get dataFrame() {
    return this.j2c();
  }
  set dataFrame(value) {
    this.n3j(value);
  }
  get rowCount() {
    return this.e2g();
  }
  get columnCount() {
    return this.y2e();
  }
  get root() {
    return this.z2w();
  }
  set root(value) {
    this.s2u(value);
  }
  get worker() {
    return this.b2x();
  }
  set worker(value) {
    this.a2x(value);
  }
  get workerFuture() {
    return this.d2x();
  }
  set workerFuture(value) {
    this.c2x(value);
  }
  get normalizedLightSourceX() {
    return this.f2x();
  }
  set normalizedLightSourceX(value) {
    this.e2x(value);
  }
  get normalizedLightSourceY() {
    return this.h2x();
  }
  set normalizedLightSourceY(value) {
    this.g2x(value);
  }
  get normalizedLightSourceZ() {
    return this.j2x();
  }
  set normalizedLightSourceZ(value) {
    this.i2x(value);
  }
  get maximumSize() {
    return this.l2x();
  }
  set maximumSize(value) {
    this.k2x(value);
  }
}
class DefaultTreeMapPopup {
  constructor(view) {
    this.s3j_1 = null;
    this.t3j_1 = null;
    this.r3j_1 = view;
  }
  l32(x, y, owner) {
    this.s3j_1 = new Point(x, y);
    this.t3j_1 = owner;
  }
  m31() {
    this.s3j_1 = null;
    this.t3j_1 = null;
  }
  i32() {
    if (!(this.t3j_1 == null)) {
      this.r3j_1.i32();
    }
  }
  e32() {
    return this.s3j_1;
  }
}
class DefaultTreeMapSettings$columnPropertyChangeListener$1 {
  constructor(this$0) {
    this.w3k_1 = this$0;
  }
  x3k(name, event) {
    if (TreeMapColumnPropertyType_nestingBackground_getInstance().equals(name) || TreeMapColumnPropertyType_headerBackground_getInstance().equals(name) || TreeMapColumnPropertyType_headerForeground_getInstance().equals(name) || TreeMapColumnPropertyType_headerEffectColor_getInstance().equals(name) || TreeMapColumnPropertyType_labelingFont_getInstance().equals(name) || TreeMapColumnPropertyType_labelingEffectColor_getInstance().equals(name) || TreeMapColumnPropertyType_labelingForeground_getInstance().equals(name) || TreeMapColumnPropertyType_labelingShrinkTextToFitShape_getInstance().equals(name) || TreeMapColumnPropertyType_labelingResizeTextToFitShape_getInstance().equals(name) || TreeMapColumnPropertyType_labelingFloat_getInstance().equals(name) || TreeMapColumnPropertyType_tooltipFont_getInstance().equals(name) || TreeMapColumnPropertyType_tooltipForeground_getInstance().equals(name) || TreeMapColumnPropertyType_borderColor_getInstance().equals(name) || TreeMapColumnPropertyType_showLabel_getInstance().equals(name)) {
      scheduleUpdate(this.w3k_1);
    } else if (TreeMapColumnPropertyType_aggregation_getInstance().equals(name)) {
      scheduleUpdateLayoutAndAggregationCache(this.w3k_1);
    } else if (TreeMapColumnPropertyType_labeling_getInstance().equals(name)) {
      scheduleUpdateLayoutAndDimension(this.w3k_1);
    } else if (TreeMapColumnPropertyType_algorithm_getInstance().equals(name) || TreeMapColumnPropertyType_scale_getInstance().equals(name) || TreeMapColumnPropertyType_labeling_getInstance().equals(name) || TreeMapColumnPropertyType_nesting_getInstance().equals(name) || TreeMapColumnPropertyType_nestingAmount_getInstance().equals(name) || TreeMapColumnPropertyType_ordering_getInstance().equals(name) || TreeMapColumnPropertyType_orderingDirection_getInstance().equals(name) || TreeMapColumnPropertyType_orderingHorizontalVanishingPoint_getInstance().equals(name) || TreeMapColumnPropertyType_orderingVerticalVanishingPoint_getInstance().equals(name) || TreeMapColumnPropertyType_headerFont_getInstance().equals(name) || TreeMapColumnPropertyType_format_getInstance().equals(name) || TreeMapColumnPropertyType_borderThickness_getInstance().equals(name) || TreeMapColumnPropertyType_headerFont_getInstance().equals(name) || TreeMapColumnPropertyType_headerRendering_getInstance().equals(name)) {
      scheduleUpdateLayout(this.w3k_1);
    } else if (TreeMapColumnPropertyType_colormap_getInstance().equals(name)) {
      scheduleUpdateColors(this.w3k_1);
    } else {
      scheduleUpdate(this.w3k_1);
    }
  }
  ey(name, event) {
    return this.x3k(name instanceof TreeMapColumnPropertyType ? name : THROW_CCE(), event);
  }
}
class DefaultTreeMapSettings$propertyChangeListener$1 {
  constructor(this$0) {
    this.y3k_1 = this$0;
  }
  h34(name, event) {
    if (TreeMapPropertyType_depth_getInstance().equals(name) || TreeMapPropertyType_rendering_getInstance().equals(name) || TreeMapPropertyType_background_getInstance().equals(name) || TreeMapPropertyType_tooltipBackground_getInstance().equals(name)) {
      scheduleUpdate(this.y3k_1);
    } else if (TreeMapPropertyType_dimension_getInstance().equals(name) || TreeMapPropertyType_sizeField_getInstance().equals(name) || TreeMapPropertyType_heightField_getInstance().equals(name) || TreeMapPropertyType_backgroundField_getInstance().equals(name) || TreeMapPropertyType_labelsField_getInstance().equals(name) || TreeMapPropertyType_hideFilterResults_getInstance().equals(name) || TreeMapPropertyType_hideSearchResults_getInstance().equals(name)) {
      scheduleUpdateLayout(this.y3k_1);
    } else if (TreeMapPropertyType_colorField_getInstance().equals(name) || TreeMapPropertyType_lightSourceHeight_getInstance().equals(name) || TreeMapPropertyType_lightSourceAmbient_getInstance().equals(name) || TreeMapPropertyType_lightSourceX_getInstance().equals(name) || TreeMapPropertyType_lightSourceY_getInstance().equals(name) || TreeMapPropertyType_lightSourceZ_getInstance().equals(name)) {
      scheduleUpdateColors(this.y3k_1);
    } else if (TreeMapPropertyType_groupByField_getInstance().equals(name)) {
      scheduleUpdateGroupBy(this.y3k_1);
    } else {
      scheduleUpdate(this.y3k_1);
    }
  }
  ey(name, event) {
    return this.h34(name instanceof TreeMapPropertyType ? name : THROW_CCE(), event);
  }
}
class DefaultTreeMapSettings extends AbstractTreeMapSettings {
  constructor(model, colorFactory, fontFactory, colorMapFactory) {
    super();
    this.v3j_1 = new EnumProperties(values_3());
    this.w3j_1 = this.v3j_1.bz(TreeMapPropertyType_dimensionFixed_getInstance(), false);
    this.x3j_1 = this.v3j_1.bz(TreeMapPropertyType_dimension_getInstance(), null);
    this.y3j_1 = this.v3j_1.bz(TreeMapPropertyType_progressive_getInstance(), null);
    this.groupByFields = this.v3j_1.bz(TreeMapPropertyType_groupByField_getInstance(), emptyList());
    this.z3j_1 = PropertyDelegates_instance.k10(this.groupByFields);
    this.labelsFields = this.v3j_1.bz(TreeMapPropertyType_labelsField_getInstance(), emptyList());
    this.a3k_1 = PropertyDelegates_instance.k10(this.labelsFields);
    this.toolTipFields = this.v3j_1.bz(TreeMapPropertyType_toolTipField_getInstance(), emptyList());
    this.b3k_1 = PropertyDelegates_instance.k10(this.toolTipFields);
    this.sizeField = this.v3j_1.bz(TreeMapPropertyType_sizeField_getInstance(), null);
    this.c3k_1 = PropertyDelegates_instance.k10(this.sizeField);
    this.d3k_1 = this.v3j_1.bz(TreeMapPropertyType_colorField_getInstance(), null);
    this.e3k_1 = PropertyDelegates_instance.k10(this.d3k_1);
    this.backgroundField = this.v3j_1.bz(TreeMapPropertyType_backgroundField_getInstance(), null);
    this.f3k_1 = PropertyDelegates_instance.k10(this.backgroundField);
    this.heightField = this.v3j_1.bz(TreeMapPropertyType_heightField_getInstance(), null);
    this.g3k_1 = PropertyDelegates_instance.k10(this.heightField);
    this._depth = this.v3j_1.bz(TreeMapPropertyType_depth_getInstance(), null);
    this._rendering = this.v3j_1.bz(TreeMapPropertyType_rendering_getInstance(), null);
    this.h3k_1 = PropertyDelegates_instance.k10(this._rendering);
    this.groupByVariables = PropertySelection.i14(this.groupByFields);
    this.sizeVariable = PropertySingleSelection.s14(this.sizeField);
    this.colorVariable = PropertySingleSelection.s14(this.d3k_1);
    this.labelVariable = PropertySelection.i14(this.labelsFields);
    this.toolTipVariable = PropertySelection.i14(this.toolTipFields);
    this.backgroundVariable = PropertySingleSelection.s14(this.backgroundField);
    this.heightVariable = PropertySingleSelection.s14(this.heightField);
    this.progressive = PropertySingleSelection.s14(this.y3j_1);
    this.depth = PropertySingleSelection.s14(this._depth);
    this.i3k_1 = PropertySingleSelection.s14(this._rendering);
    this.j3k_1 = SimpleBoundedInterval.qp(0.03, 0.0, 0.5);
    this.maximumHeight = this.v3j_1.cz(TreeMapPropertyType_maximumHeight_getInstance(), this.j3k_1.xm());
    this.k3k_1 = SimpleBoundedInterval.qp(0.25, 0.0, 2.0);
    this.lightSourceHeight = this.v3j_1.cz(TreeMapPropertyType_lightSourceHeight_getInstance(), this.k3k_1.xm());
    this.l3k_1 = SimpleBoundedInterval.qp(0.5, 0.0, 1.0);
    this.lightSourceAmbient = this.v3j_1.cz(TreeMapPropertyType_lightSourceAmbient_getInstance(), this.l3k_1.xm());
    this.m3k_1 = SimpleBoundedInterval.qp(-1.0, -4.0, 4.0);
    this.lightSourceX = this.v3j_1.cz(TreeMapPropertyType_lightSourceX_getInstance(), this.m3k_1.xm());
    this.n3k_1 = SimpleBoundedInterval.qp(-1.0, -4.0, 4.0);
    this.lightSourceY = this.v3j_1.cz(TreeMapPropertyType_lightSourceY_getInstance(), this.n3k_1.xm());
    this.o3k_1 = SimpleBoundedInterval.qp(10.0, 0.0, 100.0);
    this.lightSourceZ = this.v3j_1.cz(TreeMapPropertyType_lightSourceZ_getInstance(), this.o3k_1.xm());
    this.hideSearchResults = this.v3j_1.bz(TreeMapPropertyType_hideSearchResults_getInstance(), null);
    this.hideFilterResults = this.v3j_1.bz(TreeMapPropertyType_hideFilterResults_getInstance(), null);
    this.q3k_1 = HashMap.i7();
    var tmp = this;
    tmp.u3k_1 = new DefaultTreeMapSettings$columnPropertyChangeListener$1(this);
    var tmp_0 = this;
    tmp_0.v3k_1 = new DefaultTreeMapSettings$propertyChangeListener$1(this);
    this._model = model;
    this.r3k_1 = colorFactory;
    this.s3k_1 = fontFactory;
    this.t3k_1 = colorMapFactory;
    this._background = this.v3j_1.bz(TreeMapPropertyType_background_getInstance(), null);
    this._tooltipBackground = this.v3j_1.bz(TreeMapPropertyType_tooltipBackground_getInstance(), colorOf_0(_UByte___init__impl__g9hnc4(-24), _UByte___init__impl__g9hnc4(-24), _UByte___init__impl__g9hnc4(-24), _UByte___init__impl__g9hnc4(-56)));
    this._probingColor = this.v3j_1.bz(TreeMapPropertyType_probingColor_getInstance(), colorOf_0(_UByte___init__impl__g9hnc4(0), _UByte___init__impl__g9hnc4(0), _UByte___init__impl__g9hnc4(0), _UByte___init__impl__g9hnc4(-16)));
    this._selectionColor = this.v3j_1.bz(TreeMapPropertyType_selectionColor_getInstance(), colorOf_4(_UByte___init__impl__g9hnc4(-1), _UByte___init__impl__g9hnc4(102), _UByte___init__impl__g9hnc4(0)));
    this.resetToDefaults();
    this.v3j_1.hy(this.v3k_1);
    this.p3k_1 = this.createDefaultTreeMapColumnSettings();
    this.p3k_1.properties.hy(this.u3k_1);
  }
  p1z() {
    return this.v3j_1;
  }
  z3k() {
    return this._model;
  }
  a3l(_set____db54di) {
    this.groupByFields = _set____db54di;
  }
  b3l() {
    return this.groupByFields;
  }
  y2x(_set____db54di) {
    var tmp = KMutableProperty1;
    var tmp_0 = DefaultTreeMapSettings$_get_groupByColumns_$ref_g2pwnd_0();
    return this.z3j_1.ef(this, getPropertyCallableRef('groupByColumns'