plugins {
    kotlin("multiplatform")
}

kotlin {
    js(IR) {
        compilerOptions {
            freeCompilerArgs.add("-Xes-long-as-bigint")
//            target.set("es2015")
        }
        browser()
        binaries.executable()
    }

    sourceSets {
        val jsMain by getting {
            dependencies {
                val coroutinesVersion: String by project
                implementation("org.jetbrains.kotlinx:kotlinx-coroutines-core:$coroutinesVersion")

                val localDependencies: String? by project
                val kotlinWrappersVersion: String by project
//    if (localDependencies == null || !localDependencies.toBoolean()) {
                implementation(project.dependencies.platform("org.jetbrains.kotlin-wrappers:kotlin-wrappers-bom:${kotlinWrappersVersion}"))
                implementation("org.jetbrains.kotlin-wrappers:kotlin-react")
                implementation("org.jetbrains.kotlin-wrappers:kotlin-react-dom")
//    }
//    implementation(npm("react", "18.3.1"))
//    implementation(npm("react-dom", "18.3.1"))

                if(localDependencies != null && localDependencies.toBoolean()) {
                    implementation(project(":macrofocus-common"))
                    implementation(project(":mkui"))
                    implementation(project(":molap"))
                    implementation(project(":treemap"))
                } else {
                    val macrofocusVersion: String by project
                    implementation("org.macrofocus:macrofocus-common:$macrofocusVersion")
                    implementation("org.molap:molap:$macrofocusVersion")
                    implementation("org.mkui:mkui:$macrofocusVersion")
                    implementation("com.treemap:treemap:$macrofocusVersion")
                }
            }
        }
    }
}

repositories {
    maven { url = uri("https://archiva.macrofocus.com/repository/public/") }
    maven { url = uri("https://archiva.macrofocus.com/repository/snapshots/") }
    mavenCentral()
    // Kotlin JS
    maven { url = uri("https://maven.pkg.jetbrains.space/kotlin/p/kotlin/kotlin-js-wrappers") }
    maven { url = uri("https://maven.pkg.jetbrains.space/public/p/kotlinx-html/maven/") }
}

tasks.register<Zip>("distZip") {
    archiveFileName.set("treemap-kotlin-react.zip")
    destinationDirectory.set(layout.buildDirectory.dir("distributions"))

    from(".") {
//        include("src/**")
        exclude(".gradle/**")
        exclude("build/**")
        exclude("yarn.lock")
    }
}