import com.treemap.DefaultTreeMapModel
import com.treemap.RenderingFactory
import com.treemap.TreeMapComponent
import kotlinx.browser.window
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.await
import kotlinx.coroutines.launch
import org.mkui.font.MkFont
import org.mkui.labeling.EnhancedLabel
import org.mkui.palette.PaletteFactory
import org.molap.dataframe.DataFrame
import org.molap.json.readJson
import react.*
import react.dom.client.createRoot
import web.dom.ElementId
import web.dom.document

private val demo = FC<Props> {
    val (model, setModel) = useState<DefaultTreeMapModel<Int, String>?>(null)

    useEffectOnce {
        GlobalScope.launch {
//            TreeMap.setLicenseKey("My Company", "ABC12-ABC12-ABC12-ABC12-ABC12-ABC12")

            val json = window.fetch("https://public.treemap.com/rest/json/Forbes%20Global%202000%20-%202021.mtm").await().text().await()
            val dataFrame = DataFrame.readJson(json)
            val treeMapModel = DefaultTreeMapModel<Int, String>(dataFrame)

            val settings = treeMapModel.settings

            // General
            settings.rendering = RenderingFactory.FLAT

            // Group by
            settings.groupByColumns = listOf("Sector", "Industry")

            // Size
            settings.sizeColumn = "Market Value"

            // Color
            settings.colorColumn = "Profits"
            val profitsSettings = settings.getColumnSettings("Profits")
            val negpos = PaletteFactory.instance["negpos"]!!.getPalette()
            val colorMap = treeMapModel.getColorMap("Profits")
            colorMap!!.palette = negpos
            colorMap.interval!!.setValue(-63.93, 127.86)

            // Label
            val companySettings = settings.getColumnSettings("Company")
            companySettings.setLabelingFont(MkFont("Helvetica", 9.0)) // 9 points is the minimum size that will be displayed
            companySettings.setLabelingMinimumCharactersToDisplay(5)
            companySettings.setLabelingResizeTextToFitShape(true)
            companySettings.setLabelingVerticalAlignment(EnhancedLabel.CENTER)
            companySettings.setLabelingHorizontalAlignment(EnhancedLabel.CENTER)

            setModel(treeMapModel)
        }
    }

    TreeMapComponent {
        this.model = model
    }
}

fun main() {
    println("TreeMap starting up")

    window.onload = {
        createRoot(document.getElementById(ElementId("root"))!!).render(demo.create())
    }
}